/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.doubleArrayContainer;
import hec.lang.annotation.Scriptable;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.TSLocation;
import hec.rss.model.DayOfWeekMultiplier;
import hec.rss.model.ElementOp;
import hec.rss.model.HindcastData;
import hec.rss.model.HotstartState;
import hec.rss.model.OpController;
import hec.rss.model.OpControllerHotstartState;
import hec.rss.model.OpValue;
import hec.rss.model.OperationsElement;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.TimeOfDayMultiplier;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;

public class OpRule
extends RssTSLocationObject
implements AltInputReportInfc {
    OpController _controller;
    protected DayOfWeekMultiplier _multiplier = null;
    protected TimeOfDayMultiplier _timeOfDayMultiplier = null;
    protected boolean _useDayOfWeekMultiplier = false;
    protected boolean _useTimeOfDayMultiplier = false;
    protected boolean _usePeriodAverageLimit = false;
    protected boolean _enableRiseFallCond = false;
    protected int _riseFallCondition = 0;
    protected int _avgPeriod = Integer.MIN_VALUE;
    protected double _riseFallTolerance = Double.NEGATIVE_INFINITY;
    protected int _parameterType = 0;
    protected transient RssSystem g;
    transient doubleArrayContainer h;
    private transient doubleArrayContainer a;
    private transient boolean b = false;
    private transient double c = 1.0;
    public static final int NONE = 0;
    public static final int RISING = 1;
    public static final int RISING_OR_CONST = 2;
    public static final int FALLING_OR_CONST = 3;
    public static final int FALLING = 4;
    public static final int POOL_ELEVATION = 1;
    public static final int INFLOW = 2;
    @Scriptable
    public static final int RULETYPE_DEMAND = 3;
    @Scriptable
    public static final int RULETYPE_MAX = 2;
    @Scriptable
    public static final int RULETYPE_SPEC = 1;
    @Scriptable
    public static final int RULETYPE_MIN = 0;
    public static final int RULETYPE_FREE = -1;

    public OpRule() {
    }

    public OpRule(String string) {
        super(string);
    }

    public OpRule(OpController opController, String string) {
        super(string);
        this._controller = opController;
    }

    public double computeStepLimit(RunTimeStep runTimeStep) {
        this.evaluateLimits(runTimeStep, 0);
        return this.h.array[runTimeStep.step];
    }

    public void setPriority(RunTimeStep runTimeStep, double d) {
        if (this.a != null) {
            this.a.array[runTimeStep.step] = d;
        }
    }

    public double getPriority(RunTimeStep runTimeStep) {
        double d = -1.0;
        if (this.a != null) {
            d = this.a.array[runTimeStep.step];
        }
        return d;
    }

    public TSRecordProxy getTargetTSRecordProxy() {
        return null;
    }

    public void updateByDemandScale(double d) {
    }

    public void setUseDemandScale(boolean bl) {
        this.b = bl;
    }

    public boolean useDemandScale() {
        return this.b;
    }

    public void setDemandScale(double d) {
        this.c = d;
    }

    public double getDemandScale() {
        return this.c;
    }

    public void getElementDependencies(List list) {
    }

    public OpValue getOpValue(RunTimeStep runTimeStep) {
        return null;
    }

    public OpValue getPowerOpValue(RunTimeStep runTimeStep) {
        return null;
    }

    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
    }

    public void evaulatePerformance(RunTimeWindow runTimeWindow) {
    }

    public int getRuleLimitType() {
        return -1;
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if (n == 0) {
            int n2 = this.getRuleLimitType();
            TSRecordProxy tSRecordProxy = null;
            if (n == 0) {
                if (n2 == 0) {
                    tSRecordProxy = this.getTSRecordProxy(82);
                } else if (n2 == 2) {
                    tSRecordProxy = this.getTSRecordProxy(81);
                } else if (n2 == 1) {
                    tSRecordProxy = this.getTSRecordProxy(80);
                }
            }
            if (tSRecordProxy != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(202)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        TSRecordProxy tSRecordProxy;
        TSRecordProxy tSRecordProxy2;
        Object object = this.getTSProxyName();
        int n = this.getRuleLimitType();
        if (n == 0) {
            TSRecordProxy tSRecordProxy3 = this.getTSRecordProxy((String)object, 82);
            if (tSRecordProxy3 == null) {
                this.addTSRecordProxy((String)object, 82);
            }
        } else if (n == 2) {
            TSRecordProxy tSRecordProxy4 = this.getTSRecordProxy((String)object, 81);
            if (tSRecordProxy4 == null) {
                this.addTSRecordProxy((String)object, 81);
            }
        } else if (n == 1 && (tSRecordProxy2 = this.getTSRecordProxy((String)object, 80)) == null) {
            this.addTSRecordProxy((String)object, 80);
        }
        if ((tSRecordProxy = this.getTSRecordProxy((String)(object = (String)object + "-P"), 202)) == null) {
            this.addTSRecordProxy((String)object, 202);
        }
    }

    public String getTSProxyName() {
        Object object = this._controller != null ? ((RssTSLocationObject)this).getSystem().getNameForKeyString(this._controller.getName()) + "-" + this.getName() : this.getName();
        return object;
    }

    public void getReferencedStateVariables(List list) {
    }

    public Vector getRequiredTSRecordProxies(Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        return vector;
    }

    public void saveFunctionState(int n) {
    }

    public void restoreFunctionState(int n) {
    }

    @Scriptable
    public OperationsElement getOperationsElement() {
        ElementOp elementOp;
        OperationsElement operationsElement = null;
        if (this._controller != null && (elementOp = this._controller.getElementOp()) != null) {
            operationsElement = elementOp.getOperationsElement();
        }
        return operationsElement;
    }

    @Scriptable
    public OperationsElement getReservoirElement() {
        return this.getOperationsElement();
    }

    @Scriptable
    public boolean isActive(RunTimeStep runTimeStep) {
        if (this._controller == null) {
            return false;
        }
        return this._controller.getElementOp().isRuleActive(this, runTimeStep);
    }

    public void setSystem(RssSystem rssSystem) {
        this.g = rssSystem;
    }

    @Override
    @Scriptable
    public RssSystem getSystem() {
        if (this.g != null) {
            return this.g;
        }
        if (this._controller == null) {
            return null;
        }
        this.g = ((RssTSLocationObject)this._controller).getSystem();
        return this.g;
    }

    @Scriptable
    public RssSystem getNetwork() {
        return ((RssTSLocationObject)this).getSystem();
    }

    public void applyHindcastData(HindcastData hindcastData) {
    }

    @Scriptable
    public String toString() {
        return this.getName();
    }

    public void resetChildOwnership() {
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(i);
            tSRecordProxy.setParent((TSLocation)this);
        }
    }

    @Scriptable
    public int getGmtOffset() {
        if (this._controller != null) {
            return this._controller.getGmtOffset();
        }
        if (this.g != null) {
            return this.g.getGmtOffset();
        }
        throw new Error("GMT Offset not found for OpRule " + this.getName());
    }

    @Scriptable
    public int getUnitSystem() {
        if (this._controller != null) {
            return this._controller.getUnitSystem();
        }
        if (this.g != null) {
            return this.g.getUnitSystem();
        }
        throw new Error("Unit System not found for OpRule " + this.getName());
    }

    @Override
    public synchronized Object clone() {
        OpRule opRule = (OpRule)super.clone();
        ((OpRule)super.clone())._controller = this._controller;
        if (this._multiplier != null) {
            try {
                opRule._multiplier = (DayOfWeekMultiplier)this._multiplier.clone();
            }
            catch (Exception exception) {}
        }
        return opRule;
    }

    public boolean initializeCompute() {
        int n;
        for (n = 0; n < this._tsrecordVector.size(); ++n) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(n);
            if (tSRecordProxy == null) continue;
            tSRecordProxy.initialize();
        }
        this.h = null;
        n = this.getRuleLimitType();
        if (n != -1) {
            if (n == 0) {
                this.h = this.getTSContainer(82);
            } else if (n == 2) {
                this.h = this.getTSContainer(81);
            } else if (n == 1) {
                this.h = this.getTSContainer(80);
            } else {
                this.g.printErrorMessage("OpRule.initializeCompute: Failed to find Limit Type for rule - " + this.getName());
                return false;
            }
            if (this.h == null && this.g != null) {
                this.g.printErrorMessage("OpRule.initializeCompute: Failed to find rule time series array for " + this.getName());
                return false;
            }
        }
        this.a = null;
        this.a = this.getTSContainer(202);
        return true;
    }

    public boolean initForPostProcessing() {
        return true;
    }

    public int initOperationStep(RunTimeStep runTimeStep, int n) {
        return 0;
    }

    public OpValue evaluateRule(RunTimeStep runTimeStep, double d, int n, boolean bl) {
        return this.evaluateRule(runTimeStep, d, n);
    }

    public OpValue evaluateRule(RunTimeStep runTimeStep, double d, int n) {
        return this.evaluateRule(runTimeStep, d);
    }

    public OpValue evaluateRule(RunTimeStep runTimeStep, double d) {
        this._controller.getElementOp().printMessage("OpRule.evaluateRule: Warning - method not implemented in Class " + this.getClass().getName());
        return null;
    }

    public void setController(OpController opController) {
        this._controller = opController;
    }

    @Scriptable
    public OpController getController() {
        return this._controller;
    }

    public boolean isLocalRule() {
        return true;
    }

    public boolean isDnstrmRule() {
        return false;
    }

    public boolean isPerAvgRule() {
        return false;
    }

    public String getKeyStringForObject(Object object) {
        return this.getController().getKeyStringForObject(object);
    }

    public Object getObjectForKeyString(String string) {
        return this.getController().getObjectForKeyString(string);
    }

    @Scriptable
    public RssSystem getRssSystem() {
        if (this._controller == null) {
            return null;
        }
        ElementOp elementOp = this._controller.getElementOp();
        if (elementOp == null || elementOp.getOperationsElement() == null) {
            return null;
        }
        return elementOp.getOperationsElement().getSystem();
    }

    public boolean checkRisingFallingCondition(RunTimeStep runTimeStep) {
        if (!this._enableRiseFallCond || this._riseFallCondition == 0 || this._parameterType == 0) {
            return true;
        }
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        RunTimeStep runTimeStep3 = new RunTimeStep(runTimeStep);
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = runTimeStep.step;
        if (this._parameterType == 1) {
            if (--n < 0) {
                n = 0;
            }
            runTimeStep3.setStep(n);
        }
        int n2 = runTimeStep.getTimeStepSeconds();
        int n3 = 1;
        if (n2 > 1 && this._avgPeriod > 0) {
            n3 = this._avgPeriod / n2;
        }
        n2 = n - n3;
        double d3 = this._riseFallTolerance;
        if (n2 < 0) {
            n2 = 0;
            d3 *= (double)n / (double)n3;
        }
        runTimeStep2.setStep(n2);
        if (this._parameterType == 1) {
            d = this._controller.getElementOp().getOperationsElement().getStorageFunction().getElevation(runTimeStep3);
            d2 = this._controller.getElementOp().getOperationsElement().getStorageFunction().getElevation(runTimeStep2);
        } else if (this._parameterType == 2) {
            d = this._controller.getElementOp().getOperationsElement().getStorageFunction().getNetInflow(runTimeStep3);
            d2 = this._controller.getElementOp().getOperationsElement().getStorageFunction().getNetInflow(runTimeStep2);
        }
        if (d == Double.NEGATIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
            this._controller.getElementOp().getOperationsElement().getSystem().printErrorMessage("OpRule.checkRisingFallingCondition: Failed to load time series arrays");
            return false;
        }
        n2 = 0;
        if (this._riseFallCondition == 1) {
            if (d - d2 > d3) {
                n2 = 1;
            }
        } else if (this._riseFallCondition == 2) {
            if (d - d2 > -d3) {
                n2 = 1;
            }
        } else if (this._riseFallCondition == 3) {
            if (d - d2 < d3) {
                n2 = 1;
            }
        } else if (this._riseFallCondition == 4 && d - d2 < -d3) {
            n2 = 1;
        }
        return n2 != 0;
    }

    public boolean riseFallConditionIsValid() {
        return this._riseFallCondition != 0 && this._avgPeriod != Integer.MIN_VALUE && this._parameterType != 0;
    }

    public void setEnableRiseFallCondition(boolean bl) {
        this._enableRiseFallCond = bl;
    }

    public boolean getEnableRiseFallCondition() {
        return this._enableRiseFallCond;
    }

    public void setRiseFallCondition(int n) {
        this._riseFallCondition = n;
    }

    public int getRiseFallCondition() {
        return this._riseFallCondition;
    }

    public void setAveragingPeriod(int n) {
        this._avgPeriod = n;
    }

    public int getAveragingPeriod() {
        return this._avgPeriod;
    }

    public void setRiseFallTolerance(double d) {
        this._riseFallTolerance = d;
    }

    public double getRiseFallTolerance() {
        return this._riseFallTolerance;
    }

    public void setParameterType(int n) {
        this._parameterType = n;
    }

    public int getParameterType() {
        return this._parameterType;
    }

    public boolean useDayOfWeekMultiplier() {
        if (!this._useDayOfWeekMultiplier) {
            return false;
        }
        if (this._multiplier == null || this._multiplier.isDefaults()) {
            this._useDayOfWeekMultiplier = false;
        }
        return this._useDayOfWeekMultiplier;
    }

    public void setUseDayOfWeekMultiplier(boolean bl) {
        this._useDayOfWeekMultiplier = bl;
    }

    public void setPeriodAverageLimit(boolean bl) {
        this._usePeriodAverageLimit = bl;
    }

    public DayOfWeekMultiplier getMultiplier() {
        return this._multiplier;
    }

    public void setMultiplier(DayOfWeekMultiplier dayOfWeekMultiplier) {
        this._multiplier = dayOfWeekMultiplier;
    }

    public double getDayOfWeekFactor(RunTimeStep runTimeStep) {
        if (!this.useDayOfWeekMultiplier()) {
            return 1.0;
        }
        return this._multiplier.getMultiplier(runTimeStep);
    }

    public double getLargestDayOfWeekFactor() {
        if (!this.useDayOfWeekMultiplier()) {
            return 1.0;
        }
        return this._multiplier.getLargestMultiplier();
    }

    public boolean useTimeOfDayMultiplier() {
        if (this._timeOfDayMultiplier == null) {
            this._useTimeOfDayMultiplier = false;
        }
        return this._useTimeOfDayMultiplier;
    }

    public boolean usePeriodAverageLimit() {
        return this._usePeriodAverageLimit;
    }

    public void setUseTimeOfDayMultiplier(boolean bl) {
        this._useTimeOfDayMultiplier = bl;
    }

    public void setUsePeriodAverageLimit(boolean bl) {
        this._usePeriodAverageLimit = bl;
    }

    public TimeOfDayMultiplier getTimeOfDayMultiplier() {
        return this._timeOfDayMultiplier;
    }

    public void setTimeOfDayMultiplier(TimeOfDayMultiplier timeOfDayMultiplier) {
        this._timeOfDayMultiplier = timeOfDayMultiplier;
    }

    public double getTimeOfDayFactor(RunTimeStep runTimeStep) {
        if (this._timeOfDayMultiplier == null || !this._useTimeOfDayMultiplier) {
            return 1.0;
        }
        int n = runTimeStep.getHecTime().hour();
        int n2 = runTimeStep.getHecTime().minute();
        if (n2 > 0) {
            ++n;
        }
        if ((n %= 24) == 0) {
            n = 24;
        }
        return this._timeOfDayMultiplier.getHourlyMultiplier(n);
    }

    public double getLargestTimeOfDayFactor() {
        if (this._timeOfDayMultiplier == null || !this._useTimeOfDayMultiplier) {
            return 1.0;
        }
        return this._timeOfDayMultiplier.getLargestHourlyMultiplier();
    }

    public void saveHotstartState(HotstartState hotstartState, int n) {
    }

    public void restoreHotstartState(OpControllerHotstartState opControllerHotstartState) {
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        Element element2;
        if (this._useDayOfWeekMultiplier) {
            element2 = new Element("DayOfWeekMultiplier");
            element.addContent((Content)element2);
            this.getMultiplier().outputReport(alternativeInputReport, element2);
        }
        if (this._useTimeOfDayMultiplier) {
            element2 = new Element("TimeOfDayMultiplier");
            element.addContent((Content)element2);
            this.getTimeOfDayMultiplier().outputReport(alternativeInputReport, element2);
        }
        if (this._enableRiseFallCond) {
            element2 = new Element("RisingFallingConditions");
            element.addContent((Content)element2);
            element2.setAttribute("Condition", Integer.toString(this.getRiseFallCondition()));
            element2.setAttribute("ParameterType", Integer.toString(this.getParameterType()));
            element2.setAttribute("AveragingPeriod", Integer.toString(this.getAveragingPeriod()));
            element2.setAttribute("Tolerance", Double.toString(this.getRiseFallTolerance()));
        }
    }

    boolean isPowerRule() {
        return false;
    }
}

