/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.rss.model.DiversionDemandOpRule;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.ElevReleaseOpRule;
import hec.rss.model.FirmEnergyOpRule;
import hec.rss.model.FlowLimitOpRule;
import hec.rss.model.InducedSurchargeOpRule;
import hec.rss.model.InputTSBasedOpRule;
import hec.rss.model.OpRule;
import hec.rss.model.PeakingPowerTsOpRule;
import hec.rss.model.PowerGuideCurveOpRule;
import hec.rss.model.PrescribedOpRule;
import hec.rss.model.PumpOpRule;
import hec.rss.model.RateChangeElevLimitOpRule;
import hec.rss.model.RateChangeLimitOpRule;
import hec.rss.model.ReRegRule;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReleaseFunctionInflowOpRule;
import hec.rss.model.ScriptOpRule;
import hec.rss.model.SpecFlowOpRule;
import hec.rss.model.SystemHydropowerOpRule;
import hec.rss.model.SystemHydropowerRule;
import hec.rss.model.TandemOpRule;
import hec.rss.model.TandemSysOpRule;
import hec.rss.model.VariableTSBasedOpRule;
import hec.rss.model.WaterQualityOpRule;

public class OpRuleFactory {
    public static final String RULESTR_FLOWLIMIT = "Flow Limit";
    public static final String RULESTR_MIN = "Minimum Flow";
    public static final String RULESTR_MAX = "Maximum Flow";
    public static final String RULESTR_MIN_DNST = "Minimum Downstream Flow";
    public static final String RULESTR_MAX_DNST = "Maximum Downstream Flow";
    public static final String RULESTR_SPEC = "Specified Flow";
    public static final String RULESTR_ELEVRELEASE = "Elevation Release";
    public static final String RULESTR_RELEASE_FUNC_INFOW = "Release as Function of Inflow";
    public static final String RULESTR_CHANGELIMIT = "Flow Rate of Change Limit";
    public static final String RULESTR_ELEVCHANGELIMIT = "Elev Rate of Change Limit";
    public static final String RULESTR_INDUCEDSURCHARGE = "Induced Surcharge";
    public static final String RULESTR_TSPARAMBASED = "TS Parameter Based Release Rule";
    public static final String RULESTR_VARTSBASED = "Release as a Function of Variable";
    public static final String RULESTR_TANDEMOP = "Tandem Operation";
    public static final String RULESTR_TANDEMSYSOP = "Tandem System Operation";
    public static final String RULESTR_POWERGUIDECURVE = "Hydropower - Power Guide Curve";
    public static final String RULESTR_FIRMENERGY = "Hydropower - Schedule";
    public static final String RULESTR_POWERSYSTEMSCHED = "Hydropower - System Schedule";
    public static final String RULESTR_PEAKINGPOWERTS = "Hydropower - Time Series Requirement";
    public static final String RULESTR_RELEASEFUNC = "Release Function";
    public static final String RULESTR_REREG = "Re-Reg Operation";
    public static final String RULESTR_DOWNSTREAMCNTRL = "Downstream Control Function";
    public static final String RULESTR_WATERQUALITY = "Water Quality Rule";
    public static final String RULESTR_PUMPOPERATION = "Pump Schedule";
    public static final String RULESTR_SCRIPT = "Script";
    public static final String RULESTR_PRESCRIBEDREL = "Prescribed Release";
    public static final String RULESTR_DIVERSION_DEMAND = "Flow Function";
    public static final String RULESTR_DIVERSIONLIMIT = "Diversion Limit";
    public static final String[] RULESTRARRAY = new String[]{"Flow Limit", "Specified Flow", "Elevation Release", "Release as Function of Inflow", "Flow Rate of Change Limit", "Elev Rate of Change Limit", "Induced Surcharge", "TS Parameter Based Release Rule", "Release as a Function of Variable", "Tandem Operation", "Hydropower - Power Guide Curve", "Hydropower - Schedule", "Hydropower - System Schedule", "Hydropower - Time Series Requirement", "Release Function", "Downstream Control Function", "Pump Schedule", "Script", "Tandem System Operation", "Prescribed Release", "Re-Reg Operation", "Flow Function", "Diversion Limit", "Water Quality Rule"};

    public static final OpRule newRule(String string, String string2, int n) {
        if (string == null || string2 == null) {
            return null;
        }
        OpRule opRule = null;
        if (string.equals(RULESTR_FLOWLIMIT)) {
            opRule = new FlowLimitOpRule(string2);
            opRule.setLimitType(-1);
        } else if (string.equals(RULESTR_MIN)) {
            opRule = new FlowLimitOpRule(string2);
            opRule.setLimitType(-1);
        } else if (string.equals(RULESTR_MAX)) {
            opRule = new FlowLimitOpRule(string2);
            opRule.setLimitType(1);
        } else if (string.equals(RULESTR_MIN_DNST)) {
            opRule = new FlowLimitOpRule(string2);
            opRule.setLimitType(-1);
        } else if (string.equals(RULESTR_MAX_DNST)) {
            opRule = new FlowLimitOpRule(string2);
            opRule.setLimitType(-1);
        } else if (string.equals(RULESTR_SPEC)) {
            opRule = new SpecFlowOpRule(string2);
        } else if (string.equals(RULESTR_ELEVRELEASE)) {
            opRule = new ElevReleaseOpRule(string2);
        } else if (string.equals(RULESTR_RELEASE_FUNC_INFOW)) {
            opRule = new ReleaseFunctionInflowOpRule(string2);
        } else if (string.equals(RULESTR_CHANGELIMIT)) {
            opRule = new RateChangeLimitOpRule(string2);
        } else if (string.equals(RULESTR_ELEVCHANGELIMIT)) {
            opRule = new RateChangeElevLimitOpRule(string2);
        } else if (string.equals(RULESTR_INDUCEDSURCHARGE)) {
            opRule = new InducedSurchargeOpRule(string2);
        } else if (string.equals(RULESTR_TSPARAMBASED)) {
            opRule = new InputTSBasedOpRule(string2);
        } else if (string.equals(RULESTR_VARTSBASED)) {
            opRule = new VariableTSBasedOpRule(string2);
        } else if (string.equals(RULESTR_POWERGUIDECURVE)) {
            opRule = new PowerGuideCurveOpRule(string2);
        } else if (string.equals(RULESTR_FIRMENERGY)) {
            opRule = new FirmEnergyOpRule(string2);
        } else if (string.equals(RULESTR_PEAKINGPOWERTS)) {
            opRule = new PeakingPowerTsOpRule(string2);
        } else if (string.equals(RULESTR_RELEASEFUNC) || RULESTR_DIVERSIONLIMIT.equals(string)) {
            opRule = new ReleaseFuncOpRule(string2);
        } else if (string.equals(RULESTR_REREG)) {
            opRule = new ReRegRule(string2);
        } else if (string.equals(RULESTR_DOWNSTREAMCNTRL)) {
            opRule = new DownstreamCntrlOpRule(string2, n);
        } else if (string.equals(RULESTR_TANDEMOP)) {
            opRule = new TandemOpRule(string2);
        } else if (string.equals(RULESTR_TANDEMSYSOP)) {
            opRule = new TandemSysOpRule(string2);
        } else if (string.equals(RULESTR_POWERSYSTEMSCHED)) {
            opRule = new SystemHydropowerOpRule(string2);
        } else if (string.equals(RULESTR_PUMPOPERATION)) {
            opRule = new PumpOpRule(string2);
        } else if (string.equals(RULESTR_SCRIPT)) {
            opRule = new ScriptOpRule(string2);
        } else if (string.equals(RULESTR_PRESCRIBEDREL)) {
            opRule = new PrescribedOpRule(string2);
        } else if (RULESTR_DIVERSION_DEMAND.equals(string)) {
            opRule = new DiversionDemandOpRule(string2);
        } else if (RULESTR_WATERQUALITY.equals(string)) {
            opRule = new WaterQualityOpRule(string2);
            ((WaterQualityOpRule)opRule).setDownstreamControlLocationID(n);
        }
        return opRule;
    }

    public static final String getRuleString(OpRule opRule) {
        return OpRuleFactory.getRuleString(opRule, true);
    }

    public static final String getRuleString(OpRule opRule, boolean bl) {
        if (opRule instanceof FlowLimitOpRule) {
            return RULESTR_FLOWLIMIT;
        }
        if (opRule instanceof SpecFlowOpRule) {
            return RULESTR_SPEC;
        }
        if (opRule instanceof ElevReleaseOpRule) {
            return RULESTR_ELEVRELEASE;
        }
        if (opRule instanceof ReleaseFunctionInflowOpRule) {
            return RULESTR_RELEASE_FUNC_INFOW;
        }
        if (opRule instanceof RateChangeLimitOpRule) {
            return RULESTR_CHANGELIMIT;
        }
        if (opRule instanceof RateChangeElevLimitOpRule) {
            return RULESTR_ELEVCHANGELIMIT;
        }
        if (opRule instanceof InducedSurchargeOpRule) {
            return RULESTR_INDUCEDSURCHARGE;
        }
        if (opRule instanceof InputTSBasedOpRule) {
            return RULESTR_TSPARAMBASED;
        }
        if (opRule instanceof VariableTSBasedOpRule) {
            return RULESTR_VARTSBASED;
        }
        if (opRule instanceof PowerGuideCurveOpRule) {
            return RULESTR_POWERGUIDECURVE;
        }
        if (opRule instanceof FirmEnergyOpRule) {
            return RULESTR_FIRMENERGY;
        }
        if (opRule instanceof PeakingPowerTsOpRule) {
            return RULESTR_PEAKINGPOWERTS;
        }
        if (opRule instanceof DownstreamCntrlOpRule) {
            return RULESTR_DOWNSTREAMCNTRL;
        }
        if (opRule instanceof DownstreamOpRule) {
            return RULESTR_DOWNSTREAMCNTRL;
        }
        if (opRule instanceof WaterQualityOpRule) {
            return RULESTR_WATERQUALITY;
        }
        if (opRule instanceof ReleaseFuncOpRule) {
            if (bl) {
                return RULESTR_RELEASEFUNC;
            }
            return RULESTR_DIVERSIONLIMIT;
        }
        if (opRule instanceof ReRegRule) {
            return RULESTR_REREG;
        }
        if (opRule instanceof TandemOpRule) {
            return RULESTR_TANDEMOP;
        }
        if (opRule instanceof TandemSysOpRule) {
            return RULESTR_TANDEMSYSOP;
        }
        if (opRule instanceof SystemHydropowerOpRule) {
            return RULESTR_POWERSYSTEMSCHED;
        }
        if (opRule instanceof SystemHydropowerRule) {
            return RULESTR_POWERSYSTEMSCHED;
        }
        if (opRule instanceof ScriptOpRule) {
            return RULESTR_SCRIPT;
        }
        if (opRule instanceof PrescribedOpRule) {
            return RULESTR_PRESCRIBEDREL;
        }
        if (opRule instanceof PumpOpRule) {
            return RULESTR_PUMPOPERATION;
        }
        if (opRule instanceof DiversionDemandOpRule) {
            return RULESTR_DIVERSION_DEMAND;
        }
        if (opRule instanceof DiversionDemandOpRule) {
            return RULESTR_DIVERSION_DEMAND;
        }
        return "Unknown Rule Type";
    }
}

