/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.heclib.util.doubleArrayContainer;
import hec.heclib.util.intContainer;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainer;
import hec.lang.NamedType;
import hec.model.ConditionalBlock;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.SeasonalPairedValues;
import hec.model.TSLocation;
import hec.rss.model.CapacityOutage;
import hec.rss.model.CapacitySchedule;
import hec.rss.model.ConditionalBlockRef;
import hec.rss.model.CreditReservoirRef;
import hec.rss.model.DecisionSch;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOptions;
import hec.rss.model.Element;
import hec.rss.model.ElementOp;
import hec.rss.model.Function;
import hec.rss.model.IndependentVariable;
import hec.rss.model.InducedSurchargeOpRule;
import hec.rss.model.OpController;
import hec.rss.model.OpControllerZones;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.OpSet$DefaultDeprecatedReleaseAllocationObject;
import hec.rss.model.OpValue;
import hec.rss.model.OperationsElement;
import hec.rss.model.PeakingPowerTsOpRule;
import hec.rss.model.PowerGuideCurveOpRule;
import hec.rss.model.PumpOpRule;
import hec.rss.model.RateChangeLimitOpRule;
import hec.rss.model.ReleaseAllocation;
import hec.rss.model.ReleaseAllocationObject;
import hec.rss.model.ReleaseAllocationSet;
import hec.rss.model.ReleaseAllocationSetRef;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReleaseOverrides;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirStorageVsYieldAnalysis;
import hec.rss.model.ReverseReservoirYieldAnalysis;
import hec.rss.model.RssConditionalBlock;
import hec.rss.model.RssNode;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.ScheduledHydropowerOpRule;
import hec.rss.model.ScriptOpRule;
import hec.rss.model.StateVariable;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.StorageZoneRules;
import hec.rss.model.SystemHydropowerOpRule;
import hec.rss.model.TandemOpRule;
import hec.rss.model.TandemSysOpRule;
import hec.rss.model.VerticalDatumSettings;
import hec.rss.model.ZoneObject;
import hec.rss.model.reports.AltInputReportEnums;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.VerticalDatumException;
import org.jdom.Content;
import rma.util.RMASort;

public class OpSet
extends RssTSLocationObject
implements AltInputReportInfc {
    static final long serialVersionUID = 3554131523530966301L;
    public static final String DEFAULT_ALLOCATION_SET_NAME = "Default Allocation Set";
    public static final String BASE_NAME = "Base";
    public static final String INACTIVE_ZONE = "Inactive";
    public static final String CONSERVATION_ZONE = "Conservation";
    public static final String FLOOD_ZONE = "Flood Control";
    public static final int INACTIVE_ZONE_ID = 0;
    private static final int CONSERVATION_ZONE_ID = 1;
    public static final int FLOOD_ZONE_ID = 2;
    ElementOp _resOp;
    Vector<StorageZone> _zoneVec = new Vector();
    DecisionSch _decisionSch = new DecisionSch();
    int _gczoneId = 1;
    int _inactiveZoneId = 0;
    Vector _creditResRefVec;
    SeasonalPairedValues _storageCredit;
    boolean _useStorageCredit;
    boolean _hasCapacityOutages;
    boolean _hasReleaseAllocation;
    boolean _hasUserDefinedReleaseAllocation;
    boolean _hasDecisionSchedule;
    CapacitySchedule _capacitySchedule = new CapacitySchedule();
    int _nextZoneIndex = 3;
    @Deprecated
    transient Hashtable _contollerZoneRulesTable;
    @Deprecated
    transient Map _zoneRuleTable;
    transient intContainer _intContainer = new intContainer();
    transient doubleArrayContainer[] _zoneElevArray;
    transient doubleArrayContainer[] _zoneStorArray;
    transient doubleArrayContainer _projectedElevArray;
    transient Map<Element, double[]> _capacityFactorsMap;
    transient Map<Element, double[]> _capacityOverridesMap;
    Map _releaseAllocationTable = new Hashtable();
    ReleaseAllocationSet DEFAULT_ALLOCATION_SET = new ReleaseAllocationSet("Default Allocation Set", "");
    ReleaseAllocationObject DEFAULT_RELESSE_ALLOCATION_OBJECT = null;
    List<ReleaseAllocationSet> _releaseAllocationSets = new ArrayList<ReleaseAllocationSet>();
    List<ConditionalBlock> _releaseAllocationConditionals = new ArrayList<ConditionalBlock>();
    List<ConditionalBlock> _conditionalBlockList = new ArrayList<ConditionalBlock>();
    ReleaseAllocationObject _releaseAllocationObject = null;
    private boolean _computingProjectedElevation = false;
    private int _compProjElevHours = 0;
    private boolean _useProjectedResElevForOpZone = false;
    private transient boolean _useStorageScale = false;
    private transient double _storageScale = 1.0;

    public OpSet() {
        this.DEFAULT_RELESSE_ALLOCATION_OBJECT = this.createDefualtReleaseAllocationObject();
    }

    public OpSet(String string) {
        super(string);
        this.createDefaultZones();
        this.DEFAULT_RELESSE_ALLOCATION_OBJECT = this.createDefualtReleaseAllocationObject();
    }

    public OpSet(ElementOp elementOp, String string) {
        super(string);
        this._resOp = elementOp;
        this.createDefaultZones();
        this.DEFAULT_RELESSE_ALLOCATION_OBJECT = this.createDefualtReleaseAllocationObject();
    }

    private ReleaseAllocationObject createDefualtReleaseAllocationObject() {
        return new ReleaseAllocationSetRef(this.DEFAULT_ALLOCATION_SET);
    }

    public ReleaseAllocationObject getReleaseAllocationObject() {
        if (this._releaseAllocationObject == null) {
            if (!this._releaseAllocationTable.isEmpty()) {
                this._releaseAllocationObject = new OpSet$DefaultDeprecatedReleaseAllocationObject(this).getReleaseAllocationSetRef();
                this._releaseAllocationSets.addAll(this._releaseAllocationObject.getAllReleaseAllocationSets());
            } else {
                this._releaseAllocationObject = this.DEFAULT_RELESSE_ALLOCATION_OBJECT;
            }
        }
        return this._releaseAllocationObject;
    }

    public void setReleaseAllocationObject(ReleaseAllocationObject releaseAllocationObject) {
        this._releaseAllocationObject = releaseAllocationObject;
    }

    public int getMaxNumROCSteps(RunTimeWindow runTimeWindow, double d, int n) {
        if (runTimeWindow == null) {
            return 0;
        }
        n = 0;
        int n2 = runTimeWindow.getTimeStepSeconds();
        double d2 = this.getTopZone().getFirstElevation();
        Object object = this._resOp.getOperationsElement().getCompositeRelease();
        double d3 = 0.0;
        if (object != null) {
            d3 = object.interpolate(d2);
        }
        double d4 = 0.0;
        double d5 = this._resOp.getController().getAdjustableParameter().getMaxRateOfIncrease();
        double d6 = this._resOp.getController().getAdjustableParameter().getMaxRateOfDecrease();
        if (d5 != Double.NEGATIVE_INFINITY && d5 > 0.0) {
            d4 = d5;
        }
        if (d6 != Double.NEGATIVE_INFINITY && d6 > d4) {
            d4 = d6;
        }
        if (d4 > 0.0) {
            n = (int)(d3 / (d4 / 3600.0) / (double)n2 + 0.5);
        }
        object = this.getRules(null);
        int n3 = object.size();
        for (int i = 0; i < n3; ++i) {
            int n4;
            OpRule opRule = (OpRule)object.get(i);
            if (!(opRule instanceof RateChangeLimitOpRule) || n >= (n4 = ((RateChangeLimitOpRule)opRule).getMaxROCSteps(d, n2))) continue;
            n = n4;
        }
        if (n > runTimeWindow.getForecastSteps()) {
            n = runTimeWindow.getForecastSteps();
        }
        return n;
    }

    void setProjectedElevation(RunTimeStep runTimeStep, double d) {
        if (this._projectedElevArray != null && this._projectedElevArray.array != null) {
            this._projectedElevArray.array[runTimeStep.step] = d;
        }
    }

    private ReleaseAllocation generateDefaultReleaseAllocation(int n) {
        ReleaseAllocation releaseAllocation = new ReleaseAllocation(1);
        return releaseAllocation;
    }

    public ReleaseAllocation getReleaseAllocation(String string, OpController opController) {
        if (opController == null) {
            return null;
        }
        return this.getReleaseAllocation(string, opController.getIndex());
    }

    public void addReleaseAllocation(ReleaseAllocationSet releaseAllocationSet) {
        if (releaseAllocationSet == null) {
            throw new IllegalArgumentException("Invalid Release Allocation being added to OpSet \"" + this.getName() + "\".\nThe value cannot be NULL");
        }
        this._releaseAllocationSets.add(releaseAllocationSet);
    }

    public boolean addReleaseAllocationConditional(ConditionalBlock conditionalBlock) {
        if (conditionalBlock == null) {
            return false;
        }
        this._releaseAllocationConditionals.add(conditionalBlock);
        return true;
    }

    public ReleaseAllocationSet getDefaultReleaseAllocationSet() {
        return this.DEFAULT_ALLOCATION_SET;
    }

    public List<ReleaseAllocationSet> getReleaseAllocationSets() {
        return new ArrayList<ReleaseAllocationSet>(this._releaseAllocationSets);
    }

    public List<ConditionalBlock> getReleaseAllocationConditionals() {
        return new ArrayList<ConditionalBlock>(this._releaseAllocationConditionals);
    }

    public void addConditionalBlock(ConditionalBlock conditionalBlock) {
        if (conditionalBlock == null) {
            throw new IllegalArgumentException("Invalid Conditional Block being added to OpSet \"" + this.getName() + "\".\nThe value cannot be NULL");
        }
        this._conditionalBlockList.add(conditionalBlock);
    }

    public void deleteReleaseAllocationSet(ReleaseAllocationSet releaseAllocationSet) {
        this._releaseAllocationSets.remove((Object)releaseAllocationSet);
        if (releaseAllocationSet != null && this._releaseAllocationObject != null && ((Object)((Object)releaseAllocationSet)).equals(this._releaseAllocationObject.getReference())) {
            this._releaseAllocationObject = null;
        }
    }

    public void removeReleaseAllocationSet(ReleaseAllocationSet releaseAllocationSet) {
        if (releaseAllocationSet != null && this._releaseAllocationObject != null && ((Object)((Object)releaseAllocationSet)).equals(this._releaseAllocationObject.getReference())) {
            this._releaseAllocationObject = null;
        }
    }

    public void deleteReleaseAllocationSetIfBlock(ConditionalBlock conditionalBlock) {
        this._releaseAllocationConditionals.remove(conditionalBlock);
        if (conditionalBlock != null && this._releaseAllocationObject != null && conditionalBlock.equals(this._releaseAllocationObject.getReference())) {
            this._releaseAllocationObject = null;
        }
    }

    public ReleaseAllocationSet getReleaseAllocationSet(String string) {
        for (ReleaseAllocationSet releaseAllocationSet : this._releaseAllocationSets) {
            if (!releaseAllocationSet.getName().equals(string)) continue;
            return releaseAllocationSet;
        }
        return null;
    }

    public ReleaseAllocation getReleaseAllocation(String object, int n) {
        if (object == null) {
            return null;
        }
        if ((object = this.getReleaseAllocationSet((String)object)) == null) {
            return null;
        }
        ReleaseAllocation releaseAllocation = ((ReleaseAllocationSet)((Object)object)).getReleaseAllocation(n);
        if (releaseAllocation == null) {
            releaseAllocation = this.generateDefaultReleaseAllocation(n);
            ((ReleaseAllocationSet)((Object)object)).addReleaseAllocation(n, releaseAllocation);
        }
        return releaseAllocation;
    }

    public void deleteReleaseAllocation(OpController opController) {
        if (opController == null) {
            return;
        }
        this.deleteReleaseAllocation(opController.getIndex());
    }

    public void deleteReleaseAllocation(int n) {
        this._releaseAllocationTable.remove(new intContainer(n));
    }

    public void setReleaseAllocation(OpController opController, ReleaseAllocation releaseAllocation) {
        if (opController == null) {
            return;
        }
        this.setReleaseAllocation(opController.getIndex(), releaseAllocation);
    }

    public void setReleaseAllocation(int n, ReleaseAllocation releaseAllocation) {
        this._releaseAllocationTable.put(new intContainer(n), releaseAllocation);
    }

    public List<StorageZone> getStorageZones(List<StorageZone> list) {
        if (list == null) {
            list = new ArrayList<StorageZone>();
        }
        int n = this._zoneVec.size();
        for (int i = 0; i < n; ++i) {
            StorageZone storageZone = this._zoneVec.get(i);
            if (storageZone == null || list.contains(storageZone)) continue;
            list.add(storageZone);
        }
        return list;
    }

    public List<OpRule> getRules(List<OpRule> list) {
        if (list == null) {
            list = new ArrayList<OpRule>();
        }
        int n = this._zoneVec.size();
        for (int i = 0; i < n; ++i) {
            StorageZone storageZone = this._zoneVec.get(i);
            if (storageZone == null) continue;
            storageZone.getRules(list);
        }
        return list;
    }

    public List<OpRule> getEnabledRules(List<OpRule> list) {
        if (list == null) {
            list = new ArrayList<OpRule>();
        }
        ArrayList<OpRuleRef> arrayList = new ArrayList<OpRuleRef>();
        int n = this._zoneVec.size();
        for (int i = 0; i < n; ++i) {
            StorageZone storageZone = this._zoneVec.get(i);
            if (storageZone == null) continue;
            storageZone.getRuleRefs(arrayList);
            for (OpRuleRef opRuleRef : arrayList) {
                OpRule opRule;
                if (opRuleRef.isDisabled() || (opRule = opRuleRef.getRule()) == null || list.contains(opRule)) continue;
                list.add(opRule);
            }
            arrayList.clear();
        }
        return list;
    }

    public List<ConditionalBlockRef> getConditionals(List<ConditionalBlockRef> list) {
        if (list == null) {
            list = new ArrayList<ConditionalBlockRef>();
        }
        int n = this._zoneVec.size();
        for (int i = 0; i < n; ++i) {
            StorageZone storageZone = this._zoneVec.get(i);
            if (storageZone == null) continue;
            storageZone.getConditionalBlockRefs(list);
        }
        return list;
    }

    public double computeAdjustedZoneElev(StorageZone object, RunTimeStep runTimeStep, double d) {
        double d2;
        if (!this._useStorageCredit) {
            return d;
        }
        if (object == null || object != this.getGuideCurveZone() || this._creditResRefVec == null || this._storageCredit == null) {
            return d;
        }
        object = ((RssTSLocationObject)this).getSystem();
        OperationsElement operationsElement = this.getElementOp().getOperationsElement();
        double d3 = 0.0;
        int n = this._creditResRefVec.size();
        for (int i = 0; i < n; ++i) {
            double d4;
            ReservoirElement reservoirElement;
            CreditReservoirRef creditReservoirRef = (CreditReservoirRef)this._creditResRefVec.elementAt(i);
            if (creditReservoirRef == null || (reservoirElement = ((RssSystem)object).findReservoir(creditReservoirRef.getReservoirIndex())) == null) continue;
            d2 = reservoirElement.getStorageFunction().getPreviousStorage(runTimeStep);
            double d5 = creditReservoirRef.getMaxCreditPool() - d2;
            if (d4 > creditReservoirRef.getMaxCredit()) {
                d5 = creditReservoirRef.getMaxCredit();
            }
            if (d5 < 0.0 && !creditReservoirRef.getAllowNegCredit()) {
                d5 = 0.0;
            }
            d3 += d5;
        }
        double d6 = this._storageCredit.interpolate(runTimeStep, d3);
        d2 = operationsElement.getStorageFunction().elevationToStorage(d);
        double d7 = operationsElement.getStorageFunction().storageToElevation(d2 += d6);
        return d7;
    }

    public StorageZone getGuideCurveZone() {
        OpSet opSet = this;
        StorageZone storageZone = opSet.getZone(opSet._gczoneId);
        if (storageZone == null && this._gczoneId > 1) {
            storageZone = this.getZone(1);
            if (storageZone != null) {
                this.setGuideCurveZoneIndex(1);
            } else {
                storageZone = this.getZone(0);
                if (storageZone != null) {
                    this.setGuideCurveZoneIndex(0);
                }
            }
        }
        if (storageZone == null) {
            this.setGuideCurveZoneIndex(-1);
        }
        return storageZone;
    }

    public StorageZone getFloodZone() {
        return this.getZone(2);
    }

    public StorageZone getInactiveZone() {
        OpSet opSet = this;
        StorageZone storageZone = opSet.getZone(opSet._inactiveZoneId);
        if (storageZone == null) {
            this.setInactiveZoneIndex(-1);
        }
        return storageZone;
    }

    public int getGuideCurveZoneIndex() {
        return this._gczoneId;
    }

    public int getInactiveZoneIndex() {
        return this._inactiveZoneId;
    }

    public void setInactiveZoneIndex(int n) {
        if (n != this._inactiveZoneId) {
            this.setModified(true);
        }
        this._inactiveZoneId = n;
    }

    public boolean getUseStorageCredit() {
        return this._useStorageCredit;
    }

    public void setGuideCurveZoneIndex(int n) {
        if (n != this._gczoneId) {
            this.setModified(true);
        }
        this._gczoneId = n;
    }

    public void setUseStorgeCredit(boolean bl) {
        this._useStorageCredit = bl;
    }

    public SeasonalPairedValues getStorageCredit() {
        if (this._storageCredit != null) {
            this._storageCredit.setParamXId(Parameter.PARAMID_STOR);
            this._storageCredit.setParamYId(Parameter.PARAMID_STOR);
            this._storageCredit.setUnitSystem(this.getUnitSystem());
        }
        return this._storageCredit;
    }

    public void setStorageCredit(SeasonalPairedValues seasonalPairedValues) {
        this._storageCredit = seasonalPairedValues;
    }

    public Vector getCreditResRefVec() {
        return this._creditResRefVec;
    }

    public void setCreditResRefVec(Vector vector) {
        if (vector != null && vector.size() <= 0) {
            vector = null;
        }
        if (this._creditResRefVec == null && vector == null) {
            return;
        }
        this.setModified(true);
        this._creditResRefVec = vector;
    }

    public DecisionSch getDecisionSchedule() {
        if (this._decisionSch == null) {
            this._decisionSch = new DecisionSch();
        }
        return this._decisionSch;
    }

    public boolean isDecisionStep(RunTimeStep runTimeStep) {
        if (this._decisionSch == null || !this._hasDecisionSchedule) {
            return true;
        }
        return this._decisionSch.isDecisionStep(runTimeStep);
    }

    public int getNumDecisionSteps(RunTimeStep runTimeStep) {
        if (this._decisionSch == null || !this._hasDecisionSchedule) {
            return 1;
        }
        return this._decisionSch.getNumDecisionSteps(runTimeStep);
    }

    public int getMaxNumDecisionSteps(int n) {
        if (this._decisionSch == null || !this._hasDecisionSchedule) {
            return 1;
        }
        return this._decisionSch.getMaxNumDecisionSteps(n);
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        IndependentVariable independentVariable;
        Object object;
        Object object2;
        NamedType namedType;
        int n2;
        int n3;
        if (vector == null) {
            vector = new Vector<Object>();
        }
        if (n == 0) {
            n3 = this._zoneVec.size();
            for (n2 = 0; n2 < n3; ++n2) {
                namedType = this._zoneVec.elementAt(n2);
                object2 = this.getFullZoneName((StorageZone)namedType);
                object = this.getTSRecordProxy((String)object2, 76);
                if (object != null) {
                    vector.add(object);
                }
                if ((object = this.getTSRecordProxy((String)object2, 78)) == null) continue;
                vector.add(object);
            }
            if (this.computingProjectedElevation() && (object = this.getTSRecordProxy((String)(object2 = this._resOp.getOperationsElement().getName()), 169)) != null) {
                vector.add(object);
            }
        } else if (n == 1) {
            n3 = this._zoneVec.size();
            for (n2 = 0; n2 < n3; ++n2) {
                namedType = this._zoneVec.elementAt(n2);
                this.getFullZoneName((StorageZone)namedType);
                if (namedType.getIndependentVariable() != null && namedType.getIndependentVariable().getType() == 3) {
                    object2 = namedType.getIndependentVariable().getTimeSeriesName();
                    object = this.getTSRecordProxy((String)object2, 85);
                    if (object == null) continue;
                    vector.addElement(object);
                    continue;
                }
                if (namedType.getIndependentVariable().getType() != 5) continue;
                independentVariable = namedType.getIndependentVariable().getRowVariable();
                if (independentVariable != null && independentVariable.getType() == 3 && (object = this.getTSRecordProxy((String)(object2 = independentVariable.getTimeSeriesName()), 85)) != null) {
                    vector.addElement(object);
                }
                if ((object = namedType.getIndependentVariable().getColVariable()) == null || ((IndependentVariable)object).getType() != 3 || (object = this.getTSRecordProxy((String)(object2 = ((IndependentVariable)object).getTimeSeriesName()), 85)) == null) continue;
                vector.addElement(object);
            }
        }
        object = this.getRules(null);
        n3 = object.size();
        for (n2 = 0; n2 < n3; ++n2) {
            namedType = object.get(n2);
            if (namedType == null) continue;
            namedType.getActiveTSRecordProxies(vector, n);
        }
        object2 = this.getConditionals(null);
        n3 = object2.size();
        independentVariable = null;
        for (n2 = 0; n2 < n3; ++n2) {
            object = (ConditionalBlockRef)object2.get(n2);
            if (((ConditionalBlockRef)object).getConditionalBlock() != null) {
                independentVariable = ((ConditionalBlockRef)object).getConditionalBlock();
            }
            if (!(independentVariable instanceof RssConditionalBlock)) continue;
            ((RssConditionalBlock)((Object)independentVariable)).getActiveTSRecordProxies(vector, n);
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2 = this._zoneVec.size();
        for (n = 0; n < n2; ++n) {
            Object object4;
            StorageZone storageZone = this._zoneVec.elementAt(n);
            object3 = this.getFullZoneName(storageZone);
            object2 = this.getTSRecordProxy((String)object3, 76);
            if (object2 == null) {
                this.addTSRecordProxy((String)object3, 76);
                object2 = this.getTSRecordProxy((String)object3, 76);
            }
            object = this._resOp.getOperationsElement();
            object = object.getVerticalDatumSettings();
            object = new VerticalDatumSettings((VerticalDatumSettings)object);
            try {
                object4 = Parameter.getParameter((int)Parameter.PARAMID_ELEV).getUnitsStringForSystem(this.getUnitSystem());
                ((VerticalDatumSettings)object).setUnits((String)object4);
            }
            catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                Logger.getLogger(ReservoirElement.class.getName()).log(Level.SEVERE, null, dataSetIllegalArgumentException);
            }
            try {
                object2.setVerticalDatumInfo(((VerticalDatumSettings)object).toVerticalDatumXml());
            }
            catch (VerticalDatumException verticalDatumException) {
                Logger.getLogger(OpSet.class.getName()).log(Level.SEVERE, null, verticalDatumException);
            }
            if (storageZone.getIndependentVariable() != null) {
                if (storageZone.getIndependentVariable().getType() == 3) {
                    object = !storageZone.getIndependentVariable().getTimeSeriesName().isEmpty() ? storageZone.getIndependentVariable().getTimeSeriesName() : "External Variable";
                    object2 = this.getTSRecordProxy((String)object, 85);
                    if (object2 == null) {
                        this.addTSRecordProxy((String)object, 85);
                    }
                } else if (storageZone.getIndependentVariable().getType() == 5) {
                    object4 = storageZone.getIndependentVariable().getRowVariable();
                    if (object4 != null && ((IndependentVariable)object4).getType() == 3 && (object2 = this.getTSRecordProxy((String)(object = !((IndependentVariable)object4).getTimeSeriesName().isEmpty() ? ((IndependentVariable)object4).getTimeSeriesName() : "External Variable"), 85)) == null) {
                        this.addTSRecordProxy((String)object, 85);
                    }
                    if ((object2 = storageZone.getIndependentVariable().getColVariable()) != null && ((IndependentVariable)object2).getType() == 3 && (object2 = this.getTSRecordProxy((String)(object = !((IndependentVariable)object2).getTimeSeriesName().isEmpty() ? ((IndependentVariable)object2).getTimeSeriesName() : "External Variable"), 85)) == null) {
                        this.addTSRecordProxy((String)object, 85);
                    }
                }
            }
            if ((object2 = this.getTSRecordProxy((String)object3, 78)) != null) continue;
            this.addTSRecordProxy((String)object3, 78);
        }
        if (this.computingProjectedElevation() && (object2 = this.getTSRecordProxy((String)(object3 = this._resOp.getOperationsElement().getName()), 169)) == null) {
            this.addTSRecordProxy((String)object3, 169);
        }
        object3 = this.getRules(null);
        n2 = object3.size();
        for (n = 0; n < n2; ++n) {
            object = (OpRule)object3.get(n);
            if (object == null) continue;
            ((RssTSLocationObject)object).updateTSProxyList();
        }
    }

    @Override
    public Vector getTSRecordProxyVec(int n, Vector vector) {
        if (this._tsrecordVector == null) {
            this._tsrecordVector = new Vector();
        }
        if (vector == null) {
            vector = new Vector<Object>();
        }
        if (n == 128) {
            Object object = this.getGuideCurveZone();
            if (object == null) {
                return vector;
            }
            object = this.getFullZoneName((StorageZone)object);
            if ((object = this.getTSRecordProxy((String)object, 76)) != null) {
                vector.add(object);
            }
            return vector;
        }
        if (n == 129) {
            Object object = this.getGuideCurveZone();
            if (object == null) {
                return vector;
            }
            object = this.getFullZoneName((StorageZone)object);
            if ((object = this.getTSRecordProxy((String)object, 78)) != null) {
                vector.add(object);
            }
            return vector;
        }
        return super.getTSRecordProxyVec(n, vector);
    }

    public String getFullZoneName(StorageZone storageZone) {
        String string = this._resOp.getOperationsElement().getName();
        return string + "-" + storageZone.getName();
    }

    @Override
    public RssSystem getSystem() {
        if (this._resOp == null) {
            return null;
        }
        return this._resOp.getOperationsElement().getSystem();
    }

    public void deleteControllerReferences(int n) {
        int n2 = this._zoneVec.size();
        for (int i = 0; i < n2; ++i) {
            StorageZone storageZone = this._zoneVec.get(i);
            if (storageZone == null) continue;
            storageZone.removeControllerRefs(n);
        }
        this.deleteReleaseAllocation(n);
    }

    public int getUnitSystem() {
        return this._resOp.getUnitSystem();
    }

    public StorageZone getTopZone() {
        Vector<StorageZone> vector = this.getSortedZoneVector(true);
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        return vector.lastElement();
    }

    public boolean checkZonesAdjacent(StorageZone storageZone, StorageZone storageZone2) {
        boolean bl = false;
        int n = this._zoneVec.size();
        for (int i = 0; i < n - 1; ++i) {
            StorageZone storageZone3 = this._zoneVec.elementAt(i);
            StorageZone storageZone4 = this._zoneVec.elementAt(i + 1);
            if (storageZone3 == storageZone) {
                if (storageZone4 != storageZone2) continue;
                bl = true;
                break;
            }
            if (storageZone3 != storageZone2 || storageZone4 != storageZone) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public StorageZone getActiveZone(double d, RunTimeStep runTimeStep) {
        StorageZone storageZone = null;
        StorageZone storageZone2 = this.getGuideCurveZone();
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        if (storageZone2 != null) {
            d2 = storageZone2.getElevation(runTimeStep);
            d3 = storageZone2.getFirstElevation();
        }
        int n = this._zoneVec.size();
        for (int i = 0; i < n; ++i) {
            StorageZone storageZone3 = this._zoneVec.elementAt(i);
            double d4 = storageZone3.getElevation(runTimeStep);
            if (storageZone2 != null && storageZone2 != storageZone3) {
                if (storageZone3.getFirstElevation() <= d3 && d2 < d4) {
                    d4 = d2;
                } else if (storageZone3.getFirstElevation() > d3 && d2 > d4) {
                    d4 = d2;
                }
            }
            if (this._zoneElevArray != null && this._zoneElevArray[i] != null) {
                this._zoneElevArray[i].array[runTimeStep.step] = d4;
            }
            if (storageZone != null || !(d4 + 0.001 >= d)) continue;
            storageZone = storageZone3;
        }
        return storageZone;
    }

    public List getControllerRules(int n, List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        int n2 = this._zoneVec.size();
        for (int i = 0; i < n2; ++i) {
            StorageZone storageZone = this._zoneVec.get(i);
            if (storageZone == null) continue;
            storageZone.getControllerRules(n, arrayList);
        }
        return arrayList;
    }

    public void getDownstreamRuleNodes(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        if (this._intContainer == null) {
            this._intContainer = new intContainer();
        }
        List<OpRule> list = this.getRules(null);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            TSLocation tSLocation = list.get(i);
            int n2 = -1;
            if (tSLocation instanceof DownstreamCntrlOpRule) {
                n2 = ((DownstreamCntrlOpRule)tSLocation).getDownstreamControlLocationID();
            }
            if (n2 < 0) continue;
            this._intContainer.value = n2;
            tSLocation = (RssNode)hashtable.get(this._intContainer);
            if (tSLocation != null || (tSLocation = this._resOp.getOperationsElement().getSystem().getNode(n2)) == null) continue;
            hashtable.put(new intContainer(n2), tSLocation);
        }
    }

    public void getDownstreamRules(List list) {
        if (list == null) {
            return;
        }
        List<OpRule> list2 = this.getRules(null);
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            OpRule opRule = list2.get(i);
            if (opRule instanceof DownstreamCntrlOpRule) {
                list.add(opRule);
                continue;
            }
            if (!(opRule instanceof TandemOpRule)) continue;
            list.add(opRule);
        }
    }

    public void getSystemHydropowerOpRules(List list) {
        if (list == null) {
            return;
        }
        List<OpRule> list2 = this.getRules(null);
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            OpRule opRule = list2.get(i);
            if (!(opRule instanceof SystemHydropowerOpRule)) continue;
            list.add(opRule);
        }
    }

    public void getReferencedStateVariables(List list) {
        if (list == null) {
            return;
        }
        int n = this._zoneVec.size();
        for (int i = 0; i < n; ++i) {
            StorageZone storageZone = this._zoneVec.get(i);
            if (storageZone == null) continue;
            storageZone.getReferencedStateVariables(list);
        }
    }

    public boolean hasDownstreamGoals() {
        List<OpRule> list = this.getRules(null);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            OpRule opRule = list.get(i);
            if (opRule instanceof DownstreamCntrlOpRule) {
                return true;
            }
            if (!(opRule instanceof TandemOpRule)) continue;
            return true;
        }
        return false;
    }

    public List getAllRuleRefs(int n, int n2, List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        int n3 = this._zoneVec.size();
        for (int i = 0; i < n3; ++i) {
            StorageZone storageZone = this._zoneVec.get(i);
            if (storageZone == null) continue;
            storageZone.getAllRuleRefs(n, n2, arrayList);
        }
        return arrayList;
    }

    public void removeAllConditionalBlockRefs(int n) {
        int n2 = this._zoneVec.size();
        for (int i = 0; i < n2; ++i) {
            StorageZone storageZone = this._zoneVec.get(i);
            storageZone.removeAllConditionalBlockRefs(n);
        }
        this.setModified(true);
    }

    public void removeAllRuleRef(int n, int n2) {
        int n3 = this._zoneVec.size();
        for (int i = 0; i < n3; ++i) {
            StorageZone storageZone = this._zoneVec.get(i);
            storageZone.removeAllRuleRefs(n, n2);
        }
        this.setModified(true);
    }

    public void deleteZone(int n) {
        for (int i = 0; i < this._zoneVec.size(); ++i) {
            StorageZone storageZone = this._zoneVec.elementAt(i);
            if (storageZone.getIndex() != n) continue;
            this._zoneVec.removeElementAt(i);
            break;
        }
        this.setModified(true);
    }

    public void setElementOp(ElementOp elementOp) {
        this._resOp = elementOp;
    }

    public ElementOp getElementOp() {
        return this._resOp;
    }

    public String toString() {
        String string = this.getName();
        if (string != null) {
            return string;
        }
        return super.toString();
    }

    private void createDefaultZones() {
        StorageZone storageZone = new StorageZone(FLOOD_ZONE);
        storageZone.setIndex(2);
        storageZone.setUnitSysetm(this.getUnitSystem());
        this._zoneVec.addElement(storageZone);
        storageZone.setOpSet(this);
        storageZone = new StorageZone(CONSERVATION_ZONE);
        storageZone.setIndex(1);
        storageZone.setUnitSysetm(this.getUnitSystem());
        this._zoneVec.addElement(storageZone);
        storageZone.setOpSet(this);
        storageZone = new StorageZone(INACTIVE_ZONE);
        storageZone.setIndex(0);
        storageZone.setUnitSysetm(this.getUnitSystem());
        this._zoneVec.addElement(storageZone);
        storageZone.setOpSet(this);
        this.setModified(true);
    }

    public Vector getZoneVector() {
        return this._zoneVec;
    }

    public boolean initializeCompute(RunTimeWindow runTimeWindow) {
        Object object;
        this._zoneVec = this.getSortedZoneVector(true);
        int n = this._zoneVec.size();
        if (n > 0) {
            this._zoneElevArray = new doubleArrayContainer[n];
            this._zoneStorArray = new doubleArrayContainer[n];
            object = this._resOp.getOperationsElement().getStorageFunction();
            for (int i = 0; i < n; ++i) {
                StorageZone storageZone = this._zoneVec.elementAt(i);
                if (!storageZone.initializeCompute()) {
                    return false;
                }
                storageZone.setStorageFunction((Storage)object);
                String string = this.getFullZoneName(storageZone);
                this._zoneElevArray[i] = this.getTSContainer(string, 76);
                this._zoneStorArray[i] = this.getTSContainer(string, 78);
                if (this._zoneElevArray[i] == null || this._zoneStorArray[i] == null) {
                    ((RssTSLocationObject)this).getSystem().printErrorMessage("OpSet.initializeCompute: failed to get time series array for zone elevation for " + this.getElementOp().getOperationsElement().getName());
                    return false;
                }
                storageZone.setZoneElevTSContainer(this._zoneElevArray[i]);
                storageZone.setZoneStorTSContainer(this._zoneStorArray[i]);
                if (!storageZone.isTimeSeries()) continue;
                storageZone.setKnownElevTS(this.getTSContainer(string, 77));
            }
        } else {
            this._zoneElevArray = null;
            this._zoneStorArray = null;
        }
        if (this.computingProjectedElevation()) {
            object = this._resOp.getOperationsElement().getName();
            this._projectedElevArray = this.getTSContainer((String)object, 169);
        } else {
            this._projectedElevArray = null;
        }
        this.buildCapacityFactorArray();
        if (this._decisionSch != null && !this._decisionSch.initializeCompute(runTimeWindow)) {
            return false;
        }
        if (this._useStorageCredit && (object = this.getGuideCurveZone()) != null) {
            ((StorageZone)object).setOpSetForElevOverride(this);
        }
        return true;
    }

    public int setUseStorageScale(boolean bl, ReverseReservoirYieldAnalysis reverseReservoirYieldAnalysis) {
        Object object;
        this._useStorageScale = bl;
        StorageZone storageZone = reverseReservoirYieldAnalysis.a(this);
        if (storageZone == null) {
            return 1;
        }
        storageZone.setUseStorageScale(bl, reverseReservoirYieldAnalysis);
        StorageZone storageZone2 = storageZone;
        storageZone2.setMobileZoneId(storageZone2.getIndex());
        Object object2 = reverseReservoirYieldAnalysis.b(this);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (StorageZone)object2.next();
            ((StorageZone)object).setUseStorageScale(bl, reverseReservoirYieldAnalysis);
            ((StorageZone)object).setMobileZoneId(storageZone.getIndex());
            ((StorageZone)object).setAbvMobileZone(true);
        }
        object2 = reverseReservoirYieldAnalysis.c(this);
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (StorageZone)object.next();
            ((StorageZone)object2).setUseStorageScale(bl, reverseReservoirYieldAnalysis);
            ((StorageZone)object2).setMobileZoneId(storageZone.getIndex());
            ((StorageZone)object2).setAbvMobileZone(false);
        }
        return 0;
    }

    public void setUseStorageScale(boolean bl, ReservoirStorageVsYieldAnalysis reservoirStorageVsYieldAnalysis) {
        Object object;
        this._useStorageScale = bl;
        StorageZone storageZone = this.getGuideCurveZone();
        storageZone.setUseStorageScale(bl, reservoirStorageVsYieldAnalysis);
        StorageZone storageZone2 = storageZone;
        storageZone2.setMobileZoneId(storageZone2.getIndex());
        Object object2 = reservoirStorageVsYieldAnalysis.a(this);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (StorageZone)object2.next();
            ((StorageZone)object).setUseStorageScale(bl, reservoirStorageVsYieldAnalysis);
            ((StorageZone)object).setMobileZoneId(storageZone.getIndex());
            ((StorageZone)object).setAbvMobileZone(true);
        }
        object2 = reservoirStorageVsYieldAnalysis.b(this);
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (StorageZone)object.next();
            ((StorageZone)object2).setUseStorageScale(bl, reservoirStorageVsYieldAnalysis);
            ((StorageZone)object2).setMobileZoneId(storageZone.getIndex());
            ((StorageZone)object2).setAbvMobileZone(false);
        }
    }

    public boolean useStorageScale() {
        return this._useStorageScale;
    }

    public void setStorageScale(double d, ReverseReservoirYieldAnalysis cloneable) {
        this._storageScale = d;
        cloneable = cloneable != null ? ((ReverseReservoirYieldAnalysis)cloneable).a(this) : this.getGuideCurveZone();
        ((StorageZone)cloneable).setStorageScale(d);
    }

    public double getStorageScale() {
        return this._storageScale;
    }

    public OpValue getCapacityOutageOrOverride(Element object, int n, OpValue opValue) {
        reference v0;
        if (object == null || n < 0) {
            return opValue;
        }
        if (!this.hasCapacityOutages() && this._capacityOverridesMap.size() == 0) {
            return opValue;
        }
        object = this.hasCapacityOutages() ? (Object)this._capacityFactorsMap.get(object) : (Object)this._capacityOverridesMap.get(object);
        if (object == null) {
            return opValue;
        }
        if (n >= ((Object)object).length) {
            return opValue;
        }
        reference var5_4 = object[n];
        if (v0 < 0.0) {
            if (var5_4 <= -19.0) {
                var5_4 += 19.0;
                opValue.constraintid = -19;
            } else if (var5_4 <= -17.0) {
                var5_4 += 17.0;
                opValue.constraintid = -17;
            }
            if (var5_4 < 0.0) {
                var5_4 = -var5_4;
            }
            opValue.value = (double)(var5_4 * opValue.value);
        }
        return opValue;
    }

    protected void buildCapacityFactorArray() {
        ReleaseOverrides releaseOverrides;
        RssRun rssRun;
        Object object;
        double[] dArray;
        Object object2;
        NamedType namedType = ((RssTSLocationObject)this).getSystem();
        RunTimeWindow runTimeWindow = namedType.getRssRun().getCurrentComputeBlockRunTimeWindow();
        Object object3 = this._capacitySchedule.getCapacityOutages();
        object3.size();
        this._capacityFactorsMap = new HashMap<Element, double[]>();
        this._capacityOverridesMap = new HashMap<Element, double[]>();
        Object object4 = object3.keySet();
        Iterator<Object> iterator = object4.iterator();
        int n = runTimeWindow.getNumSteps();
        DSSPathname dSSPathname = new DSSPathname();
        int n2 = 0;
        try {
            n2 = ((RmiWorkspace)namedType.getWorkspace().getRemote()).getTimeZone().getRawOffset();
        }
        catch (RemoteException remoteException) {
            System.out.println("buildCapacityFactorArray: failed to get TZ offset " + String.valueOf(remoteException));
        }
        while (iterator.hasNext()) {
            int n3;
            object4 = (intContainer)iterator.next();
            object2 = namedType.getElement(((intContainer)object4).value);
            if (object2 == null) {
                System.out.println("buildCapacityFactorArray: failed to find element for Index=" + ((intContainer)object4).value);
                continue;
            }
            dArray = new double[n];
            object = new double[n];
            int[] nArray = new int[n];
            Object object5 = ((Element)object2).getTSRecordProxy(127);
            object5 = namedType.getRssRun().constructTSRecordProxyDssPath((TSRecordProxy)object5, "CAPACITY-FACTOR");
            dSSPathname.setPathname((String)object5);
            TimeSeriesContainer timeSeriesContainer = new TimeSeriesContainer();
            new TimeSeriesContainer().fullName = dSSPathname.pathname();
            timeSeriesContainer.fileName = namedType.getRssRun().getDSSOutputFile();
            timeSeriesContainer.watershed = dSSPathname.aPart();
            timeSeriesContainer.location = dSSPathname.bPart();
            timeSeriesContainer.parameter = dSSPathname.cPart();
            timeSeriesContainer.version = dSSPathname.fPart();
            timeSeriesContainer.type = "PER-AVER";
            timeSeriesContainer.timeZoneRawOffset = n2;
            timeSeriesContainer.units = "Factor";
            timeSeriesContainer.startTime = runTimeWindow.getLookbackTime().value();
            timeSeriesContainer.endTime = runTimeWindow.getEndTime().value();
            timeSeriesContainer.interval = runTimeWindow.getTimeIncrement();
            timeSeriesContainer.numberValues = ((double[])object).length;
            nArray[0] = timeSeriesContainer.startTime;
            for (int i = 1; i < nArray.length; ++i) {
                nArray[i] = nArray[i - 1] + runTimeWindow.getTimeStepMinutes();
            }
            timeSeriesContainer.times = nArray;
            Arrays.fill(dArray, 1.0);
            Arrays.fill(object, 1.0);
            this._capacityFactorsMap.put((Element)object2, dArray);
            object2 = (List)object3.get(object4);
            int n4 = object2.size();
            rssRun = new HecTime();
            releaseOverrides = new HecTime();
            for (n3 = 0; n3 < n4; ++n3) {
                object4 = (CapacityOutage)object2.get(n3);
                if (!((CapacityOutage)object4).isActive()) continue;
                rssRun.set(runTimeWindow.getLookbackTime());
                rssRun.set(nArray[0]);
                rssRun.add(-runTimeWindow.getTimeStepMinutes());
                for (int i = 0; i < n; ++i) {
                    releaseOverrides.set(nArray[i]);
                    double d = ((CapacityOutage)object4).getFactorForStep((HecTime)rssRun, (HecTime)releaseOverrides, runTimeWindow.isPerAvgTimeStep());
                    this.fillCapacityArray(i, dArray, (double[])object, d);
                    rssRun.set((HecTime)releaseOverrides);
                }
            }
            timeSeriesContainer.values = object;
            try {
                n3 = namedType.getDSSFileManager().write((DataContainer)timeSeriesContainer);
                if (n3 == 0) continue;
                ((RssTSLocationObject)this).getSystem().printErrorMessage("Failed to save Capacity Factor Timeseries. rv=" + n3);
            }
            catch (Exception exception) {
                System.out.println("buildCapacityFactorArray: Exception writing Capacity Factors to DSS " + String.valueOf(exception));
            }
        }
        rssRun = ((RssTSLocationObject)this).getSystem().getRssRun();
        if (rssRun == null) {
            return;
        }
        releaseOverrides = rssRun.getCapacityOverrides();
        if (releaseOverrides == null) {
            return;
        }
        ReleaseOverrides releaseOverrides2 = ((RssTSLocationObject)this).getSystem().getRssRun().getCapacityOverrides();
        if (releaseOverrides2 != null) {
            object4 = this._capacityFactorsMap.keySet();
            iterator = object4.iterator();
            object = new HecTime();
            while (iterator.hasNext()) {
                Hashtable hashtable;
                object2 = (Element)iterator.next();
                dArray = this._capacityFactorsMap.get(object2);
                TSRecordProxy tSRecordProxy = ((Element)object2).getTSRecordProxy(127);
                if (tSRecordProxy == null || (hashtable = releaseOverrides2.getReleaseValues(tSRecordProxy.getName())) == null) continue;
                namedType = hashtable.keys();
                while (namedType.hasMoreElements()) {
                    object3 = (Integer)namedType.nextElement();
                    object.set(((Integer)object3).intValue());
                    int n5 = runTimeWindow.getStepAtTime((HecTime)object);
                    if (n5 < 0 || n5 >= n) continue;
                    double d = (Double)hashtable.get(object3);
                    dArray[n5] = -d + -19.0;
                }
            }
            iterator = releaseOverrides2.getReleaseNames();
            if (iterator != null) {
                for (int i = 0; i < ((Iterator<Object>)iterator).length; ++i) {
                    Hashtable hashtable;
                    boolean bl = false;
                    namedType = ((RssTSLocationObject)this).getSystem().getObjectForKeyString((String)((Object)iterator[i]));
                    object2 = namedType instanceof Element ? (Element)namedType : (namedType instanceof Function ? ((Function)namedType).getElement() : null);
                    if (object4.contains(object2) || (hashtable = releaseOverrides2.getReleaseValues((String)((Object)iterator[i]))) == null) continue;
                    dArray = new double[n];
                    namedType = hashtable.keys();
                    while (namedType.hasMoreElements()) {
                        object3 = (Integer)namedType.nextElement();
                        object.set(((Integer)object3).intValue());
                        int n6 = runTimeWindow.getStepAtTime((HecTime)object);
                        if (n6 < 0 || n6 >= n) continue;
                        double d = (Double)hashtable.get(object3);
                        dArray[n6] = -d + -19.0;
                        bl = true;
                    }
                    if (!bl) continue;
                    this._capacityOverridesMap.put((Element)object2, dArray);
                }
            }
        }
    }

    private void fillCapacityArray(int n, double[] dArray, double[] dArray2, double d) {
        double d2 = -d + -17.0;
        if (dArray[n] == 1.0 || dArray[n] < d2) {
            dArray[n] = d2;
            dArray2[n] = d;
        }
    }

    private void fillCapacityArray(HecTime hecTime, HecTime hecTime2, RunTimeWindow runTimeWindow, double[] dArray, double[] dArray2, double d) {
        HecTime hecTime3;
        int n = runTimeWindow.getStepAtTime(hecTime);
        int n2 = runTimeWindow.getStepAtTime(hecTime2);
        int n3 = runTimeWindow.getNumSteps();
        if (n > n3) {
            return;
        }
        if (n < 0 && n2 < 0) {
            return;
        }
        HecTime hecTime4 = runTimeWindow.getTimeAtStep(n);
        if (n != n2) {
            hecTime3 = runTimeWindow.getTimeAtStep(n2);
        } else {
            hecTime3 = new HecTime(hecTime4);
            hecTime3.add(runTimeWindow.getTimeIncrement() * 60);
        }
        if (!hecTime4.equalTo(hecTime) || !hecTime3.greaterThan(hecTime2)) {
            hecTime4.value();
            hecTime3.value();
            hecTime.value();
            hecTime2.value();
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 >= n3) {
            n2 = n3;
        }
        if (n > n2) {
            return;
        }
        double d2 = -d + -17.0;
        for (int i = n; i < n2; ++i) {
            if (dArray[i] != 1.0 && !(dArray[i] < d2)) continue;
            dArray[i] = d2;
            dArray2[i] = d;
        }
    }

    public Vector<StorageZone> getSortedZoneVector() {
        return this.getSortedZoneVector(false);
    }

    public Vector<StorageZone> getSortedZoneVector(boolean bl) {
        Vector vector = (Vector)this._zoneVec.clone();
        Vector<Double> vector2 = new Vector<Double>();
        for (StorageZone storageZone : vector) {
            double d;
            if (storageZone.getUnitSystem() == 0) {
                storageZone.setUnitSysetm(this.getUnitSystem());
            }
            if ((d = storageZone.getFirstElevation()) == Double.NEGATIVE_INFINITY) {
                d = Double.NEGATIVE_INFINITY;
            }
            vector2.add(d);
        }
        RMASort.quickSort(vector2, (List)vector, (boolean)bl);
        return vector;
    }

    public StorageZone getZone(int n) {
        for (StorageZone storageZone : this._zoneVec) {
            if (storageZone.getIndex() != n) continue;
            if (storageZone.getUnitSystem() == 0) {
                storageZone.setUnitSysetm(this.getUnitSystem());
            }
            return storageZone;
        }
        return null;
    }

    public StorageZone getZone(String string) {
        for (StorageZone storageZone : this._zoneVec) {
            if (!storageZone.getName().equals(string)) continue;
            if (storageZone.getUnitSystem() == 0) {
                storageZone.setUnitSysetm(this.getUnitSystem());
            }
            return storageZone;
        }
        return null;
    }

    public boolean useRecursiveModifiedTest() {
        return true;
    }

    public StorageZone addNewStorageZone(String object) {
        if (object == null || ((String)object).equals("")) {
            return null;
        }
        object = new StorageZone((String)object);
        int n = this.nextZoneIndex();
        ((StorageZone)object).setUnitSysetm(this.getUnitSystem());
        object.setIndex(n);
        ((StorageZone)object).setOpSetForElevOverride(this);
        ((StorageZone)object).setOpSet(this);
        this._zoneVec.addElement((StorageZone)object);
        this.setModified(true);
        return object;
    }

    private int nextZoneIndex() {
        int n = this._nextZoneIndex++;
        return n;
    }

    public void setCapacitySchedule(CapacitySchedule capacitySchedule) {
        this._capacitySchedule = capacitySchedule;
    }

    public boolean hasUserDefinedReleaseAllocation() {
        if (this._hasReleaseAllocation) {
            this._hasUserDefinedReleaseAllocation = true;
        }
        return this._hasUserDefinedReleaseAllocation;
    }

    public void setHasUserDefinedReleaseAllocation(boolean bl) {
        this._hasReleaseAllocation = this._hasUserDefinedReleaseAllocation = bl;
    }

    public boolean hasCapacityOutages() {
        return this._hasCapacityOutages;
    }

    public void setHasCapacityOutages(boolean bl) {
        this._hasCapacityOutages = bl;
    }

    public void setHasDecisionSchedule(boolean bl) {
        this._hasDecisionSchedule = bl;
    }

    public boolean hasDecisionSchedule() {
        return this._hasDecisionSchedule;
    }

    public boolean hasStorageCredit() {
        return this._useStorageCredit;
    }

    public void setHasStorageCredit(boolean bl) {
        this._useStorageCredit = bl;
    }

    public CapacitySchedule getCapacitySchedule() {
        return this._capacitySchedule;
    }

    @Override
    public synchronized Object clone() {
        try {
            Cloneable cloneable;
            Cloneable cloneable22;
            int n;
            OpSet opSet = (OpSet)super.clone();
            if (opSet == null) {
                return null;
            }
            opSet._resOp = this._resOp;
            opSet._contollerZoneRulesTable = null;
            opSet._zoneRuleTable = null;
            opSet._intContainer = new intContainer();
            opSet._zoneElevArray = null;
            this._zoneStorArray = null;
            opSet._capacityFactorsMap = null;
            opSet._zoneVec = new Vector(this._zoneVec.size());
            for (n = 0; n < this._zoneVec.size(); ++n) {
                cloneable22 = this._zoneVec.elementAt(n);
                cloneable = (StorageZone)((StorageZone)cloneable22).clone();
                if (cloneable == null) continue;
                ((StorageZone)cloneable).setOpSet(opSet);
                opSet._zoneVec.addElement((StorageZone)cloneable);
            }
            opSet._nextZoneIndex = this._nextZoneIndex;
            if (this._decisionSch != null) {
                opSet._decisionSch = (DecisionSch)this._decisionSch.clone();
            }
            opSet._capacitySchedule = (CapacitySchedule)this._capacitySchedule.clone();
            if (this._creditResRefVec != null) {
                opSet._creditResRefVec = new Vector(this._creditResRefVec.size());
                for (n = 0; n < this._creditResRefVec.size(); ++n) {
                    cloneable22 = (CreditReservoirRef)this._creditResRefVec.get(n);
                    opSet._creditResRefVec.add(((CreditReservoirRef)cloneable22).clone());
                }
            }
            if (this._storageCredit != null) {
                opSet._storageCredit = this._storageCredit.clone();
            }
            if (this._releaseAllocationTable != null) {
                opSet._releaseAllocationTable = new Hashtable();
                for (Cloneable cloneable22 : this._releaseAllocationTable.keySet()) {
                    cloneable = (ReleaseAllocation)this._releaseAllocationTable.get(cloneable22);
                    opSet._releaseAllocationTable.put(new intContainer(((intContainer)cloneable22).value), ((ReleaseAllocation)cloneable).clone());
                }
            }
            opSet._compProjElevHours = this._compProjElevHours;
            opSet._useProjectedResElevForOpZone = this._useProjectedResElevForOpZone;
            opSet._computingProjectedElevation = this._computingProjectedElevation;
            opSet._useStorageScale = this._useStorageScale;
            opSet._storageScale = this._storageScale;
            return opSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    void updateRuleRefTables() {
        if (this._contollerZoneRulesTable == null) {
            return;
        }
        if (this._intContainer == null) {
            this._intContainer = new intContainer();
        }
        int n = this._zoneVec.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            int n2;
            StorageZone storageZone = this._zoneVec.get(i);
            if (storageZone == null) continue;
            storageZone.setOpSet(this);
            Vector<OpController> vector = this._resOp.getControllers();
            Vector vector2 = new Vector();
            int n3 = vector.size();
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                object2 = vector.elementAt(n2);
                if (object2 == null) continue;
                this._intContainer.value = n4 = object2.getIndex();
                object = (OpControllerZones)this._contollerZoneRulesTable.get(this._intContainer);
                if (object == null) continue;
                object2 = ((OpControllerZones)object).getZoneRuleRefs(storageZone, null);
                int n5 = ((Vector)object2).size();
                for (int j = 0; j < n5; ++j) {
                    OpRuleRef opRuleRef = (OpRuleRef)((Vector)object2).get(j);
                    if (opRuleRef == null) continue;
                    opRuleRef.setOpControllerIndex(n4);
                }
                vector2.addAll(object2);
            }
            if (this._zoneRuleTable != null) {
                this._intContainer.value = storageZone.getIndex();
                object2 = (StorageZoneRules)this._zoneRuleTable.get(this._intContainer);
                if (object2 != null) {
                    List list = ((StorageZoneRules)object2).getSortedZoneObjects(true);
                    vector2.addAll(list);
                }
            }
            object2 = new Vector();
            Vector<List<ZoneObject>> vector3 = new Vector<List<ZoneObject>>();
            n3 = vector2.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object = (ZoneObject)vector2.get(n2);
                if (object == null) continue;
                ((Vector)object2).add(new Float(object.getPriority()));
                vector3.add((List<ZoneObject>)object);
            }
            RMASort.quickSort((List)object2, vector3, (boolean)true);
            object = storageZone.getZoneObjectsList();
            object.addAll(vector3);
            n3 = object.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object2 = object.get(n2);
                if (object2 == null) continue;
                object2.setParent(storageZone);
            }
        }
        this._contollerZoneRulesTable = null;
        this._zoneRuleTable = null;
        this.setModified(true);
    }

    public boolean computingProjectedElevation() {
        return this._computingProjectedElevation;
    }

    public void setComputeProjectedElevation(boolean bl) {
        this._computingProjectedElevation = bl;
    }

    public void setCompProjElevHours(int n) {
        this._compProjElevHours = n;
    }

    public int getCompProjElevHours() {
        return this._compProjElevHours;
    }

    public void setUseProjectedResElevForOpZone(boolean bl) {
        this._useProjectedResElevForOpZone = bl;
    }

    public boolean useProjectedResElevForOpZone() {
        return this._useProjectedResElevForOpZone;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        org.jdom.Element element2;
        Object object;
        int n;
        org.jdom.Element element3;
        Object object2;
        element.setAttribute("Name", this._name);
        element.setAttribute("Description", this._description);
        List<OpRule> list = new ArrayList<OpRule>();
        new ArrayList();
        ArrayList<Object> arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_ZONES).a()) {
            object2 = this.getSortedZoneVector();
            element3 = new org.jdom.Element("Zones");
            element.addContent((Content)element3);
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                object = ((Vector)object2).get(n);
                element2 = new org.jdom.Element("Zone");
                element3.addContent((Content)element2);
                ((StorageZone)object).outputReport(alternativeInputReport, element2);
                list = ((StorageZone)object).getRules(list);
                arrayList.addAll(((StorageZone)object).getConditionalBlockRefs(arrayList));
                ((StorageZone)object).getReferencedStateVariables(arrayList2);
            }
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_IF_THEN_ELSE).a() && !arrayList.isEmpty()) {
            element3 = new org.jdom.Element("Conditionals");
            element.addContent((Content)element3);
            object2 = new ArrayList();
            for (n = 0; n < arrayList.size(); ++n) {
                object = (ConditionalBlockRef)arrayList.get(n);
                if (object2.contains(object)) continue;
                object2.add(object);
                element2 = new org.jdom.Element("Conditional");
                element3.addContent((Content)element2);
                ((ConditionalBlockRef)object).outputReport(alternativeInputReport, element2);
                list.addAll(((ConditionalBlockRef)object).getRuleRefs());
            }
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_RULES).a()) {
            object = new ArrayList();
            object2 = null;
            element3 = new org.jdom.Element("Rules");
            element.addContent((Content)element3);
            for (n = 0; n < list.size(); ++n) {
                arrayList = list.get(n);
                if (arrayList instanceof OpRule) {
                    object2 = (OpRule)((Object)arrayList);
                } else if (arrayList instanceof OpRuleRef) {
                    object2 = ((OpRuleRef)((Object)arrayList)).getRule();
                }
                if (object.contains(object2)) continue;
                object.add(object2);
                element2 = new org.jdom.Element("Rule");
                element3.addContent((Content)element2);
                if (object2 instanceof ReleaseFuncOpRule) {
                    ((OpRule)((ReleaseFuncOpRule)object2)).outputReport(alternativeInputReport, element2);
                    continue;
                }
                if (object2 instanceof DownstreamCntrlOpRule) {
                    ((OpRule)((DownstreamCntrlOpRule)object2)).outputReport(alternativeInputReport, element2);
                    continue;
                }
                if (object2 instanceof InducedSurchargeOpRule) {
                    ((OpRule)((InducedSurchargeOpRule)object2)).outputReport(alternativeInputReport, element2);
                    continue;
                }
                if (object2 instanceof TandemOpRule) {
                    ((OpRule)((TandemOpRule)object2)).outputReport(alternativeInputReport, element2);
                    continue;
                }
                if (object2 instanceof TandemSysOpRule) continue;
                if (object2 instanceof RateChangeLimitOpRule) {
                    ((OpRule)((RateChangeLimitOpRule)object2)).outputReport(alternativeInputReport, element2);
                    continue;
                }
                if (object2 instanceof ScriptOpRule) {
                    ((OpRule)((ScriptOpRule)object2)).outputReport(alternativeInputReport, element2);
                    continue;
                }
                if (object2 instanceof PowerGuideCurveOpRule) {
                    ((OpRule)((PowerGuideCurveOpRule)object2)).outputReport(alternativeInputReport, element2);
                    continue;
                }
                if (object2 instanceof ScheduledHydropowerOpRule) {
                    ((OpRule)((ScheduledHydropowerOpRule)object2)).outputReport(alternativeInputReport, element2);
                    continue;
                }
                if (object2 instanceof SystemHydropowerOpRule) {
                    ((OpRule)((SystemHydropowerOpRule)object2)).outputReport(alternativeInputReport, element2);
                    continue;
                }
                if (object2 instanceof PeakingPowerTsOpRule) {
                    ((OpRule)((PeakingPowerTsOpRule)object2)).outputReport(alternativeInputReport, element2);
                    continue;
                }
                if (!(object2 instanceof PumpOpRule)) continue;
                ((OpRule)((PumpOpRule)object2)).outputReport(alternativeInputReport, element2);
            }
            element2 = new org.jdom.Element("DefaultDownstreamOptions");
            element.addContent((Content)element2);
            DownstreamOptions downstreamOptions = ((RssTSLocationObject)this).getSystem().getDefaultDownstreamOptions();
            if (downstreamOptions._useLaggedSpaceAdj) {
                element2.setAttribute("CorrectionForAtteniation", "Option1_LaggedSpaceAdj");
                element2.setAttribute("MaxIterations", Integer.toString(downstreamOptions._lagMaxIterations));
                element2.setAttribute("AbsoluteFlowTol", Double.toString(downstreamOptions._lagFlowTolerance));
                element2.setAttribute("TolFractionLimit", Double.toString(downstreamOptions._lagFractionLimit));
            } else if (downstreamOptions._usePredictor) {
                element2.setAttribute("CorrectionForAtteniation", "Option2_PredictorCorrector");
                element2.setAttribute("MaxIterations", Integer.toString(downstreamOptions._predictorMaxIterations));
                element2.setAttribute("CorrectionFactor", Double.toString(downstreamOptions._predictorCorrectionFactor));
            } else {
                element2.setAttribute("CorrectionForAtteniation", "Option3_NoCorrection");
            }
            element2.setAttribute("ConsiderROC_Constraints", Boolean.toString(downstreamOptions._useConsiderROC));
            if (downstreamOptions._useConsiderROC) {
                element2.setAttribute("MaxLookahead", Integer.toString(downstreamOptions._maxLookaheadROC));
            }
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.STATE_VARIABLES).a()) {
            element3 = new org.jdom.Element("StateVariables");
            element.addContent((Content)element3);
            for (int i = 0; i < arrayList2.size(); ++i) {
                object = (StateVariable)arrayList2.get(i);
                element2 = new org.jdom.Element("StateVariable");
                element3.addContent((Content)element2);
                ((StateVariable)object).outputReport(alternativeInputReport, element2);
            }
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_RELEASE_ALLOCATION).a() && this._hasUserDefinedReleaseAllocation) {
            object = this._releaseAllocationTable.keySet().toArray();
            element3 = new org.jdom.Element("ReleaseAllocations");
            element.addContent((Content)element3);
            for (int i = 0; i < ((Object)object).length; ++i) {
                Object object3 = object[i];
                arrayList = this._releaseAllocationTable.get(object3);
                if (!(arrayList instanceof ReleaseAllocation)) continue;
                element2 = new org.jdom.Element("ReleaseAllocation");
                element3.addContent((Content)element2);
                ((ReleaseAllocation)((Object)arrayList)).outputReport(alternativeInputReport, element2);
            }
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_OUTAGES).a() && this._hasCapacityOutages) {
            element2 = new org.jdom.Element("CapacityOutages");
            element.addContent((Content)element2);
            this._capacitySchedule.outputReport(alternativeInputReport, element2);
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_STORAGE_CREDIT).a() && this._useStorageCredit) {
            element2 = new org.jdom.Element("StorageCredit");
            element.addContent((Content)element2);
            if (this._storageCredit.hasSeasonalVariation()) {
                element3 = new org.jdom.Element("AvaliableCredit");
                element2.addContent((Content)element3);
                XMLUtilities.createArrayElements((org.jdom.Element)element3, (double[])this._storageCredit.getXArray());
                for (int i = 0; i < this._storageCredit.getNumberCurves(); ++i) {
                    object = this._storageCredit.getCurve(i);
                    element3 = new org.jdom.Element("StorageCredit" + i);
                    element2.addContent((Content)element3);
                    XMLUtilities.createArrayElements((org.jdom.Element)element3, (double[])object.getYArray());
                }
            } else {
                element3 = new org.jdom.Element("AvaliableCredit");
                element2.addContent((Content)element3);
                XMLUtilities.createArrayElements((org.jdom.Element)element3, (double[])this._storageCredit.getXArray());
                element3 = new org.jdom.Element("StorageCredit");
                element2.addContent((Content)element3);
                XMLUtilities.createArrayElements((org.jdom.Element)element3, (double[])this._storageCredit.getYArray());
            }
            this.getStorageCredit();
            for (int i = 0; i < this._creditResRefVec.size(); ++i) {
                CreditReservoirRef creditReservoirRef = (CreditReservoirRef)this._creditResRefVec.get(i);
                element3 = new org.jdom.Element("CreditReservoirRef");
                element2.addContent((Content)element3);
                creditReservoirRef.outputReport(alternativeInputReport, element3);
            }
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_DECISION_SCHEDULE).a() && this._hasDecisionSchedule) {
            element2 = new org.jdom.Element("DecisionSchdule");
            element.addContent((Content)element2);
            this._decisionSch.outputReport(alternativeInputReport, element2);
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_PROJECTED_ELEVATION).a() && this._computingProjectedElevation) {
            element2 = new org.jdom.Element("ProjectedEvlevation");
            element.addContent((Content)element2);
            element2.setAttribute("TimeWindow", Integer.toString(this._compProjElevHours));
            element2.setAttribute("UseProjectedResElev", Boolean.toString(this._useProjectedResElevForOpZone));
        }
    }
}

