/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.Manager;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.model.TSManager;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.ControlStructure;
import hec.rss.model.Controller;
import hec.rss.model.Element;
import hec.rss.model.ReleaseOverrides;
import hec.rss.model.RssSystem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Vector;
import rma.util.RMAIO;

public class Operations
extends Manager
implements TSManager {
    Vector controllerVector = new Vector();
    private transient RssSystem a = null;
    private transient TSDataSet b = null;
    private transient TSDataSet c = null;
    private transient ReleaseOverrides d = null;

    public void init() {
    }

    public RssSystem getSystem() {
        return this.a;
    }

    public void setReleaseOverrides(ReleaseOverrides releaseOverrides) {
        this.d = releaseOverrides;
    }

    public ReleaseOverrides getReleaseOverrides() {
        return this.d;
    }

    public Element findElement(String string) {
        return this.a.findElement(string);
    }

    public AdjustableParameter findAdjParam(String string, String string2, String string3) {
        return this.a.findAdjParam(string, string2, string3);
    }

    public double[] findTSArray(String string, String string2, String string3) {
        return this.a.findTSArray(string, string2, string3);
    }

    public void setSystem(RssSystem rssSystem) {
        this.a = rssSystem;
    }

    public void setInputTSDataSet(TSDataSet tSDataSet) {
        this.b = tSDataSet;
    }

    public TSDataSet getInputTSDataSet() {
        return this.b;
    }

    public void setOutputTSDataSet(TSDataSet tSDataSet) {
        this.c = tSDataSet;
    }

    public TSDataSet getOutputTSDataSet() {
        return this.c;
    }

    public boolean initialize(RssSystem rssSystem, TSDataSet object, TSDataSet tSDataSet, ReleaseOverrides releaseOverrides) {
        this.a = rssSystem;
        this.b = object;
        this.c = tSDataSet;
        this.d = releaseOverrides;
        for (int i = 0; i < this.controllerVector.size(); ++i) {
            object = (Controller)((Object)this.controllerVector.elementAt(i));
            if (object == null) continue;
            object.initialize();
        }
        return true;
    }

    public void addController(Controller controller) {
        if (controller == null) {
            return;
        }
        this.controllerVector.addElement(controller);
    }

    public boolean removeController(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < this.controllerVector.size(); ++i) {
            Controller controller = (Controller)((Object)this.controllerVector.elementAt(i));
            if (controller == null || !string.equals(controller.getAdjParamElementName())) continue;
            this.controllerVector.removeElement((Object)controller);
            return true;
        }
        return false;
    }

    public Controller getController(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        for (int i = 0; i < this.controllerVector.size(); ++i) {
            Controller controller = (Controller)((Object)this.controllerVector.elementAt(i));
            if (controller == null || !string.equals(controller.getAdjParamElementName())) continue;
            return controller;
        }
        return null;
    }

    public Controller createController(ControlStructure controlStructure, NamedType namedType) {
        Controller controller = new Controller(this);
        controller.setIndex(this.controllerVector.size());
        controller.setName(namedType.getName() + ";" + controlStructure.getElement().getName());
        controller.setAdjParamData(namedType.getName() + ";" + controlStructure.getElement().getName(), controlStructure.getName(), "Flow");
        this.controllerVector.addElement(controller);
        return controller;
    }

    public Vector getControllerVector() {
        return this.controllerVector;
    }

    public Vector getTSRecordProxies() {
        return this.getTSRecordProxies(true);
    }

    public Vector getTSRecordProxies(boolean bl) {
        Vector vector = new Vector();
        for (int i = 0; i < this.controllerVector.size(); ++i) {
            Object object = (Controller)((Object)this.controllerVector.elementAt(i));
            if (object == null || (object = object.getTSRecordProxies(bl)) == null) continue;
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                TSRecordProxy tSRecordProxy = (TSRecordProxy)((Vector)object).elementAt(j);
                if (tSRecordProxy == null) continue;
                vector.addElement(((Vector)object).elementAt(j));
            }
        }
        return vector;
    }

    public boolean readFile(Identifier object) {
        int n = -1;
        HecFile hecFile = object.getFile();
        System.out.println("opening " + hecFile.getPath());
        try {
            object = hecFile.getBufferedReader();
            String string = ((BufferedReader)object).readLine();
            while (string != null) {
                int n2;
                if (string.length() == 0) {
                    string = ((BufferedReader)object).readLine();
                    continue;
                }
                String string2 = RMAIO.getType((String)string, (String)"=");
                string = RMAIO.getParam((String)string, (String)"=");
                if (string2.compareTo("Operations Name") == 0) {
                    this.setName(string);
                } else if (string2.compareTo("Description") == 0) {
                    string2 = string.replace('|', '\n');
                    this.setDescription(string2);
                } else if (string2.compareTo("ModifiedTime") == 0) {
                    try {
                        this.setLastModifiedTime(Long.parseLong(string));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string2.compareTo("Controller") == 0 && (n2 = RMAIO.parseInt((String)string)) != Integer.MIN_VALUE) {
                    int n3 = this.controllerVector.size();
                    if (n2 + 1 > n3) {
                        this.controllerVector.setSize(n2 + 50);
                    }
                    if (this.controllerVector.elementAt(n2) != null) {
                        this.printMessage("Warning! Duplicate Controller " + n2 + " ignored.");
                    } else {
                        Controller controller = new Controller(this, n2);
                        if (controller.readData((BufferedReader)object)) {
                            this.controllerVector.setElementAt(controller, n2);
                            if (n2 > n) {
                                n = n2;
                            }
                        } else {
                            this.printMessage("Error reading data for Controller " + n2);
                        }
                    }
                }
                string = ((BufferedReader)object).readLine();
            }
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {
            this.printMessage("Failed to open file " + hecFile.getPath());
            return false;
        }
        this.controllerVector.setSize(++n);
        this.controllerVector.trimToSize();
        this.printMessage("Operations Dimensions:\n" + n + " Controllers");
        return true;
    }

    public boolean writeFile(Identifier identifier) {
        super.writeFile(identifier);
        HecFile hecFile = identifier.getFile();
        System.out.println("writing " + hecFile.getPath());
        this.setReloadOk(false);
        try {
            BufferedWriter bufferedWriter = hecFile.getBufferedWriter();
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Operations Name=" + this.getName()));
            String string = this.getDescription().replace('\n', '|');
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Description=" + string));
            this.writeLastModTime(bufferedWriter);
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
            for (int i = 0; i < this.controllerVector.size(); ++i) {
                Controller controller = (Controller)((Object)this.controllerVector.elementAt(i));
                if (controller == null) continue;
                controller.writeData(bufferedWriter);
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            hecFile.save();
        }
        catch (IOException iOException) {
            this.setReloadOk(true);
            this.printMessage("Failed to open file " + identifier.getPath());
            return false;
        }
        this.setModified(false);
        this.setReloadOk(true);
        return true;
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get((Object)this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set((Object)this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

