/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.lang.NamedType;
import hec.model.PairedValuesExt;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.Element;
import hec.rss.model.ForebayHeadLoss;
import hec.rss.model.FunctionFactory;
import hec.rss.model.Junction;
import hec.rss.model.PowerPlantFlow;
import hec.rss.model.PumpFlow;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirUtilities;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.Spillway;
import hec.rss.model.TailElevContainer;
import hec.rss.model.TailwaterElevation;
import hec.rss.model.reports.AltInputReportEnums;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import java.util.Vector;
import org.jdom.Content;

public class OutletGroupElement
extends Element
implements TailElevContainer,
AltInputReportInfc {
    public static final int TAILWATER_CHILD_ID = 0;
    private transient PairedValuesExt a;

    public OutletGroupElement() {
    }

    public OutletGroupElement(RssSystem rssSystem, int n) {
        super(rssSystem, n);
    }

    @Override
    public void setupForSerialization() {
        super.setupForSerialization();
    }

    public PairedValuesExt getCompositeRelease() {
        this.a = ReservoirUtilities.a(this);
        return this.a;
    }

    public void buildDefaultElements() {
        this.removeAllChildElements();
        Element element = this._system.newElement(false);
        element.setName(this._system.getKeyStringForObject(this));
        Element element2 = element;
        element2.setFunction(FunctionFactory.a(element2, "Junction"));
        super.addChildElement(element);
    }

    @Override
    public void addNode(RssNode rssNode, int n) {
        if (this._nodeVector.contains(rssNode)) {
            return;
        }
        super.addNode(rssNode, n);
        if (this._parentElement != null && n == 1) {
            this._parentElement.addNode(rssNode, n);
        }
        if (this._elemVector.size() <= 0) {
            return;
        }
        if (n == 0) {
            Element element = this._elemVector.elementAt(0);
            element.addNode(rssNode, n);
        }
    }

    @Override
    public void addChildElement(Element element) {
        Element element2;
        RssNode rssNode;
        if (element == null) {
            return;
        }
        super.addChildElement(element);
        if (!(element instanceof OutletGroupElement)) {
            rssNode = this._system.newNode();
            element2 = ((ReservoirElement)this.getTopParent()).getStorageElement();
            element2.addNode(rssNode, 0);
            ((Element)this).addNode(rssNode, 1);
            element.addNode(rssNode, 1);
            rssNode.setName(this._system.getKeyStringForObject(element) + "~" + "IN");
        }
        element2 = this._elemVector.elementAt(0);
        rssNode = this._system.newNode();
        element.addNode(rssNode, 0);
        element2.addNode(rssNode, 1);
    }

    Element getStorageElement() {
        Element element = this;
        while (element.getParent() != null) {
            if (!((element = element.getParent()) instanceof ReservoirElement)) continue;
            return ((ReservoirElement)element).getStorageElement();
        }
        return null;
    }

    @Override
    public synchronized Object clone() {
        OutletGroupElement outletGroupElement = (OutletGroupElement)super.clone();
        ((OutletGroupElement)super.clone()).a = null;
        return outletGroupElement;
    }

    public Junction getTailwaterFunction() {
        if (this._elemVector.size() <= 0) {
            return null;
        }
        Element element = this._elemVector.elementAt(0);
        if (element == null || !(element.getFunction() instanceof Junction)) {
            return null;
        }
        return (Junction)element.getFunction();
    }

    public Element getTailwaterElement() {
        if (this._elemVector.size() <= 0) {
            return null;
        }
        return this._elemVector.elementAt(0);
    }

    @Override
    public TailwaterElevation getTailwaterElevation() {
        Junction junction = this.getTailwaterFunction();
        if (junction == null) {
            return null;
        }
        return junction.getTailwaterElevation();
    }

    @Override
    public void setHasTailElev(boolean bl) {
        Junction junction = this.getTailwaterFunction();
        if (junction == null) {
            return;
        }
        junction.setHasTailElev(bl);
    }

    @Override
    public boolean hasTailElev() {
        Junction junction = this.getTailwaterFunction();
        if (junction == null) {
            return false;
        }
        return junction.hasTailElev();
    }

    public boolean hasPowerPlant() {
        Vector vector = this.getElementsByClass(AdjustableFlow.class, null);
        for (int i = 0; i < vector.size(); ++i) {
            NamedType namedType = (Element)vector.elementAt(i);
            if (!((AdjustableFlow)(namedType = (AdjustableFlow)namedType.getFunction())).hasPowerPlant()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        org.jdom.Element element2;
        Cloneable cloneable;
        element.setAttribute("Name", this.getDisplayName());
        element.setAttribute("Description", this.getDescription());
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_TAILWATER).a() && (cloneable = this.getTailwaterElevation()) != null) {
            element2 = new org.jdom.Element("Tailwater");
            element.addContent((Content)element2);
            ((TailwaterElevation)cloneable).outputReport(alternativeInputReport, element2);
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_FOREBAY_HEADLOSS).a() && this.hasForebayHeadLoss() && (cloneable = this.getForebayHeadLoss()) != null) {
            element2 = new org.jdom.Element("ForebayHeadLoss");
            element.addContent((Content)element2);
            ((ForebayHeadLoss)cloneable).outputReport(alternativeInputReport, element2);
        }
        cloneable = this.getElementVector();
        for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
            Element element3 = (Element)((Vector)cloneable).get(i);
            if (element3 instanceof OutletGroupElement) {
                element2 = new org.jdom.Element("OutletGroup");
                element.addContent((Content)element2);
                ((OutletGroupElement)element3).outputReport(alternativeInputReport, element2);
            }
            element3.getFunction();
            if (element3.getFunction() instanceof PowerPlantFlow && alternativeInputReport.b().get((Object)AltInputReportEnums.RES_POWER_PLANT).a()) {
                element2 = new org.jdom.Element("Power_Plant");
                element.addContent((Content)element2);
                ((AdjustableFlow)element3.getFunction()).outputReport(alternativeInputReport, element2);
            } else if (element3.getFunction() instanceof PumpFlow && alternativeInputReport.b().get((Object)AltInputReportEnums.RES_PUMP).a()) {
                element2 = new org.jdom.Element("Pump");
                element.addContent((Content)element2);
                ((AdjustableFlow)element3.getFunction()).outputReport(alternativeInputReport, element2);
            } else if (element3.getFunction() instanceof Spillway && alternativeInputReport.b().get((Object)AltInputReportEnums.RES_UNCONTROLLED_OUTLET).a()) {
                element2 = new org.jdom.Element("Spillway");
                element.addContent((Content)element2);
                ((Spillway)element3.getFunction()).outputReport(alternativeInputReport, element2);
            } else if (element3.getFunction() instanceof AdjustableFlow && alternativeInputReport.b().get((Object)AltInputReportEnums.RES_CONTROLLED_OUTLET).a()) {
                element2 = new org.jdom.Element("Controlled_Outlet");
                element.addContent((Content)element2);
                ((AdjustableFlow)element3.getFunction()).outputReport(alternativeInputReport, element2);
            }
            if (element3._forebayHeadLoss == null) continue;
            element2 = new org.jdom.Element("Forebay");
            element.addContent((Content)element2);
            this._forebayHeadLoss.outputReport(alternativeInputReport, element2);
        }
    }
}

