/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.Manager;
import hec.io.Identifier;
import hec.rss.model.PDCDataSet$RecordBuilder;
import hec.rss.model.PDCRecord;
import hec.rss.model.PDCRecordImpl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import rma.util.RMAIO;

public class PDCDataSet
extends Manager {
    public static final String EXT = ".wqipd";
    public static final String DATASET = "PDCDataSet";
    public static final String NAME = "Name";
    public static final String DESCRIPTION = "Description";
    public static final String PDCRECORD = "PDCRecord";
    private final List<PDCRecord> _records = new ArrayList<PDCRecord>();

    public static void a(PDCRecord pDCRecord, PDCRecord pDCRecord2) {
        if (pDCRecord != null && pDCRecord2 != null) {
            if (pDCRecord2 instanceof PDCRecordImpl) {
                pDCRecord2 = (PDCRecordImpl)pDCRecord2;
                pDCRecord2.setName(pDCRecord.getName());
                pDCRecord2.setDescription(pDCRecord.getDescription());
                pDCRecord2.setIndex(pDCRecord.getIndex());
                ((PDCRecordImpl)pDCRecord2).setDSSFilename(pDCRecord.getDSSFilename());
                ((PDCRecordImpl)pDCRecord2).setDSSPathname(pDCRecord.getDSSPathname());
                ((PDCRecordImpl)pDCRecord2).setInput(pDCRecord.isInput());
                ((PDCRecordImpl)pDCRecord2).setParamName(pDCRecord.getParamName());
                ((PDCRecordImpl)pDCRecord2).setUnits(pDCRecord.getUnits());
                ((PDCRecordImpl)pDCRecord2).setVariableId(pDCRecord.getVariableId());
                ((PDCRecordImpl)pDCRecord2).setCurveIndex(pDCRecord.getCurveIndex());
                return;
            }
            throw new IllegalArgumentException("dstRec must be a PDCRecordImpl");
        }
    }

    public void init() {
    }

    public void clear() {
        this._records.clear();
    }

    public void addAll(List<PDCRecord> list) {
        this._records.addAll(list);
    }

    public List<PDCRecord> getAll() {
        return this._records;
    }

    public void addAll(PDCDataSet pDCDataSet) {
        this.addAll(pDCDataSet.getAll());
    }

    public void removeIfIsNull() {
        this._records.removeIf(Objects::isNull);
    }

    public PDCRecord getRecord(String string, String string2) {
        PDCRecord pDCRecord = null;
        if (string != null && !string.isEmpty() && string2 != null && !string2.isEmpty()) {
            for (PDCRecord pDCRecord2 : this._records) {
                if (pDCRecord2 == null || !string.equals(pDCRecord2.getName()) || !string2.equalsIgnoreCase(pDCRecord2.getParamName())) continue;
                pDCRecord = pDCRecord2;
                break;
            }
        }
        return pDCRecord;
    }

    public PDCRecord getRecord(String string, int n) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        for (PDCRecord pDCRecord : this._records) {
            if (pDCRecord == null || !string.equals(pDCRecord.getName()) || n != pDCRecord.getVariableId()) continue;
            return pDCRecord;
        }
        return null;
    }

    public PDCRecord getOrCreate(String string, int n, String string2) {
        PDCRecord pDCRecord = this.getRecord(string, n);
        if (pDCRecord == null) {
            pDCRecord = new PDCRecordImpl();
            pDCRecord.setIndex(this._records.size());
            pDCRecord.setName(string);
            ((PDCRecordImpl)pDCRecord).setVariableId(n);
            ((PDCRecordImpl)pDCRecord).setParamName(string2);
            this.add(pDCRecord);
        }
        return pDCRecord;
    }

    public void add(PDCRecord pDCRecord) {
        this._records.add(pDCRecord);
    }

    public boolean writeFile(Identifier identifier) {
        this.setReloadOk(false);
        identifier = identifier.getFile();
        if (identifier == null) {
            return false;
        }
        boolean bl = false;
        try {
            BufferedWriter bufferedWriter = identifier.getBufferedWriter();
            if (bufferedWriter != null) {
                this.writeLastModTime(bufferedWriter);
                bl = this.writeFile(identifier.getBufferedWriter());
            }
        }
        finally {
            identifier.save();
            this.setReloadOk(true);
        }
        if (bl) {
            this.setModified(false);
        }
        return bl;
    }

    public boolean writeFile(BufferedWriter bufferedWriter) {
        if (bufferedWriter == null) {
            return false;
        }
        try {
            bufferedWriter.write(String.format("%s %s=%s", DATASET, NAME, this.getName()));
            bufferedWriter.newLine();
            bufferedWriter.write(String.format("%s=%s", DESCRIPTION, this.getDescription()));
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            for (int i = 0; i < this._records.size(); ++i) {
                PDCRecord pDCRecord = this._records.get(i);
                if (pDCRecord == null) continue;
                bufferedWriter.write(String.format("%s=%s", PDCRECORD, Integer.toString(pDCRecord.getIndex())));
                bufferedWriter.newLine();
                pDCRecord.writeData(bufferedWriter);
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            this.printErrorMessage("Failed to write file");
            return false;
        }
        return true;
    }

    public boolean readFile(Identifier object) {
        if ((object = object.getFile()) == null) {
            return false;
        }
        boolean bl = this.readFile((BufferedReader)(object = object.getBufferedReader()));
        if (bl) {
            this.setModified(false);
        }
        return bl;
    }

    public boolean readFile(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            return false;
        }
        this._records.clear();
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() == 0) {
                    string = bufferedReader.readLine();
                    continue;
                }
                Object object = RMAIO.getType((String)string, (String)"=");
                string = RMAIO.getParam((String)string, (String)"=");
                if (String.format("%s %s", DATASET, NAME).equals(object)) {
                    this.setName(string);
                } else if (DESCRIPTION.equals(object)) {
                    string = string.replace('|', '\n');
                    this.setDescription(string);
                } else if ("ModifiedTime".equals(object)) {
                    this.setLastModifiedTime(RMAIO.parseLong((String)string, (long)Long.MAX_VALUE));
                } else if (PDCRECORD.equals(object)) {
                    int n = RMAIO.parseInt((String)string);
                    object = new PDCDataSet$RecordBuilder();
                    ((PDCDataSet$RecordBuilder)object).withIndex(n);
                    object = ((PDCDataSet$RecordBuilder)object).build();
                    if (object.readData(bufferedReader)) {
                        this._records.add((PDCRecord)object);
                    } else {
                        this.printErrorMessage("Error reading data for PDCRecord " + n);
                    }
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.printErrorMessage("Failed to open file ");
            return false;
        }
        return true;
    }

    public PDCRecord getPDCRecord(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return null;
        }
        for (int i = 0; i < this._records.size(); ++i) {
            PDCRecord pDCRecord = this._records.get(i);
            if (pDCRecord == null || !string.equals(pDCRecord.getName()) || !string2.equalsIgnoreCase(pDCRecord.getParamName())) continue;
            return pDCRecord;
        }
        return null;
    }

    public PDCRecord getPDCRecord(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        for (int i = 0; i < this._records.size(); ++i) {
            PDCRecord pDCRecord = this._records.get(i);
            if (pDCRecord == null || n != pDCRecord.getIndex() || n2 != pDCRecord.getVariableId()) continue;
            return pDCRecord;
        }
        return null;
    }
}

