/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import com.google.common.flogger.FluentLogger;
import hec.lang.NamedType;
import hec.rss.model.PDCRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Objects;
import rma.util.RMAIO;

public class PDCRecordImpl
extends NamedType
implements PDCRecord {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    public static final String REC = "PDCRecordImpl";
    public static final String NAME = "Name";
    public static final String DESCRIPTION = "Description";
    public static final String UNITS = "Units";
    public static final String INPUT = "Input";
    public static final String VARIABLE_ID = "VariableId";
    public static final String PARAM_NAME = "ParamName";
    public static final String DSS_FILENAME = "DssFilename";
    public static final String CURVE_INDEX = "CurveIndex";
    public static final String DSS_PATHNAME = "DssPathname";
    public static final String END = "End";
    boolean _isInput = false;
    private String _dssFilename;
    private String _dssPathname;
    private Integer _curveIndex;
    private String _paramName;
    private String _units;
    private int _varId;

    public void setInput(boolean bl) {
        this._isInput = bl;
    }

    @Override
    public void setDSSPathname(String string) {
        this._dssPathname = string;
    }

    @Override
    public void setDSSPathname(String[] stringArray) {
        if (stringArray.length < 6) {
            return;
        }
        Object object = "/";
        object = "/" + stringArray[0] + "/";
        object = (String)object + stringArray[1] + "/";
        object = (String)object + stringArray[2] + "/";
        object = (String)object + stringArray[3] + "/";
        object = (String)object + stringArray[4] + "/";
        this._dssPathname = object = (String)object + stringArray[5] + "/";
    }

    @Override
    public void setDSSFilename(String string) {
        this._dssFilename = string;
    }

    public void setParamName(String string) {
        this._paramName = string;
    }

    @Override
    public String getParamName() {
        return this._paramName;
    }

    public void setUnits(String string) {
        this._units = string;
    }

    public void setVariableId(int n) {
        this._varId = n;
    }

    @Override
    public int getVariableId() {
        return this._varId;
    }

    @Override
    public String getDSSPathname() {
        return this._dssPathname;
    }

    @Override
    public String getDSSFilename() {
        return this._dssFilename;
    }

    public void setCurveIndex(Integer n) {
        this._curveIndex = n;
    }

    @Override
    public Integer getCurveIndex() {
        return this._curveIndex;
    }

    @Override
    public String getUnits() {
        return this._units;
    }

    @Override
    public boolean isInput() {
        return this._isInput;
    }

    @Override
    public boolean writeData(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write(String.format("%s %s=%s", REC, NAME, this.getName()));
            bufferedWriter.newLine();
            bufferedWriter.write(String.format("%s %s=%s", REC, DESCRIPTION, this.getDescription()));
            bufferedWriter.newLine();
            bufferedWriter.write(String.format("%s %s=%s", REC, UNITS, this.getUnits()));
            bufferedWriter.newLine();
            bufferedWriter.write(String.format("%s %s=%s", REC, INPUT, this.isInput()));
            bufferedWriter.newLine();
            bufferedWriter.write(String.format("%s %s=%d", REC, VARIABLE_ID, this.getVariableId()));
            bufferedWriter.newLine();
            bufferedWriter.write(String.format("%s %s=%s", REC, PARAM_NAME, this.getParamName()));
            bufferedWriter.newLine();
            Integer n = this.getCurveIndex();
            if (n != null) {
                bufferedWriter.write(String.format("%s %s=%s", REC, CURVE_INDEX, n));
                bufferedWriter.newLine();
            }
            bufferedWriter.write(String.format("%s %s=%s", REC, DSS_FILENAME, this.getDSSFilename()));
            bufferedWriter.newLine();
            bufferedWriter.write(String.format("%s %s=%s", REC, DSS_PATHNAME, this.getDSSPathname()));
            bufferedWriter.newLine();
            bufferedWriter.write(String.format("%s %s=", REC, END));
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            ((FluentLogger.Api)((FluentLogger.Api)a.atWarning()).withCause((Throwable)iOException)).log("Failed write PDCRecordImpl");
            return false;
        }
        return true;
    }

    @Override
    public boolean readData(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() == 0) {
                    string = bufferedReader.readLine();
                    continue;
                }
                if (string.indexOf(REC) < 0) break;
                String string2 = RMAIO.getType((String)string, (String)"=");
                string = RMAIO.getParam((String)string, (String)"=").trim();
                if (string2.equals(String.format("%s %s", REC, NAME))) {
                    this.setName(string);
                } else if (string2.equals(String.format("%s %s", REC, DESCRIPTION))) {
                    this.setDescription(string);
                } else if (string2.equals(String.format("%s %s", REC, UNITS))) {
                    this.setUnits(string);
                } else if (string2.equals(String.format("%s %s", REC, INPUT))) {
                    this.setInput(RMAIO.parseBoolean((String)string, (boolean)false));
                } else if (string2.equals(String.format("%s %s", REC, VARIABLE_ID))) {
                    this.setVariableId(RMAIO.parseInt((String)string));
                } else if (string2.equals(String.format("%s %s", REC, PARAM_NAME))) {
                    this.setParamName(string);
                } else if (string2.equals(String.format("%s %s", REC, DSS_FILENAME))) {
                    this.setDSSFilename(string);
                } else if (string2.equals(String.format("%s %s", REC, CURVE_INDEX))) {
                    this.setCurveIndex(RMAIO.parseInt((String)string));
                } else if (string2.equals(String.format("%s %s", REC, DSS_PATHNAME))) {
                    this.setDSSPathname(string);
                } else if (string2.equals(String.format("%s %s", REC, END))) break;
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            ((FluentLogger.Api)((FluentLogger.Api)a.atWarning()).withCause((Throwable)iOException)).log("Failed read PDCRecordImpl");
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (PDCRecordImpl)object;
        return this._isInput == ((PDCRecordImpl)object)._isInput && this._varId == ((PDCRecordImpl)object)._varId && (Objects.equals(this._dssFilename, ((PDCRecordImpl)object)._dssFilename) || this._dssFilename != null && this._dssFilename.equalsIgnoreCase(((PDCRecordImpl)object)._dssFilename)) && (Objects.equals(this._dssPathname, ((PDCRecordImpl)object)._dssPathname) || this._dssPathname != null && this._dssPathname.equalsIgnoreCase(((PDCRecordImpl)object)._dssPathname)) && Objects.equals(this._curveIndex, ((PDCRecordImpl)object)._curveIndex) && (Objects.equals(this._paramName, ((PDCRecordImpl)object)._paramName) || this._paramName != null && this._paramName.equalsIgnoreCase(((PDCRecordImpl)object)._paramName));
    }

    public int hashCode() {
        return Objects.hash(this._isInput, this._dssFilename == null ? null : this._dssFilename.toLowerCase(), this._dssPathname == null ? null : this._dssPathname.toLowerCase(), this._curveIndex, this._paramName == null ? null : this._paramName.toLowerCase(), this._varId);
    }
}

