/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.model.RunTimeStep;
import hec.rss.model.ScheduledHydropowerOpRule;
import hec.rss.model.reports.AlternativeInputReport;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Vector;
import org.jdom.Element;

public class PeakingPowerTsOpRule
extends ScheduledHydropowerOpRule
implements AsciiSerializable,
Serializable,
Cloneable {
    private String _parameterName = "";
    private String _inputName = "";
    private transient doubleArrayContainer f;

    public PeakingPowerTsOpRule() {
    }

    public PeakingPowerTsOpRule(String string) {
        super(string);
    }

    public String getDisplayName() {
        return this._controller.getElementOp().getOperationsElement().getName() + " - " + this.getName();
    }

    @Override
    public void updateTSProxyList() {
        super.updateTSProxyList();
        TSRecordProxy tSRecordProxy = this.getTSRecordProxy(85);
        if (tSRecordProxy == null) {
            this.addTSRecordProxy(85);
        }
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        TSRecordProxy tSRecordProxy;
        vector = super.getActiveTSRecordProxies(vector, n);
        if (n == 1 && (tSRecordProxy = this.getTSRecordProxy(85)) != null) {
            vector.addElement(tSRecordProxy);
        }
        return vector;
    }

    @Override
    public boolean initializeCompute() {
        this.f = this.getTSContainer(85);
        if (this.f == null) {
            this._controller.getElementOp().getOperationsElement().getSystem().printErrorMessage("InputTSBasedOpRule.initializeCompute: Failed to load time series arrays");
            return false;
        }
        return super.initializeCompute();
    }

    @Override
    protected double getEnergyReguirement(RunTimeStep runTimeStep, double d) {
        double d2 = this.f.array[runTimeStep.step];
        if (this.useDemandScale()) {
            d2 *= this.getDemandScale();
        }
        double d3 = d2 * (double)runTimeStep.getTimeStepSeconds() / 3600.0;
        return d3;
    }

    @Override
    public Object clone() {
        PeakingPowerTsOpRule peakingPowerTsOpRule = (PeakingPowerTsOpRule)super.clone();
        return peakingPowerTsOpRule;
    }

    public String getInputName() {
        return this._inputName;
    }

    public void setInputName(String string) {
        this._inputName = string;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        element.setAttribute("Rule", "HydropowerTimeSeriesRequirement");
        super.outputReport(alternativeInputReport, element);
    }
}

