/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.doubleArrayContainer;
import hec.model.RunTimeStep;
import hec.rss.model.Element;
import hec.rss.model.OpControllableElement;
import hec.rss.model.OpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.Storage;
import rma.util.RMAConst;

public class PhysMaxOpRule
extends OpRule {
    private Storage _storageFunc;

    public PhysMaxOpRule() {
    }

    public PhysMaxOpRule(String string) {
        super(string);
    }

    @Override
    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
        if (this._storageFunc == null) {
            Element element = this._controller.getReleaseElement().getTopParent();
            if (!(element instanceof ReservoirElement)) {
                return;
            }
            this._storageFunc = ((ReservoirElement)element).getStorageFunction();
        }
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        dArray[0] = 0.0;
        dArray[1] = runTimeStep.getTimeStepSeconds();
        dArray2[0] = this._storageFunc.getPreviousElevationEst33(runTimeStep);
        dArray2[1] = this._storageFunc.getElevationEst33(runTimeStep);
        if (!RMAConst.isValidValue((double)dArray2[1])) {
            dArray2[1] = dArray2[0];
        }
        OpControllableElement opControllableElement = (OpControllableElement)this._controller._controllableVec.get(0);
        opControllableElement.recalcPhysicalLimits(runTimeStep, dArray, dArray2, 2);
        if (this.h == null) {
            this.h = new doubleArrayContainer(new double[runTimeStep.getTotalNumSteps() + 1]);
        }
        this.h.array[runTimeStep.step] = opControllableElement.a._maxValue;
    }

    @Override
    public int getRuleLimitType() {
        return 2;
    }
}

