/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.Parameter;
import hec.heclib.util.doubleArrayContainer;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.Controller;
import hec.rss.model.OpController;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Rule;
import hec.rss.model.Storage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class PoolElevation
extends Rule {
    PairedValues _poolValues = new PairedValues();
    String _resName = "";
    private transient doubleArrayContainer b;
    private transient Storage c;

    public PoolElevation() {
        this.setRuleType("Function of Pool Elevation");
    }

    @Deprecated
    public PoolElevation(Controller controller) {
        super(controller);
        this.setRuleType("Function of Pool Elevation");
    }

    public PoolElevation(OpController opController) {
        super(opController);
        this.setRuleType("Function of Pool Elevation");
    }

    public void setPoolValues(PairedValues pairedValues) {
        this._poolValues = pairedValues;
    }

    public PairedValues getPoolValues() {
        this._poolValues.setUnitSystem(this.getUnitSystem());
        this._poolValues.setParamXId(Parameter.PARAMID_ELEV);
        this._poolValues.setParamYId(Parameter.PARAMID_FLOW);
        return this._poolValues;
    }

    public void setReservoirName(String string) {
        this._resName = string;
    }

    public String getReservoirName() {
        return this._resName;
    }

    @Override
    public boolean initialize() {
        this.c = null;
        ReservoirElement reservoirElement = ((RssTSLocationObject)this.controller.getDiversionFunction()).getSystem().findReservoir(this._resName);
        if (reservoirElement != null && reservoirElement instanceof ReservoirElement) {
            this.c = reservoirElement.getStorageFunction();
        }
        if (this.c == null) {
            ((RssTSLocationObject)this.controller.getDiversionFunction()).getSystem().printErrorMessage("PoolElevation.initialize: Failed to find storage pool");
            ((RssTSLocationObject)this.controller.getDiversionFunction()).getSystem().printErrorMessage("Controller: " + this.controller.getName());
            return false;
        }
        this.b = this.c.getTSContainer(10);
        if (this.b == null) {
            ((RssTSLocationObject)this.controller.getDiversionFunction()).getSystem().printErrorMessage("PoolElevation.initialize: Failed to find elevation time series");
            ((RssTSLocationObject)this.controller.getDiversionFunction()).getSystem().printErrorMessage("Controller: " + this.controller.getName());
            return false;
        }
        return true;
    }

    @Override
    public double getValue(AdjustableParameter adjustableParameter, RunTimeStep runTimeStep, double d) {
        double d2 = this.b.array[runTimeStep.step];
        double d3 = this._poolValues.interpolateValue(d2);
        if (!RMAConst.isValidValue((double)d3)) {
            ((RssTSLocationObject)this.controller.getDiversionFunction()).getSystem().printErrorMessage("PoolElevation.getValue: invalid release calculation");
            ((RssTSLocationObject)this.controller.getDiversionFunction()).getSystem().printErrorMessage("Controller: " + this.controller.getName());
            ((RssTSLocationObject)this.controller.getDiversionFunction()).getSystem().printErrorMessage("Date and Time: " + runTimeStep.dateTimeString());
        }
        if (this.useDemandScale()) {
            return d3 * this.getDemandScale();
        }
        return d3;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public boolean writeData(BufferedWriter bufferedWriter) {
        String string = this.getRuleType();
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller Rule=" + string));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller " + string + " Name=" + this.getName()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller " + string + " resName=" + this._resName));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller " + string + " values=" + this._poolValues.getData()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller " + string + " End"));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        return true;
    }

    @Override
    public boolean readData(BufferedReader bufferedReader) {
        String string = this.getRuleType();
        try {
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.length() == 0) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                if (string2.indexOf("Controller " + string) < 0) break;
                String string3 = RMAIO.getType((String)string2, (String)"=");
                string2 = RMAIO.getParam((String)string2, (String)"=");
                if (string3.equals("Controller " + string + " Name")) {
                    this.setName(string2);
                } else if (string3.equals("Controller " + string + " resName")) {
                    this._resName = string2;
                } else if (string3.equals("Controller " + string + " values")) {
                    this._poolValues.setData(string2);
                } else if (string3.equals("Controller " + string + " End")) break;
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public PoolElevation clone() {
        PoolElevation poolElevation = (PoolElevation)super.clone();
        poolElevation.setPoolValues((PairedValues)this.getPoolValues().clone());
        return poolElevation;
    }
}

