/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.HecTime;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.SystemPwrGenerationPattern;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import rma.util.RMASort;

public class PowerGenerationPatternContainer
implements AsciiSerializable,
AltInputReportInfc,
Cloneable {
    boolean m_systemPwrGenSeasonal = false;
    Map m_pwrGenPatternTable = new Hashtable();
    private transient boolean a = false;
    private transient int[] b = null;
    private transient Hashtable<Object, PowerGenerationPatternContainer> c = null;

    public PowerGenerationPatternContainer() {
        this.createDefaultData();
    }

    public void setUseLocalGeneration(boolean bl) {
        this.a = bl;
    }

    public void setResIds(int[] nArray) {
        this.b = nArray;
    }

    public void setResPatternContainer(Hashtable<Object, PowerGenerationPatternContainer> hashtable) {
        this.c = hashtable;
    }

    public void fillPatternTSByLocal(RunTimeWindow runTimeWindow, double[] dArray) {
        if (runTimeWindow == null || dArray == null) {
            return;
        }
        if (this.b == null || this.c == null) {
            Arrays.fill(dArray, 1.0);
            return;
        }
        int n = runTimeWindow.getNumSteps();
        Arrays.fill(dArray, 0.0);
        int n2 = this.b.length;
        doubleArrayContainer[] doubleArrayContainerArray = new doubleArrayContainer[n2];
        for (int i = 0; i < n2; ++i) {
            doubleArrayContainerArray[i] = new doubleArrayContainer();
            doubleArrayContainerArray[i].array = new double[n + 1];
            PowerGenerationPatternContainer powerGenerationPatternContainer = this.c.get(new Integer(this.b[i]));
            if (powerGenerationPatternContainer != null) {
                powerGenerationPatternContainer.fillPatternTS(runTimeWindow, doubleArrayContainerArray[i].array);
            } else {
                Arrays.fill(doubleArrayContainerArray[i].array, 1.0);
            }
            for (int j = 0; j <= n; ++j) {
                int n3 = j;
                dArray[n3] = dArray[n3] + doubleArrayContainerArray[i].array[j];
            }
        }
    }

    public void fillPatternTS(RunTimeWindow runTimeWindow, double[] dArray) {
        if (this.a) {
            this.fillPatternTSByLocal(runTimeWindow, dArray);
            return;
        }
        if (runTimeWindow == null || dArray == null) {
            return;
        }
        int n = runTimeWindow.getNumSteps();
        if (dArray.length < n + 1) {
            n = dArray.length - 1;
        }
        int n2 = runTimeWindow.getTimeStepSeconds();
        int cfr_ignored_0 = 86400 / n2;
        HecTime hecTime = runTimeWindow.getTimeAtStep(0);
        double[] dArray2 = new double[24];
        this.getPatternForDay(hecTime, dArray2);
        int cfr_ignored_1 = 3600 / n2;
        int n3 = n2 / 3600;
        for (int i = 0; i <= n; ++i) {
            int n4;
            hecTime = runTimeWindow.getTimeAtStep(i);
            int n5 = hecTime.secondsSinceMidnight();
            if (n5 == 0) {
                n5 = 86400;
            }
            if (n5 == n2) {
                this.getPatternForDay(hecTime, dArray2);
            }
            if (n2 < 3600) {
                n4 = n5 / 3600;
                if (n5 % 3600 == 0) {
                    --n4;
                }
                dArray[i] = dArray2[n4];
                continue;
            }
            if (n2 == 3600) {
                n4 = n5 / n2 - 1;
                dArray[i] = dArray2[n4];
                continue;
            }
            dArray[i] = 0.0;
            n4 = n5 / n2 - 1;
            for (n5 = 0; n5 < n3; ++n5) {
                int n6 = i;
                dArray[n6] = dArray[n6] + dArray2[n4 * n3 + n5];
            }
        }
    }

    private void createDefaultData() {
        this.m_pwrGenPatternTable.put(new Integer(this.generateTime("01JAN")), new SystemPwrGenerationPattern());
    }

    public void setPwrGenPattern(String string, SystemPwrGenerationPattern systemPwrGenerationPattern) {
        if (string == null || systemPwrGenerationPattern == null) {
            return;
        }
        this.m_pwrGenPatternTable.put(new Integer(this.generateTime(string)), systemPwrGenerationPattern);
    }

    public void clearPwrGenPatterns() {
        try {
            this.m_pwrGenPatternTable.clear();
        }
        catch (Exception exception) {}
        this.createDefaultData();
    }

    public Map getPowerGenerationTable() {
        return this.m_pwrGenPatternTable;
    }

    public String[] getPwrGenPaternDates() {
        this.m_pwrGenPatternTable.keySet();
        int[] nArray = this.getPwrGenPatternTimes();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = HecTime.juldat((int)(nArray[i] / 1440), (int)4).substring(0, 5);
        }
        return stringArray;
    }

    public int[] getPwrGenPatternTimes() {
        Object object = this.m_pwrGenPatternTable.keySet();
        int[] nArray = new int[object.size()];
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            Integer n2 = (Integer)object.next();
            nArray[n++] = n2;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    private int generateTime(String string) {
        int[] nArray = new int[1];
        HecTime.datjul((String)(string + "1900"), (int[])nArray);
        return nArray[0] * 1440;
    }

    public SystemPwrGenerationPattern getPwrGenPattern(String string) {
        return (SystemPwrGenerationPattern)this.m_pwrGenPatternTable.get(new Integer(this.generateTime(string)));
    }

    public boolean isSystemPwrGenarationPatternSeasonal() {
        return this.m_systemPwrGenSeasonal;
    }

    public void setSystemPwrGenearationPatternSeasonal(boolean bl) {
        this.m_systemPwrGenSeasonal = bl;
    }

    public SystemPwrGenerationPattern getGenPatternForDay(HecTime object) {
        if (object == null) {
            return null;
        }
        int[] nArray = this.getPwrGenPatternTimes();
        if (!this.m_systemPwrGenSeasonal) {
            object = (SystemPwrGenerationPattern)this.m_pwrGenPatternTable.get(new Integer(nArray[0]));
        } else {
            int n = object.dayOfYear() * 1440 + object.minutesSinceMidnight();
            int n2 = 0;
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (n < nArray[i]) continue;
                n2 = i;
                break;
            }
            object = (SystemPwrGenerationPattern)this.m_pwrGenPatternTable.get(new Integer(nArray[n2]));
        }
        return object;
    }

    public boolean getPatternForDay(HecTime hecTime, double[] dArray) {
        if (hecTime == null) {
            return false;
        }
        if (dArray == null || dArray.length != 24) {
            return false;
        }
        SystemPwrGenerationPattern systemPwrGenerationPattern = this.getGenPatternForDay(hecTime);
        if (systemPwrGenerationPattern == null) {
            return false;
        }
        int n = RunTimeStep.getDayOfWeek((HecTime)hecTime) + 1;
        return systemPwrGenerationPattern.getPatternForDay(n, dArray);
    }

    public double[][] computePowerGenPattern(RunTimeStep runTimeStep, double d, int n, int n2, int n3, double d2, double d3, double d4, int n4, int n5) {
        SystemPwrGenerationPattern systemPwrGenerationPattern;
        HecTime hecTime = runTimeStep.getHecTime();
        int n6 = hecTime.dayOfYear() * 1440 + hecTime.minutesSinceMidnight();
        int[] nArray = this.getPwrGenPatternTimes();
        if (!this.m_systemPwrGenSeasonal) {
            systemPwrGenerationPattern = (SystemPwrGenerationPattern)this.m_pwrGenPatternTable.get(new Integer(nArray[0]));
        } else {
            int n7 = 0;
            if (n == 11 || n == 13) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    if (n6 < nArray[i]) continue;
                    n7 = i;
                    break;
                }
                systemPwrGenerationPattern = (SystemPwrGenerationPattern)this.m_pwrGenPatternTable.get(new Integer(nArray[n7]));
            } else {
                HecTime hecTime2 = new HecTime(hecTime);
                hecTime2.setTimeIncrement(3);
                int n8 = RunTimeStep.getDayOfWeek((HecTime)hecTime);
                n2 = n8 - n2;
                if (n2 < 0) {
                    n2 = 7 - n2;
                }
                hecTime2.subtract(n2);
                n2 = 0;
                for (n8 = 0; n8 < 7; ++n8) {
                    if (RunTimeStep.getDayOfWeek((HecTime)hecTime2) == n3) {
                        n2 = hecTime2.dayOfYear() * 1440 + hecTime2.minutesSinceMidnight();
                        break;
                    }
                    hecTime2.add(1);
                }
                for (n8 = nArray.length - 1; n8 >= 0; --n8) {
                    if (n2 < nArray[n8]) continue;
                    n7 = n8;
                    break;
                }
                systemPwrGenerationPattern = (SystemPwrGenerationPattern)this.m_pwrGenPatternTable.get(new Integer(nArray[n7]));
            }
        }
        return systemPwrGenerationPattern.computePowerGenerationPattern(runTimeStep, d, n, d2, d3, d4, n4, n5);
    }

    public double computePatternValueForStep(RunTimeStep runTimeStep, int n, int n2, int n3, double[] dArray, double[] dArray2, double d, double d2, int n4) {
        double[] dArray3 = this.getPattern(runTimeStep, n2, n3);
        n2 = dArray3.length / 24;
        n3 = runTimeStep.getTimeStepSeconds();
        int n5 = 86400 / n3;
        double[] dArray4 = new double[n2 * n5];
        n5 = n2 * n5;
        if (n3 == 3600) {
            System.arraycopy(dArray3, 0, dArray4, 0, dArray3.length);
        } else if (n3 < 3600) {
            var12_14 = 3600 / n3;
            for (n2 = 0; n2 < n5; ++n2) {
                dArray4[n2] = dArray3[n2 / var12_14] / (double)var12_14;
            }
        } else {
            var12_14 = n3 / 3600;
            for (n2 = 0; n2 < n5; ++n2) {
                dArray4[n2] = 0.0;
                for (n3 = 0; n3 < var12_14; ++n3) {
                    int n6 = n2;
                    dArray4[n6] = dArray4[n6] + dArray3[n3 + n2 * var12_14];
                }
            }
        }
        SystemPwrGenerationPattern systemPwrGenerationPattern = this.getGenPatternForDay(runTimeStep.getHecTime());
        if (systemPwrGenerationPattern == null) {
            return Double.NEGATIVE_INFINITY;
        }
        int n7 = systemPwrGenerationPattern.getPwrPatternAdjustMethod();
        if (n7 == 1) {
            PowerGenerationPatternContainer.a(dArray4, d2, n4, dArray4.length - n4, dArray, dArray2);
        } else {
            this.slidePattern(dArray4, d2, n4, dArray4.length - n4, dArray, dArray2);
        }
        return dArray4[n4];
    }

    public static void a(double[] dArray, double d, int n, int n2, double[] dArray2, double[] dArray3) {
        double d2;
        int n3;
        if (dArray == null || dArray2 == null || dArray3 == null) {
            System.out.println("PowerGenerationPatternContainer.scalePattern - missing pattern patmax or patmin");
            return;
        }
        int n4 = dArray.length;
        if (dArray2.length != n4 || dArray3.length != n4) {
            return;
        }
        if (n >= n4) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n + n2 < n4) {
            n4 = n + n2;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (n3 = n; n3 < n4; ++n3) {
            d5 += dArray[n3];
            d3 += dArray3[n3];
            d4 += dArray2[n3];
        }
        if (d5 <= 0.0) {
            dArray[n] = 1.0;
            d5 = 1.0;
        }
        if (d4 <= d) {
            System.arraycopy(dArray2, n, dArray, n, n4 - n);
            return;
        }
        if (d3 <= 0.0) {
            double d6 = d / d5;
            n3 = n;
            while (n3 < n4) {
                int n5 = n3++;
                dArray[n5] = dArray[n5] * d6;
            }
            PowerGenerationPatternContainer.a(dArray, dArray2, n, n2, d);
            return;
        }
        if (d3 >= d) {
            double d7 = d / d5;
            n3 = n;
            while (n3 < n4) {
                int n6 = n3++;
                dArray[n6] = dArray[n6] * d7;
            }
            PowerGenerationPatternContainer.a(dArray, dArray3, n, n2, d);
            return;
        }
        double[] dArray4 = new double[n4 - n];
        for (n3 = n; n3 < n4; ++n3) {
            dArray4[n3 - n] = dArray3[n3] == Double.NEGATIVE_INFINITY || dArray3[n3] < 0.0 ? -1.0 : (n3 < n || dArray[n3] <= 0.0 ? -1.0 : dArray3[n3] / dArray[n3]);
        }
        double[] dArray5 = new double[n4 - n];
        System.arraycopy(dArray, n, dArray5, 0, n4 - n);
        RMASort.quickSort((double[])dArray4, (double[])dArray5, (boolean)true);
        double[] dArray6 = new double[n4 - n];
        for (n3 = 0; n3 < n4 - n; ++n3) {
            if (dArray4[n3] < 0.0) {
                dArray5[n3] = 0.0;
            } else if (n3 > 0) {
                int n7 = n3;
                dArray5[n7] = dArray5[n7] + dArray5[n3 - 1];
            }
            dArray6[n3] = n3 == 0 ? d3 : dArray6[n3 - 1] + (dArray4[n3] - dArray4[n3 - 1]) * dArray5[n3 - 1];
        }
        for (n3 = 0; n3 < n4 - n - 1 && !(dArray6[n3 + 1] > d); ++n3) {
        }
        double d8 = (d - dArray6[n3]) / dArray5[n3] + dArray4[n3];
        if (d2 < 0.0) {
            n3 = n4 - n - 1;
            d8 = (d - dArray6[n3]) / dArray5[n3] + dArray4[n3];
        }
        for (n3 = n; n3 < n4; ++n3) {
            int n8 = n3;
            dArray[n8] = dArray[n8] * d8;
            if (!(dArray[n3] < dArray3[n3])) continue;
            dArray[n3] = dArray3[n3];
        }
        PowerGenerationPatternContainer.a(dArray, dArray2, n, n2, d);
    }

    public static void a(double[] dArray, double[] dArray2, int n, int n2, double d) {
        int n3 = dArray.length;
        if (n + n2 < n3) {
            n3 = n + n2;
        }
        for (n2 = n; n2 < n3; ++n2) {
            double cfr_ignored_0 = dArray[n2];
        }
        block1: for (n2 = n; n2 < n3; ++n2) {
            if (!(dArray[n2] > dArray2[n2])) continue;
            double d2 = dArray[n2] - dArray2[n2];
            dArray[n2] = dArray2[n2];
            int n4 = 0;
            while (d2 > 0.0 && n4++ < n3) {
                int n5 = n2;
                int n6 = -1;
                double d3 = 0.0;
                while (--n5 >= n) {
                    if (!(dArray[n5] < dArray2[n5])) continue;
                    n6 = n5;
                    d3 = dArray2[n5] - dArray[n5];
                    break;
                }
                n5 = n2;
                int n7 = -1;
                double d4 = 0.0;
                while (++n5 < n3) {
                    if (!(dArray[n5] < dArray2[n5])) continue;
                    n7 = n5;
                    d4 = dArray2[n5] - dArray[n5];
                    break;
                }
                if (n6 < 0 && n7 < 0) continue block1;
                if (n6 >= 0 && n7 >= 0) {
                    if (d3 + d4 < d2) {
                        dArray[n6] = dArray2[n6];
                        dArray[n7] = dArray2[n7];
                        d2 -= d3 + d4;
                        continue;
                    }
                    int n8 = n6;
                    dArray[n8] = dArray[n8] + d2 / 2.0;
                    if (dArray[n6] > dArray2[n6]) {
                        int n9 = n7;
                        dArray[n9] = dArray[n9] + (dArray2[n6] - dArray[n6]);
                        dArray[n6] = dArray2[n6];
                    }
                    int n10 = n7;
                    dArray[n10] = dArray[n10] + d2 / 2.0;
                    if (dArray[n7] > dArray2[n7]) {
                        int n11 = n6;
                        dArray[n11] = dArray[n11] + (dArray2[n7] - dArray[n7]);
                        dArray[n7] = dArray2[n7];
                    }
                    d2 = 0.0;
                    continue;
                }
                if (n6 >= 0) {
                    if (d2 <= d3) {
                        int n12 = n6;
                        dArray[n12] = dArray[n12] + d2;
                        d2 = 0.0;
                        continue;
                    }
                    int n13 = n6;
                    dArray[n13] = dArray[n13] + d3;
                    d2 -= d3;
                    continue;
                }
                if (d2 <= d4) {
                    int n14 = n7;
                    dArray[n14] = dArray[n14] + d2;
                    d2 = 0.0;
                    continue;
                }
                int n15 = n7;
                dArray[n15] = dArray[n15] + d4;
                d2 -= d4;
            }
        }
        for (n2 = n; n2 < n3; ++n2) {
            double cfr_ignored_1 = dArray[n2];
        }
    }

    void slidePattern(double[] dArray, double d, int n, int n2, double[] dArray2, double[] dArray3) {
        PowerGenerationPatternContainer.a(dArray, d, n, n2, dArray2, dArray3);
    }

    public double[] computeAdjustedPattern(double[] dArray, double d, double d2, double d3, int n, int n2) {
        return null;
    }

    public double[] getPattern(RunTimeStep object, int n, int n2) {
        double[] dArray;
        HecTime hecTime = object.getHecTime();
        if (n == 2) {
            object = new double[24];
            dArray = new double[168];
            int n3 = RunTimeStep.getDayOfWeek((HecTime)hecTime) + 1;
            n2 = n3 - n2;
            if (n2 < 0) {
                n2 -= 7;
            }
            hecTime = new HecTime(hecTime);
            n3 = hecTime.getTimeIncrement();
            int n4 = 1440;
            if (n3 == 3) {
                n4 = 1;
            } else if (n3 == 2) {
                n4 = 24;
            } else if (n3 == 1) {
                n4 = 1440;
            } else if (n3 == 0) {
                n4 = 86400;
            }
            hecTime.subtract(n4 * n2);
            for (n2 = 0; n2 < 7; ++n2) {
                this.getPatternForDay(hecTime, (double[])object);
                System.arraycopy(object, 0, dArray, n2 * 24, ((RunTimeStep)object).length);
                hecTime.add(n4);
            }
        } else {
            dArray = new double[24];
            this.getPatternForDay(object.getHecTime(), dArray);
        }
        return dArray;
    }

    public Object clone() {
        PowerGenerationPatternContainer powerGenerationPatternContainer;
        try {
            powerGenerationPatternContainer = (PowerGenerationPatternContainer)super.clone();
        }
        catch (Exception exception) {
            return null;
        }
        Object object = this.m_pwrGenPatternTable.keySet();
        object = object.iterator();
        Hashtable hashtable = new Hashtable();
        while (object.hasNext()) {
            Object e = object.next();
            SystemPwrGenerationPattern systemPwrGenerationPattern = (SystemPwrGenerationPattern)this.m_pwrGenPatternTable.get(e);
            hashtable.put(e, systemPwrGenerationPattern.clone());
        }
        powerGenerationPatternContainer.m_pwrGenPatternTable = hashtable;
        return powerGenerationPatternContainer;
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public void outputReport(AlternativeInputReport objectArray, Element element) {
        element.setAttribute("UseSeasonalVariation", Boolean.toString(this.m_systemPwrGenSeasonal));
        objectArray = this.m_pwrGenPatternTable.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof Integer)) continue;
            element.setAttribute("Date", ((Integer)object).toString());
            object = this.m_pwrGenPatternTable.get(object);
            if (object == null || !(object instanceof SystemPwrGenerationPattern)) continue;
            object = (SystemPwrGenerationPattern)object;
            element.setAttribute("Pattern_Type", Integer.toString(((SystemPwrGenerationPattern)object).m_patternType));
            element.setAttribute("Pattern_Adjustment_Method", Integer.toString(((SystemPwrGenerationPattern)object).m_pwrPatternAdjustMethod));
            Element element2 = new Element("Table");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((Element)element2, (double[][])((SystemPwrGenerationPattern)object).m_powerGenPattern);
        }
    }
}

