/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.model.SeasonalRecord;
import hec.rss.model.DayOfWeekMultiplier;
import hec.rss.model.OpSet;
import hec.rss.model.OperationsElement;
import hec.rss.model.PowerPlant;
import hec.rss.model.RssSystem;
import hec.rss.model.ScheduledHydropowerOpRule;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.jdom.Content;
import org.jdom.Element;
import rma.util.RMAConst;

public class PowerGuideCurveOpRule
extends ScheduledHydropowerOpRule
implements AsciiSerializable,
Serializable,
Cloneable {
    private PairedValues _powerGuideCurve = new PairedValues();
    private int _topStorageZoneId = Integer.MIN_VALUE;
    private int _bottomStorageZoneId = Integer.MIN_VALUE;
    private SeasonalRecord _seasonalMultiplier;
    private boolean _useSeasonalMultiplier = false;
    private boolean _generatePowerBelowPowerPool = true;
    private transient double f = 0.0;
    private transient int i = -1;
    private transient double[] j = new double[24];

    public PowerGuideCurveOpRule() {
    }

    public PowerGuideCurveOpRule(String string) {
        super(string);
    }

    @Override
    public boolean initializeCompute() {
        RssSystem rssSystem = this._controller.getElementOp().getOperationsElement().getSystem();
        if (!super.initializeCompute()) {
            return false;
        }
        if (this._topStorageZoneId == Integer.MIN_VALUE || this._bottomStorageZoneId == Integer.MIN_VALUE) {
            rssSystem.printErrorMessage("PowerGuideCurveOpRule.initializeCompute: Top and/or bottom power storage zones undefined.  Associated with " + this._controller.getName());
            return false;
        }
        this._generatePowerBelowPowerPool = true;
        return true;
    }

    public PairedValues getPowerGuideCurve() {
        this._powerGuideCurve.setUnitSystem(this.getUnitSystem());
        this._powerGuideCurve.setParamXId(-1);
        this._powerGuideCurve.setParamYId(-1);
        return this._powerGuideCurve;
    }

    public void setPowerGuideCurve(PairedValues pairedValues) {
        this._powerGuideCurve.setParamXId(-1);
        this._powerGuideCurve.setParamYId(-1);
        this._powerGuideCurve = pairedValues;
    }

    public void setTopPowerPoolStorageZoneId(int n) {
        this._topStorageZoneId = n;
    }

    public int getTopPowerPoolStorageZoneId() {
        return this._topStorageZoneId;
    }

    public void setBottomPowerPoolStorageZoneId(int n) {
        this._bottomStorageZoneId = n;
    }

    public int getBottomPowerPoolStorageZoneId() {
        return this._bottomStorageZoneId;
    }

    public void setGeneratePowerBelowPowerPool(boolean bl) {
        this._generatePowerBelowPowerPool = bl;
    }

    public boolean generatePowerBelowPowerPool() {
        return this._generatePowerBelowPowerPool;
    }

    private double getDailyFactor(RunTimeStep runTimeStep) {
        DayOfWeekMultiplier dayOfWeekMultiplier = this.getMultiplier();
        if (dayOfWeekMultiplier == null || !this.useDayOfWeekMultiplier()) {
            return 1.0;
        }
        return dayOfWeekMultiplier.getMultiplier(runTimeStep);
    }

    private double getHourlyFactor(RunTimeStep runTimeStep) {
        double d;
        int n = runTimeStep.getHecTime().hour();
        int n2 = runTimeStep.getHecTime().minute();
        double d2 = runTimeStep.getTimeStepMinutes();
        int n3 = (int)(d2 / 60.0 + 0.001);
        if (this._timeOfDayMultiplier == null || !this.useTimeOfDayMultiplier()) {
            return 1.0;
        }
        if (d2 <= 60.0) {
            int n4 = n;
            if (n2 > 0) {
                ++n4;
            }
            if ((n4 %= 24) == 0) {
                n4 = 24;
            }
            d = this._timeOfDayMultiplier.getHourlyMultiplier(n4);
        } else if (d2 >= 1440.0) {
            d = 1.0;
        } else {
            double d3 = 0.0;
            n -= n3;
            for (n2 = 0; n2 < n3; ++n2) {
                ++n;
                if ((n %= 24) == 0) {
                    n = 24;
                }
                double d4 = this._timeOfDayMultiplier.getHourlyMultiplier(n);
                d3 += d4;
            }
            d = d3 / (double)n3;
        }
        return d;
    }

    private double getHourlyFactor(RunTimeStep runTimeStep, double[] dArray) {
        double d;
        int n = runTimeStep.getHecTime().hour();
        int n2 = runTimeStep.getHecTime().minute();
        double d2 = runTimeStep.getTimeStepMinutes();
        int n3 = (int)(d2 / 60.0 + 0.001);
        if (d2 <= 60.0) {
            int n4 = n;
            if (n2 > 0) {
                ++n4;
            }
            if ((n4 %= 24) == 0) {
                n4 = 24;
            }
            d = dArray[n4 - 1];
        } else if (d2 >= 1440.0) {
            double d3 = 0.0;
            for (n = 0; n < 24; ++n) {
                double d4 = dArray[n];
                d3 += d4;
            }
            d = d3 / 24.0;
        } else {
            double d5 = 0.0;
            int n5 = n - n3;
            for (n = 0; n < n3; ++n) {
                ++n5;
                if ((n5 %= 24) == 0) {
                    n5 = 24;
                }
                double d6 = dArray[n5 - 1];
                d5 += d6;
            }
            d = d5 / (double)n3;
        }
        return d;
    }

    public SeasonalRecord getSeasonalMultiplier() {
        if (this._seasonalMultiplier == null) {
            this._seasonalMultiplier = new SeasonalRecord();
        }
        this._seasonalMultiplier.setUnitSystem(this.getUnitSystem());
        this._seasonalMultiplier.setParameterId(-1);
        this._seasonalMultiplier.setInterpolationType(2);
        return this._seasonalMultiplier;
    }

    public void setSeasonalMultiplier(SeasonalRecord seasonalRecord) {
        if (seasonalRecord == null) {
            return;
        }
        this._seasonalMultiplier = seasonalRecord;
        this._seasonalMultiplier.setUnitSystem(this.getUnitSystem());
        this._seasonalMultiplier.setParameterId(-1);
        this._seasonalMultiplier.setInterpolationType(2);
    }

    public boolean useSeasonalMultiplier() {
        return this._useSeasonalMultiplier;
    }

    public void setUseSeasonalMultiplier(boolean bl) {
        this._useSeasonalMultiplier = bl;
    }

    protected boolean canCompute() {
        Object object = this._controller.getElementOp().getActiveOpSet();
        NamedType namedType = ((OpSet)object).getZone(this._topStorageZoneId);
        object = ((OpSet)object).getZone(this._bottomStorageZoneId);
        OperationsElement operationsElement = this._controller.getElementOp().getOperationsElement();
        if (namedType == null || object == null) {
            System.out.println("PowerGuideCurveOpRule: top or bottom power storage zones undefined. Reservior " + operationsElement.getName() + ", Rule " + this.getName());
            return false;
        }
        if (this._powerGuideCurve == null || this._powerGuideCurve.size() <= 0) {
            System.out.println("PowerGuideCurveOpRule: power guide curve undefined. Reservior " + operationsElement.getName() + ", Rule " + this.getName());
            return false;
        }
        object = this.getPowerPlantList();
        if (object == null || object.isEmpty()) {
            System.out.println("PowerGuideCurveOpRule: no power plant assigned. Reservior " + operationsElement.getName() + ", Rule " + this.getName());
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            namedType = (PowerPlant)object.next();
            if (((PowerPlant)namedType).canCompute()) continue;
            System.out.println("PowerGuideCurveOpRule: Missing data for power plant. Reservior " + operationsElement.getName() + ", Rule " + this.getName());
            return false;
        }
        return true;
    }

    @Override
    protected double getEnergyReguirement(RunTimeStep runTimeStep, double d) {
        double d2;
        if (!this.canCompute()) {
            return 0.0;
        }
        HecTime hecTime = runTimeStep.getHecTime();
        hecTime.month();
        NamedType namedType = this._controller.getElementOp().getActiveOpSet();
        StorageZone storageZone = namedType.getZone(this._topStorageZoneId);
        namedType = namedType.getZone(this._bottomStorageZoneId);
        double d3 = storageZone.getElevation(runTimeStep);
        double d4 = namedType.getElevation(runTimeStep);
        if (d > d3) {
            d2 = this._powerGuideCurve.getYValue(this._powerGuideCurve.size() - 1);
        } else if (d < d4) {
            d2 = this._generatePowerBelowPowerPool ? this._powerGuideCurve.getYValue(0) : 0.0;
        } else {
            Storage storage = this._controller.getElementOp().getOperationsElement().getStorageFunction();
            double d5 = storage.elevationToStorage(d3);
            double d6 = storage.elevationToStorage(d4);
            double d7 = storage.getPreviousStorage(runTimeStep);
            double d8 = (d7 - d6) / (d5 - d6);
            d2 = this.getPlantFactor(d8 *= 100.0);
        }
        double d9 = 0.0;
        for (PowerPlant powerPlant : this.e) {
            d9 += powerPlant.getMaxCapacity(runTimeStep, d);
        }
        double d10 = d9;
        if (!RMAConst.isValidValue((double)d10)) {
            d10 = 0.0;
        }
        double cfr_ignored_0 = d10 * 24.0 * d2 / 100.0;
        double d11 = d10 * d2 / 100.0;
        this.m_patternContainer.getPatternForDay(hecTime, this.j);
        double d12 = this.getHourlyFactor(runTimeStep, this.j);
        double d13 = d11 * d12;
        double d14 = runTimeStep.getTimeStepSeconds();
        double d15 = d14 / 3600.0;
        return d13 *= d15;
    }

    @Deprecated
    protected double getEnergyReguirement2(RunTimeStep runTimeStep, double d) {
        int n;
        double d2;
        double d3;
        double d4;
        if (!this.canCompute()) {
            return 0.0;
        }
        HecTime hecTime = runTimeStep.getHecTime();
        hecTime.month();
        NamedType namedType = this._controller.getElementOp().getActiveOpSet();
        StorageZone storageZone = namedType.getZone(this._topStorageZoneId);
        namedType = namedType.getZone(this._bottomStorageZoneId);
        double d5 = storageZone.getElevation(runTimeStep);
        double d6 = namedType.getElevation(runTimeStep);
        if (d > d5) {
            d4 = this._powerGuideCurve.getYValue(this._powerGuideCurve.size() - 1);
        } else if (d < d6) {
            d4 = this._generatePowerBelowPowerPool ? this._powerGuideCurve.getYValue(0) : 0.0;
        } else {
            Storage storage = this._controller.getElementOp().getOperationsElement().getStorageFunction();
            double d7 = storage.elevationToStorage(d5);
            double d8 = storage.elevationToStorage(d6);
            double d9 = storage.getPreviousStorage(runTimeStep);
            d3 = (d9 - d8) / (d7 - d8);
            d4 = this.getPlantFactor(d3 *= 100.0);
        }
        double d10 = 0.0;
        for (PowerPlant powerPlant : this.e) {
            d10 += powerPlant.getMaxCapacity(runTimeStep, d);
        }
        if (!RMAConst.isValidValue((double)d10)) {
            d10 = 0.0;
        }
        double d11 = d10 * 24.0 * d4 / 100.0;
        double d12 = runTimeStep.getTimeStepSeconds();
        double[][] dArray = this.m_patternContainer.computePowerGenPattern(runTimeStep, d11, 11, 0, 0, d10, 0.0, 0.0, 1, 0);
        d3 = (double)(hecTime.minutesSinceMidnight() * 60) - d12;
        if (d2 < 0.0) {
            d3 += 86400.0;
        }
        if ((n = (int)Math.floor(d3 / 3600.0)) < 0 || n >= 24) {
            return 0.0;
        }
        double d13 = 0.0;
        double d14 = ((double)(n + 1) * 3600.0 - d3) / 3600.0;
        double d15 = runTimeStep.getTimeStepSeconds();
        int n2 = n;
        while (d15 > 0.0) {
            double d16 = dArray[0][n2];
            d13 += d16 * d14;
            double d17 = d14 = d15 >= 3600.0 ? 1.0 : (d15 -= 3600.0) / 3600.0;
            if (++n2 < 24) continue;
            n2 = 0;
        }
        return d13;
    }

    private double getPlantFactor(double d) {
        if (this._powerGuideCurve == null) {
            return 0.0;
        }
        double d2 = this._powerGuideCurve.interpolateValue(d);
        return d2;
    }

    @Override
    public Object clone() {
        PowerGuideCurveOpRule powerGuideCurveOpRule = (PowerGuideCurveOpRule)super.clone();
        return powerGuideCurveOpRule;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        super.outputReport(alternativeInputReport, element);
        element.setAttribute("Rule", "HydropowerPowerGuideCurve");
        element.setAttribute("ZoneAtTopOfPowerPoolID", Integer.toString(this.getTopPowerPoolStorageZoneId()));
        element.setAttribute("ZoneAtBottomOfPowerPoolID", Integer.toString(this.getBottomPowerPoolStorageZoneId()));
        Element element2 = new Element("PowerStorage");
        element.addContent((Content)element2);
        XMLUtilities.createArrayElements((Element)element2, (double[])this._powerGuideCurve.getYArray());
        element2 = new Element("PlantFactor");
        element.addContent((Content)element2);
        XMLUtilities.createArrayElements((Element)element2, (double[])this._powerGuideCurve.getXArray());
        element2 = new Element("PowerGenerationPattern");
        element.addContent((Content)element2);
        this.getPowerPatternContainer().outputReport(alternativeInputReport, element2);
    }
}

