/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.doubleArrayContainer;
import hec.io.DSSIdentifier;
import hec.lang.NamedType;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.RunTimeStep;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.Element;
import hec.rss.model.RSimDssPathPartGenerator;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Storage;
import hec.rss.model.TailElevContainer;
import hec.rss.model.TailwaterElevation;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Vector;
import org.jdom.Content;
import rma.util.RMAConst;

public class PowerPlant
extends NamedType
implements RssModelVariableConstants,
AltInputReportInfc {
    public static final int EFFC_CONST = 0;
    public static final int EFFC_BY_ELEV = 1;
    public static final int EFFC_BY_REL = 2;
    public static final int EFFC_BY_HEAD = 3;
    public static final int EFFC_BY_HILLCURVE = 4;
    public static final int SUSE_CONST = 0;
    public static final int SUSE_BY_REL = 1;
    public static final int HLOSS_CONST = 0;
    public static final int HLOSS_BY_REL = 1;
    public static final int CAPACITY_CONST = 0;
    public static final int CAPACITY_BY_ELEV = 1;
    public static final int CAPACITY_BY_STORAGE = 2;
    public static final int CAPACITY_BY_REL = 3;
    public static final int CAPACITY_BY_HEAD = 4;
    AdjustableFlow _adjustableFlow;
    double _capacity = Double.NEGATIVE_INFINITY;
    double _overload = Double.NEGATIVE_INFINITY;
    double _constEff = Double.NEGATIVE_INFINITY;
    double _constSUse = Double.NEGATIVE_INFINITY;
    double _constHUse = Double.NEGATIVE_INFINITY;
    PairedValues _capacityByElev;
    PairedValues _capacityByStorage;
    PairedValues _capacityByRelease;
    PairedValues _capacityByOpHead;
    PairedValues _efficiencyByElev;
    PairedValues _efficiencyByRelease;
    PairedValues _efficiencyByOpHead;
    PairedValuesExt _efficiencyByHillCurve;
    private transient Double b;
    double[] _efficiencyHillCurveTurbineInflows;
    PairedValues _stationUseByRelease;
    PairedValues _hydLossByRelease;
    int _capacityMethod = 0;
    int _efficiencyMethod = 0;
    int _stationUseMethod = 0;
    int _hydLossMethod = 0;
    public static final double KW_CONST_ENGLISH = 0.0846;
    public static final double KW_CONST_SI = 9.8;
    public static double a = 0.0846;
    boolean _restrictMinPowerRel = false;
    double _minPowerRel = 0.0;
    boolean _restrictMinEffForRel = false;
    double _minEffForRel = 0.0;
    boolean _restrictMaxPowerRel = false;
    double _maxPowerRel = 0.0;
    private transient Element c;
    private transient TailwaterElevation d;
    private transient doubleArrayContainer e;
    private transient doubleArrayContainer f;
    private transient doubleArrayContainer g;
    private transient doubleArrayContainer h;
    private transient doubleArrayContainer i;
    private transient doubleArrayContainer j;
    private transient doubleArrayContainer k;
    private transient doubleArrayContainer l;
    private transient doubleArrayContainer m;
    private transient double n = 1.0;
    private transient double o = 1.0;
    private transient PairedValues p = null;
    private transient RunTimeStep q = new RunTimeStep();

    public PowerPlant() {
    }

    protected String getOutputBPart() {
        ArrayList<String> arrayList = this._adjustableFlow.getFullNameList();
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        arrayList.add("POWERPLANT");
        return ((RssTSLocationObject)this._adjustableFlow).getSystem().generateUniquePathPart(arrayList, "-");
    }

    public void setupForSerialization() {
        DSSPathname dSSPathname = new DSSPathname();
        RSimDssPathPartGenerator rSimDssPathPartGenerator = new RSimDssPathPartGenerator();
        Object object = this._adjustableFlow.getElement().getTopParent().getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)object);
        object = rSimDssPathPartGenerator.generatePathnamePart(arrayList, "");
        dSSPathname.setAPart((String)object);
        RssSystem rssSystem = ((RssTSLocationObject)this._adjustableFlow).getSystem();
        String string = this._adjustableFlow.getElement().getSystem().getDssPairedDataFilePath();
        if (this._efficiencyByElev != null) {
            arrayList.clear();
            arrayList.add(this._adjustableFlow.getName());
            arrayList.add("Eff By Elev");
            object = rssSystem != null ? rssSystem.generateUniquePathPart(arrayList, "-") : rSimDssPathPartGenerator.generatePathnamePart(arrayList, "-");
            dSSPathname.setBPart((String)object);
            object = Parameter.getParamString((int)Parameter.PARAMID_ELEV) + "-" + Parameter.getParamString((int)Parameter.PARAMID_PERCENT);
            dSSPathname.setCPart((String)object);
            object = dSSPathname.getPathname();
            this._efficiencyByElev.setUnitSystem(this._adjustableFlow.getUnitSystem());
            this._efficiencyByElev.setDssIdentifer(new DSSIdentifier(string, (String)object));
        }
        if (this._efficiencyByRelease != null) {
            arrayList.clear();
            arrayList.add(this._adjustableFlow.getName());
            arrayList.add("Eff By Release");
            object = rssSystem != null ? rssSystem.generateUniquePathPart(arrayList, "-") : rSimDssPathPartGenerator.generatePathnamePart(arrayList, "-");
            dSSPathname.setBPart((String)object);
            object = Parameter.getParamString((int)Parameter.PARAMID_FLOW) + "-" + Parameter.getParamString((int)Parameter.PARAMID_PERCENT);
            dSSPathname.setCPart((String)object);
            object = dSSPathname.getPathname();
            try {
                this._efficiencyByRelease.setUnitSystem(this._adjustableFlow.getUnitSystem());
            }
            catch (Exception exception) {}
            this._efficiencyByRelease.setDssIdentifer(new DSSIdentifier(string, (String)object));
        }
        if (this._efficiencyByOpHead != null) {
            arrayList.clear();
            arrayList.add(this._adjustableFlow.getName());
            arrayList.add("Eff By Head");
            object = rssSystem != null ? rssSystem.generateUniquePathPart(arrayList, "-") : rSimDssPathPartGenerator.generatePathnamePart(arrayList, "-");
            dSSPathname.setBPart((String)object);
            object = Parameter.getParamString((int)Parameter.PARAMID_STAGE) + "-" + Parameter.getParamString((int)Parameter.PARAMID_PERCENT);
            dSSPathname.setCPart((String)object);
            object = dSSPathname.getPathname();
            this._efficiencyByOpHead.setDssIdentifer(new DSSIdentifier(string, (String)object));
        }
        if (this._stationUseByRelease != null) {
            arrayList.clear();
            arrayList.add(this._adjustableFlow.getName());
            arrayList.add("Station Use");
            object = rssSystem != null ? rssSystem.generateUniquePathPart(arrayList, "-") : rSimDssPathPartGenerator.generatePathnamePart(arrayList, "-");
            dSSPathname.setBPart((String)object);
            object = Parameter.getParamString((int)Parameter.PARAMID_FLOW) + "-" + Parameter.getParamString((int)Parameter.PARAMID_FLOW);
            dSSPathname.setCPart((String)object);
            this._stationUseByRelease.setUnitSystem(this._adjustableFlow.getUnitSystem());
            object = dSSPathname.getPathname();
            this._stationUseByRelease.setDssIdentifer(new DSSIdentifier(string, (String)object));
        }
        if (this._hydLossByRelease != null) {
            arrayList.clear();
            arrayList.add(this._adjustableFlow.getName());
            arrayList.add("Hyd Loss");
            object = rssSystem != null ? rssSystem.generateUniquePathPart(arrayList, "-") : rSimDssPathPartGenerator.generatePathnamePart(arrayList, "-");
            dSSPathname.setBPart((String)object);
            object = Parameter.getParamString((int)Parameter.PARAMID_FLOW) + "-" + Parameter.getParamString((int)Parameter.PARAMID_ELEV);
            dSSPathname.setCPart((String)object);
            object = dSSPathname.getPathname();
            this._hydLossByRelease.setUnitSystem(this._adjustableFlow.getUnitSystem());
            this._hydLossByRelease.setDssIdentifer(new DSSIdentifier(string, (String)object));
        }
        if (this._capacityByElev != null) {
            arrayList.clear();
            arrayList.add(this._adjustableFlow.getName());
            arrayList.add(" PowerCap By Elev");
            object = rssSystem != null ? rssSystem.generateUniquePathPart(arrayList, "-") : rSimDssPathPartGenerator.generatePathnamePart(arrayList, "-");
            dSSPathname.setBPart((String)object);
            object = Parameter.getParamString((int)Parameter.PARAMID_ELEV) + "-" + Parameter.getParamString((int)Parameter.PARAMID_POWER);
            dSSPathname.setCPart((String)object);
            object = dSSPathname.getPathname();
            this._capacityByElev.setUnitSystem(this._adjustableFlow.getUnitSystem());
            this._capacityByElev.setDssIdentifer(new DSSIdentifier(string, (String)object));
        }
        if (this._capacityByStorage != null) {
            arrayList.clear();
            arrayList.add(this._adjustableFlow.getName());
            arrayList.add(" PowerCap By Storage");
            object = rssSystem != null ? rssSystem.generateUniquePathPart(arrayList, "-") : rSimDssPathPartGenerator.generatePathnamePart(arrayList, "-");
            dSSPathname.setBPart((String)object);
            object = Parameter.getParamString((int)Parameter.PARAMID_STOR) + "-" + Parameter.getParamString((int)Parameter.PARAMID_POWER);
            dSSPathname.setCPart((String)object);
            object = dSSPathname.getPathname();
            try {
                this._capacityByStorage.setUnitSystem(this._adjustableFlow.getUnitSystem());
            }
            catch (Exception exception) {}
            this._capacityByStorage.setDssIdentifer(new DSSIdentifier(string, (String)object));
        }
        if (this._capacityByRelease != null) {
            arrayList.clear();
            arrayList.add(this._adjustableFlow.getName());
            arrayList.add(" PowerCap By Release");
            object = rssSystem != null ? rssSystem.generateUniquePathPart(arrayList, "-") : rSimDssPathPartGenerator.generatePathnamePart(arrayList, "-");
            dSSPathname.setBPart((String)object);
            object = Parameter.getParamString((int)Parameter.PARAMID_FLOW) + "-" + Parameter.getParamString((int)Parameter.PARAMID_POWER);
            dSSPathname.setCPart((String)object);
            object = dSSPathname.getPathname();
            try {
                this._capacityByRelease.setUnitSystem(this._adjustableFlow.getUnitSystem());
            }
            catch (Exception exception) {}
            this._capacityByRelease.setDssIdentifer(new DSSIdentifier(string, (String)object));
        }
        if (this._capacityByOpHead != null) {
            arrayList.clear();
            arrayList.add(this._adjustableFlow.getName());
            arrayList.add(" PowerCap By OpHead");
            object = rssSystem != null ? rssSystem.generateUniquePathPart(arrayList, "-") : rSimDssPathPartGenerator.generatePathnamePart(arrayList, "-");
            dSSPathname.setBPart((String)object);
            object = Parameter.getParamString((int)Parameter.PARAMID_STAGE) + "-" + Parameter.getParamString((int)Parameter.PARAMID_POWER);
            dSSPathname.setCPart((String)object);
            object = dSSPathname.getPathname();
            try {
                this._capacityByOpHead.setUnitSystem(this._adjustableFlow.getUnitSystem());
            }
            catch (Exception exception) {}
            this._capacityByOpHead.setDssIdentifer(new DSSIdentifier(string, (String)object));
        }
    }

    public PowerPlant(AdjustableFlow adjustableFlow) {
        this._adjustableFlow = adjustableFlow;
    }

    public boolean initialize() {
        this.d = null;
        AdjustableFlow adjustableFlow = this.getAdjustableFlow();
        if (adjustableFlow == null) {
            return false;
        }
        a = this._adjustableFlow.getUnitSystem() == 1 ? 0.0846 : 9.8;
        this.e = adjustableFlow.getTSContainer(50);
        this.f = adjustableFlow.getTSContainer(51);
        this.g = adjustableFlow.getTSContainer(52);
        this.h = adjustableFlow.getTSContainer(53);
        this.i = adjustableFlow.getTSContainer(54);
        this.j = adjustableFlow.getTSContainer(55);
        this.k = adjustableFlow.getTSContainer(56);
        this.l = adjustableFlow.getTSContainer(57);
        this.m = adjustableFlow.getTSContainer(166);
        this.c = adjustableFlow.getElement();
        double d = 1.0;
        switch (this._efficiencyMethod) {
            case 0: {
                d = this._constEff;
                break;
            }
            case 1: {
                if (this._efficiencyByElev == null || this._efficiencyByElev.size() <= 0) break;
                d = this._efficiencyByElev.getMaxY();
                break;
            }
            case 2: {
                if (this._efficiencyByRelease == null || this._efficiencyByRelease.size() <= 0) break;
                d = this._efficiencyByRelease.getMaxY();
                break;
            }
            case 3: {
                if (this._efficiencyByOpHead == null || this._efficiencyByOpHead.size() <= 0) break;
                d = this._efficiencyByOpHead.getMaxY();
                break;
            }
            case 4: {
                this.b = this._efficiencyByHillCurve.getLargestValue();
                d = this.b;
            }
        }
        if (d > 1.0) {
            this.o = 0.01;
            this.n = d * this.o;
        } else {
            this.o = 1.0;
            this.n = d;
        }
        return true;
    }

    public double computePower(RunTimeStep runTimeStep, double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9 = this.getTailwaterElevation(runTimeStep);
        double d10 = Math.max(0.0, d - d9);
        if (!(RMAConst.isValidValue((double)d) && RMAConst.isValidValue((double)d2) && RMAConst.isValidValue((double)d9))) {
            this.e.array[runTimeStep.step] = -3.4028234663852886E38;
            this.f.array[runTimeStep.step] = -3.4028234663852886E38;
            this.g.array[runTimeStep.step] = -3.4028234663852886E38;
            this.k.array[runTimeStep.step] = -3.4028234663852886E38;
            this.i.array[runTimeStep.step] = -3.4028234663852886E38;
            this.l.array[runTimeStep.step] = -3.4028234663852886E38;
            this.m.array[runTimeStep.step] = -3.4028234663852886E38;
            return -3.4028234663852886E38;
        }
        double d11 = this.getStationUse(d2);
        double d12 = d2 - d11;
        if (d8 < 0.0) {
            d12 = 0.0;
        }
        double d13 = this.getHydraulicLoss(d12);
        double d14 = d - d9 - d13;
        if (d7 < 0.0) {
            d14 = 0.0;
        }
        this.e.array[runTimeStep.step] = d6 = this.calcEfficiency(d, d14, d12);
        this.f.array[runTimeStep.step] = d14;
        this.g.array[runTimeStep.step] = d13;
        double d15 = PowerPlant.a(d12, d14, d6);
        double d16 = this.getCapacity(d, d14, d12);
        double d17 = 1.0;
        if (this._capacityMethod == 0 && this._overload > 1.0 && this._overload != Double.NEGATIVE_INFINITY) {
            d17 = this._overload;
        }
        if (d15 > (d16 *= d17)) {
            d15 = d16;
            d12 = d5 = d15 * 1000.0 / (d14 * d6 * a);
        }
        d5 = this.calcMaxCapability(d, d10, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.k.array[runTimeStep.step] = d12;
        this.i.array[runTimeStep.step] = d15;
        this.l.array[runTimeStep.step] = d5;
        this.m.array[runTimeStep.step] = d16;
        this.h.array[runTimeStep.step] = 0.0;
        double d18 = (double)runTimeStep.rtw.getTimeStepMinutes() / 60.0;
        if (!runTimeStep.isPerAvgTimeStep()) {
            if (runTimeStep.step > 0 && RMAConst.isValidValue((double)this.i.array[runTimeStep.step]) && RMAConst.isValidValue((double)this.i.array[runTimeStep.step - 1])) {
                d4 = 0.5 * (this.i.array[runTimeStep.step] + this.i.array[runTimeStep.step - 1]);
                this.h.array[runTimeStep.step] = d4 * d18;
            }
        } else if (RMAConst.isValidValue((double)this.i.array[runTimeStep.step])) {
            d4 = this.i.array[runTimeStep.step];
            this.h.array[runTimeStep.step] = d4 * d18;
        }
        d4 = 0.0;
        double d19 = d18 * d5;
        if (d3 > 0.0) {
            d4 = this.h.array[runTimeStep.step] / d19;
        }
        this.j.array[runTimeStep.step] = d4;
        return d15;
    }

    public double calculatePower(double d, double d2, double d3) {
        return this.calculatePower(d, d2, d3, true);
    }

    public double calculatePower(double d, double d2, double d3, boolean bl) {
        double d4;
        double d5 = d;
        d -= this.getStationUse(d);
        if (d4 < 0.0) {
            d = 0.0;
        }
        double d6 = this.getHydraulicLoss(d);
        double d7 = d2 - d3 - d6;
        double d8 = this.calcEfficiency(d2, d7, d);
        double d9 = PowerPlant.a(d, d7, d8);
        if (bl) {
            double d10 = d2;
            double d11 = this.getCapacity(d10, d10 - d3, d5);
            if (this._capacityMethod == 0 && this._overload > 1.0 && this._overload != Double.NEGATIVE_INFINITY) {
                d11 *= this._overload;
            }
            if (d9 > d11) {
                d9 = d11;
            }
        }
        return d9;
    }

    public static double a(double d, double d2, double d3) {
        double d4 = d * d2 * d3 * a / 1000.0;
        return d4;
    }

    public double calculateAvailablePowerCapacity(double d, double d2) {
        double d3 = Math.max(0.0, d - d2);
        return this.calcMaxCapability(d, d3, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    public double getRequiredRelease(double d, double d2, double d3) {
        double d4;
        if (Math.abs(d) < 1.0E-8) {
            return 0.0;
        }
        double d5 = Math.max(0.0, d2 - d3);
        double d6 = this._adjustableFlow.getCapacity(d2);
        if (d4 <= 0.0) {
            return 0.0;
        }
        if (this._restrictMaxPowerRel && RMAConst.isValidValue((double)this._maxPowerRel)) {
            d6 = Math.min(d6, this._maxPowerRel);
        }
        double d7 = 0.0;
        if (this._restrictMinPowerRel && RMAConst.isValidValue((double)this._minPowerRel)) {
            d7 = Math.max(0.0, this._minPowerRel);
        }
        if (d6 == d7) {
            return d7;
        }
        double d8 = d7;
        double d9 = d7;
        for (int i = 0; i < 3; ++i) {
            int n;
            double d10;
            double d11 = (d6 - d7) / 10.0;
            boolean bl = false;
            double d12 = d7;
            double d13 = d10 = this.calcCapability(d2, d5, d12);
            int n2 = 0;
            for (n = 1; n <= 10; ++n) {
                double d14;
                double d15 = d7 + (double)n * d11;
                double d16 = this.calcCapability(d2, d5, d15);
                if (d14 > d13) {
                    d13 = d16;
                    d9 = d15;
                    n2 = n;
                }
                if (d16 >= d) {
                    d8 = d12 + (d15 - d12) * (d - d10) / (d16 - d10);
                    d6 = d15;
                    d7 = d15 - d11;
                    bl = true;
                    break;
                }
                d12 = d15;
                d10 = d16;
            }
            if (bl) continue;
            d8 = d9;
            n = Math.max(0, n2 - 1);
            n2 = Math.min(10, n2 + 1);
            d6 = d7 + (double)n2 * d11;
            d7 += (double)n * d11;
        }
        return d8;
    }

    public double getRequiredReleaseOld(double d, double d2, double d3) {
        double d4;
        if (Math.abs(d) < 1.0E-8) {
            return 0.0;
        }
        double d5 = this.getHydraulicLoss(0.0);
        double d6 = d2 - d3 - d5;
        double d7 = this.calcEfficiency(d2, d6, Double.NEGATIVE_INFINITY);
        a = this._adjustableFlow.getUnitSystem() == 1 ? 0.0846 : 9.8;
        int n = 1;
        if (this._efficiencyMethod == 2 || this._hydLossMethod == 1 || this._stationUseMethod == 1 || this._efficiencyMethod == 4) {
            n = 20;
        }
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = this.getStationUse(0.0);
        for (int i = 0; i < n; ++i) {
            d8 = d * 1000.0 / (d6 * d7 * a);
            double d11 = this.getStationUse(d8);
            d10 += 0.65 * (d11 - d10);
            d8 += d10;
            if (Math.abs((d8 = Math.min(d8, this._adjustableFlow.getCapacity(d2))) - d9) < 0.01) break;
            d9 = d8;
            if (this._efficiencyMethod == 2 || this._efficiencyMethod == 4) {
                double d12 = this.calcEfficiency(d2, d6, d8);
                d7 += 0.65 * (d12 - d7);
            }
            double d13 = this.getHydraulicLoss(d8);
            d5 += 0.65 * (d13 - d5);
            d6 = d2 - d3 - d5;
        }
        if (this._restrictMaxPowerRel && d8 > this._maxPowerRel) {
            d8 = this._maxPowerRel;
            if (this._efficiencyMethod == 2 || this._efficiencyMethod == 4) {
                d7 = this.calcEfficiency(d2, d6, d8);
            }
        }
        if (this._restrictMinPowerRel && d8 > 0.0 && d8 < this._minPowerRel) {
            d8 = this._minPowerRel;
            if (this._efficiencyMethod == 2 || this._efficiencyMethod == 4) {
                d7 = this.calcEfficiency(d2, d6, d8);
            }
        }
        double d14 = this._minEffForRel;
        if (d4 > 1.0) {
            d14 *= 0.01;
        }
        if (this._restrictMinEffForRel && d8 > 0.0 && d7 < d14) {
            d8 = this.calcRelForMinEff(d7, d2, d6, d8);
        }
        return d8;
    }

    public double calcRelForMinEff(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = d4;
        double d7 = this._minEffForRel;
        if (d5 > 1.0) {
            d7 *= 0.01;
        }
        if (d4 == 0.0 || d >= d7) {
            return d4;
        }
        if (this._efficiencyMethod == 0 || this._efficiencyMethod == 1 || this._efficiencyMethod == 3) {
            return 0.0;
        }
        double d8 = d4;
        double d9 = d;
        double d10 = this.calcDEdr(d2, d3, d6, d);
        if (d10 == 0.0) {
            return 0.0;
        }
        boolean bl = false;
        int n = 1;
        for (int i = 0; i < 10; ++i) {
            double d11;
            double d12;
            double d13 = d8 - (d9 - d7) / d10 / (double)n;
            double d14 = this.calcEfficiency(d2, d3, d13);
            if (Math.abs(d12 - d7) < 0.001) {
                bl = true;
                d6 = d13;
                break;
            }
            double d15 = this.calcDEdr(d2, d3, d13, d14);
            if (d11 * d10 < 0.0) {
                ++n;
                continue;
            }
            n = 1;
            d9 = d14;
            d8 = d13;
            d10 = d15;
        }
        if (!bl) {
            d6 = d4;
        }
        return d6;
    }

    private double calcDEdr(double d, double d2, double d3, double d4) {
        double d5 = d3 * 0.01;
        double d6 = this.calcEfficiency(d, d2, d3 + d5) - d4;
        if (d6 == 0.0 && (d6 = d4 - this.calcEfficiency(d, d2, d3 - d5)) == 0.0) {
            return 0.0;
        }
        double d7 = d6 / d5;
        return d7;
    }

    public int getCapacityMethod() {
        return this._capacityMethod;
    }

    public void setCapacityMethod(int n) {
        if (n < 0 || n > 4) {
            return;
        }
        this._capacityMethod = n;
    }

    public int getEfficiencyMethod() {
        return this._efficiencyMethod;
    }

    public void setEfficiencyMethod(int n) {
        if (n < 0 || n > 4) {
            return;
        }
        this._efficiencyMethod = n;
    }

    public int getStationUseMethod() {
        return this._stationUseMethod;
    }

    public void setStationUseMethod(int n) {
        if (n < 0 || n > 1) {
            return;
        }
        this._stationUseMethod = n;
    }

    public int getHydLossMethod() {
        return this._hydLossMethod;
    }

    public void setHydLossMethod(int n) {
        if (n < 0 || n > 1) {
            return;
        }
        this._hydLossMethod = n;
    }

    private double getHydraulicLoss(double d) {
        double d2 = 0.0;
        if (this._hydLossMethod == 1 && this._hydLossByRelease != null && this._hydLossByRelease.size() > 0) {
            d2 = this._hydLossByRelease.getYValue(d);
        } else if (this._hydLossMethod == 0 && this._constHUse != Double.NEGATIVE_INFINITY) {
            d2 = this._constHUse;
        }
        return d2;
    }

    private double getStationUse(double d) {
        double d2 = 0.0;
        if (this._stationUseMethod == 1 && this._stationUseByRelease != null && this._stationUseByRelease.size() > 0) {
            d2 = this._stationUseByRelease.getYValue(d);
        } else if (this._stationUseMethod == 0 && this._constSUse != Double.NEGATIVE_INFINITY) {
            d2 = this._constSUse;
        }
        return d2;
    }

    private double calcEfficiencyByHillCurve(double d, double d2) {
        double d3 = 100.0;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._efficiencyMethod == 4) {
            PairedValuesExt pairedValuesExt = this._efficiencyByHillCurve;
            if (d2 == Double.NEGATIVE_INFINITY) {
                return this.b;
            }
            int n = 0;
            double d4 = this._efficiencyHillCurveTurbineInflows[0];
            double d5 = this._efficiencyHillCurveTurbineInflows[this._efficiencyHillCurveTurbineInflows.length - 1];
            double d6 = pairedValuesExt.getXValue(0);
            PairedValuesExt pairedValuesExt2 = pairedValuesExt;
            double d7 = pairedValuesExt2.getXValue(pairedValuesExt2.getXArray().length - 1);
            if (d2 < d4) {
                stringBuffer.append("The flow value " + d2 + " is less than " + d4 + ", the minimum flow in the Hill Curve Table.\n");
                d2 = d4;
            } else if (d2 >= d5) {
                stringBuffer.append("The flow value " + d2 + " is greater than " + d5 + ", the maximum flow in the Hill Curve Table.\n");
                d2 = d5;
            }
            if (d < d6) {
                stringBuffer.append("The head value " + d + " is less than " + d6 + ", the minimum head in the Hill Curve Table.\n");
                d = d6;
            } else if (d > d7) {
                stringBuffer.append("The head value " + d + " is greater than " + d7 + ", the maximum head in the Hill Curve Table.\n");
                d = d7;
            }
            if (!"".equals(stringBuffer.toString())) {
                stringBuffer.append("\n");
                ((RssTSLocationObject)this._adjustableFlow).getSystem().printWarningMessage(stringBuffer.toString());
            }
            while (n < this._efficiencyHillCurveTurbineInflows.length - 1 && d2 > this._efficiencyHillCurveTurbineInflows[n]) {
                ++n;
            }
            if (n == 0) {
                n = 1;
            }
            double d8 = pairedValuesExt.getYValue(d, n - 1);
            double d9 = pairedValuesExt.getYValue(d, n);
            double d10 = (d2 - this._efficiencyHillCurveTurbineInflows[n - 1]) / (this._efficiencyHillCurveTurbineInflows[n] - this._efficiencyHillCurveTurbineInflows[n - 1]);
            d3 = d8 + d10 * (d9 - d8);
        }
        return d3;
    }

    public double calcEfficiency(double d, double d2, double d3) {
        double d4 = this.n;
        if (this._efficiencyMethod == 0) {
            d4 = this._constEff;
            d4 *= this.o;
        } else if (this._efficiencyMethod == 1 && this._efficiencyByElev != null && this._efficiencyByElev.size() > 0 && RMAConst.isValidValue((double)d)) {
            d4 = this._efficiencyByElev.getYValue(d);
            d4 *= this.o;
        } else if (this._efficiencyMethod == 2 && this._efficiencyByRelease != null && this._efficiencyByRelease.size() > 0 && RMAConst.isValidValue((double)d3)) {
            d4 = this._efficiencyByRelease.getYValue(d3);
            d4 *= this.o;
        } else if (this._efficiencyMethod == 3 && this._efficiencyByOpHead != null && this._efficiencyByOpHead.size() > 0 && RMAConst.isValidValue((double)d2)) {
            d4 = this._efficiencyByOpHead.getYValue(d2);
            d4 *= this.o;
        } else if (this._efficiencyMethod == 4) {
            d4 = this.calcEfficiencyByHillCurve(d2, d3);
            d4 *= this.o;
        }
        return d4;
    }

    public double calcMaxCapability(double d, double d2, double d3, double d4) {
        double d5 = this._adjustableFlow.getCapacity(d);
        if (RMAConst.isValidValue((double)d4)) {
            d5 = Math.min(d5, d4);
        }
        if (d5 <= 0.0) {
            return 0.0;
        }
        if (this._restrictMaxPowerRel && RMAConst.isValidValue((double)this._maxPowerRel)) {
            d5 = Math.min(d5, this._maxPowerRel);
        }
        double d6 = 0.0;
        if (this._restrictMinPowerRel && RMAConst.isValidValue((double)this._minPowerRel)) {
            d6 = Math.max(0.0, this._minPowerRel);
        }
        if (RMAConst.isValidValue((double)d3)) {
            d5 = Math.max(d5, d3);
        }
        if (d5 == d6) {
            return this.calcCapability(d, d2, d5);
        }
        double d7 = Double.MIN_VALUE;
        for (int i = 0; i < 3; ++i) {
            int n;
            double d8;
            double d9 = (d5 - d6) / 10.0;
            double d10 = d6;
            d7 = d8 = this.calcCapability(d, d2, d10);
            int n2 = 0;
            for (n = 1; n <= 10; ++n) {
                double d11;
                double d12 = d6 + (double)n * d9;
                double d13 = this.calcCapability(d, d2, d12);
                if (!(d11 > d7)) continue;
                d7 = d13;
                n2 = n;
            }
            n = Math.max(0, n2 - 1);
            n2 = Math.min(10, n2 + 1);
            d5 = d6 + (double)n2 * d9;
            d6 += (double)n * d9;
        }
        return d7;
    }

    private double calcCapability(double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9 = this.getStationUse(d3);
        double d10 = d3 - d9;
        if (d8 < 0.0) {
            d10 = 0.0;
        }
        double d11 = this.getHydraulicLoss(d10);
        double d12 = d2 - d11;
        if (d7 < 0.0) {
            d12 = 0.0;
        }
        if ((d6 = PowerPlant.a(d10, d12, d5 = this.calcEfficiency(d, d12, d10))) > (d4 = this.getCapacity(d, d12, d10))) {
            d6 = d4;
        }
        return d6;
    }

    public double getCapacity(double d, double d2, double d3) {
        double d4 = 100.0;
        double d5 = 0.0;
        PairedValues pairedValues = null;
        if (this._capacityMethod == 0) {
            return this._capacity;
        }
        if (this._capacityMethod == 1) {
            pairedValues = this._capacityByElev;
            d5 = d;
        } else if (this._capacityMethod == 3) {
            pairedValues = this._capacityByRelease;
            d5 = d3;
        } else if (this._capacityMethod == 2) {
            pairedValues = this._capacityByStorage;
            Storage storage = this.findStorage();
            if (storage != null) {
                double d6;
                d5 = d6 = storage.elevationToStorage(d);
            }
        } else if (this._capacityMethod == 4) {
            pairedValues = this._capacityByOpHead;
            d5 = d2;
        }
        if (pairedValues != null && pairedValues.size() > 0) {
            d4 = pairedValues.getYValue(d5);
        }
        return d4;
    }

    public TailwaterElevation findTailwaterElevation() {
        if (this.d == null) {
            if (this._adjustableFlow.hasTailElev()) {
                this.d = this._adjustableFlow.getTailwaterElevation();
            } else {
                for (Element element = this._adjustableFlow.getElement().getParent(); element != null; element = element.getParent()) {
                    if (!(element instanceof TailElevContainer) || !((TailElevContainer)((Object)element)).hasTailElev()) continue;
                    this.d = ((TailElevContainer)((Object)element)).getTailwaterElevation();
                    break;
                }
            }
        }
        return this.d;
    }

    public double getTailwaterElevation(RunTimeStep runTimeStep) {
        double d;
        this.findTailwaterElevation();
        if (this.d == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.d.isDefined(runTimeStep)) {
            d = this.d.getElevation(runTimeStep);
        } else {
            this.q.step = runTimeStep.step;
            this.q.rtw = runTimeStep.rtw;
            if (this.q.step > 0) {
                --this.q.step;
            }
            d = this.d.getElevation(this.q);
        }
        return d;
    }

    public TailwaterElevation getAssociatedTailwater() {
        if (this.d == null) {
            if (this._adjustableFlow.hasTailElev()) {
                this.d = this._adjustableFlow.getTailwaterElevation();
            } else {
                for (Element element = this._adjustableFlow.getElement().getParent(); element != null; element = element.getParent()) {
                    if (!(element instanceof TailElevContainer) || !((TailElevContainer)((Object)element)).hasTailElev()) continue;
                    this.d = ((TailElevContainer)((Object)element)).getTailwaterElevation();
                    break;
                }
            }
        }
        return this.d;
    }

    public double getPoolElevation(RunTimeStep runTimeStep) {
        double d;
        boolean bl = false;
        double d2 = this.c.getEffectiveElev(runTimeStep);
        if (RMAConst.isValidValue((double)d2)) {
            bl = true;
        }
        this.q.step = runTimeStep.step;
        this.q.rtw = runTimeStep.rtw;
        if (this.q.step > 0) {
            --this.q.step;
        }
        double d3 = d = this.c.getEffectiveElev(this.q);
        if (bl) {
            d3 = d2;
        }
        if (runTimeStep.isPerAvgTimeStep() && bl) {
            d3 = (d + d2) / 2.0;
        }
        return d3;
    }

    public Storage findStorage() {
        NamedType namedType = null;
        namedType = this._adjustableFlow.getElement().getTopParent();
        if (!(namedType instanceof ReservoirElement)) {
            return null;
        }
        namedType = ((ReservoirElement)namedType).getStorageFunction();
        return namedType;
    }

    public PairedValues getStationUseByRelease() {
        if (this._stationUseByRelease == null) {
            this._stationUseByRelease = new PairedValues();
        }
        this._stationUseByRelease.setUnitSystem(this._adjustableFlow.getUnitSystem());
        this._stationUseByRelease.setParamXId(Parameter.PARAMID_FLOW);
        this._stationUseByRelease.setParamYId(Parameter.PARAMID_FLOW);
        return (PairedValues)this._stationUseByRelease.clone();
    }

    public void setStationUseByRelease(PairedValues pairedValues) {
        this._stationUseByRelease = pairedValues;
        this.setModified(true);
    }

    public PairedValues getHydLossByRelease() {
        if (this._hydLossByRelease == null) {
            this._hydLossByRelease = new PairedValues();
        }
        this._hydLossByRelease.setUnitSystem(this._adjustableFlow.getUnitSystem());
        this._hydLossByRelease.setParamXId(Parameter.PARAMID_FLOW);
        this._hydLossByRelease.setParamYId(Parameter.PARAMID_ELEV);
        return (PairedValues)this._hydLossByRelease.clone();
    }

    public void setHydLossByRelease(PairedValues pairedValues) {
        this._hydLossByRelease = pairedValues;
        this.setModified(true);
    }

    public PairedValues getEfficiencyByElev() {
        if (this._efficiencyByElev == null) {
            this._efficiencyByElev = new PairedValues();
        }
        this._efficiencyByElev.setUnitSystem(this._adjustableFlow.getUnitSystem());
        this._efficiencyByElev.setParamXId(Parameter.PARAMID_ELEV);
        this._efficiencyByElev.setParamYId(Parameter.PARAMID_PERCENT);
        return (PairedValues)this._efficiencyByElev.clone();
    }

    public void setEfficiencyByElev(PairedValues pairedValues) {
        this._efficiencyByElev = pairedValues;
        this.setModified(true);
    }

    public PairedValues getEfficiencyByRelease() {
        if (this._efficiencyByRelease == null) {
            this._efficiencyByRelease = new PairedValues();
        }
        this._efficiencyByRelease.setUnitSystem(this._adjustableFlow.getUnitSystem());
        this._efficiencyByRelease.setParamXId(Parameter.PARAMID_FLOW);
        this._efficiencyByRelease.setParamYId(Parameter.PARAMID_PERCENT);
        return (PairedValues)this._efficiencyByRelease.clone();
    }

    public void setEfficiencyByRelease(PairedValues pairedValues) {
        this._efficiencyByRelease = pairedValues;
        this.setModified(true);
    }

    public PairedValues getEfficiencyByOpHead() {
        if (this._efficiencyByOpHead == null) {
            this._efficiencyByOpHead = new PairedValues();
        }
        this._efficiencyByOpHead.setUnitSystem(this._adjustableFlow.getUnitSystem());
        this._efficiencyByOpHead.setParamXId(Parameter.PARAMID_STAGE);
        this._efficiencyByOpHead.setParamYId(Parameter.PARAMID_PERCENT);
        return (PairedValues)this._efficiencyByOpHead.clone();
    }

    public void setEfficiencyByOpHead(PairedValues pairedValues) {
        this._efficiencyByOpHead = pairedValues;
        this.setModified(true);
    }

    public void getConstHydLoss(ParamDouble paramDouble) {
        paramDouble.setValue(this._constHUse);
        paramDouble.setParameterId(Parameter.PARAMID_ELEV);
        paramDouble.setUnitSystem(this._adjustableFlow.getUnitSystem());
    }

    public void setConstHydLoss(ParamDouble paramDouble) {
        this._constHUse = paramDouble.getValue();
    }

    public void getConstStationUse(ParamDouble paramDouble) {
        paramDouble.setValue(this._constSUse);
        paramDouble.setParameterId(Parameter.PARAMID_FLOW);
        paramDouble.setUnitSystem(this._adjustableFlow.getUnitSystem());
    }

    public void setConstStationUse(ParamDouble paramDouble) {
        this._constSUse = paramDouble.getValue();
    }

    public double getConstEfficiency() {
        return this._constEff;
    }

    public void setConstEfficiency(double d) {
        this._constEff = d;
    }

    public double getOverload() {
        return this._overload;
    }

    public void setOverload(double d) {
        this._overload = d;
    }

    public double getCapacity() {
        return this._capacity;
    }

    public void setCapacity(double d) {
        this._capacity = d;
    }

    public double getConstCapacity() {
        return this._capacity;
    }

    public void setConstCapacity(double d) {
        this._capacity = d;
    }

    public double getRestrictMinimum() {
        return this._minPowerRel;
    }

    public void setRestrictMinimum(double d) {
        this._minPowerRel = d;
    }

    public double getEfficiencyRelease() {
        return this._minEffForRel;
    }

    public void setEfficiencyRelease(double d) {
        this._minEffForRel = d;
    }

    public double getRestrictMaximum() {
        return this._maxPowerRel;
    }

    public void setRestrictMaximum(double d) {
        this._maxPowerRel = d;
    }

    public boolean isRestrictMinimum() {
        return this._restrictMinPowerRel;
    }

    public void setIsRestrictMinimum(boolean bl) {
        this._restrictMinPowerRel = bl;
    }

    public boolean isEfficiencyRelease() {
        return this._restrictMinEffForRel;
    }

    public void setIsEfficiencyRelease(boolean bl) {
        this._restrictMinEffForRel = bl;
    }

    public boolean isRestrictMaximum() {
        return this._restrictMaxPowerRel;
    }

    public void setIsRestrictMaximum(boolean bl) {
        this._restrictMaxPowerRel = bl;
    }

    public PairedValues getCapacityByElev() {
        if (this._capacityByElev == null) {
            this._capacityByElev = new PairedValues();
        }
        this._capacityByElev.setUnitSystem(this._adjustableFlow.getUnitSystem());
        this._capacityByElev.setParamXId(Parameter.PARAMID_ELEV);
        this._capacityByElev.setParamYId(Parameter.PARAMID_POWER);
        return (PairedValues)this._capacityByElev.clone();
    }

    public void setCapacityByElev(PairedValues pairedValues) {
        this._capacityByElev = pairedValues;
        this.setModified(true);
    }

    public PairedValues getCapacityByStorage() {
        if (this._capacityByStorage == null) {
            this._capacityByStorage = new PairedValues();
        }
        this._capacityByStorage.setUnitSystem(this._adjustableFlow.getUnitSystem());
        this._capacityByStorage.setParamXId(Parameter.PARAMID_STOR);
        this._capacityByStorage.setParamYId(Parameter.PARAMID_POWER);
        return (PairedValues)this._capacityByStorage.clone();
    }

    public void setCapacityByStorage(PairedValues pairedValues) {
        this._capacityByStorage = pairedValues;
        this.setModified(true);
    }

    public PairedValues getCapacityByRelease() {
        if (this._capacityByRelease == null) {
            this._capacityByRelease = new PairedValues();
        }
        this._capacityByRelease.setUnitSystem(this._adjustableFlow.getUnitSystem());
        this._capacityByRelease.setParamXId(Parameter.PARAMID_FLOW);
        this._capacityByRelease.setParamYId(Parameter.PARAMID_POWER);
        return (PairedValues)this._capacityByRelease.clone();
    }

    public void setCapacityByRelease(PairedValues pairedValues) {
        this._capacityByRelease = pairedValues;
        this.setModified(true);
    }

    public PairedValues getCapacityByOpHead() {
        if (this._capacityByOpHead == null) {
            this._capacityByOpHead = new PairedValues();
        }
        this._capacityByOpHead.setUnitSystem(this._adjustableFlow.getUnitSystem());
        this._capacityByOpHead.setParamXId(Parameter.PARAMID_STAGE);
        this._capacityByOpHead.setParamYId(Parameter.PARAMID_POWER);
        return (PairedValues)this._capacityByOpHead.clone();
    }

    public void setCapacityByOpHead(PairedValues pairedValues) {
        this._capacityByOpHead = pairedValues;
        this.setModified(true);
    }

    public PairedValuesExt getEfficientByHillCurve() {
        return this._efficiencyByHillCurve;
    }

    public void setEfficientByHillCurve(PairedValuesExt pairedValuesExt) {
        this._efficiencyByHillCurve = pairedValuesExt;
    }

    public double[] getEfficiencyHillCurveTurbineInflows() {
        return this._efficiencyHillCurveTurbineInflows;
    }

    public void setEfficiencyHillCurveTurbineInflows(double[] dArray) {
        this._efficiencyHillCurveTurbineInflows = dArray;
    }

    public AdjustableFlow getAdjustableFlow() {
        return this._adjustableFlow;
    }

    public void setAdjustableFlow(AdjustableFlow adjustableFlow) {
        this._adjustableFlow = adjustableFlow;
    }

    public boolean canCompute() {
        if (this._efficiencyMethod == 0 ? !RMAConst.isValidValue((double)this._constEff) : (this._efficiencyMethod == 1 ? this._efficiencyByElev == null || this._efficiencyByElev.size() <= 0 : (this._efficiencyMethod == 2 ? this._efficiencyByRelease == null || this._efficiencyByRelease.size() <= 0 : this._efficiencyMethod == 3 && (this._efficiencyByOpHead == null || this._efficiencyByOpHead.size() <= 0)))) {
            return false;
        }
        return !(this._capacityMethod == 0 ? !RMAConst.isValidValue((double)this._capacity) : (this._capacityMethod == 1 ? this._capacityByElev == null || this._capacityByElev.size() <= 0 : (this._capacityMethod == 2 ? this._capacityByStorage == null || this._capacityByStorage.size() <= 0 : (this._capacityMethod == 3 ? this._capacityByRelease == null || this._capacityByRelease.size() <= 0 : this._capacityMethod == 4 && (this._capacityByOpHead == null || this._capacityByOpHead.size() <= 0)))));
    }

    public double getInstalledCapacity() {
        return this._capacity;
    }

    public double getMaxCapacity(RunTimeStep runTimeStep, double d) {
        double d2 = this.getTailwaterElevation(runTimeStep);
        return this.getMaxCapacity(d, d2);
    }

    public double getMaxCapacity(double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        PairedValues pairedValues = null;
        if (this._capacityMethod == 0) {
            return this._capacity;
        }
        if (this._capacityMethod == 1) {
            pairedValues = this._capacityByElev;
            d4 = d;
        } else if (this._capacityMethod == 2) {
            pairedValues = this._capacityByStorage;
            Storage storage = this.findStorage();
            if (storage != null) {
                double d5;
                d4 = d5 = storage.elevationToStorage(d);
            }
        } else if (this._capacityMethod == 3) {
            double d6 = this._adjustableFlow.getCapacity(d);
            pairedValues = this._capacityByRelease;
            d4 = d6;
        } else if (this._capacityMethod == 4) {
            double d7;
            double d8 = this._adjustableFlow.getCapacity(d);
            double d9 = this.getHydraulicLoss(d8);
            double d10 = d - d2 - d9;
            if (d7 < 0.0) {
                d10 = 0.0;
            }
            pairedValues = this._capacityByOpHead;
            d4 = d10;
        }
        if (pairedValues != null && pairedValues.size() > 0) {
            d3 = pairedValues.getYValue(d4);
        }
        return d3;
    }

    public synchronized Object clone() {
        try {
            PowerPlant powerPlant = (PowerPlant)super.clone();
            if (this._efficiencyByElev != null) {
                powerPlant._efficiencyByElev = (PairedValues)this._efficiencyByElev.clone();
            }
            if (this._efficiencyByRelease != null) {
                powerPlant._efficiencyByRelease = (PairedValues)this._efficiencyByRelease.clone();
            }
            if (this._efficiencyByOpHead != null) {
                powerPlant._efficiencyByOpHead = (PairedValues)this._efficiencyByOpHead.clone();
            }
            if (this._stationUseByRelease != null) {
                powerPlant._stationUseByRelease = (PairedValues)this._stationUseByRelease.clone();
            }
            if (this._hydLossByRelease != null) {
                powerPlant._hydLossByRelease = (PairedValues)this._hydLossByRelease.clone();
            }
            if (this._efficiencyByHillCurve != null) {
                powerPlant._efficiencyByHillCurve = this._efficiencyByHillCurve.clone();
            }
            if (this._efficiencyHillCurveTurbineInflows != null) {
                powerPlant._efficiencyHillCurveTurbineInflows = (double[])this._efficiencyHillCurveTurbineInflows.clone();
            }
            if (this._capacityByElev != null) {
                powerPlant._capacityByElev = (PairedValues)this._capacityByElev.clone();
            }
            if (this._capacityByStorage != null) {
                powerPlant._capacityByStorage = (PairedValues)this._capacityByStorage.clone();
            }
            if (this._capacityByRelease != null) {
                powerPlant._capacityByRelease = (PairedValues)this._capacityByRelease.clone();
            }
            if (this._capacityByOpHead != null) {
                powerPlant._capacityByOpHead = (PairedValues)this._capacityByOpHead.clone();
            }
            powerPlant.d = null;
            return powerPlant;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void getActiveTSRecordProxies(Vector vector, int n) {
        if (n == 0) {
            AdjustableFlow adjustableFlow = this.getAdjustableFlow();
            if (adjustableFlow == null) {
                return;
            }
            TSRecordProxy tSRecordProxy = adjustableFlow.getTSRecordProxy(50);
            if (tSRecordProxy != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = adjustableFlow.getTSRecordProxy(51)) != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = adjustableFlow.getTSRecordProxy(52)) != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = adjustableFlow.getTSRecordProxy(53)) != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = adjustableFlow.getTSRecordProxy(54)) != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = adjustableFlow.getTSRecordProxy(55)) != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = adjustableFlow.getTSRecordProxy(56)) != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = adjustableFlow.getTSRecordProxy(57)) != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = adjustableFlow.getTSRecordProxy(166)) != null) {
                vector.addElement(tSRecordProxy);
            }
        }
    }

    public void updateTSProxyList() {
        AdjustableFlow adjustableFlow = this.getAdjustableFlow();
        if (adjustableFlow == null) {
            return;
        }
        if (adjustableFlow.getTSRecordProxy(50) == null) {
            adjustableFlow.addTSRecordProxy(50);
        }
        if (adjustableFlow.getTSRecordProxy(51) == null) {
            adjustableFlow.addTSRecordProxy(51);
        }
        if (adjustableFlow.getTSRecordProxy(52) == null) {
            adjustableFlow.addTSRecordProxy(52);
        }
        if (adjustableFlow.getTSRecordProxy(53) == null) {
            adjustableFlow.addTSRecordProxy(53);
        }
        if (adjustableFlow.getTSRecordProxy(54) == null) {
            adjustableFlow.addTSRecordProxy(54);
        }
        if (adjustableFlow.getTSRecordProxy(55) == null) {
            adjustableFlow.addTSRecordProxy(55);
        }
        if (adjustableFlow.getTSRecordProxy(56) == null) {
            adjustableFlow.addTSRecordProxy(56);
        }
        if (adjustableFlow.getTSRecordProxy(57) == null) {
            adjustableFlow.addTSRecordProxy(57);
        }
        if (adjustableFlow.getTSRecordProxy(166) == null) {
            adjustableFlow.addTSRecordProxy(166);
        }
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        element.setAttribute("InstalledCapacity", Double.toString(this._capacity));
        if (this._capacityMethod == 0) {
            element.setAttribute("OverloadFactor", Double.toString(this._capacity));
        } else if (this._capacityMethod == 1) {
            alternativeInputReport = new org.jdom.Element("Elevation");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._capacityByElev.getYArray());
            alternativeInputReport = new org.jdom.Element("Capacity");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._capacityByElev.getXArray());
        } else if (this._capacityMethod == 2) {
            alternativeInputReport = new org.jdom.Element("Storage");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._capacityByStorage.getYArray());
            alternativeInputReport = new org.jdom.Element("Capacity");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._capacityByStorage.getXArray());
        } else if (this._capacityMethod == 3) {
            alternativeInputReport = new org.jdom.Element("Release");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._capacityByRelease.getYArray());
            alternativeInputReport = new org.jdom.Element("Capacity");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._capacityByRelease.getXArray());
        } else if (this._capacityMethod == 4) {
            alternativeInputReport = new org.jdom.Element("Head");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._capacityByOpHead.getYArray());
            alternativeInputReport = new org.jdom.Element("Capacity");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._capacityByOpHead.getXArray());
        }
        if (this._efficiencyMethod == 0) {
            element.setAttribute("Constant_Efficiency", Double.toString(this._constEff));
        } else if (this._efficiencyMethod == 1) {
            alternativeInputReport = new org.jdom.Element("Efficiency_Elevation");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._efficiencyByElev.getYArray());
            alternativeInputReport = new org.jdom.Element("Efficiency");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._efficiencyByElev.getXArray());
        } else if (this._efficiencyMethod == 2) {
            alternativeInputReport = new org.jdom.Element("Efficiency_Release");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._efficiencyByRelease.getYArray());
            alternativeInputReport = new org.jdom.Element("Efficiency");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._efficiencyByRelease.getXArray());
        } else if (this._efficiencyMethod == 3) {
            alternativeInputReport = new org.jdom.Element("Efficiency_Head");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._efficiencyByOpHead.getYArray());
            alternativeInputReport = new org.jdom.Element("Efficiency");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._efficiencyByOpHead.getXArray());
        }
        if (this._stationUseMethod == 0) {
            element.setAttribute("Station_Use_Const", Double.toString(this._constSUse));
        } else if (this._stationUseMethod == 1) {
            alternativeInputReport = new org.jdom.Element("StationUse_Release");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._stationUseByRelease.getYArray());
            alternativeInputReport = new org.jdom.Element("Use");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._stationUseByRelease.getXArray());
        }
        if (this._hydLossMethod == 0) {
            element.setAttribute("HydroLoss_Const", Double.toString(this._constHUse));
            return;
        }
        if (this._hydLossMethod == 1) {
            alternativeInputReport = new org.jdom.Element("HydroLoss_Release");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._hydLossByRelease.getYArray());
            alternativeInputReport = new org.jdom.Element("Loss");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._hydLossByRelease.getXArray());
        }
    }
}

