/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.Parameter;
import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import java.io.Serializable;
import java.lang.reflect.Field;

public class PrescribedOpItem
implements AsciiSerializable,
Serializable,
Cloneable {
    public static final int PRESCRIB_UNDEF = 0;
    public static final int PRESCRIB_SET_RELEASE = 1;
    public static final int PRESCRIB_SET_REL_DELTA_INFLOW = 2;
    public static final int PRESCRIB_HOLD_RELEASE = 3;
    public static final int PRESCRIB_SET_GATE = 4;
    public static final int PRESCRIB_ELEV_TARGET = 5;
    public static final int PRESCRIB_ELEV_CHANGE = 6;
    public static final int PRESCRIB_HOLD_GATE = 7;
    public static final int PRESCRIB_HOLD_ELEV = 8;
    public static final int PRESCRIB_ELEV_DELTA = 9;
    public static final int PRESCRIB_SET_REL_PERCENT_INFLOW = 10;
    public static final int PRESCRIB_HOLD_PREV_REL = 11;
    public static final int PRESCRIB_HOLD_PREV_GATE = 12;
    public static final String[] PRESCRIB_OP_STRINGS = new String[]{"Undefined", "Set Release", "Rel Inflow + Delta", "Hold Starting Release", "Set Gate", "Elev Target", "Elev ROC", "Hold Starting Gate", "Pass Inflow", "Delta Elev", "Rel % Inflow", "Hold Previous Release", "Hold Previous Gate"};
    public static final String[] PRESCRIB_OP_DESCRIP = new String[]{"Undefined", "Set release to specified Value", "Release net inflow plus specified Value", "Hold release as of the specified Start Date/Time", "Set gate opening to the specified Value", "Reach the pool elevation target Value by the specified End Date/Time", "Manage releases to maintain an elevation rate of change based on the specified Value", "Hold gate opening as of the specified Start Date/Time", "Hold the pool elevation by releasing net inflow", "Reach a pool elevation equal to the elevation at the Start Time plus the specified Value by the End Date/Time", "Release a fraction of the net Inflow as specified by the Value given in %", "Hold release from the previous time step", "Hold gate opening from the previous time step"};
    public static final int[] PRESCRIB_OP_UNITS_PARAMID = new int[]{-1, Parameter.PARAMID_FLOW, Parameter.PARAMID_FLOW, -1, -1, Parameter.PARAMID_ELEV, Parameter.PARAMID_RATE_OF_RISE, -1, -1, Parameter.PARAMID_ELEV, Parameter.PARAMID_PERCENT, -1, -1};
    public static final boolean[] PRESCRIB_OP_ENDTIME_REQD = new boolean[]{false, false, false, false, false, true, false, false, false, true, false, false, false};
    public static final boolean[] PRESCRIB_OP_VALUE_NOTUSED = new boolean[]{false, false, false, true, false, false, false, true, true, false, false, true, true};
    public static final String[] PRESCRIB_OP_RES_STRINGS = new String[]{PRESCRIB_OP_STRINGS[1], PRESCRIB_OP_STRINGS[2], PRESCRIB_OP_STRINGS[10], PRESCRIB_OP_STRINGS[3], PRESCRIB_OP_STRINGS[11], PRESCRIB_OP_STRINGS[8], PRESCRIB_OP_STRINGS[5], PRESCRIB_OP_STRINGS[9], PRESCRIB_OP_STRINGS[6]};
    public static final String[] PRESCRIB_OP_OUTLET_STRINGS = new String[]{PRESCRIB_OP_STRINGS[1], PRESCRIB_OP_STRINGS[2], PRESCRIB_OP_STRINGS[10], PRESCRIB_OP_STRINGS[3], PRESCRIB_OP_STRINGS[11]};
    public static final String[] PRESCRIB_OP_GATE_STRINGS = new String[]{PRESCRIB_OP_STRINGS[1], PRESCRIB_OP_STRINGS[2], PRESCRIB_OP_STRINGS[10], PRESCRIB_OP_STRINGS[3], PRESCRIB_OP_STRINGS[11], PRESCRIB_OP_STRINGS[4], PRESCRIB_OP_STRINGS[7], PRESCRIB_OP_STRINGS[12]};
    protected HecTime _startTime;
    protected HecTime _endTime;
    protected int _opCode;
    protected double _value;

    public PrescribedOpItem() {
        this._startTime = null;
        this._endTime = null;
        this._opCode = 0;
        this._value = Double.NEGATIVE_INFINITY;
    }

    public PrescribedOpItem(HecTime hecTime, HecTime hecTime2, int n, double d) {
        this._startTime = hecTime;
        this._endTime = hecTime2;
        this._opCode = n;
        this._value = d;
    }

    public boolean initializeCompute() {
        if (this._startTime != null) {
            this._startTime.showTimeAsBeginningOfDay(true);
        }
        return true;
    }

    public boolean isEndTimeReqd() {
        return PRESCRIB_OP_ENDTIME_REQD[this._opCode];
    }

    public boolean isValueNotUsed() {
        return PRESCRIB_OP_VALUE_NOTUSED[this._opCode];
    }

    public HecTime getStartTime() {
        return this._startTime;
    }

    public HecTime getEndTime() {
        return this._endTime;
    }

    public void setStartTime(HecTime hecTime) {
        this._startTime = hecTime;
    }

    public void setEndTime(HecTime hecTime) {
        this._endTime = hecTime;
    }

    public int getOpCode() {
        return this._opCode;
    }

    public double getValue() {
        return this._value;
    }

    public void setValue(double d) {
        this._value = d;
    }

    public void setOpCodeString(String string) {
        for (int i = 0; i < PRESCRIB_OP_STRINGS.length; ++i) {
            if (!PRESCRIB_OP_STRINGS[i].equalsIgnoreCase(string)) continue;
            this._opCode = i;
            return;
        }
    }

    public String getOpCodeString() {
        if (this._opCode < 0 || this._opCode >= PRESCRIB_OP_STRINGS.length) {
            return PRESCRIB_OP_RES_STRINGS[0];
        }
        return PRESCRIB_OP_STRINGS[this._opCode];
    }

    public String getOpCodeDescription() {
        if (this._opCode < 0 || this._opCode >= PRESCRIB_OP_DESCRIP.length) {
            return PRESCRIB_OP_DESCRIP[0];
        }
        return PRESCRIB_OP_DESCRIP[this._opCode];
    }

    public int getUnitsParamId() {
        return PRESCRIB_OP_UNITS_PARAMID[this._opCode];
    }

    public synchronized PrescribedOpItem clone() {
        try {
            return (PrescribedOpItem)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("Exception: " + cloneNotSupportedException.getMessage());
            return null;
        }
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public boolean startIsLaterThan(HecTime hecTime) {
        if (this._startTime == null || hecTime == null) {
            return true;
        }
        return this._startTime.greaterThan(hecTime);
    }

    public boolean endIsAtOrAfter(HecTime hecTime) {
        if (this._endTime == null || !this._endTime.isDefined() || hecTime == null) {
            return true;
        }
        return this._endTime.greaterThanEqualTo(hecTime);
    }
}

