/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.HecTime;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.model.RunTimeStep;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.Element;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import hec.rss.model.OperationsElement;
import hec.rss.model.PrescribedOpItem;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Storage;
import hec.rss.model.reports.AlternativeInputReport;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import rma.util.RMAConst;

public class PrescribedOpRule
extends OpRule
implements AsciiSerializable,
Serializable,
Cloneable {
    private List<PrescribedOpItem> _opItemList = new ArrayList<PrescribedOpItem>();
    private transient int[] a;
    private transient doubleArrayContainer b;

    public PrescribedOpRule() {
    }

    public PrescribedOpRule(String string) {
        super(string);
    }

    @Override
    public boolean initializeCompute() {
        int n;
        RssSystem rssSystem = ((RssTSLocationObject)this).getSystem();
        if (rssSystem == null) {
            return false;
        }
        this.h = null;
        if (!super.initializeCompute()) {
            return false;
        }
        if (this._controller == null) {
            return false;
        }
        int n2 = rssSystem.c.getNumSteps();
        this.a = new int[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            this.a[n] = -1;
        }
        this.b = this._controller.getReleaseTSContainer();
        if (this.b == null) {
            return false;
        }
        n2 = this._opItemList.size();
        for (n = 0; n < n2; ++n) {
            PrescribedOpItem prescribedOpItem = this._opItemList.get(n);
            if (prescribedOpItem == null) continue;
            prescribedOpItem.initializeCompute();
        }
        return true;
    }

    @Override
    public TSRecordProxy getTargetTSRecordProxy() {
        TSRecordProxy tSRecordProxy = null;
        Element element = this._controller.getReleaseElement();
        RssNode rssNode = element.getDownstreamNode();
        if (rssNode == null) {
            rssNode = element.getNode(0);
        }
        if (rssNode != null) {
            tSRecordProxy = rssNode.getTSRecordProxy(0);
        }
        return tSRecordProxy;
    }

    @Override
    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
        if (this.h == null || this.a == null) {
            return;
        }
        PrescribedOpItem prescribedOpItem = this.getPrescribedOpItem(runTimeStep);
        double d = prescribedOpItem == null ? Double.NEGATIVE_INFINITY : this.getFlowValue(runTimeStep, prescribedOpItem);
        this.h.array[runTimeStep.step] = d;
    }

    private PrescribedOpItem getPrescribedOpItem(RunTimeStep runTimeStep) {
        if (this._opItemList == null) {
            return null;
        }
        runTimeStep = runTimeStep.getHecTime();
        int n = this._opItemList.size();
        PrescribedOpItem prescribedOpItem = null;
        for (int i = 0; i < n; ++i) {
            PrescribedOpItem prescribedOpItem2 = this._opItemList.get(i);
            if (prescribedOpItem2.startIsLaterThan((HecTime)runTimeStep) || !prescribedOpItem2.endIsAtOrAfter((HecTime)runTimeStep)) continue;
            prescribedOpItem = prescribedOpItem2;
        }
        return prescribedOpItem;
    }

    public double getFlowValue(RunTimeStep runTimeStep, PrescribedOpItem prescribedOpItem) {
        return switch (prescribedOpItem.getOpCode()) {
            case 1 -> prescribedOpItem.getValue();
            case 2 -> this.getRelDeltaInflowValue(runTimeStep, prescribedOpItem.getValue());
            case 10 -> this.getRelPercentInflowValue(runTimeStep, prescribedOpItem.getValue());
            case 3 -> this.getHoldRelValue(runTimeStep, prescribedOpItem.getValue(), prescribedOpItem.getStartTime());
            case 11 -> this.getHoldPrevRelValue(runTimeStep, prescribedOpItem.getValue());
            case 4 -> this.getSetGateValue(runTimeStep, prescribedOpItem.getValue());
            case 7 -> this.getHoldStartingGateValue(runTimeStep, prescribedOpItem.getValue(), prescribedOpItem.getStartTime());
            case 12 -> this.getHoldPrevGateValue(runTimeStep, prescribedOpItem.getValue());
            case 5 -> this.getElevTargetValue(runTimeStep, prescribedOpItem.getValue(), prescribedOpItem.getEndTime());
            case 9 -> this.getElevDeltaValue(runTimeStep, prescribedOpItem.getValue(), prescribedOpItem.getStartTime(), prescribedOpItem.getEndTime());
            case 6 -> this.getElevChangeValue(runTimeStep, prescribedOpItem.getValue());
            case 8 -> this.getHoldElevValue(runTimeStep, prescribedOpItem.getValue());
            default -> Double.NEGATIVE_INFINITY;
        };
    }

    private double getElevChangeValue(RunTimeStep runTimeStep, double d) {
        double d2;
        Object object = this.getOperationsElement();
        object = object.getStorageFunction();
        double d3 = ((Storage)object).getPreviousElevation(runTimeStep);
        double d4 = ((Storage)object).getPreviousStorage(runTimeStep);
        int n = runTimeStep.getTimeStepSeconds();
        double d5 = d3 + d / 3600.0 * (double)n;
        double d6 = ((Storage)object).elevationToStorage(d5);
        double d7 = ((Storage)object).getNetInflow(runTimeStep);
        double d8 = d7 - (d6 - d4) / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q;
        if (d2 < 0.0) {
            d8 = 0.0;
        }
        return d8;
    }

    private double getHoldElevValue(RunTimeStep runTimeStep, double d) {
        double d2;
        double d3;
        Object object = this.getOperationsElement();
        object = object.getStorageFunction();
        double d4 = d3 = ((Storage)object).getNetInflow(runTimeStep);
        if (d2 < 0.0) {
            d4 = 0.0;
        }
        return d4;
    }

    private double getElevTargetValue(RunTimeStep runTimeStep, double d, HecTime hecTime) {
        Object object = this.getOperationsElement();
        object = object.getStorageFunction();
        double d2 = ((Storage)object).getPreviousStorage(runTimeStep);
        double d3 = ((Storage)object).elevationToStorage(d);
        int n = runTimeStep.getHecTime().computeNumberIntervals(hecTime, runTimeStep.getTimeStepMinutes());
        if (n <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        hecTime = new RunTimeStep(runTimeStep);
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            hecTime.step = runTimeStep.step + i;
            double d5 = ((Storage)object).getNetInflowVolume(runTimeStep);
            if (!RMAConst.isValidValue((double)d5)) continue;
            d4 += d5;
        }
        double d6 = (d4 - (d3 - d2)) / (double)(runTimeStep.getTimeStepSeconds() * n) * Storage.DSDT_TO_Q;
        return d6;
    }

    private double getElevDeltaValue(RunTimeStep runTimeStep, double d, HecTime hecTime, HecTime hecTime2) {
        Object object = this.getOperationsElement();
        object = object.getStorageFunction();
        double d2 = ((Storage)object).getPreviousStorage(runTimeStep);
        int n = runTimeStep.getRunTimeWindow().getStepAtTime(hecTime) - 1;
        if (n < 0) {
            n = 0;
        } else if (n > runTimeStep.getTotalNumSteps()) {
            n = runTimeStep.getTotalNumSteps();
        }
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        new RunTimeStep(runTimeStep).step = n;
        double d3 = ((Storage)object).getPreviousElevation(runTimeStep2);
        double d4 = d3 + d;
        double d5 = ((Storage)object).elevationToStorage(d4);
        int n2 = runTimeStep.getHecTime().computeNumberIntervals(hecTime2, runTimeStep.getTimeStepMinutes());
        if (n2 <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        RunTimeStep runTimeStep3 = new RunTimeStep(runTimeStep);
        double d6 = 0.0;
        for (int i = 0; i < n2; ++i) {
            runTimeStep3.step = runTimeStep.step + i;
            double d7 = ((Storage)object).getNetInflowVolume(runTimeStep);
            if (!RMAConst.isValidValue((double)d7)) continue;
            d6 += d7;
        }
        double d8 = (d6 - (d5 - d2)) / (double)(runTimeStep.getTimeStepSeconds() * n2) * Storage.DSDT_TO_Q;
        return d8;
    }

    private double getSetGateValue(RunTimeStep object, double d) {
        double d2;
        double d3 = Double.NEGATIVE_INFINITY;
        Object object2 = this.getOperationsElement();
        object2 = object2.getStorageFunction();
        double d4 = ((Storage)object2).getPreviousElevation((RunTimeStep)object);
        object = this._controller.getReleaseElement().getFunction();
        if (object instanceof AdjustableFlow && RMAConst.isValidValue((double)(d2 = (object = (AdjustableFlow)object).getFlowForGateHeight(d4, d)))) {
            d3 = d2;
        }
        return d3;
    }

    private double getHoldStartingGateValue(RunTimeStep runTimeStep, double d, HecTime hecTime) {
        int n = runTimeStep.getRunTimeWindow().getStepAtTime(hecTime) - 1;
        if (n < 0) {
            n = 0;
        } else if (n > runTimeStep.getTotalNumSteps()) {
            n = runTimeStep.getTotalNumSteps();
        }
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        new RunTimeStep(runTimeStep).step = n;
        return this.getHoldGateValue(runTimeStep, d, runTimeStep2);
    }

    private double getHoldPrevGateValue(RunTimeStep runTimeStep, double d) {
        int n = runTimeStep.step - 1;
        if (n < 0) {
            n = 0;
        } else if (n > runTimeStep.getTotalNumSteps()) {
            n = runTimeStep.getTotalNumSteps();
        }
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        new RunTimeStep(runTimeStep).step = n;
        return this.getHoldGateValue(runTimeStep, d, runTimeStep2);
    }

    private double getHoldGateValue(RunTimeStep object, double d, RunTimeStep runTimeStep) {
        double d2;
        double d3;
        double d4 = Double.NEGATIVE_INFINITY;
        Object object2 = this.getOperationsElement();
        object2 = object2.getStorageFunction();
        double d5 = ((Storage)object2).getPreviousElevation(runTimeStep);
        double d6 = this.b.array[runTimeStep.step];
        double d7 = ((Storage)object2).getPreviousElevation((RunTimeStep)object);
        object = this._controller.getReleaseElement().getFunction();
        if (object instanceof AdjustableFlow && RMAConst.isValidValue((double)(d3 = ((AdjustableFlow)(object = (AdjustableFlow)object)).getFlowForGateHeight(d7, d2 = ((AdjustableFlow)object).getGateHeightForElevFlow(d5, d6))))) {
            d4 = d3;
        }
        return d4;
    }

    private double getHoldRelValue(RunTimeStep runTimeStep, double d, HecTime hecTime) {
        double d2 = Double.NEGATIVE_INFINITY;
        int n = runTimeStep.getRunTimeWindow().getStepAtTime(hecTime) - 1;
        if (n < 0) {
            n = 0;
        } else if (n > runTimeStep.getTotalNumSteps()) {
            n = runTimeStep.getTotalNumSteps();
        }
        double d3 = this.b.array[n];
        if (RMAConst.isValidValue((double)d3)) {
            d2 = d3;
        }
        return d2;
    }

    private double getHoldPrevRelValue(RunTimeStep runTimeStep, double d) {
        double d2 = Double.NEGATIVE_INFINITY;
        int n = runTimeStep.step - 1;
        if (n < 0) {
            n = 0;
        } else if (n > runTimeStep.getTotalNumSteps()) {
            n = runTimeStep.getTotalNumSteps();
        }
        double d3 = this.b.array[n];
        if (RMAConst.isValidValue((double)d3)) {
            d2 = d3;
        }
        return d2;
    }

    private double getRelDeltaInflowValue(RunTimeStep runTimeStep, double d) {
        double d2 = Double.NEGATIVE_INFINITY;
        OperationsElement operationsElement = this.getOperationsElement();
        double d3 = operationsElement.getStorageFunction().getNetInflow(runTimeStep);
        if (RMAConst.isValidValue((double)d3)) {
            d2 = d + d3;
        }
        return d2;
    }

    private double getRelPercentInflowValue(RunTimeStep runTimeStep, double d) {
        double d2 = Double.NEGATIVE_INFINITY;
        OperationsElement operationsElement = this.getOperationsElement();
        double d3 = operationsElement.getStorageFunction().getNetInflow(runTimeStep);
        if (RMAConst.isValidValue((double)d3)) {
            d2 = d * d3 / 100.0;
        }
        return d2;
    }

    @Override
    public OpValue getOpValue(RunTimeStep runTimeStep) {
        if (!RMAConst.isValidValue((double)this.h.array[runTimeStep.step])) {
            return null;
        }
        OpValue opValue = new OpValue();
        new OpValue().value = this.h.array[runTimeStep.step];
        opValue.type = 1;
        return opValue;
    }

    @Override
    public boolean isLocalRule() {
        return true;
    }

    @Override
    public boolean isDnstrmRule() {
        return false;
    }

    @Override
    public boolean isPerAvgRule() {
        return false;
    }

    @Override
    public int getRuleLimitType() {
        return 1;
    }

    @Override
    public Object clone() {
        PrescribedOpRule prescribedOpRule = (PrescribedOpRule)super.clone();
        ((PrescribedOpRule)super.clone())._opItemList = new ArrayList<PrescribedOpItem>();
        int n = this._opItemList.size();
        for (int i = 0; i < n; ++i) {
            PrescribedOpItem prescribedOpItem = this._opItemList.get(i);
            if (prescribedOpItem == null || (prescribedOpItem = prescribedOpItem.clone()) == null) continue;
            prescribedOpRule._opItemList.add(prescribedOpItem);
        }
        return prescribedOpRule;
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        element.setAttribute("Name", this.getDisplayName());
        element.setAttribute("Description", this.getDescription());
        super.outputReport(alternativeInputReport, element);
    }

    public List<PrescribedOpItem> getOpItemList() {
        return this._opItemList;
    }

    public void setOpItemList(List<PrescribedOpItem> list) {
        this._opItemList.clear();
        if (list != null) {
            this._opItemList.addAll(list);
        }
    }

    public String[] getOperators() {
        NamedType namedType = this._controller.getReleaseElement();
        if (namedType == null) {
            return PrescribedOpItem.PRESCRIB_OP_STRINGS;
        }
        if (namedType instanceof ReservoirElement) {
            return PrescribedOpItem.PRESCRIB_OP_RES_STRINGS;
        }
        if ((namedType = namedType.getFunction()) instanceof AdjustableFlow) {
            if (((AdjustableFlow)(namedType = (AdjustableFlow)namedType)).hasMultipleGateSettings()) {
                return PrescribedOpItem.PRESCRIB_OP_GATE_STRINGS;
            }
            return PrescribedOpItem.PRESCRIB_OP_OUTLET_STRINGS;
        }
        return PrescribedOpItem.PRESCRIB_OP_STRINGS;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

