/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.DataSetException;
import hec.data.Parameter;
import hec.data.Units;
import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.model.ValuePair;
import hec.rss.model.Element;
import hec.rss.model.Routing;
import hec.rss.model.RssTSLocationObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Vector;

public class PulsChannelRouting
extends Routing {
    PairedValues _storOutflowTable = new PairedValues();
    int _numberStorageOutflow;
    int _numberReaches = 5;
    private transient PairedValues a;
    private transient double[] b;
    private transient double[] c;
    private transient double[] d = new double[2];
    private transient double[] e = new double[2];
    private transient boolean f = false;
    private transient boolean g = true;
    private static double h = Math.pow(0.3048, 3.0);
    private static double i = 1233.4817230346482;

    public PulsChannelRouting() {
    }

    public PulsChannelRouting(Element element) {
        super(element);
    }

    @Override
    public void setupForSerialization() {
        super.setupForSerialization();
        if (this._storOutflowTable == null) {
            return;
        }
        Object object = new DSSPathname();
        object.setAPart(this.getElement().getSystem().getName());
        object.setBPart(this.getOutputBPart());
        Object object2 = Parameter.getParamString((int)Parameter.PARAMID_ELEV) + "-" + Parameter.getParamString((int)Parameter.PARAMID_FLOW);
        object.setCPart((String)object2);
        object2 = this.getElement().getSystem().getDssPairedDataFilePath();
        object = object.getPathname();
        this._storOutflowTable.setDssIdentifer(new DSSIdentifier((String)object2, (String)object));
        this._storOutflowTable.setParamXId(Parameter.PARAMID_ELEV);
        this._storOutflowTable.setParamYId(Parameter.PARAMID_FLOW);
        this._storOutflowTable.setUnitSystem(this.getUnitSystem());
    }

    @Override
    public synchronized Object clone() {
        PulsChannelRouting pulsChannelRouting = (PulsChannelRouting)super.clone();
        if (this._storOutflowTable != null) {
            pulsChannelRouting._storOutflowTable = (PairedValues)this._storOutflowTable.clone();
        }
        return pulsChannelRouting;
    }

    @Override
    public int computeRouting(RunTimeStep runTimeStep) {
        this.g = this.getUnitSystem() == 2;
        int n = runTimeStep.step;
        int n2 = runTimeStep.nstep;
        runTimeStep.getTimeStepMinutes();
        if (n2 > this.d.length) {
            this.d = new double[n2];
            this.e = new double[n2];
        }
        System.arraycopy(this._tsUpstrm, n, this.d, 0, n2);
        if (!this.f) {
            for (int i = 0; i < this._numberReaches; ++i) {
                this.b[i] = this._tsUpstrm[runTimeStep.step];
            }
            double d = runTimeStep.getTimeStepSeconds();
            this.buildStorageIndicationTable(d);
        }
        byte[] cfr_ignored_0 = new byte[81];
        for (int i = 0; i < n2; ++i) {
            double d = this.d[i];
            double d2 = i > 0 ? this.d[i - 1] : this.d[0];
            this.e[i] = this.computeRoutingStep(d2, d, runTimeStep);
            if (runTimeStep != null && ((RssTSLocationObject)this).getSystem().b && ((RssTSLocationObject)this).getSystem().shouldSaveHotstartAtTimeStep(i, runTimeStep.flag)) {
                ArrayList<Element> arrayList = new ArrayList<Element>(1);
                Element element = this.element.getTopParent();
                arrayList.add(element);
                ((RssTSLocationObject)this).getSystem().checkSaveHotstart(i, runTimeStep.flag, arrayList);
            }
            if (i != runTimeStep.rtw.getForecastSteps() - runTimeStep.rtw.getNumRoutingSteps() - 1) continue;
            this.element.saveElementState(4);
        }
        String string = "";
        if ("".length() > 0) {
            System.out.println("PulsChannelRouting");
            System.out.println(string);
        }
        if (!this.f) {
            for (int i = 0; i < this._numberReaches; ++i) {
                this.b[i] = this.c[i];
            }
            this.f = true;
        }
        for (int i = 0; i < n2; ++i) {
            this._tsDnstrm[i + n] = this.e[i];
        }
        return this.checkForecastCalc(runTimeStep, true);
    }

    private double computeRoutingStep(double d, double d2, RunTimeStep runTimeStep) {
        int n;
        int n2 = this._numberReaches;
        double d3 = d;
        double d4 = d2;
        this.a.getXValue(d);
        for (n = 0; n < n2; ++n) {
            double d5;
            double d6;
            double d7 = runTimeStep.isPerAvgTimeStep() ? d4 : 0.5 * (d3 + d4);
            double d8 = this.b[n];
            double d9 = this.a.getXValue(d8);
            double d10 = d9 - d8 + d7;
            if (d6 < 0.0) {
                d10 = 0.0;
            }
            this.c[n] = d5 = this.a.getYValue(d10);
            d3 = d8;
            d4 = d5;
        }
        for (n = 0; n < n2; ++n) {
            this.b[n] = this.c[n];
        }
        return this.c[n2 - 1];
    }

    @Override
    public boolean initialize() {
        if (!super.initialize()) {
            return false;
        }
        String string = System.getProperty("SKIP_INITIALIZE");
        if (string == null || string.equals("true")) {
            this.f = false;
            this.b = new double[this._numberReaches];
            this.c = new double[this._numberReaches];
        }
        return true;
    }

    private void buildStorageIndicationTable(double d) {
        String string;
        double d2 = 1.0;
        if (this.getUnitSystem() == 1) {
            String string2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_STOR, (int)2);
            String string3 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)2);
            String string4 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_STOR, (int)1);
            string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)1);
            try {
                double d3 = Units.getScalarFactor((String)string, (String)string3);
                double d4 = Units.getScalarFactor((String)string4, (String)string2);
                d2 = d4 / d3;
            }
            catch (DataSetException dataSetException) {
                System.out.println(dataSetException.getMessage());
                this.element.getSystem().printErrorMessage(dataSetException.getMessage());
                dataSetException.printStackTrace();
            }
        }
        double d5 = d2 / d;
        int n = this._storOutflowTable.size();
        Vector vector = this._storOutflowTable.getDataVector();
        this.a = new PairedValues();
        for (int i = 0; i < n; ++i) {
            string = (ValuePair)vector.elementAt(i);
            if (string == null) continue;
            double d6 = ((ValuePair)string).yval;
            double d7 = ((ValuePair)string).xval / (double)this._numberReaches;
            double d8 = d7 * d5 + d6 * 0.5;
            this.a.addPair(d8, d6);
        }
    }

    public void setstorOutflowTable(PairedValues object) {
        if (object.getUnitSystem() == 0) {
            object.setUnitSystem(this.getUnitSystem());
            object.setParamXId(Parameter.PARAMID_STOR);
            object.setParamYId(Parameter.PARAMID_FLOW);
            this._storOutflowTable = object;
            return;
        }
        if (object.getUnitSystem() == this.getUnitSystem()) {
            this._storOutflowTable = object;
            return;
        }
        PairedValues pairedValues = new PairedValues();
        object = object.getDataVector();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            ValuePair valuePair = (ValuePair)((Vector)object).elementAt(i);
            double d = valuePair.xval * PulsChannelRouting.i;
            double d2 = valuePair.yval * h;
            pairedValues.addPair(d, d2);
        }
        this._storOutflowTable = pairedValues;
    }

    public void setnumberReaches(int n) {
        this._numberReaches = n == Integer.MIN_VALUE || n <= 0 ? 1 : n;
        this.b = new double[this._numberReaches];
        this.c = new double[this._numberReaches];
        this.f = false;
    }

    public PairedValues getstorOutflowTable() {
        this._storOutflowTable.setUnitSystem(this.getUnitSystem());
        this._storOutflowTable.setParamXId(Parameter.PARAMID_STOR);
        this._storOutflowTable.setParamYId(Parameter.PARAMID_FLOW);
        return this._storOutflowTable;
    }

    public int getnumberReaches() {
        return this._numberReaches;
    }

    public void setIsSI(boolean bl) {
        this.g = bl;
    }

    public void convertToWatershedUnits() {
        if (this.getUnitSystem() == 2) {
            return;
        }
        String string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_STOR, (int)2);
        String string2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_STOR, (int)1);
        String string3 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)2);
        String string4 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)1);
        PairedValues pairedValues = new PairedValues();
        Vector vector = this._storOutflowTable.getDataVector();
        for (int i = 0; i < vector.size(); ++i) {
            ValuePair valuePair = (ValuePair)vector.elementAt(i);
            try {
                double d = Units.convertUnits((double)valuePair.xval, (String)string, (String)string2);
                double d2 = Units.convertUnits((double)valuePair.yval, (String)string3, (String)string4);
                System.out.println("PulsChannelRouting - Storage Outflow Table (" + d + "," + d2 + ")");
                pairedValues.addPair(d, d2);
                continue;
            }
            catch (DataSetException dataSetException) {
                System.out.println(dataSetException.getMessage());
                this.element.getSystem().printErrorMessage(dataSetException.getMessage());
                dataSetException.printStackTrace();
            }
        }
        this._storOutflowTable = pairedValues;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

