/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.DataSetException;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.Units;
import hec.model.Interpolate;
import hec.model.RunTimeStep;
import hec.rss.model.Element;
import hec.rss.model.HotstartState;
import hec.rss.model.PulsChannelRouting;
import hec.rss.model.PulsChannelRoutingWLossesHotstartState;
import hec.rss.model.PulsChannelRoutingWithLosses$SubReachData;
import hec.rss.model.PulsRecord;
import hec.rss.model.Routing;
import hec.rss.model.RoutingHotstartState;
import hec.rss.model.reports.AlternativeInputReport;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Vector;
import org.jdom.Content;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class PulsChannelRoutingWithLosses
extends Routing {
    Vector _pulsVector = new Vector();
    int _numberStorageOutflow = 1;
    int _numberReaches;
    boolean _hasChannelLosses = false;
    double _invertElevation;
    double _percolationRate;
    double _muskingumX = 0.0;
    private transient double[] e;
    private transient double[] f;
    private transient double[] g;
    private transient double[] h;
    transient double[][] a;
    transient double[][] b;
    private transient boolean[] i;
    private transient boolean j;
    transient Object[] c;
    transient Object[] d;
    private transient boolean k = true;

    public PulsChannelRoutingWithLosses() {
    }

    public PulsChannelRoutingWithLosses(Element element) {
        super(element);
    }

    @Override
    public synchronized Object clone() {
        PulsChannelRoutingWithLosses pulsChannelRoutingWithLosses = (PulsChannelRoutingWithLosses)super.clone();
        ((PulsChannelRoutingWithLosses)super.clone())._pulsVector = new Vector();
        for (int i = 0; i < this._pulsVector.size(); ++i) {
            PulsRecord pulsRecord = (PulsRecord)this._pulsVector.elementAt(i);
            if (pulsRecord == null) continue;
            pulsRecord = (PulsRecord)pulsRecord.clone();
            pulsChannelRoutingWithLosses._pulsVector.addElement(pulsRecord);
        }
        return pulsChannelRoutingWithLosses;
    }

    public double getMuskingumX() {
        return this._muskingumX;
    }

    public void setMuskingumX(double d) {
        if (d < 0.0 || d > 0.5) {
            throw new IllegalArgumentException("Invalid MuskingumX value in " + this.getClass().getName() + " = " + d);
        }
        this._muskingumX = d;
    }

    @Override
    public int computeRouting(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, Object[] objectArray, double[] dArray3) {
        int n;
        int n2;
        if (dArray == null || dArray2 == null || dArray3 == null) {
            return 1;
        }
        for (n2 = 0; n2 < runTimeStep.nstep; ++n2) {
            dArray3[n2] = 0.0;
        }
        this.k = this.getUnitSystem() == 2;
        n2 = runTimeStep.step;
        int n3 = runTimeStep.nstep;
        if (!this.i[runTimeStep.step]) {
            double d = runTimeStep.getTimeStepSeconds();
            if (!this.buildInterpolationTables(d)) {
                return 1;
            }
            double d2 = dArray[runTimeStep.step];
            for (int i = 0; i < this._numberReaches; ++i) {
                this.b[runTimeStep.step][i] = d2;
                this.a[runTimeStep.step][i] = d2;
            }
            this.i[runTimeStep.step] = true;
        }
        if ((n = n2 - 1) >= 0) {
            PulsChannelRoutingWithLosses$SubReachData pulsChannelRoutingWithLosses$SubReachData = (PulsChannelRoutingWithLosses$SubReachData)objectArray[n];
            System.arraycopy(pulsChannelRoutingWithLosses$SubReachData.b, 0, this.a[runTimeStep.step], 0, this.a[runTimeStep.step].length);
            System.arraycopy(pulsChannelRoutingWithLosses$SubReachData.a, 0, this.b[runTimeStep.step], 0, this.b[runTimeStep.step].length);
        } else {
            double d = dArray[0];
            for (int i = 0; i < this._numberReaches; ++i) {
                this.b[runTimeStep.step][i] = d;
                this.a[runTimeStep.step][i] = d;
            }
        }
        for (int i = 0; i < n3; ++i) {
            double d = dArray[i + n2];
            double d3 = i + n2 - 1 > 0 ? dArray[i + n2 - 1] : dArray[0];
            dArray3[i] = this.computeRoutingStep(d3, d, runTimeStep);
            PulsChannelRoutingWithLosses$SubReachData pulsChannelRoutingWithLosses$SubReachData = (PulsChannelRoutingWithLosses$SubReachData)objectArray[i + n2];
            System.arraycopy(this.a[runTimeStep.step], 0, pulsChannelRoutingWithLosses$SubReachData.b, 0, this.a[runTimeStep.step].length);
            System.arraycopy(this.b[runTimeStep.step], 0, pulsChannelRoutingWithLosses$SubReachData.a, 0, this.b[runTimeStep.step].length);
        }
        return 0;
    }

    @Override
    public int computeRouting(RunTimeStep runTimeStep) {
        double d;
        double d2;
        this.k = this.getUnitSystem() == 2;
        int n = runTimeStep.step;
        int n2 = runTimeStep.nstep;
        if (!this.j) {
            d2 = runTimeStep.getTimeStepSeconds();
            if (!this.buildInterpolationTables(d2)) {
                return 1;
            }
            d = this._tsUpstrm[runTimeStep.step];
            for (int i = 0; i < this._numberReaches; ++i) {
                this.b[runTimeStep.step][i] = d;
                this.a[runTimeStep.step][i] = d;
            }
            this.j = true;
        }
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        new RunTimeStep(runTimeStep).nstep = 1;
        for (int i = 0; i < n2; ++i) {
            runTimeStep2.step = i + n;
            d = this._tsUpstrm[i + n];
            d2 = i + n - 1 > 0 ? this._tsUpstrm[i + n - 1] : this._tsUpstrm[0];
            this._tsDnstrm[i + n] = this.computeRoutingStep(d2, d, runTimeStep2);
        }
        return this.checkForecastCalc(runTimeStep, true);
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        double d = this._tsUpstrm[runTimeStep.step];
        double d2 = runTimeStep.step > 0 ? this._tsUpstrm[runTimeStep.step - 1] : this._tsUpstrm[0];
        this._tsDnstrm[runTimeStep.step] = this.computeRoutingStep(d2, d, runTimeStep);
        return this.checkForecastStepCalc(runTimeStep, true);
    }

    private double computeRoutingStep(double d, double d2, RunTimeStep runTimeStep) {
        int n = this._numberReaches;
        double d3 = d;
        double d4 = d2;
        for (int i = 0; i < n; ++i) {
            double d5;
            double d6;
            double d7 = 0.5 * (d3 + d4);
            int n2 = runTimeStep.step > 0 ? runTimeStep.step - 1 : 0;
            double d8 = this.a[n2][i];
            double d9 = Interpolate.linearInterpolate((double[])this.g, (double[])this.f, (double)d8, (int)this._numberStorageOutflow);
            double d10 = d9 - d8 + d7;
            if (d6 < 0.0) {
                d10 = 0.0;
            }
            double d11 = Interpolate.linearInterpolate((double[])this.f, (double[])this.g, (double)d10, (int)this._numberStorageOutflow);
            double d12 = this._muskingumX > 0.0 ? d11 - this._muskingumX / (1.0 - this._muskingumX) * (d4 - d11) : d11;
            if (d12 < 0.0) {
                d12 = 0.0;
            }
            double d13 = 0.0;
            if (this._hasChannelLosses && this._percolationRate > 0.0) {
                double d14;
                double d15 = Interpolate.linearInterpolate((double[])this.f, (double[])this.h, (double)d10, (int)this._numberStorageOutflow);
                double d16 = d15 - this._invertElevation;
                if (d14 > 0.0) {
                    double d17 = Interpolate.linearInterpolate((double[])this.g, (double[])this.e, (double)d12, (int)this._numberStorageOutflow);
                    double d18 = (d17 /= (double)n) / d16;
                    d13 = this._percolationRate * d18;
                }
            }
            d12 -= d13;
            if (d5 < 0.0) {
                d12 = 0.0;
            }
            this.a[runTimeStep.step][i] = d11;
            d3 = this.b[n2][i];
            this.b[runTimeStep.step][i] = d12;
            d4 = d12;
        }
        return this.b[runTimeStep.step][n - 1];
    }

    @Override
    public boolean initialize() {
        if (!super.initialize()) {
            return false;
        }
        String string = System.getProperty("SKIP_INITIALIZE");
        if (string == null || string.equals("true")) {
            this.j = false;
            int n = this.getElement().getSystem().getRssRun().getRunTimeWindow().getNumSteps() + 1;
            this.i = new boolean[n];
            this.b = new double[n][this._numberReaches];
            this.a = new double[n][this._numberReaches];
            this.c = new Object[7];
            for (n = 0; n < 7; ++n) {
                this.c[n] = new double[this._numberReaches];
            }
            this.d = new Object[7];
            for (n = 0; n < 7; ++n) {
                this.d[n] = new double[this._numberReaches];
            }
        }
        return true;
    }

    @Override
    public void saveFunctionState(int n) {
        if (this.c == null || n >= this.c.length) {
            return;
        }
        if (this.d == null || n >= this.d.length) {
            return;
        }
        double[] dArray = (double[])this.c[n];
        if (dArray == null || dArray.length < this.b.length) {
            return;
        }
        System.arraycopy(this.b, 0, dArray, 0, this.b.length);
        dArray = (double[])this.d[n];
        if (dArray == null || dArray.length < this.a.length) {
            return;
        }
        System.arraycopy(this.a, 0, dArray, 0, this.a.length);
    }

    @Override
    public void restoreFunctionState(int n) {
        if (this.c == null || n >= this.c.length) {
            return;
        }
        if (this.d == null || n >= this.d.length) {
            return;
        }
        double[] dArray = (double[])this.c[n];
        if (dArray == null || dArray.length < this.b.length) {
            return;
        }
        System.arraycopy(dArray, 0, this.b, 0, this.b.length);
        dArray = (double[])this.d[n];
        if (dArray == null || dArray.length < this.a.length) {
            return;
        }
        System.arraycopy(dArray, 0, this.a, 0, this.a.length);
        if (n == 6) {
            Arrays.fill(this.i, false);
        }
    }

    @Override
    public void saveHotstartState(HotstartState hotstartState, int n) {
        PulsChannelRoutingWLossesHotstartState pulsChannelRoutingWLossesHotstartState = (PulsChannelRoutingWLossesHotstartState)hotstartState.getChildState(this.getName(), this.getClass().getName());
        if (pulsChannelRoutingWLossesHotstartState == null) {
            pulsChannelRoutingWLossesHotstartState = new PulsChannelRoutingWLossesHotstartState(this);
            hotstartState.addChildState(pulsChannelRoutingWLossesHotstartState);
        }
        ((HotstartState)pulsChannelRoutingWLossesHotstartState).saveState(n);
    }

    @Override
    public boolean restoreHotstartState(HotstartState hotstartState) {
        if ((hotstartState = (PulsChannelRoutingWLossesHotstartState)hotstartState.getChildState(this.getName(), this.getClass().getName())) != null) {
            ((RoutingHotstartState)hotstartState).routing(this);
            return hotstartState.restoreState();
        }
        PulsChannelRoutingWithLosses pulsChannelRoutingWithLosses = this;
        pulsChannelRoutingWithLosses.printErrorMessage("Failed to find PulsChannelRoutingWithLosses hotstart state for " + String.valueOf(pulsChannelRoutingWithLosses.getElement()));
        return false;
    }

    public void setinvertElevation(ParamDouble paramDouble) {
        if (paramDouble.getUnitSystem() == this.getUnitSystem()) {
            this._invertElevation = paramDouble.getValue();
            return;
        }
        this._invertElevation = paramDouble.convertToUnitSystem(this.getUnitSystem());
    }

    public void setnumberReaches(int n) {
        if (n == Integer.MIN_VALUE) {
            this._numberReaches = 0;
            return;
        }
        this._numberReaches = n;
    }

    public Vector getPulsVector() {
        return (Vector)this._pulsVector.clone();
    }

    public void setPulsVector(Vector vector) {
        this._pulsVector = vector;
    }

    public void addPulsRecord(PulsRecord pulsRecord) {
        this._pulsVector.addElement(pulsRecord);
    }

    public void emptyPulsVector() {
        this._pulsVector.removeAllElements();
    }

    public void getinvertElevation(ParamDouble paramDouble) {
        paramDouble.setValue(this._invertElevation);
        paramDouble.setParameterId(Parameter.PARAMID_ELEV);
        paramDouble.setUnitSystem(this.getUnitSystem());
    }

    public void setpercolationRate(ParamDouble paramDouble) {
        if (paramDouble.getParameterId() != Parameter.PARAMID_PERCRATE) {
            throw new IllegalArgumentException("ERROR <PulsChannelRoutingWithLosses.setpercolationRate()> : Illegal Paramter Value, not of type PERCOLATION RATE");
        }
        if (paramDouble.getUnitSystem() == this.getUnitSystem()) {
            this._percolationRate = paramDouble.getValue();
            return;
        }
        this._percolationRate = paramDouble.convertToUnitSystem(this.getUnitSystem());
    }

    public void getpercolationRate(ParamDouble paramDouble) {
        paramDouble.setValue(this._percolationRate);
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_PERCRATE);
    }

    public int getnumberReaches() {
        return this._numberReaches;
    }

    public void setIsSI(boolean bl) {
        this.k = bl;
    }

    public void setHasChannelLosses(boolean bl) {
        this._hasChannelLosses = bl;
    }

    public boolean getHasChannelLosses() {
        return this._hasChannelLosses;
    }

    private boolean buildInterpolationTables(double d) {
        double d2;
        double d3;
        double d4;
        String string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_STOR, (int)this.getUnitSystem());
        String string2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)this.getUnitSystem());
        String string3 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)this.getUnitSystem());
        try {
            d4 = Units.getStorageToFlowConversion((String)string, (String)string2);
            d4 /= d;
            double d5 = Units.convertUnits((double)1.0, (String)string, (String)"m3");
            d3 = Units.convertUnits((double)1.0, (String)string3, (String)"m");
            d2 = d5 / Math.pow(d3, 3.0);
        }
        catch (DataSetException dataSetException) {
            System.out.println(dataSetException.getMessage());
            dataSetException.printStackTrace();
            String string4 = "\n     PulsChannelRoutingWithLosses: Problem with storage to flow units conversion.";
            this.printErrorMessage(string4);
            return false;
        }
        int n = this._pulsVector.size();
        this._numberStorageOutflow = 0;
        this.e = new double[n];
        this.f = new double[n];
        this.g = new double[n];
        this.h = new double[n];
        for (int i = 0; i < n; ++i) {
            PulsRecord pulsRecord = (PulsRecord)this._pulsVector.elementAt(i);
            if (pulsRecord == null) continue;
            if (!RMAConst.isValidValue((double)pulsRecord.outflow) || !RMAConst.isValidValue((double)pulsRecord.stor)) {
                Object object = "\n     Problem with Puls Storage-Outflow table.";
                object = "\n     Problem with Puls Storage-Outflow table." + " - " + this.element.getName() + "\n";
                this.printErrorMessage((String)object);
                return false;
            }
            if (this._hasChannelLosses && !RMAConst.isValidValue((double)pulsRecord.elev)) {
                Object object = "\n     Problem with Puls Storage-Outflow-Elevation table.";
                object = "\n     Problem with Puls Storage-Outflow-Elevation table." + " - " + this.element.getName() + "\n";
                this.printErrorMessage((String)object);
                return false;
            }
            double d6 = pulsRecord.outflow;
            d3 = pulsRecord.stor / (double)this._numberReaches;
            double d7 = d3 * (1.0 - this._muskingumX) * d4 + d6 * 0.5;
            this.e[this._numberStorageOutflow] = pulsRecord.stor;
            this.f[this._numberStorageOutflow] = d7;
            this.g[this._numberStorageOutflow] = d6;
            this.h[this._numberStorageOutflow] = pulsRecord.elev;
            int n2 = this._numberStorageOutflow++;
            this.e[n2] = this.e[n2] * d2;
        }
        return true;
    }

    public void convertToWatershedUnits() {
        if (this.getUnitSystem() == 2) {
            return;
        }
        try {
            for (int i = 0; i < this._pulsVector.size(); ++i) {
                PulsChannelRoutingWithLosses pulsChannelRoutingWithLosses = this;
                pulsChannelRoutingWithLosses.convertPulseRecord((PulsRecord)pulsChannelRoutingWithLosses._pulsVector.elementAt(i), 2, 1);
            }
            String string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)2);
            String string2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)1);
            Units.convertUnits((double)this._invertElevation, (String)string, (String)string2);
            this._invertElevation = RMAIO.parseDouble((String)RMAIO.setPrecision2((double)this._invertElevation, (int)2));
            string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_PERCRATE, (int)2);
            string2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_PERCRATE, (int)1);
            Units.convertUnits((double)this._percolationRate, (String)string, (String)string2);
            this._percolationRate = RMAIO.parseDouble((String)RMAIO.setPrecision2((double)this._percolationRate, (int)2));
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    private void convertPulseRecord(PulsRecord pulsRecord, int n, int n2) {
        try {
            String string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n);
            String string2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n2);
            pulsRecord.elev = Units.convertUnits((double)pulsRecord.elev, (String)string, (String)string2);
            string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_STOR, (int)n);
            string2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_STOR, (int)n2);
            pulsRecord.stor = Units.convertUnits((double)pulsRecord.stor, (String)string, (String)string2);
            string2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)n2);
            string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)n);
            pulsRecord.outflow = Units.convertUnits((double)pulsRecord.outflow, (String)string, (String)string2);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    public void copyDataFromPulChannelRouting(PulsChannelRouting pulsChannelRouting) {
        if (pulsChannelRouting == null) {
            return;
        }
        this._hasChannelLosses = false;
        this._invertElevation = Double.NEGATIVE_INFINITY;
        this._percolationRate = Double.NEGATIVE_INFINITY;
        this._numberReaches = pulsChannelRouting.getnumberReaches();
        pulsChannelRouting = pulsChannelRouting.getstorOutflowTable();
        int n = pulsChannelRouting.size();
        this.emptyPulsVector();
        for (int i = 0; i < n; ++i) {
            PulsRecord pulsRecord = new PulsRecord();
            new PulsRecord().stor = pulsChannelRouting.getXValue(i);
            pulsRecord.outflow = pulsChannelRouting.getYValue(i);
            this.addPulsRecord(pulsRecord);
        }
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        element.setAttribute("NumberOfSubReaches", Integer.toString(this._numberReaches));
        if (this._hasChannelLosses) {
            element.setAttribute("InvertElev", Double.toString(this._invertElevation));
            element.setAttribute("PercolationRate", Double.toString(this._percolationRate));
        }
        for (int i = 0; i < this._pulsVector.size(); ++i) {
            alternativeInputReport = new org.jdom.Element("PulsRecord" + Integer.toString(i));
            element.addContent((Content)alternativeInputReport);
            PulsRecord pulsRecord = (PulsRecord)this._pulsVector.get(i);
            alternativeInputReport.setAttribute("Storage", Double.toString(pulsRecord.stor));
            alternativeInputReport.setAttribute("Outflow", Double.toString(pulsRecord.outflow));
            alternativeInputReport.setAttribute("Elevation", Double.toString(pulsRecord.elev));
        }
    }

    @Override
    public Object newRouteData() {
        PulsChannelRoutingWithLosses pulsChannelRoutingWithLosses = this;
        return new PulsChannelRoutingWithLosses$SubReachData(pulsChannelRoutingWithLosses, pulsChannelRoutingWithLosses._numberReaches);
    }

    @Override
    public boolean initializeStandalone() {
        this.j = false;
        if (this._numberReaches <= 0 || this._numberReaches == Integer.MIN_VALUE) {
            this._numberReaches = 1;
        }
        int n = this.getElement().getSystem().getRssRun().getRunTimeWindow().getNumSteps() + 1;
        this.i = new boolean[n];
        this.b = new double[n][this._numberReaches];
        this.a = new double[n][this._numberReaches];
        this.c = new Object[7];
        for (n = 0; n < 7; ++n) {
            this.c[n] = new double[this._numberReaches];
        }
        this.d = new Object[7];
        for (n = 0; n < 7; ++n) {
            this.d[n] = new double[this._numberReaches];
        }
        return true;
    }

    @Override
    public int getNumberSubreaches() {
        return this._numberReaches;
    }

    @Override
    public double[] getSubreachFlowArray(double d, double d2, int n) {
        double[] dArray = new double[this._numberReaches + 1];
        for (int i = 0; i < this._numberReaches; ++i) {
            dArray[i + 1] = this.a[n][i];
        }
        dArray[0] = d;
        return dArray;
    }
}

