/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.lang.DSSPathString;
import hec.model.RunTimeStep;
import hec.model.TSLocation;
import hec.rss.model.Function;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOutletElement;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RunTime;
import java.lang.reflect.Field;
import rma.util.RMAConst;

public class PulseRoutingFunction
extends Function {
    private transient boolean a;
    private transient double[] b;
    private transient double[] c = new double[]{Double.NEGATIVE_INFINITY};
    private transient double d;
    private transient double e;
    private transient boolean f;
    private transient RunTime g;
    private transient int h;
    private transient int i = 12;
    private transient int j;
    private transient double[] k;
    private transient double[] l;
    private transient boolean m = false;

    public PulseRoutingFunction() {
    }

    public PulseRoutingFunction(ReservoirOutletElement reservoirOutletElement, boolean bl) {
        super(reservoirOutletElement);
        this.a = bl;
    }

    @Override
    public void updateTSProxyList() {
        super.updateTSProxyList();
        Object object = this.getTSRecordProxy(90);
        if (object == null) {
            this.addTSRecordProxy(90);
        }
        if ((object = this.getTSRecordProxy(91)) == null) {
            this.addTSRecordProxy(91);
        }
        if (this.getTSRecordProxy(0) == null) {
            object = this.element.getDownstreamNode();
            object = RssModelVariableSet.newTSRecordProxy(this.element.getSystem(), (TSLocation)object, 0);
            if (object != null) {
                this._tsrecordVector.addElement(object);
            }
        }
    }

    @Override
    public void setupForSerialization() {
        super.setupForSerialization();
    }

    @Override
    public synchronized Object clone() {
        PulseRoutingFunction pulseRoutingFunction = (PulseRoutingFunction)super.clone();
        return pulseRoutingFunction;
    }

    public double getPulseQ() {
        return this.d;
    }

    public double getOutletQ() {
        return this.e;
    }

    public int getPulseStep() {
        return this.i;
    }

    public double computeStepFlow(RunTimeStep runTimeStep) {
        double d = this.e;
        if (!this.a) {
            d = 0.0;
        } else if (this.m) {
            d = this.l[runTimeStep.step];
        } else if (runTimeStep.step == runTimeStep.getRunTimeWindow().getNumLookbackSteps() + this.i + 1) {
            d = this.d;
            this.h = runTimeStep.step;
        }
        if (this.b != null) {
            this.b[runTimeStep.step] = d;
        }
        return d;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        if (this.b == null) {
            return 1;
        }
        if (!this.a) {
            this.b[runTimeStep.step] = 0.0;
            return 0;
        }
        if (this.m) {
            this.b[runTimeStep.step] = this.l[runTimeStep.step];
            return 0;
        }
        if (this.f && this.j == this.i) {
            this.b[runTimeStep.step] = this.d;
            this.f = false;
            this.h = runTimeStep.step;
        } else {
            this.b[runTimeStep.step] = this.e;
            ++this.j;
        }
        return 0;
    }

    @Override
    public int computeHindcastStep(RunTimeStep runTimeStep) {
        if (!this.a) {
            this.b[runTimeStep.step] = 0.0;
            return 0;
        }
        if (this.m) {
            this.b[runTimeStep.step] = this.l[runTimeStep.step];
            return 0;
        }
        this.b[runTimeStep.step] = this.e;
        return 0;
    }

    @Override
    public boolean getForecastEquation(RunTime runTime) {
        if (this.b == null) {
            return false;
        }
        if (this.m) {
            this.b[runTime.step] = this.l[runTime.step];
            return true;
        }
        if (this.f && this.j == this.i) {
            this.b[runTime.step] = this.d;
            this.f = false;
            this.g = (RunTime)runTime.clone();
        } else {
            this.b[runTime.step] = this.e;
            ++this.j;
        }
        return true;
    }

    public void setUseNewReleaseQ(boolean bl) {
        this.m = bl;
    }

    @Override
    public boolean getHindcastEquation(RunTime runTime) {
        if (this.m) {
            this.b[runTime.step] = this.l[runTime.step];
            return true;
        }
        this.b[runTime.step] = this.e;
        return true;
    }

    @Override
    public boolean initialize() {
        Object object = (ReservoirOutletElement)this.element;
        ReservoirElement reservoirElement = (ReservoirElement)this.element.getTopParent();
        this.e = 5000.0;
        if (!((ReservoirOutletElement)object).getUseDefaultPulseFlow() && RMAConst.isValidValue((double)((ReservoirOutletElement)object).getPulseFlow())) {
            this.e = ((ReservoirOutletElement)object).getPulseFlow();
        } else if (RMAConst.isValidValue((double)reservoirElement.getSystem().getDefaultPulseFlow())) {
            this.e = reservoirElement.getSystem().getDefaultPulseFlow();
        }
        if (this.e < 0.01) {
            object = "\nPulse Flow for " + reservoirElement.getName() + " " + object.getName() + " is zero or negative\nPluse Flow = " + this.e;
            this.printErrorMessage("initiailize", (String)object);
            return false;
        }
        this.d = 0.5 * this.e;
        this.f = true;
        this.g = null;
        this.b = this.element.getDownstreamNode().getTSArray(0);
        if (this.b == null) {
            return false;
        }
        this.j = 0;
        return true;
    }

    public boolean computeResponse(RssNode rssNode) {
        rssNode.getTSArray("Flow");
        this.calculateLagFlow(rssNode);
        return true;
    }

    public boolean calculateLagFlow(RssNode object) {
        int n;
        TSDataSet tSDataSet = this.element.getSystem().getOutputTSDataSet();
        if (tSDataSet == null) {
            return false;
        }
        if ((object = tSDataSet.getTSRecord(object.getName(), "FLOW")) == null) {
            return false;
        }
        DSSPathString dSSPathString = new DSSPathString(object.getDSSPathname());
        dSSPathString.setCPart("FLOW");
        object.setDSSPathname(dSSPathString.getPathname());
        tSDataSet.loadTSRecord(object.getName(), object.getParamName(), "");
        double[] dArray = object.getTSArray();
        object = dArray;
        int n2 = dArray.length;
        double[] dArray2 = new double[n2 + 1];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = 0.0;
        }
        for (n = 0; n < n2; ++n) {
            dArray2[n] = (double)(object[n] - 3500.0);
        }
        dArray2[n2 - 1] = -3500.0;
        this.k = new double[n2 + 1];
        for (n = 0; n < n2; ++n) {
            if (!(this.k[n] < 0.0)) continue;
            this.k[n] = 0.0;
        }
        this.l = new double[n2 + 1];
        object = this.getRegFlow();
        for (n = 0; n < n2; ++n) {
            this.k[n] = 0.0;
        }
        for (n = 0; n < n2; ++n) {
            if (!(dArray2[n] > 0.0)) continue;
            this.k[n] = dArray2[n];
        }
        for (n = 0; n < n2 - 10; ++n) {
            this.l[n] = (double)(object[n] - this.k[n + 10]);
        }
        return true;
    }

    public double[] getRegFlow() {
        Object object = this.element.getSystem().getOutputTSDataSet();
        if (object == null) {
            return null;
        }
        TSRecordProxy tSRecordProxy = this.getTSRecordProxy(0);
        if (tSRecordProxy == null) {
            return null;
        }
        if ((tSRecordProxy = object.getTSRecord(tSRecordProxy.getName(), 0)) == null) {
            return null;
        }
        DSSPathString dSSPathString = new DSSPathString(tSRecordProxy.getDSSPathname());
        dSSPathString.setCPart("FLOW");
        tSRecordProxy.setDSSPathname(dSSPathString.getPathname());
        object.loadTSRecord(tSRecordProxy.getName(), tSRecordProxy.getParamName(), "");
        double[] dArray = this.getTSArray(0);
        object = dArray;
        return dArray;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

