/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.doubleArrayContainer;
import hec.io.DSSIdentifier;
import hec.lang.NamedType;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.Element;
import hec.rss.model.RSimDssPathPartGenerator;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.TailElevContainer;
import hec.rss.model.TailwaterElevation;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Vector;
import org.jdom.Content;
import rma.util.RMAConst;

public class Pump
extends NamedType
implements RssModelVariableConstants,
AltInputReportInfc {
    public static final int PUMP_CAPACITY_CONSTANT = 0;
    public static final int PUMP_CAPACITY_FUNCTION_OF_HEAD = 1;
    AdjustableFlow _adjustableFlow;
    PairedValues m_operatingLimits = new PairedValues();
    private transient TailwaterElevation a = null;
    int m_numberPumps = 1;
    int m_pumpCapacityType = 0;
    double m_pumpCapacityConstant = 0.0;
    PairedValues m_pumpCapacityFunction = new PairedValues();
    private transient doubleArrayContainer b;
    private transient doubleArrayContainer c;

    public Pump() {
    }

    public Pump(AdjustableFlow adjustableFlow) {
        this._adjustableFlow = adjustableFlow;
    }

    public void setNumberOfPumps(int n) {
        this.m_numberPumps = n;
    }

    public int getNumberOfPumps() {
        return this.m_numberPumps;
    }

    public PairedValues getOperatingLimitFunction() {
        this.m_operatingLimits.setParamYId(Parameter.PARAMID_ELEV);
        this.m_operatingLimits.setParamXId(Parameter.PARAMID_ELEV);
        this.m_operatingLimits.setUnitSystem(this._adjustableFlow.getUnitSystem());
        return this.m_operatingLimits;
    }

    public PairedValues getPumpCapacityFunction() {
        this.m_pumpCapacityFunction.setParamYId(Parameter.PARAMID_FLOW);
        this.m_pumpCapacityFunction.setParamXId(Parameter.PARAMID_ELEV);
        this.m_pumpCapacityFunction.setUnitSystem(this._adjustableFlow.getUnitSystem());
        return this.m_pumpCapacityFunction;
    }

    public double getPumpCapacityConstant() {
        return this.m_pumpCapacityConstant;
    }

    public void setPumpCapacityConstant(double d) {
        this.m_pumpCapacityConstant = d;
    }

    public void setUnitSystem(int n) {
        this.m_pumpCapacityFunction.setUnitSystem(n);
    }

    public AdjustableFlow getAdjustableFlow() {
        return this._adjustableFlow;
    }

    public void setAdjustableFlow(AdjustableFlow adjustableFlow) {
        this._adjustableFlow = adjustableFlow;
    }

    public int getPumpCapacityType() {
        return this.m_pumpCapacityType;
    }

    public void setPumpCapacityType(int n) {
        this.m_pumpCapacityType = n;
    }

    public void getActiveTSRecordProxies(Vector vector, int n) {
        if (n == 0) {
            AdjustableFlow adjustableFlow = this.getAdjustableFlow();
            if (adjustableFlow == null) {
                return;
            }
            TSRecordProxy tSRecordProxy = adjustableFlow.getTSRecordProxy(182);
            if (tSRecordProxy != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = adjustableFlow.getTSRecordProxy(183)) != null) {
                vector.addElement(tSRecordProxy);
            }
        }
    }

    public void updateTSProxyList() {
        AdjustableFlow adjustableFlow = this.getAdjustableFlow();
        if (adjustableFlow == null) {
            return;
        }
        if (adjustableFlow.getTSRecordProxy(182) == null) {
            adjustableFlow.addTSRecordProxy(182);
        }
        if (adjustableFlow.getTSRecordProxy(183) == null) {
            adjustableFlow.addTSRecordProxy(183);
        }
    }

    public boolean initialize() {
        if (this.getAssociatedTailwater() == null) {
            this._adjustableFlow.getElement().getSystem().printErrorMessage("Pump Error : Missing Tailwater");
            return false;
        }
        AdjustableFlow adjustableFlow = this.getAdjustableFlow();
        if (adjustableFlow == null) {
            return false;
        }
        this.b = adjustableFlow.getTSContainer(182);
        this.c = adjustableFlow.getTSContainer(183);
        if (this.b == null || this.c == null) {
            this._adjustableFlow.getElement().getSystem().printErrorMessage("Pump Error : failed to initialize pump time series");
            return false;
        }
        return true;
    }

    public void setPumpVolAndFlow(RunTimeStep runTimeStep, double d, double d2) {
        this.b.array[runTimeStep.step] = d;
        this.c.array[runTimeStep.step] = d2;
    }

    public boolean canOperatePumpUnit(int n, double d, double d2) {
        if (n < 0 || n >= this.m_operatingLimits.size()) {
            return false;
        }
        double d3 = this.m_operatingLimits.getXArray()[n];
        double d4 = this.m_operatingLimits.getYArray()[n];
        return d >= d3 && d2 <= d4;
    }

    public double computePumpUnitCapacity(double d) {
        if (this.m_pumpCapacityType == 0) {
            return this.m_pumpCapacityConstant;
        }
        return this.m_pumpCapacityFunction.interpolate(d);
    }

    public TailwaterElevation getAssociatedTailwater() {
        if (this.a == null) {
            if (this._adjustableFlow.hasTailElev()) {
                this.a = this._adjustableFlow.getTailwaterElevation();
            } else {
                for (Element element = this._adjustableFlow.getElement().getParent(); element != null; element = element.getParent()) {
                    if (!(element instanceof TailElevContainer) || !((TailElevContainer)((Object)element)).hasTailElev()) continue;
                    this.a = ((TailElevContainer)((Object)element)).getTailwaterElevation();
                    break;
                }
            }
        }
        return this.a;
    }

    public double getTailwaterElevation(RunTimeStep runTimeStep) {
        if (this.a == null) {
            this.a = this.getAssociatedTailwater();
        }
        if (this.a == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.a.getElevation(runTimeStep);
    }

    public double computeMaximumCapacity(RunTimeStep runTimeStep, double d) {
        if (runTimeStep == null || !RMAConst.isValidValue((double)d)) {
            return 0.0;
        }
        double d2 = this.getTailwaterElevation(runTimeStep);
        if (d2 == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        int n = 0;
        double d3 = d - d2;
        for (int i = 0; i < this.getNumberOfPumps(); ++i) {
            if (!this.canOperatePumpUnit(i, d2, d3)) continue;
            ++n;
        }
        double d4 = this.m_pumpCapacityType == 0 ? this.m_pumpCapacityConstant : this.m_pumpCapacityFunction.interpolate(d3);
        return d4 * (double)n;
    }

    public void setupForSerialization() {
        Object object = new DSSPathname();
        Object object2 = new RSimDssPathPartGenerator();
        Object object3 = this._adjustableFlow.getElement().getTopParent().getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)object3);
        object3 = object2.generatePathnamePart(arrayList, "");
        object.setAPart((String)object3);
        object3 = ((RssTSLocationObject)this._adjustableFlow).getSystem();
        String string = this._adjustableFlow.getElement().getSystem().getDssPairedDataFilePath();
        PairedValues pairedValues = this.getPumpCapacityFunction();
        if (pairedValues != null) {
            arrayList.clear();
            arrayList.add(this._adjustableFlow.getName());
            arrayList.add("Op Head");
            object2 = object3 != null ? ((RssSystem)object3).generateUniquePathPart(arrayList, "-") : object2.generatePathnamePart(arrayList, "-");
            object.setBPart((String)object2);
            object2 = Parameter.getParamString((int)Parameter.PARAMID_ELEV) + "-" + Parameter.getParamString((int)Parameter.PARAMID_FLOW);
            object.setCPart((String)object2);
            object = object.getPathname();
            pairedValues.setDssIdentifer(new DSSIdentifier(string, (String)object));
        }
    }

    public synchronized Object clone() {
        try {
            Pump pump = (Pump)super.clone();
            if (this.m_pumpCapacityFunction != null) {
                pump.m_pumpCapacityFunction = (PairedValues)this.m_pumpCapacityFunction.clone();
            }
            if (this.m_operatingLimits != null) {
                pump.m_operatingLimits = (PairedValues)this.m_operatingLimits.clone();
            }
            return pump;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        element.setAttribute("Number_Of_Pumps", Integer.toString(this.m_numberPumps));
        alternativeInputReport = new org.jdom.Element("Pump_Operating_Limits_MinTailElev");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this.m_operatingLimits.getYArray());
        alternativeInputReport = new org.jdom.Element("Pump_Operating_Limits_MaxHead");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this.m_operatingLimits.getXArray());
        if (this.m_pumpCapacityType == 0) {
            element.setAttribute("Constant_Pump_Capacity", Double.toString(this.m_pumpCapacityConstant));
            return;
        }
        if (this.m_pumpCapacityType == 1) {
            alternativeInputReport = new org.jdom.Element("Pump_Capicity_Head");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this.m_pumpCapacityFunction.getYArray());
            alternativeInputReport = new org.jdom.Element("Capacity");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this.m_pumpCapacityFunction.getXArray());
        }
    }
}

