/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.model.RunTimeStep;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.PumpAdjustableParameter;
import rma.util.RMAConst;

public class PumpFlow
extends AdjustableFlow {
    public PumpFlow() {
        this.setHasPump(true);
    }

    public PumpFlow(Element element) {
        super(element);
        this.setHasPump(true);
    }

    @Override
    public void setupForSerialization() {
        super.setupForSerialization();
    }

    @Override
    protected AdjustableParameter createDefaultAdjustableParameter() {
        PumpAdjustableParameter pumpAdjustableParameter = new PumpAdjustableParameter(this);
        pumpAdjustableParameter.setName("Flow");
        return pumpAdjustableParameter;
    }

    @Override
    public double getCurrentCapacity(RunTimeStep runTimeStep) {
        return 0.0;
    }

    @Override
    public double computeSubStepFlow(RunTimeStep runTimeStep, double d, double d2) {
        return 0.0;
    }

    @Override
    public double getMaxCapacityForElevation(double d) {
        return 0.0;
    }

    public double getCurrentPumpCapacity(RunTimeStep runTimeStep) {
        double d = this.a.array[runTimeStep.step];
        if (!RMAConst.isValidValue((double)d)) {
            int n = runTimeStep.step > 0 ? runTimeStep.step - 1 : 0;
            d = this.a.array[n];
        }
        return -1.0 * this.getPump().computeMaximumCapacity(runTimeStep, d);
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, int n) {
        return ((Function)this).computeForecastStep(runTimeStep);
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        if (this.c == null || this.b == null) {
            this.printErrorMessage("computeForecastStep", "missing timeseries arrays" + this._hindcastCondition);
            this.element.getSystem().printMessage("Date and Time: " + runTimeStep.dateTimeString());
            return 1;
        }
        if (this._tailElev != null && this._hasTailElev) {
            this._tailElev.computeElevation(runTimeStep);
        }
        this._flowParam.setMinValue(0.0);
        this._flowParam.setMaxValue(0.0);
        double d = this._flowParam.getValue(runTimeStep);
        double d2 = this.getCurrentPumpCapacity(runTimeStep);
        if (d < d2) {
            d = d2;
        }
        this.c.array[runTimeStep.step] = d;
        this.b.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        return 0;
    }

    @Override
    public int computeHindcastStep(RunTimeStep runTimeStep) {
        if (this.c == null) {
            return 1;
        }
        this.c.array[runTimeStep.step] = 0.0;
        if (this._tailElev != null && this._hasTailElev) {
            this._tailElev.computeElevation(runTimeStep);
        }
        this._flowParam.setMaxValue(0.0);
        this._flowParam.setMinValue(0.0);
        this._flowParam.setValue(this.c.array[runTimeStep.step]);
        this.b.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        return 0;
    }
}

