/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.doubleArrayContainer;
import hec.lang.NamedType;
import hec.model.RunTimeStep;
import hec.model.SeasonalRecord;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.DemandRuleInf;
import hec.rss.model.Function;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.Pump;
import hec.rss.model.PumpingHourRangeModel;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.SunriseSunsetModel;
import hec.rss.model.WaterAccount;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;

public class PumpOpRule
extends OpRule
implements DemandRuleInf {
    public static final int PUMPING_STRATEGY_FULL_CAPACITY = 0;
    public static final int PUMPING_STRATEGY_FULL_PERIOD = 1;
    public static final int PUMPING_BIAS_BEGINNING_PERIOD = 1;
    public static final int PUMPING_BIAS_MIDDLE_PERIOD = 2;
    public static final int PUMPING_BIAS_END_PERIOD = 3;
    public static final int TARGET_ELEVATION_CONSTANT = 0;
    public static final int TARGET_ELEVATION_STORAGE_ZONE = 1;
    public static final int TARGET_ELEVATION_SEASONALLY = 2;
    public static final int DAILY_PUMPING_OPTION_NIGHTTIME = 0;
    public static final int DAILY_PUMPING_OPTION_HOUR_RANGE = 1;
    public static final int MINPUMPING_OPTION_NONE = 0;
    public static final int MINPUMPING_OPTION_ALWAYS = 1;
    public static final int MINPUMPING_OPTION_IFPUMP = 2;
    public static final int MINPUMPING_OPTION_THRESHOLD = 3;
    int _sourceResId = -1;
    int m_pumpingStrategy = 0;
    int m_pumpingBias = 1;
    int m_targetElevationOption = 0;
    double m_targetElevationConstant = Double.NEGATIVE_INFINITY;
    int m_dailyPumpingOption = 1;
    boolean _useWholeHourPumping = true;
    double _minPumpHours = 0.0;
    int _minPumpOption = 0;
    SeasonalRecord m_seasonalTargetElevation = new SeasonalRecord();
    int m_opSetId = -1;
    int m_storageZoneId = -1;
    boolean m_computeMiddlePumpingPeriod = true;
    double m_numHoursPassed = 0.0;
    double m_numHoursOff = 0.0;
    double m_startingTimeStep = 0.0;
    double m_numHoursNeeded = 0.0;
    SunriseSunsetModel m_sunriseModel = new SunriseSunsetModel();
    PumpingHourRangeModel m_pumpingRangeModel = new PumpingHourRangeModel();
    private transient ReservoirElement a = null;
    private transient doubleArrayContainer b = null;
    private transient doubleArrayContainer c = null;
    private transient doubleArrayContainer d = null;
    private transient doubleArrayContainer e = null;
    private transient doubleArrayContainer f = null;
    private transient doubleArrayContainer i = null;
    private transient doubleArrayContainer j = null;
    private transient doubleArrayContainer k = null;
    private transient doubleArrayContainer l = null;
    private transient doubleArrayContainer m = null;
    private transient doubleArrayContainer n = null;
    private transient doubleArrayContainer o = null;
    private transient doubleArrayContainer p = null;
    private transient doubleArrayContainer q = null;
    private transient doubleArrayContainer r = null;
    private transient doubleArrayContainer s = null;
    private transient int[] t = new int[1];
    private transient int[] u = new int[1];
    private transient int v;
    private transient double w;
    private transient double x;
    private transient ReservoirElement y;
    private transient WaterAccount z;

    public PumpOpRule() {
    }

    public PumpOpRule(String string) {
        super(string);
    }

    @Override
    public void getElementDependencies(List list) {
        ReservoirElement reservoirElement = this.getSourceReservoir();
        if (reservoirElement != null && !list.contains(reservoirElement)) {
            list.add(reservoirElement);
        }
    }

    public void setMinPumpHours(double d) {
        this._minPumpHours = d;
    }

    public double getMinPumpHours() {
        return this._minPumpHours;
    }

    public void setMinPumpOption(int n) {
        this._minPumpOption = n;
    }

    public int getMinPumpOption() {
        return this._minPumpOption;
    }

    public boolean isWholeHourOption() {
        return this._useWholeHourPumping;
    }

    public void setWholeHourOption(boolean bl) {
        this._useWholeHourPumping = bl;
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        if ((vector = super.getActiveTSRecordProxies(vector, n)) == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if (n == 0) {
            TSRecordProxy tSRecordProxy = this.getTSRecordProxy(170);
            if (tSRecordProxy != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(171)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(172)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(173)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(180)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(174)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(175)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(176)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(177)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(178)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(181)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(179)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        super.updateTSProxyList();
        String string = this.getTSProxyName();
        TSRecordProxy tSRecordProxy = this.getTSRecordProxy(string, 170);
        if (tSRecordProxy == null) {
            this.addTSRecordProxy(string, 170);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(string, 171)) == null) {
            this.addTSRecordProxy(string, 171);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(string, 172)) == null) {
            this.addTSRecordProxy(string, 172);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(string, 173)) == null) {
            this.addTSRecordProxy(string, 173);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(string, 180)) == null) {
            this.addTSRecordProxy(string, 180);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(string, 174)) == null) {
            this.addTSRecordProxy(string, 174);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(string, 175)) == null) {
            this.addTSRecordProxy(string, 175);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(string, 176)) == null) {
            this.addTSRecordProxy(string, 176);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(string, 177)) == null) {
            this.addTSRecordProxy(string, 177);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(string, 178)) == null) {
            this.addTSRecordProxy(string, 178);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(string, 181)) == null) {
            this.addTSRecordProxy(string, 181);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(string, 179)) == null) {
            this.addTSRecordProxy(string, 179);
        }
    }

    public double getMaxPumpVol(RunTimeStep runTimeStep, int n, int n2) {
        double d = 0.0;
        Pump pump = this.getPump();
        if (pump == null) {
            return 0.0;
        }
        double d2 = pump.getTailwaterElevation(runTimeStep);
        if (d2 == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        double d3 = this.getTargetElevation(runTimeStep);
        double d4 = d3 - d2;
        double d5 = pump.computePumpUnitCapacity(d4);
        pump = new RunTimeStep(runTimeStep);
        for (int i = n; i < n2; ++i) {
            int n3;
            ((RunTimeStep)pump).step = n3 = runTimeStep.step + i - n;
            if (!this.computePumpingPeriod((RunTimeStep)pump)) continue;
            n3 = this.getNumberOfPumpingUnits(runTimeStep, d2, d4);
            double d6 = d5 * (double)n3;
            double d7 = d6 * this.x * 3600.0 / Storage.DSDT_TO_Q;
            d += d7;
        }
        return d;
    }

    public double getMinPumpVol(RunTimeStep runTimeStep, int n, int n2) {
        double d = 0.0;
        Pump pump = this.getPump();
        if (pump == null || this._minPumpOption == 0) {
            return 0.0;
        }
        double d2 = pump.getTailwaterElevation(runTimeStep);
        if (d2 == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        double d3 = this.getTargetElevation(runTimeStep);
        double d4 = d3 - d2;
        double d5 = pump.computePumpUnitCapacity(d4);
        pump = new RunTimeStep(runTimeStep);
        for (int i = n; i < n2; ++i) {
            int n3;
            ((RunTimeStep)pump).step = n3 = runTimeStep.step + i - n;
            if (!this.computePumpingPeriod((RunTimeStep)pump)) continue;
            double d6 = this._minPumpHours;
            n3 = this.getNumberOfPumpingUnits(runTimeStep, d2, d4);
            if (d6 > (double)n3 * this.x) {
                d6 = (double)n3 * this.x;
            }
            double d7 = d5 * d6 * 3600.0 / Storage.DSDT_TO_Q;
            d += d7;
        }
        return d;
    }

    boolean computePumpingPeriod(RunTimeStep runTimeStep) {
        SimpleTimeZone simpleTimeZone;
        int n;
        if (runTimeStep == null) {
            return false;
        }
        if (this.m_dailyPumpingOption == 1 ? (n = this.m_pumpingRangeModel.getPumpInterval(runTimeStep, this.t, this.u)) == 0 : (n = this.m_sunriseModel.getPumpInterval(runTimeStep, simpleTimeZone = new SimpleTimeZone(this.getGmtOffset() * 60 * 60 * 1000, "CWMS/WATERSHED"), this.t, this.u)) == 0) {
            return false;
        }
        if (this.u[0] < this.t[0]) {
            this.u[0] = this.u[0] + 1440;
        }
        if (this._useWholeHourPumping) {
            if (this.t[0] % 60 != 0) {
                this.t[0] = (this.t[0] / 60 + 1) * 60;
            }
            if (this.u[0] % 60 != 0) {
                this.u[0] = this.u[0] / 60 * 60;
            }
            if (this.u[0] < this.t[0]) {
                this.u[0] = this.t[0];
            }
        }
        this.v = runTimeStep.getHecTime().minutesSinceMidnight();
        if (this.v == 0) {
            this.v = 1440;
        }
        if (this.v < this.t[0]) {
            this.v += 1440;
        }
        if ((n = runTimeStep.rtw.getTimeStepMinutes()) < 1440) {
            int n2;
            if ((n = this.v - n) < this.t[0]) {
                n = this.t[0];
            }
            if ((n2 = this.v) > this.u[0]) {
                n2 = this.u[0];
            }
            this.w = (double)(this.u[0] - n) / 60.0;
            if (this.w < 0.0) {
                this.w = 0.0;
            }
            this.x = (double)(n2 - n) / 60.0;
            if (this.x < 0.0) {
                this.x = 0.0;
            }
        } else {
            this.x = this.w = (double)(this.u[0] - this.t[0]) / 60.0;
        }
        return true;
    }

    public int getSourceReservoirId() {
        return this._sourceResId;
    }

    public void setSourceReservoirId(int n) {
        if (n != this._sourceResId) {
            this._sourceResId = n;
            this.a = null;
        }
    }

    public ReservoirElement getSourceReservoir() {
        if (this.a != null) {
            return this.a;
        }
        if (this._sourceResId < 0) {
            return null;
        }
        this.a = ((RssTSLocationObject)this).getSystem().findReservoir(this._sourceResId);
        return this.a;
    }

    public int initPumpbackStep(RunTimeStep runTimeStep) {
        Storage storage = this.getSourceReservoir().getStorageFunction();
        storage.setPumpVol(runTimeStep, 0.0, 0.0);
        int n = this.initPumpbackRecords(runTimeStep);
        return n;
    }

    public int initPumpbackRecords(RunTimeStep runTimeStep) {
        this.b.array[runTimeStep.step] = 0.0;
        this.c.array[runTimeStep.step] = 0.0;
        this.d.array[runTimeStep.step] = 0.0;
        this.e.array[runTimeStep.step] = 0.0;
        this.f.array[runTimeStep.step] = 0.0;
        this.i.array[runTimeStep.step] = 0.0;
        this.j.array[runTimeStep.step] = 0.0;
        this.k.array[runTimeStep.step] = 0.0;
        this.l.array[runTimeStep.step] = 0.0;
        this.m.array[runTimeStep.step] = 0.0;
        this.n.array[runTimeStep.step] = 0.0;
        this.o.array[runTimeStep.step] = 0.0;
        Pump pump = this.getPump();
        if (pump == null) {
            ((RssTSLocationObject)this).getSystem().printErrorMessage("PumpOpRule.computePumpbackStep: Did not find pump object for rule " + this.getName());
            return 1;
        }
        pump.setPumpVolAndFlow(runTimeStep, 0.0, 0.0);
        return 0;
    }

    public int computePumpbackStep(RunTimeStep runTimeStep) {
        double d;
        double d2;
        double d3;
        double d4;
        this.initPumpbackRecords(runTimeStep);
        this.b.array[runTimeStep.step] = 0.0;
        this.c.array[runTimeStep.step] = 0.0;
        this.d.array[runTimeStep.step] = 0.0;
        this.e.array[runTimeStep.step] = 0.0;
        this.f.array[runTimeStep.step] = 0.0;
        this.i.array[runTimeStep.step] = 0.0;
        this.j.array[runTimeStep.step] = 0.0;
        this.k.array[runTimeStep.step] = 0.0;
        this.l.array[runTimeStep.step] = 0.0;
        this.m.array[runTimeStep.step] = 0.0;
        this.n.array[runTimeStep.step] = 0.0;
        this.o.array[runTimeStep.step] = 0.0;
        int n = this._controller.getIndex() << 16 | this.getIndex();
        this._controller.setRuleId(runTimeStep, n);
        if (this.h != null) {
            this.h.array[runTimeStep.step] = 0.0;
        }
        if (!this.computePumpingPeriod(runTimeStep)) {
            this.m_computeMiddlePumpingPeriod = true;
            return 0;
        }
        Pump pump = this.getPump();
        if (pump == null) {
            ((RssTSLocationObject)this).getSystem().printErrorMessage("PumpOpRule.computePumpbackStep: Did not find pump object for rule " + this.getName());
            return 0;
        }
        pump.setPumpVolAndFlow(runTimeStep, 0.0, 0.0);
        double d5 = pump.getTailwaterElevation(runTimeStep);
        if (d5 == Double.NEGATIVE_INFINITY) {
            ((RssTSLocationObject)this).getSystem().printErrorMessage("PumpOpRule.computePumpbackStep: No tailwater elevation for rule " + this.getName());
            return 0;
        }
        double d6 = this.getTargetElevation(runTimeStep);
        double d7 = this.p.array[runTimeStep.step];
        double d8 = d7 - d5;
        int n2 = this.getNumberOfPumpingUnits(runTimeStep, d5, d8);
        double d9 = pump.computePumpUnitCapacity(d8);
        int cfr_ignored_0 = (this.u[0] - this.t[0]) / 60;
        this.j.array[runTimeStep.step] = d9 * (double)n2 * this.x * 3600.0 / Storage.DSDT_TO_Q;
        this.k.array[runTimeStep.step] = d9 * (double)n2 * this.x * 3600.0 / (double)runTimeStep.getTimeStepSeconds();
        this.l.array[runTimeStep.step] = d9 * (double)n2;
        this.m.array[runTimeStep.step] = this.x;
        this.n.array[runTimeStep.step] = this.x * (double)n2;
        this.o.array[runTimeStep.step] = n2;
        Storage storage = this.getOperationsElement().getStorageFunction();
        storage.incrementPumpVolumeCap(runTimeStep, this.j.array[runTimeStep.step]);
        if (d9 == 0.0 || n2 == 0) {
            return 0;
        }
        double d10 = storage.elevationToStorage(d6);
        double d11 = storage.elevationToStorage(d7);
        double d12 = d10 - d11;
        double d13 = this.getExpectedNetInflowVol(runTimeStep);
        d12 -= d13;
        if (this._minPumpOption != 0) {
            double d14;
            double d15 = this._minPumpHours;
            if (d14 > (double)n2 * this.x) {
                d15 = (double)n2 * this.x;
            }
            double d16 = d9 * d15 * 3600.0 / Storage.DSDT_TO_Q;
            if (this._minPumpOption == 1) {
                if (d12 < d16) {
                    d12 = d16;
                }
            } else if (this._minPumpOption == 2 && d12 > 0.0) {
                if (d12 < d16) {
                    d12 = d16;
                }
            } else if (this._minPumpOption == 3 && d12 < d16) {
                d12 = 0.0;
            }
        }
        Storage storage2 = this.y.getStorageFunction();
        double d17 = storage2.getStorage(runTimeStep);
        if (d4 < d12) {
            d12 = d17;
        }
        if (d12 <= 0.0) {
            return 0;
        }
        double d18 = this.w * 3600.0 * d9 * (double)n2 / Storage.DSDT_TO_Q;
        if (d3 <= d12) {
            d2 = this.x * 3600.0 * d9 * (double)n2 / Storage.DSDT_TO_Q;
            d = this.x;
        } else if (!this._useWholeHourPumping) {
            int n3;
            if (this.m_pumpingStrategy == 1) {
                n3 = (int)Math.ceil(d12 / this.w / 3600.0 * Storage.DSDT_TO_Q / d9);
                double d19 = d12 / (d9 * (double)n3) / 3600.0 * Storage.DSDT_TO_Q;
                if (this.x > d19) {
                    d = d19;
                    d2 = d12;
                } else {
                    d = this.x;
                    d2 = this.x * d9 * (double)n3 * 3600.0 / Storage.DSDT_TO_Q;
                }
            } else {
                double d20;
                n3 = n2;
                double d21 = d12 / (d9 * (double)n2) / 3600.0 * Storage.DSDT_TO_Q;
                if (this.m_pumpingBias == 1 || runTimeStep.getTimeStepMinutes() >= 1440) {
                    d20 = this.x;
                } else {
                    double d22;
                    int n4;
                    int n5;
                    if (this.m_pumpingBias == 2) {
                        n5 = (this.t[0] + this.u[0]) / 2;
                        n4 = n5 + (int)(d21 * 60.0 / 2.0);
                        if (n4 > this.u[0]) {
                            n4 = this.u[0];
                        }
                    } else {
                        n4 = this.u[0];
                    }
                    int n6 = n4 - (int)(d21 * 60.0);
                    n5 = this.v - runTimeStep.getTimeStepMinutes();
                    if (n6 < n5) {
                        n6 = n5;
                    }
                    d20 = (double)(this.v - n6) / 60.0;
                    if (d22 < 0.0) {
                        d20 = 0.0;
                    }
                }
                if (d20 > d21) {
                    d = d21;
                    d2 = d12;
                } else {
                    d = d20;
                    d2 = d20 * d9 * (double)n2 * 3600.0 / Storage.DSDT_TO_Q;
                }
            }
            n2 = n3;
        } else {
            double d23 = Math.floor(this.w);
            double d24 = this.w - d23;
            double d25 = d12 / d9 / 3600.0 * Storage.DSDT_TO_Q;
            if (this.m_pumpingStrategy == 1) {
                double d26;
                double d27;
                int n7 = (int)Math.floor(d25 / this.w);
                double d28 = d25 - (double)n7 * this.w;
                if (d27 > 0.0) {
                    d28 = Math.ceil(d28 - d24) + d24;
                }
                double d29 = d28;
                if (d26 > this.x) {
                    d29 = this.x;
                }
                d2 = (this.x * (double)n7 + d29) * d9 * 3600.0 / Storage.DSDT_TO_Q;
                n2 = n7;
                if (d29 > 0.0) {
                    ++n2;
                }
                double d30 = this.x * (double)n7 + d29;
                d = Math.min(this.x, d30);
            } else {
                double d31;
                double d32;
                double d33;
                int n8;
                double d34;
                double d35 = d25 / (double)n2;
                if (d34 < d24) {
                    n8 = (int)Math.ceil(d25 / d24);
                    d33 = d24;
                    d35 = 0.0;
                } else {
                    d35 = d24 + Math.floor(d35 - d24);
                    n8 = (int)Math.ceil(d25 - d35 * (double)n2);
                    d33 = 1.0;
                }
                if (this.m_pumpingBias == 1 || runTimeStep.getTimeStepMinutes() >= 1440) {
                    d32 = this.x;
                } else {
                    double d36;
                    int n9;
                    int n10;
                    if (this.m_pumpingBias == 2) {
                        n10 = (this.t[0] + this.u[0]) / 2;
                        n9 = n10 + (int)((d35 + d33) * 60.0 / 2.0);
                        if (n9 > this.u[0]) {
                            n9 = this.u[0];
                        }
                    } else {
                        n9 = this.u[0];
                    }
                    int n11 = n9 - (int)((d35 + d33) * 60.0);
                    n10 = this.v - runTimeStep.getTimeStepMinutes();
                    if (n11 < n10) {
                        n11 = n10;
                    }
                    d32 = (double)(this.v - n11) / 60.0;
                    if (d36 < 0.0) {
                        d32 = 0.0;
                    }
                }
                d = d31 = Math.min(d32, d35);
                d2 = 0.0 + d31 * (double)n2 * d9 * 3600.0 / Storage.DSDT_TO_Q;
                if (d33 > 0.0 && d32 > d35) {
                    double d37 = Math.min(d33, d32 - d35);
                    d2 += d37 * (double)n8 * d9 * 3600.0 / Storage.DSDT_TO_Q;
                    d += d37;
                }
                if (!(d35 > 0.0)) {
                    n2 = n8;
                }
                double cfr_ignored_1 = d2 / d9 / 3600.0;
            }
        }
        double d38 = -storage2.incrementPumpVolume(runTimeStep, -d2);
        storage.incrementPumpVolume(runTimeStep, d38);
        this.b.array[runTimeStep.step] = d38;
        this.c.array[runTimeStep.step] = d38 / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q;
        this.e.array[runTimeStep.step] = d;
        this.f.array[runTimeStep.step] = d38 / d9 / 3600.0 * Storage.DSDT_TO_Q;
        if (d38 <= 0.0) {
            n2 = 0;
        }
        this.i.array[runTimeStep.step] = n2;
        this.d.array[runTimeStep.step] = (double)n2 * d9;
        this.h.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        pump.setPumpVolAndFlow(runTimeStep, d38, this.c.array[runTimeStep.step]);
        return 0;
    }

    private double getExpectedNetInflowVol(RunTimeStep runTimeStep) {
        double d;
        double d2 = runTimeStep.getTimeStepMinutes();
        if (d >= 1440.0) {
            return 0.0;
        }
        int n = (int)Math.ceil((double)(this.u[0] - this.v) / d2);
        double d3 = 0.0;
        if (n > 0) {
            d3 = ((ReservoirElement)this.getOperationsElement()).getExpectedNetInflowVol(runTimeStep, n, this);
        }
        return d3;
    }

    @Override
    public int getRuleLimitType() {
        return 1;
    }

    public PumpingHourRangeModel getPumpingRangeModel() {
        return this.m_pumpingRangeModel;
    }

    public void setPumpingHourRangeModel(PumpingHourRangeModel pumpingHourRangeModel) {
        if (pumpingHourRangeModel == null) {
            return;
        }
        this.m_pumpingRangeModel = pumpingHourRangeModel;
    }

    public SunriseSunsetModel getSuriseSunsetModel() {
        return this.m_sunriseModel;
    }

    public void setSunriseSunsetModel(SunriseSunsetModel sunriseSunsetModel) {
        if (sunriseSunsetModel == null) {
            return;
        }
        this.m_sunriseModel = sunriseSunsetModel;
    }

    public int getPumpingStrategy() {
        return this.m_pumpingStrategy;
    }

    public void setPumpingStrategy(int n) {
        this.m_pumpingStrategy = n;
    }

    public int getPumpingBias() {
        return this.m_pumpingBias;
    }

    public void setPumpingBias(int n) {
        this.m_pumpingBias = n;
    }

    public void setTargetElevationOption(int n) {
        this.m_targetElevationOption = n;
    }

    public int getTargetElevationOption() {
        return this.m_targetElevationOption;
    }

    public void setConstantTargetElevation(double d) {
        this.m_targetElevationConstant = d;
    }

    public double getConstantTargetElevation() {
        return this.m_targetElevationConstant;
    }

    public void setSeasonalTargetElevation(SeasonalRecord seasonalRecord) {
        seasonalRecord.setUnitSystem(this.getUnitSystem());
        this.m_seasonalTargetElevation = seasonalRecord;
    }

    public SeasonalRecord getSeasonalTargetElevation() {
        this.m_seasonalTargetElevation.setUnitSystem(this.getUnitSystem());
        return this.m_seasonalTargetElevation;
    }

    public void setStorageZoneTargetElevation(OpSet opSet, StorageZone storageZone) {
        this.m_opSetId = opSet.getIndex();
        this.m_storageZoneId = storageZone.getIndex();
    }

    public int getStorageZoneId() {
        return this.m_storageZoneId;
    }

    public int getOpSetId() {
        return this.m_opSetId;
    }

    public void setDailyPumpingOption(int n) {
        this.m_dailyPumpingOption = n;
    }

    public int getDailyPumpingOption() {
        return this.m_dailyPumpingOption;
    }

    public double getLongitude() {
        return this.m_sunriseModel.getLongitude();
    }

    public void setLongitude(double d) {
        this.m_sunriseModel.setLongitude(d);
    }

    public double getLatitude() {
        return this.m_sunriseModel.getLatitude();
    }

    public void setLatitude(double d) {
        this.m_sunriseModel.setLatitude(d);
    }

    public double getPumpRuleFlow(RunTimeStep runTimeStep) {
        return this.c.array[runTimeStep.step];
    }

    protected double getTargetElevation(RunTimeStep runTimeStep) {
        int n = this.getTargetElevationOption();
        if (n == 0) {
            return this.m_targetElevationConstant;
        }
        if (n == 2) {
            return this.m_seasonalTargetElevation.interpolate(runTimeStep);
        }
        if (n == 1) {
            NamedType namedType = this.getOperationsElement().getElementOp(false).getOperationSet(this.m_opSetId);
            if (namedType == null) {
                return Double.NEGATIVE_INFINITY;
            }
            if ((namedType = namedType.getZone(this.m_storageZoneId)) == null) {
                return Double.NEGATIVE_INFINITY;
            }
            return namedType.getElevation(runTimeStep);
        }
        return Double.NEGATIVE_INFINITY;
    }

    protected int computeHoursLeftInPumpingPeriod(RunTimeStep runTimeStep) {
        if (runTimeStep == null) {
            return 0;
        }
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(this.getGmtOffset() * 60 * 60 * 1000, "CWMS/WATERSHED");
        if (this.m_dailyPumpingOption == 1) {
            return this.m_pumpingRangeModel.computeHoursLeftInPumpingTime(runTimeStep);
        }
        return this.m_sunriseModel.computeHoursLeftInPumpingTime(runTimeStep, simpleTimeZone);
    }

    protected int computePumpingWindowHours(RunTimeStep runTimeStep) {
        if (runTimeStep == null) {
            return 0;
        }
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(this.getGmtOffset() * 60 * 60 * 1000, "CWMS/WATERSHED");
        if (this.m_dailyPumpingOption == 1) {
            return this.m_pumpingRangeModel.computePumpingWindow(runTimeStep);
        }
        return this.m_sunriseModel.computePumpingWindow(runTimeStep, simpleTimeZone);
    }

    @Override
    public boolean initializeCompute() {
        if (!super.initializeCompute()) {
            return false;
        }
        this.b = null;
        this.c = null;
        this.d = null;
        this.e = null;
        this.f = null;
        this.i = null;
        this.j = null;
        this.k = null;
        this.l = null;
        this.m = null;
        this.n = null;
        this.o = null;
        this.b = this.getTSContainer(170);
        this.c = this.getTSContainer(171);
        this.d = this.getTSContainer(172);
        this.e = this.getTSContainer(173);
        this.f = this.getTSContainer(180);
        this.i = this.getTSContainer(174);
        this.j = this.getTSContainer(175);
        this.k = this.getTSContainer(176);
        this.l = this.getTSContainer(177);
        this.m = this.getTSContainer(178);
        this.n = this.getTSContainer(181);
        this.o = this.getTSContainer(179);
        RssReturnStatusConstants rssReturnStatusConstants = this._controller.getElementOp().getOperationsElement().getStorageFunction();
        this.p = ((RssTSLocationObject)rssReturnStatusConstants).getTSContainer(10);
        this.q = ((RssTSLocationObject)rssReturnStatusConstants).getTSContainer(13);
        this.r = ((RssTSLocationObject)rssReturnStatusConstants).getTSContainer(21);
        rssReturnStatusConstants = this.getRssSystem();
        if (this.getPump().getAssociatedTailwater() == null) {
            RssReturnStatusConstants rssReturnStatusConstants2 = rssReturnStatusConstants;
            rssReturnStatusConstants2.printErrorMessage("PumpOpRule.initializeCompute: There is no Tailwater associated with the Power Plant for " + ((RssSystem)rssReturnStatusConstants2).getNameForKeyString(this._controller.getName()));
            return false;
        }
        this.y = this.getSourceReservoir();
        if (this.y == null) {
            rssReturnStatusConstants.printErrorMessage("PumpOpRule.initializeCompute: There is no source reservoir associated with Pump Rule " + this.getName());
            return false;
        }
        return true;
    }

    @Override
    public int initOperationStep(RunTimeStep runTimeStep, int n) {
        return 0;
    }

    private double computeInflowVolume(RunTimeStep runTimeStep, Storage storage, int n) {
        double d = runTimeStep.getTimeStepSeconds();
        int n2 = (int)Math.ceil((double)n * 60.0 * 60.0 / d);
        if (n2 == 0) {
            return 0.0;
        }
        double d2 = 0.0;
        n = !runTimeStep.isPerAvgTimeStep() ? 1 : 0;
        int cfr_ignored_0 = runTimeStep.step;
        for (int i = 1; i <= n2; ++i) {
            int n3;
            int n4 = runTimeStep.step + i - 1;
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = runTimeStep.step + i) >= this.q.array.length) {
                n3 = this.q.array.length - 1;
            }
            if (n4 >= this.q.array.length) continue;
            if (n != 0) {
                d2 += (this.q.array[n3] + this.q.array[n4]) / 2.0 * d;
                continue;
            }
            d2 += this.q.array[i] * d;
        }
        if (this.getUnitSystem() == 1) {
            d2 /= 43560.0;
        }
        return d2;
    }

    protected Pump getPump() {
        Function function = this._controller.getReleaseElement().getFunction();
        if (function instanceof AdjustableFlow) {
            function = (AdjustableFlow)function;
            return ((AdjustableFlow)function).getPump();
        }
        return null;
    }

    int getNumberOfPumpingUnits(RunTimeStep runTimeStep, double d, double d2) {
        Pump pump = this.getPump();
        if (runTimeStep == null || pump == null) {
            return 0;
        }
        int n = this.m_dailyPumpingOption == 1 ? this.m_pumpingRangeModel.getNumUnitsAtTime(runTimeStep) : this.m_sunriseModel.getNumUnitsAtTime(runTimeStep);
        int n2 = pump.getNumberOfPumps();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!pump.canOperatePumpUnit(i, d, d2)) continue;
            ++n3;
        }
        if (n > n3) {
            n = n3;
        }
        return n;
    }

    int pumpingPeriodLength(RunTimeStep runTimeStep) {
        return 0;
    }

    boolean inVallidPumpingTime(RunTimeStep runTimeStep) {
        if (runTimeStep == null) {
            return false;
        }
        if (this.m_dailyPumpingOption == 1) {
            return this.m_pumpingRangeModel.isInPumpingPeriod(runTimeStep);
        }
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(this.getGmtOffset() * 60 * 60 * 1000, "CWMS/WATERSHED");
        return this.m_sunriseModel.isInPumpingPeriod(runTimeStep, simpleTimeZone);
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        Element element2;
        super.outputReport(alternativeInputReport, element);
        element.setAttribute("Rule", "Pump");
        element.setAttribute("PumpingStratagy", Integer.toString(this.m_pumpingStrategy));
        element.setAttribute("SourseReseroirID", Integer.toString(this._sourceResId));
        element.setAttribute("MinimumPumping", Integer.toString(this._minPumpOption));
        element.setAttribute("PumpingBias", Integer.toString(this.m_pumpingBias));
        element.setAttribute("WholeHourPumpingOption", Boolean.toString(this._useWholeHourPumping));
        element.setAttribute("PumpingBias", Double.toString(this._minPumpHours));
        element.setAttribute("TargetFillElevationType", Integer.toString(this.m_targetElevationOption));
        if (this.m_targetElevationOption == 0) {
            element.setAttribute("TagetElevationConstant", Double.toString(this.m_targetElevationConstant));
        } else if (this.m_targetElevationOption == 1) {
            element.setAttribute("TagetElevationZoneID", Integer.toString(this.m_storageZoneId));
        } else if (this.m_targetElevationOption == 2) {
            element2 = new Element("TagetElevationDates");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((Element)element2, (int[])this.m_seasonalTargetElevation.getTimeArray());
            element2 = new Element("TagetElevationData");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((Element)element2, (double[])this.m_seasonalTargetElevation.getDataArray());
        }
        element.setAttribute("DailyPumpingOption", Integer.toString(this.m_dailyPumpingOption));
        if (this.m_dailyPumpingOption == 1) {
            element2 = new Element("FixedHourRange");
            element.addContent((Content)element2);
            this.m_pumpingRangeModel.outputReport(alternativeInputReport, element2);
            return;
        }
        element2 = new Element("BetweenSunriseAndSunset");
        element.addContent((Content)element2);
        this.m_sunriseModel.outputReport(alternativeInputReport, element2);
    }

    @Override
    public WaterAccount getWaterAccount() {
        return this.z;
    }

    @Override
    public void setWaterAccount(WaterAccount waterAccount) {
        this.z = waterAccount;
    }
}

