/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.jdom.Content;
import org.jdom.Element;

public class PumpingHourRangeModel
implements AsciiSerializable,
AltInputReportInfc {
    int[] m_beginDate = null;
    int[] m_endDate = null;
    int[] m_noUnits = null;
    HecTime filterTime;
    HecTime intervalDayTime;

    public int getNumberValues() {
        if (this.m_beginDate == null) {
            return 0;
        }
        return this.m_beginDate.length;
    }

    public void setNumberValues(int n) {
        this.m_beginDate = this.resize(this.m_beginDate, n);
        this.m_endDate = this.resize(this.m_endDate, n);
        this.m_noUnits = this.resize(this.m_noUnits, n);
    }

    private int[] resize(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        Arrays.fill(nArray2, Integer.MIN_VALUE);
        for (int i = 0; i < n && nArray != null && i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    private double[] resize(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        for (int i = 0; i < n && dArray != null && i < dArray.length; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    public void setValueAt(int n, int n2, int n3, int n4) {
        if (n < 0) {
            return;
        }
        if (n >= this.getNumberValues()) {
            this.setNumberValues(n + 1);
        }
        this.m_beginDate[n] = n2;
        this.m_endDate[n] = n3;
        this.m_noUnits[n] = n4;
    }

    public int getBeginDateAt(int n) {
        if (n < 0 || n >= this.m_beginDate.length) {
            return Integer.MIN_VALUE;
        }
        return this.m_beginDate[n];
    }

    public int getEndDateAt(int n) {
        if (n < 0 || n >= this.m_endDate.length) {
            return Integer.MIN_VALUE;
        }
        return this.m_endDate[n];
    }

    public int getNumOfUnitsAt(int n) {
        if (n < 0 || n >= this.m_noUnits.length) {
            return -1;
        }
        return this.m_noUnits[n];
    }

    public boolean getPumpInterval(RunTimeStep runTimeStep, int[] nArray, int[] nArray2) {
        if (runTimeStep == null) {
            return false;
        }
        int n = this.computeIndex(runTimeStep);
        if (n < 0 || n > this.m_beginDate.length) {
            return false;
        }
        int n2 = this.m_beginDate[n] % 1440;
        if ((n = this.m_endDate[n] % 1440) == 0) {
            n += 1440;
        }
        if (n < n2) {
            n += 1440;
        }
        nArray[0] = n2;
        nArray2[0] = n;
        return true;
    }

    public boolean isInPumpingPeriod(RunTimeStep runTimeStep) {
        int n = this.computeIndex(runTimeStep);
        if (n < 0) {
            return false;
        }
        if (runTimeStep.getTimeStepMinutes() >= 1440) {
            return true;
        }
        int n2 = this.m_beginDate[n];
        if ((n = this.m_endDate[n]) - n2 == 1440) {
            return true;
        }
        HecTime hecTime = new HecTime(n2, 1);
        HecTime hecTime2 = new HecTime(n, 1);
        HecTime hecTime3 = runTimeStep.getHecTime();
        int n3 = hecTime.minutesSinceMidnight();
        int n4 = hecTime2.minutesSinceMidnight();
        int n5 = hecTime3.minutesSinceMidnight();
        if (n4 < n3) {
            n4 += 1440;
        }
        if (n5 < n3) {
            n5 += 1440;
        }
        int n6 = n5 - runTimeStep.getTimeStepMinutes();
        if (n3 <= n5 && n5 <= n4) {
            return true;
        }
        return n6 <= n3 && n4 <= n5;
    }

    public int computePumpingWindow(RunTimeStep runTimeStep) {
        int n;
        int n2 = this.computeIndex(runTimeStep);
        if (n2 < 0) {
            return 0;
        }
        int n3 = this.m_beginDate[n2];
        n2 = this.m_endDate[n2];
        HecTime hecTime = new HecTime(n3, 1);
        HecTime hecTime2 = new HecTime(n2, 1);
        runTimeStep = runTimeStep.getHecTime();
        int n4 = hecTime.minutesSinceMidnight();
        int n5 = hecTime2.minutesSinceMidnight();
        runTimeStep.minutesSinceMidnight();
        if (n5 < n4) {
            n5 += 1440;
        }
        if ((n = (n5 - n4) / 60) >= 0) {
            return n;
        }
        return 0;
    }

    public int computeHoursLeftInPumpingTime(RunTimeStep runTimeStep) {
        int n = this.computeIndex(runTimeStep);
        if (n < 0) {
            return 0;
        }
        int n2 = this.m_beginDate[n];
        n = this.m_endDate[n];
        HecTime hecTime = new HecTime(n2, 1);
        HecTime hecTime2 = new HecTime(n, 1);
        runTimeStep = runTimeStep.getHecTime();
        int n3 = hecTime.minutesSinceMidnight();
        int n4 = hecTime2.minutesSinceMidnight();
        int n5 = runTimeStep.minutesSinceMidnight();
        if (n4 < n3) {
            n4 += 1440;
        }
        if (n5 < n3) {
            n5 += 1440;
        }
        if ((n5 = (n4 - n5) / 60) >= 0) {
            return n5;
        }
        return 0;
    }

    public int computeIndex(RunTimeStep runTimeStep) {
        int n;
        if (this.m_beginDate == null || this.m_beginDate.length == 0) {
            return -1;
        }
        if (this.filterTime == null) {
            this.filterTime = new HecTime();
        }
        int n2 = this.intervalTime(runTimeStep);
        int n3 = -1;
        int n4 = -1;
        this.filterTime.set(n2);
        n2 = this.filterTime.dayOfYear();
        n2 = n2 * 1440 + this.filterTime.minutesSinceMidnight();
        for (n = this.getNumberValues() - 1; n3 == -1 && n >= 0; --n) {
            this.filterTime.set(this.m_beginDate[n]);
            if (n2 < this.filterTime.dayOfYear() * 1440 + this.filterTime.minutesSinceMidnight()) continue;
            n3 = this.m_endDate[n];
            n4 = n;
        }
        if (n4 < 0) {
            n4 = this.m_endDate.length - 1;
        }
        if ((n = n4 + 1) >= this.m_beginDate.length) {
            n = 0;
        }
        this.filterTime.set(this.m_beginDate[n]);
        if (this.filterTime.dayOfYear() == runTimeStep.getHecTime().dayOfYear() && runTimeStep.getHecTime().minutesSinceMidnight() <= new HecTime(this.m_beginDate[n], 1).minutesSinceMidnight() && runTimeStep.getHecTime().minutesSinceMidnight() > new HecTime(this.m_endDate[n], 1).minutesSinceMidnight()) {
            n4 = n;
        }
        return n4;
    }

    public int getNumUnitsAtTime(RunTimeStep runTimeStep) {
        if (!this.isInPumpingPeriod(runTimeStep)) {
            return 0;
        }
        int n = this.computeIndex(runTimeStep);
        if (n < 0) {
            return 0;
        }
        return this.m_noUnits[n];
    }

    int intervalTime(RunTimeStep runTimeStep) {
        if ((runTimeStep = runTimeStep.getHecTime()) == null) {
            return 0;
        }
        int n = 0 + runTimeStep.dayOfYear() * 1440 + runTimeStep.minutesSinceMidnight();
        return n;
    }

    public static void a(String[] object) {
        object = new PumpingHourRangeModel();
        ((PumpingHourRangeModel)object).setNumberValues(1);
        ((PumpingHourRangeModel)object).setValueAt(0, 2340, 3000, 2);
        ((PumpingHourRangeModel)object).setValueAt(1, 483420, 484260, 1);
        RunTimeWindow runTimeWindow = new RunTimeWindow(new HecTime("30Nov1993"), new HecTime("03Dec1993"), new HecTime("29Nov1993"));
        runTimeWindow.setTimeStep(1, 2);
        RunTimeStep runTimeStep = new RunTimeStep(runTimeWindow);
        for (int i = 0; i < runTimeWindow.getNumSteps(); ++i) {
            runTimeStep.setStep(i);
            ((PumpingHourRangeModel)object).isInPumpingPeriod(runTimeStep);
            System.out.print("Time = " + runTimeStep.getHecTime().dateAndTime(4));
            System.out.print("\tHours Left in Pumping time = " + ((PumpingHourRangeModel)object).computeHoursLeftInPumpingTime(runTimeStep));
            System.out.println("\t Pumping Window = " + ((PumpingHourRangeModel)object).computePumpingWindow(runTimeStep));
        }
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        alternativeInputReport = new Element("Date_Begin");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((Element)alternativeInputReport, (int[])this.m_beginDate);
        alternativeInputReport = new Element("Date_End");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((Element)alternativeInputReport, (int[])this.m_endDate);
        alternativeInputReport = new Element("No_Units");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((Element)alternativeInputReport, (int[])this.m_noUnits);
    }
}

