/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.rss.model.DemandRuleInf;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import hec.rss.model.RssSystem;
import hec.rss.model.Storage;
import hec.rss.model.WaterAccount;
import java.io.Serializable;
import java.lang.reflect.Field;
import rma.util.RMAConst;

public class RateChangeElevLimitOpRule
extends OpRule
implements AsciiSerializable,
DemandRuleInf,
Serializable,
Cloneable {
    public static final String DECREASING_STR = "Decreasing";
    public static final String INCREASING_STR = "Increasing";
    public static final int DECREASING = 0;
    public static final int INCREASING = 1;
    public static final int CONSTANT = 0;
    public static final int FUNCTION_OF_INFLOW = 1;
    public static final int FUNCTION_OF_RELEASE = 2;
    public static final int FUNCTION_OF_ELEVATION = 3;
    private int _functionType = 0;
    private PairedValues _pvChangeLimit = new PairedValues();
    private int _type = 1;
    private double _maxRate = Double.NEGATIVE_INFINITY;
    private double _periodAverageTime = Double.NEGATIVE_INFINITY;
    private boolean _isInstantaneous = true;
    private transient doubleArrayContainer a;
    private transient doubleArrayContainer b;
    private transient doubleArrayContainer c;
    private transient WaterAccount d;

    public RateChangeElevLimitOpRule() {
    }

    public RateChangeElevLimitOpRule(String string) {
        super(string);
    }

    @Override
    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
        double d;
        double d2;
        double d3;
        double d4;
        n = runTimeStep.step - 1;
        if (n < 0) {
            n = 0;
        }
        int n2 = runTimeStep.step;
        double d5 = this._maxRate;
        if (this._functionType == 1) {
            d4 = this._controller.getElementOp().getOperationsElement().getStorageFunction().getNetInflow(runTimeStep);
            if (d4 == Double.NEGATIVE_INFINITY) {
                this._controller.getElementOp().getOperationsElement().getSystem().printErrorMessage("RateChangeElevLimitOpRule.evaluateRule: inflow undefined");
                this.h.array[runTimeStep.step] = -3.4028234663852886E38;
                return;
            }
            d5 = this._pvChangeLimit.interpolate(d4);
        } else if (this._functionType == 2) {
            d4 = this.a.array[n];
            d5 = this._pvChangeLimit.interpolate(d4);
        }
        if (this._isInstantaneous) {
            d4 = d5 * (double)runTimeStep.getTimeStepSeconds() / 3600.0;
            if (this._type == 0 && d4 > 0.0) {
                d4 = -d4;
            }
        } else {
            int n3 = this.getPeriodStartStep(runTimeStep, this._periodAverageTime);
            d3 = this.b.array[n] - this.b.array[n3];
            d2 = d5;
            if (this._type == 0 && d2 > 0.0) {
                d2 = -d2;
            }
            d4 = d2 - d3;
        }
        Storage storage = this._controller.getElementOp().getOperationsElement().getStorageFunction();
        d3 = storage.elevationToStorage(this.b.array[n]);
        d2 = storage.elevationToStorage(this.b.array[n] + d4);
        double d6 = (d2 - d3) * Storage.DSDT_TO_Q / (double)runTimeStep.getTimeStepSeconds();
        double d7 = this.c.array[n2] - d6;
        if (d < 0.0) {
            d7 = 0.0;
        }
        this.h.array[runTimeStep.step] = d7;
    }

    @Override
    public OpValue getOpValue(RunTimeStep runTimeStep) {
        if (!RMAConst.isValidValue((double)this.h.array[runTimeStep.step])) {
            return null;
        }
        OpValue opValue = new OpValue();
        opValue.type = this._type == 1 ? 0 : 2;
        opValue.value = this.h.array[runTimeStep.step];
        return opValue;
    }

    @Override
    public boolean initializeCompute() {
        this.a = null;
        this.b = null;
        this.c = null;
        if (!this.isValid()) {
            return false;
        }
        if (!super.initializeCompute()) {
            return false;
        }
        Storage storage = this._controller.getElementOp().getOperationsElement().getStorageFunction();
        this.b = storage.getTSContainer(10);
        this.c = storage.getTSContainer(13);
        if (this.b == null || this.c == null) {
            this._controller.getElementOp().getOperationsElement().getSystem().printErrorMessage("RateChangeElevLimitOpRule.initializeCompute: Failed to load time series arrays");
            return false;
        }
        this.a = this._controller.getReleaseTSContainer();
        if (this.a == null && this._functionType == 2) {
            this._controller.getElementOp().getOperationsElement().getSystem().printErrorMessage("RateChangeElevLimitOpRule.initializeCompute: Failed to load time series arrays");
            return false;
        }
        return true;
    }

    public boolean isValid() {
        if (this._functionType == 0) {
            if (!RMAConst.isValidValue((double)this._maxRate)) {
                return false;
            }
        } else if (this._functionType == 1 || this._functionType == 2 || this._functionType == 3) {
            if (this._pvChangeLimit == null || this._pvChangeLimit.size() < 2 || !this._pvChangeLimit.canInterpX()) {
                RssSystem rssSystem = this._controller.getElementOp().getOperationsElement().getSystem();
                String string = "RateChangeElevLimitOpRule.initializeCompute: Values for variable rate of change are not defined or x-values are not in ascending order.";
                rssSystem.printErrorMessage(string);
                string = rssSystem.getNameForKeyString(this._controller.getName());
                rssSystem.printErrorMessage("  Reservoir = " + string);
                rssSystem.printErrorMessage("  Rule name = " + this.getName());
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public OpValue evaluateRule(RunTimeStep runTimeStep, double d) {
        ((OpRule)this).evaluateLimits(runTimeStep, 0);
        return ((OpRule)this).getOpValue(runTimeStep);
    }

    private int getPeriodStartStep(RunTimeStep runTimeStep, double d) {
        int n;
        if (d <= 0.0 || !RMAConst.isValidValue((double)d)) {
            d = 1.0;
        }
        double d2 = runTimeStep.getTimeStepSeconds();
        int n2 = 1;
        if (d2 > 1.0 && d > 0.0) {
            n2 = (int)(d * 3600.0 / d2);
        }
        if ((n = runTimeStep.step) < 0) {
            n = 0;
        }
        if ((n -= n2) < 0) {
            n = 0;
        }
        return n;
    }

    @Override
    public Object clone() {
        RateChangeElevLimitOpRule rateChangeElevLimitOpRule = (RateChangeElevLimitOpRule)super.clone();
        return rateChangeElevLimitOpRule;
    }

    public void setChangeLimitCurve(PairedValues pairedValues) {
        if (pairedValues == null) {
            return;
        }
        this._pvChangeLimit = pairedValues;
    }

    public PairedValues getChangeLimitCurve() {
        this._pvChangeLimit.setUnitSystem(this.getUnitSystem());
        this._pvChangeLimit.setParamYId(Parameter.PARAMID_ELEV);
        if (this._functionType == 3) {
            this._pvChangeLimit.setParamXId(Parameter.PARAMID_ELEV);
        } else {
            this._pvChangeLimit.setParamXId(Parameter.PARAMID_FLOW);
        }
        return this._pvChangeLimit;
    }

    public int getFunctionType() {
        return this._functionType;
    }

    public void setFunctionType(int n) {
        this._functionType = n;
    }

    public void setInterpolationType(int n) {
        this._pvChangeLimit.setInterpolationType(n);
    }

    public int getInterpolationType() {
        return this._pvChangeLimit.getInterpolationType();
    }

    public void setInstantaneous(boolean bl) {
        this._isInstantaneous = bl;
    }

    public boolean isInstantaneous() {
        return this._isInstantaneous;
    }

    public void setType(int n) {
        if (n != 1 && n != 0) {
            return;
        }
        this._type = n;
    }

    public int getType() {
        return this._type;
    }

    public void setMaxRateOfChange(ParamDouble paramDouble) {
        this._maxRate = paramDouble.getValue();
    }

    public void setMaxRateOfChange(double d) {
        this._maxRate = d;
    }

    public void getMaxRateOfChange(ParamDouble paramDouble) {
        paramDouble.setValue(this._maxRate);
        paramDouble.setUnitSystem(this.getController().getElementOp().getOperationsElement().getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_ELEV);
    }

    public double getMaxRateOfChange() {
        return this._maxRate;
    }

    public double getPeriodAverageTime() {
        return this._periodAverageTime;
    }

    public void setPeriodAverageTime(double d) {
        this._periodAverageTime = d;
    }

    @Override
    public int getRuleLimitType() {
        if (this._type == 1) {
            return 0;
        }
        return 2;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public WaterAccount getWaterAccount() {
        return this.d;
    }

    @Override
    public void setWaterAccount(WaterAccount waterAccount) {
        this.d = waterAccount;
    }
}

