/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.rss.model.DemandRuleInf;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import hec.rss.model.RssSystem;
import hec.rss.model.WaterAccount;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.jdom.Content;
import org.jdom.Element;
import rma.util.RMAConst;

public class RateChangeLimitOpRule
extends OpRule
implements AsciiSerializable,
DemandRuleInf,
Serializable,
Cloneable {
    public static final String DECREASING_STR = "Decreasing";
    public static final String INCREASING_STR = "Increasing";
    public static final int DECREASING = 0;
    public static final int INCREASING = 1;
    private int _type = 1;
    public static final int CONSTANT = 0;
    public static final int FUNCTION_OF_INFLOW = 1;
    public static final int FUNCTION_OF_RELEASE = 2;
    public static final int FUNCTION_OF_ELEVATION = 3;
    private int _functionType = 0;
    private PairedValues _pvChangeLimit = new PairedValues();
    private double _maxRate = Double.NEGATIVE_INFINITY;
    private double _lookback = Double.NEGATIVE_INFINITY;
    private boolean _isInstantaneous = true;
    private transient doubleArrayContainer a;
    private transient doubleArrayContainer b;
    private transient WaterAccount c;

    public RateChangeLimitOpRule() {
        this._pvChangeLimit = new PairedValues();
    }

    public RateChangeLimitOpRule(String string) {
        super(string);
        this._pvChangeLimit = new PairedValues();
    }

    public int getMaxROCSteps(double d, int n) {
        int n2 = 0;
        if (this._functionType == 0) {
            if (this._maxRate <= 0.0) {
                return 0;
            }
            n2 = (int)(d / (this._maxRate / 3600.0) / (double)n + 0.5);
        } else if (this._functionType == 1) {
            double d2 = d;
            while (d2 > 0.0) {
                double d3 = this._pvChangeLimit.interpolate(d2);
                d2 -= d3 / 3600.0 * (double)n;
                ++n2;
            }
        } else if (this._functionType == 2) {
            double d4 = d;
            while (d4 > 0.0) {
                double d5;
                double d6 = this._pvChangeLimit.interpolate(d4);
                if (d5 <= 1.0) {
                    return 0;
                }
                d4 -= d6 / 3600.0 * (double)n;
                ++n2;
            }
        } else if (this._functionType == 3) {
            double d7;
            double d8 = this._pvChangeLimit.getMinY();
            if (d7 <= 0.0) {
                return 0;
            }
            n2 = (int)(d / (d8 / 3600.0) / (double)n + 0.5);
        }
        return n2;
    }

    public double getControllingRateOfChangeLimit() {
        double d = this._maxRate;
        if (this._functionType == 1) {
            d = this._pvChangeLimit.getMinY();
        } else if (this._functionType == 2) {
            d = this._pvChangeLimit.getMinY();
        } else if (this._functionType == 3) {
            d = this._pvChangeLimit.getMinY();
        }
        return d;
    }

    @Override
    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
        n = runTimeStep.step - 1;
        if (n < 0) {
            n = 0;
        }
        double d = this.a.array[n];
        double d2 = this.getRateOfChangeLimit(runTimeStep);
        if (!RMAConst.isValidValue((double)d2)) {
            this.h.array[runTimeStep.step] = -3.4028234663852886E38;
            return;
        }
        if (this._type == 1) {
            this.h.array[runTimeStep.step] = d + d2 * (double)runTimeStep.getTimeStepSeconds() / 3600.0;
            return;
        }
        this.h.array[runTimeStep.step] = d - d2 * (double)runTimeStep.getTimeStepSeconds() / 3600.0;
    }

    @Override
    public OpValue getOpValue(RunTimeStep runTimeStep) {
        if (!RMAConst.isValidValue((double)this.h.array[runTimeStep.step])) {
            return null;
        }
        OpValue opValue = new OpValue();
        opValue.type = this._type == 1 ? 2 : 0;
        opValue.value = this.h.array[runTimeStep.step];
        return opValue;
    }

    @Override
    public int getRuleLimitType() {
        if (this._type == 1) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean initializeCompute() {
        if (!this.isValid()) {
            return false;
        }
        this.a = null;
        if (!super.initializeCompute()) {
            return false;
        }
        this.a = this._controller.getReleaseTSContainer();
        if (this.a == null) {
            this._controller.getElementOp().getOperationsElement().getSystem().printErrorMessage("FlowLimitOpRule.initializeCompute: Failed to load time series arrays");
            return false;
        }
        if (this._functionType == 3 && this.b == null) {
            this.b = this._controller.getElementOp().getOperationsElement().getStorageFunction().getTSContainer(10);
        }
        return true;
    }

    public boolean isValid() {
        if (this._functionType == 0) {
            if (!RMAConst.isValidValue((double)this._maxRate)) {
                return false;
            }
        } else if (this._functionType == 1 || this._functionType == 2 || this._functionType == 3) {
            if (this._pvChangeLimit == null || this._pvChangeLimit.size() < 2 || !this._pvChangeLimit.canInterpX()) {
                RssSystem rssSystem = this._controller.getElementOp().getOperationsElement().getSystem();
                String string = "RateChangeLimitOpRule.initializeCompute: Values for variable rate of change are not defined or x-values are not in ascending order.";
                rssSystem.printErrorMessage(string);
                string = rssSystem.getNameForKeyString(this._controller.getName());
                rssSystem.printErrorMessage("  Reservoir = " + string);
                rssSystem.printErrorMessage("  Rule name = " + this.getName());
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public double getRateOfChangeLimit(RunTimeStep runTimeStep) {
        int n = runTimeStep.step - 1;
        if (n < 0) {
            n = 0;
        }
        double d = this.a.array[n];
        double d2 = this._maxRate;
        if (this._functionType == 1) {
            double d3 = this._controller.getElementOp().getOperationsElement().getStorageFunction().getNetInflow(runTimeStep);
            if (d3 == Double.NEGATIVE_INFINITY) {
                this._controller.getElementOp().getOperationsElement().getSystem().printErrorMessage("RateChangeLimitOpRule.evaluateRule: inflow undefined");
                d2 = Double.NEGATIVE_INFINITY;
            } else {
                d2 = this._pvChangeLimit.interpolate(d3);
            }
        } else if (this._functionType == 2) {
            d2 = this._pvChangeLimit.interpolate(d);
        } else if (this._functionType == 3) {
            d2 = this._pvChangeLimit.interpolate(this.b.array[n]);
        }
        return d2;
    }

    public double getRateOfChangeLimit(double d, double d2, double d3) {
        double d4 = this._maxRate;
        if (this._functionType == 1) {
            d4 = this._pvChangeLimit.interpolate(d2);
        } else if (this._functionType == 2) {
            d4 = this._pvChangeLimit.interpolate(d);
        } else if (this._functionType == 3) {
            d4 = this._pvChangeLimit.interpolate(d3);
        }
        return d4;
    }

    @Override
    public OpValue evaluateRule(RunTimeStep runTimeStep, double d) {
        ((OpRule)this).evaluateLimits(runTimeStep, 0);
        return ((OpRule)this).getOpValue(runTimeStep);
    }

    @Override
    public Object clone() {
        RateChangeLimitOpRule rateChangeLimitOpRule = (RateChangeLimitOpRule)super.clone();
        ((RateChangeLimitOpRule)super.clone())._pvChangeLimit = (PairedValues)this._pvChangeLimit.clone();
        return rateChangeLimitOpRule;
    }

    public void setChangeLimitCurve(PairedValues pairedValues) {
        if (pairedValues == null) {
            return;
        }
        this._pvChangeLimit = pairedValues;
    }

    public PairedValues getChangeLimitCurve() {
        this._pvChangeLimit.setUnitSystem(this.getUnitSystem());
        this._pvChangeLimit.setParamYId(Parameter.PARAMID_FLOW);
        if (this._functionType == 3) {
            this._pvChangeLimit.setParamXId(Parameter.PARAMID_ELEV);
        } else {
            this._pvChangeLimit.setParamXId(Parameter.PARAMID_FLOW);
        }
        return this._pvChangeLimit;
    }

    public int getFunctionType() {
        return this._functionType;
    }

    public void setFunctionType(int n) {
        this._functionType = n;
    }

    public void setInterpolationType(int n) {
        this._pvChangeLimit.setInterpolationType(n);
    }

    public int getInterpolationType() {
        return this._pvChangeLimit.getInterpolationType();
    }

    public void setType(int n) {
        if (n != 1 && n != 0) {
            return;
        }
        this._type = n;
    }

    public int getType() {
        return this._type;
    }

    public void setMaxRateOfChange(ParamDouble paramDouble) {
        this._maxRate = paramDouble.getValue();
    }

    public void setMaxRateOfChange(double d) {
        this._maxRate = d;
    }

    public void getMaxRateOfChange(ParamDouble paramDouble) {
        paramDouble.setValue(this._maxRate);
        paramDouble.setUnitSystem(this.getController().getElementOp().getOperationsElement().getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_FLOW);
    }

    public double getMaxRateOfChange() {
        return this._maxRate;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        super.outputReport(alternativeInputReport, element);
        element.setAttribute("Rule", "RateOfChange");
        element.setAttribute("RateType", Integer.toString(this._type));
        element.setAttribute("FunctionType", Integer.toString(this._functionType));
        if (this._functionType == 0) {
            element.setAttribute("MaxRateOfChange", Double.toString(this._maxRate));
            return;
        }
        element.setAttribute("Interpolate", Integer.toString(this._pvChangeLimit.getInterpolationType()));
        alternativeInputReport = new Element("ResInflow");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((Element)alternativeInputReport, (double[])this._pvChangeLimit.getXArray());
        alternativeInputReport = new Element("RateOfChange");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((Element)alternativeInputReport, (double[])this._pvChangeLimit.getYArray());
    }

    @Override
    public WaterAccount getWaterAccount() {
        return this.c;
    }

    @Override
    public void setWaterAccount(WaterAccount waterAccount) {
        this.c = waterAccount;
    }
}

