/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.model.ModelVariable;
import hec.model.PairedValues;
import hec.model.RunTimeWindow;
import hec.rss.model.CoefRouting;
import hec.rss.model.Element;
import hec.rss.model.ElementAssignmentContainer;
import hec.rss.model.Function;
import hec.rss.model.FunctionFactory;
import hec.rss.model.ITimeStepRoutingElement;
import hec.rss.model.LagAndKRouting;
import hec.rss.model.MuskingumCungeRouting;
import hec.rss.model.MuskingumRouting;
import hec.rss.model.NullRouting;
import hec.rss.model.PulsChannelRoutingWithLosses;
import hec.rss.model.RSimDssPathPartGenerator;
import hec.rss.model.Routing;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.RuleResolution;
import hec.rss.model.SeepageConstants;
import hec.rss.model.SsarrRouting;
import hec.rss.model.TimeStepRoutingElement;
import hec.rss.model.WorkingRDRouting;
import hec.rss.model.reports.AltInputReportEnums;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.jdom.Content;
import rma.util.RMAIO;
import rma.util.rmaTokenizer;

public class ReachElement
extends TimeStepRoutingElement
implements ITimeStepRoutingElement,
SeepageConstants,
AltInputReportInfc {
    int _seepageType = 0;
    double _constSeepage = Double.NEGATIVE_INFINITY;
    int _constSeepagePrecision = 2;
    double _returnRatio = 1.0;
    PairedValues _seepageValues = new PairedValues();
    private transient WorldPt a = new WorldPt();
    private transient WorldLine b = new WorldLine();
    private String _fillColorName = null;

    public ReachElement() {
    }

    @Override
    public boolean initialize(RunTimeWindow runTimeWindow) {
        return super.initialize(runTimeWindow);
    }

    public boolean initializeRoutingForWQ(RunTimeWindow runTimeWindow) {
        return super.setRoutingFunction(runTimeWindow);
    }

    public double calcLag() {
        double d = 0.0;
        if (this._function == null) {
            return 0.0;
        }
        if (this._function instanceof CoefRouting) {
            d = ((CoefRouting)this._function).calcLag();
        }
        return d;
    }

    @Override
    public void setupForSerialization() {
        super.setupForSerialization();
        if (this._seepageValues == null) {
            return;
        }
        Object object = new DSSPathname();
        Object object2 = new RSimDssPathPartGenerator();
        Object object3 = this.getTopParent().getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)object3);
        object3 = object2.generatePathnamePart(arrayList, "");
        object.setAPart((String)object3);
        arrayList.clear();
        arrayList.add("Seepage");
        object3 = this.getSystem();
        object2 = object3 != null ? ((RssSystem)object3).generateUniquePathPart(arrayList, "-") : object2.generatePathnamePart(arrayList, "-");
        object.setBPart((String)object2);
        object2 = Parameter.getParamString((int)Parameter.PARAMID_FLOW) + "-" + Parameter.getParamString((int)Parameter.PARAMID_FLOW);
        object.setCPart((String)object2);
        object2 = this.getSystem().getDssPairedDataFilePath();
        object = object.getPathname();
        this._seepageValues.setDssIdentifer(new DSSIdentifier((String)object2, (String)object));
        this._seepageValues.setParamXId(Parameter.PARAMID_ELEV);
        this._seepageValues.setParamYId(Parameter.PARAMID_FLOW);
        this._seepageValues.setUnitSystem(this.getUnitSystem());
    }

    public ReachElement(RssSystem rssSystem, int n) {
        super(rssSystem, n);
        this._function = new NullRouting(this);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public synchronized Object clone() {
        ReachElement reachElement = (ReachElement)super.clone();
        if (this._seepageValues != null) {
            reachElement._seepageValues = (PairedValues)this._seepageValues.clone();
        }
        return reachElement;
    }

    @Override
    public int computeHindcast(RunTimeWindow runTimeWindow, int n) {
        if (this._function == null) {
            return 1;
        }
        if (!(this._function instanceof Routing)) {
            return super.computeHindcast(runTimeWindow, n);
        }
        return ((Routing)this._function).computeHindcast(runTimeWindow, n);
    }

    @Override
    public int computeForecast(RunTimeWindow runTimeWindow, int n) {
        if (this._function == null) {
            return 1;
        }
        if (!(this._function instanceof Routing)) {
            return super.computeForecast(runTimeWindow, n);
        }
        return ((Routing)this._function).computeForecast(runTimeWindow, n);
    }

    @Override
    public double calcSeepageFlow(double d) {
        double d2 = 0.0;
        if (this._seepageType == 0) {
            d2 = this._constSeepage;
        } else if (this._seepageType == 2) {
            d2 = d * (1.0 - this._returnRatio);
        } else if (this._seepageType == 1) {
            d2 = this._seepageValues.interpolateValue(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return d2;
    }

    public double getConstSeepage() {
        return this._constSeepage;
    }

    public void getConstSeepage(ParamDouble paramDouble) {
        paramDouble.setValue(this._constSeepage);
        paramDouble.setParameterId(Parameter.PARAMID_FLOW);
        paramDouble.setUnitSystem(this.getUnitSystem());
    }

    public void setConstSeepage(ParamDouble paramDouble) {
        this._constSeepage = paramDouble.getValue();
    }

    public void setConstSeepage(double d) {
        this._constSeepage = d;
    }

    public double getReturnRatio() {
        return this._returnRatio;
    }

    public void setReturnRatio(double d) {
        this._returnRatio = d;
    }

    public PairedValues getSeepageValues() {
        this._seepageValues.setUnitSystem(this.getUnitSystem());
        this._seepageValues.setParamXId(Parameter.PARAMID_FLOW);
        this._seepageValues.setParamYId(Parameter.PARAMID_FLOW);
        return this._seepageValues;
    }

    public void setSeepageValues(PairedValues pairedValues) {
        this._seepageValues = pairedValues;
    }

    public int getSeepageType() {
        return this._seepageType;
    }

    public boolean setSeepageType(int n) {
        if (n < 0 || n > 1) {
            return false;
        }
        this._seepageType = n;
        return true;
    }

    public WorldLine getLine() {
        return this.b;
    }

    @Override
    public WorldPt getReferencePt() {
        return this.a;
    }

    public void setReferencePt(WorldPt worldPt) {
        this.a = worldPt;
    }

    public void setLine(WorldLine worldLine) {
        if (worldLine == null) {
            return;
        }
        this.b = worldLine;
        this.a = (WorldPt)this.b.pts.elementAt(0);
    }

    @Override
    public RssNode getUpstreamNode() {
        if (this._nodeVector.size() <= 0) {
            return null;
        }
        return this._nodeVector.elementAt(0);
    }

    @Override
    public RssNode getDownstreamNode() {
        if (this._nodeVector.size() < 2) {
            return null;
        }
        return this._nodeVector.elementAt(1);
    }

    @Override
    public boolean readData(BufferedReader bufferedReader) {
        try {
            Object object = bufferedReader.readLine();
            while (object != null) {
                if (((String)object).length() == 0) {
                    object = bufferedReader.readLine();
                    continue;
                }
                String string = RMAIO.getType((String)object, (String)"=");
                object = RMAIO.getParam((String)object, (String)"=");
                if (string.compareTo("ReachElement Name") == 0) {
                    this.setName((String)object);
                } else if (string.compareTo("ReachElement Description") == 0) {
                    this.setDescription((String)object);
                } else if (string.compareTo("ReachElement ReferencePt") == 0) {
                    this.a.parseString((String)object);
                } else if (string.compareTo("ReachElement Region") == 0) {
                    this.b.parseString((String)object);
                } else if (string.compareTo("Element Nodes") == 0) {
                    var4_7 = new rmaTokenizer((String)object, ",");
                    int n = 0;
                    while (var4_7.hasMoreTokens()) {
                        try {
                            int n2;
                            object = var4_7.nextToken();
                            if (this._nodeVector.size() < n + 1) {
                                this._nodeVector.setSize(n + 1);
                            }
                            if ((n2 = RMAIO.parseInt((String)object)) >= 0 && n2 != Integer.MIN_VALUE) {
                                var5_8 = this._system.getNode(n2);
                                this._nodeVector.setElementAt((RssNode)var5_8, n);
                                if (var5_8 == null) {
                                    this._system.printMessage("Warning! RssNode " + n2 + " not found");
                                }
                            }
                            ++n;
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            break;
                        }
                    }
                } else if (string.compareTo("Element NodeDir") == 0) {
                    var4_7 = new rmaTokenizer((String)object, ",");
                    int n = 0;
                    while (var4_7.hasMoreTokens()) {
                        try {
                            object = var4_7.nextToken();
                            if (this._nodeDirVector.size() < n + 1) {
                                this._nodeDirVector.setSize(n + 1);
                            }
                            int[] nArray = new int[1];
                            var5_8 = nArray;
                            nArray[0] = RMAIO.parseInt((String)object);
                            if (var5_8[0] >= 0 && var5_8[0] != Integer.MIN_VALUE) {
                                this._nodeDirVector.setElementAt(new Integer(var5_8[0]), n);
                                object = this._nodeVector.elementAt(n);
                                if (var5_8[0] == 0) {
                                    ((RssNode)object).setUpstreamElement(this);
                                } else {
                                    ((RssNode)object).setDownstreamElement(this);
                                }
                            }
                            ++n;
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            break;
                        }
                    }
                } else if (string.compareTo("Element Function") == 0) {
                    var4_7 = FunctionFactory.a(this, (String)object);
                    if (var4_7 == null) {
                        this._system.printMessage("Could not create Function " + (String)object);
                    } else if (((Function)var4_7).readData(bufferedReader)) {
                        this._function = var4_7;
                    }
                } else if (string.compareTo("ReachElement End") == 0) break;
                object = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean writeData(BufferedWriter bufferedWriter) {
        Object object;
        int n;
        new String();
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ReachElement=" + this.getIndex()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ReachElement Name= " + this.getName()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ReachElement Description= " + this.getDescription()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ReachElement ReferencePt= " + this.a.toString()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ReachElement Region= " + this.b.toString()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        if (this._function != null) {
            this._function.writeData(bufferedWriter);
        }
        Object object2 = "Element Nodes= ";
        for (n = 0; n < this._nodeVector.size(); ++n) {
            object = this._nodeVector.elementAt(n);
            object2 = (String)object2 + object.getIndex() + ", ";
        }
        if (this._nodeVector.size() > 0) {
            object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)object2);
        object2 = "Element NodeDir= ";
        for (n = 0; n < this._nodeDirVector.size(); ++n) {
            object = this._nodeDirVector.elementAt(n);
            object2 = (String)object2 + ((Integer)object).toString() + ", ";
        }
        if (this._nodeDirVector.size() > 0) {
            object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)object2);
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"ReachElement End");
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        return true;
    }

    @Override
    public Vector getModelVariables(Vector vector) {
        if (vector == null) {
            vector = new Vector<ModelVariable>();
        }
        vector.add(RssModelVariableSet.getModelVariable(100));
        vector.add(RssModelVariableSet.getModelVariable(103));
        vector.add(RssModelVariableSet.getModelVariable(101));
        vector.add(RssModelVariableSet.getModelVariable(102));
        return vector;
    }

    @Override
    public Vector getDefaultModelVariables() {
        Vector<ModelVariable> vector = new Vector<ModelVariable>();
        vector.add(RssModelVariableSet.getModelVariable(100));
        return vector;
    }

    @Override
    public Vector getPlotTypes() {
        Vector vector = new Vector();
        return vector;
    }

    @Override
    public Vector getTSRecords(ModelVariable object, Vector vector) {
        if (vector == null) {
            vector = new Vector<Object>();
        }
        if (object == null) {
            return vector;
        }
        switch (object.getType()) {
            case 100: {
                object = ((Element)this).getDownstreamNode();
                if (object == null || (object = ((RssNode)object).getTSRecordProxy(0)) == null) break;
                vector.addElement(object);
                break;
            }
            case 103: {
                object = ((Element)this).getUpstreamNode();
                if (object == null || (object = ((RssNode)object).getTSRecordProxy(0)) == null) break;
                vector.addElement(object);
                break;
            }
            case 101: {
                object = ((Element)this).getDownstreamNode();
                if (object == null || (object = ((RssNode)object).getTSRecordProxy(0)) == null) break;
                vector.addElement(object);
                break;
            }
            case 102: {
                object = ((Element)this).getDownstreamNode();
                if (object == null || (object = ((RssNode)object).getTSRecordProxy(0)) == null) break;
                vector.addElement(object);
            }
        }
        return vector;
    }

    public boolean importFrom(RuleResolution object) {
        if (!(((ElementAssignmentContainer)object).b instanceof ReachElement)) {
            System.out.println("importFrom: can't import a ReachElement from a " + String.valueOf(((ElementAssignmentContainer)object).b));
            return false;
        }
        object = (ReachElement)((ElementAssignmentContainer)object).b;
        this.setDescription(object.getDescription());
        Duration[] durationArray = ((Element)object).getFunction();
        this.setFunction((Function)durationArray.clone());
        Duration[] durationArray2 = ((TimeStepRoutingElement)object).getDefinedTimeStepDurations();
        durationArray = durationArray2;
        durationArray = durationArray2;
        int n = durationArray2.length;
        for (int i = 0; i < n; ++i) {
            Duration duration = durationArray[i];
            Function function = ((TimeStepRoutingElement)object).getFunction(duration, null);
            if (function == null) continue;
            this.putFunction(duration, (Function)((RssTSLocationObject)function).clone());
        }
        this.setSeepageType(((ReachElement)object).getSeepageType());
        this.setSeepageValues((PairedValues)((ReachElement)object).getSeepageValues().clone());
        this.setConstSeepage(((ReachElement)object).getConstSeepage());
        this.setReturnRatio(((ReachElement)object).getReturnRatio());
        this.importObservedData((Element)object, null);
        this.setModified(true);
        this.getSystem().setModified(true);
        return true;
    }

    public void setFillColorName(String string) {
        this._fillColorName = string;
    }

    public String getFillColorName() {
        return this._fillColorName;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport object, org.jdom.Element element) {
        org.jdom.Element element2;
        element.setAttribute("Name", this.getDisplayName());
        element.setAttribute("Description", this.getDescription());
        if (((AlternativeInputReport)object).b().get((Object)AltInputReportEnums.REACH_ROUTING).a()) {
            element2 = new org.jdom.Element("Routing");
            element.addContent((Content)element2);
            if (this._function instanceof NullRouting) {
                element2.setAttribute("Type", "NullRouting");
            } else if (this._function instanceof CoefRouting) {
                element2.setAttribute("Type", "Coef");
                ((Routing)((CoefRouting)this._function)).outputReport((AlternativeInputReport)object, element2);
            } else if (this._function instanceof MuskingumRouting) {
                element2.setAttribute("Type", "MuskingumRouting");
                ((Routing)((MuskingumRouting)this._function)).outputReport((AlternativeInputReport)object, element2);
            } else if (this._function instanceof MuskingumCungeRouting) {
                ((Routing)((MuskingumCungeRouting)this._function)).outputReport((AlternativeInputReport)object, element2);
            } else if (this._function instanceof PulsChannelRoutingWithLosses) {
                element2.setAttribute("Type", "ModifiedPulse");
                ((Routing)((PulsChannelRoutingWithLosses)this._function)).outputReport((AlternativeInputReport)object, element2);
            } else if (this._function instanceof SsarrRouting) {
                element2.setAttribute("Type", "SsarrRouting");
                ((Routing)((SsarrRouting)this._function)).outputReport((AlternativeInputReport)object, element2);
            } else if (this._function instanceof WorkingRDRouting) {
                element2.setAttribute("Type", "WorkingRDRouting");
                ((Routing)((WorkingRDRouting)this._function)).outputReport((AlternativeInputReport)object, element2);
            } else if (this._function instanceof LagAndKRouting) {
                element2.setAttribute("Type", "VariableLagKRouting");
                ((Routing)((LagAndKRouting)this._function)).outputReport((AlternativeInputReport)object, element2);
            }
        }
        if (((AlternativeInputReport)object).b().get((Object)AltInputReportEnums.REACH_LOSSES).a()) {
            element2 = new org.jdom.Element("Losses");
            element.addContent((Content)element2);
            if (this._seepageType == 0) {
                element2.setAttribute("ConstantSeepage", Double.toString(this._constSeepage));
            } else {
                org.jdom.Element element3 = new org.jdom.Element("Flows");
                element2.addContent((Content)element3);
                XMLUtilities.createArrayElements((org.jdom.Element)element3, (double[])this._seepageValues.getXArray());
                element3 = new org.jdom.Element("Seepages");
                element2.addContent((Content)element3);
                XMLUtilities.createArrayElements((org.jdom.Element)element3, (double[])this._seepageValues.getYArray());
            }
        }
        if (((AlternativeInputReport)object).b().get((Object)AltInputReportEnums.REACH_OBSERVED).a() && this._obsDataVector != null && !this._obsDataVector.isEmpty()) {
            element2 = new org.jdom.Element("ObservedData");
            element.addContent((Content)element2);
            for (int i = 0; i < this._obsDataVector.size(); ++i) {
                object = (String)this._obsDataVector.get(i);
                element2.setAttribute("NameParamID", (String)object);
            }
        }
    }
}

