/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.intContainer;
import hec.io.AsciiSerializable;
import hec.model.IntToDoubleArrayContainer;
import hec.model.IntToDoubleContainer;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class ReleaseAllocation
implements AsciiSerializable,
AltInputReportInfc,
Cloneable {
    public static final int SEQUENTIAL_RELEASE = 0;
    public static final int BALANCED_RELEASE = 1;
    public static final int STEPPED_RELEASE = 2;
    public static final String SEQUENTIAL_RELEASE_NAME = "Sequential";
    public static final String BALANCED_RELEASE_NAME = "Balanced";
    public static final String STEPPED_RELEASE_NAME = "Stepped";
    public static final int FLOW_CAPACITY = 0;
    public static final int PERCENT_GATE_OPENING = 1;
    public static final int GATE_OPENING_HEIGHT = 2;
    public static final String[] RELEASE_NAMES = new String[]{"Sequential", "Balanced", "Stepped"};
    public static final String RELEASE_UNIT_CAPACITY = "% Release Capacity";
    public static final String RELEASE_UNIT_PERC_GATE_OPENING = "% Gate Opening";
    public static final String[] RELEASE_UNITS = new String[]{"% Release Capacity", "% Gate Opening"};
    private String _name;
    private String _description;
    private int _allocationType = 1;
    private int _releaseUnits;
    private List _releaseList = new ArrayList();

    public ReleaseAllocation() {
    }

    public ReleaseAllocation(int n) {
        this();
        this.setAllocationType(n);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Invalid Release Allocation name.  Name cannot be NULL or Empty");
        }
        this._name = string;
    }

    public void setDescription(String string) {
        this._description = string != null ? string : "";
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        ReleaseAllocation releaseAllocation = (ReleaseAllocation)super.clone();
        if (this._releaseList != null) {
            int n = this._releaseList.size();
            releaseAllocation._releaseList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                Object object = this._releaseList.get(i);
                if (object instanceof IntToDoubleContainer) {
                    object = (IntToDoubleContainer)object;
                    releaseAllocation._releaseList.add(new IntToDoubleContainer(((IntToDoubleContainer)object).intValue, ((IntToDoubleContainer)object).doubleValue));
                    continue;
                }
                if (object instanceof intContainer) {
                    releaseAllocation._releaseList.add(new intContainer(((intContainer)object).value));
                    continue;
                }
                if (!(object instanceof IntToDoubleArrayContainer)) continue;
                object = (IntToDoubleArrayContainer)object;
                releaseAllocation._releaseList.add(object.clone());
            }
        }
        return releaseAllocation;
    }

    public int getAllocationType() {
        return this._allocationType;
    }

    public String getAllocationTypeString() {
        if (this._allocationType < 0 || this._allocationType >= RELEASE_NAMES.length) {
            return null;
        }
        return RELEASE_NAMES[this._allocationType];
    }

    public void setAllocationType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Invalid Release Allocation Type " + n);
        }
        if (this._allocationType != n) {
            this._releaseList.clear();
        }
        this._allocationType = n;
    }

    public void setAllocationType(String string) {
        for (int i = 0; i < RELEASE_NAMES.length; ++i) {
            if (!RELEASE_NAMES[i].equalsIgnoreCase(string)) continue;
            this.setAllocationType(i);
            return;
        }
        throw new IllegalArgumentException("Invalid Release Allocation Name " + string);
    }

    public void addReleaseElement(Object object) {
        if (object == null) {
            return;
        }
        switch (this._allocationType) {
            case 0: {
                if (!(object instanceof intContainer)) break;
                this._releaseList.add(object);
                return;
            }
            case 1: {
                if (!(object instanceof IntToDoubleContainer)) break;
                this._releaseList.add(object);
                return;
            }
            case 2: {
                if (!(object instanceof IntToDoubleArrayContainer)) break;
                this._releaseList.add(object);
            }
        }
    }

    public void setReleaseUnits(int n) {
        this._releaseUnits = n;
    }

    public void setReleaseUnits(String string) {
        for (int i = 0; i < RELEASE_UNITS.length; ++i) {
            if (!RELEASE_UNITS[i].equalsIgnoreCase(string)) continue;
            this.setReleaseUnits(i);
        }
    }

    public List getAllocationList() {
        return this._releaseList;
    }

    public int getReleaseUnits() {
        return this._releaseUnits;
    }

    public String getReleaseUnitsString() {
        if (this._releaseUnits < 0 || this._releaseUnits > 2) {
            return null;
        }
        return RELEASE_UNITS[this._releaseUnits];
    }

    public String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Allocation Type:" + RELEASE_NAMES[this._allocationType]);
        stringBuffer.append(" ReleaseList:");
        stringBuffer.append(this._releaseList);
        if (this._allocationType == 2) {
            stringBuffer.append(" Release Units:" + this._releaseUnits);
        }
        return stringBuffer.toString();
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        element.setAttribute("AllocationType", Integer.toString(this._allocationType));
        if (this._releaseList != null) {
            int n = this._releaseList.size();
            for (int i = 0; i < n; ++i) {
                IntToDoubleContainer intToDoubleContainer;
                alternativeInputReport = this._releaseList.get(i);
                if (alternativeInputReport instanceof IntToDoubleContainer) {
                    intToDoubleContainer = (IntToDoubleContainer)alternativeInputReport;
                    element.setAttribute("ElementID", Integer.toString(intToDoubleContainer.intValue));
                    element.setAttribute("Weight", Double.toString(intToDoubleContainer.doubleValue));
                    continue;
                }
                if (alternativeInputReport instanceof intContainer) {
                    element.setAttribute(SEQUENTIAL_RELEASE_NAME, Double.toString(((intContainer)alternativeInputReport).value));
                    continue;
                }
                if (!(alternativeInputReport instanceof IntToDoubleArrayContainer)) continue;
                intToDoubleContainer = (IntToDoubleArrayContainer)alternativeInputReport;
                element.setAttribute("ElementID", Integer.toString(intToDoubleContainer.intValue));
                alternativeInputReport = new Element("Capacity");
                element.addContent((Content)alternativeInputReport);
                XMLUtilities.createArrayElements((Element)alternativeInputReport, (double[])intToDoubleContainer.doubleVector.toArray());
            }
        }
    }
}

