/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.heclib.util.HecTime;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.model.RunTimeStep;
import hec.model.SeasonalPairedValues;
import hec.model.SeasonalRecord;
import hec.model.TSLocation;
import hec.model.ValueSet;
import hec.rss.model.DemandRuleInf;
import hec.rss.model.Element;
import hec.rss.model.IndependentVariable;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import hec.rss.model.OperationsElement;
import hec.rss.model.PowerGenerationPatternContainer;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.StateVariable;
import hec.rss.model.WaterAccount;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.TimeSeriesGlobalVariable;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import rma.util.RMAConst;

public class ReleaseFuncOpRule
extends OpRule
implements AsciiSerializable,
DemandRuleInf,
Serializable,
Cloneable {
    public static final int MIN = -1;
    public static final int MAX = 1;
    public static final int SPECIFIED = 0;
    public static final int DEMAND = 2;
    public static final int NONE = 0;
    public static final int DAILY = 1;
    public static final int WEEKLY = 2;
    private int _period;
    private int _startingDay;
    IndependentVariable _independentVariable;
    protected int _limitType = Integer.MIN_VALUE;
    private SeasonalPairedValues _seasonalPairedValues;
    private SeasonalRecord _seasonalRecord;
    protected PowerGenerationPatternContainer _patternContainer = null;
    private transient doubleArrayContainer a;
    private transient doubleArrayContainer b;
    transient WaterAccount i;

    public ReleaseFuncOpRule() {
    }

    public ReleaseFuncOpRule(String string) {
        super(string);
    }

    @Override
    public TSRecordProxy getTargetTSRecordProxy() {
        TSRecordProxy tSRecordProxy = null;
        TSLocation tSLocation = this._controller.getReleaseElement();
        tSLocation = tSLocation.getDownstreamNode() == null ? tSLocation.getNode(0) : tSLocation.getDownstreamNode();
        if (tSLocation != null) {
            tSRecordProxy = tSLocation.getTSRecordProxy(0);
        }
        return tSRecordProxy;
    }

    @Override
    public void updateByDemandScale(double d) {
        if (this._independentVariable == null) {
            return;
        }
        switch (this._independentVariable.getType()) {
            case 0: 
            case 1: {
                this._seasonalRecord.scaleValues(d);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                ReleaseFuncOpRule releaseFuncOpRule = this;
                releaseFuncOpRule.scaleValues(releaseFuncOpRule._seasonalPairedValues, d);
                break;
            }
            default: {
                return;
            }
        }
        this.setDemandScale(1.0);
    }

    private void scaleValues(SeasonalPairedValues object, double d) {
        if ((object = object.getDataVector()) != null) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                ValueSet valueSet = (ValueSet)((Vector)object).elementAt(i);
                int n = 0;
                while (n < valueSet.yval.length) {
                    int n2 = n++;
                    valueSet.yval[n2] = valueSet.yval[n2] * d;
                }
            }
        }
    }

    @Override
    public void getElementDependencies(List list) {
        IndependentVariable independentVariable = this.getIndependentVariable();
        OperationsElement operationsElement = this.getOperationsElement();
        if (independentVariable == null || operationsElement == null) {
            return;
        }
        independentVariable.getElementDependencies(list, (Element)((Object)operationsElement));
    }

    @Override
    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
        double d = this.getLimitValue(runTimeStep);
        if (this._period != 0 && d != Double.NEGATIVE_INFINITY) {
            d = this.getPeriodAvgLimit(runTimeStep, d);
        }
        if (d == Double.NEGATIVE_INFINITY) {
            d = -3.4028234663852886E38;
        }
        this.h.array[runTimeStep.step] = d;
    }

    @Override
    public OpValue getOpValue(RunTimeStep runTimeStep) {
        if (!RMAConst.isValidValue((double)this.h.array[runTimeStep.step])) {
            return null;
        }
        OpValue opValue = new OpValue();
        new OpValue().value = this.h.array[runTimeStep.step];
        opValue.type = this._limitType == 0 ? 1 : (this._limitType == 1 ? 2 : 0);
        return opValue;
    }

    @Override
    public boolean isLocalRule() {
        return true;
    }

    @Override
    public boolean isDnstrmRule() {
        return false;
    }

    @Override
    public boolean isPerAvgRule() {
        return this._period != 0;
    }

    public PowerGenerationPatternContainer getPatternContainer() {
        if (this._patternContainer == null) {
            this._patternContainer = new PowerGenerationPatternContainer();
        }
        return this._patternContainer;
    }

    public void setPatternContainer(PowerGenerationPatternContainer powerGenerationPatternContainer) {
        this._patternContainer = powerGenerationPatternContainer;
    }

    @Override
    public int getRuleLimitType() {
        if (this._limitType == -1) {
            return 0;
        }
        if (this._limitType == 1) {
            return 2;
        }
        if (this._limitType == 0) {
            return 1;
        }
        return this._limitType;
    }

    @Override
    public void getReferencedStateVariables(List list) {
        if (this._independentVariable == null) {
            return;
        }
        if (this._independentVariable.getType() == 4) {
            RssReturnStatusConstants rssReturnStatusConstants = ((RssTSLocationObject)this).getSystem();
            if (rssReturnStatusConstants == null) {
                return;
            }
            if ((rssReturnStatusConstants = rssReturnStatusConstants.getStateVariable(this._independentVariable.getStateVariableId())) != null && !list.contains(rssReturnStatusConstants)) {
                list.add(rssReturnStatusConstants);
            }
        }
    }

    @Override
    public Vector getRequiredTSRecordProxies(Vector vector) {
        if (vector == null) {
            vector = new Vector<Object>();
        }
        if (this._independentVariable == null || this._independentVariable.getType() != 2) {
            return vector;
        }
        Object object = this.getController();
        if (object == null) {
            return vector;
        }
        if ((object = ((OpController)object).getElementOp().getOperationsElement()) == null) {
            return vector;
        }
        RssSystem rssSystem = object.getSystem();
        Element element = rssSystem.getElement(this._independentVariable.getElementId());
        if (element == null) {
            return vector;
        }
        if (object == (element = element.getTopParent())) {
            return vector;
        }
        if (((Vector)(object = rssSystem.getDownstreamElements((Element)object, false))).contains(element)) {
            return vector;
        }
        object = rssSystem.getTSRecordProxy(this._independentVariable.getTSProxyName(), this._independentVariable.getModelVariableId());
        if (object != null) {
            vector.add(object);
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        String string;
        TSRecordProxy tSRecordProxy;
        super.updateTSProxyList();
        if (this._independentVariable != null && this._independentVariable.getType() == 3 && (tSRecordProxy = this.getTSRecordProxy(string = this._independentVariable.getTimeSeriesName(), 85)) == null) {
            this.addTSRecordProxy(string, 85);
        }
    }

    public int getPeriod() {
        return this._period;
    }

    public int getStartingDay() {
        if (this._startingDay <= 0) {
            this._startingDay = 1;
        }
        return this._startingDay;
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        vector = super.getActiveTSRecordProxies(vector, n);
        if (n == 1 && this._independentVariable != null && this._independentVariable.getType() == 3) {
            String string = this._independentVariable.getTimeSeriesName();
            if ((string = this.getTSRecordProxy(string, 85)) != null) {
                vector.addElement(string);
            }
        }
        return vector;
    }

    @Override
    public boolean initializeCompute() {
        RssSystem rssSystem = ((RssTSLocationObject)this).getSystem();
        if (rssSystem == null) {
            return false;
        }
        this.h = null;
        this.a = null;
        if (!super.initializeCompute()) {
            return false;
        }
        if (this._independentVariable == null) {
            rssSystem.printErrorMessage("ReleaseFuncOpRule.initializeCompute(" + this.getName() + "): Function is not defined");
            return false;
        }
        switch (this._independentVariable.getType()) {
            case 2: {
                TSRecordProxy tSRecordProxy = rssSystem.getTSRecordProxy(this._independentVariable.getTSProxyName(), this._independentVariable.getModelVariableId());
                if (tSRecordProxy == null) {
                    rssSystem.printErrorMessage("ReleaseFuncOpRule.initializeCompute(" + this.getName() + "): failed to find TSRecordProxy");
                    return false;
                }
                this.a = tSRecordProxy.getTSContainer();
                if (this.a != null) break;
                rssSystem.printErrorMessage("ReleaseFuncOpRule.initializeCompute(" + this.getName() + "): failed to find Model Variable Time Series");
                return false;
            }
            case 3: {
                String string = this._independentVariable.getTimeSeriesName();
                if (string == null) {
                    rssSystem.printErrorMessage("ReleaseFuncOpRule.initializeCompute:(" + this.getName() + ") external time series name is null");
                    return false;
                }
                this.a = this.getTSContainer(string, 85);
                if (this.a != null) break;
                rssSystem.printErrorMessage("ReleaseFuncOpRule.initializeCompute:(" + this.getName() + ") failed to find Time Series");
                return false;
            }
            case 4: {
                int n = this._independentVariable.getStateVariableId();
                StateVariable stateVariable = rssSystem.getStateVariable(n);
                if (stateVariable == null) {
                    stateVariable = rssSystem.getStateVariable(this._independentVariable.getStateVariableName());
                }
                if (stateVariable == null) {
                    rssSystem.printErrorMessage("ReleaseFuncOpRule.initializeCompute:(" + this.getName() + ") failed to find State Variable => " + this._independentVariable.getStateVariableName());
                    return false;
                }
                this.a = stateVariable.getTSContainer(97);
                if (this.a != null) break;
                rssSystem.printErrorMessage("ReleaseFuncOpRule.initializeCompute:(" + this.getName() + ") failed to find State Variable Time Series for " + stateVariable.getName());
                return false;
            }
            case 6: {
                int n = this._independentVariable.getGlobalVariableId();
                GlobalVariable globalVariable = rssSystem.getGlobalVariable(n);
                if (globalVariable == null) {
                    globalVariable = rssSystem.getGlobalVariable(this._independentVariable.getGlobalVariableName());
                }
                if (globalVariable == null) {
                    rssSystem.printErrorMessage("ReleaseFuncOpRule.initializeCompute:(" + this.getName() + ") failed to find Global Variable => " + this._independentVariable.getGlobalVariableName());
                    return false;
                }
                if (!(globalVariable instanceof TimeSeriesGlobalVariable)) {
                    rssSystem.printErrorMessage("ReleaseFuncOpRule.initializeCompute:(" + this.getName() + ") Global Variable => " + globalVariable.getName() + " is not a TimeSeriesGlobal Variable. Its a  " + String.valueOf((Object)globalVariable.getType()));
                    return false;
                }
                this.a = ((TimeSeriesGlobalVariable)globalVariable).getTSContainer();
                if (this.a != null) break;
                rssSystem.printErrorMessage("ReleaseFuncOpRule.initializeCompute:(" + this.getName() + ") failed to find Global Variable Time Series for " + globalVariable.getName());
                return false;
            }
        }
        if (this._controller != null) {
            this.b = this._controller.getReleaseTSContainer();
            if (this.b == null) {
                return false;
            }
        }
        return true;
    }

    public double getLargestLimitValue() {
        double d;
        if (this._independentVariable == null) {
            return Double.NEGATIVE_INFINITY;
        }
        switch (this._independentVariable.getType()) {
            case 0: 
            case 1: {
                d = this._seasonalRecord.getLargestValue();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                d = this._seasonalPairedValues.getLargestValue();
                break;
            }
            default: {
                return Double.NEGATIVE_INFINITY;
            }
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._period == 0) {
            double d2 = this.getLargestTimeOfDayFactor() * this.getLargestDayOfWeekFactor();
            d *= d2;
        }
        if (this.useDemandScale()) {
            return d * this.getDemandScale();
        }
        return d;
    }

    public double getLimitValue(RunTimeStep runTimeStep) {
        double d;
        double d2;
        if (this._independentVariable == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.getEnableRiseFallCondition() && !this.checkRisingFallingCondition(runTimeStep)) {
            return Double.NEGATIVE_INFINITY;
        }
        switch (this._independentVariable.getType()) {
            case 0: 
            case 1: {
                d2 = this._seasonalRecord.interpolate(runTimeStep);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                if (this.a == null) {
                    return Double.NEGATIVE_INFINITY;
                }
                d = this._independentVariable.evaluateTSFunction(runTimeStep, this.a.array);
                if (d == Double.NEGATIVE_INFINITY) {
                    return Double.NEGATIVE_INFINITY;
                }
                if (this._seasonalPairedValues.hasSeasonalVariation()) {
                    d2 = this._seasonalPairedValues.interpolate(runTimeStep, d);
                    break;
                }
                d2 = this._seasonalPairedValues.interpolate(d);
                break;
            }
            default: {
                return Double.NEGATIVE_INFINITY;
            }
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._period == 0) {
            d = this.getTimeOfDayFactor(runTimeStep) * this.getDayOfWeekFactor(runTimeStep);
            d2 *= d;
        }
        if (this.useDemandScale()) {
            return d2 * this.getDemandScale();
        }
        return d2;
    }

    @Override
    public OpValue evaluateRule(RunTimeStep object, double d, int n) {
        if (n < 0 && this._period != 0) {
            return null;
        }
        double d2 = this.getLimitValue((RunTimeStep)object);
        if (d2 == Double.NEGATIVE_INFINITY) {
            return null;
        }
        if (this._period != 0) {
            if (n <= 0) {
                return null;
            }
            if ((d2 = this.getPeriodAvgLimit((RunTimeStep)object, d2)) == Double.NEGATIVE_INFINITY) {
                return null;
            }
        }
        this.h.array[object.step] = d2;
        object = new OpValue();
        new OpValue().value = d2;
        object.type = this._limitType == 0 ? 1 : (this._limitType == 1 ? 2 : 0);
        return object;
    }

    private double getPeriodAvgLimit(RunTimeStep runTimeStep, double d) {
        double d2;
        int n;
        int n2;
        int n3;
        int n4;
        double d3;
        if (this._period == 0) {
            return d;
        }
        if (this._controller == null) {
            return d;
        }
        int n5 = runTimeStep.getTimeStepSeconds();
        HecTime hecTime = runTimeStep.getHecTime();
        int n6 = hecTime.secondsSinceMidnight();
        if (n6 == 0) {
            n6 = 86400;
        }
        if (this._period == 1) {
            d3 = d * 86400.0;
            n4 = 86400 / n5;
            n2 = n3 = n6 / n5 - 1;
        } else {
            d3 = d * 86400.0 * 7.0;
            n4 = 604800 / n5;
            int n7 = RunTimeStep.getDayOfWeek((HecTime)hecTime);
            int n8 = n7 - this._startingDay;
            if (n8 < 0) {
                n8 += 7;
            }
            n2 = n3 = n6 / n5 - 1 + n8 * 86400 / n5;
        }
        double d4 = this._controller.getAdjustableParameter().getMaxValue();
        PowerGenerationPatternContainer powerGenerationPatternContainer = this.getPatternContainer();
        boolean bl = !runTimeStep.isPerAvgTimeStep();
        double d5 = 0.0;
        for (int i = 0; i < n3; ++i) {
            int n9;
            n = runTimeStep.step - n3 + i - 1;
            if (n < 0) {
                n = 0;
            }
            if ((n9 = runTimeStep.step - n3 + i) < 0) {
                n9 = 0;
            }
            if (bl) {
                d5 += (this.b.array[n9] + this.b.array[n]) / 2.0 * (double)n5;
                continue;
            }
            d5 += this.b.array[n9] * (double)n5;
        }
        double d6 = d3 - d5;
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        Arrays.fill(dArray2, 0.0);
        if (bl) {
            dArray2[n2] = this.b.array[runTimeStep.step - 1] / 2.0 * (double)n5;
        }
        Arrays.fill(dArray, d4 * (double)n5);
        if (bl) {
            dArray[n2] = (this.b.array[runTimeStep.step - 1] + d4) / 2.0 * (double)n5;
        }
        double d7 = powerGenerationPatternContainer.computePatternValueForStep(runTimeStep, 11, this._period, this._startingDay + 1, dArray, dArray2, d3, d6, n2);
        double cfr_ignored_0 = d7 / (double)runTimeStep.getTimeStepSeconds();
        if (bl) {
            n = runTimeStep.step - 1;
            if (n < 0) {
                n = 0;
            }
            d2 = d7 * 2.0 / (double)n5 - this.b.array[n];
        } else {
            d2 = d7 / (double)n5;
        }
        return d2;
    }

    @Override
    public Object clone() {
        try {
            ReleaseFuncOpRule releaseFuncOpRule = (ReleaseFuncOpRule)super.clone();
            if (this._seasonalPairedValues != null) {
                releaseFuncOpRule._seasonalPairedValues = this._seasonalPairedValues.clone();
            }
            if (this._seasonalRecord != null) {
                releaseFuncOpRule._seasonalRecord = (SeasonalRecord)this._seasonalRecord.clone();
            }
            if (this._independentVariable != null) {
                releaseFuncOpRule._independentVariable = (IndependentVariable)this._independentVariable.clone();
            }
            if (this._patternContainer != null) {
                releaseFuncOpRule._patternContainer = (PowerGenerationPatternContainer)this._patternContainer.clone();
            }
            return releaseFuncOpRule;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setIndependentVariable(IndependentVariable independentVariable) {
        this._independentVariable = independentVariable;
    }

    public IndependentVariable getIndependentVariable() {
        return this._independentVariable;
    }

    public void setFunctionRelease(SeasonalPairedValues seasonalPairedValues) {
        if (seasonalPairedValues == null) {
            return;
        }
        this._seasonalPairedValues = seasonalPairedValues;
    }

    public SeasonalPairedValues getFunctionRelease() {
        if (this._seasonalPairedValues == null) {
            return null;
        }
        this._seasonalPairedValues.setUnitSystem(this.getUnitSystem());
        this._seasonalPairedValues.setParamXId(-1);
        this._seasonalPairedValues.setParamYId(Parameter.PARAMID_FLOW);
        return this._seasonalPairedValues;
    }

    public SeasonalRecord getSeasonalRecord() {
        if (this._seasonalRecord == null) {
            return null;
        }
        this._seasonalRecord.setUnitSystem(this.getUnitSystem());
        this._seasonalRecord.setParameterId(Parameter.PARAMID_FLOW);
        this._seasonalRecord.setGmtOffset(this.getGmtOffset());
        return this._seasonalRecord;
    }

    public void setSeasonalRecord(SeasonalRecord seasonalRecord) {
        this._seasonalRecord = seasonalRecord;
    }

    public void setTimeInterpolationType(int n) {
        if (this._seasonalPairedValues == null) {
            return;
        }
        this._seasonalPairedValues.setTimeInterpolationType(n);
    }

    public int getTimeInterpolationType() {
        if (this._seasonalPairedValues == null) {
            return 0;
        }
        return this._seasonalPairedValues.getTimeInterpolationType();
    }

    public int getLimitType() {
        return this._limitType;
    }

    public void setLimitType(int n) {
        if (n != -1 && n != 1 && n != 0 && n != 2) {
            return;
        }
        this._limitType = n;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public void setPeriod(int n) {
        this._period = n;
    }

    public void setStartingDay(int n) {
        this._startingDay = n;
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        org.jdom.Element element2;
        element.setAttribute("Name", this.getDisplayName());
        element.setAttribute("Description", this.getDescription());
        element.setAttribute("Limit_Type", Integer.toString(this._limitType));
        if (this._independentVariable != null) {
            element2 = new org.jdom.Element("IndependentVariable");
            this._independentVariable.outputReport(alternativeInputReport, element2);
            element.setAttribute("Function_Of", Integer.toString(this._independentVariable.getType()));
            if (this._independentVariable.getType() == 0) {
                element2 = new org.jdom.Element("Date");
                element.addContent((Content)element2);
                element.setAttribute("InterpType", Integer.toString(this._seasonalRecord.getInterpolationType()));
                XMLUtilities.createArrayElements((org.jdom.Element)element2, (int[])this._seasonalRecord.getTimeArray());
                element2 = new org.jdom.Element("Elevations");
                element.addContent((Content)element2);
                XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalRecord.getDataArray());
            } else if (this._independentVariable.getType() == 1) {
                element2 = new org.jdom.Element("DateTime");
                element.addContent((Content)element2);
                element.setAttribute("InterpType", Integer.toString(this._seasonalRecord.getInterpolationType()));
                XMLUtilities.createArrayElements((org.jdom.Element)element2, (int[])this._seasonalRecord.getTimeArray());
                element2 = new org.jdom.Element("Elevations");
                element.addContent((Content)element2);
                XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalRecord.getDataArray());
            } else if (this._independentVariable.getType() == 2) {
                element2 = new org.jdom.Element("ModelVariable");
                element.addContent((Content)element2);
                if (this._seasonalPairedValues.hasSeasonalVariation()) {
                    element.setAttribute("HasSeasonalVariation", Boolean.toString(this._seasonalPairedValues.hasSeasonalVariation()));
                    element.setAttribute("InterpType", Integer.toString(this._seasonalPairedValues.getInterpolationType()));
                    XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getXArray());
                    for (int i = 0; i < this._seasonalPairedValues.getNumberCurves(); ++i) {
                        element2 = new org.jdom.Element("Parameter1");
                        element.addContent((Content)element2);
                        XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getCurve(i).getYArray());
                    }
                } else {
                    element.setAttribute("HasSeasonalVariation", Boolean.toString(this._seasonalPairedValues.hasSeasonalVariation()));
                    element.setAttribute("InterpType", Integer.toString(this._seasonalPairedValues.getInterpolationType()));
                    XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getXArray());
                    element2 = new org.jdom.Element("Parameter");
                    element.addContent((Content)element2);
                    XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getYArray());
                }
            } else if (this._independentVariable.getType() == 3 && !this._independentVariable.isTSOptChecked()) {
                element2 = new org.jdom.Element("TimeSeriesVariable");
                element.addContent((Content)element2);
                if (this._seasonalPairedValues.hasSeasonalVariation()) {
                    element.setAttribute("HasSeasonalVariation", Boolean.toString(this._seasonalPairedValues.hasSeasonalVariation()));
                    element.setAttribute("InterpType", Integer.toString(this._seasonalPairedValues.getInterpolationType()));
                    XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getXArray());
                    for (int i = 0; i < this._seasonalPairedValues.getNumberCurves(); ++i) {
                        element2 = new org.jdom.Element("Parameter1");
                        element.addContent((Content)element2);
                        XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getCurve(i).getYArray());
                    }
                } else {
                    element.setAttribute("InterpType", Integer.toString(this._seasonalPairedValues.getInterpolationType()));
                    XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getXArray());
                    element2 = new org.jdom.Element("Parameter");
                    element.addContent((Content)element2);
                    XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getYArray());
                }
            } else if (this._independentVariable.getType() == 4) {
                element2 = new org.jdom.Element("StateVariable");
                element.addContent((Content)element2);
                if (this._seasonalPairedValues.hasSeasonalVariation()) {
                    element.setAttribute("HasSeasonalVariation", Boolean.toString(this._seasonalPairedValues.hasSeasonalVariation()));
                    element.setAttribute("InterpType", Integer.toString(this._seasonalPairedValues.getInterpolationType()));
                    XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getXArray());
                    for (int i = 0; i < this._seasonalPairedValues.getNumberCurves(); ++i) {
                        element2 = new org.jdom.Element("Parameter1");
                        element.addContent((Content)element2);
                        XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getCurve(i).getYArray());
                    }
                } else {
                    element.setAttribute("InterpType", Integer.toString(this._seasonalPairedValues.getInterpolationType()));
                    XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getXArray());
                    element2 = new org.jdom.Element("Parameter");
                    element.addContent((Content)element2);
                    XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getYArray());
                }
            } else if (this._independentVariable.getType() == 6) {
                element2 = new org.jdom.Element("GlobalVariable");
                element.addContent((Content)element2);
                if (this._seasonalPairedValues.hasSeasonalVariation()) {
                    element.setAttribute("HasSeasonalVariation", Boolean.toString(this._seasonalPairedValues.hasSeasonalVariation()));
                    element.setAttribute("InterpType", Integer.toString(this._seasonalPairedValues.getInterpolationType()));
                    XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getXArray());
                    for (int i = 0; i < this._seasonalPairedValues.getNumberCurves(); ++i) {
                        element2 = new org.jdom.Element("Parameter1");
                        element.addContent((Content)element2);
                        XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getCurve(i).getYArray());
                    }
                } else {
                    element.setAttribute("InterpType", Integer.toString(this._seasonalPairedValues.getInterpolationType()));
                    XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getXArray());
                    element2 = new org.jdom.Element("Parameter");
                    element.addContent((Content)element2);
                    XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seasonalPairedValues.getYArray());
                }
            }
        }
        if (this._usePeriodAverageLimit) {
            element2 = new org.jdom.Element("Period_Average_Limit");
            element.addContent((Content)element2);
            element2.setAttribute("Period", Integer.toString(this.getPeriod()));
            element2.setAttribute("StartingDayOfPeriod", Integer.toString(this.getStartingDay()));
            element2 = new org.jdom.Element("Period_Average_Requirement_Pattern");
            this.getPatternContainer().outputReport(alternativeInputReport, element2);
        }
        super.outputReport(alternativeInputReport, element);
    }

    @Override
    public WaterAccount getWaterAccount() {
        return this.i;
    }

    @Override
    public void setWaterAccount(WaterAccount waterAccount) {
        this.i = waterAccount;
    }
}

