/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Vector;

public class ReleaseFunctionInflowOpRule
extends OpRule
implements AsciiSerializable,
Serializable {
    public static final String PARAMSTR_MAXRULE = "FLow-MaxRule";
    public static final String PARAMSTR_MINRULE = "FLow-MinRule";
    public static final int MIN = -1;
    public static final int MAX = 1;
    public static final int SPECIFIED = 0;
    protected PairedValues _releaseFunction = new PairedValues();
    protected boolean _ratioOfInflow = false;
    int _limitType = -1;
    private transient doubleArrayContainer a;

    public ReleaseFunctionInflowOpRule() {
    }

    public ReleaseFunctionInflowOpRule(String string) {
        super(string);
    }

    @Override
    public void updateTSProxyList() {
        if (this._limitType == -1) {
            TSRecordProxy tSRecordProxy = this.getTSRecordProxy(82);
            if (tSRecordProxy == null) {
                this.addTSRecordProxy(82);
                return;
            }
        } else if (this._limitType == 1) {
            TSRecordProxy tSRecordProxy = this.getTSRecordProxy(81);
            if (tSRecordProxy == null) {
                this.addTSRecordProxy(81);
                return;
            }
        } else {
            TSRecordProxy tSRecordProxy = this.getTSRecordProxy(80);
            if (tSRecordProxy == null) {
                this.addTSRecordProxy(80);
            }
        }
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if (n == 0) {
            if (this._limitType == -1) {
                TSRecordProxy tSRecordProxy = this.getTSRecordProxy(82);
                if (tSRecordProxy != null) {
                    vector.addElement(tSRecordProxy);
                }
            } else if (this._limitType == 1) {
                TSRecordProxy tSRecordProxy = this.getTSRecordProxy(81);
                if (tSRecordProxy != null) {
                    vector.addElement(tSRecordProxy);
                }
            } else {
                TSRecordProxy tSRecordProxy = this.getTSRecordProxy(80);
                if (tSRecordProxy != null) {
                    vector.addElement(tSRecordProxy);
                }
            }
        }
        return vector;
    }

    @Override
    public boolean initializeCompute() {
        this.a = null;
        if (!super.initializeCompute()) {
            return false;
        }
        this.a = this._limitType == -1 ? this.getTSContainer(82) : (this._limitType == 1 ? this.getTSContainer(81) : this.getTSContainer(80));
        if (this.a == null) {
            this._controller.getElementOp().getOperationsElement().getSystem().printErrorMessage("ReleaseFunctionInflowOpRule.initializeCompute: Failed to load time series arrays");
            return false;
        }
        return true;
    }

    @Override
    public OpValue evaluateRule(RunTimeStep runTimeStep, double d) {
        OpValue opValue = new OpValue();
        double d2 = this._controller.getElementOp().getOperationsElement().getStorageFunction().getNetInflow(runTimeStep);
        if (d2 == Double.NEGATIVE_INFINITY) {
            this._controller.getElementOp().getOperationsElement().getSystem().printErrorMessage("ReleaseFunctionInflowOpRule.evaluateRule: inflow undefined");
            opValue.type = 1;
            opValue.value = Double.NEGATIVE_INFINITY;
            return opValue;
        }
        if (this.getEnableRiseFallCondition() && !this.checkRisingFallingCondition(runTimeStep)) {
            return null;
        }
        this._releaseFunction.findInterval(d2);
        double d3 = this._releaseFunction.interpolate(d2);
        if (d3 == Double.NEGATIVE_INFINITY) {
            this._controller.getElementOp().getOperationsElement().getSystem().printErrorMessage("ReleaseFunctionInflowOpRule.evaluateRule: interpolated limit undefined");
            opValue.type = 1;
            opValue.value = Double.NEGATIVE_INFINITY;
            return opValue;
        }
        opValue.value = d3;
        opValue.type = this._limitType == 0 ? 1 : (this._limitType == 1 ? 2 : 0);
        return opValue;
    }

    @Override
    public Object clone() {
        ReleaseFunctionInflowOpRule releaseFunctionInflowOpRule = (ReleaseFunctionInflowOpRule)super.clone();
        ((ReleaseFunctionInflowOpRule)super.clone())._releaseFunction = (PairedValues)this._releaseFunction.clone();
        releaseFunctionInflowOpRule._ratioOfInflow = this._ratioOfInflow;
        return releaseFunctionInflowOpRule;
    }

    public PairedValues getReleaseFunction() {
        this._releaseFunction.setUnitSystem(this.getUnitSystem());
        this._releaseFunction.setParamXId(Parameter.PARAMID_FLOW);
        this._releaseFunction.setParamYId(-1);
        return this._releaseFunction;
    }

    public boolean getRatioInflow() {
        return this._ratioOfInflow;
    }

    public void setReleaseFunction(PairedValues pairedValues, boolean bl) {
        if (pairedValues == null) {
            return;
        }
        this._releaseFunction = pairedValues;
        this._ratioOfInflow = bl;
    }

    public void setInterpolationType(int n) {
        this._releaseFunction.setInterpolationType(n);
    }

    public int getInterpolationType() {
        return this._releaseFunction.getInterpolationType();
    }

    public int getLimitType() {
        return this._limitType;
    }

    public void setLimitType(int n) {
        if (n != -1 && n != 1 && n != 0) {
            return;
        }
        this._limitType = n;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

