/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.Identifier;
import hec.io.TimeSeriesContainer;
import hec.lang.Logger;
import hec.rss.model.AltOverride;
import hec.rss.model.ReleaseOverrides$Overrides;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;
import rma.util.RMASort;

public class ReleaseOverrides
implements AsciiSerializable,
AltInputReportInfc,
Serializable {
    private static final FluentLogger b = FluentLogger.forEnclosingClass();
    public static final String BEGIN_RELEASE_OVERRIDE = "ReleaseOverrideBegin";
    public static final String END_RELEASE_OVERRIDE = "ReleaseOverrideEnd";
    private transient int c = -1;
    private transient int d = -1;
    private transient int e = -1;
    private transient int f = 0;
    public static final int UNDEFINED_OVERRIDE = 0;
    public static final int OUTLET_RELEASE = 1;
    public static final int RESERVOIR_ELEVATION = 2;
    public static final int GATE_OPENING = 3;
    public static final int CAPACITY = 4;
    public static final int STORAGE = 5;
    public static final int ELEV_STORAGE = 6;
    public static final String OUTLET_RELEASE_STR = "FLOW-RELEASE OVERRIDE";
    public static final String RESERVOIR_ELEVATION_STR = "ELEV-RESERVOIR OVERRIDE";
    public static final String GATE_OPENING_STR = "LENGTH-GATE OVERRIDE";
    public static final String CAPACITY_STR = "CAPACITY-FACTOR OVERRIDE";
    public static final String STORAGE_STR = "STORAGE OVERRIDE";
    public static final String ELEV_STORAGE_STR = "ELEV-STORAGE OVERRIDE";
    public static final int OUTLET_RELEASE_PARAMID = Parameter.PARAMID_FLOW;
    public static final int RESERVOIR_ELEVATION_PARAMID = Parameter.PARAMID_ELEV;
    public static final int GATE_OPENING_PARAMID = Parameter.PARAMID_LENGTH;
    public static final int CAPACITY_PARAMID = -1;
    public static final int STORAGE_PARAMID = Parameter.PARAMID_STOR;
    public static final int ELEV_STORAGE_PARAMID = Parameter.PARAMID_ELEV;
    private static boolean g = Logger.canDebug((String)"ResSimOverrides");
    private static final int[] h = new int[]{-1, OUTLET_RELEASE_PARAMID, RESERVOIR_ELEVATION_PARAMID, GATE_OPENING_PARAMID, -1, STORAGE_PARAMID, ELEV_STORAGE_PARAMID};
    transient Hashtable<String, ReleaseOverrides$Overrides> a = new Hashtable();
    private transient Hashtable<String, String> i = new Hashtable();
    private transient RssRun j = null;
    private transient boolean k = false;

    public ReleaseOverrides() {
        this.initReleases(null);
    }

    public ReleaseOverrides(int n, int n2, int n3, String[] stringArray) {
        this.setReleaseTimes(n, n2, n3);
        this.initReleases(stringArray);
    }

    public void setDssPathTable(Hashtable hashtable) {
        this.i = hashtable;
    }

    public Hashtable getDssPathTable() {
        return this.i;
    }

    public void setReleaseTimes(int n, int n2, int n3) {
        this.c = n;
        this.d = n2;
        this.e = n3;
        if (!this.a.isEmpty()) {
            Hashtable hashtable = new Hashtable();
            Enumeration<String> enumeration = this.a.keys();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable2;
                String string = enumeration.nextElement();
                Object object = this.a.get(string);
                if (object == null || !(object instanceof ReleaseOverrides$Overrides) || (hashtable2 = ((ReleaseOverrides$Overrides)object).b) == null) continue;
                Hashtable<Integer, Object> hashtable3 = new Hashtable<Integer, Object>();
                Enumeration enumeration2 = hashtable2.keys();
                while (enumeration2.hasMoreElements()) {
                    Integer n4 = (Integer)enumeration2.nextElement();
                    object = (Double)hashtable2.get(n4);
                    hashtable3.put(n4, object);
                }
                hashtable.put(string, hashtable3);
            }
            this.a = hashtable;
        }
    }

    public void setReplaceAll(boolean bl) {
        this.j.getAlternative().setReplaceAll(bl);
    }

    public void setOverrideOutletsForThisReservoir(boolean bl, String object) {
        object = this.j.getAlternative().getSystem().findReservoir((String)object);
        if (object != null) {
            ((ReservoirElement)object).setUseOverridesForThisReservoir(bl);
        }
    }

    public boolean isOverrideOutletsForThisReservoir(String object) {
        object = this.j.getAlternative().getSystem().findReservoir((String)object);
        if (object != null) {
            return ((ReservoirElement)object).useOverridesForThisReservoir();
        }
        return false;
    }

    public boolean replaceAllWithOtherAlt() {
        return this.j.getAlternative().replaceAllReleaseOverrides();
    }

    public void initReleases(String[] stringArray) {
        this.a.clear();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            ReleaseOverrides$Overrides releaseOverrides$Overrides = new ReleaseOverrides$Overrides(this);
            this.a.put(stringArray[i], releaseOverrides$Overrides);
        }
    }

    public void updateReleases(String[] stringArray, int n) {
        this.f = n;
        this.updateReleases(stringArray);
    }

    public boolean updateAltData() {
        Enumeration<String> enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!this.useOtherAltResults(string)) continue;
            this.a.get(string);
            String string2 = this.getUseOtherAltName(string);
            new Identifier(string2);
            try {
                String string3;
                RssRun rssRun = (RssRun)this.j.getAlternative().getProxyList().loadManagerByName(RssRun.class.getName(), string2);
                if (rssRun == null) {
                    this.j.printErrorMessage("The Alternative Run: " + string2 + " used in the Release Override for: " + this.j.getNetwork().getNameForKeyString(string) + " is not in this Simulation or needs to be computed.");
                    return false;
                }
                String string4 = rssRun.getOutputFPart();
                if (this.getUseOtherAltCollectionSequence(string) != null && this.getUseOtherAltCollectionSequence(string).length() > 0) {
                    string3 = new DSSPathname();
                    string3.setFPart(string4);
                    string3.setCollectionSequence(this.getUseOtherAltCollectionSequence(string));
                    rssRun.setOutputFPart(string3.getFPart());
                }
                if (rssRun.getDSSOutputFile() == null) {
                    this.j.printErrorMessage("The Alternative Run: " + string2 + " used in the Release Override for: " + this.j.getNetwork().getNameForKeyString(string) + " needs to be computed.");
                    return false;
                }
                string3 = rssRun.getDSSOutputFile();
                Vector vector = rssRun.getNetwork().getFlowContolTSRecordProxies();
                if (vector != null && vector.size() > 0) {
                    for (int i = 0; i < vector.size(); ++i) {
                        Object object = (TSRecordProxy)vector.elementAt(i);
                        if (!object.getName().equals(string)) continue;
                        object = rssRun.constructTSRecordProxyDssPath((TSRecordProxy)object, "-REG");
                        Object object2 = new DSSIdentifier();
                        object2.setDSSPath((String)object);
                        object2.setFileName(string3);
                        object2.setTimeWindow(this.j.getRunTimeWindow().getStartTime(), this.j.getRunTimeWindow().getEndTime());
                        try {
                            object = rssRun.getDSSFileManager().readTS((DSSIdentifier)object2, true);
                            object2 = new Hashtable();
                            for (int j = 0; j < this.e; ++j) {
                                if (j >= object.times.length) continue;
                                ((Hashtable)object2).put(new Integer(object.times[j]), new Double(object.values[j]));
                            }
                            this.setReleaseValues(string, (Hashtable)object2, true, rssRun.getName(), this.getUseOtherAltCollectionSequence(string));
                            continue;
                        }
                        catch (Exception exception) {
                            Exception exception2 = exception;
                            exception.printStackTrace();
                        }
                    }
                }
                rssRun.setOutputFPart(string4);
            }
            catch (RemoteException remoteException) {
                this.j.printErrorMessage("The Alternative Run: " + string2 + " used in the Release Override for: " + this.j.getNetwork().getNameForKeyString(string) + " can not referenced.");
                return false;
            }
        }
        return true;
    }

    public void updateReleases(String[] stringArray) {
        Object object;
        if (stringArray == null) {
            this.initReleases(null);
        }
        Hashtable<String, ReleaseOverrides$Overrides> hashtable = new Hashtable<String, ReleaseOverrides$Overrides>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            object = this.a.get(stringArray[i]);
            ReleaseOverrides$Overrides releaseOverrides$Overrides = null;
            if (object != null && object instanceof ReleaseOverrides$Overrides) {
                releaseOverrides$Overrides = (ReleaseOverrides$Overrides)object;
            }
            if (releaseOverrides$Overrides == null) {
                releaseOverrides$Overrides = new ReleaseOverrides$Overrides(this);
            }
            hashtable.put(stringArray[i], releaseOverrides$Overrides);
        }
        this.a.clear();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            this.a.put((String)object, (ReleaseOverrides$Overrides)hashtable.get(object));
        }
    }

    public int getArraySize() {
        if (this.c == -1) {
            return 0;
        }
        return this.e;
    }

    public int getStartTime() {
        return this.c;
    }

    public int getTimeStep() {
        return this.d;
    }

    public int getNumberOfSteps() {
        return this.e;
    }

    public void setOverridesType(int n) {
        this.f = n;
    }

    public int getOverridesType() {
        return this.f;
    }

    public static int a(int n) {
        return ReleaseOverrides.b(n);
    }

    public static int b(int n) {
        if (n > 0 || n < h.length) {
            return 0;
        }
        return h[n];
    }

    public String[] getReleaseNames() {
        String[] stringArray = new String[this.a.size()];
        int n = 0;
        Enumeration<String> enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n] = enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String getReleaseDssPath(String string) {
        return this.i.get(string);
    }

    public boolean useOtherAltResults(String string) {
        return this.j.getAlternative().useOtherAltResults(string);
    }

    public void setUseOtherAlt(boolean bl, String string) {
        this.j.getAlternative().setUseOtherAltResults(bl, string);
    }

    public String getUseOtherAltName(String string) {
        return this.j.getAlternative().getUseOtherAltName(string);
    }

    public String getUseOtherAltCollectionSequence(String string) {
        return this.j.getAlternative().getUseOtherAltCollectionSequence(string);
    }

    public Hashtable getReleaseValues(String string) {
        ReleaseOverrides$Overrides releaseOverrides$Overrides = this.a.get(string);
        if (releaseOverrides$Overrides == null || !(releaseOverrides$Overrides instanceof ReleaseOverrides$Overrides)) {
            return null;
        }
        if (this.j != null) {
            this.getDssIdentifier(string);
        }
        if (releaseOverrides$Overrides.b == null && !releaseOverrides$Overrides.a) {
            releaseOverrides$Overrides = this.readOverridesFromDss(string);
            if (releaseOverrides$Overrides == null) {
                return null;
            }
            this.a.put(string, releaseOverrides$Overrides);
        }
        return releaseOverrides$Overrides.b;
    }

    public void setReleaseValues(String string, Hashtable hashtable) {
        this.setReleaseValues(string, hashtable, false, null, null);
    }

    public void setReleaseValues(String string, Hashtable object, boolean bl, String string2, String string3) {
        if (object == null || string == null) {
            return;
        }
        ReleaseOverrides$Overrides releaseOverrides$Overrides = this.a.get(string);
        if (releaseOverrides$Overrides == null || !(releaseOverrides$Overrides instanceof ReleaseOverrides$Overrides)) {
            releaseOverrides$Overrides = new ReleaseOverrides$Overrides(this);
        }
        releaseOverrides$Overrides.b = object;
        releaseOverrides$Overrides.a(true);
        object = new AltOverride(bl, string2, string3);
        this.j.getAlternative().setReleaseOverridesAlt(string, (AltOverride)object);
        this.a.put(string, releaseOverrides$Overrides);
    }

    public void clearUserOtherAltOverrides() {
        this.j.getAlternative().clearUserOtherAltOverrides();
    }

    public void setRun(RssRun rssRun) {
        this.j = rssRun;
    }

    public void setForceWrite(boolean bl) {
        this.k = bl;
    }

    public void storeOverrides() {
        if (this.j == null || this.a == null) {
            this.k = false;
            return;
        }
        RssSystem rssSystem = this.j.getAlternative().getSystem();
        Object object = this.j.getIdentifier().getPath();
        int n = ((String)object).lastIndexOf(".");
        object = ((String)object).substring(0, n) + ".dss";
        DSSPathname dSSPathname = new DSSPathname();
        dSSPathname.setAPart("");
        new Hashtable();
        Enumeration<String> enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Object object2 = this.a.get(string);
            if (object2 == null || !(object2 instanceof ReleaseOverrides$Overrides) || !((ReleaseOverrides$Overrides)object2).a() && !this.k || (object2 = ((ReleaseOverrides$Overrides)object2).b) == null) continue;
            int n2 = ((Hashtable)object2).size();
            Object object3 = new int[n2];
            double[] dArray = new double[n2];
            TimeSeriesContainer timeSeriesContainer = new Double[n2];
            int n3 = 0;
            HecTime hecTime = ((Hashtable)object2).keys();
            while (hecTime.hasMoreElements()) {
                Integer n4 = (Integer)hecTime.nextElement();
                Double d = (Double)((Hashtable)object2).get(n4);
                timeSeriesContainer[n3] = d;
                object3[n3] = n4;
                ++n3;
            }
            RMASort.quickSort((int[])object3, (Object[])timeSeriesContainer);
            for (int i = 0; i < ((int[])object3).length; ++i) {
                dArray[i] = (Double)timeSeriesContainer[i];
            }
            hecTime = this.j.getRunTimeWindow().getStartTime();
            object2 = this.j.getRunTimeWindow().getEndTime();
            n2 = 1;
            int n5 = 2 + ((int[])object3).length;
            if (((int[])object3).length > 0) {
                if (object3[0] == hecTime.value()) {
                    n2 = 0;
                    --n5;
                }
                if (object3[((int[])object3).length - 1] == object2.value()) {
                    --n5;
                }
            }
            timeSeriesContainer = new TimeSeriesContainer();
            new TimeSeriesContainer().times = new int[n5];
            timeSeriesContainer.values = new double[n5];
            System.arraycopy(object3, 0, timeSeriesContainer.times, n2, ((int[])object3).length);
            System.arraycopy(dArray, 0, timeSeriesContainer.values, n2, ((int[])object3).length);
            timeSeriesContainer.times[0] = hecTime.value();
            timeSeriesContainer.times[timeSeriesContainer.times.length - 1] = object2.value();
            if (((int[])object3).length <= 0 || object3[0] != hecTime.value()) {
                timeSeriesContainer.values[0] = -3.4028234663852886E38;
            }
            if (((int[])object3).length <= 0 || object3[((int[])object3).length - 1] != object2.value()) {
                timeSeriesContainer.values[timeSeriesContainer.times.length - 1] = -3.4028234663852886E38;
            }
            n2 = this.getParamId();
            Parameter.getParamString((int)n2);
            object3 = this.getCPart(n2);
            dSSPathname.setCPart((String)object3);
            string = rssSystem.getNameForKeyString(string);
            dSSPathname.setBPart(string);
            dSSPathname.setEPart("IR-MONTH");
            string = dSSPathname.getPathname();
            object3 = Parameter.getUnitsStringForSystem((int)n2, (int)this.j.getUnitSystem());
            string = new DSSIdentifier((String)object, string);
            string.setTimeWindow(hecTime, (HecTime)object2);
            timeSeriesContainer.fullName = string.getDSSPath();
            timeSeriesContainer.fileName = string.getFileName();
            timeSeriesContainer.units = object3;
            timeSeriesContainer.interval = 0;
            timeSeriesContainer.quality = null;
            timeSeriesContainer.numberValues = n5;
            timeSeriesContainer.startTime = hecTime.value();
            timeSeriesContainer.endTime = object2.value();
            timeSeriesContainer.parameter = Parameter.getParamString((int)n2);
            try {
                string = this.j.getDSSFileManager();
                int n6 = string.write((DataContainer)timeSeriesContainer);
                if (n6 != 0) {
                    System.out.println("storeOverrides:error writing overrides to " + timeSeriesContainer.fileName + ":" + timeSeriesContainer.fullName + " Error:" + n6);
                    continue;
                }
                System.out.println("storeOverrides:successfully wrote overrides to " + timeSeriesContainer.fileName + ":" + timeSeriesContainer.fullName);
            }
            catch (IOException iOException) {
                System.out.println("ERROR");
                System.out.println("storeOverrides():Error writing file in ReleaseOverrides. " + iOException.toString());
            }
        }
        this.k = false;
    }

    private String getCPart(int n) {
        if (this.f == 1) {
            return OUTLET_RELEASE_STR;
        }
        if (this.f == 2) {
            return RESERVOIR_ELEVATION_STR;
        }
        if (this.f == 3) {
            return GATE_OPENING_STR;
        }
        if (this.f == 4) {
            return CAPACITY_STR;
        }
        if (this.f == 5) {
            return STORAGE_STR;
        }
        if (this.f == 6) {
            return ELEV_STORAGE_STR;
        }
        return Parameter.getParamString((int)n);
    }

    private int getParamId() {
        if (this.f == 1) {
            return OUTLET_RELEASE_PARAMID;
        }
        if (this.f == 2) {
            return RESERVOIR_ELEVATION_PARAMID;
        }
        if (this.f == 3) {
            return GATE_OPENING_PARAMID;
        }
        if (this.f == 4) {
            return -1;
        }
        if (this.f == 5) {
            return STORAGE_PARAMID;
        }
        if (this.f == 6) {
            return ELEV_STORAGE_PARAMID;
        }
        return -1;
    }

    private DSSIdentifier getDssIdentifier(String string) {
        if (this.j == null) {
            System.out.println("ERROR");
            System.out.println("getDssIdentifier(): RssRun is null. ");
            return null;
        }
        if (this.j.getAlternative().getSystem() == null) {
            System.out.println("ERROR");
            System.out.println("getDssIdentifier(): RssSystem is null. ");
            return null;
        }
        RssSystem rssSystem = this.j.getAlternative().getSystem();
        Object object = this.j.getIdentifier().getPath();
        int n = ((String)object).lastIndexOf(".");
        object = ((String)object).substring(0, n) + ".dss";
        DSSPathname dSSPathname = new DSSPathname();
        dSSPathname.setAPart("");
        int n2 = this.getParamId();
        Parameter.getParamString((int)n2);
        String string2 = this.getCPart(n2);
        dSSPathname.setCPart(string2);
        string = rssSystem.getNameForKeyString(string);
        dSSPathname.setBPart(string);
        dSSPathname.setEPart("IR-MONTH");
        dSSPathname.setFPart(" ");
        string = dSSPathname.getPathname();
        string = new DSSIdentifier((String)object, string);
        rssSystem = this.j.getRunTimeWindow().getStartTime();
        object = this.j.getRunTimeWindow().getEndTime();
        string.setTimeWindow((HecTime)rssSystem, (HecTime)object);
        return string;
    }

    private ReleaseOverrides$Overrides readOverridesFromDss(String string) {
        Object object;
        if (this.j == null) {
            System.out.println("ERROR");
            System.out.println("readOverridesFromDss(): RssRun is null. ");
            return null;
        }
        if (this.j.getAlternative().getSystem() == null) {
            System.out.println("ERROR");
            System.out.println("readOverridesFromDss(): RssSystem is null. ");
            return null;
        }
        this.j.getAlternative().getSystem();
        TimeSeriesContainer timeSeriesContainer = null;
        DSSIdentifier dSSIdentifier = this.getDssIdentifier(string);
        try {
            if (!this.j.getFileManager().fileExists(dSSIdentifier.getFileName())) {
                ReleaseOverrides$Overrides releaseOverrides$Overrides = new ReleaseOverrides$Overrides(this);
                new ReleaseOverrides$Overrides(this).a = true;
                if (g) {
                    System.out.println("NOTE");
                    System.out.println("readOverridesFromDss: No DSS File Found for " + dSSIdentifier.toString());
                }
                return releaseOverrides$Overrides;
            }
        }
        catch (IOException iOException) {
            System.out.println("WARNING");
            System.out.println("readOverridesFromDss():No DSS file for ReleaseOverrides. " + iOException.toString());
        }
        try {
            object = this.j.getDSSFileManager();
            timeSeriesContainer = object.readTS(dSSIdentifier, false);
        }
        catch (IOException iOException) {
            ((FluentLogger.Api)b.atWarning()).log("readOverridesFromDss():Error reading file in ReleaseOverrides. %s ", (Object)iOException.toString());
        }
        object = this.parseDssRecordIntoOverrides(string, timeSeriesContainer, dSSIdentifier);
        return object;
    }

    private ReleaseOverrides$Overrides parseDssRecordIntoOverrides(String hashtable, TimeSeriesContainer object, DSSIdentifier object2) {
        if (object == null || object.times == null || object.values == null || object.numberValues <= 0) {
            hashtable = new ReleaseOverrides$Overrides(this);
            new ReleaseOverrides$Overrides(this).a = true;
            if (g) {
                ((FluentLogger.Api)b.atInfo()).log("parseDssRecordIntoOverrides: No Data Found for %s", (Object)object2.toString());
            }
            return hashtable;
        }
        hashtable = new Hashtable<TimeSeriesContainer, DSSIdentifier>();
        int[] nArray = object.times;
        double[] dArray = object.values;
        if (g) {
            ((FluentLogger.Api)b.atInfo()).log("parseDssRecordIntoOverrides: Reading the following ReleaseOverrides DSS file: %s", (Object)object2.toString());
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (dArray[i] != -3.4028234663852886E38) {
                object = new Integer(nArray[i]);
                object2 = new Double(dArray[i]);
                hashtable.put((TimeSeriesContainer)object, (DSSIdentifier)object2);
            }
            if (!g) continue;
            ((FluentLogger.Api)b.atInfo()).log("parseDssRecordIntoOverrides: values[%d]= ", (Object)dArray[i]);
        }
        ReleaseOverrides$Overrides releaseOverrides$Overrides = new ReleaseOverrides$Overrides(this, hashtable);
        new ReleaseOverrides$Overrides(this, hashtable).a = false;
        return releaseOverrides$Overrides;
    }

    public boolean isModified() {
        Enumeration<ReleaseOverrides$Overrides> enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            ReleaseOverrides$Overrides releaseOverrides$Overrides = enumeration.nextElement();
            if (releaseOverrides$Overrides == null || !(releaseOverrides$Overrides instanceof ReleaseOverrides$Overrides) || !releaseOverrides$Overrides.a()) continue;
            return true;
        }
        return false;
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        this.outputReport(alternativeInputReport, element, null);
    }

    public void outputReport(AlternativeInputReport alternativeInputReport, Element element, RssSystem rssSystem) {
        ReleaseOverrides releaseOverrides = this;
        element.setAttribute("Override_Type", releaseOverrides.getCPart(releaseOverrides.f));
        Enumeration<String> enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray;
            Element element2 = enumeration.nextElement();
            Object object = this.a.get(element2);
            if (object == null || !(object instanceof ReleaseOverrides$Overrides) || (objectArray = object) == null || objectArray.a) continue;
            alternativeInputReport = new Element("Override");
            element.addContent((Content)alternativeInputReport);
            if (rssSystem == null) {
                alternativeInputReport.setAttribute("Name", (String)element2);
            } else {
                alternativeInputReport.setAttribute("Name", rssSystem.getNameForKeyString((String)element2));
            }
            element2 = objectArray.b.keySet().toArray();
            objectArray = objectArray.b.values().toArray();
            String[] stringArray = new String[((Object[])element2).length];
            double[] dArray = new double[objectArray.length];
            for (int i = 0; i < ((Object[])element2).length; ++i) {
                object = element2[i];
                HecTime hecTime = new HecTime();
                hecTime.set(((Integer)object).intValue());
                stringArray[i] = hecTime.dateAndTime();
                Object cfr_ignored_0 = objectArray[i];
                dArray[i] = (Double)objectArray[i];
            }
            element2 = new Element("Times");
            alternativeInputReport.addContent((Content)element2);
            XMLUtilities.createArrayElements((Element)element2, (String[])stringArray);
            element2 = new Element("Values");
            alternativeInputReport.addContent((Content)element2);
            XMLUtilities.createArrayElements((Element)element2, (double[])dArray);
        }
    }
}

