/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.model.RunTimeStep;
import hec.model.SeasonalValue;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.Controller;
import hec.rss.model.Element;
import hec.rss.model.OpController;
import hec.rss.model.Rule;
import hec.rss.model.Storage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import rma.util.RMAIO;
import rma.util.rmaTokenizer;

public class ResGuideCurve
extends Rule {
    SeasonalValue _elevValues = new SeasonalValue();
    String _reservoirName = "";
    private transient Storage b = null;
    double _oldinflow = Double.NEGATIVE_INFINITY;

    public ResGuideCurve() {
    }

    @Deprecated
    public ResGuideCurve(Controller controller) {
        super(controller);
    }

    public ResGuideCurve(OpController opController) {
        super(opController);
    }

    public void removeAllElevValues() {
        this._elevValues = new SeasonalValue();
    }

    public String getElevValues() {
        if (this._elevValues == null) {
            return null;
        }
        return this._elevValues.toString();
    }

    public void setElevValues(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this._elevValues.parseString(string);
    }

    public void setReservoirName(String string) {
        this._reservoirName = string;
    }

    @Override
    public boolean initialize() {
        this.b = null;
        this._oldinflow = Double.NEGATIVE_INFINITY;
        return true;
    }

    @Override
    public double getValue(AdjustableParameter adjustableParameter, RunTimeStep runTimeStep, double d) {
        Element element;
        if (this.b == null && (element = this.controller.findElement(this._reservoirName)) != null) {
            this.b = (Storage)element.getFunction();
        }
        if (this.b == null) {
            return d;
        }
        double d2 = this._elevValues.interpolateValue(runTimeStep);
        double d3 = this.b.elevationToStorage(d2);
        double d4 = this.b.getNetInflow(runTimeStep);
        double d5 = this.b.getStorage(runTimeStep);
        double d6 = runTimeStep.getTimeStepSeconds();
        double d7 = adjustableParameter.getMaxRateOfIncrease();
        double d8 = adjustableParameter.getMaxRateOfDecrease();
        double d9 = adjustableParameter.getCurrentValue();
        double d10 = adjustableParameter.getMinValue();
        double d11 = adjustableParameter.getMaxValue();
        double d12 = this._oldinflow != Double.NEGATIVE_INFINITY ? d4 * 2.0 - this._oldinflow : d4;
        double d13 = (d5 - d3) / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q + d4;
        if (d5 > d3 && d9 > d12) {
            double d14;
            double d15;
            double d16 = d5 - (d9 - d12) * (d9 - d12) / (d7 * 2.0);
            if (d15 <= d3 && d5 + d12 - (d13 = (d14 = Math.sqrt((d5 - d3) * 2.0 * d8)) + d12) * d6 / 43560.0 < d3) {
                d13 = (d5 - d3) / d6 * 43560.0 + d12;
            }
        } else if (d5 < d3 && d9 < d12) {
            double d17;
            double d18;
            double d19 = d5 - (d9 - d12) * (d9 - d12) / (d8 * 2.0);
            if (d18 >= d3 && d5 + d12 - (d13 = (d17 = Math.sqrt((d3 - d5) * 2.0 * d7)) + d12) * d6 / 43560.0 > d3) {
                d13 = (d3 - d5) / d6 * 43560.0 - d12;
            }
        }
        if (d13 < d10) {
            d13 = d10;
        } else if (d13 > d11) {
            d13 = d11;
        }
        this._oldinflow = d4;
        return d13;
    }

    public SeasonalValue getSeasonalElev() {
        return this._elevValues;
    }

    public void setSeasonalElev(SeasonalValue seasonalValue) {
        this._elevValues = seasonalValue;
    }

    @Override
    public boolean writeData(BufferedWriter bufferedWriter) {
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"Controller Rule=ResGuideCurve");
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller ResGuideCurve Name=" + this.getName()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller ResGuideCurve Reservoir=" + this._reservoirName));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller ResGuideCurve Elev=" + this._elevValues.toString()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller ResGuideCurve TS=" + this.tsLocationType + ", " + this.tsLocationName + ", " + this.tsLocationParam));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"Controller ResGuideCurve End");
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        return true;
    }

    @Override
    public boolean readData(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() == 0) {
                    string = bufferedReader.readLine();
                    continue;
                }
                if (string.indexOf("Controller ResGuideCurve") < 0) break;
                String string2 = RMAIO.getType((String)string, (String)"=");
                string = RMAIO.getParam((String)string, (String)"=");
                if (string2.compareTo("Controller ResGuideCurve Name") == 0) {
                    this.setName(string);
                } else if (string2.compareTo("Controller ResGuideCurve Reservoir") == 0) {
                    this._reservoirName = string;
                } else if (string2.compareTo("Controller ResGuideCurve TS") == 0) {
                    string = new rmaTokenizer(string, ",");
                    try {
                        this.tsLocationType = string.nextToken().trim();
                        this.tsLocationName = string.nextToken().trim();
                        this.tsLocationParam = string.nextToken().trim();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                } else if (string2.compareTo("Controller ResGuideCurve Elev") == 0) {
                    this._elevValues.parseString(string);
                } else if (string2.compareTo("Controller ResGuideCurve End") == 0) break;
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

