/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.HecTime;
import hec.heclib.util.intContainer;
import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.rss.model.OpSet;
import hec.rss.model.OpSetRef;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.SystemOpRule;
import hec.rss.model.SystemReservoirStorage;
import hec.rss.model.SystemStorageDefinition;
import hec.rss.model.SystemStorageZone;
import hec.rss.model.ZoneBounds;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;
import rma.util.RMAConst;

public class ResSystemOpSet
extends NamedType
implements AsciiSerializable,
AltInputReportInfc,
Serializable {
    private Hashtable _operationSetRefs = null;
    private Hashtable _systemStorageZones = null;
    private int _nextStorageZoneId = 1;
    private int _nextOpSetRefId = 1;
    private transient ReservoirSysOp a = null;

    public ResSystemOpSet() {
        this._systemStorageZones = new Hashtable();
        this._operationSetRefs = new Hashtable();
    }

    public ResSystemOpSet(int n, String string, String string2) {
        this.setIndex(n);
        this.setName(string);
        this.setDescription(string2);
        this._systemStorageZones = new Hashtable();
        this._operationSetRefs = new Hashtable();
    }

    public double getSysZoneStorage(HecTime hecTime, int n) {
        if (this.a == null) {
            return Double.NEGATIVE_INFINITY;
        }
        int[] nArray = this.a.getReservoirIDs();
        if (nArray == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            double d2 = this.getResZoneStorage(hecTime, n, nArray[i]);
            if (!RMAConst.isValidValue((double)d2)) continue;
            d += d2;
        }
        return d;
    }

    public double getResZoneStorage(HecTime object, int n, int n2) {
        NamedType namedType = this.getStorageZone(n);
        if (namedType == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if ((namedType = namedType.getStorageZoneBounds(n2)) == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if ((namedType = namedType.getUpperBound()) == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = namedType.getInterpolateElev((HecTime)object);
        object = this.getReservoir(n2);
        if (object == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return ((ReservoirElement)object).getStorageFunction().elevationToStorage(d);
    }

    public double getMaxSystemStorage() {
        if (this.a == null) {
            return Double.NEGATIVE_INFINITY;
        }
        int[] nArray = this.a.getReservoirIDs();
        if (nArray == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            double d2 = this.getMaxReservoirStorage(nArray[i]);
            if (!RMAConst.isValidValue((double)d2)) continue;
            d += d2;
        }
        return d;
    }

    public double getMaxReservoirStorage(int n) {
        ReservoirElement reservoirElement = this.getReservoir(n);
        if (reservoirElement == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return reservoirElement.getStorageFunction().getMaxStorage();
    }

    public SystemStorageDefinition getSystemStorageDefinition() {
        if (this.a == null) {
            return null;
        }
        Object object = this.a.getReservoirIDs();
        ReservoirElement[] reservoirElementArray = new ReservoirElement[((int[])object).length];
        int n = ((int[])object).length;
        for (int i = 0; i < n; ++i) {
            reservoirElementArray[i] = this.getReservoir(object[i]);
        }
        SystemStorageDefinition systemStorageDefinition = this.a.getZoneSystemDefinition(this, reservoirElementArray);
        object = systemStorageDefinition;
        return systemStorageDefinition;
    }

    public double[][] getResStoragePattern(HecTime hecTime) {
        int n;
        if (this.a == null) {
            return null;
        }
        Object object = this.a.getReservoirIDs();
        ReservoirElement[] reservoirElementArray = new ReservoirElement[((int[])object).length];
        int n2 = ((int[])object).length;
        for (n = 0; n < n2; ++n) {
            reservoirElementArray[n] = this.getReservoir(object[n]);
        }
        SystemStorageDefinition systemStorageDefinition = this.a.getZoneSystemDefinition(this, reservoirElementArray);
        object = systemStorageDefinition;
        double[][] dArray = systemStorageDefinition.b();
        int n3 = 0;
        int n4 = 0;
        SystemStorageZone[] systemStorageZoneArray = ((SystemStorageDefinition)object).d();
        int[] nArray = ((SystemStorageDefinition)object).e();
        for (int i = 0; i < systemStorageZoneArray.length; ++i) {
            n4 += nArray[i];
            for (n = 0; n < n2; ++n) {
                Object object2 = reservoirElementArray[n];
                Storage storage = ((ReservoirElement)object2).getStorageFunction();
                NamedType namedType = systemStorageZoneArray[i].getStorageZoneBounds(object2.getIndex());
                if (namedType == null || (namedType = namedType.getUpperBound()) == null) continue;
                double d = namedType.getInterpolateElev(hecTime);
                dArray[n3 + nArray[i]][n] = storage.elevationToStorage(d);
                object2 = systemStorageZoneArray[i].getSystemStorage(object2.getIndex());
                object2 = ((SystemReservoirStorage)object2).getStorageValues();
                int n5 = Math.min(nArray[i], ((Object)object2).length);
                for (int j = 1; j < n5; ++j) {
                    dArray[n3 + nArray[i] - j][n] = dArray[n3][n] + object2[j] / 100.0 * (dArray[n3 + nArray[i]][n] - dArray[n3][n]);
                }
            }
            n3 += nArray[i];
        }
        for (int i = 0; i < n4 + 2; ++i) {
            dArray[i][n2] = 0.0;
            for (n = 0; n < n2; ++n) {
                double[] dArray2 = dArray[i];
                int n6 = n2;
                dArray2[n6] = dArray2[n6] + dArray[i][n];
            }
        }
        return dArray;
    }

    public void setParent(ReservoirSysOp reservoirSysOp) {
        this.a = reservoirSysOp;
    }

    public ReservoirSysOp getReservoirSystemOp() {
        return this.a;
    }

    public ReservoirElement getReservoir(int n) {
        if (this.a == null) {
            return null;
        }
        return this.a.getReservoirById(n);
    }

    public Object clone() {
        try {
            Object object;
            ResSystemOpSet resSystemOpSet = (ResSystemOpSet)super.clone();
            ((ResSystemOpSet)super.clone()).a = this.a;
            resSystemOpSet._nextOpSetRefId = this._nextOpSetRefId;
            resSystemOpSet._nextStorageZoneId = this._nextStorageZoneId;
            Object object2 = this._operationSetRefs.elements();
            resSystemOpSet._operationSetRefs = new Hashtable();
            while (object2.hasMoreElements()) {
                object = (OpSetRef)((OpSetRef)object2.nextElement()).clone();
                if (object == null) continue;
                ((OpSetRef)object).setParent(resSystemOpSet);
                resSystemOpSet._operationSetRefs.put(new intContainer(object.getIndex()), object);
            }
            object = this._systemStorageZones.elements();
            resSystemOpSet._systemStorageZones = new Hashtable();
            while (object.hasMoreElements()) {
                object2 = (SystemStorageZone)((SystemStorageZone)object.nextElement()).clone();
                if (object2 == null) continue;
                ((SystemStorageZone)object2).setParent(resSystemOpSet);
                resSystemOpSet._systemStorageZones.put(new intContainer(object2.getIndex()), object2);
            }
            return resSystemOpSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("Clone Error when cloning ResSystemOpSet" + this.getName());
            System.out.println(cloneNotSupportedException.getMessage());
            return null;
        }
    }

    public void copySystemStorageZones(ResSystemOpSet object) {
        if (object == null) {
            return;
        }
        object = ((ResSystemOpSet)object)._systemStorageZones.elements();
        while (object.hasMoreElements()) {
            SystemStorageZone systemStorageZone = (SystemStorageZone)object.nextElement();
            if (this._nextStorageZoneId <= systemStorageZone.getIndex()) {
                this._nextStorageZoneId = systemStorageZone.getIndex() + 1;
            }
            this._systemStorageZones.put(new intContainer(systemStorageZone.getIndex()), systemStorageZone);
        }
    }

    public void deleteSystemStorageZone(int n) {
        intContainer intContainer2 = new intContainer(n);
        this._systemStorageZones.remove(intContainer2);
    }

    public SystemStorageZone addNewSystemStorageZone(String object, String object2) {
        if (object == null || ((String)object).trim().equals("") || object2 == null) {
            return null;
        }
        int n = this.getNextStorageZoneIndex();
        object = new SystemStorageZone(n, (String)object, (String)object2);
        ((SystemStorageZone)object).setParent(this);
        object2 = this.a.getReservoirIDs();
        for (int i = 0; i < ((Object)object2).length; ++i) {
            ReservoirElement reservoirElement = this.a.getReservoirById((int)object2[i]);
            NamedType namedType = this.getOpSetReferences(reservoirElement);
            if (namedType == null) continue;
            Object object3 = namedType.getOpSet();
            object3 = ((OpSet)object3).getZoneVector();
            object3 = (StorageZone)((Vector)object3).get(0);
            ((SystemStorageZone)object).addStorageZoneBounds(reservoirElement, new ZoneBounds(reservoirElement.getIndex(), namedType.getOpSetID(), (StorageZone)object3, null));
            namedType = new SystemReservoirStorage();
            ((SystemReservoirStorage)namedType).addStorageValue(100.0);
            ((SystemStorageZone)object).addSystemReservoirStorage(reservoirElement, (SystemReservoirStorage)namedType);
        }
        this._systemStorageZones.put(new intContainer(n), object);
        return object;
    }

    public SystemStorageZone getStorageZone(int n) {
        SystemStorageZone systemStorageZone = (SystemStorageZone)this._systemStorageZones.get(new intContainer(n));
        systemStorageZone.setParent(this);
        return systemStorageZone;
    }

    public SystemStorageZone getStorageZone(String string) {
        if (string == null) {
            return null;
        }
        Enumeration enumeration = this._systemStorageZones.elements();
        while (enumeration.hasMoreElements()) {
            SystemStorageZone systemStorageZone = (SystemStorageZone)enumeration.nextElement();
            if (!systemStorageZone.getName().equalsIgnoreCase(string)) continue;
            systemStorageZone.setParent(this);
            return systemStorageZone;
        }
        return null;
    }

    public int[] getStorageZoneIDs() {
        int[] nArray = new int[this._systemStorageZones.size()];
        Enumeration enumeration = this._systemStorageZones.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            intContainer intContainer2 = (intContainer)enumeration.nextElement();
            nArray[n] = intContainer2.value;
            ++n;
        }
        return nArray;
    }

    public boolean doesStorageZoneNameExist(String string) {
        if (string == null) {
            return false;
        }
        Enumeration enumeration = this._systemStorageZones.elements();
        while (enumeration.hasMoreElements()) {
            SystemStorageZone systemStorageZone = (SystemStorageZone)enumeration.nextElement();
            if (!systemStorageZone.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void removeRuleRef(SystemStorageZone systemStorageZone, SystemOpRule systemOpRule) {
        if (systemStorageZone == null || systemOpRule == null) {
            return;
        }
        systemStorageZone.removeRuleRef(systemOpRule);
    }

    public void removeAllRuleRef(SystemOpRule systemOpRule) {
        if (systemOpRule == null) {
            return;
        }
        Enumeration enumeration = this._systemStorageZones.elements();
        while (enumeration.hasMoreElements()) {
            SystemStorageZone systemStorageZone = (SystemStorageZone)enumeration.nextElement();
            systemStorageZone.removeRuleRef(systemOpRule);
        }
    }

    public int getNextStorageZoneIndex() {
        return this._nextStorageZoneId++;
    }

    private int getNextOpSetRefIndex() {
        return this._nextOpSetRefId++;
    }

    public void addReservoirReferenceSpace() {
    }

    public void deleteReservoirReferences(int n) {
        this.deleteOpSetRefByReservoirID(n);
        Enumeration enumeration = this._systemStorageZones.elements();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            SystemStorageZone systemStorageZone = (SystemStorageZone)enumeration.nextElement();
            systemStorageZone.deleteSystemStorage(n);
            systemStorageZone.deleteZoneBounds(n);
        }
    }

    public OpSetRef[] getOpSetReferenceArray() {
        OpSetRef[] opSetRefArray = new OpSetRef[this._operationSetRefs.size()];
        Enumeration enumeration = this._operationSetRefs.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            opSetRefArray[n] = (OpSetRef)enumeration.nextElement();
            opSetRefArray[n].setParent(this);
            ++n;
        }
        return opSetRefArray;
    }

    public OpSetRef getOpSetReferences(int n) {
        OpSetRef opSetRef = (OpSetRef)this._operationSetRefs.get(new intContainer(n));
        opSetRef.setParent(this);
        return opSetRef;
    }

    public void deleteOpSetRefByReservoir(ReservoirElement reservoirElement) {
        if (reservoirElement == null) {
            return;
        }
        this.deleteOpSetRefByReservoirID(reservoirElement.getIndex());
    }

    public void deleteOpSetRefByReservoirID(int n) {
        Enumeration enumeration = this._operationSetRefs.elements();
        while (enumeration.hasMoreElements()) {
            OpSetRef opSetRef = (OpSetRef)enumeration.nextElement();
            if (opSetRef.getReserovirIndex() != n) continue;
            this._operationSetRefs.remove(new intContainer(opSetRef.getIndex()));
        }
    }

    public OpSetRef getOpSetReferences(ReservoirElement reservoirElement) {
        if (reservoirElement == null) {
            return null;
        }
        ReservoirOp reservoirOp = reservoirElement.getReservoirOp();
        if (reservoirOp == null) {
            return null;
        }
        OpSetRef[] opSetRefArray = this.getOpSetReferenceArray();
        for (int i = 0; i < opSetRefArray.length; ++i) {
            OpSetRef opSetRef = opSetRefArray[i];
            OpSet opSet = opSetRef.getOpSet();
            if (opSet == null || !reservoirOp.doesOpSetExist(opSet.getName()) || opSetRef.getReserovirIndex() != reservoirElement.getIndex()) continue;
            opSetRef.setParent(this);
            return opSetRef;
        }
        return null;
    }

    public void addReservoirOpSet(OpSet namedType) {
        if (namedType == null) {
            return;
        }
        ResSystemOpSet resSystemOpSet = this;
        namedType = new OpSetRef(resSystemOpSet, resSystemOpSet.getNextOpSetRefIndex(), (OpSet)namedType);
        this._operationSetRefs.put(new intContainer(namedType.getIndex()), namedType);
    }

    public String toString() {
        return this.getName();
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        element.setAttribute("Name", this.getName());
        element.setAttribute("Description", this.getDescription());
        Enumeration enumeration = this._systemStorageZones.elements();
        while (enumeration.hasMoreElements()) {
            SystemStorageZone systemStorageZone = (SystemStorageZone)enumeration.nextElement();
            Element element2 = new Element("SystemStorageZone");
            element.addContent((Content)element2);
            systemStorageZone.setParent(this);
            systemStorageZone.outputReport(alternativeInputReport, element2);
        }
    }
}

