/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.lang.NamedType;
import hec.model.PairedValuesExt;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.Dam;
import hec.rss.model.Element;
import hec.rss.model.ForebayHeadLoss;
import hec.rss.model.FunctionFactory;
import hec.rss.model.Junction;
import hec.rss.model.OutletGroupElement;
import hec.rss.model.PowerPlantFlow;
import hec.rss.model.PumpFlow;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOutletElement;
import hec.rss.model.ReservoirUtilities;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.Spillway;
import hec.rss.model.TailElevContainer;
import hec.rss.model.TailwaterElevation;
import hec.rss.model.reports.AltInputReportEnums;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.Vector;
import org.jdom.Content;

public class ReservoirDamElement
extends ReservoirOutletElement
implements TailElevContainer,
AltInputReportInfc {
    public static final int TAILWATER_CHILD_ID = 0;
    public static final int DAM_CHILD_ID = 1;
    private transient PairedValuesExt a;

    public ReservoirDamElement() {
    }

    public ReservoirDamElement(RssSystem rssSystem, int n) {
        super(rssSystem, n);
    }

    @Override
    public TailwaterElevation getTailwaterElevation() {
        Junction junction = this.getTailwaterFunction();
        if (junction == null) {
            return null;
        }
        return junction.getTailwaterElevation();
    }

    @Override
    public void setHasTailElev(boolean bl) {
        Junction junction = this.getTailwaterFunction();
        if (junction == null) {
            return;
        }
        junction.setHasTailElev(bl);
    }

    @Override
    public boolean hasTailElev() {
        Junction junction = this.getTailwaterFunction();
        if (junction == null) {
            return false;
        }
        return junction.hasTailElev();
    }

    public boolean hasPowerPlant() {
        Vector vector = this.getElementsByClass(AdjustableFlow.class, null);
        for (int i = 0; i < vector.size(); ++i) {
            NamedType namedType = (Element)vector.elementAt(i);
            if (!((AdjustableFlow)(namedType = (AdjustableFlow)namedType.getFunction())).hasPowerPlant()) continue;
            return true;
        }
        return false;
    }

    public boolean getComputesLeakage() {
        Dam dam = this.getDamFunction();
        if (dam != null) {
            return dam.getComputesLeakage();
        }
        return false;
    }

    public void setComputesLeakage(boolean bl) {
        Dam dam = this.getDamFunction();
        if (dam != null) {
            dam.setComputesLeakage(bl);
        }
    }

    public PairedValuesExt getCompositeRelease() {
        this.a = ReservoirUtilities.a(this);
        return this.a;
    }

    public void buildDefaultElements() {
        this.removeAllChildElements();
        Element element = this._system.newElement(false);
        element.setName(this._system.getKeyStringForObject(this) + "~Tailwater");
        Element element2 = element;
        element2.setFunction(FunctionFactory.a(element2, "Junction"));
        super.addChildElement(element);
        Element element3 = this._system.newElement(false);
        element3.setName(this._system.getKeyStringForObject(this) + "~L&O");
        Element element4 = element3;
        element4.setFunction(FunctionFactory.a(element4, "Dam"));
        super.addChildElement(element3);
        RssNode rssNode = this._system.newNode();
        Element element5 = ((ReservoirElement)this._parentElement).getStorageElement();
        element5.addNode(rssNode, 0);
        ((Element)this).addNode(rssNode, 1);
        element3.addNode(rssNode, 1);
        rssNode.setName(this._system.getKeyStringForObject(element3) + "~" + "IN");
        rssNode = this._system.newNode();
        element3.addNode(rssNode, 0);
        element.addNode(rssNode, 1);
    }

    @Override
    public void addNode(RssNode rssNode, int n) {
        if (this._nodeVector.contains(rssNode)) {
            return;
        }
        super.addNode(rssNode, n);
        if (this._elemVector.size() < 2) {
            return;
        }
        if (n == 0) {
            Element element = this._elemVector.elementAt(0);
            element.addNode(rssNode, n);
        }
    }

    @Override
    public void addChildElement(Element element) {
        Element element2;
        RssNode rssNode;
        if (element == null) {
            return;
        }
        super.addChildElement(element);
        if (!(element instanceof OutletGroupElement)) {
            rssNode = this._system.newNode();
            element2 = ((ReservoirElement)this._parentElement).getStorageElement();
            element2.addNode(rssNode, 0);
            ((Element)this).addNode(rssNode, 1);
            element.addNode(rssNode, 1);
            rssNode.setName(this._system.getKeyStringForObject(element) + "~" + "IN");
        }
        element2 = this._elemVector.elementAt(0);
        rssNode = this._system.newNode();
        element.addNode(rssNode, 0);
        element2.addNode(rssNode, 1);
    }

    public Dam getDamFunction() {
        if (this._elemVector.size() <= 1) {
            return null;
        }
        Element element = this._elemVector.elementAt(1);
        if (element == null || !(element.getFunction() instanceof Dam)) {
            return null;
        }
        return (Dam)element.getFunction();
    }

    public Element getDamElement() {
        if (this._elemVector.size() <= 1) {
            return null;
        }
        Element element = this._elemVector.get(1);
        if (element == null || !(element.getFunction() instanceof Dam)) {
            return null;
        }
        return element;
    }

    public Element getTailwaterElement() {
        if (this._elemVector.size() <= 0) {
            return null;
        }
        return this._elemVector.elementAt(0);
    }

    public Junction getTailwaterFunction() {
        if (this._elemVector.size() <= 0) {
            return null;
        }
        Element element = this._elemVector.elementAt(0);
        if (element == null || !(element.getFunction() instanceof Junction)) {
            return null;
        }
        return (Junction)element.getFunction();
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        Object object;
        org.jdom.Element element2 = null;
        element.setAttribute("Name", this.getDisplayName());
        element.setAttribute("Description", this.getDescription());
        if (!this.getUseDefaultPulseFlow()) {
            element.setAttribute("PulseRouting", Double.toString(this.getPulseFlow()));
        }
        this.getDamFunction().outputReport(alternativeInputReport, element);
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_TAILWATER).a() && (object = this.getTailwaterElevation()) != null) {
            element2 = new org.jdom.Element("Tailwater");
            element.addContent((Content)element2);
            ((TailwaterElevation)object).outputReport(alternativeInputReport, element2);
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_FOREBAY_HEADLOSS).a() && this.hasForebayHeadLoss() && (object = this.getForebayHeadLoss()) != null) {
            element2 = new org.jdom.Element("ForebayHeadLoss");
            element.addContent((Content)element2);
            ((ForebayHeadLoss)object).outputReport(alternativeInputReport, element2);
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_LEAKAGE).a() && (object = this.getDamFunction()) != null && ((Dam)object).getComputesLeakage()) {
            if (((Dam)object)._leakageValues != null) {
                element2 = new org.jdom.Element("Leakages_Elev");
            }
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])((Dam)object)._leakageValues.getYArray());
            element2 = new org.jdom.Element("Leakage_Leakage");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])((Dam)object)._leakageValues.getXArray());
        }
        object = this.getElementVector();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            Element element3 = (Element)((Vector)object).get(i);
            if (element3 instanceof OutletGroupElement) {
                element2 = new org.jdom.Element("OutletGroup");
                element.addContent((Content)element2);
                ((OutletGroupElement)element3).outputReport(alternativeInputReport, element2);
            }
            element3.getFunction();
            if (element3.getFunction() instanceof PowerPlantFlow && alternativeInputReport.b().get((Object)AltInputReportEnums.RES_POWER_PLANT).a()) {
                element2 = new org.jdom.Element("Power_Plant");
                element.addContent((Content)element2);
                ((AdjustableFlow)element3.getFunction()).outputReport(alternativeInputReport, element2);
            } else if (element3.getFunction() instanceof PumpFlow && alternativeInputReport.b().get((Object)AltInputReportEnums.RES_PUMP).a()) {
                element2 = new org.jdom.Element("Pump");
                element.addContent((Content)element2);
                ((AdjustableFlow)element3.getFunction()).outputReport(alternativeInputReport, element2);
            } else if (element3.getFunction() instanceof Spillway && alternativeInputReport.b().get((Object)AltInputReportEnums.RES_UNCONTROLLED_OUTLET).a()) {
                element2 = new org.jdom.Element("Spillway");
                element.addContent((Content)element2);
                ((Spillway)element3.getFunction()).outputReport(alternativeInputReport, element2);
            } else if (element3.getFunction() instanceof AdjustableFlow && alternativeInputReport.b().get((Object)AltInputReportEnums.RES_CONTROLLED_OUTLET).a()) {
                element2 = new org.jdom.Element("Controlled_Outlet");
                element.addContent((Content)element2);
                ((AdjustableFlow)element3.getFunction()).outputReport(alternativeInputReport, element2);
            }
            if (element3._forebayHeadLoss == null) continue;
            element2 = new org.jdom.Element("Forebay");
            element.addContent((Content)element2);
            this._forebayHeadLoss.outputReport(alternativeInputReport, element2);
        }
    }
}

