/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.Manager;
import hec.clientapp.model.StreamAlignment;
import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.intContainer;
import hec.io.AsciiSerializable;
import hec.io.dbf.AsciiSerializableDbfHeader;
import hec.io.dbf.DbfRecord;
import hec.io.dbf.DbfRecordQuery;
import hec.io.dbf.DbfRecordSet;
import hec.lang.Logger;
import hec.lang.NamedType;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldRegion;
import hec.model.CommonDataList;
import hec.model.DataObject;
import hec.model.ModelVariable;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.StreamSegment;
import hec.model.TSLocation;
import hec.rss.model.AbstractReservoirOp;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.ConditionalBlockRef;
import hec.rss.model.ControlStructure;
import hec.rss.model.CumLocFunction;
import hec.rss.model.Dam;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOp;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.Element;
import hec.rss.model.ElementAssignmentContainer;
import hec.rss.model.ElementHotstartState;
import hec.rss.model.ElementOp;
import hec.rss.model.FlowLimitOpRule;
import hec.rss.model.Function;
import hec.rss.model.FunctionFactory;
import hec.rss.model.HoldoutFunction;
import hec.rss.model.IndependentVariable;
import hec.rss.model.IndependentVariableInfo;
import hec.rss.model.Junction;
import hec.rss.model.ModelConst;
import hec.rss.model.OpControllable;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.OpSet;
import hec.rss.model.OperationsElement;
import hec.rss.model.OutletGroupElement;
import hec.rss.model.PowerPlant;
import hec.rss.model.PowerPlantFlow;
import hec.rss.model.PulseRoutingFunction;
import hec.rss.model.Pump;
import hec.rss.model.PumpFlow;
import hec.rss.model.PumpOpRule;
import hec.rss.model.RateChangeLimitOpRule;
import hec.rss.model.ReleaseElement;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReleaseOverrides;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement$RelIntegrFunc;
import hec.rss.model.ReservoirElement$StorageErrorFunc;
import hec.rss.model.ReservoirHotstartState;
import hec.rss.model.ReservoirImport;
import hec.rss.model.ReservoirLimitSet;
import hec.rss.model.ReservoirOp;
import hec.rss.model.ReservoirOutletElement;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.ReservoirUtilities;
import hec.rss.model.ReversiblePumpFlow;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.RuleResolution;
import hec.rss.model.Spillway;
import hec.rss.model.StateVariable;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.SystemHydropowerOpRule;
import hec.rss.model.SystemHydropowerRule;
import hec.rss.model.TandemOpRule;
import hec.rss.model.VerticalDatumSettings;
import hec.rss.model.WaterAccount;
import hec.rss.model.WaterControlDevice;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.reports.AltInputReportEnums;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import mil.army.usace.hec.rmi.io.dbf.DbfFile;
import org.jdom.Content;
import rma.lang.RmaMath;
import rma.lang.RmaSVFunction;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ReservoirElement
extends Element
implements OperationsElement,
ReleaseElement,
AltInputReportInfc,
Cloneable {
    public static final String KNOWN_STORAGE = " Known Storage";
    public static final String KNOWN_ELEVATION = " Known Elevation";
    public static final String KNOWN_RELEASE = " Known Release";
    public static final String KNOWN_EVAPORATION = " Evaporation";
    public static final String KNOWN_SPILL = " Known Spill";
    public static final String ELEVATION = ModelConst.k;
    public static final String STORAGE = ModelConst.n;
    public static final String EVAPORATION = "Evap";
    public static final String SPILL = "Spill";
    public static final int STORAGE_ID = 0;
    public static final int DNSTRM_ID = 1;
    public static final int DAM_ID = 0;
    public static final int OUTLET_ID = 1;
    public static final int SPILL_ID = 2;
    public static final int TAILWATER_ID = 3;
    WorldPt _referencePt = new WorldPt();
    WorldRegion _region = new WorldRegion();
    private Vector<StreamSegment> _streamSegmentVector;
    long _resOpId = -1L;
    int _resOpDbfId = -1;
    long _resSysOpId = -1L;
    long _reservoirProjectId = Long.MIN_VALUE;
    VerticalDatumSettings _verticalDatumSettings = new VerticalDatumSettings();
    private int _labelPosition = 0;
    private transient int c = 0;
    private transient Junction d;
    private transient CumLocFunction e;
    private transient HoldoutFunction f;
    private transient PulseRoutingFunction g;
    private transient RssNode h;
    private transient String i;
    transient ReservoirOp a;
    private transient ReservoirSysOp j;
    private transient PairedValuesExt k;
    transient Element[] b;
    private transient ReservoirElement$StorageErrorFunc l;
    private transient ReservoirElement$RelIntegrFunc m;
    private transient int n;
    private transient Hashtable o;
    private transient Storage p = null;
    private boolean _useOverridesForThisReservoir = false;
    private transient WaterAccount q = null;

    public ReservoirElement() {
    }

    public ReservoirElement(RssSystem rssSystem, int n) {
        super(rssSystem, n);
    }

    @Override
    protected void initTSVals(int n) {
        super.initTSVals(n);
    }

    public void setVerticalDatumSettings(VerticalDatumSettings verticalDatumSettings) {
        if (verticalDatumSettings == null) {
            return;
        }
        this._verticalDatumSettings = verticalDatumSettings;
    }

    @Override
    public VerticalDatumSettings getVerticalDatumSettings() {
        return this._verticalDatumSettings;
    }

    @Override
    public double getEffectiveElev(RunTimeStep runTimeStep) {
        if (this.p == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = 0.0;
        double d2 = this.p.getElevation(runTimeStep);
        if (!RMAConst.isValidValue((double)d2)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._forebayHeadLoss != null) {
            d = this._forebayHeadLoss.getHeadLoss(runTimeStep);
        }
        return d2 -= d;
    }

    @Override
    public double getPrevEffectiveElev(RunTimeStep runTimeStep) {
        if (this.p == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = 0.0;
        double d2 = this.p.getPreviousElevation(runTimeStep);
        if (!RMAConst.isValidValue((double)d2)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._forebayHeadLoss != null) {
            d = this._forebayHeadLoss.getPrevHeadLoss(runTimeStep);
        }
        return d2 -= d;
    }

    @Override
    public Vector getFlowContolTSRecordProxies() {
        Vector<Object> vector = new Vector<Object>();
        Storage storage = this.getStorageFunction();
        if (storage != null && storage.getTSRecordProxy(21) != null) {
            vector.addElement(storage.getTSRecordProxy(21));
        }
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._elemVector.elementAt(i);
            if (object == null) continue;
            object = ((Element)object).getFlowContolTSRecordProxies();
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                vector.addElement(((Vector)object).elementAt(j));
            }
        }
        return vector;
    }

    void setComputeState(int n) {
        this.c = n;
    }

    public List getReservoirOutletElements(List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<Element>();
        }
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = this._elemVector.get(i);
            if (!(element instanceof ReservoirOutletElement)) continue;
            arrayList.add(element);
        }
        return arrayList;
    }

    public PowerPlant[] getPowerPlants() {
        PowerPlant[] powerPlantArray = this.getElementsByClass(AdjustableFlow.class, null);
        Vector<PowerPlant> vector = new Vector<PowerPlant>();
        int n = powerPlantArray.size();
        for (int i = 0; i < n; ++i) {
            NamedType namedType = (Element)powerPlantArray.get(i);
            if (!(namedType = (AdjustableFlow)namedType.getFunction()).hasPowerPlant()) continue;
            vector.add(namedType.getPowerPlant());
        }
        powerPlantArray = new PowerPlant[vector.size()];
        vector.toArray(powerPlantArray);
        return powerPlantArray;
    }

    public Pump[] getPumps() {
        Pump[] pumpArray = this.getElementsByClass(AdjustableFlow.class, null);
        Vector<Pump> vector = new Vector<Pump>();
        int n = pumpArray.size();
        for (int i = 0; i < n; ++i) {
            NamedType namedType = (Element)pumpArray.get(i);
            if (!(namedType = (AdjustableFlow)namedType.getFunction()).hasPump()) continue;
            vector.add(namedType.getPump());
        }
        pumpArray = new Pump[vector.size()];
        vector.toArray(pumpArray);
        return pumpArray;
    }

    @Override
    public Vector getRequiredTSRecordProxies() {
        Vector vector = super.getRequiredTSRecordProxies();
        ReservoirOp reservoirOp = this.getReservoirOp();
        if (reservoirOp == null) {
            return vector;
        }
        vector = reservoirOp.getRequiredTSRecordProxies(vector);
        return vector;
    }

    @Override
    public List getRuleConnectivityRefs() {
        RssReturnStatusConstants rssReturnStatusConstants = this.getReservoirOp(false);
        rssReturnStatusConstants = rssReturnStatusConstants.getController();
        return ((OpController)rssReturnStatusConstants).getRuleConnectivityRefs(false);
    }

    public double getGuideCurveStorage(RunTimeStep runTimeStep) {
        if (this.a == null) {
            this.getReservoirOp(false);
            if (this.a == null) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        return this.a.getGuideCurveStorage(runTimeStep);
    }

    @Override
    public void saveElementState(int n) {
        super.saveElementState(n);
        this.getReservoirOp(false).saveFunctionState(n);
    }

    @Override
    public void restoreElementState(int n) {
        super.restoreElementState(n);
        this.getReservoirOp(false).restoreFunctionState(n);
    }

    @Override
    protected ElementHotstartState createHotstartState() {
        return new ReservoirHotstartState(this);
    }

    @Override
    public void updateDecisions(RunTimeStep runTimeStep, int n) {
        if (this.a == null) {
            return;
        }
        this.a.updateDecisions(runTimeStep, n);
        double d = this.getStorageFunction().getPreviousElevation(runTimeStep);
        StorageZone storageZone = this.a.getActiveOpSet().getActiveZone(d, runTimeStep);
        this.a.applyWaterQualityRules(runTimeStep, storageZone, n);
    }

    @Override
    public int initForecastOperations(RunTimeWindow runTimeWindow) {
        Vector vector = this.getElementsByClass(ControlStructure.class, null);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            NamedType namedType = (Element)vector.elementAt(i);
            namedType = (ControlStructure)namedType.getFunction();
            ((ControlStructure)namedType).initForecastOperations(runTimeWindow);
        }
        return 0;
    }

    @Override
    public PairedValuesExt getCompositeRelease() {
        this.k = ReservoirUtilities.a(this);
        return this.k;
    }

    public double getTotalCompositeRelease(double d) {
        if (this.k == null) {
            this.k = this.getCompositeRelease();
        }
        if (this.k == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.k.getYValue(d, 2);
    }

    @Override
    public Vector getModelVariables(Vector vector) {
        if (vector == null) {
            vector = new Vector<ModelVariable>();
        }
        vector.add(RssModelVariableSet.getModelVariable(128));
        vector.add(RssModelVariableSet.getModelVariable(129));
        vector.add(RssModelVariableSet.getModelVariable(76));
        vector.add(RssModelVariableSet.getModelVariable(78));
        vector.add(RssModelVariableSet.getModelVariable(10));
        vector.add(RssModelVariableSet.getModelVariable(11));
        vector.add(RssModelVariableSet.getModelVariable(89));
        vector.add(RssModelVariableSet.getModelVariable(12));
        vector.add(RssModelVariableSet.getModelVariable(13));
        vector.add(RssModelVariableSet.getModelVariable(17));
        vector.add(RssModelVariableSet.getModelVariable(19));
        vector.add(RssModelVariableSet.getModelVariable(20));
        vector.add(RssModelVariableSet.getModelVariable(21));
        vector.add(RssModelVariableSet.getModelVariable(7));
        vector.add(RssModelVariableSet.getModelVariable(40));
        vector.add(RssModelVariableSet.getModelVariable(45));
        vector.add(RssModelVariableSet.getModelVariable(69));
        vector.add(RssModelVariableSet.getModelVariable(74));
        if (this.hasPowerPlant()) {
            vector.add(RssModelVariableSet.getModelVariable(50));
            vector.add(RssModelVariableSet.getModelVariable(51));
            vector.add(RssModelVariableSet.getModelVariable(52));
            vector.add(RssModelVariableSet.getModelVariable(55));
            vector.add(RssModelVariableSet.getModelVariable(54));
            vector.add(RssModelVariableSet.getModelVariable(56));
            vector.add(RssModelVariableSet.getModelVariable(57));
            vector.add(RssModelVariableSet.getModelVariable(166));
            vector.add(RssModelVariableSet.getModelVariable(58));
            vector.add(RssModelVariableSet.getModelVariable(53));
            vector.add(RssModelVariableSet.getModelVariable(59));
            vector.add(RssModelVariableSet.getModelVariable(155));
            vector.add(RssModelVariableSet.getModelVariable(156));
            vector.add(RssModelVariableSet.getModelVariable(157));
            vector.add(RssModelVariableSet.getModelVariable(159));
        }
        if (this.hasPump()) {
            vector.add(RssModelVariableSet.getModelVariable(182));
            vector.add(RssModelVariableSet.getModelVariable(183));
            vector.add(RssModelVariableSet.getModelVariable(170));
            vector.add(RssModelVariableSet.getModelVariable(171));
            vector.add(RssModelVariableSet.getModelVariable(172));
            vector.add(RssModelVariableSet.getModelVariable(173));
            vector.add(RssModelVariableSet.getModelVariable(180));
            vector.add(RssModelVariableSet.getModelVariable(174));
            vector.add(RssModelVariableSet.getModelVariable(175));
            vector.add(RssModelVariableSet.getModelVariable(176));
            vector.add(RssModelVariableSet.getModelVariable(177));
            vector.add(RssModelVariableSet.getModelVariable(178));
            vector.add(RssModelVariableSet.getModelVariable(181));
            vector.add(RssModelVariableSet.getModelVariable(179));
        }
        return vector;
    }

    public boolean hasPump() {
        Vector vector = this.getElementsByClass(AdjustableFlow.class, null);
        for (int i = 0; i < vector.size(); ++i) {
            NamedType namedType = (Element)vector.elementAt(i);
            if (!((AdjustableFlow)(namedType = (AdjustableFlow)namedType.getFunction())).hasPump()) continue;
            return true;
        }
        return false;
    }

    public boolean useOverridesForThisReservoir() {
        return this._useOverridesForThisReservoir;
    }

    public void setUseOverridesForThisReservoir(boolean bl) {
        this._useOverridesForThisReservoir = bl;
    }

    public boolean hasPowerPlant() {
        Vector vector = this.getElementsByClass(AdjustableFlow.class, null);
        for (int i = 0; i < vector.size(); ++i) {
            NamedType namedType = (Element)vector.elementAt(i);
            if (!((AdjustableFlow)(namedType = (AdjustableFlow)namedType.getFunction())).hasPowerPlant()) continue;
            return true;
        }
        return false;
    }

    public boolean hasWaterControlDeviceOnRes() {
        Vector vector = this.getElementsByClass(AdjustableFlow.class, null);
        for (int i = 0; i < vector.size(); ++i) {
            Element element = (Element)vector.elementAt(i);
            if (!element.hasWaterControlDevice()) continue;
            return true;
        }
        return false;
    }

    public List<WaterControlDevice> getWaterControlDevicesOnRes() {
        ArrayList<WaterControlDevice> arrayList = new ArrayList<WaterControlDevice>();
        Vector vector = this.getElementsByClass(AdjustableFlow.class, null);
        for (int i = 0; i < vector.size(); ++i) {
            Element element = (Element)vector.elementAt(i);
            if (!element.hasWaterControlDevice()) continue;
            arrayList.add(element.getWaterControlDevice());
        }
        return arrayList;
    }

    @Override
    public Vector getDefaultModelVariables() {
        Vector<ModelVariable> vector = new Vector<ModelVariable>();
        vector.add(RssModelVariableSet.getModelVariable(76));
        vector.add(RssModelVariableSet.getModelVariable(10));
        vector.add(RssModelVariableSet.getModelVariable(12));
        vector.add(RssModelVariableSet.getModelVariable(21));
        return vector;
    }

    @Override
    public Vector getTSRecords(ModelVariable object, Vector vector, Vector vector2) {
        if (vector == null) {
            vector = new Vector<Object>();
        }
        if (object == null) {
            return vector;
        }
        switch (object.getType()) {
            case 69: 
            case 74: {
                object = ((RssTSLocationObject)this.a.getController()).getTSRecordProxy(object.getType());
                if (object == null) break;
                vector.addElement(object);
                break;
            }
            case 76: 
            case 78: 
            case 128: 
            case 129: {
                if (vector2 == null) break;
                int n = vector2.size();
                for (int i = 0; i < n; ++i) {
                    OpSet opSet;
                    RssReturnStatusConstants rssReturnStatusConstants;
                    Manager manager = (RssRun)vector2.elementAt(i);
                    if (manager == null || (manager = manager.getAlternative()) == null || (rssReturnStatusConstants = manager.getSystem()) == null || (rssReturnStatusConstants = ((RssSystem)rssReturnStatusConstants).findReservoir(this.getName())) == null) continue;
                    int n2 = manager.getResOpSetSelection(rssReturnStatusConstants.getIndex());
                    if ((rssReturnStatusConstants = ((ReservoirElement)rssReturnStatusConstants).getReservoirOp()) == null || (opSet = ((ReservoirOp)rssReturnStatusConstants).getOperationSet(n2)) == null) continue;
                    ((RssTSLocationObject)opSet).updateTSProxyList();
                    ((RssTSLocationObject)opSet).getTSRecordProxyVec(object.getType(), vector);
                }
                break;
            }
            case 10: {
                object = this.getStorageFunction().getTSRecordProxy(10);
                if (object == null) break;
                vector.addElement(object);
                break;
            }
            case 11: {
                object = this.getStorageFunction().getTSRecordProxy(11);
                if (object == null) break;
                vector.addElement(object);
                break;
            }
            case 89: {
                this.getStorBalTSProxies(89, vector);
                break;
            }
            case 12: {
                object = this.getStorageFunction().getTSRecordProxy(12);
                if (object == null) break;
                vector.addElement(object);
                break;
            }
            case 13: {
                object = this.getStorageFunction().getTSRecordProxy(13);
                if (object == null) break;
                vector.addElement(object);
                break;
            }
            case 17: {
                object = this.getStorageFunction().getTSRecordProxy(17);
                if (object == null) break;
                vector.addElement(object);
                break;
            }
            case 19: {
                object = this.getStorageFunction().getTSRecordProxy(19);
                if (object == null) break;
                vector.addElement(object);
                break;
            }
            case 20: {
                object = this.getStorageFunction().getTSRecordProxy(20);
                if (object == null) break;
                vector.addElement(object);
                break;
            }
            case 21: {
                object = this.getStorageFunction().getTSRecordProxy(21);
                if (object == null) break;
                vector.addElement(object);
                break;
            }
            case 7: {
                object = ((RssTSLocationObject)this.a.getController()).getTSRecordProxy(7);
                if (object == null) break;
                vector.addElement(object);
                break;
            }
            case 40: {
                vector2 = this.getElementsByClass(AdjustableFlow.class, null);
                for (int i = 0; i < vector2.size(); ++i) {
                    Element element = (Element)vector2.elementAt(i);
                    object = element.getDownstreamNode();
                    if (object == null) {
                        return null;
                    }
                    if ((object = ((RssNode)object).getTSRecordProxy(0)) == null) continue;
                    vector.addElement(object);
                }
                break;
            }
            case 45: {
                vector2 = this.getElementsByClass(Dam.class, null);
                vector2 = this.getElementsByClass(Spillway.class, vector2);
                for (int i = 0; i < vector2.size(); ++i) {
                    Element element = (Element)vector2.elementAt(i);
                    object = element.getDownstreamNode();
                    if (object == null) {
                        return null;
                    }
                    if ((object = ((RssNode)object).getTSRecordProxy(0)) == null) continue;
                    vector.addElement(object);
                }
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 155: 
            case 156: 
            case 157: 
            case 159: 
            case 166: {
                this.getPowerTSProxies(object.getType(), vector);
                break;
            }
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: {
                this.getPumpTSProxies(object.getType(), vector);
            }
        }
        return vector;
    }

    private void getPowerTSProxies(int n, Vector vector) {
        if (vector == null) {
            return;
        }
        Vector vector2 = this.getElementsByClass(Element.class, null);
        vector2.insertElementAt(this, 0);
        for (int i = 0; i < vector2.size(); ++i) {
            Object object = (Element)vector2.elementAt(i);
            RssTSLocationObject rssTSLocationObject = ((Element)object).getFunction();
            if (rssTSLocationObject != null && (rssTSLocationObject = rssTSLocationObject.getTSRecordProxy(n)) != null) {
                vector.addElement(rssTSLocationObject);
            }
            if ((rssTSLocationObject = object == this ? this.getReservoirOp().getController() : this.getReservoirOp().getControllerForElement((Element)object)) == null) continue;
            object = ((OpController)rssTSLocationObject).getRules(null);
            for (int j = 0; object != null && j < ((Vector)object).size(); ++j) {
                SystemHydropowerOpRule systemHydropowerOpRule;
                Object object2;
                Object object3 = (OpRule)((Vector)object).get(j);
                if (object3 == null) continue;
                Vector vector3 = ((RssTSLocationObject)object3).getTSRecordProxyVec(n, null);
                for (int k = 0; vector3 != null && k < vector3.size(); ++k) {
                    object2 = vector3.get(k);
                    if (object2 == null || vector.contains(object2)) continue;
                    vector.add(object2);
                }
                if (!(object3 instanceof SystemHydropowerOpRule) || (object2 = this._system.getSystemHydropowerRule((systemHydropowerOpRule = (SystemHydropowerOpRule)object3).getParentRuleIndex())) == null || (object3 = ((RssTSLocationObject)object2).getTSRecordProxyVec(n, null)) == null) continue;
                for (int k = 0; k < ((Vector)object3).size(); ++k) {
                    systemHydropowerOpRule = ((Vector)object3).get(k);
                    if (systemHydropowerOpRule == null || vector.contains(systemHydropowerOpRule)) continue;
                    vector.add(systemHydropowerOpRule);
                }
            }
        }
    }

    private void getPumpTSProxies(int n, Vector vector) {
        if (vector == null) {
            return;
        }
        Object object = this.getStorageFunction().getTSRecordProxy(n);
        if (object != null) {
            vector.addElement(object);
        }
        Vector vector2 = this.getElementsByClass(AdjustableFlow.class, null);
        for (int i = 0; i < vector2.size(); ++i) {
            Element element = (Element)vector2.elementAt(i);
            object = (AdjustableFlow)element.getFunction();
            if (((AdjustableFlow)object).hasPump() && (object = ((RssTSLocationObject)object).getTSRecordProxy(n)) != null) {
                vector.addElement(object);
            }
            object = this.getReservoirOp().getControllerForElement(element).getRules(null);
            for (int j = 0; object != null && j < ((Vector)object).size(); ++j) {
                Object object2 = (OpRule)((Vector)object).get(j);
                if (object2 == null) continue;
                object2 = ((RssTSLocationObject)object2).getTSRecordProxyVec(n, null);
                for (int k = 0; object2 != null && k < ((Vector)object2).size(); ++k) {
                    Object e = ((Vector)object2).get(k);
                    if (e == null || vector.contains(e)) continue;
                    vector.add(e);
                }
            }
        }
    }

    private void getStorBalTSProxies(int n, Vector vector) {
        if (vector == null) {
            return;
        }
        Vector vector2 = this.getElementsByClass(AdjustableFlow.class, null);
        for (int i = 0; i < vector2.size(); ++i) {
            Object object = (Element)vector2.elementAt(i);
            object = this.getReservoirOp().getControllerForElement((Element)object).getRules(null);
            for (int j = 0; object != null && j < ((Vector)object).size(); ++j) {
                SystemHydropowerOpRule systemHydropowerOpRule;
                Object object2;
                Object object3 = (OpRule)((Vector)object).get(j);
                if (object3 == null) continue;
                Vector vector3 = ((RssTSLocationObject)object3).getTSRecordProxyVec(n, null);
                for (int k = 0; vector3 != null && k < vector3.size(); ++k) {
                    object2 = vector3.get(k);
                    if (object2 == null || vector.contains(object2)) continue;
                    vector.add(object2);
                }
                if (!(object3 instanceof SystemHydropowerOpRule) || (object2 = this._system.getSystemHydropowerRule((systemHydropowerOpRule = (SystemHydropowerOpRule)object3).getParentRuleIndex())) == null || (object3 = ((RssTSLocationObject)object2).getTSRecordProxyVec(n, null)) == null) continue;
                for (int k = 0; k < ((Vector)object3).size(); ++k) {
                    systemHydropowerOpRule = (TSRecordProxy)((Vector)object3).get(k);
                    if (systemHydropowerOpRule.getName().indexOf(this.getName()) < 0 || systemHydropowerOpRule == null || vector.contains(systemHydropowerOpRule)) continue;
                    vector.add(systemHydropowerOpRule);
                }
            }
        }
    }

    @Override
    public void setupForSerialization() {
        super.setupForSerialization();
    }

    public void updateSegments() {
        Object object = this._system.getAlignment();
        if (object == null) {
            return;
        }
        Vector vector = new Vector();
        Vector<StreamSegment> vector2 = new Vector<StreamSegment>();
        if ((object = object.getStreamSegmentsByNodes(this._nodeVector, vector, vector2)) == null) {
            this.setStreamSegmentVector(vector2);
        }
    }

    public Vector<StreamSegment> getStreamSegmentVector() {
        return this._streamSegmentVector;
    }

    public void setStreamSegmentVector(Vector<StreamSegment> vector) {
        this._streamSegmentVector = vector;
    }

    public void setReservoirProjectId(long l) {
        this._reservoirProjectId = l;
    }

    public long getReservoirProjectId() {
        return this._reservoirProjectId;
    }

    public String getNextDivertedOutletName() {
        return this.getNextChildName(DivertedOutletElement.class.getName(), "Diverted Outlet");
    }

    public String getNextControlledOutletName() {
        return this.getNextChildName(AdjustableFlow.class.getName(), "Controlled Outlet");
    }

    public String getNextUncontrolledOutletName() {
        return this.getNextChildName(Spillway.class.getName(), "Uncontrolled Outlet");
    }

    public String getNextWaterControlDeviceName() {
        LinkedList linkedList = new LinkedList();
        List<Object> list = this.getElementVector();
        while (!list.isEmpty()) {
            List list2 = list.stream().map(object -> ((Element)object).getElementVector()).flatMap(Collection::stream).filter(object -> !linkedList.contains(object)).collect(Collectors.toList());
            linkedList.addAll(list);
            list = list2;
        }
        int n = 0;
        boolean bl = false;
        String string = "Water Control Device";
        Object object2 = "Water Control Device";
        int n2 = linkedList.size();
        while (!bl) {
            bl = true;
            for (int i = 0; i < n2; ++i) {
                NamedType namedType = (Element)linkedList.get(i);
                if ((namedType = namedType.getWaterControlDevice()) == null || !namedType.getName().equalsIgnoreCase((String)object2)) continue;
                object2 = string + " " + Integer.toString(++n);
                bl = false;
                break;
            }
            if (n <= 10000) continue;
            object2 = "Water Control Device " + Integer.toString(n2);
            break;
        }
        return object2;
    }

    public String getNextOutletGroupName() {
        return this.getNextChildName(OutletGroupElement.class.getName(), "Outlet Group");
    }

    public String getNextPumpName() {
        return this.getNextChildName(PumpFlow.class.getName(), "Pump");
    }

    public String getNextPowerPlantName() {
        return this.getNextChildName(PowerPlantFlow.class.getName(), "Power Plant");
    }

    public String getNextReversiblePumpName() {
        return this.getNextChildName(ReversiblePumpFlow.class.getName(), "Reversible Plant");
    }

    public void setDefaultWaterAccount(WaterAccount waterAccount) {
        this.q = waterAccount;
    }

    public WaterAccount getDefaultWaterAccount() {
        return this.q;
    }

    public String getNextChildName(String object, String string) {
        try {
            object = Class.forName((String)object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(classNotFoundException);
            return string;
        }
        object = this.getElementsByClass((Class)object, new Vector());
        int n = 0;
        boolean bl = false;
        Object object2 = string;
        int n2 = ((Vector)object).size();
        while (!bl) {
            bl = true;
            for (int i = 0; i < n2; ++i) {
                Element element = (Element)((Vector)object).elementAt(i);
                if (!element.getName().equalsIgnoreCase((String)object2)) continue;
                object2 = string + " " + Integer.toString(++n);
                bl = false;
                break;
            }
            if (n <= 10000) continue;
            object2 = "Element " + Integer.toString(n2);
            break;
        }
        return object2;
    }

    public Vector getDivertedOutlets() {
        Vector<Element> vector = new Vector<Element>();
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = this._elemVector.elementAt(i);
            if (!(element instanceof DivertedOutletElement)) continue;
            vector.add(element);
        }
        return vector;
    }

    public DivertedOutletElement createDivertedOutlet(RssNode rssNode, RssNode rssNode2, Vector vector, double d) {
        if (rssNode == null) {
            return null;
        }
        DivertedOutletElement divertedOutletElement = new DivertedOutletElement(this._system, this._system.nextElementIndex(), this);
        divertedOutletElement.setName("Diverted Outlet");
        this._elemVector.addElement(divertedOutletElement);
        divertedOutletElement.createDefaultElements(rssNode);
        if (rssNode2 != null) {
            super.addNode(rssNode2, 0);
            ((Element)divertedOutletElement).addNode(rssNode2, 0);
        }
        rssNode = new WorldLine();
        for (int i = 0; i < vector.size(); ++i) {
            ((WorldLine)rssNode).pts.addElement(vector.elementAt(i));
        }
        divertedOutletElement.setLine((WorldLine)rssNode);
        Element element = this.getSystem().newElement(false);
        element.setName(this.getNextControlledOutletName());
        Element element2 = element;
        element2.setFunction(FunctionFactory.a(element2, "AdjustableFlow"));
        ((Element)divertedOutletElement).addChildElement(element);
        this.setModified(true);
        return divertedOutletElement;
    }

    public void reconnectDivertedOutlet(RssNode rssNode) {
        if (rssNode != null) {
            super.addNode(rssNode, 0);
        }
    }

    @Override
    public synchronized Object clone() {
        ReservoirElement reservoirElement = (ReservoirElement)super.clone();
        ((ReservoirElement)super.clone())._referencePt = (WorldPt)this._referencePt.clone();
        reservoirElement._region = (WorldRegion)this._region.clone();
        this.i = reservoirElement.i;
        if (this.a != null) {
            reservoirElement.a = (ReservoirOp)((AbstractReservoirOp)this.a).clone();
            reservoirElement.a.setReservoirElement(reservoirElement);
        }
        reservoirElement.d = null;
        reservoirElement.e = null;
        reservoirElement.f = null;
        reservoirElement.g = null;
        reservoirElement.h = null;
        reservoirElement._useOverridesForThisReservoir = this._useOverridesForThisReservoir;
        if (this.q != null) {
            reservoirElement.q = (WaterAccount)((RssTSLocationObject)this.q).clone();
        }
        return reservoirElement;
    }

    public void copyInto(ReservoirElement reservoirElement) {
        VerticalDatumSettings verticalDatumSettings;
        super.copyInto(reservoirElement);
        this._referencePt = (WorldPt)reservoirElement._referencePt.clone();
        this._region = (WorldRegion)reservoirElement._region.clone();
        this.c = reservoirElement.c;
        this._labelPosition = reservoirElement._labelPosition;
        this._resOpId = reservoirElement._resOpId;
        this._resSysOpId = reservoirElement._resSysOpId;
        this._resOpDbfId = reservoirElement._resOpDbfId;
        if (this.a == null) {
            this.getReservoirOp();
        }
        if (reservoirElement.a != null && this.a != null) {
            this.a.copyInto(reservoirElement.a);
            this.a.setReservoirElement(this);
            this.a.setModified(true);
        }
        this._verticalDatumSettings = (verticalDatumSettings = reservoirElement.getVerticalDatumSettings()) != null ? new VerticalDatumSettings(verticalDatumSettings) : new VerticalDatumSettings();
        this.d = null;
        this.e = null;
        this.f = null;
        this.g = null;
        this.h = null;
        if (reservoirElement.q != null) {
            this.q = (WaterAccount)((RssTSLocationObject)reservoirElement.q).clone();
        }
        this.setModified(true);
    }

    @Override
    public boolean initialize(RunTimeWindow runTimeWindow) {
        if (!super.initialize(runTimeWindow)) {
            return false;
        }
        this.getCompositeRelease();
        int n = this._elemVector.size();
        this.b = new Element[n];
        for (int i = 0; i < n; ++i) {
            this.b[i] = this._elemVector.elementAt(i);
            if (this.b[i] != null) continue;
            return false;
        }
        if (this.c == 0) {
            RssAlt rssAlt = this._system.getAlternative();
            if (rssAlt == null) {
                return false;
            }
            n = rssAlt.getResOpSetSelection(this.getIndex());
            if (n == Integer.MIN_VALUE) {
                this._system.printErrorMessage("ReservoirElement.initialize: No Operation Set selected for reservoir " + this.getName());
                this._system.printErrorMessage("Check that an operation set has been selected for this reservoir in alternative " + rssAlt.getName());
                return false;
            }
            this.getReservoirOp(true);
            if (this.a == null) {
                this._system.printErrorMessage("ReservoirElement.initialize: Could not retrieve operations data for reservoir " + this.getName());
                return false;
            }
            return this.a.initializeCompute(runTimeWindow);
        }
        this.l = new ReservoirElement$StorageErrorFunc(this);
        this.m = new ReservoirElement$RelIntegrFunc(this);
        RssRun rssRun = this.getSystem().getRssRun();
        this.n = rssRun.getStorageOverrideType();
        this.o = null;
        ReleaseOverrides releaseOverrides = this.n == 5 ? this.getSystem().getRssRun().getStorageOverrides() : this.getSystem().getRssRun().getElevationStorageOverrides();
        if (releaseOverrides != null && (runTimeWindow = this.getStorageFunction().getTSRecordProxy(10)) != null) {
            this.o = releaseOverrides.getReleaseValues(runTimeWindow.getName());
        }
        this.p = this.getStorageFunction();
        return true;
    }

    @Override
    public boolean initForPostProcessing(RunTimeWindow runTimeWindow) {
        if (!super.initialize(runTimeWindow)) {
            return false;
        }
        this.getCompositeRelease();
        int n = this._elemVector.size();
        this.b = new Element[n];
        for (int i = 0; i < n; ++i) {
            this.b[i] = this._elemVector.elementAt(i);
            if (this.b[i] != null) continue;
            return false;
        }
        if (this.c == 0) {
            RssAlt rssAlt = this._system.getAlternative();
            if (rssAlt == null) {
                return false;
            }
            n = rssAlt.getResOpSetSelection(this.getIndex());
            if (n == Integer.MIN_VALUE) {
                this._system.printErrorMessage("ReservoirElement.initialize: No Operation Set selected for reservoir " + this.getName());
                this._system.printErrorMessage("Check that an operation set has been selected for this reservoir in alternative " + rssAlt.getName());
                return false;
            }
            this.getReservoirOp(true);
            if (this.a == null) {
                this._system.printErrorMessage("ReservoirElement.initialize: Could not retrieve operations data for reservoir " + this.getName());
                return false;
            }
            return this.a.initForPostProcessing(runTimeWindow);
        }
        RssRun rssRun = this.getSystem().getRssRun();
        this.n = rssRun.getStorageOverrideType();
        this.o = null;
        ReleaseOverrides releaseOverrides = this.n == 5 ? this.getSystem().getRssRun().getStorageOverrides() : this.getSystem().getRssRun().getElevationStorageOverrides();
        if (releaseOverrides != null && (runTimeWindow = this.getStorageFunction().getTSRecordProxy(10)) != null) {
            this.o = releaseOverrides.getReleaseValues(runTimeWindow.getName());
        }
        this.p = this.getStorageFunction();
        return true;
    }

    public boolean prepRegulatedFlowCompute() {
        Object object;
        int n = this._elemVector.size();
        for (int i = 1; i < n; ++i) {
            object = this._elemVector.elementAt(i);
            if (!(object instanceof ReservoirOutletElement)) continue;
            ((Element)object).setFunction(null);
        }
        object = this._elemVector.elements();
        while (object.hasMoreElements()) {
            Element element = (Element)object.nextElement();
            element.setActive(true, true);
        }
        this._function = null;
        this.c = 0;
        this.setActive(true);
        return true;
    }

    public boolean prepCumLocFlowCompute() {
        Enumeration<Element> enumeration = this._elemVector.elements();
        while (enumeration.hasMoreElements()) {
            Element element = enumeration.nextElement();
            element.setActive(false, true);
        }
        this.e = new CumLocFunction(this);
        this._function = this.e;
        this.c = 4;
        this.setActive(true, false);
        return true;
    }

    public boolean prepUnregulatedFlowCompute(boolean bl) {
        Element element;
        int n;
        int n2 = this._elemVector.size();
        for (n = 0; n < n2; ++n) {
            element = this._elemVector.elementAt(n);
            element.setActive(false, true);
        }
        this.d = new Junction(this);
        this._function = this.d;
        this.c = 1;
        this.setActive(true, false);
        if (bl) {
            for (n = 0; n < n2; ++n) {
                RssNode rssNode;
                element = this._elemVector.elementAt(n);
                if (!(element instanceof DivertedOutletElement) || (rssNode = element.getDownstreamNode()) == null) continue;
                rssNode.setActive(false);
            }
        }
        return true;
    }

    public boolean prepHoldoutCompute() {
        this.prepUnregulatedFlowCompute(true);
        this.f = new HoldoutFunction(this);
        this._function = this.f;
        this.c = 2;
        this.setActive(true);
        return true;
    }

    public boolean prepPulseRoutingCompute(int n) {
        TSLocation tSLocation;
        int n2;
        int n3 = this._elemVector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            tSLocation = this._elemVector.elementAt(n2);
            tSLocation.setActive(false, true);
        }
        this.d = new Junction(this);
        this._function = this.d;
        this.c = 1;
        this.setActive(true, false);
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 == n) continue;
            tSLocation = this._elemVector.elementAt(n2);
            if ((tSLocation = tSLocation.getDownstreamNode()) == null) continue;
            tSLocation.setActive(false);
        }
        this._function = null;
        this.c = 3;
        tSLocation = this._elemVector.elementAt(n);
        if (tSLocation instanceof ReservoirOutletElement) {
            if (tSLocation instanceof DivertedOutletElement && ((Element)((DivertedOutletElement)tSLocation)).getDownstreamNode() == null) {
                tSLocation.setActive(false, true);
                return false;
            }
            tSLocation.setFunction(new PulseRoutingFunction((ReservoirOutletElement)tSLocation, true));
            n2 = tSLocation._elemVector.size();
            for (n = 0; n < n2; ++n) {
                Element element = tSLocation._elemVector.elementAt(n);
                element.setActive(false, true);
            }
            tSLocation.setActive(true, false);
        }
        this.setActive(true);
        return true;
    }

    public void setName() {
    }

    @Override
    public int computeHindcast(RunTimeWindow runTimeWindow, int n) {
        int n2;
        if (n != 0) {
            return super.computeHindcast(runTimeWindow, n);
        }
        int n3 = this._elemVector.size();
        Element[] elementArray = new Element[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            elementArray[n2] = this._elemVector.elementAt(n2);
            if (elementArray[n2] != null) continue;
            return 1;
        }
        RunTimeStep runTimeStep = new RunTimeStep(runTimeWindow);
        new RunTimeStep(runTimeWindow).flag = n;
        for (n2 = 0; n2 <= runTimeWindow.getNumLookbackSteps(); ++n2) {
            runTimeStep.setStep(n2);
            if (this.a.computeHindcastStep(runTimeStep) != 0) {
                this._system.printMessage("ReservoirElement.computeHindcast: Operations Error at step " + Integer.toString(n2));
                return 1;
            }
            for (int i = n3 - 1; i >= 0; --i) {
                if (elementArray[i].computeHindcastStep(runTimeStep) == 0) continue;
                this._system.printMessage("ReservoirElement.computeHindcast: Error at step " + Integer.toString(n2));
                return 1;
            }
        }
        for (n2 = 1; n2 < n3; ++n2) {
            Element element = this._elemVector.elementAt(n2);
            if (!(element instanceof DivertedOutletElement) || element.getDownstreamNode() == null || ((DivertedOutletElement)element).getReachElement().computeHindcast(runTimeWindow, n) == 0) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public int computeHindcastStep(RunTimeStep runTimeStep) {
        if (runTimeStep.flag != 0) {
            return super.computeHindcastStep(runTimeStep);
        }
        int n = this.b.length;
        if (this.a.computeHindcastStep(runTimeStep) != 0) {
            this._system.printMessage("ReservoirElement.computeHindcast: Operations Error at step " + Integer.toString(runTimeStep.step));
            return 1;
        }
        for (int i = n - 1; i >= 0; --i) {
            if (this.b[i].computeHindcastStep(runTimeStep) == 0) continue;
            this._system.printMessage("ReservoirElement.computeHindcast: Error at step " + Integer.toString(runTimeStep.step));
            return 1;
        }
        for (int i = 1; i < n; ++i) {
            Element element = this.b[i];
            if (!(element instanceof DivertedOutletElement) || element.getDownstreamNode() == null || ((DivertedOutletElement)element).getReachElement().computeHindcastStep(runTimeStep) == 0) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public int computeForecast(RunTimeWindow runTimeWindow, int n) {
        int n2;
        if (n != 0) {
            return super.computeForecast(runTimeWindow, n);
        }
        int n3 = this._elemVector.size();
        Element[] elementArray = new Element[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            elementArray[n2] = this._elemVector.elementAt(n2);
            if (elementArray[n2] != null) continue;
            return 1;
        }
        RunTimeStep runTimeStep = new RunTimeStep(runTimeWindow);
        new RunTimeStep(runTimeWindow).flag = n;
        this.getStorageFunction().initForecast(runTimeWindow.getNumLookbackSteps());
        for (n2 = runTimeWindow.getNumLookbackSteps() + 1; n2 <= runTimeWindow.getNumSteps(); ++n2) {
            runTimeStep.setStep(n2);
            ((Storage)elementArray[0]._function).computeInflow(runTimeStep);
        }
        for (n2 = runTimeWindow.getNumLookbackSteps() + 1; n2 <= runTimeWindow.getNumSteps(); ++n2) {
            runTimeStep.setStep(n2);
            ((Storage)elementArray[0]._function).computeInflow(runTimeStep);
            Storage storage = (Storage)elementArray[0]._function;
            double d = storage.getPreviousElevation(runTimeStep);
            double[] dArray = storage.getTSArray(10);
            double[] dArray2 = dArray;
            dArray[n2] = d;
            double d2 = d;
            for (int i = 0; i < 15; ++i) {
                for (int j = n3 - 1; j >= 0; --j) {
                    if (elementArray[j].computeForecastStep(runTimeStep) == 0) continue;
                    this._system.printMessage("ReservoirElement.computeForecast: Error at step " + Integer.toString(n2));
                    return 1;
                }
                double d3 = storage.getElevation(runTimeStep);
                if (i == 0) {
                    d2 = d3;
                    continue;
                }
                double d4 = d3 - d2;
                d2 += d4 * 0.67;
                if (Math.abs(d4) < 0.001) break;
                dArray2[n2] = d2;
            }
            if (this.o == null) continue;
            this.overrideStorage(runTimeStep, storage);
        }
        for (n2 = 1; n2 < n3; ++n2) {
            Element element = this._elemVector.elementAt(n2);
            if (!(element instanceof DivertedOutletElement) || element.getDownstreamNode() == null || ((DivertedOutletElement)element).getReachElement().computeForecast(runTimeWindow, n) == 0) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        if (runTimeStep.flag != 0) {
            return super.computeForecastStep(runTimeStep);
        }
        int n = this._elemVector.size();
        Storage storage = (Storage)this.b[0]._function;
        storage.computeInflow(runTimeStep);
        if (runTimeStep.isPerAvgTimeStep()) {
            this.m.a(runTimeStep);
        } else {
            this.l.a(runTimeStep);
            double d = this.l.b();
            double d2 = this.l.a();
            double d3 = RmaMath.bisectRoot((RmaSVFunction)this.l, (double)d, (double)d2, (int)200, (double)0.001);
            if (Logger.canDebug((String)"ResSimOperations")) {
                System.out.println("ResElem Cap bisect search " + runTimeStep.dateTimeString() + ", " + d3);
            }
        }
        for (int i = 1; i < n; ++i) {
            Element element = this.b[i];
            if (!(element instanceof DivertedOutletElement) || element.getDownstreamNode() == null || ((DivertedOutletElement)element).getReachElement().computeForecastStep(runTimeStep) == 0) continue;
            return 1;
        }
        if (this.o != null) {
            this.overrideStorage(runTimeStep, storage);
        }
        return 0;
    }

    private void overrideStorage(RunTimeStep runTimeStep, Storage storage) {
        if (this.o == null) {
            return;
        }
        Double d = (Double)this.o.get(new Integer(runTimeStep.valueMinutes()));
        if (d != null && d != Double.NEGATIVE_INFINITY) {
            double d2;
            double d3;
            if (this.n == 5) {
                d3 = d;
                d2 = storage.storageToElevation(d3);
            } else {
                d2 = d;
                d3 = storage.elevationToStorage(d2);
            }
            storage.a.array[runTimeStep.step] = d3;
            storage.b.array[runTimeStep.step] = d2;
        }
    }

    public int initPumpbackStep(RunTimeStep runTimeStep) {
        return this.a.initPumpbackStep(runTimeStep);
    }

    public int computePumpbackStep(RunTimeStep runTimeStep) {
        return this.a.computePumpbackStep(runTimeStep);
    }

    void createDefaultElements() {
        this.removeAllChildElements();
        Element element = this._system.newElement(false);
        element.setParentElement(this);
        element.setName("Pool");
        Element element2 = element;
        element2.setFunction(FunctionFactory.a(element2, "Storage"));
        this.addChildElement(element);
        this.createDefaultReservoirOp();
    }

    void createDefaultReservoirOp() {
        DbfFile dbfFile = this._system.getResOpDbfFile();
        if (dbfFile == null) {
            this._system.printErrorMessage("createDefaultReservoirOp: failed to get DbfFile from system");
            return;
        }
        dbfFile.getHeader().getNumRecords();
        AsciiSerializableDbfHeader asciiSerializableDbfHeader = new AsciiSerializableDbfHeader();
        asciiSerializableDbfHeader = asciiSerializableDbfHeader.buildDbfRecordSet();
        DbfRecord dbfRecord = new Vector();
        ReservoirOp reservoirOp = new ReservoirOp();
        reservoirOp.setName(this.getResOpName());
        reservoirOp.setDescription("Operations for " + this.getName());
        reservoirOp.setReservoirElement(this);
        int n = this._system.getNextResOpId();
        reservoirOp.setIndex(n);
        dbfRecord.add(n);
        dbfRecord.add(this.getResOpName());
        dbfRecord.add(reservoirOp.getDescription());
        dbfRecord.add(reservoirOp);
        dbfRecord = new DbfRecord(dbfRecord);
        asciiSerializableDbfHeader.add(dbfRecord);
        dbfFile = dbfFile.writeRecords((DbfRecordSet)asciiSerializableDbfHeader);
        if (dbfFile == null) {
            this._system.printErrorMessage("createDefaultReservoirOp: failed to get a recordSet back from writeRecords");
            return;
        }
        this._resOpDbfId = n;
        this.a = reservoirOp;
    }

    public void resetOpsIds() {
        this._resOpDbfId = -1;
        this._resSysOpId = -1L;
    }

    private void createDefaultReservoirOpInDataList() {
        CommonDataList commonDataList = this._system.getReservoirOpDataList();
        if (commonDataList == null) {
            this._system.printMessage("Error ReservoirElement:createDefaultReservoirOp - cannot get DataList");
            return;
        }
        ReservoirOp reservoirOp = (ReservoirOp)commonDataList.getObject(this.getResOpName());
        if (!(reservoirOp != null || (reservoirOp = (ReservoirOp)commonDataList.newDataObject(this.getResOpName(), this.getDescription() + ": Operations")) != null && commonDataList.addNewObject((DataObject)reservoirOp))) {
            this._system.printMessage("Error ReservoirElement:createDefaultReservoirOp - Failed to add new reservoirOp for " + this.getName());
            return;
        }
        this._resOpId = reservoirOp.getId();
        this.a = reservoirOp;
    }

    public String getResOpName() {
        if (this.i == null) {
            this.i = this._system.getName() + "_" + this.getName();
        }
        return this.i;
    }

    public void setReservoirOp(ReservoirOp reservoirOp) {
        if (reservoirOp == null) {
            return;
        }
        DbfFile dbfFile = this._system.getResOpDbfFile();
        if (dbfFile == null) {
            this._system.printErrorMessage("Error ReservoirElement:setReservoirOp - cannot get DBFFile");
        }
        reservoirOp.setReservoirElement(this);
        this._resOpDbfId = this._system.saveReservoirOp(reservoirOp, -1);
        this.a = reservoirOp;
    }

    public ReservoirOp getReservoirOp() {
        return this.getReservoirOp(true);
    }

    ReservoirOp getReservoirOp(boolean bl) {
        boolean bl2 = false;
        if (this.a == null) {
            if (!this.getReservoirOpFromDbf()) {
                if (Logger.canDebug((String)"ResSimOperations")) {
                    System.out.println(this.getName() + ".getReservoirOp: didn't find ResOp in DBFFile");
                }
                this.getReservoirOpFromDataList();
            }
            if (this.a == null) {
                System.out.println(this.getName() + ".getReservoirOp: failed to find my Reservoir Op. id=" + this._resOpId);
                this.createDefaultReservoirOp();
                if (this.a == null) {
                    return null;
                }
            }
            bl2 = true;
        }
        if (bl || bl2) {
            RssAlt rssAlt = this._system.getAlternative();
            if (rssAlt != null) {
                this.a.setActiveOpSet(rssAlt.getResOpSetSelection(this.getIndex()));
            }
            this.a.setReservoirElement(this);
        }
        return this.a;
    }

    protected boolean getReservoirOpFromDbf() {
        String[] stringArray;
        if (this._resOpDbfId == -1) {
            return false;
        }
        Object object = this._system.getResOpDbfFile();
        if (object == null) {
            return false;
        }
        boolean bl = Logger.canDebug((String)"ResSimOperations");
        if (bl) {
            System.out.println(this.getName() + ".getReservoirOpFromDbf: getting ResOp id=" + this._resOpDbfId + " from " + object.getPath());
        }
        AsciiSerializableDbfHeader asciiSerializableDbfHeader = new AsciiSerializableDbfHeader();
        DbfRecordQuery dbfRecordQuery = new Integer[1];
        DbfRecordQuery dbfRecordQuery2 = dbfRecordQuery;
        dbfRecordQuery[0] = this._resOpDbfId;
        dbfRecordQuery2 = asciiSerializableDbfHeader.buildDbfRecordIdQuery((Serializable[])dbfRecordQuery2);
        dbfRecordQuery2 = object.queryRecords(dbfRecordQuery2);
        if ((dbfRecordQuery2 = dbfRecordQuery2.get(0)) == null) {
            stringArray = new String[]{this.getResOpName().toUpperCase()};
            dbfRecordQuery2 = asciiSerializableDbfHeader.buildDbfRecordNameQuery((Serializable[])stringArray);
            dbfRecordQuery2 = object.queryRecords(dbfRecordQuery2);
            if ((dbfRecordQuery2 = dbfRecordQuery2.get(0)) != null) {
                object = dbfRecordQuery2.getData();
                if (object.size() > 0 && (object = object.get(0)) instanceof Double) {
                    object = (Double)object;
                    this._resOpDbfId = object.intValue();
                }
            } else {
                this._system.printErrorMessage("getReservoirOpFromDbf: no DbfRecord returned for id =" + this._resOpDbfId + " or DbfRecName=" + this.getResOpName());
                return false;
            }
        }
        if ((stringArray = dbfRecordQuery2.getData()).size() < 4) {
            this._system.printErrorMessage("getReservoirOpFromDbf: failed to get enough data back from DbfRecord.");
            this._system.printErrorMessage("getReservoirOpFromDbf: expected at least 4 got " + stringArray.size());
            dbfRecordQuery2.printData();
            return false;
        }
        object = stringArray.get(3);
        if (!(object instanceof String)) {
            this._system.printErrorMessage("getReservoirOpFromDbf: expected a String in the 4th position got a " + String.valueOf(object));
            return false;
        }
        this.a = new ReservoirOp();
        boolean bl2 = this._system.deserializeString((AsciiSerializable)this.a, (String)object);
        if (this._resOpDbfId != ((Number)stringArray.get(0)).intValue()) {
            this._system.printMessage("getReservoirOpFromDbf: WARNING: asked for ResOpID=" + this._resOpDbfId + " got from DBFFile ResOpId=" + ((Number)stringArray.get(0)).intValue());
        }
        if (bl && !bl2) {
            this._system.printMessage("getReservoirOpFromDbf: WARNING failed to deserialize operations for " + this.getName() + " Record id=" + this._resOpDbfId);
        }
        return bl2;
    }

    private boolean getReservoirOpFromDataList() {
        CommonDataList commonDataList;
        if (Logger.canDebug((String)"ResSimOperations")) {
            System.out.println(this.getName() + ".getReservoirOpFromDataList: getting ResOp id=" + this._resOpId);
        }
        if ((commonDataList = this._system.getReservoirOpDataList()) == null) {
            this._system.printMessage(this.getName() + ".getReservoirOpFromDataList: cannot get DataList");
            return false;
        }
        this.a = this._resOpId == -1L ? (ReservoirOp)commonDataList.getObject(this.getResOpName()) : (ReservoirOp)commonDataList.getObject(this._resOpId);
        if (this.a != null) {
            this.a.setIndex(this._system.getNextResOpId());
            this.a.setId(this.a.getIndex());
            this._resOpDbfId = this._system.saveReservoirOp(this.a, this.a.getIndex());
            this._system.setModified(true);
        }
        return this.a != null;
    }

    public void setReservoirSysOp(ReservoirSysOp reservoirSysOp) {
        this.j = reservoirSysOp;
        this._resSysOpId = this.j != null ? (long)this.j.getIndex() : -1L;
        this.setModified(true);
    }

    public ReservoirSysOp getReservoirSysOp() {
        if (this._resSysOpId < 0L) {
            return null;
        }
        if (this.j == null) {
            if (!this.getReservoirSysOpFromDbf() && Logger.canDebug((String)"ResSimOperations")) {
                System.out.println(this.getName() + ".getReservoirSysOp: didn't find ResSysOp in DBFFile");
            }
            if (this.j == null) {
                System.out.println(this.getName() + ".getReservoirSysOp: failed to find my Reservoir Sys Op. id=" + this._resSysOpId);
                this._resSysOpId = -1L;
                if (this.j == null) {
                    return null;
                }
            }
            this.j.setRssSystem(this._system);
            RssAlt rssAlt = this._system.getAlternative();
            if (rssAlt != null) {
                this.j.setActiveOpSet(rssAlt.getResSysOpSetSelection(this.getIndex()));
            }
        }
        return this.j;
    }

    protected boolean getReservoirSysOpFromDbf() {
        if (this._resSysOpId == -1L) {
            return false;
        }
        Object object = this._system.getResSysOpDbfFile();
        if (object == null) {
            return false;
        }
        boolean bl = Logger.canDebug((String)"ResSimOperations");
        if (bl) {
            System.out.println(this.getName() + ".getReservoirSysOpFromDbf: getting ResSysOp " + this._resSysOpId + " from " + object.getPath());
        }
        Object object2 = new AsciiSerializableDbfHeader();
        Serializable[] serializableArray = new Integer[]{new Integer((int)this._resSysOpId)};
        object2 = object2.buildDbfRecordIdQuery(serializableArray);
        object = object.queryRecords((DbfRecordQuery)object2);
        if ((object = object.get(0)) == null) {
            this._system.printErrorMessage("getReservoirSysOpFromDbf: no DbfRecord returned for id =" + this._resSysOpId);
            return false;
        }
        object2 = object.getData();
        if (((Vector)object2).size() < 4) {
            this._system.printErrorMessage("getReservoirSysOpFromDbf: failed to get enough data back from DbfRecord.");
            this._system.printErrorMessage("getReservoirSysOpFromDbf: expected at least 4 got " + ((Vector)object2).size());
            object.printData();
            return false;
        }
        object = ((Vector)object2).get(3);
        if (!(object instanceof String)) {
            this._system.printErrorMessage("getReservoirSysOpFromDbf: expected a String in the 4th position got a " + String.valueOf(object));
            return false;
        }
        this.j = new ReservoirSysOp();
        boolean bl2 = this._system.deserializeString(this.j, (String)object);
        if (this._resSysOpId != (long)((Number)((Vector)object2).get(0)).intValue()) {
            this._system.printMessage("getReservoirSysOpFromDbf: WARNING: asked for ResSysOpID=" + this._resSysOpId + " got from DBFFile ResSysOpId=" + ((Number)((Vector)object2).get(0)).intValue());
        }
        return bl2;
    }

    @Override
    public void addNode(RssNode rssNode, int n) {
        if (this._nodeVector.contains(rssNode)) {
            return;
        }
        super.addNode(rssNode, n);
        Element element = this._elemVector.elementAt(0);
        if (n == 1) {
            element.addNode(rssNode, n);
            return;
        }
        element = new ReservoirDamElement(this._system, this._system.nextElementIndex());
        element.setParentElement(this);
        ((ReservoirDamElement)element).buildDefaultElements();
        StreamAlignment streamAlignment = this._system.getAlignment();
        if (streamAlignment != null) {
            element.setName("Dam at " + streamAlignment.findReach(rssNode.getStreamIndex()).getName());
        } else {
            element.setName("Dam");
        }
        this.addChildElement(element);
        element.addNode(rssNode, n);
    }

    public Element getStorageElement() {
        return this._elemVector.elementAt(0);
    }

    @Override
    public Storage getStorageFunction() {
        Element element = this._elemVector.elementAt(0);
        return (Storage)element.getFunction();
    }

    public void setStorageFunction(Storage storage) {
        Element element = this._elemVector.elementAt(0);
        element.setFunction(storage);
    }

    @Deprecated
    public void setEvaporationTS(boolean bl) {
        boolean bl2;
        Storage storage = this.getStorageFunction();
        boolean bl3 = bl2 = storage.getTSRecordProxy(EVAPORATION, true) == null;
        if (bl) {
            if (bl2) {
                storage.addTSRecord(this.getName() + KNOWN_EVAPORATION, EVAPORATION, true);
                return;
            }
        } else if (!bl2) {
            storage.removeTSRecord(this.getName() + KNOWN_EVAPORATION);
        }
    }

    public WorldRegion getRegion() {
        return this._region;
    }

    @Override
    public WorldPt getReferencePt() {
        return this._referencePt;
    }

    public void setReferencePt(WorldPt worldPt) {
        this._referencePt = new WorldPt(worldPt);
    }

    public void setRegion(WorldRegion worldRegion) {
        if (worldRegion == null) {
            return;
        }
        this._region = worldRegion;
        if (this._region.pts.size() > 1 && this._referencePt == null) {
            worldRegion = (WorldPt)this._region.pts.elementAt(1);
            this._referencePt = (WorldPt)worldRegion.clone();
        }
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Deprecated
    public AdjustableFlow getGatedFlowFunction() {
        return null;
    }

    @Override
    public String toString() {
        String string = this.getName();
        if (string != null) {
            return string;
        }
        return super.toString();
    }

    public boolean hasDownstreamGoals(int n) {
        ReservoirOp reservoirOp = this.getReservoirOp(false);
        if (reservoirOp == null) {
            return false;
        }
        return reservoirOp.hasDownstreamGoals(n);
    }

    @Override
    public List getDownstreamNodes(List arrayList) {
        if (this.c != 0 && this.c != 3) {
            return super.getDownstreamNodes(arrayList);
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = this._elemVector.get(i);
            if (!(element instanceof ReservoirOutletElement)) continue;
            element.getDownstreamNodes(arrayList);
        }
        return arrayList;
    }

    public Hashtable getDownstreamRuleNodes(int n) {
        Hashtable hashtable = new Hashtable();
        ReservoirOp reservoirOp = this.getReservoirOp(false);
        if (reservoirOp != null) {
            reservoirOp.getDownstreamRuleNodes(n, hashtable);
        }
        return hashtable;
    }

    public void getStorageZones(int n, List<StorageZone> list) {
        if (this.a == null) {
            return;
        }
        this.a.getStorageZones(n, list);
    }

    public StorageZone getStorageZone(int n, int n2) {
        if (this.a == null) {
            return null;
        }
        ArrayList<StorageZone> cloneable2 = new ArrayList<StorageZone>();
        this.a.getStorageZones(n, cloneable2);
        for (StorageZone storageZone : cloneable2) {
            if (storageZone.getIndex() != n2) continue;
            return storageZone;
        }
        return null;
    }

    public void getRules(int n, List list) {
        if (this.a == null) {
            return;
        }
        this.a.getRules(n, list);
    }

    public List<ConditionalBlockRef> getConditionalBlockRefs(int n, List<ConditionalBlockRef> list) {
        ReservoirOp reservoirOp = this.getReservoirOp();
        if (reservoirOp == null) {
            return null;
        }
        OpSet opSet = reservoirOp.getOperationSet(n);
        if (opSet == null) {
            return null;
        }
        if (list == null) {
            list = new ArrayList<ConditionalBlockRef>();
        }
        return opSet.getConditionals(list);
    }

    public void getDownstreamRules(int n, List list) {
        if (this.a == null) {
            return;
        }
        this.a.getDownstreamRules(n, list);
    }

    public void getSystemHydropowerOpRules(int n, ArrayList arrayList) {
        if (this.a == null) {
            return;
        }
        this.a.getSystemHydropowerOpRules(n, arrayList);
    }

    protected double getSystemEnergyGeneration(RunTimeStep runTimeStep) {
        double d = 0.0;
        Vector vector = this.getElementsByClass(AdjustableFlow.class, null);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            NamedType namedType = (Element)vector.get(i);
            if (!(namedType = (AdjustableFlow)namedType.getFunction()).hasPowerPlant() || (namedType = namedType.getTSContainer(53)) == null) continue;
            d += namedType.array[runTimeStep.step];
        }
        return d;
    }

    protected double getSystemGenerationLimits(RunTimeStep runTimeStep, SystemHydropowerRule object, double[] dArray, double[] dArray2, int n, int n2) {
        double d = 0.0;
        object = this.getElementsByClass(AdjustableFlow.class, null);
        int n3 = ((Vector)object).size();
        for (int i = 0; i < n3; ++i) {
            NamedType namedType = (Element)((Vector)object).get(i);
            if (!(namedType = (AdjustableFlow)namedType.getFunction()).hasPowerPlant() || (namedType = namedType.getTSContainer(57)) == null) continue;
            d += namedType.array[runTimeStep.step] * (double)runTimeStep.getTimeStepMinutes() / 60.0 * (double)n2;
        }
        dArray[n] = d;
        dArray2[n] = 0 * n2;
        return d;
    }

    public double getSystemGenerationLimits2(RunTimeStep runTimeStep, OpRule object, double[] dArray, double[] dArray2, int n, int n2) {
        double d = 0.0;
        object = this.getElementsByClass(AdjustableFlow.class, null);
        int n3 = ((Vector)object).size();
        Arrays.fill(dArray, 0.0);
        Arrays.fill(dArray2, 0.0);
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        int n4 = runTimeStep.getTotalNumSteps();
        for (int i = n; i < n2; ++i) {
            runTimeStep2.step = runTimeStep.step + (i - n);
            if (runTimeStep2.step > n4) {
                runTimeStep2.step = n4;
            }
            for (int j = 0; j < n3; ++j) {
                Element element = (Element)((Vector)object).get(j);
                RssTSLocationObject rssTSLocationObject = (AdjustableFlow)element.getFunction();
                if (!((AdjustableFlow)rssTSLocationObject).hasPowerPlant()) continue;
                PowerPlant powerPlant = ((AdjustableFlow)rssTSLocationObject).getPowerPlant();
                rssTSLocationObject = this.a.getController(element);
                double d2 = element.getEffectiveElev(runTimeStep2);
                double d3 = powerPlant.getTailwaterElevation(runTimeStep2);
                if (RMAConst.isValidValue((double)d2) && RMAConst.isValidValue((double)d3)) {
                    dArray[i] = powerPlant.calculatePower(((OpController)rssTSLocationObject).getCurMaxOpValue((RunTimeStep)runTimeStep2).value, d2, d3);
                    dArray2[i] = powerPlant.calculatePower(((OpController)rssTSLocationObject).getCurMinOpValue((RunTimeStep)runTimeStep2).value, d2, d3);
                } else {
                    dArray[i] = powerPlant.getCapacity();
                }
                int n5 = i;
                dArray[n5] = dArray[n5] * ((double)runTimeStep.getTimeStepMinutes() / 60.0);
                int n6 = i;
                dArray2[n6] = dArray2[n6] * ((double)runTimeStep.getTimeStepMinutes() / 60.0);
                d += dArray[i];
            }
        }
        return d;
    }

    public void calcPeriodRelAndGenLimits(RunTimeStep runTimeStep, int n, int n2, ReservoirLimitSet reservoirLimitSet, OpRule opRule) {
        if (runTimeStep == null || reservoirLimitSet == null) {
            return;
        }
        List list = this.getReservoirOutletElements(null);
        int n3 = list.size();
        reservoirLimitSet.a(n3, n2);
        reservoirLimitSet.a();
        Vector vector = this.getElementsByClass(AdjustableFlow.class, null);
        int n4 = vector.size();
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        int n5 = runTimeStep.getTotalNumSteps();
        this.a.getController();
        for (int i = n; i < n2; ++i) {
            NamedType namedType;
            int n6;
            runTimeStep2.step = runTimeStep.step + (i - n);
            if (runTimeStep2.step > n5) {
                runTimeStep2.step = n5;
            }
            this.a.testOperationStep(runTimeStep2, 1, 0, opRule);
            for (n6 = 0; n6 < n3; ++n6) {
                namedType = (Element)list.get(n6);
                namedType = this.a.getController((Element)namedType);
                reservoirLimitSet.b[n6][i] = namedType.getEstimatedCurLimit(0, runTimeStep2);
                reservoirLimitSet.a[n6][i] = namedType.getEstimatedCurLimit(2, runTimeStep2);
            }
            for (n6 = 0; n6 < n4; ++n6) {
                namedType = (Element)vector.get(n6);
                NamedType namedType2 = (AdjustableFlow)namedType.getFunction();
                if (!namedType2.hasPowerPlant()) continue;
                namedType2 = namedType2.getPowerPlant();
                this.a.getController((Element)namedType);
                double d = namedType.getEffectiveElev(runTimeStep2);
                double d2 = namedType2.getTailwaterElevation(runTimeStep2);
                if (!RMAConst.isValidValue((double)d)) continue;
                RMAConst.isValidValue((double)d2);
            }
        }
    }

    public double calcPumpbackVolCap(RunTimeStep runTimeStep, int n, int n2) {
        double d = this.getStorageFunction().getPreviousElevation(runTimeStep);
        List list = this.a.getActiveRules(runTimeStep, d, null);
        int n3 = list.size();
        double d2 = 0.0;
        ArrayList<Pump> arrayList = new ArrayList<Pump>();
        for (int i = 0; i < n3; ++i) {
            Pump pump;
            OpRule opRule = (OpRule)list.get(i);
            if (!(opRule instanceof PumpOpRule) || arrayList.contains(pump = ((PumpOpRule)(opRule = (PumpOpRule)opRule)).getPump())) continue;
            arrayList.add(pump);
            double d3 = ((PumpOpRule)opRule).getMaxPumpVol(runTimeStep, n, n2);
            d2 += d3;
        }
        return d2;
    }

    public double calcPumpbackVolMin(RunTimeStep runTimeStep, int n, int n2) {
        double d = this.getStorageFunction().getPreviousElevation(runTimeStep);
        List list = this.a.getActiveRules(runTimeStep, d, null);
        int n3 = list.size();
        double d2 = 0.0;
        ArrayList<Pump> arrayList = new ArrayList<Pump>();
        for (int i = 0; i < n3; ++i) {
            Pump pump;
            OpRule opRule = (OpRule)list.get(i);
            if (!(opRule instanceof PumpOpRule) || arrayList.contains(pump = ((PumpOpRule)(opRule = (PumpOpRule)opRule)).getPump())) continue;
            arrayList.add(pump);
            double d3 = ((PumpOpRule)opRule).getMinPumpVol(runTimeStep, n, n2);
            d2 += d3;
        }
        return d2;
    }

    public double getExpectedNetInflowVol(RunTimeStep runTimeStep, int n, OpRule opRule) {
        double d = 0.0;
        Storage storage = this.getStorageFunction();
        double d2 = storage.getElevationEst(runTimeStep);
        double d3 = storage.elevationToStorage(d2);
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        if (!RMAConst.isValidValue((double)d2)) {
            return 0.0;
        }
        int n2 = runTimeStep.getTotalNumSteps();
        int n3 = runTimeStep.getTimeStepSeconds();
        for (int i = 1; i <= n; ++i) {
            runTimeStep2.step = runTimeStep.step + i;
            if (runTimeStep2.step > n2) {
                runTimeStep2.step = n2;
            }
            storage.getNetInflow(runTimeStep2);
            double d4 = storage.getNetInflowVolume(runTimeStep2);
            this.a.getGuideCurveStorage(runTimeStep2);
            this.a.testOperationStep(runTimeStep2, 1, 8, opRule, d2);
            double d5 = this.a.getController().getCurMinOpValue((RunTimeStep)runTimeStep2).value;
            double d6 = d5 * (double)n3 / Storage.DSDT_TO_Q;
            d2 = storage.storageToElevation(d3 += (d += d4 - d6));
        }
        return d;
    }

    @Override
    public void clearTSProxyList() {
        super.clearTSProxyList();
        if (this.a == null) {
            this.getReservoirOp();
        }
        if (this.a != null) {
            this.a.clearTSProxyList();
        }
    }

    @Override
    public void updateTSProxyList() {
        super.updateTSProxyList();
        this.getReservoirOp();
        if (this.a != null) {
            this.a.updateTSProxyList();
        }
    }

    @Override
    public Vector getActiveTSProxies(Vector vector, int n) {
        vector = super.getActiveTSProxies(vector, n);
        if (this.c == 0) {
            this.getReservoirOp();
            if (this.a == null) {
                return vector;
            }
            this.a.getActiveTSRecordProxies(vector, n);
        }
        return vector;
    }

    @Override
    public Vector getTSRecordProxies() {
        Vector vector = super.getTSRecordProxies();
        if (this.c == 0) {
            if (this.a == null) {
                this.getReservoirOp();
            }
            if (this.a == null) {
                return vector;
            }
            this.a.getActiveTSRecordProxies(vector, 0);
        }
        return vector;
    }

    public boolean importFrom(ReservoirImport reservoirImport, StringBuffer stringBuffer) {
        this.getStorageElement();
        ReservoirElement reservoirElement = (ReservoirElement)reservoirImport.b.get((int)0).b;
        if (reservoirElement == null) {
            stringBuffer.append("<font=+0 color=red> Import Failed. Import from Element is not a Reservoir</font><br>");
            System.out.println("importFrom: failed import. Import From Element is not a Reservoir ");
            return false;
        }
        this.setDescription(reservoirElement.getDescription());
        HashMap<intContainer, intContainer> hashMap = new HashMap<intContainer, intContainer>();
        hashMap.put(new intContainer(reservoirElement.getIndex()), new intContainer(this.getIndex()));
        if (Logger.canDebug((String)"ResSimImport")) {
            System.out.println("addIdMapping: mapped " + reservoirElement.getIndex() + " (" + String.valueOf(reservoirElement) + ") to " + this.getIndex() + " (" + String.valueOf(this) + ")");
        }
        ArrayList<RuleResolution> arrayList = new ArrayList<RuleResolution>();
        for (int i = 0; i < reservoirImport.b.size(); ++i) {
            ElementAssignmentContainer elementAssignmentContainer = reservoirImport.b.get(i);
            elementAssignmentContainer = new ElementAssignmentContainer(elementAssignmentContainer.a, elementAssignmentContainer.b);
            if (arrayList.contains(elementAssignmentContainer)) continue;
            arrayList.add((RuleResolution)elementAssignmentContainer);
        }
        if (!this.importPhysicalElements(reservoirElement, arrayList, stringBuffer, hashMap)) {
            stringBuffer.append("<font=+0 color=red> Import Failed. Failed to import Physical Elements for Reservoir " + this.getName() + "</font><br");
            System.out.println("importFrom: failed to import the Physical Elements for Reservoir " + this.getName());
            return false;
        }
        if (!this.importOperations(reservoirElement, reservoirImport, stringBuffer, hashMap)) {
            stringBuffer.append("<font=+0 color=red> Import Failed. Failed to import Operations for Reservoir " + this.getName() + "</font><br");
            System.out.println("importFrom: failed to import the Operations for Reservoir " + this.getName());
            return false;
        }
        this.importObservedData(reservoirElement, stringBuffer);
        this.setModified(true);
        this.getSystem().setModified(true);
        return true;
    }

    private boolean importPhysicalElements(ReservoirElement namedType, List list, StringBuffer stringBuffer, Map map) {
        boolean bl = Logger.canDebug((String)"ResSimImport");
        if (bl) {
            System.out.println("importPhysicalElements: importing for Reservoir " + this.getName() + " have " + list.size() + " user selected elements to assign");
        }
        Object object = this.getStorageElement();
        namedType = namedType.getStorageElement();
        this.addIdMapping(map, (Element)namedType, (Element)object);
        namedType = (Storage)((RssTSLocationObject)namedType.getFunction()).clone();
        namedType.setElement(this);
        ((Element)object).setFunction((Function)namedType);
        for (int i = 0; i < list.size(); ++i) {
            int n;
            Element element;
            NamedType namedType2;
            Object object2;
            object = (ElementAssignmentContainer)list.get(i);
            if (((ElementAssignmentContainer)object).a instanceof ReservoirDamElement && ((ElementAssignmentContainer)object).b instanceof ReservoirDamElement) {
                namedType = (ReservoirDamElement)((ElementAssignmentContainer)object).a;
                object = (ReservoirDamElement)((ElementAssignmentContainer)object).b;
                stringBuffer.append("Importing Dam <b>" + object.getName() + "</b> into Dam <b>" + namedType.getName() + "</b><br>");
                this.addIdMapping(map, (Element)object, (Element)namedType);
                namedType.setName(object.getName());
                namedType.setDescription(object.getDescription());
                if (bl) {
                    System.out.println("importPhysicalElements: importing Dam " + object.getName() + " into " + namedType.getName());
                }
                object2 = namedType.getDamFunction();
                namedType2 = ((ReservoirDamElement)object).getDamFunction();
                ((Dam)object2).setComputesLeakage(namedType2.getComputesLeakage());
                ((Dam)object2).setLeakageValues((PairedValues)namedType2.getLeakageValues().clone());
                ((Dam)object2).setTopOfDam(namedType2.getTopOfDam());
                ((Dam)object2).setWeirCoef(namedType2.getWeirCoef());
                ((Dam)object2).setWidthOfDam(namedType2.getWidthOfDam());
                object2.setName(namedType2.getName());
                object2.setDescription(namedType2.getDescription());
                object2 = namedType.getElementVector();
                for (int j = ((Vector)object2).size() - 1; j >= 0; --j) {
                    namedType2 = (Element)((Vector)object2).get(j);
                    if (!(namedType2.getFunction() instanceof AdjustableFlow) && !(namedType2.getFunction() instanceof Spillway) && !(namedType2 instanceof OutletGroupElement)) continue;
                    namedType.removeChild((Element)namedType2);
                }
                element = namedType.getTailwaterElement();
                object2 = namedType.getDamElement();
                Element element2 = ((ReservoirDamElement)object).getTailwaterElement();
                namedType2 = ((ReservoirDamElement)object).getDamElement();
                this.addIdMapping(map, element2, element);
                this.addIdMapping(map, (Element)namedType2, (Element)object2);
                if (element.getFunction() instanceof Junction) {
                    element.setFunction(element2.getFunction());
                }
                object2 = ((Element)object).getElementVector();
                for (n = 0; n < ((Vector)object2).size(); ++n) {
                    namedType2 = (Element)((Vector)object2).get(n);
                    if (namedType2.getFunction() instanceof AdjustableFlow || namedType2.getFunction() instanceof Spillway) {
                        element = namedType.getSystem().newElement(false);
                        element.setName(namedType2.getName());
                        element.setFunction((Function)((RssTSLocationObject)namedType2.getFunction()).clone());
                        namedType.addChildElement(element);
                        this.addIdMapping(map, (Element)namedType2, element);
                        continue;
                    }
                    if (!(namedType2 instanceof OutletGroupElement) || this.importOutletGroup((Element)namedType, (OutletGroupElement)namedType2, map)) continue;
                    return false;
                }
                if (!((ReservoirDamElement)object).hasTailElev()) continue;
                namedType.setHasTailElev(true);
                continue;
            }
            if (!(((ElementAssignmentContainer)object).a instanceof DivertedOutletElement) || !(((ElementAssignmentContainer)object).b instanceof DivertedOutletElement)) continue;
            namedType = (DivertedOutletElement)((ElementAssignmentContainer)object).a;
            object = (DivertedOutletElement)((ElementAssignmentContainer)object).b;
            stringBuffer.append("Importing Diverted Outlet <b>" + object.getName() + "</b> into <b>" + namedType.getName() + "</b><br>");
            this.addIdMapping(map, (Element)object, (Element)namedType);
            namedType.setName(object.getName());
            namedType.setDescription(object.getDescription());
            if (bl) {
                System.out.println("importPhysicalElements: importing DivertedOutlet " + object.getName() + " into " + namedType.getName());
            }
            if (((Element)object).getFunction() != null) {
                namedType.setFunction((Function)((RssTSLocationObject)((Element)object).getFunction()).clone());
            }
            element = ((DivertedOutletElement)object).getReachElement();
            object2 = namedType.getReachElement();
            this.addIdMapping(map, element, (Element)object2);
            ((Element)object2).setFunction((Function)((RssTSLocationObject)element.getFunction()).clone());
            object2 = namedType.getElementVector();
            for (n = ((Vector)object2).size() - 1; n >= 0; --n) {
                namedType2 = (Element)((Vector)object2).get(n);
                if (!(namedType2.getFunction() instanceof AdjustableFlow) && !(namedType2.getFunction() instanceof Spillway) && !(namedType2 instanceof OutletGroupElement)) continue;
                namedType.removeChild((Element)namedType2);
            }
            this.addIdMapping(map, ((DivertedOutletElement)object).getTailwaterElement(), namedType.getTailwaterElement());
            object2 = ((Element)object).getElementVector();
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                namedType2 = (Element)((Vector)object2).get(n);
                if (namedType2.getFunction() instanceof AdjustableFlow || namedType2.getFunction() instanceof Spillway) {
                    element = namedType.getSystem().newElement(false);
                    element.setName(namedType2.getName());
                    element.setFunction((Function)((RssTSLocationObject)namedType2.getFunction()).clone());
                    namedType.addChildElement(element);
                    this.addIdMapping(map, (Element)namedType2, element);
                    continue;
                }
                if (!(namedType2 instanceof OutletGroupElement) || this.importOutletGroup((Element)namedType, (OutletGroupElement)namedType2, map)) continue;
                System.out.println("importPhysicalElements: failed to import OutletGroup" + namedType2.getName());
                return false;
            }
        }
        return true;
    }

    private void addIdMapping(Map map, Element element, Element element2) {
        if (element == null || element2 == null) {
            System.out.println("addIdMapping: WARNING null Element from=" + String.valueOf(element) + " to " + String.valueOf(element2));
        }
        if (Logger.canDebug((String)"ResSimImport")) {
            System.out.println("addIdMapping: mapped " + element.getIndex() + " (" + String.valueOf(element) + ") to " + element2.getIndex() + " (" + String.valueOf(element2) + ")");
        }
        map.put(new intContainer(element.getIndex()), new intContainer(element2.getIndex()));
    }

    private boolean importOutletGroup(Element element, OutletGroupElement outletGroupElement, Map map) {
        this.addIdMapping(map, outletGroupElement, element);
        if (Logger.canDebug((String)"ResSimImport")) {
            System.out.println("importOutletGroup: importing into " + element.getName());
        }
        OutletGroupElement outletGroupElement2 = new OutletGroupElement(element.getSystem(), element.getSystem().nextElementIndex());
        outletGroupElement2.setName(outletGroupElement.getName());
        outletGroupElement2.setDescription(outletGroupElement.getDescription());
        outletGroupElement2.setParentElement(element);
        outletGroupElement2.buildDefaultElements();
        element.addChildElement(outletGroupElement2);
        this.addIdMapping(map, outletGroupElement, outletGroupElement2);
        this.importOutletElement(outletGroupElement2, outletGroupElement, map);
        return true;
    }

    private boolean importOutletElement(Element element, Element element2, Map map) {
        Vector vector = element2.getElementVector();
        if (Logger.canDebug((String)"ResSimImport")) {
            System.out.println("importOutletElement: importing " + element2.getName() + " into " + element.getName());
        }
        for (int i = 0; i < vector.size(); ++i) {
            Element element3 = (Element)vector.get(i);
            if (element3 instanceof OutletGroupElement) {
                if (this.importOutletGroup(element, (OutletGroupElement)element3, map)) continue;
                System.out.println("importOutletElement: Failed to import Outlet Group " + element2.getName());
                return false;
            }
            if (!(element3.getFunction() instanceof AdjustableFlow) && !(element3.getFunction() instanceof Spillway)) continue;
            Element element4 = element.getSystem().newElement(false);
            element4.setName(element3.getName());
            element4.setFunction((Function)((RssTSLocationObject)element3.getFunction()).clone());
            element.addChildElement(element4);
            this.addIdMapping(map, element3, element4);
        }
        return true;
    }

    private boolean importOperations(ReservoirElement reservoirElement, ReservoirImport reservoirImport, StringBuffer stringBuffer, Map map) {
        Object object;
        boolean bl = Logger.canDebug((String)"ResSimImport");
        ReservoirOp reservoirOp = reservoirElement.getReservoirOp();
        ReservoirOp reservoirOp2 = this.getReservoirOp();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (reservoirOp != null && reservoirOp2 != null) {
            Object object2;
            NamedType namedType;
            Object object3;
            if (bl) {
                System.out.println("importOperations: importing...");
            }
            reservoirOp = (ReservoirOp)((AbstractReservoirOp)reservoirOp).clone();
            if (bl) {
                System.out.println("importOperations: have " + reservoirImport.b.size() + " in ruleList");
            }
            block0: for (int i = 0; i < reservoirImport.b.size(); ++i) {
                Object object4 = reservoirImport.b.get(i);
                if (((RuleResolution)object4).c == null) {
                    if (!bl) continue;
                    System.out.println("importOperations: no ruleRef for " + String.valueOf(((RuleResolution)object4).d));
                    continue;
                }
                object = ((RuleResolution)object4).c.a();
                NamedType namedType2 = object instanceof OpRule ? (OpRule)object : null;
                if (namedType2 == null) {
                    if (!bl) continue;
                    System.out.println("importOperations: no Rule or Rule isn't an OpRule " + String.valueOf(object) + " " + (object == null ? "" : object.getClass().getName()));
                    continue;
                }
                object3 = reservoirOp.getRules();
                for (int j = 0; j < ((Vector)object3).size(); ++j) {
                    Object object5;
                    object = (OpRule)((Vector)object3).get(j);
                    if (bl) {
                        System.out.println("importOperations: checking Rule " + String.valueOf(namedType2) + " against " + String.valueOf(object));
                    }
                    if (((OpRule)object).getController().getIndex() == namedType2.getController().getIndex() && object.getIndex() == namedType2.getIndex()) {
                        if (bl) {
                            System.out.println("importOperations: matched fromRule " + String.valueOf(object) + " to " + String.valueOf(namedType2));
                        }
                        if (namedType2 instanceof DownstreamCntrlOpRule) {
                            namedType = (DownstreamCntrlOpRule)object;
                            if (((RuleResolution)object4).d == null) {
                                reservoirOp.deleteOpRule((OpRule)object);
                            } else if (((RuleResolution)object4).d instanceof RssNode) {
                                object5 = (RssNode)((RuleResolution)object4).d;
                                namedType.setDownstreamControlLocationID(object5.getIndex());
                            } else {
                                System.out.println("importOperations: found DownstreamCntrlOpRule. Expecting RssNode but got " + (((RuleResolution)object4).d == null ? "null" : ((RuleResolution)object4).d.getClass().getName()));
                            }
                        }
                        if (namedType2 instanceof TandemOpRule) {
                            namedType = (TandemOpRule)object;
                            if (((RuleResolution)object4).d == null) {
                                reservoirOp.deleteOpRule((OpRule)object);
                            } else if (((RuleResolution)object4).d instanceof ReservoirElement) {
                                object5 = (ReservoirElement)((RuleResolution)object4).d;
                                namedType.setReservoirIndex(object5.getIndex());
                            } else {
                                System.out.println("importOperations: found TandemOpRule. Expecting RssNode but got " + (((RuleResolution)object4).d == null ? "null" : ((RuleResolution)object4).d.getClass().getName()));
                            }
                        }
                        if (namedType2 instanceof ReleaseFuncOpRule) {
                            namedType = (ReleaseFuncOpRule)object;
                            if (namedType.getIndependentVariable().getType() == 4) {
                                object5 = reservoirElement.getSystem();
                                if (object5 != null && (object = ((RssSystem)object5).getStateVariable(namedType.getIndependentVariable().getStateVariableId())) != null) {
                                    if (!arrayList.contains(object)) {
                                        arrayList.add(object);
                                        this.getSystem().newStateVariable(object.getName(), (StateVariable)object);
                                    }
                                    reservoirImport.c.add(object.getName());
                                    ((ReleaseFuncOpRule)namedType2)._independentVariable.setStateVariable(this.getSystem().getStateVariable(object.getName()));
                                }
                            } else if (namedType.getIndependentVariable().getType() == 6 && (object5 = reservoirElement.getSystem()) != null && (object = ((RssSystem)object5).getGlobalVariable(namedType.getIndependentVariable().getGlobalVariableId())) != null) {
                                if (!arrayList2.contains(object)) {
                                    arrayList2.add(object);
                                    this.getSystem().newGlobalVariable(object.getName(), (GlobalVariable)object);
                                }
                                reservoirImport.d.add(object.getName());
                                ((ReleaseFuncOpRule)namedType2)._independentVariable.setGlobalVariable(this.getSystem().getGlobalVariable(object.getName()));
                            }
                            if (((RuleResolution)object4).d instanceof IndependentVariableInfo) {
                                object5 = (IndependentVariableInfo)((RuleResolution)object4).d;
                                if (bl) {
                                    System.out.println("importOperations: setting ModelVariable info to " + String.valueOf(object5));
                                }
                                if (((IndependentVariable)(object = namedType.getIndependentVariable())).getType() == 4) {
                                    object2 = reservoirElement.getSystem();
                                    if (object2 != null && (object4 = ((RssSystem)object2).getStateVariable(((IndependentVariable)object).getStateVariableId())) != null) {
                                        if (!arrayList.contains(object4)) {
                                            arrayList.add(object4);
                                            this.getSystem().newStateVariable(object4.getName(), (StateVariable)object4);
                                        }
                                        reservoirImport.c.add(object4.getName());
                                        namedType._independentVariable.setStateVariable(this.getSystem().getStateVariable(object4.getName()));
                                    }
                                } else if (((IndependentVariable)object).getType() == 6 && (object2 = reservoirElement.getSystem()) != null && (object4 = ((RssSystem)object2).getGlobalVariable(((IndependentVariable)object).getGlobalVariableId())) != null) {
                                    if (!arrayList2.contains(object4)) {
                                        arrayList2.add(object4);
                                        this.getSystem().newGlobalVariable(object4.getName(), (GlobalVariable)object4);
                                    }
                                    reservoirImport.d.add(object4.getName());
                                    namedType._independentVariable.setGlobalVariable(this.getSystem().getGlobalVariable(object4.getName()));
                                }
                                int n = ((IndependentVariableInfo)object5).b.getIndex();
                                object4 = (intContainer)map.get(new intContainer(n));
                                if (object4 == null || (namedType2 = this.getElement(((intContainer)object4).value)) == null) {
                                    namedType2 = ((IndependentVariableInfo)object5).b;
                                }
                                object3 = ((IndependentVariableInfo)object5).a.getName();
                                object2 = this.getSystem().getObjectForKeyString((String)object3);
                                if (object2 != null && (object4 = (intContainer)map.get(new intContainer(object2.getIndex()))) != null) {
                                    RMAIO.replace((String)object3, (String)String.valueOf(object2.getIndex()), (String)String.valueOf(((intContainer)object4).value));
                                }
                                if (bl) {
                                    System.out.println("importOperations: setting updated ModelVariable info to TSProxy" + (String)object3 + " Element=" + String.valueOf(namedType2) + " ModelVariable=" + String.valueOf(((IndependentVariableInfo)object5).c));
                                }
                                ((IndependentVariable)object).setModalVariableInfo((String)object3, namedType2.getIndex(), ((IndependentVariableInfo)object5).c);
                                continue block0;
                            }
                            System.out.println("importOperations: found ReleaseFuncOpRule. Expecting IndependentVariableInfo but got " + (((RuleResolution)object4).d == null ? "null" : ((RuleResolution)object4).d.getClass().getName()));
                            continue block0;
                        }
                        if (namedType2 instanceof FlowLimitOpRule) {
                            namedType = (FlowLimitOpRule)object;
                            if (((RuleResolution)object4).d instanceof RssNode) {
                                namedType.setRssNodeIndex(((RssNode)((RuleResolution)object4).d).getIndex());
                                continue block0;
                            }
                            System.out.println("importOperations: found FlowLimitOpRule. Expecting RssNode but got " + String.valueOf(((RuleResolution)object4).d) == null ? "null" : ((RuleResolution)object4).d.getClass().getName());
                            continue block0;
                        }
                        if (!(namedType2 instanceof SystemHydropowerOpRule) || !(((RuleResolution)object4).d instanceof ReservoirElement)) continue block0;
                        namedType = (ReservoirElement)((RuleResolution)object4).d;
                        SystemHydropowerOpRule cfr_ignored_0 = (SystemHydropowerOpRule)namedType2;
                        object5 = (SystemHydropowerOpRule)namedType2;
                        object2 = ((SystemHydropowerOpRule)object5).getReservoirIndexArray();
                        boolean bl2 = false;
                        object = this.getSystem().getSystemHydropowerRule(object5.getName());
                        if (object == null) {
                            int[] nArray = new int[1];
                            object2 = nArray;
                            nArray[0] = namedType.getIndex();
                            ((SystemHydropowerOpRule)object5).setReservoirIndexArray((int[])object2);
                        } else {
                            for (int k = 0; k < ((Object)object2).length; ++k) {
                                if (object2[k] != namedType.getIndex()) continue;
                                bl2 = true;
                                break;
                            }
                            if (!bl2) {
                                int[] nArray = new int[((Object)object2).length + 1];
                                System.arraycopy(object2, 0, nArray, 0, ((Object)object2).length);
                                nArray[nArray.length - 1] = namedType.getIndex();
                                ((SystemHydropowerOpRule)object5).setReservoirIndexArray(nArray);
                            }
                        }
                        if (object == null) {
                            object = this.getSystem().createSystemHydropowerRule();
                            ((SystemHydropowerRule)object).copyChildInto((SystemHydropowerOpRule)object5);
                            ((SystemHydropowerOpRule)object5).setParentRuleIndex(object.getIndex());
                            continue block0;
                        }
                        ((SystemHydropowerRule)object).copyChildInto((SystemHydropowerOpRule)object5);
                        continue block0;
                    }
                    if (!(namedType2 instanceof ReleaseFuncOpRule)) continue;
                    if (object instanceof RateChangeLimitOpRule) {
                        namedType = (RateChangeLimitOpRule)object;
                        namedType.getReferencedStateVariables(arrayList);
                        continue;
                    }
                    if (!(object instanceof ReleaseFuncOpRule) || (namedType = (ReleaseFuncOpRule)object).getIndependentVariable() == null || ((IndependentVariable)(object5 = namedType.getIndependentVariable())).getType() != 4 || (object = reservoirElement.getSystem()) == null || (object2 = ((RssSystem)object).getStateVariable(((IndependentVariable)object5).getStateVariableId())) == null) continue;
                    if (!arrayList.contains(object2)) {
                        arrayList.add(object2);
                        this.getSystem().newStateVariable(object2.getName(), (StateVariable)object2);
                    }
                    reservoirImport.c.add(object2.getName());
                    namedType._independentVariable.setStateVariable(this.getSystem().getStateVariable(object2.getName()));
                }
            }
            if (bl) {
                System.out.println("importOperations: copying Operations");
            }
            reservoirOp2.copyInto(reservoirOp);
            Vector<OpSet> vector = reservoirOp.getOperationSets();
            Vector<OpSet> vector2 = reservoirOp2.getOperationSets();
            for (int i = 0; i < vector.size(); ++i) {
                RssSystem rssSystem;
                namedType = vector.get(i);
                if (namedType.hasCapacityOutages()) {
                    object = vector.get((int)i)._capacitySchedule.getCapacityOutages();
                    object2 = object.keySet();
                    Iterator iterator = object2.iterator();
                    object3 = vector2.get((int)i)._capacitySchedule.getCapacityOutages();
                    object3.clear();
                    while (iterator.hasNext()) {
                        rssSystem = (intContainer)iterator.next();
                        if (reservoirImport.a.getElementByName(reservoirElement.getElement((int)((intContainer)rssSystem).value)._name) == null) continue;
                        object2 = reservoirImport.a.getElementByName(reservoirElement.getElement((int)((intContainer)rssSystem).value)._name);
                        List list = (List)object.get(rssSystem);
                        ((intContainer)rssSystem).value = ((Element)object2)._index;
                        object3.put(rssSystem, list);
                    }
                }
                object = namedType.getZoneVector();
                for (int j = 0; j < ((Vector)object).size(); ++j) {
                    object2 = (StorageZone)((Vector)object).get(j);
                    if (((StorageZone)object2)._independentVariable.getType() != 4 || (rssSystem = reservoirElement.getSystem()) == null || (object3 = rssSystem.getStateVariable(((StorageZone)object2)._independentVariable.getStateVariableId())) == null) continue;
                    if (!arrayList.contains(object3)) {
                        arrayList.add(object3);
                        this.getSystem().newStateVariable(object3.getName(), (StateVariable)object3);
                    }
                    reservoirImport.c.add(object3.getName());
                    ((StorageZone)object2)._independentVariable.setStateVariable(this.getSystem().getStateVariable(object3.getName()));
                }
            }
        }
        object = this.a.getController();
        Vector vector = ((OpController)object)._controllableVec;
        ((OpController)object).setReleaseElementId(this.getIndex());
        this.fixupControllerIds(vector, map);
        ((OpController)object).updateControllerTree(this);
        this.fixupDownstreamControlOpRules();
        return true;
    }

    private void fixupDownstreamControlOpRules() {
        Vector vector = this.a.getRules();
        for (int i = 0; i < vector.size(); ++i) {
            OpRule opRule = (OpRule)vector.get(i);
            if (!(opRule instanceof DownstreamCntrlOpRule)) continue;
            opRule = (DownstreamCntrlOpRule)opRule;
            DownstreamOp downstreamOp = this.getSystem().getDownstreamOp(((DownstreamOpRule)opRule).getDownstreamControlLocationID(), true);
            DownstreamOpRule downstreamOpRule = downstreamOp.getDownstreamOpRule(opRule.getName());
            if (downstreamOpRule == null) {
                ((DownstreamCntrlOpRule)opRule).setParentRuleIndex(-1);
                downstreamOp.addRule((DownstreamCntrlOpRule)opRule);
                continue;
            }
            downstreamOpRule.copyChildInto((DownstreamCntrlOpRule)opRule);
            ((DownstreamCntrlOpRule)opRule).setParentRuleIndex(downstreamOpRule.getIndex());
        }
    }

    private void fixupControllerIds(List list, Map map) {
        intContainer intContainer2 = new intContainer();
        boolean bl = Logger.canDebug((String)"ResSimImport");
        for (int i = 0; i < list.size(); ++i) {
            int n;
            OpControllable opControllable = (OpControllable)list.get(i);
            intContainer2.value = n = opControllable.getReleaseElementId();
            intContainer intContainer3 = (intContainer)map.get(intContainer2);
            if (intContainer3 != null) {
                if (bl) {
                    System.out.println("fixupControllerIds: fixed " + String.valueOf(intContainer2) + " to " + String.valueOf(intContainer3));
                }
                opControllable.setReleaseElementId(intContainer3.value);
            } else {
                System.out.println("fixupControllerIds: failed to find mapping for " + n + " OpController=" + String.valueOf(opControllable));
            }
            if (!(opControllable instanceof OpController)) continue;
            Object object = (OpController)opControllable;
            if (bl) {
                System.out.println("fixupControllerIds: found child OpController " + String.valueOf(object));
            }
            object = ((OpController)object)._controllableVec;
            this.fixupControllerIds((List)object, map);
        }
    }

    public void setLabelPosition(int n) {
        this._labelPosition = n;
    }

    public int getLabelPosition() {
        return this._labelPosition;
    }

    public List<OpRule> findRulesFor(Element element) {
        ArrayList<OpRule> arrayList = new ArrayList<OpRule>();
        if (element == null) {
            return arrayList;
        }
        Cloneable cloneable = this.getReservoirOp();
        if (cloneable == null) {
            return arrayList;
        }
        ((ReservoirOp)cloneable).getOperationSets();
        cloneable = ((ReservoirOp)cloneable).getRules();
        for (int i = 0; i < cloneable.size(); ++i) {
            OpController opController;
            OpRule opRule = (OpRule)cloneable.get(i);
            if (opRule == null || (opController = opRule.getController()) == null || opController.getReleaseElement() != element || arrayList.contains(opRule)) continue;
            arrayList.add(opRule);
        }
        return arrayList;
    }

    public List<OpRuleRef> findRuleRefsFor(Element element) {
        ArrayList<OpRuleRef> arrayList = new ArrayList<OpRuleRef>();
        if (element == null) {
            return arrayList;
        }
        Cloneable cloneable = this.getReservoirOp();
        if (cloneable == null) {
            return arrayList;
        }
        cloneable = ((ReservoirOp)cloneable).getOperationSets();
        for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
            Object object = (OpSet)((Vector)cloneable).get(i);
            object = ((OpSet)object).getZoneVector();
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                Object object2 = (StorageZone)((Vector)object).get(j);
                object2 = ((StorageZone)object2).getRuleRefs(null);
                for (int k = 0; k < object2.size(); ++k) {
                    OpRuleRef opRuleRef = (OpRuleRef)object2.get(k);
                    RssTSLocationObject rssTSLocationObject = opRuleRef.getRule();
                    if (rssTSLocationObject == null || (rssTSLocationObject = ((OpRule)rssTSLocationObject).getController()) == null || ((OpController)rssTSLocationObject).getReleaseElement() != element) continue;
                    arrayList.add(opRuleRef);
                }
            }
        }
        return arrayList;
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        Object object;
        int n;
        org.jdom.Element element2;
        element.setAttribute("Name", this.getName());
        element.setAttribute("Description", this._description);
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_PHYSICAL).a()) {
            org.jdom.Element element3;
            Vector vector;
            org.jdom.Element element4;
            element2 = new org.jdom.Element("Res_Physical_Data");
            element.addContent((Content)element2);
            if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_POOL).a()) {
                element4 = new org.jdom.Element("Res_Pool");
                element2.addContent((Content)element4);
                this.getStorageFunction().outputReport(alternativeInputReport, element4);
            }
            if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_DAM).a() && (vector = this.getElementsByClass(ReservoirDamElement.class, null)).size() > 0) {
                element4 = new org.jdom.Element("Res_Dams");
                element2.addContent((Content)element4);
                for (n = 0; n < vector.size(); ++n) {
                    object = (ReservoirDamElement)vector.get(n);
                    element3 = new org.jdom.Element("Res_Dam");
                    element4.addContent((Content)element3);
                    ((ReservoirDamElement)object).outputReport(alternativeInputReport, element3);
                }
            }
            if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_DIVERTED_OUTLET).a() && (vector = this.getDivertedOutlets()).size() > 0) {
                element4 = new org.jdom.Element("DivertedOutlets");
                element2.addContent((Content)element4);
                for (n = 0; n < vector.size(); ++n) {
                    object = (DivertedOutletElement)vector.get(n);
                    element3 = new org.jdom.Element("Diverted_Outlet");
                    element4.addContent((Content)element3);
                    ((DivertedOutletElement)object).outputReport(alternativeInputReport, element3);
                }
            }
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_OPERATIONAL).a()) {
            element2 = new org.jdom.Element("Res_Operational_Data");
            element.addContent((Content)element2);
            if (this.getReservoirOp() != null && this.getReservoirOp().b != null) {
                this.getReservoirOp().b.outputReport(alternativeInputReport, element2);
            }
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_OBSERVED_DATA).a() && this._obsDataVector != null && !this._obsDataVector.isEmpty()) {
            element2 = new org.jdom.Element("ObservedData");
            element.addContent((Content)element2);
            for (n = 0; n < this._obsDataVector.size(); ++n) {
                object = (String)this._obsDataVector.get(n);
                element2.setAttribute("NameParamID", (String)object);
            }
        }
    }

    @Override
    public ElementOp getElementOp() {
        return this.getReservoirOp();
    }

    @Override
    public ElementOp getElementOp(boolean bl) {
        return this.getReservoirOp(bl);
    }
}

