/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.intContainer;
import hec.lang.Logger;
import hec.lang.NamedType;
import hec.lang.annotation.Scriptable;
import hec.model.Conditional;
import hec.model.ConditionalBlock;
import hec.model.DataObject;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.AbstractReservoirOp;
import hec.rss.model.ConditionalBlockRef;
import hec.rss.model.ContinuousIntakeControlDevice;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOp;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.Element;
import hec.rss.model.ElementOp;
import hec.rss.model.HotstartState;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.OperationsElement;
import hec.rss.model.PumpOpRule;
import hec.rss.model.RateChangeElevLimitOpRule;
import hec.rss.model.RateChangeLimitOpRule;
import hec.rss.model.ReleaseAllocationConditionalBlockRef;
import hec.rss.model.ReleaseAllocationObject;
import hec.rss.model.ReleaseOverrides;
import hec.rss.model.ResOpHotstartState;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp$RelIntegrFunc;
import hec.rss.model.ReservoirOp$StorageErrorFunc;
import hec.rss.model.RssConditionalBlock;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.SystemHydropowerOpRule;
import hec.rss.model.SystemHydropowerRule;
import hec.rss.model.TandemOpParent;
import hec.rss.model.TandemOpRule;
import hec.rss.model.TandemSysOpRule;
import hec.rss.model.WaterAccount;
import hec.rss.model.WaterControlDevice;
import hec.rss.model.WaterQualityOpReleaseType;
import hec.rss.model.WaterQualityOpRule;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.server.RssComputeOptions;
import hec.rss.wq.model.WQOpValue;
import hec.wqenginecore.geometry.WQControlDevice;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import rma.lang.RmaMath;
import rma.lang.RmaSVFunction;
import rma.util.RMAConst;
import rma.util.RMASort;

public class ReservoirOp
extends AbstractReservoirOp
implements ElementOp,
RssReturnStatusConstants,
Cloneable {
    public static final int NOEVAL_LOCAL = 1;
    public static final int NOEVAL_DNSTRM = 2;
    public static final int NOEVAL_PERAVG = 4;
    public static final int NOEVAL_GC = 8;
    public static final int NOEVAL_ROC = 16;
    public static final int NOEVAL_RULES = 32;
    transient ReservoirElement a;
    OpController _controller = new OpController("Reservoir", 0);
    Hashtable<intContainer, OpSet> _opSetTable = new Hashtable();
    private List<ConditionalBlock> _conditionalBlockList = new Vector<ConditionalBlock>();
    int _nextConditionalBlockIndex = 100000;
    int _nextControllerIndex = 1;
    int _nextOpSetIndex = 0;
    private transient intContainer c = new intContainer();
    transient OpSet b;
    private transient Hashtable d = null;
    private transient int e;
    private transient List f;
    private transient boolean g;
    private transient ReservoirOp$StorageErrorFunc h;
    private transient ReservoirOp$RelIntegrFunc i;
    private transient double[] j;
    private transient double[] k;
    private transient boolean l = false;
    private static final FluentLogger m = FluentLogger.forEnclosingClass();

    public void loadControllerLimits(RunTimeStep runTimeStep) {
        this._controller.loadControllerLimits(runTimeStep);
    }

    public int testOperationStep(RunTimeStep runTimeStep, int n, int n2, OpRule opRule) {
        Storage storage = this.a.getStorageFunction();
        double d = storage.getPreviousElevation(runTimeStep);
        return this.testOperationStep(runTimeStep, n, n2, opRule, d);
    }

    public int testOperationStep(RunTimeStep runTimeStep, int n, int n2, OpRule opRule, double d) {
        if (this.b == null) {
            this.printMessage("ReservoirOp.testOperationStep: No active Operations Set is available");
            return 1;
        }
        StorageZone storageZone = this.b.getActiveZone(d, runTimeStep);
        if (storageZone != null) {
            this._controller.setZone(runTimeStep, storageZone);
        }
        this.evalControllerDecision(runTimeStep, storageZone, n, n2, opRule);
        return 0;
    }

    public void commitOperation(RunTimeStep runTimeStep) {
        this._controller.commitOperation(runTimeStep, this.e);
    }

    public void initOperationStep(RunTimeStep runTimeStep, int n) {
        this._controller.initOperationStep(runTimeStep, n);
    }

    public void applyPhysicalLimits32(RunTimeStep runTimeStep) {
        this._controller.applyPhysicalLimits32(runTimeStep, true);
    }

    public void applyReleaseOverrides(RunTimeStep runTimeStep) {
        this._controller.applyReleaseOverrides(runTimeStep);
    }

    public void applyElevationOverrides(RunTimeStep runTimeStep) {
        if (this.d != null) {
            this._controller.applyElevationOverrides(runTimeStep, this.d);
        }
    }

    public void applyRuleLimits2(RunTimeStep runTimeStep, OpRule opRule, int n) {
        this._controller.applyRuleLimits2(runTimeStep, opRule, n);
    }

    public void applyGCOperation(RunTimeStep runTimeStep, List list) {
        this._controller.computeGCOperationStep(runTimeStep, list);
    }

    double getIncrROCLimit(RunTimeStep runTimeStep, double[] dArray, double[] dArray2) {
        NamedType namedType = this.a.getStorageFunction();
        double d = namedType.getPreviousElevation(runTimeStep);
        namedType = this.b.getActiveZone(d, runTimeStep);
        List list = null;
        if (namedType != null) {
            list = namedType.getActiveRules(runTimeStep, null);
        }
        return this._controller.getIncrROCLimit(runTimeStep, dArray, dArray2, d, list);
    }

    double getDecrROCLimit(RunTimeStep runTimeStep, double[] dArray, double[] dArray2) {
        NamedType namedType = this.a.getStorageFunction();
        double d = namedType.getPreviousElevation(runTimeStep);
        namedType = this.b.getActiveZone(d, runTimeStep);
        List list = null;
        if (namedType != null) {
            list = namedType.getActiveRules(runTimeStep, null);
        }
        return this._controller.getDecrROCLimit(runTimeStep, dArray, dArray2, d, list);
    }

    @Override
    public String getControllerRuleNameByID(int n) {
        if (n == Integer.MIN_VALUE) {
            return "";
        }
        if (n >= 0) {
            int n2 = n >>> 16;
            int n3 = n & 0xFFFF;
            OpController opController = this.getController(n2);
            OpRule opRule = opController != null ? opController.getRule(n3) : this._controller.getRule(n);
            if (opRule != null) {
                return opRule.getName();
            }
            return "";
        }
        if (-n < OpController.OBJECTIVE_NAME.length) {
            return OpController.OBJECTIVE_NAME[-n];
        }
        return "";
    }

    @Override
    public String getControllerConstraintNameByID(int n) {
        if (n == Integer.MIN_VALUE) {
            return "";
        }
        if (n >= 0) {
            int n2 = n >>> 16;
            n &= 0xFFFF;
            OpController opController = this.getController(n2);
            OpRule opRule = null;
            if (opController != null) {
                opRule = opController.getRule(n);
            }
            if (opRule != null) {
                return opRule.getName();
            }
            return "";
        }
        if (-n < OpController.CNSTRNT_NAME.length) {
            return OpController.CNSTRNT_NAME[-n];
        }
        return "";
    }

    public void evaluateRuleLimits(RunTimeStep runTimeStep, int n) {
        this.a.getStorageFunction().computeInflow(runTimeStep);
        int n2 = this.f.size();
        for (int i = 0; i < n2; ++i) {
            OpRule opRule = (OpRule)this.f.get(i);
            if (opRule == null) continue;
            opRule.evaluateLimits(runTimeStep, n);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void updateDecisions(RunTimeStep var1_1, int var2_2) {
        var3_3 /* !! */  = this.a.getStorageFunction();
        var4_4 = var3_3 /* !! */ .getPreviousElevation(var1_1);
        var6_5 = var3_3 /* !! */ .getPreviousStorage(var1_1);
        var9_8 = var8_7 = this.b.getActiveZone(var4_4, var1_1);
        if (var8_7 != null) {
            this._controller.setZone(var1_1, var8_7);
        }
        if (var1_1.step > var1_1.rtw.getNumLookbackSteps() + 1 && !this.b.isDecisionStep(var1_1)) {
            return;
        }
        this.e = this.b.getNumDecisionSteps(var1_1);
        if (this.b.computingProjectedElevation()) {
            this.b.setProjectedElevation(var1_1, var4_4);
        }
        this.evalControllerDecision(var1_1, var8_7, var2_2);
        if (this.b.computingProjectedElevation()) {
            var10_9 = this.getProjectedElev(var1_1, var4_4, var8_7, var2_2);
            this.b.setProjectedElevation(var1_1, var10_9);
            var12_10 = this.b.getActiveZone(var10_9, var1_1);
            if (this.b.useProjectedResElevForOpZone() && var8_7 != var12_10) {
                var9_8 = var12_10;
                this.evalControllerDecision(var1_1, var9_8, var2_2);
            } else {
                this.evalControllerDecision(var1_1, var8_7, var2_2);
            }
        }
        if (Boolean.getBoolean("NOZBLOGIC")) {
            if (var1_1.step == var1_1.rtw.getNumLookbackSteps() + 2) {
                this.printMessage("Skipping Zone Boundary Logic");
            }
            this._controller.commitOperation(var1_1, this.e);
            return;
        }
        var10_9 = this.estimateStorageChange(var1_1, var3_3 /* !! */ , true);
        var12_11 = var6_5 + var10_9;
        var14_12 = var3_3 /* !! */ .storageToElevation(var12_11);
        var6_6 = this.b.getActiveZone(var14_12, var1_1);
        if (var6_6 == null && var8_7 == null || var6_6 == var8_7) {
            this._controller.commitOperation(var1_1, this.e);
            return;
        }
        if (var8_7 == null) ** GOTO lbl-1000
        if (var6_6 == null) {
            var7_13 = var8_7;
            var17_14 = var8_7.getElevation(var1_1);
        } else {
            var20_15 = var8_7.getFirstElevation();
            var22_16 = var6_6.getFirstElevation();
            if (var6_6 == null || var20_15 < var22_16) {
                var7_13 = var8_7;
                var17_14 = var8_7.getElevation(var1_1);
            } else lbl-1000:
            // 2 sources

            {
                var7_13 = var6_6;
                var17_14 = var6_6.getElevation(var1_1);
            }
        }
        if (Math.abs(var17_14 - var14_12) < 1.0E-10) {
            this._controller.commitOperation(var1_1, this.e);
            return;
        }
        this.evalControllerDecision(var1_1, var6_6, var2_2);
        if (this.b.computingProjectedElevation()) {
            var20_15 = this.getProjectedElev(var1_1, var4_4, var6_6, var2_2);
            var22_17 = this.b.getActiveZone(var20_15, var1_1);
            if (this.b.useProjectedResElevForOpZone() && var6_6 != var22_17) {
                this.evalControllerDecision(var1_1, var22_17, var2_2);
            }
        }
        var20_15 = this.estimateStorageChange(var1_1, var3_3 /* !! */ , false);
        if (var10_9 > 0.0 && var20_15 <= 1.0E-10 || var10_9 < 0.0 && var20_15 >= -1.0E-10) {
            this.evalZBDecision(var1_1, var9_8, var2_2, var7_13);
        } else if (var10_9 >= 0.0 && var20_15 > var10_9 || var10_9 < 0.0 && var20_15 < var10_9) {
            this.evalControllerDecision(var1_1, var9_8, var2_2);
            if (this.b.computingProjectedElevation()) {
                var22_16 = this.getProjectedElev(var1_1, var4_4, var9_8, var2_2);
                var3_3 /* !! */  = this.b.getActiveZone(var22_16, var1_1);
                if (this.b.useProjectedResElevForOpZone() && var9_8 != var3_3 /* !! */ ) {
                    this.evalControllerDecision(var1_1, (StorageZone)var3_3 /* !! */ , var2_2);
                }
            }
        }
        this._controller.commitOperation(var1_1, this.e);
    }

    private double estimateStorageChange(RunTimeStep runTimeStep, Storage storage, boolean bl) {
        double d = this._controller.getCurrentOpValue((RunTimeStep)runTimeStep).value;
        double d2 = storage.getNetInflow(runTimeStep);
        if (!RMAConst.isValidValue((double)d) || !RMAConst.isValidValue((double)d2)) {
            return 0.0;
        }
        if (!runTimeStep.isPerAvgTimeStep() && bl) {
            if (runTimeStep.step > 1) {
                int cfr_ignored_0 = runTimeStep.step;
            }
            double d3 = storage.getOutflowArray()[runTimeStep.step - 1];
            double d4 = storage.getNetInflowArray()[runTimeStep.step - 1];
            if (!RMAConst.isValidValue((double)d3) || !RMAConst.isValidValue((double)d4)) {
                return 0.0;
            }
            d = (d + d3) / 2.0;
            d2 = (d2 + d4) / 2.0;
        }
        double d5 = (d2 - d) * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q;
        return d5;
    }

    public int initPumpbackStep(RunTimeStep runTimeStep) {
        if (this.b == null) {
            this.printMessage("ReservoirOp.computePumpbackStep: No active Operations Set is available");
            return 1;
        }
        Object object = this.a.getStorageFunction();
        ((Storage)object).setPumpVol(runTimeStep, 0.0, 0.0);
        object = this.b.getRules(null);
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            Object object2 = object.get(i);
            if (!(object2 instanceof PumpOpRule) || (n2 = ((PumpOpRule)(object2 = (PumpOpRule)object2)).initPumpbackStep(runTimeStep)) == 0) continue;
            return n2;
        }
        return 0;
    }

    public int computePumpbackStep(RunTimeStep runTimeStep) {
        if (this.b == null) {
            this.printMessage("ReservoirOp.computePumpbackStep: No active Operations Set is available");
            return 1;
        }
        Object object = this.a.getStorageFunction();
        double d = ((Storage)object).getElevation(runTimeStep);
        if ((object = this.b.getActiveZone(d, runTimeStep)) == null) {
            return 0;
        }
        object = ((StorageZone)object).getActiveRules(runTimeStep, null);
        int n = object.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object2 = object.get(i);
            if (!(object2 instanceof PumpOpRule)) continue;
            ++n2;
            object2 = (PumpOpRule)object2;
            if (this.g) {
                this.a.getSystem().printLogMessage("active pump rule: " + object2.getName() + ", " + runTimeStep.getHecTime().dateAndTime(4));
            }
            if (n2 > 1) {
                this.a.getSystem().printWarningMessage("More than one pump rule active " + runTimeStep.getHecTime().dateAndTime(4));
                this.a.getSystem().printWarningMessage(this.a.getName() + " " + object2.getName() + ", rule ignored");
                continue;
            }
            int n3 = ((PumpOpRule)object2).computePumpbackStep(runTimeStep);
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    public ConditionalBlock deleteConditionalBlock(ConditionalBlock conditionalBlock) {
        if (conditionalBlock == null) {
            return null;
        }
        return this.deleteConditionalBlock(conditionalBlock.getIndex());
    }

    public ConditionalBlock deleteConditionalBlock(int n) {
        for (int i = 0; i < this._conditionalBlockList.size(); ++i) {
            ConditionalBlock conditionalBlock = this._conditionalBlockList.get(i);
            if (conditionalBlock.getIndex() == n) {
                this._conditionalBlockList.remove(conditionalBlock);
                return conditionalBlock;
            }
            conditionalBlock.deleteConditionalBlock(n);
        }
        return null;
    }

    public ConditionalBlock createNewConditionalBlock(String object) {
        object = new RssConditionalBlock((String)object);
        object.setIndex(this.nextConditionalBlockIndex());
        this._conditionalBlockList.add((ConditionalBlock)object);
        object.setParent((Object)this);
        return object;
    }

    void addConditionablock(ConditionalBlock conditionalBlock) {
        conditionalBlock.setIndex(this.nextConditionalBlockIndex());
        this._conditionalBlockList.add(conditionalBlock);
        if (conditionalBlock.getParent() == null) {
            conditionalBlock.setParent((Object)this);
        }
    }

    @Override
    public ConditionalBlock getConditionalBlock(int n) {
        for (int i = 0; i < this._conditionalBlockList.size(); ++i) {
            ConditionalBlock conditionalBlock = this._conditionalBlockList.get(i);
            if (conditionalBlock == null || conditionalBlock.getIndex() != n) continue;
            return conditionalBlock;
        }
        return null;
    }

    public ConditionalBlock getConditionalBlock(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this._conditionalBlockList.size(); ++i) {
            ConditionalBlock conditionalBlock = this._conditionalBlockList.get(i);
            if (conditionalBlock == null || !conditionalBlock.getName().equalsIgnoreCase(string)) continue;
            return conditionalBlock;
        }
        return null;
    }

    public List<ConditionalBlock> getConditionalBlocks() {
        return this._conditionalBlockList;
    }

    int nextConditionalBlockIndex() {
        return this._nextConditionalBlockIndex++;
    }

    public Vector getRequiredTSRecordProxies(Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        if (this.b == null) {
            return vector;
        }
        List<OpRule> list = this.b.getRules(null);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            OpRule opRule = list.get(i);
            vector = opRule.getRequiredTSRecordProxies(vector);
        }
        return vector;
    }

    public double getGuideCurveStorage(RunTimeStep runTimeStep) {
        if (this.b == null) {
            return Double.NEGATIVE_INFINITY;
        }
        StorageZone storageZone = this.b.getGuideCurveZone();
        if (storageZone == null && (storageZone = this.b.getInactiveZone()) == null) {
            return this.a.getStorageFunction().getMinStorage();
        }
        double d = storageZone.getElevation(runTimeStep, null);
        return this.a.getStorageFunction().elevationToStorage(d);
    }

    public double getInactiveStorage(RunTimeStep runTimeStep) {
        if (this.b == null) {
            return Double.NEGATIVE_INFINITY;
        }
        StorageZone storageZone = this.b.getInactiveZone();
        if (storageZone == null) {
            return this.a.getStorageFunction().getMinStorage();
        }
        double d = storageZone.getElevation(runTimeStep, null);
        return this.a.getStorageFunction().elevationToStorage(d);
    }

    public void saveHotstartState(HotstartState hotstartState, int n) {
        HotstartState hotstartState2 = hotstartState.getChildState(this.getName(), this.getClass().getName());
        if (hotstartState2 == null) {
            hotstartState2 = new ResOpHotstartState(this);
            hotstartState.addChildState(hotstartState2);
        }
        hotstartState2.saveState(n);
    }

    public boolean restoreHotstartState(HotstartState hotstartState) {
        String string = this.getDisplayName();
        int n = string.lastIndexOf(":");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((hotstartState = (ResOpHotstartState)hotstartState.getChildState(string, this.getClass().getName())) != null) {
            ((ResOpHotstartState)hotstartState).setReservoirOp(this);
            return hotstartState.restoreState();
        }
        return false;
    }

    public void saveFunctionState(int n) {
        this._controller.saveFunctionState(n);
    }

    public void restoreFunctionState(int n) {
        this._controller.restoreFunctionState(n);
    }

    public void deletDownstreamRulesForParent(int n, int n2) {
        RssTSLocationObject rssTSLocationObject = this._controller.getDownstreamRuleForParent(n, n2);
        if (rssTSLocationObject == null) {
            return;
        }
        n2 = rssTSLocationObject.getIndex();
        rssTSLocationObject = ((OpRule)rssTSLocationObject).getController();
        Vector<OpSet> vector = this.getOperationSets();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            OpSet opSet = vector.elementAt(i);
            opSet.removeAllRuleRef(rssTSLocationObject.getIndex(), n2);
        }
        ((OpController)rssTSLocationObject).deleteRule(n2);
        this.setModified(true);
    }

    public void deleteSystemHydropowerRulesForParent(int n) {
        RssTSLocationObject rssTSLocationObject = this._controller.getSystemHydropowerRuleForParent(n);
        if (rssTSLocationObject != null) {
            int n2 = rssTSLocationObject.getIndex();
            rssTSLocationObject = ((OpRule)rssTSLocationObject).getController();
            Vector<OpSet> vector = this.getOperationSets();
            if (vector == null) {
                return;
            }
            for (int i = 0; i < vector.size(); ++i) {
                OpSet opSet = vector.elementAt(i);
                opSet.removeAllRuleRef(rssTSLocationObject.getIndex(), n2);
            }
            ((OpController)rssTSLocationObject).deleteRule(n2);
            this.setModified(true);
            return;
        }
        Vector vector = new Vector();
        this._controller.getChildControllers(vector);
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.get(i) instanceof OpController) || (rssTSLocationObject = ((OpController)vector.get(i)).getSystemHydropowerRuleForParent(n)) == null) continue;
            int n3 = rssTSLocationObject.getIndex();
            rssTSLocationObject = ((OpRule)rssTSLocationObject).getController();
            Vector<OpSet> vector2 = this.getOperationSets();
            if (vector2 == null) {
                return;
            }
            for (int j = 0; j < vector2.size(); ++j) {
                OpSet opSet = vector2.elementAt(j);
                opSet.removeAllRuleRef(rssTSLocationObject.getIndex(), n3);
            }
            ((OpController)rssTSLocationObject).deleteRule(n3);
            this.setModified(true);
        }
    }

    public void deleteTandemSysOpRulesForParent(int n) {
        RssTSLocationObject rssTSLocationObject = this._controller.getTandemSysOpRuleForParent(n);
        if (rssTSLocationObject == null) {
            return;
        }
        int n2 = rssTSLocationObject.getIndex();
        rssTSLocationObject = ((OpRule)rssTSLocationObject).getController();
        Vector<OpSet> vector = this.getOperationSets();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            OpSet opSet = vector.elementAt(i);
            opSet.removeAllRuleRef(rssTSLocationObject.getIndex(), n2);
        }
        ((OpController)rssTSLocationObject).deleteRule(n2);
        this.setModified(true);
    }

    public void loadSystemDownstreamRules() {
        if (this.a == null) {
            return;
        }
        RssSystem rssSystem = this.a.getSystem();
        Vector vector = this.getRules();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            RssReturnStatusConstants rssReturnStatusConstants;
            OpRule opRule = (OpRule)vector.elementAt(i);
            if (opRule == null || !(opRule instanceof DownstreamCntrlOpRule) || (rssReturnStatusConstants = rssSystem.getDownstreamOp(((DownstreamOpRule)(opRule = (DownstreamCntrlOpRule)opRule)).getDownstreamControlLocationID())) == null || (rssReturnStatusConstants = rssReturnStatusConstants.getDownstreamOpRule(((DownstreamCntrlOpRule)opRule).getParentRuleIndex())) == null) continue;
            ((DownstreamCntrlOpRule)opRule).copyParentInto((DownstreamOpRule)rssReturnStatusConstants);
        }
    }

    public void loadSystemSystemHydropowerRules() {
        if (this.a == null) {
            return;
        }
        RssSystem rssSystem = this.a.getSystem();
        Vector vector = this.getRules();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SystemHydropowerRule systemHydropowerRule;
            OpRule opRule = (OpRule)vector.elementAt(i);
            if (opRule == null || !(opRule instanceof SystemHydropowerOpRule) || (systemHydropowerRule = rssSystem.getSystemHydropowerRule(((SystemHydropowerOpRule)(opRule = (SystemHydropowerOpRule)opRule)).getParentRuleIndex())) == null) continue;
            ((SystemHydropowerOpRule)opRule).copyParentInto(systemHydropowerRule);
        }
    }

    public void storeSystemHydropowerRules() {
        if (this.a == null) {
            return;
        }
        RssSystem rssSystem = this.a.getSystem();
        Vector vector = this.getRules();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            OpRule opRule = (OpRule)vector.elementAt(i);
            if (opRule == null || !(opRule instanceof SystemHydropowerOpRule)) continue;
            SystemHydropowerOpRule systemHydropowerOpRule = (SystemHydropowerOpRule)opRule;
            int n2 = systemHydropowerOpRule.getParentRuleIndex();
            if (n2 != Integer.MIN_VALUE) {
                opRule = rssSystem.getSystemHydropowerRule(n2);
                ((SystemHydropowerRule)opRule).copyChildInto(systemHydropowerOpRule);
                continue;
            }
            opRule = rssSystem.createSystemHydropowerRule();
            ((SystemHydropowerRule)opRule).setSystemHydropowerOpRule(systemHydropowerOpRule);
            systemHydropowerOpRule.setParentRuleIndex(opRule.getIndex());
        }
    }

    public void storeTandemSysOpRules() {
        if (this.a == null) {
            return;
        }
        RssSystem rssSystem = this.a.getSystem();
        Vector vector = this.getRules();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            OpRule opRule = (OpRule)vector.elementAt(i);
            if (opRule == null || !(opRule instanceof TandemSysOpRule)) continue;
            TandemSysOpRule tandemSysOpRule = (TandemSysOpRule)opRule;
            int n2 = tandemSysOpRule.getParentIndex();
            if (n2 != Integer.MIN_VALUE) {
                TandemOpParent tandemOpParent = rssSystem.getTandemOpParent(n2);
                tandemOpParent.copyChildInto(tandemSysOpRule);
                continue;
            }
            rssSystem.createTandemOpParent(tandemSysOpRule);
        }
    }

    public void storeSystemDownstreamRules() {
        if (this.a == null) {
            return;
        }
        RssSystem rssSystem = this.a.getSystem();
        Vector vector = this.getRules();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            DownstreamOp downstreamOp;
            OpRule opRule = (OpRule)vector.elementAt(i);
            if (opRule == null || !(opRule instanceof DownstreamCntrlOpRule) || (downstreamOp = rssSystem.getDownstreamOp(n2 = ((DownstreamOpRule)(opRule = (DownstreamCntrlOpRule)opRule)).getDownstreamControlLocationID(), true)) == null) continue;
            int n3 = ((DownstreamCntrlOpRule)opRule).getParentRuleIndex();
            DownstreamOpRule downstreamOpRule = null;
            if (n3 != Integer.MIN_VALUE) {
                downstreamOpRule = downstreamOp.getDownstreamOpRule(n3);
            }
            if (downstreamOpRule == null) {
                downstreamOp.addRule((DownstreamCntrlOpRule)opRule);
                continue;
            }
            downstreamOpRule.copyChildInto((DownstreamCntrlOpRule)opRule);
        }
    }

    public int getNumDecisionSteps() {
        return this.e;
    }

    @Override
    public boolean isRuleActive(OpRule opRule, RunTimeStep object) {
        if (this.b == null) {
            return false;
        }
        double d = this.a.getStorageFunction().getElevation((RunTimeStep)object);
        StorageZone storageZone = this.b.getActiveZone(d, (RunTimeStep)object);
        if (storageZone == null) {
            return false;
        }
        object = storageZone.getActiveRules((RunTimeStep)object, null);
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            OpRule opRule2 = (OpRule)object.get(i);
            if (opRule2 != opRule) continue;
            return true;
        }
        return false;
    }

    @Scriptable
    public double getWQControlDeviceFlow(RunTimeStep runTimeStep, OpRule rssTSLocationObject, boolean bl) {
        Element element = ((OpRule)rssTSLocationObject).getController().getReleaseElement();
        double d = -3.4028234663852886E38;
        if (element.hasWaterControlDevice()) {
            rssTSLocationObject = ((OpRule)rssTSLocationObject).getController();
            d = ((OpController)rssTSLocationObject).getCurMinOpValue((RunTimeStep)runTimeStep).value;
            if (d == -3.4028234663852886E38 && bl) {
                d = ((OpController)rssTSLocationObject).getPreviousParameterValue(runTimeStep);
            }
        } else {
            ((FluentLogger.Api)m.atWarning()).log("No Water Quality Control Device found for rule: " + rssTSLocationObject.getName());
        }
        return d;
    }

    @Scriptable
    public boolean setWQControlDeviceFlowRatios(double[] object, OpRule namedType, double d) {
        int n;
        double[] dArray = new double[((double[])object).length];
        if (Math.abs(d) > 1.0E-6) {
            for (n = 0; n < ((double[])object).length; n += 1) {
                dArray[n] = object[n] / d;
            }
        } else {
            for (n = 0; n < ((double[])object).length; n += 1) {
                dArray[n] = 0.0;
            }
        }
        n = 0;
        WQControlDevice wQControlDevice = this.getWQControlDeviceFromRule((OpRule)namedType);
        object = wQControlDevice;
        if (wQControlDevice != null) {
            namedType = this.getReservoirElement();
            RssWQGeometry rssWQGeometry = namedType.getSystem().getRssRun().getWQRun().getRssWQGeometry();
            if ((rssWQGeometry = (namedType = rssWQGeometry.getWQSubdomain((Element)namedType)).getResHydro()) != null) {
                rssWQGeometry.setTCDFlowRatios(dArray, object.getId());
                n = 1;
            } else {
                ((FluentLogger.Api)m.atWarning()).log("No WQResHydro object found for WQ subdomain: " + namedType.getName());
            }
        } else {
            ((FluentLogger.Api)m.atWarning()).log("No WQ Control Device found for rule: " + namedType.getName() + " on release element: " + namedType.getController().getReleaseElement().getName());
        }
        return n != 0;
    }

    private WQControlDevice getWQControlDeviceFromRule(OpRule namedType) {
        Object object = this.getReservoirElement();
        RssModelVariableConstants rssModelVariableConstants = ((Element)object).getSystem().getRssRun();
        if (rssModelVariableConstants != null && rssModelVariableConstants.getWQRun() != null && rssModelVariableConstants.getWQRun().getRssWQGeometry() != null && (object = ((RssWQGeometry)(rssModelVariableConstants = rssModelVariableConstants.getWQRun().getRssWQGeometry())).getWQSubdomain((Element)object)) != null) {
            namedType = namedType.getController().getReleaseElement();
            object = object.getWqControlDevices();
            object = object.iterator();
            while (object.hasNext()) {
                rssModelVariableConstants = (WQControlDevice)object.next();
                if (rssModelVariableConstants.getRssReleaseElemId() != namedType.getIndex()) continue;
                return rssModelVariableConstants;
            }
        }
        return null;
    }

    @Override
    public synchronized Object clone() {
        try {
            int n;
            OpSet opSet;
            ReservoirOp reservoirOp = (ReservoirOp)super.clone();
            ((ReservoirOp)super.clone()).a = this.a;
            reservoirOp._controller = (OpController)((RssTSLocationObject)this._controller).clone();
            reservoirOp._controller.setElementOp(reservoirOp);
            reservoirOp._opSetTable = new Hashtable();
            Enumeration<intContainer> enumeration = this._opSetTable.keys();
            while (enumeration.hasMoreElements()) {
                intContainer intContainer2 = enumeration.nextElement();
                opSet = this._opSetTable.get(intContainer2);
                opSet = (OpSet)((RssTSLocationObject)opSet).clone();
                opSet.setElementOp(reservoirOp);
                reservoirOp._opSetTable.put(intContainer2, opSet);
            }
            reservoirOp._nextControllerIndex = this._nextControllerIndex;
            reservoirOp._nextOpSetIndex = this._nextOpSetIndex;
            reservoirOp.c = this.c;
            if (this.b != null) {
                reservoirOp.setActiveOpSet(this.b.getIndex());
            }
            reservoirOp._nextConditionalBlockIndex = this._nextConditionalBlockIndex;
            reservoirOp._conditionalBlockList = new Vector<ConditionalBlock>(this._conditionalBlockList.size());
            for (n = 0; n < this._conditionalBlockList.size(); ++n) {
                opSet = this._conditionalBlockList.get(n);
                opSet = opSet.clone();
                reservoirOp._conditionalBlockList.add((ConditionalBlock)opSet);
            }
            for (n = 0; n < reservoirOp._conditionalBlockList.size(); ++n) {
                opSet = reservoirOp._conditionalBlockList.get(n);
                opSet.setParent(reservoirOp);
            }
            return reservoirOp;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void clearTSProxyList() {
        if (this._controller != null) {
            ((RssTSLocationObject)this._controller).clearTSProxyList();
        }
        if (this.b != null) {
            this.b.clearTSProxyList();
        }
    }

    public void updateTSProxyList() {
        if (this.b != null) {
            ((RssTSLocationObject)this.b).updateTSProxyList();
        }
        if (this._controller != null) {
            ((RssTSLocationObject)this._controller).updateTSProxyList();
        }
        for (int i = 0; i < this._conditionalBlockList.size(); ++i) {
            ConditionalBlock conditionalBlock = this._conditionalBlockList.get(i);
            if (!(conditionalBlock instanceof RssConditionalBlock)) continue;
            ((RssConditionalBlock)conditionalBlock).updateTSProxyList();
        }
    }

    public void getActiveTSRecordProxies(Vector vector, int n) {
        if (this.b == null) {
            return;
        }
        ((RssTSLocationObject)this.b).getActiveTSRecordProxies(vector, n);
        ((RssTSLocationObject)this._controller).getActiveTSRecordProxies(vector, n);
    }

    public OpSet addDuplicateOpSet(int n, String string) {
        if (string == null) {
            return null;
        }
        OpSet opSet = this._opSetTable.get(new intContainer(n));
        if (opSet == null) {
            return null;
        }
        opSet = (OpSet)((RssTSLocationObject)opSet).clone();
        opSet.setName(string);
        int n2 = this.nextOpSetIndex();
        opSet.setIndex(n2);
        this._opSetTable.put(new intContainer(n2), opSet);
        this.setModified(true);
        return opSet;
    }

    @Override
    public void printErrorMessage(String string) {
        if (this.a != null) {
            this.a.getSystem().printErrorMessage(string);
            return;
        }
        System.out.println(string);
    }

    @Override
    public void printMessage(String string) {
        if (this.a != null) {
            this.a.getSystem().printMessage(string);
            return;
        }
        System.out.println(string);
    }

    public int computeHindcastStep(RunTimeStep runTimeStep) {
        if (this.b == null) {
            this.printMessage("ReservoirOp.computeOperationStep: No active Operations Set is available");
            return 1;
        }
        double d = this.a.getStorageFunction().getElevation(runTimeStep);
        this.b.getActiveZone(d, runTimeStep);
        return 0;
    }

    public int testOperationStepOld(RunTimeStep runTimeStep, int n, int n2, OpRule opRule) {
        Storage storage = this.a.getStorageFunction();
        double d = storage.getPreviousElevation(runTimeStep);
        return this.testOperationStep(runTimeStep, n, n2, opRule, d);
    }

    public int testOperationStepOld(RunTimeStep runTimeStep, int n, int n2, OpRule opRule, double d) {
        if (this.b == null) {
            this.printMessage("ReservoirOp.testOperationStep: No active Operations Set is available");
            return 1;
        }
        StorageZone storageZone = this.b.getActiveZone(d, runTimeStep);
        if (storageZone != null) {
            this._controller.setZone(runTimeStep, storageZone);
        }
        this.evalControllerDecision(runTimeStep, storageZone, n, n2, opRule);
        return 0;
    }

    void evalControllerDecision(RunTimeStep runTimeStep, StorageZone storageZone, int n) {
        this.evalControllerDecision(runTimeStep, storageZone, n, 0, null);
    }

    @Override
    public void determinePhysicalLimits(OpController opController, RunTimeStep runTimeStep) {
        if (runTimeStep.isPerAvgTimeStep()) {
            this.i.a(opController, runTimeStep);
            return;
        }
        this.h.a(opController, runTimeStep);
        double d = this.h.b();
        double d2 = this.h.a();
        double d3 = RmaMath.bisectRoot((RmaSVFunction)this.h, (double)d, (double)d2, (int)200, (double)1.0E-4);
        if (Logger.canDebug((String)"ResSimOperations")) {
            System.out.println("ResOp Cap bisect search " + runTimeStep.dateTimeString() + ", " + d3 + " " + opController.getDisplayName());
        }
        if (!RMAConst.isValidValue((double)d3)) {
            d3 = d2;
        }
        opController.recalcPhysicalLimitsInst(runTimeStep, d3);
        opController.distributePhysicalLimits(runTimeStep);
    }

    void evalControllerDecision(RunTimeStep runTimeStep, StorageZone storageZone, int n, int n2, OpRule opRule) {
        int n3 = 1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        WaterAccount waterAccount = null;
        if (this.a.getDefaultWaterAccount() != null) {
            bl = true;
            n3 = 10;
            waterAccount = this.a.getDefaultWaterAccount();
            waterAccount.initEvalControllerDecision(runTimeStep, this.a);
        }
        for (int i = 0; i < n3; ++i) {
            if (bl) {
                if (waterAccount.evalConvergence(i, bl3)) break;
                waterAccount.initializeWADemands(runTimeStep);
            }
            this._controller.initOperationStep(runTimeStep, n);
            this._controller.applyPhysicalLimits(runTimeStep, true);
            if (this.l) {
                this._controller.saveReleaseToGuideCurve(runTimeStep);
            }
            this._controller.applyReleaseOverrides(runTimeStep);
            if (this.d != null) {
                this._controller.applyElevationOverrides(runTimeStep, this.d);
            }
            List list = null;
            int n4 = 0;
            boolean bl4 = false;
            if (opRule != null) {
                n4 = opRule.getRuleLimitType();
            }
            if (storageZone != null && (n2 & 0x20) == 0) {
                if (bl) {
                    waterAccount.updateLosses(runTimeStep, this._controller.o[runTimeStep.step].value);
                }
                list = storageZone.getActiveRules(runTimeStep, null);
                int n5 = list.size();
                for (int j = 0; j < n5; ++j) {
                    OpRule opRule2 = (OpRule)list.get(j);
                    if (opRule2 == opRule) {
                        bl4 = true;
                        continue;
                    }
                    if (bl4 && n4 != opRule2.getRuleLimitType() || opRule2 instanceof RateChangeLimitOpRule && (n2 & 0x10) != 0 || opRule2 instanceof RateChangeElevLimitOpRule && (n2 & 0x10) != 0 || opRule2 instanceof DownstreamCntrlOpRule && n <= 0 || opRule2 instanceof TandemOpRule && n < 2 || opRule2 instanceof SystemHydropowerOpRule && n < 2 || opRule2 instanceof PumpOpRule && n < 2 || opRule2 instanceof WaterQualityOpRule) continue;
                    if (opRule2.isPowerRule()) {
                        this._controller.applyPowerRuleLimits(runTimeStep, opRule2, n);
                        continue;
                    }
                    this._controller.applyRuleLimits2(runTimeStep, opRule2, n);
                }
            }
            if (bl && !waterAccount.inflowEvaled()) {
                waterAccount.updateCurrentVolume(runTimeStep);
            }
            double d = this._controller.o[runTimeStep.step].value;
            if ((n2 & 8) == 0) {
                this._controller.computeGCOperationStep(runTimeStep, list);
                if (bl) {
                    double d2 = this._controller.n[runTimeStep.step].value;
                    double d3 = d2 - d;
                    double d4 = waterAccount.getTotalGCOpDemand();
                    if (d3 > 0.01) {
                        bl2 = true;
                        waterAccount.updateCharges(runTimeStep, d3);
                    } else {
                        bl2 = false;
                        waterAccount.updateCharges(runTimeStep, 0.0);
                    }
                    bl3 = Math.abs(d4 - d3) > 0.01;
                }
            }
            if (!bl) continue;
            if (i > 0 || i == 0 && !bl2) {
                waterAccount.redistributeInflow(runTimeStep);
            }
            if (i != 9 || !(Math.abs(waterAccount.getResExcessInflowVol()) > 0.01)) continue;
            waterAccount.updateVolumes(runTimeStep);
        }
    }

    int evalZBDecision(RunTimeStep runTimeStep, StorageZone storageZone, int n, StorageZone storageZone2) {
        int n2 = 1;
        boolean bl = false;
        boolean bl2 = false;
        WaterAccount waterAccount = null;
        if (this.a.getDefaultWaterAccount() != null) {
            bl = true;
            n2 = 10;
            waterAccount = this.a.getDefaultWaterAccount();
            waterAccount.initEvalControllerDecision(runTimeStep, this.a);
        }
        for (int i = 0; i < n2; ++i) {
            double d;
            StorageZone storageZone3;
            if (bl) {
                if (waterAccount.evalConvergence(i, bl2)) break;
                waterAccount.initializeWADemands(runTimeStep);
            }
            this._controller.initOperationStep(runTimeStep, n);
            this._controller.applyPhysicalLimits(runTimeStep, true);
            double d2 = this._controller.o[runTimeStep.step].value;
            if (bl) {
                waterAccount.updateLosses(runTimeStep, d2);
            }
            this._controller.applyReleaseOverrides(runTimeStep);
            if (this.d != null) {
                this._controller.applyElevationOverrides(runTimeStep, this.d);
            }
            if ((storageZone3 = storageZone2) == null) {
                storageZone3 = this.b.getTopZone();
            }
            double d3 = this._controller.applyZoneOperation(runTimeStep, storageZone3);
            if (storageZone != null) {
                List list = storageZone.getActiveRules(runTimeStep, null);
                int n3 = list.size();
                for (int j = 0; j < n3; ++j) {
                    OpRule opRule = (OpRule)list.get(j);
                    if (opRule instanceof WaterQualityOpRule) continue;
                    if (opRule.isPowerRule()) {
                        this._controller.applyPowerRuleLimits(runTimeStep, opRule, n);
                        continue;
                    }
                    this._controller.applyRuleLimits2(runTimeStep, opRule, n);
                }
            }
            if (bl && !waterAccount.inflowEvaled()) {
                waterAccount.updateCurrentVolume(runTimeStep);
            }
            this._controller.computeZoneOperationStep(runTimeStep, storageZone2, d3);
            if (!bl) continue;
            double d4 = waterAccount.sumWADemands(runTimeStep, d2);
            double d5 = this._controller.o[runTimeStep.step].value - d4;
            double d6 = waterAccount.getTotalGCOpDemand();
            bl2 = Math.abs(d - d5) > 0.01;
            waterAccount.updateCharges(runTimeStep, d5);
            if (i <= 0) continue;
            waterAccount.redistributeInflow(runTimeStep);
        }
        return 0;
    }

    void applyWaterQualityRules(RunTimeStep runTimeStep, StorageZone object, int n) {
        if (object != null) {
            Object object2;
            object = ((StorageZone)object).getActiveRules(runTimeStep, null);
            int n2 = object.size();
            for (int i = 0; i < n2; ++i) {
                object2 = (OpRule)object.get(i);
                if (!(object2 instanceof WaterQualityOpRule) || n <= 1) continue;
                object2 = (WaterQualityOpRule)object2;
                ((WaterQualityOpRule)object2).evaluateRule(runTimeStep, n);
            }
            List<WaterControlDevice> list = this.a.getWaterControlDevicesOnRes();
            block1: for (WaterControlDevice waterControlDevice : list) {
                int n3;
                if (!(waterControlDevice instanceof ContinuousIntakeControlDevice)) continue;
                ContinuousIntakeControlDevice continuousIntakeControlDevice = (ContinuousIntakeControlDevice)waterControlDevice;
                double d = Double.MAX_VALUE;
                double d2 = -1.7976931348623157E308;
                for (n3 = 0; n3 < n2; ++n3) {
                    object2 = (OpRule)object.get(n3);
                    if (!(object2 instanceof WaterQualityOpRule) || n <= 1 || ((WaterQualityOpRule)(object2 = (WaterQualityOpRule)object2)).getWaterControlDevice().getIndex() != continuousIntakeControlDevice.getIndex()) continue;
                    object2 = ((WaterQualityOpRule)object2).getWQOpValue();
                    d = Math.min(d, ((WQOpValue)object2).b());
                    d2 = Math.max(d2, ((WQOpValue)object2).c());
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    object2 = (OpRule)object.get(n3);
                    if (!(object2 instanceof WaterQualityOpRule) || n <= 1) continue;
                    if (((WaterQualityOpRule)(object2 = (WaterQualityOpRule)object2)).getWaterControlDevice().getIndex() != continuousIntakeControlDevice.getIndex()) continue block1;
                    n3 = ((WaterQualityOpRule)object2).getReleaseType() == WaterQualityOpReleaseType.TOP_OF_POOL ? 1 : 0;
                    double d3 = n3 != 0 ? d2 : d;
                    ((WaterQualityOpRule)object2).setWQControlDeviceElev(d3);
                    continuousIntakeControlDevice.setElevArray(runTimeStep, d3);
                    continue block1;
                }
            }
        }
    }

    double getProjectedElev(RunTimeStep runTimeStep, double d, StorageZone storageZone, int n) {
        this.j[0] = d;
        double d2 = this._controller.n[runTimeStep.step].value;
        Storage storage = this.a.getStorageFunction();
        this.k[0] = storage.elevationToStorage(this.j[0]);
        double d3 = this.j[0];
        int n2 = runTimeStep.getTimeStepSeconds();
        n = this.b.getCompProjElevHours() * 3600 / n2;
        int n3 = runTimeStep.step - 1;
        double[] dArray = storage.getNetInflowArray();
        for (int i = 1; i <= n; ++i) {
            int n4 = n3 + i;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 > runTimeStep.getTotalNumSteps()) {
                n4 = runTimeStep.getTotalNumSteps();
            }
            this.k[i] = this.k[i - 1] + (dArray[n4] - d2) * (double)n2 / Storage.DSDT_TO_Q;
            this.j[i] = storage.storageToElevation(this.k[i]);
            d3 = Math.max(d3, this.j[i]);
        }
        return d3;
    }

    /*
     * WARNING - void declaration
     */
    public boolean initializeCompute(RunTimeWindow runTimeWindow) {
        Cloneable cloneable;
        void object22;
        TSRecordProxy tSRecordProxy;
        if (this.b == null) {
            return false;
        }
        if (!this.b.initializeCompute(runTimeWindow)) {
            return false;
        }
        Object object = this.b.getReleaseAllocationObject();
        if (object == null) {
            this.a.getSystem().printErrorMessage("No Release Allocation defined for time step. Verify an Allocation Set is defined in the \nReservoir Editor's Operation's Tab's Rel. Alloc. Tab.");
        }
        try {
            object.validate();
        }
        catch (VerifyError verifyError) {
            this.a.getSystem().printErrorMessage("Invalid Release Allocation Set: " + verifyError.getMessage());
            return false;
        }
        object = this.a.getSystem().getRssRun().getElevationOverrides();
        if (object != null && (tSRecordProxy = this.a.getStorageFunction().getTSRecordProxy(10)) != null) {
            this.d = ((ReleaseOverrides)object).getReleaseValues(tSRecordProxy.getName());
        }
        tSRecordProxy = new ArrayList();
        object = this.b.getZoneVector();
        boolean i = false;
        while (object != null && object22 < object.size()) {
            cloneable = (StorageZone)object.get((int)object22);
            List list = ((StorageZone)cloneable).getConditionalBlockRefs(null);
            tSRecordProxy.addAll(list);
            ++object22;
        }
        ReleaseAllocationObject releaseAllocationObject = this.b.getReleaseAllocationObject();
        releaseAllocationObject.setParent(this);
        releaseAllocationObject.updateParentData();
        if (tSRecordProxy.size() > 0) {
            cloneable = new HashMap();
            int n = tSRecordProxy.size();
            for (int j = 0; j < n; ++j) {
                ConditionalBlockRef conditionalBlockRef = (ConditionalBlockRef)tSRecordProxy.get(j);
                ConditionalBlock conditionalBlock = conditionalBlockRef.getConditionalBlock();
                if (conditionalBlock == null || cloneable.get(conditionalBlock) != null) continue;
                ConditionalBlock conditionalBlock2 = conditionalBlock;
                cloneable.put(conditionalBlock2, conditionalBlock2);
                conditionalBlock.setParent((Object)this);
                if (conditionalBlock.initializeCompute(runTimeWindow)) continue;
                return false;
            }
        }
        this.f = this.b.getRules(null);
        this.g = Boolean.getBoolean("RS_DEBUGPUMP");
        this.h = new ReservoirOp$StorageErrorFunc(this);
        this.i = new ReservoirOp$RelIntegrFunc(this);
        if (this.b.computingProjectedElevation()) {
            int n = runTimeWindow.getTimeStepSeconds();
            int n2 = this.b.getCompProjElevHours();
            int n3 = n2 * 3600 / n + 1;
            this.j = new double[n3];
            this.k = new double[n3];
        } else {
            this.j = null;
            this.k = null;
        }
        RssComputeOptions rssComputeOptions = this.a.getSystem().getComputeOptions();
        if (rssComputeOptions != null) {
            this.l = rssComputeOptions.saveReleaseToGuideCurve();
        }
        List<WaterControlDevice> list = this.a.getWaterControlDevicesOnRes();
        for (WaterControlDevice waterControlDevice : list) {
            if (!(waterControlDevice instanceof ContinuousIntakeControlDevice)) continue;
            ContinuousIntakeControlDevice continuousIntakeControlDevice = (ContinuousIntakeControlDevice)waterControlDevice;
            continuousIntakeControlDevice.initializeCompute();
        }
        return this._controller.initializeCompute(runTimeWindow);
    }

    public boolean initForPostProcessing(RunTimeWindow runTimeWindow) {
        int n;
        TSRecordProxy tSRecordProxy;
        Serializable serializable = this.a.getSystem().getRssRun().getElevationOverrides();
        if (serializable != null && (tSRecordProxy = this.a.getStorageFunction().getTSRecordProxy(10)) != null) {
            this.d = ((ReleaseOverrides)serializable).getReleaseValues(tSRecordProxy.getName());
        }
        tSRecordProxy = new ArrayList();
        serializable = this.b.getZoneVector();
        for (n = 0; serializable != null && n < serializable.size(); ++n) {
            Object object = (StorageZone)serializable.get(n);
            object = ((StorageZone)object).getConditionalBlockRefs(null);
            tSRecordProxy.addAll(object);
        }
        this.f = this.b.getRules(null);
        this.g = Boolean.getBoolean("RS_DEBUGPUMP");
        this.h = new ReservoirOp$StorageErrorFunc(this);
        this.i = new ReservoirOp$RelIntegrFunc(this);
        if (this.b.computingProjectedElevation()) {
            n = runTimeWindow.getTimeStepSeconds();
            int n2 = this.b.getCompProjElevHours();
            n2 = n2 * 3600 / n + 1;
            this.j = new double[n2];
            this.k = new double[n2];
        } else {
            this.j = null;
            this.k = null;
        }
        RssComputeOptions rssComputeOptions = this.a.getSystem().getComputeOptions();
        if (rssComputeOptions != null) {
            this.l = rssComputeOptions.saveReleaseToGuideCurve();
        }
        return this._controller.initForPostProcessing(runTimeWindow);
    }

    public void setActiveOpSet(int n) {
        if (this.c == null) {
            this.c = new intContainer();
        }
        this.c.value = n;
        this.b = this._opSetTable.get(this.c);
        this._controller.setActiveOperations(this.b);
    }

    @Override
    public OpSet getActiveOpSet() {
        return this.b;
    }

    public List getActiveRules(RunTimeStep runTimeStep, List list) {
        double d = this.a.getStorageFunction().getPreviousElevation(runTimeStep);
        return this.getActiveRules(runTimeStep, d, list);
    }

    public List getActiveRules(RunTimeStep runTimeStep, double d, List arrayList) {
        StorageZone storageZone;
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if ((storageZone = this.b.getActiveZone(d, runTimeStep)) != null) {
            storageZone.getActiveRules(runTimeStep, arrayList);
        }
        return arrayList;
    }

    public List getActiveRules(RunTimeStep runTimeStep, double d, StorageZone namedType, List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<StorageZone>();
        }
        if (namedType != null) {
            namedType = namedType.getZBOpRule();
            arrayList.add((StorageZone)namedType);
        }
        return this.getActiveRules(runTimeStep, d, arrayList);
    }

    public void setReservoirElement(ReservoirElement reservoirElement) {
        this.a = reservoirElement;
        this._controller.setElementOp(this);
        this._controller.setName(this.a.getName());
        this._controller.updateControllerTree(reservoirElement);
    }

    @Override
    public void deleteControllerReferences(int n) {
        Enumeration<OpSet> enumeration = this._opSetTable.elements();
        while (enumeration.hasMoreElements()) {
            OpSet opSet = enumeration.nextElement();
            opSet.deleteControllerReferences(n);
        }
    }

    @Override
    public void deleteOpRule(OpRule opRule) {
        OpSet opSet;
        int n;
        Object object;
        ConditionalBlock conditionalBlock;
        int n2;
        if (opRule == null) {
            return;
        }
        if (!(opRule instanceof DownstreamOpRule) || opRule instanceof DownstreamCntrlOpRule) {
            n2 = opRule.getIndex();
            conditionalBlock = this.getOperationSets();
            if (conditionalBlock == null) {
                return;
            }
            object = opRule.getController();
            for (n = 0; n < conditionalBlock.size(); ++n) {
                opSet = (OpSet)conditionalBlock.elementAt(n);
                opSet.removeAllRuleRef(object.getIndex(), n2);
            }
            ((OpController)object).deleteRule(n2);
        }
        for (n2 = 0; n2 < this._conditionalBlockList.size(); ++n2) {
            conditionalBlock = this._conditionalBlockList.get(n2);
            object = conditionalBlock.getConditionals();
            for (n = 0; n < object.size(); ++n) {
                opSet = (Conditional)object.get(n);
                opSet.removeCondtionalObject(opRule);
            }
        }
        if (opRule instanceof DownstreamOpRule) {
            n2 = opRule.getIndex();
            if (opRule instanceof DownstreamCntrlOpRule) {
                n2 = ((DownstreamCntrlOpRule)opRule).getParentRuleIndex();
            }
            int n3 = ((DownstreamOpRule)opRule).getDownstreamControlLocationID();
            object = this.getReservoirElement().getSystem();
            ((RssSystem)object).deleteDownstreamOpRule(n3, n2);
        }
    }

    public ReservoirElement getReservoirElement() {
        return this.a;
    }

    public void getDownstreamRuleNodes(int n, Hashtable hashtable) {
        if (this.c == null) {
            this.c = new intContainer();
        }
        this.c.value = n;
        OpSet opSet = this._opSetTable.get(this.c);
        if (opSet != null) {
            opSet.getDownstreamRuleNodes(hashtable);
        }
    }

    public void getStorageZones(int n, List<StorageZone> list) {
        if (this.c == null) {
            this.c = new intContainer();
        }
        this.c.value = n;
        OpSet opSet = this._opSetTable.get(this.c);
        if (opSet != null) {
            opSet.getStorageZones(list);
        }
    }

    public Vector getRules() {
        Vector<OpController> vector = this.getControllers();
        Vector vector2 = new Vector();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            OpController opController = vector.elementAt(i);
            opController.getRules(vector2);
        }
        return vector2;
    }

    public void getRules(int n, List<OpRule> list) {
        if (this.c == null) {
            this.c = new intContainer();
        }
        this.c.value = n;
        OpSet opSet = this._opSetTable.get(this.c);
        if (opSet != null) {
            opSet.getRules(list);
        }
    }

    public void getDownstreamRules(int n, List list) {
        if (this.c == null) {
            this.c = new intContainer();
        }
        this.c.value = n;
        OpSet opSet = this._opSetTable.get(this.c);
        if (opSet != null) {
            opSet.getDownstreamRules(list);
        }
    }

    public void getSystemHydropowerOpRules(int n, ArrayList arrayList) {
        if (this.c == null) {
            this.c = new intContainer();
        }
        this.c.value = n;
        OpSet opSet = this._opSetTable.get(this.c);
        if (opSet != null) {
            opSet.getSystemHydropowerOpRules(arrayList);
        }
    }

    public boolean hasDownstreamGoals(int n) {
        if (this.c == null) {
            this.c = new intContainer();
        }
        this.c.value = n;
        OpSet opSet = this._opSetTable.get(this.c);
        if (opSet == null) {
            return false;
        }
        return opSet.hasDownstreamGoals();
    }

    public boolean doesOpSetExist(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        Enumeration<OpSet> enumeration = this._opSetTable.elements();
        while (enumeration.hasMoreElements()) {
            OpSet opSet = enumeration.nextElement();
            if (!opSet.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public OpSet addNewOpSet(String object) {
        object = new OpSet(this, (String)object);
        int n = this.nextOpSetIndex();
        object.setIndex(n);
        this._opSetTable.put(new intContainer(n), (OpSet)object);
        this.setModified(true);
        return object;
    }

    public void removeOpSet(int n) {
        this._opSetTable.remove(new intContainer(n));
        this.setModified(true);
    }

    public void removeOpSet(OpSet opSet) {
        if (opSet == null) {
            return;
        }
        this._opSetTable.remove(new intContainer(opSet.getIndex()));
        this.setModified(true);
    }

    public boolean loadData() {
        if (!this._loaded || this._outOfDateData) {
            Enumeration<OpSet> enumeration = this._dataList.loadObject((DataObject)this);
            if (enumeration instanceof ReservoirOp) {
                this.copyInto((ReservoirOp)((Object)enumeration));
            }
            if (super.loadData()) {
                this._loaded = true;
            }
            this._controller.setElementOp(this);
            this._controller.resetChildOwnership();
            enumeration = this._opSetTable.elements();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().setElementOp(this);
            }
            this.setModified(false);
        }
        return this._loaded;
    }

    public void copyInto(ReservoirOp reservoirOp) {
        if (reservoirOp != this) {
            int n;
            Object object;
            OpSet opSet;
            Object object2;
            this._controller = (OpController)((RssTSLocationObject)reservoirOp._controller).clone();
            this._controller.setElementOp(this);
            this._opSetTable = new Hashtable();
            Object object3 = reservoirOp._opSetTable.keys();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                opSet = reservoirOp._opSetTable.get(object2);
                object = (OpSet)((RssTSLocationObject)opSet).clone();
                ((OpSet)object).setElementOp(this);
                this._opSetTable.put((intContainer)object2, (OpSet)object);
            }
            this._nextControllerIndex = reservoirOp._nextControllerIndex;
            this._nextOpSetIndex = reservoirOp._nextOpSetIndex;
            object2 = this._opSetTable.elements();
            while (object2.hasMoreElements()) {
                opSet = (OpSet)object2.nextElement();
                object = opSet.getReleaseAllocationObject();
                if (!(object instanceof ReleaseAllocationConditionalBlockRef)) continue;
                object3 = (ReleaseAllocationConditionalBlockRef)object;
                opSet = ((ReleaseAllocationConditionalBlockRef)object3).getConditionalBlock();
                opSet = opSet.clone();
                ((ReleaseAllocationConditionalBlockRef)object3).setConditionaBlock((ConditionalBlock)opSet);
                ((ReleaseAllocationConditionalBlockRef)object3).setParent(this);
            }
            if (reservoirOp.b != null) {
                this.setActiveOpSet(reservoirOp.b.getIndex());
            }
            this._nextConditionalBlockIndex = reservoirOp._nextConditionalBlockIndex;
            this._conditionalBlockList = new Vector<ConditionalBlock>(reservoirOp._conditionalBlockList.size());
            for (n = 0; n < reservoirOp._conditionalBlockList.size(); ++n) {
                object = reservoirOp._conditionalBlockList.get(n);
                object3 = object.clone();
                this._conditionalBlockList.add((ConditionalBlock)object3);
            }
            for (n = 0; n < this._conditionalBlockList.size(); ++n) {
                object = this._conditionalBlockList.get(n);
                object.setParent((Object)this);
            }
        }
        this.setModified(true);
    }

    @Override
    public OpController getController() {
        return this._controller;
    }

    @Override
    public Vector<OpController> getControllers() {
        Vector<OpController> vector = new Vector<OpController>();
        vector.add(this._controller);
        this._controller.getChildControllers(vector);
        return vector;
    }

    @Override
    public OpController getController(int n) {
        Object object = new Vector<OpController>();
        ((Vector)object).add(this._controller);
        this._controller.getChildControllers((Vector)object);
        Enumeration enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            object = (OpController)enumeration.nextElement();
            if (object.getIndex() != n) continue;
            return object;
        }
        return null;
    }

    @Override
    public OpController getController(Element element) {
        Vector<OpController> vector = new Vector<OpController>();
        vector.add(this._controller);
        this._controller.getChildControllers(vector);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            OpController opController = (OpController)vector.elementAt(i);
            if (opController.getReleaseElement() != element) continue;
            return opController;
        }
        return null;
    }

    public OpController getControllerForElement(Element element) {
        if (element == null) {
            return null;
        }
        Object object = new Vector<OpController>();
        ((Vector)object).add(this._controller);
        this._controller.getChildControllers((Vector)object);
        Enumeration enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            object = (OpController)enumeration.nextElement();
            if (((OpController)object).getReleaseElementId() != element.getIndex()) continue;
            return object;
        }
        return null;
    }

    public String[] getControllerNames() {
        Object object = new Vector<OpController>();
        ((Vector)object).add(this._controller);
        this._controller.getChildControllers((Vector)object);
        String[] stringArray = new String[((Vector)object).size()];
        object = ((Vector)object).iterator();
        while (object.hasNext()) {
            stringArray[0] = ((OpController)object.next()).getName();
        }
        return stringArray;
    }

    @Override
    public Vector<OpSet> getOperationSets() {
        Vector<OpSet> vector = new Vector<OpSet>();
        Enumeration<OpSet> enumeration = this._opSetTable.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        RMASort.quickSort(vector);
        return vector;
    }

    @Override
    public Hashtable<intContainer, OpSet> getOpSetTable() {
        return this._opSetTable;
    }

    public String[] getOperationSetNames() {
        Object[] objectArray = new String[this._opSetTable.size()];
        Enumeration<OpSet> enumeration = this._opSetTable.elements();
        for (int i = 0; i < this._opSetTable.size(); ++i) {
            OpSet opSet = enumeration.nextElement();
            objectArray[i] = opSet.getName();
        }
        RMASort.quickSort((Object[])objectArray);
        return objectArray;
    }

    @Override
    public OpSet getOperationSet(String string) {
        if (string == null) {
            return null;
        }
        Enumeration<OpSet> enumeration = this._opSetTable.elements();
        while (enumeration.hasMoreElements()) {
            OpSet opSet = enumeration.nextElement();
            if (!string.equalsIgnoreCase(opSet.getName())) continue;
            return opSet;
        }
        return null;
    }

    @Override
    public OpSet getOperationSet(int n) {
        return this._opSetTable.get(new intContainer(n));
    }

    @Override
    public OpController newController() {
        OpController opController = new OpController();
        opController.setIndex(this.nextControllerIndex());
        return opController;
    }

    private int nextControllerIndex() {
        int n = this._nextControllerIndex++;
        return n;
    }

    private int nextOpSetIndex() {
        int n = this._nextOpSetIndex++;
        return n;
    }

    public void resetId() {
        this._id = Long.MIN_VALUE;
    }

    public boolean useRecursiveModifiedTest() {
        return true;
    }

    @Override
    public int getGmtOffset() {
        return this.a._system.getGmtOffset();
    }

    @Override
    public int getUnitSystem() {
        return this.a._system.getUnitSystem();
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public OperationsElement getOperationsElement() {
        return this.a;
    }
}

