/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.lang.NamedType;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.Element;
import hec.rss.model.OpController;
import hec.rss.model.PowerPlant;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Vector;

public class ReservoirOutletElement
extends Element {
    private double _pulseFlow = Double.NEGATIVE_INFINITY;
    private boolean _useDefaultPulseFlow = true;

    public ReservoirOutletElement() {
    }

    public ReservoirOutletElement(RssSystem rssSystem, int n) {
        super(rssSystem, n);
    }

    public ReservoirOutletElement(RssSystem rssSystem, int n, ReservoirElement reservoirElement) {
        super(rssSystem, n);
        this._parentElement = reservoirElement;
    }

    public PowerPlant[] getPowerPlants() {
        PowerPlant[] powerPlantArray = this.getElementsByClass(AdjustableFlow.class, null);
        Vector<PowerPlant> vector = new Vector<PowerPlant>();
        int n = powerPlantArray.size();
        for (int i = 0; i < n; ++i) {
            NamedType namedType = (Element)powerPlantArray.get(i);
            if (!(namedType = (AdjustableFlow)namedType.getFunction()).hasPowerPlant()) continue;
            vector.add(namedType.getPowerPlant());
        }
        powerPlantArray = new PowerPlant[vector.size()];
        vector.toArray(powerPlantArray);
        return powerPlantArray;
    }

    public double getPulseFlow() {
        return this._pulseFlow;
    }

    public void getPulseFlow(ParamDouble paramDouble) {
        paramDouble.setValue(this.getPulseFlow());
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_FLOW);
    }

    public void setpulseFlow(double d) {
        this._pulseFlow = d;
    }

    public void setPulseFlow(ParamDouble paramDouble) {
        this._pulseFlow = paramDouble.getValue();
    }

    public void setUseDefaultPulseFlow(boolean bl) {
        this._useDefaultPulseFlow = bl;
    }

    public boolean getUseDefaultPulseFlow() {
        return this._useDefaultPulseFlow;
    }

    @Override
    public List getRuleConnectivityRefs() {
        RssReturnStatusConstants rssReturnStatusConstants = (ReservoirElement)this.getParent();
        if (rssReturnStatusConstants == null) {
            return null;
        }
        rssReturnStatusConstants = ((ReservoirElement)rssReturnStatusConstants).getReservoirOp(false);
        if ((rssReturnStatusConstants = ((ReservoirOp)rssReturnStatusConstants).getControllerForElement(this)) == null) {
            return null;
        }
        return ((OpController)rssReturnStatusConstants).getRuleConnectivityRefs(true);
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

