/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.lang.NamedType;
import hec.model.RunTimeStep;
import hec.rss.client.AdjustmentOptions$AdjustmentStrategy;
import hec.rss.client.AdjustmentOptions$ZoneAdjustments;
import hec.rss.client.ReservoirStorageVsYieldAdjustmentOptions;
import hec.rss.model.Element;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReverseReservoirYieldAnalysisBase;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.model.StorageZone;
import hec.rss.model.WaterAccount;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import rma.swing.RmaJIntegerSetField;
import rma.util.RMAIO;

public class ReservoirStorageVsYieldAnalysis
extends ReverseReservoirYieldAnalysisBase {
    private WaterAccount r = null;
    private ParamDouble s;
    private ParamDouble t;
    private int u;
    private double[] v;
    private double[] w;
    private double[] x;
    private boolean[] y;
    private double z;
    private String A = "";
    private int[] B = new int[0];
    private int[] C;
    private ReservoirStorageVsYieldAdjustmentOptions D;

    public ReservoirStorageVsYieldAnalysis(RssAlt rssAlt) {
        super(rssAlt);
    }

    public int[] a() {
        return this.B;
    }

    public boolean a(int n) {
        boolean bl = false;
        if (this.B != null && this.B.length > 0) {
            for (int i = 0; i < this.B.length; ++i) {
                if (this.B[i] != n) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void a(int[] nArray) {
        this.B = nArray;
    }

    @Override
    final void a(BufferedWriter bufferedWriter) throws IOException {
        this.D.a(bufferedWriter);
    }

    public String b() {
        return this.A;
    }

    public void a(String string) {
        this.A = string;
    }

    public int[] c() {
        return this.C;
    }

    public void b(int[] nArray) {
        this.C = nArray;
    }

    public int d() {
        return this.u;
    }

    public void b(int n) {
        this.u = n;
    }

    public void a(ParamDouble paramDouble) {
        this.s = paramDouble;
    }

    public ParamDouble e() {
        return this.s;
    }

    public void b(ParamDouble paramDouble) {
        this.t = paramDouble;
    }

    public ParamDouble f() {
        return this.t;
    }

    public ReservoirStorageVsYieldAdjustmentOptions g() {
        return this.D;
    }

    public void a(ReservoirStorageVsYieldAdjustmentOptions reservoirStorageVsYieldAdjustmentOptions) {
        this.D = reservoirStorageVsYieldAdjustmentOptions;
    }

    @Override
    public int initializeCompute(RssRun object) {
        this.b = null;
        ReservoirElement reservoirElement = this.k();
        int n = this.a((RssRun)object, reservoirElement);
        if (n != 0) {
            return n;
        }
        this.initializeRuleRefs(((RssRun)object).getAlternative());
        this.D.f();
        n = this.b((RssRun)object);
        if (n != 0) {
            return n;
        }
        object = this;
        this.v = new double[((ReservoirStorageVsYieldAnalysis)object).u];
        ((ReservoirStorageVsYieldAnalysis)object).w = new double[((ReservoirStorageVsYieldAnalysis)object).u];
        ((ReservoirStorageVsYieldAnalysis)object).x = new double[((ReservoirStorageVsYieldAnalysis)object).u];
        ((ReservoirStorageVsYieldAnalysis)object).y = new boolean[((ReservoirStorageVsYieldAnalysis)object).u];
        NamedType namedType = ((ReverseReservoirYieldAnalysisBase)object).k();
        namedType = namedType.getStorageFunction();
        double d = namedType.elevationToStorage(((ReservoirStorageVsYieldAnalysis)object).s.getValue());
        double d2 = namedType.elevationToStorage(((ReservoirStorageVsYieldAnalysis)object).t.getValue());
        ((ReservoirStorageVsYieldAnalysis)object).v[0] = ((ReservoirStorageVsYieldAnalysis)object).s.getValue();
        ((ReservoirStorageVsYieldAnalysis)object).w[0] = d;
        ((ReservoirStorageVsYieldAnalysis)object).v[((ReservoirStorageVsYieldAnalysis)object).u - 1] = ((ReservoirStorageVsYieldAnalysis)object).t.getValue();
        ((ReservoirStorageVsYieldAnalysis)object).w[((ReservoirStorageVsYieldAnalysis)object).u - 1] = d2;
        double d3 = (d2 - d) / (double)(((ReservoirStorageVsYieldAnalysis)object).u - 1);
        for (int i = 1; i < ((ReservoirStorageVsYieldAnalysis)object).u - 1; ++i) {
            double d4;
            ((ReservoirStorageVsYieldAnalysis)object).w[i] = d4 = d + (double)i * d3;
            ((ReservoirStorageVsYieldAnalysis)object).v[i] = namedType.storageToElevation(d4);
        }
        object = this;
        int n2 = ((ReverseReservoirYieldAnalysisBase)object).a.getResOpSetSelection(((ReverseReservoirYieldAnalysisBase)object).b.getIndex());
        OpSet opSet = ((ReverseReservoirYieldAnalysisBase)object).b.getReservoirOp().getOperationSet(n2);
        StorageZone storageZone = opSet.getGuideCurveZone();
        ((ReservoirStorageVsYieldAnalysis)object).z = storageZone.getSeasonalRecord().getAnnualAverage();
        object = reservoirElement.getReservoirOp().getActiveOpSet();
        ((OpSet)object).setUseStorageScale(true, this);
        this.setYieldAnalysisRuleUseDemandScale(true);
        return n;
    }

    public void a(RssRun rssRun) {
        OpSet opSet = this.b.getReservoirOp().getActiveOpSet();
        opSet.setUseStorageScale(false, this);
        this.setYieldAnalysisRuleUseDemandScale(false);
        this.e(rssRun);
        this.f(rssRun);
    }

    public int b(RssRun rssRun) {
        double d;
        double d2;
        StorageZone storageZone;
        if (this.u < 2) {
            rssRun.printErrorMessage("Storage vs. Yield Analysis Error: Need at least 2 intervals");
            return 1;
        }
        int n = this.a.getResOpSetSelection(this.b.getIndex());
        NamedType namedType = this.b.getReservoirOp().getOperationSet(n);
        Object object = namedType.getSortedZoneVector(true);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        object = ((Vector)object).iterator();
        while (object.hasNext()) {
            storageZone = (StorageZone)object.next();
            arrayList.add(storageZone.getIndex());
        }
        object = namedType.getGuideCurveZone();
        storageZone = this.m();
        StorageZone storageZone2 = namedType.getInactiveZone();
        namedType = namedType.getFloodZone();
        if (arrayList.indexOf(object.getIndex()) < arrayList.indexOf(storageZone.getIndex())) {
            rssRun.printErrorMessage("Storage vs. Yield Analysis Error: Lower Limit of Con Pool Zone is above Guide Curve");
            return 1;
        }
        double d3 = Arrays.stream(storageZone2.getSeasonalRecord().getDataArray()).min().getAsDouble();
        double d4 = Arrays.stream(namedType.getSeasonalRecord().getDataArray()).max().getAsDouble();
        if (this.s.getValue() >= this.t.getValue()) {
            rssRun.printErrorMessage("Storage vs. Yield Analysis Error: Min Guide Curve Elevation > Max Elevation");
            return 1;
        }
        double d5 = this.t.getValue();
        if (d2 > d4) {
            rssRun.printWarningMessage("Storage vs. Yield Analysis Warning: Max Elevation is above Flood Control Zone");
        }
        double d6 = this.s.getValue();
        if (d < d3) {
            rssRun.printWarningMessage("Storage vs. Yield Analysis Warning: Min Elevation is below Inactive Zone");
            return 1;
        }
        return 0;
    }

    public void a(int n, double d) {
        this.x[n - 1] = d;
    }

    public void a(int n, boolean bl) {
        this.y[n - 1] = bl;
    }

    public int h() {
        return this.getMaxIterations();
    }

    public boolean a(RunTimeStep runTimeStep) {
        return this.D.a(runTimeStep.getHecTime());
    }

    public List<StorageZone> a(OpSet object) {
        Object object2 = ((OpSet)object).getSortedZoneVector(true);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Object object3 = ((Vector)object2).iterator();
        while (object3.hasNext()) {
            StorageZone storageZone = object3.next();
            arrayList.add(storageZone.getIndex());
        }
        object3 = ((OpSet)object).getGuideCurveZone();
        double d = this.t.getValue();
        object = new ArrayList();
        boolean bl = false;
        object2 = ((Vector)object2).iterator();
        while (object2.hasNext()) {
            double d2;
            StorageZone storageZone = (StorageZone)object2.next();
            if (storageZone.getIndex() == object3.getIndex()) {
                bl = true;
                continue;
            }
            if (!bl || !(d < (d2 = Arrays.stream(storageZone.getSeasonalRecord().getDataArray()).min().getAsDouble()))) continue;
            object.add(storageZone);
        }
        return object;
    }

    public List<StorageZone> b(OpSet object) {
        Object object2 = ((OpSet)object).getSortedZoneVector(true);
        Cloneable cloneable = new ArrayList<Integer>();
        Object object3 = ((Vector)object2).iterator();
        while (object3.hasNext()) {
            StorageZone storageZone = object3.next();
            cloneable.add(storageZone.getIndex());
        }
        object3 = ((OpSet)object).getGuideCurveZone();
        double d = this.s.getValue();
        object = new ArrayList();
        object2 = ((Vector)object2).iterator();
        while (object2.hasNext() && (cloneable = (StorageZone)object2.next()).getIndex() != object3.getIndex()) {
            double d2 = Arrays.stream(((StorageZone)cloneable).getSeasonalRecord().getDataArray()).max().getAsDouble();
            if (!(d < d2)) continue;
            object.add(cloneable);
        }
        return object;
    }

    public void c(int n) {
        double d;
        double d2;
        double d3 = this.v[n - 1];
        if (d2 > this.z) {
            this.b(true);
            double d4 = this.t.getValue() - this.z;
            double d5 = d3 - this.z;
            d = d5 / d4;
        } else {
            this.b(false);
            double d6 = this.z - this.s.getValue();
            double d7 = this.z - d3;
            d = -d7 / d6;
        }
        n = this.a.getResOpSetSelection(this.b.getIndex());
        OpSet opSet = this.b.getReservoirOp().getOperationSet(n);
        opSet.setStorageScale(d, null);
    }

    public void i() {
        double d;
        boolean bl = this.n();
        double d2 = d = bl ? 1.0 : -1.0;
        if (this.D.b() == AdjustmentOptions$AdjustmentStrategy.SLIDE_PATTERN || this.D.a() == AdjustmentOptions$ZoneAdjustments.PROPORTIONALLY_SCALE) {
            int n = this.a.getResOpSetSelection(this.b.getIndex());
            NamedType namedType = this.b.getReservoirOp().getOperationSet(n);
            double d3 = bl ? this.t.getValue() : this.s.getValue();
            this.h = d * (d3 - this.z);
            if (this.D.a() == AdjustmentOptions$ZoneAdjustments.PROPORTIONALLY_SCALE) {
                Object object = this.g ? this.a((OpSet)namedType) : this.b((OpSet)namedType);
                object = object.iterator();
                while (object.hasNext()) {
                    namedType = (StorageZone)object.next();
                    double d4 = namedType.getSeasonalRecord().getAnnualAverage();
                    double d5 = d * (d3 - d4);
                    double d6 = 1.0 - d5 / this.h;
                    d6 = Math.max(0.0, Math.min(1.0, d6));
                    namedType.setProportionScale(d6);
                }
            }
        }
    }

    public double d(int n) {
        return this.v[n - 1];
    }

    private boolean e(RssRun rssRun) {
        int n;
        PairedDataContainer pairedDataContainer = new PairedDataContainer();
        int n2 = Parameter.PARAMID_STOR;
        int n3 = this.useHydropowerRules() ? Parameter.PARAMID_POWER : Parameter.PARAMID_FLOW;
        double[] dArray = this.w;
        double[][] dArray2 = new double[1][this.u];
        for (int i = 0; i < this.u; ++i) {
            dArray2[0][i] = this.x[i];
        }
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "Firm Yield";
        pairedDataContainer.xOrdinates = dArray;
        pairedDataContainer.yOrdinates = dArray2;
        pairedDataContainer.labels = stringArray2;
        pairedDataContainer.numberOrdinates = this.u;
        pairedDataContainer.numberCurves = 1;
        pairedDataContainer.xparameter = Parameter.getParamString((int)n2);
        pairedDataContainer.xunits = Parameter.getUnitsStringForSystem((int)n2, (int)rssRun.getAlternative().getUnitSystem());
        pairedDataContainer.yparameter = Parameter.getParamString((int)n3);
        pairedDataContainer.yunits = Parameter.getUnitsStringForSystem((int)n3, (int)rssRun.getAlternative().getUnitSystem());
        pairedDataContainer.labelsUsed = true;
        pairedDataContainer.fullName = ReservoirStorageVsYieldAnalysis.a(rssRun, n2, n3);
        pairedDataContainer.fileName = rssRun.getDSSOutputFile();
        try {
            n = rssRun.getDSSFileManager().write((DataContainer)pairedDataContainer);
        }
        catch (Exception exception) {
            System.out.println("Failed to save data set: " + pairedDataContainer.fullName);
            return false;
        }
        if (n < 0) {
            System.out.println("Failed to save data set: " + pairedDataContainer.fullName);
            return false;
        }
        return true;
    }

    public PairedDataContainer c(RssRun object) {
        DSSManager dSSManager = object.getDSSFileManager();
        String string = ((RssRun)object).getDSSOutputFile();
        int n = Parameter.PARAMID_STOR;
        int n2 = this.useHydropowerRules() ? Parameter.PARAMID_POWER : Parameter.PARAMID_FLOW;
        object = ReservoirStorageVsYieldAnalysis.a((RssRun)object, n, n2);
        object = new DSSIdentifier(string, (String)object);
        string = null;
        try {
            string = dSSManager.readPairedDataContainer((DSSIdentifier)object);
        }
        catch (RemoteException remoteException) {
            System.out.println("Failed to read data set: " + null.fullName);
        }
        return string;
    }

    private boolean f(RssRun rssRun) {
        int n;
        PairedDataContainer pairedDataContainer = new PairedDataContainer();
        int n2 = Parameter.PARAMID_ELEV;
        int n3 = Parameter.PARAMID_COUNT;
        double[] dArray = this.v;
        double[][] dArray2 = new double[1][this.u];
        for (int i = 0; i < this.u; ++i) {
            dArray2[0][i] = this.y[i] ? 1.0 : 0.0;
        }
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "Convergence";
        pairedDataContainer.xOrdinates = dArray;
        pairedDataContainer.yOrdinates = dArray2;
        pairedDataContainer.labels = stringArray2;
        pairedDataContainer.numberOrdinates = this.u;
        pairedDataContainer.numberCurves = 1;
        pairedDataContainer.xparameter = Parameter.getParamString((int)n2);
        pairedDataContainer.xunits = Parameter.getUnitsStringForSystem((int)n2, (int)rssRun.getAlternative().getUnitSystem());
        pairedDataContainer.yparameter = Parameter.getParamString((int)n3);
        pairedDataContainer.yunits = Parameter.getUnitsStringForSystem((int)n3, (int)rssRun.getAlternative().getUnitSystem());
        pairedDataContainer.labelsUsed = true;
        pairedDataContainer.fullName = ReservoirStorageVsYieldAnalysis.a(rssRun, n2, n3);
        pairedDataContainer.fileName = rssRun.getDSSOutputFile();
        try {
            n = rssRun.getDSSFileManager().write((DataContainer)pairedDataContainer);
        }
        catch (Exception exception) {
            System.out.println("Failed to save data set: " + pairedDataContainer.fullName);
            return false;
        }
        if (n < 0) {
            System.out.println("Failed to save data set: " + pairedDataContainer.fullName);
            return false;
        }
        return true;
    }

    private static String a(RssRun object, int n, int n2) {
        String string = "";
        String string2 = "Storage vs Yield Analysis";
        String string3 = Parameter.getParamString((int)n) + "-" + Parameter.getParamString((int)n2);
        String string4 = "";
        String string5 = "";
        object = object.getName();
        object = Arrays.asList("", string, string2, string3, string4, string5, object, "");
        object = String.join((CharSequence)"/", object);
        return object;
    }

    @Override
    public boolean writeFile(BufferedWriter bufferedWriter, RssAlt object) throws IOException {
        if (bufferedWriter == null) {
            return false;
        }
        bufferedWriter.write("ReservoirStorageVsYieldAnalysisBegin");
        bufferedWriter.newLine();
        super.writeFile(bufferedWriter, (RssAlt)object);
        bufferedWriter.write("Intervals=" + this.u);
        bufferedWriter.newLine();
        object = new StringBuilder();
        if (this.B != null) {
            int[] nArray = this.B;
            int n = this.B.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                ((StringBuilder)object).append(n2).append(", ");
            }
            if (((StringBuilder)object).length() > 0) {
                Object object2 = object;
                ((StringBuilder)object2).deleteCharAt(((StringBuilder)object2).length() - 2);
            }
        }
        bufferedWriter.write("YieldAnalysesToOutput=" + ((StringBuilder)object).toString());
        bufferedWriter.newLine();
        bufferedWriter.write("ReservoirStorageVsYieldAnalysisEnd");
        bufferedWriter.newLine();
        return true;
    }

    @Override
    public boolean readFile(BufferedReader bufferedReader) throws IOException {
        String string;
        if (bufferedReader == null) {
            return false;
        }
        while ((string = bufferedReader.readLine()) != null) {
            if ("ReservoirStorageVsYieldAnalysisEnd".equalsIgnoreCase(string)) {
                return true;
            }
            String string2 = RMAIO.getType((String)string, (String)"=");
            String string3 = RMAIO.getParam((String)string, (String)"=");
            if ("Intervals".equalsIgnoreCase(string2)) {
                this.u = RMAIO.parseInt((String)string3);
                continue;
            }
            if ("YieldAnalysesToOutput".equalsIgnoreCase(string2)) {
                string = new RmaJIntegerSetField();
                string.setText(string3);
                this.B = string.getIntegerSet();
                this.A = string3;
                continue;
            }
            if ("YieldAnalysisBegin".equalsIgnoreCase(string)) {
                super.readFile(bufferedReader);
                continue;
            }
            if ("SatisfyMapBegin".equalsIgnoreCase(string)) {
                this.b(bufferedReader);
                continue;
            }
            if ("ReservoirDataBegin".equalsIgnoreCase(string)) {
                this.a(bufferedReader);
                continue;
            }
            if (!"AdjustmentOptionsBegin".equalsIgnoreCase(string)) continue;
            this.D = ReservoirStorageVsYieldAdjustmentOptions.a(bufferedReader);
        }
        return true;
    }

    @Override
    final void b(BufferedWriter bufferedWriter) throws IOException {
        if (this.s != null) {
            bufferedWriter.write("Min=" + this.s.getValue());
            bufferedWriter.newLine();
        }
        if (this.t != null) {
            bufferedWriter.write("Max=" + this.t.getValue());
            bufferedWriter.newLine();
        }
    }

    @Override
    final void a(String string, String string2, int n) {
        if ("Min".equalsIgnoreCase(string)) {
            double d = RMAIO.parseDouble((String)string2);
            this.s = new ParamDouble(d, Parameter.PARAMID_ELEV, n);
            return;
        }
        if ("Max".equalsIgnoreCase(string)) {
            double d = RMAIO.parseDouble((String)string2);
            this.t = new ParamDouble(d, Parameter.PARAMID_ELEV, n);
        }
    }

    public ReservoirStorageVsYieldAnalysis j() {
        try {
            ReservoirStorageVsYieldAnalysis reservoirStorageVsYieldAnalysis = (ReservoirStorageVsYieldAnalysis)super.clone();
            if (this.D != null) {
                reservoirStorageVsYieldAnalysis.a(this.D.h());
            }
            reservoirStorageVsYieldAnalysis.a(this.r());
            if (this.s != null) {
                reservoirStorageVsYieldAnalysis.a((ParamDouble)this.s.clone());
            }
            if (this.t != null) {
                reservoirStorageVsYieldAnalysis.b((ParamDouble)this.t.clone());
            }
            if (this.b != null) {
                reservoirStorageVsYieldAnalysis.a((ReservoirElement)((Element)this.b).clone());
            }
            if (this.i != null) {
                reservoirStorageVsYieldAnalysis.c((ParamDouble)this.i.clone());
            }
            reservoirStorageVsYieldAnalysis.d = this.d;
            reservoirStorageVsYieldAnalysis.c = this.c;
            reservoirStorageVsYieldAnalysis.f = this.f;
            if (this.B != null) {
                reservoirStorageVsYieldAnalysis.B = (int[])this.B.clone();
            }
            reservoirStorageVsYieldAnalysis.A = this.A;
            return reservoirStorageVsYieldAnalysis;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            CloneNotSupportedException cloneNotSupportedException2 = cloneNotSupportedException;
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    @Override
    public /* synthetic */ Object clone() {
        return this.j();
    }
}

