/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.intContainer;
import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.model.DataObject;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.model.TSLocation;
import hec.rss.model.AbstractReservoirOp;
import hec.rss.model.Element;
import hec.rss.model.OpController;
import hec.rss.model.ResSystemOpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.SystemReservoirStorage;
import hec.rss.model.SystemStorageDefinition;
import hec.rss.model.SystemStorageZone;
import hec.rss.model.ZoneBounds;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import rma.util.RMASort;

public class ReservoirSysOp
extends AbstractReservoirOp
implements AsciiSerializable,
RssReturnStatusConstants,
Serializable {
    public static final int CONTROLLER_ID_OFFSET = 1000;
    public static final int DEFAULT_BALANCE = 0;
    public static final int ZONE_BALANCE = 1;
    public static final int TABLEAS_STOR = 0;
    public static final int TABLEAS_ZONE = 1;
    public static final int TABLEAS_ELEV = 2;
    int _reservoirSysId;
    private Vector _reservoirIndex = new Vector();
    private String _userName = "";
    private transient RssSystem a = null;
    private Hashtable _systemOpSetTable = new Hashtable();
    private int _nextIndex = 1;
    private transient ResSystemOpSet b;

    public static int a() {
        return 0;
    }

    public static int a(RssSystem rssSystem, ReservoirElement[] reservoirElementArray, boolean[] blArray, RunTimeStep runTimeStep, SystemStorageDefinition systemStorageDefinition, double d, double[] dArray) {
        if (systemStorageDefinition == null) {
            return 1;
        }
        if (systemStorageDefinition.h() == 0) {
            return ReservoirSysOp.b(rssSystem, reservoirElementArray, blArray, runTimeStep, systemStorageDefinition, d, dArray);
        }
        for (int i = 0; i < reservoirElementArray.length; ++i) {
            ReservoirSysOp reservoirSysOp;
            if (reservoirElementArray[i] == null || (reservoirSysOp = reservoirElementArray[i].getReservoirSysOp()) == null) continue;
            return reservoirSysOp.getZoneSystemBalanceForCoef(rssSystem, reservoirElementArray, blArray, runTimeStep, systemStorageDefinition, d, dArray);
        }
        return 1;
    }

    public static int b(RssSystem rssSystem, ReservoirElement[] reservoirElementArray, boolean[] blArray, RunTimeStep runTimeStep, SystemStorageDefinition systemStorageDefinition, double d, double[] dArray) {
        Object object;
        int n;
        int n2 = reservoirElementArray.length;
        double[][] dArray2 = systemStorageDefinition.b();
        dArray2[0][n2] = 0.0;
        dArray2[1][n2] = 0.0;
        dArray2[2][n2] = 0.0;
        for (n = 0; n < n2; ++n) {
            if (!blArray[n] || reservoirElementArray[n] == null) continue;
            NamedType namedType = reservoirElementArray[n];
            Storage storage = reservoirElementArray[n].getStorageFunction();
            StorageZone storageZone = (namedType = namedType.getReservoirOp(false).getActiveOpSet()).getInactiveZone();
            if (storageZone != null) {
                double d2 = storageZone.getElevation(runTimeStep);
                dArray2[0][n] = storage.elevationToStorage(d2);
            } else {
                dArray2[0][n] = 0.0;
            }
            StorageZone storageZone2 = namedType.getGuideCurveZone();
            if (storageZone2 != null) {
                double d3 = storageZone2.getElevation(runTimeStep);
                dArray2[1][n] = storage.elevationToStorage(d3);
            } else {
                dArray2[1][n] = dArray2[0][n] + 0.001;
            }
            StorageZone storageZone3 = namedType.getTopZone();
            object = storageZone3;
            if (storageZone3 != null && object != storageZone2) {
                double d4 = ((StorageZone)object).getElevation(runTimeStep);
                dArray2[2][n] = storage.elevationToStorage(d4);
            } else {
                dArray2[2][n] = storage.getMaxStorage();
            }
            double[] dArray3 = dArray2[0];
            int n3 = n2;
            dArray3[n3] = dArray3[n3] + dArray2[0][n];
            double[] dArray4 = dArray2[1];
            int n4 = n2;
            dArray4[n4] = dArray4[n4] + dArray2[1][n];
            double[] dArray5 = dArray2[2];
            int n5 = n2;
            dArray5[n5] = dArray5[n5] + dArray2[2][n];
        }
        if (d < 1.0) {
            d = 1.0;
        }
        if (d > 3.0) {
            d = 3.0;
        }
        int n6 = (int)d;
        double d5 = d - (double)n6;
        if (n6 >= 3 && d5 == 0.0) {
            d5 = 1.0;
            --n6;
        }
        if (systemStorageDefinition.i() == 0) {
            for (int i = 0; i < n2; ++i) {
                if (!blArray[i]) continue;
                dArray[i] = dArray2[n6 - 1][i] + d5 * (dArray2[n6][i] - dArray2[n6 - 1][i]);
            }
        } else {
            object = systemStorageDefinition.c();
            PairedValues[] pairedValuesArray = systemStorageDefinition.a();
            object[0][n2] = 0.0;
            object[1][n2] = 0.0;
            object[2][n2] = 0.0;
            for (n = 0; n < n2; ++n) {
                if (!blArray[n] || reservoirElementArray[n] == null) continue;
                PairedValues pairedValues = pairedValuesArray[n];
                for (int i = 0; i < 3; ++i) {
                    object[i][n] = pairedValues.interpolateValueCubicSpline(dArray2[i][n]);
                    Object object2 = object[i];
                    int n7 = n2;
                    object2[n7] = object2[n7] + object[i][n];
                }
            }
            for (int i = 0; i < n2; ++i) {
                if (!blArray[i]) continue;
                dArray[i] = (double)(object[n6 - 1][i] + d5 * (object[n6][i] - object[n6 - 1][i]));
            }
        }
        return 0;
    }

    public int getZoneSystemBalanceForCoef(RssSystem rssSystem, ReservoirElement[] reservoirElementArray, boolean[] blArray, RunTimeStep runTimeStep, SystemStorageDefinition systemStorageDefinition, double d, double[] dArray) {
        double d2;
        double d3;
        Object object;
        int n;
        int n2;
        RssAlt rssAlt = rssSystem.getAlternative();
        if (rssAlt == null) {
            return ReservoirSysOp.b(rssSystem, reservoirElementArray, blArray, runTimeStep, systemStorageDefinition, d, dArray);
        }
        int n3 = rssAlt.getResSysOpSetSelection(this.getIndex());
        Object object2 = this.getSystemOpSet(n3);
        if (object2 == null) {
            return ReservoirSysOp.b(rssSystem, reservoirElementArray, blArray, runTimeStep, systemStorageDefinition, d, dArray);
        }
        object2 = systemStorageDefinition.b();
        int n4 = reservoirElementArray.length;
        int n5 = 0;
        int n6 = 0;
        SystemStorageZone[] systemStorageZoneArray = systemStorageDefinition.d();
        int[] nArray = systemStorageDefinition.e();
        for (n2 = 0; n2 < systemStorageZoneArray.length; ++n2) {
            n6 += nArray[n2];
            for (n = 0; n < n4; ++n) {
                if (!blArray[n]) continue;
                ReservoirElement reservoirElement = reservoirElementArray[n];
                object = reservoirElement.getStorageFunction();
                Object object3 = systemStorageZoneArray[n2].getStorageZoneBounds(reservoirElement.getIndex());
                StorageZone storageZone = ((ZoneBounds)object3).getUpperBound();
                if (storageZone == null) {
                    rssSystem.printErrorMessage("Reservior System Operations - Reservior: " + reservoirElement.getName() + "'s zone is null");
                    rssSystem.printErrorMessage("System Storage balance computation cannot be completed");
                    return 1;
                }
                d3 = storageZone.getElevation(runTimeStep);
                object2[n5 + nArray[n2]][n] = ((Storage)object).elevationToStorage(d3);
                object = systemStorageZoneArray[n2].getSystemStorage(reservoirElement.getIndex());
                object3 = ((SystemReservoirStorage)object).getStorageValues();
                int n7 = Math.min(nArray[n2], ((Object)object3).length);
                if (nArray[n2] != ((Object)object3).length) {
                    rssSystem.printWarningMessage("Number of rows balance data (" + nArray[n2] + ") for System Storage Zone:" + String.valueOf(systemStorageZoneArray[n2]) + " Reservoir:" + String.valueOf(reservoirElement) + " StorageZone:" + String.valueOf(storageZone) + " is not the same for all reservoirs utilized in the system balance.");
                    rssSystem.printWarningMessage("System Storage balance computation will be affected");
                }
                for (int i = 1; i < n7; ++i) {
                    object2[n5 + nArray[n2] - i][n] = object2[n5][n] + object3[i] / 100.0 * (object2[n5 + nArray[n2]][n] - object2[n5][n]);
                }
            }
            n5 += nArray[n2];
        }
        int n8 = n6 + 2;
        d += 1.0;
        if (d2 < 1.0) {
            d = 1.0;
        }
        if (d > (double)n8) {
            d = n8;
        }
        int n9 = (int)d;
        d3 = d - (double)n9;
        if (n9 >= n8 + 1 && d3 == 0.0) {
            d3 = 1.0;
            --n9;
        }
        if (systemStorageDefinition.i() == 0) {
            for (int i = 0; i < n6 + 2; ++i) {
                object2[i][n4] = 0.0;
                for (n = 0; n < n4; ++n) {
                    if (!blArray[n]) continue;
                    Object object4 = object2[i];
                    int n10 = n4;
                    object4[n10] = object4[n10] + object2[i][n];
                }
            }
            for (n2 = 0; n2 < n4; ++n2) {
                if (!blArray[n2]) continue;
                dArray[n2] = (double)(object2[n9 - 1][n2] + d3 * (object2[n9][n2] - object2[n9 - 1][n2]));
            }
        } else {
            object = systemStorageDefinition.c();
            PairedValues[] pairedValuesArray = systemStorageDefinition.a();
            for (n2 = 0; n2 < n6 + 2; ++n2) {
                object[n2][n4] = 0.0;
            }
            for (n = 0; n < n4; ++n) {
                if (!blArray[n] || reservoirElementArray[n] == null) continue;
                PairedValues pairedValues = pairedValuesArray[n];
                for (n2 = 0; n2 < n6 + 2; ++n2) {
                    object[n2][n] = pairedValues.interpolateValueCubicSpline((double)object2[n2][n]);
                    Object object5 = object[n2];
                    int n11 = n4;
                    object5[n11] = object5[n11] + object[n2][n];
                }
            }
            for (n2 = 0; n2 < n4; ++n2) {
                if (!blArray[n2]) continue;
                dArray[n2] = (double)(object[n9 - 1][n2] + d3 * (object[n9][n2] - object[n9 - 1][n2]));
            }
        }
        return 0;
    }

    public static int a(RssSystem rssSystem, ReservoirElement[] reservoirElementArray, boolean[] blArray, RunTimeStep runTimeStep, SystemStorageDefinition systemStorageDefinition, double[] dArray, double[] dArray2, double d) {
        return ReservoirSysOp.a(rssSystem, reservoirElementArray, blArray, runTimeStep, systemStorageDefinition, dArray, dArray2, d, null, null);
    }

    public static int a(RssSystem rssSystem, ReservoirElement[] reservoirElementArray, boolean[] blArray, RunTimeStep runTimeStep, SystemStorageDefinition systemStorageDefinition, double[] dArray, double[] dArray2, double d, double[] dArray3, double[] dArray4) {
        if (systemStorageDefinition == null) {
            return 1;
        }
        if (systemStorageDefinition.h() == 0) {
            return ReservoirSysOp.b(rssSystem, reservoirElementArray, blArray, runTimeStep, systemStorageDefinition, dArray, dArray2, d, dArray3, dArray4);
        }
        for (int i = 0; i < reservoirElementArray.length; ++i) {
            ReservoirSysOp reservoirSysOp;
            if (reservoirElementArray[i] == null || (reservoirSysOp = reservoirElementArray[i].getReservoirSysOp()) == null) continue;
            return reservoirSysOp.getZoneSystemBalance(rssSystem, reservoirElementArray, blArray, runTimeStep, systemStorageDefinition, dArray, dArray2, d, dArray3, dArray4);
        }
        return 1;
    }

    public static int b(RssSystem rssSystem, ReservoirElement[] reservoirElementArray, boolean[] blArray, RunTimeStep runTimeStep, SystemStorageDefinition systemStorageDefinition, double[] dArray, double[] dArray2, double d, double[] dArray3, double[] dArray4) {
        double d2;
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2 = reservoirElementArray.length;
        double[][] dArray5 = systemStorageDefinition.b();
        double d3 = 0.0;
        dArray5[0][n2] = 0.0;
        dArray5[1][n2] = 0.0;
        dArray5[2][n2] = 0.0;
        for (n = 0; n < n2; ++n) {
            if (!blArray[n] || reservoirElementArray[n] == null) continue;
            NamedType namedType = reservoirElementArray[n];
            object3 = reservoirElementArray[n].getStorageFunction();
            object2 = (namedType = namedType.getReservoirOp(false).getActiveOpSet()).getInactiveZone();
            if (object2 != null) {
                double d4 = ((StorageZone)object2).getElevation(runTimeStep);
                dArray5[0][n] = ((Storage)object3).elevationToStorage(d4);
            } else {
                dArray5[0][n] = 0.0;
            }
            object = namedType.getGuideCurveZone();
            if (object != null) {
                double d5 = ((StorageZone)object).getElevation(runTimeStep);
                dArray5[1][n] = ((Storage)object3).elevationToStorage(d5);
            } else {
                dArray5[1][n] = dArray5[0][n] + 0.001;
            }
            StorageZone storageZone = namedType.getTopZone();
            if (storageZone != null && storageZone != object) {
                double d6 = storageZone.getElevation(runTimeStep);
                dArray5[2][n] = ((Storage)object3).elevationToStorage(d6);
            } else {
                dArray5[2][n] = ((Storage)object3).getMaxStorage();
            }
            double[] dArray6 = dArray5[0];
            int n3 = n2;
            dArray6[n3] = dArray6[n3] + dArray5[0][n];
            double[] dArray7 = dArray5[1];
            int n4 = n2;
            dArray7[n4] = dArray7[n4] + dArray5[1][n];
            double[] dArray8 = dArray5[2];
            int n5 = n2;
            dArray8[n5] = dArray8[n5] + dArray5[2][n];
            d3 += dArray[n];
        }
        if (systemStorageDefinition.i() == 0) {
            double d7;
            d3 += d;
            if (d7 < 0.0) {
                d3 = 0.0;
            }
            for (n = 0; n < 3; ++n) {
                if (!(dArray5[n][n2] >= d3)) continue;
                ++n;
                break;
            }
            if (--n == 0) {
                d2 = 1.0;
                for (int i = 0; i < n2; ++i) {
                    if (!blArray[i]) continue;
                    dArray2[i] = dArray5[n][i];
                }
            } else {
                double d8 = (d3 - dArray5[n - 1][n2]) / (dArray5[n][n2] - dArray5[n - 1][n2]);
                d2 = (double)n + d8;
                for (int i = 0; i < n2; ++i) {
                    if (!blArray[i]) continue;
                    dArray2[i] = dArray5[n - 1][i] + d8 * (dArray5[n][i] - dArray5[n - 1][i]);
                }
            }
        } else {
            int n6;
            object3 = systemStorageDefinition.c();
            object2 = systemStorageDefinition.a();
            double d9 = 0.0;
            object3[0][n2] = 0.0;
            object3[1][n2] = 0.0;
            object3[2][n2] = 0.0;
            for (n = 0; n < n2; ++n) {
                if (!blArray[n] || reservoirElementArray[n] == null) continue;
                object = object2[n];
                for (n6 = 0; n6 < 3; ++n6) {
                    object3[n6][n] = object.interpolateValueCubicSpline(dArray5[n6][n]);
                    Object object4 = object3[n6];
                    int n7 = n2;
                    object4[n7] = object4[n7] + object3[n6][n];
                }
                d9 += dArray[n];
            }
            d9 -= d;
            for (n = 0; n < 3; ++n) {
                if (!(object3[n][n2] >= d9)) continue;
                ++n;
                break;
            }
            if (--n == 0) {
                d2 = 1.0;
                for (n6 = 0; n6 < n2; ++n6) {
                    if (!blArray[n6]) continue;
                    dArray2[n6] = (double)object3[n][n6];
                }
            } else {
                double d10 = (d9 - object3[n - 1][n2]) / (object3[n][n2] - object3[n - 1][n2]);
                d2 = (double)n + d10;
                for (n6 = 0; n6 < n2; ++n6) {
                    if (!blArray[n6]) continue;
                    dArray2[n6] = dArray[n6] - (object3[n - 1][n6] + d10 * (object3[n][n6] - object3[n - 1][n6]));
                }
            }
        }
        if (dArray3 != null) {
            dArray3[0] = d2;
        }
        if (dArray4 != null) {
            dArray4[0] = d2;
        }
        return 0;
    }

    public int getZoneSystemBalance(RssSystem rssSystem, ReservoirElement[] reservoirElementArray, boolean[] blArray, RunTimeStep runTimeStep, SystemStorageDefinition systemStorageDefinition, double[] dArray, double[] dArray2, double d, double[] dArray3, double[] dArray4) {
        double d2;
        Object object;
        Object object2;
        int n;
        int n2;
        RssAlt rssAlt = rssSystem.getAlternative();
        if (rssAlt == null) {
            return ReservoirSysOp.b(rssSystem, reservoirElementArray, blArray, runTimeStep, systemStorageDefinition, dArray, dArray2, d, dArray3, dArray4);
        }
        int n3 = rssAlt.getResSysOpSetSelection(this.getIndex());
        Object object3 = this.getSystemOpSet(n3);
        if (object3 == null) {
            return ReservoirSysOp.b(rssSystem, reservoirElementArray, blArray, runTimeStep, systemStorageDefinition, dArray, dArray2, d, dArray3, dArray4);
        }
        object3 = systemStorageDefinition.b();
        int n4 = reservoirElementArray.length;
        int n5 = 0;
        int n6 = 0;
        double d3 = 0.0;
        SystemStorageZone[] systemStorageZoneArray = systemStorageDefinition.d();
        int[] nArray = systemStorageDefinition.e();
        for (n2 = 0; n2 < systemStorageZoneArray.length; ++n2) {
            n6 += nArray[n2];
            for (n = 0; n < n4; ++n) {
                if (!blArray[n]) continue;
                ReservoirElement reservoirElement = reservoirElementArray[n];
                Storage storage = reservoirElement.getStorageFunction();
                ZoneBounds zoneBounds = systemStorageZoneArray[n2].getStorageZoneBounds(reservoirElement.getIndex());
                object2 = zoneBounds;
                object = zoneBounds.getUpperBound();
                if (object == null) {
                    rssSystem.printErrorMessage("Reservior System Operations - Reservior: " + reservoirElement.getName() + "'s zone is null");
                    rssSystem.printErrorMessage("System Storage balance computation cannot be completed");
                    return 1;
                }
                double d4 = ((StorageZone)object).getElevation(runTimeStep);
                object3[n5 + nArray[n2]][n] = storage.elevationToStorage(d4);
                SystemReservoirStorage systemReservoirStorage = systemStorageZoneArray[n2].getSystemStorage(reservoirElement.getIndex());
                double[] dArray5 = systemReservoirStorage.getStorageValues();
                int n7 = Math.min(nArray[n2], dArray5.length);
                if (nArray[n2] != dArray5.length) {
                    rssSystem.printWarningMessage("Number of rows balance data (" + nArray[n2] + ") for System Storage Zone:" + String.valueOf(systemStorageZoneArray[n2]) + " Reservoir:" + String.valueOf(reservoirElement) + " StorageZone:" + String.valueOf(object) + " is not the same for all reservoirs utilized in the system balance.");
                    rssSystem.printWarningMessage("System Storage balance computation will be affected");
                }
                for (int i = 1; i < n7; ++i) {
                    object3[n5 + nArray[n2] - i][n] = object3[n5][n] + dArray5[i] / 100.0 * (object3[n5 + nArray[n2]][n] - object3[n5][n]);
                }
            }
            n5 += nArray[n2];
        }
        if (systemStorageDefinition.i() == 0) {
            double d5;
            for (int i = 0; i < n6 + 2; ++i) {
                object3[i][n4] = 0.0;
                for (n = 0; n < n4; ++n) {
                    if (!blArray[n]) continue;
                    Object object4 = object3[i];
                    int n8 = n4;
                    object4[n8] = object4[n8] + object3[i][n];
                }
            }
            for (n = 0; n < n4; ++n) {
                if (!blArray[n]) continue;
                d3 += dArray[n];
            }
            d3 += d;
            if (d5 < 0.0) {
                d3 = 0.0;
            }
            for (n = 1; n < n6 + 2; ++n) {
                if (!(object3[n][n4] >= d3)) continue;
                ++n;
                break;
            }
            double d6 = (d3 - object3[--n - 1][n4]) / (object3[n][n4] - object3[n - 1][n4]);
            d2 = (double)n + d6 - 1.0;
            for (n2 = 0; n2 < n4; ++n2) {
                if (!blArray[n2]) continue;
                dArray2[n2] = (double)(object3[n - 1][n2] + d6 * (object3[n][n2] - object3[n - 1][n2]));
            }
        } else {
            object2 = systemStorageDefinition.c();
            object = systemStorageDefinition.a();
            double d7 = 0.0;
            for (n2 = 0; n2 < n6 + 2; ++n2) {
                object2[n2][n4] = 0.0;
            }
            for (n = 0; n < n4; ++n) {
                if (!blArray[n] || reservoirElementArray[n] == null) continue;
                PairedValues pairedValues = object[n];
                for (n2 = 0; n2 < n6 + 2; ++n2) {
                    object2[n2][n] = pairedValues.interpolateValueCubicSpline((double)object3[n2][n]);
                    double[] dArray6 = object2[n2];
                    int n9 = n4;
                    dArray6[n9] = dArray6[n9] + object2[n2][n];
                }
                d7 += dArray[n];
            }
            d7 -= d;
            for (n = 1; n < n6 + 2; ++n) {
                if (!(object2[n][n4] >= d7)) continue;
                ++n;
                break;
            }
            double d8 = (d7 - object2[--n - 1][n4]) / (object2[n][n4] - object2[n - 1][n4]);
            d2 = (double)n + d8 - 1.0;
            for (n2 = 0; n2 < n4; ++n2) {
                if (!blArray[n2]) continue;
                dArray2[n2] = dArray[n2] - (object2[n - 1][n2] + d8 * (object2[n][n2] - object2[n - 1][n2]));
            }
        }
        if (dArray3 != null) {
            dArray3[0] = d2;
        }
        if (dArray4 != null) {
            dArray4[0] = d2;
        }
        return 0;
    }

    public static SystemStorageDefinition a(RssSystem rssSystem, ReservoirElement[] reservoirElementArray) {
        return ReservoirSysOp.a(rssSystem, reservoirElementArray, null);
    }

    public static SystemStorageDefinition a(RssSystem rssSystem, ReservoirElement[] reservoirElementArray, boolean[] object) {
        if (rssSystem == null) {
            return null;
        }
        if (reservoirElementArray == null) {
            rssSystem.printErrorMessage("ReservoirSysOp.getSystemBalance: Error, null arguments");
            return null;
        }
        if (reservoirElementArray.length <= 0) {
            rssSystem.printErrorMessage("ReservoirSysOp.getSystemBalance: Error, no reservoirs given to balance");
            return null;
        }
        object = null;
        int n = reservoirElementArray.length;
        for (int i = 0; i < n; ++i) {
            RssReturnStatusConstants rssReturnStatusConstants = reservoirElementArray[i];
            if ((rssReturnStatusConstants = rssReturnStatusConstants.getReservoirSysOp()) == null || object != null && rssReturnStatusConstants.getIndex() != object.getIndex()) {
                object = null;
                break;
            }
            object = rssReturnStatusConstants;
        }
        if (object == null) {
            return ReservoirSysOp.b(rssSystem, reservoirElementArray);
        }
        return object.getZoneSystemDefinition(rssSystem, reservoirElementArray);
    }

    public static SystemStorageDefinition a(RssSystem object, ReservoirElement[] object2, PairedValues[] pairedValuesArray) {
        if (object == null || object2 == null || ((ReservoirElement[])object2).length == 0) {
            return null;
        }
        object = ReservoirSysOp.a((RssSystem)object, object2);
        double[][] dArray = ((SystemStorageDefinition)object).b();
        object2 = dArray;
        if (dArray == null || ((ReservoirElement[])object2).length == 0 || object2[0] == null) {
            return null;
        }
        object2 = new double[((ReservoirElement[])object2).length][((ReservoirElement)object2[0]).length];
        ((SystemStorageDefinition)object).b((double[][])object2);
        ((SystemStorageDefinition)object).a(pairedValuesArray);
        ((SystemStorageDefinition)object).b(1);
        return object;
    }

    public static SystemStorageDefinition b(RssSystem rssSystem, ReservoirElement[] reservoirElementArray) {
        int n = reservoirElementArray.length;
        double[][] dArray = new double[3][n + 1];
        for (int i = 0; i < n; ++i) {
            NamedType namedType = reservoirElementArray[i];
            namedType = namedType.getStorageFunction();
            dArray[0][i] = 0.0;
            dArray[2][i] = namedType.getMaxStorage();
            double[] dArray2 = dArray[0];
            int n2 = n;
            dArray2[n2] = dArray2[n2] + dArray[0][i];
            double[] dArray3 = dArray[2];
            int n3 = n;
            dArray3[n3] = dArray3[n3] + dArray[2][i];
        }
        SystemStorageDefinition systemStorageDefinition = new SystemStorageDefinition();
        systemStorageDefinition.a(dArray);
        systemStorageDefinition.a(0);
        return systemStorageDefinition;
    }

    public SystemStorageDefinition getZoneSystemDefinition(RssSystem rssSystem, ReservoirElement[] reservoirElementArray) {
        RssAlt rssAlt = rssSystem.getAlternative();
        if (rssAlt == null) {
            return ReservoirSysOp.b(rssSystem, reservoirElementArray);
        }
        int n = rssAlt.getResSysOpSetSelection(this.getIndex());
        ResSystemOpSet resSystemOpSet = this.getSystemOpSet(n);
        if (resSystemOpSet == null) {
            return ReservoirSysOp.b(rssSystem, reservoirElementArray);
        }
        return this.getZoneSystemDefinition(resSystemOpSet, reservoirElementArray);
    }

    public SystemStorageDefinition getZoneSystemDefinition(ResSystemOpSet resSystemOpSet, ReservoirElement[] reservoirElementArray) {
        Object object;
        Object object2;
        int n;
        int n2 = reservoirElementArray.length;
        int[] nArray = resSystemOpSet.getStorageZoneIDs();
        Object[] objectArray = new SystemStorageZone[nArray.length];
        double[] dArray = new double[nArray.length];
        int n3 = 0;
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = resSystemOpSet.getStorageZone(nArray[i]);
            int n4 = Integer.MAX_VALUE;
            for (n = 0; n < n2; ++n) {
                object2 = reservoirElementArray[n];
                object = ((SystemStorageZone)objectArray[i]).getStorageZoneBounds(object2.getIndex());
                StorageZone storageZone = null;
                if (object != null) {
                    storageZone = ((ZoneBounds)object).getUpperBound();
                }
                if (storageZone != null) {
                    double d = storageZone.getFirstElevation();
                    int n5 = i;
                    dArray[n5] = dArray[n5] + ((ReservoirElement)object2).getStorageFunction().elevationToStorage(d);
                    object2 = ((SystemStorageZone)objectArray[i]).getSystemStorage(object2.getIndex());
                    double[] dArray2 = ((SystemReservoirStorage)object2).getStorageValues();
                    object2 = dArray2;
                    if (dArray2.length >= n4) continue;
                    n4 = ((Object)object2).length;
                    continue;
                }
                if (n4 != Integer.MAX_VALUE) continue;
                n4 = 0;
            }
            n3 += n4;
            nArray2[i] = n4;
        }
        RMASort.quickSort((double[])dArray, (Object[])objectArray, (int[])nArray2, (boolean)true);
        double[][] dArray3 = new double[n3 + 2][n2 + 1];
        for (n = 0; n < n2; ++n) {
            object2 = reservoirElementArray[n];
            dArray3[0][n] = 0.0;
            dArray3[n3 + 1][n] = ((ReservoirElement)object2).getStorageFunction().getMaxStorage();
        }
        object = new SystemStorageDefinition();
        ((SystemStorageDefinition)object).a(dArray3);
        ((SystemStorageDefinition)object).a(nArray2);
        ((SystemStorageDefinition)object).a((SystemStorageZone[])objectArray);
        ((SystemStorageDefinition)object).a(1);
        return object;
    }

    public static int a(RssSystem rssSystem, Vector vector, RunTimeStep runTimeStep, boolean[] blArray, double[] dArray) {
        return ReservoirSysOp.a(rssSystem, vector, runTimeStep, blArray, dArray, 0.0);
    }

    public static int a(RssSystem rssSystem, Vector vector, RunTimeStep runTimeStep, boolean[] blArray, double[] dArray, double d) {
        if (rssSystem == null) {
            return 1;
        }
        if (vector == null || runTimeStep == null || blArray == null || dArray == null) {
            rssSystem.printErrorMessage("ReservoirSysOp.getSystemBalance: Error, null arguments");
            return 1;
        }
        if (vector.isEmpty()) {
            rssSystem.printErrorMessage("ReservoirSysOp.getSystemBalance: Error, no reservoirs given to balance");
            return 1;
        }
        if (vector.size() != dArray.length || vector.size() != blArray.length) {
            rssSystem.printErrorMessage("ReservoirSysOp.getSystemBalance: Error, number of reservoirs does not match length of arrays");
            return 1;
        }
        RssReturnStatusConstants rssReturnStatusConstants = null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            RssReturnStatusConstants rssReturnStatusConstants2 = (ReservoirElement)vector.elementAt(i);
            if ((rssReturnStatusConstants2 = rssReturnStatusConstants2.getReservoirSysOp()) == null || rssReturnStatusConstants != null && rssReturnStatusConstants2.getIndex() != rssReturnStatusConstants.getIndex()) {
                rssReturnStatusConstants = null;
                break;
            }
            rssReturnStatusConstants = rssReturnStatusConstants2;
        }
        if (rssReturnStatusConstants == null) {
            return ReservoirSysOp.b(rssSystem, vector, runTimeStep, blArray, dArray, d);
        }
        return rssReturnStatusConstants.getZoneSystemBalance(rssSystem, vector, runTimeStep, blArray, dArray, d);
    }

    public static int b(RssSystem rssSystem, Vector vector, RunTimeStep runTimeStep, boolean[] blArray, double[] dArray, double d) {
        double d2;
        int n;
        int n2 = vector.size();
        double[] dArray2 = new double[n2];
        double[][] dArray3 = new double[3][n2 + 1];
        double d3 = 0.0;
        for (n = 0; n < n2; ++n) {
            if (!blArray[n]) continue;
            NamedType namedType = (ReservoirElement)vector.elementAt(n);
            Storage storage = namedType.getStorageFunction();
            StorageZone storageZone = (namedType = namedType.getReservoirOp(false).getActiveOpSet()).getInactiveZone();
            if (storageZone != null) {
                double d4 = storageZone.getElevation(runTimeStep);
                dArray3[0][n] = storage.elevationToStorage(d4);
            } else {
                dArray3[0][n] = 0.0;
            }
            StorageZone storageZone2 = namedType.getGuideCurveZone();
            if (storageZone2 != null) {
                double d5 = storageZone2.getElevation(runTimeStep);
                dArray3[1][n] = storage.elevationToStorage(d5);
            } else {
                dArray3[1][n] = dArray3[0][n] + 0.001;
            }
            StorageZone storageZone3 = namedType.getTopZone();
            if (storageZone3 != null && storageZone3 != storageZone2) {
                double d6 = storageZone3.getElevation(runTimeStep);
                dArray3[2][n] = storage.elevationToStorage(d6);
            } else {
                dArray3[2][n] = storage.getMaxStorage();
            }
            double[] dArray4 = dArray3[0];
            int n3 = n2;
            dArray4[n3] = dArray4[n3] + dArray3[0][n];
            double[] dArray5 = dArray3[1];
            int n4 = n2;
            dArray5[n4] = dArray5[n4] + dArray3[1][n];
            double[] dArray6 = dArray3[2];
            int n5 = n2;
            dArray6[n5] = dArray6[n5] + dArray3[2][n];
            dArray2[n] = storage.getStorage(runTimeStep);
            d3 += dArray2[n];
        }
        d3 += d;
        if (d2 < 0.0) {
            d3 = 0.0;
        }
        for (n = 1; n < 3; ++n) {
            if (!(dArray3[n][n2] >= d3)) continue;
            ++n;
            break;
        }
        double d7 = (d3 - dArray3[--n - 1][n2]) / (dArray3[n][n2] - dArray3[n - 1][n2]);
        for (int i = 0; i < n2; ++i) {
            if (!blArray[i]) continue;
            dArray[i] = dArray3[n - 1][i] + d7 * (dArray3[n][i] - dArray3[n - 1][i]);
        }
        return 0;
    }

    public int getZoneSystemBalance(RssSystem rssSystem, Vector vector, RunTimeStep runTimeStep, boolean[] blArray, double[] dArray, double d) {
        double d2;
        int n;
        int n2;
        Object object;
        double d3;
        Object object2;
        ReservoirElement reservoirElement;
        RssAlt rssAlt = rssSystem.getAlternative();
        if (rssAlt == null) {
            return ReservoirSysOp.b(rssSystem, vector, runTimeStep, blArray, dArray, d);
        }
        int n3 = rssAlt.getResSysOpSetSelection(this.getIndex());
        Object object3 = this.getSystemOpSet(n3);
        if (object3 == null) {
            return ReservoirSysOp.b(rssSystem, vector, runTimeStep, blArray, dArray, d);
        }
        int n4 = vector.size();
        int[] nArray = ((ResSystemOpSet)object3).getStorageZoneIDs();
        Object[] objectArray = new SystemStorageZone[nArray.length];
        Object object4 = new double[nArray.length];
        int n5 = 0;
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = ((ResSystemOpSet)object3).getStorageZone(nArray[i]);
            int n6 = Integer.MAX_VALUE;
            for (int j = 0; j < n4; ++j) {
                reservoirElement = (ReservoirElement)vector.elementAt(j);
                ZoneBounds zoneBounds = ((SystemStorageZone)objectArray[i]).getStorageZoneBounds(reservoirElement.getIndex());
                object2 = zoneBounds;
                StorageZone storageZone = zoneBounds.getUpperBound();
                d3 = storageZone.getFirstElevation();
                int n7 = i;
                object4[n7] = object4[n7] + reservoirElement.getStorageFunction().elevationToStorage(d3);
                SystemReservoirStorage systemReservoirStorage = ((SystemStorageZone)objectArray[i]).getSystemStorage(reservoirElement.getIndex());
                object = systemReservoirStorage.getStorageValues();
                if (((double[])object).length >= n6) continue;
                n6 = ((double[])object).length;
            }
            n5 += n6;
            nArray2[i] = n6;
        }
        RMASort.quickSort((double[])object4, (Object[])objectArray, (boolean)true);
        double[][] dArray2 = new double[n5 + 2][n4 + 1];
        for (n2 = 0; n2 < n4; ++n2) {
            reservoirElement = (ReservoirElement)vector.elementAt(n2);
            dArray2[0][n2] = 0.0;
            dArray2[n5 + 1][n2] = reservoirElement.getStorageFunction().getMaxStorage();
        }
        object2 = new double[n4];
        int n8 = 0;
        d3 = 0.0;
        for (n = 0; n < nArray.length; ++n) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (!blArray[n2]) continue;
                ReservoirElement reservoirElement2 = (ReservoirElement)vector.elementAt(n2);
                object3 = reservoirElement2.getStorageFunction();
                ZoneBounds zoneBounds = ((SystemStorageZone)objectArray[n]).getStorageZoneBounds(reservoirElement2.getIndex());
                object = zoneBounds;
                StorageZone storageZone = zoneBounds.getUpperBound();
                object4 = storageZone;
                double d4 = storageZone.getElevation(runTimeStep);
                dArray2[n8 + nArray2[n]][n2] = ((Storage)object3).elevationToStorage(d4);
                object3 = ((SystemStorageZone)objectArray[n]).getSystemStorage(reservoirElement2.getIndex());
                object3 = ((SystemReservoirStorage)object3).getStorageValues();
                for (int i = 1; i < nArray2[n]; ++i) {
                    dArray2[n8 + nArray2[n] - i][n2] = dArray2[n8][n2] + object3[i] / 100.0 * (dArray2[n8 + nArray2[n]][n2] - dArray2[n8][n2]);
                }
            }
            n8 += nArray2[n];
        }
        for (n = 0; n < n5 + 2; ++n) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (!blArray[n2]) continue;
                double[] dArray3 = dArray2[n];
                int n9 = n4;
                dArray3[n9] = dArray3[n9] + dArray2[n][n2];
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (!blArray[n2]) continue;
            ReservoirElement reservoirElement3 = (ReservoirElement)vector.elementAt(n2);
            object3 = reservoirElement3.getStorageFunction();
            object2[n2] = ((Storage)object3).getStorage(runTimeStep);
            d3 += object2[n2];
        }
        d3 += d;
        if (d2 < 0.0) {
            d3 = 0.0;
        }
        for (n2 = 1; n2 < n5 + 2; ++n2) {
            if (!(dArray2[n2][n4] >= d3)) continue;
            ++n2;
            break;
        }
        double d5 = (d3 - dArray2[--n2 - 1][n4]) / (dArray2[n2][n4] - dArray2[n2 - 1][n4]);
        for (int i = 0; i < n4; ++i) {
            if (!blArray[i]) continue;
            dArray[i] = dArray2[n2 - 1][i] + d5 * (dArray2[n2][i] - dArray2[n2 - 1][i]);
        }
        return 0;
    }

    public void setActiveOpSet(int n) {
        this.b = (ResSystemOpSet)this._systemOpSetTable.get(new intContainer(n));
    }

    public RssSystem getSystem() {
        return this.a;
    }

    public OpController newController() {
        return null;
    }

    public void deleteControllerReferences(int n) {
    }

    private int getNextIndex() {
        return this._nextIndex++;
    }

    public void addSystemOpSet(ResSystemOpSet resSystemOpSet) {
        if (resSystemOpSet == null) {
            return;
        }
        resSystemOpSet.setParent(this);
        this._systemOpSetTable.put(new intContainer(resSystemOpSet.getIndex()), resSystemOpSet);
    }

    public ResSystemOpSet createNewSystemOpSet(String object, String string) {
        if (object == null || ((String)object).equals("") || string == null) {
            return null;
        }
        object = new ResSystemOpSet(this.getNextIndex(), (String)object, string);
        ((ResSystemOpSet)object).setParent(this);
        this._systemOpSetTable.put(new intContainer(object.getIndex()), object);
        return object;
    }

    public void removeSystemOpSet(int n) {
        this._systemOpSetTable.remove(new intContainer(n));
        this.setModified(true);
    }

    public void removeSystemOpSet(ResSystemOpSet resSystemOpSet) {
        if (resSystemOpSet == null) {
            return;
        }
        this._systemOpSetTable.remove(new intContainer(resSystemOpSet.getIndex()));
        this.setModified(true);
    }

    public int[] getSystemOpSetIDs() {
        int[] nArray = new int[this._systemOpSetTable.size()];
        Object object = this._systemOpSetTable.keySet();
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            nArray[n] = ((intContainer)object.next()).value;
            if (this._nextIndex <= nArray[n]) {
                this._nextIndex = nArray[n] + 1;
                this.setModified(true);
            }
            ++n;
        }
        return nArray;
    }

    public int[] getReservoirIDs() {
        int[] nArray = new int[this._reservoirIndex.size()];
        for (int i = 0; i < this._reservoirIndex.size(); ++i) {
            intContainer intContainer2 = (intContainer)this._reservoirIndex.elementAt(i);
            nArray[i] = intContainer2.value;
        }
        return nArray;
    }

    public ResSystemOpSet getSystemOpSet(int n) {
        ResSystemOpSet resSystemOpSet = (ResSystemOpSet)this._systemOpSetTable.get(new intContainer(n));
        if (resSystemOpSet != null) {
            resSystemOpSet.setParent(this);
        }
        return resSystemOpSet;
    }

    public Vector getSystemOpSets() {
        Vector vector = new Vector();
        Enumeration enumeration = this._systemOpSetTable.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        RMASort.quickSort(vector);
        return vector;
    }

    public boolean loadData() {
        if (!this._loaded || this._outOfDateData) {
            Object object = this._dataList.loadObject((DataObject)this);
            if (object instanceof ReservoirSysOp) {
                this.copyInto((ReservoirSysOp)object);
            }
            if (super.loadData()) {
                this._loaded = true;
            }
            this.setModified(false);
        }
        return this._loaded;
    }

    public void copyInto(ReservoirSysOp reservoirSysOp) {
        if (reservoirSysOp == null) {
            return;
        }
        if (reservoirSysOp != this) {
            Object object;
            super.copyInto((DataObject)reservoirSysOp);
            this._userName = reservoirSysOp.getUserName();
            this._nextIndex = reservoirSysOp._nextIndex;
            this._reservoirIndex.removeAllElements();
            for (int i = 0; i < reservoirSysOp._reservoirIndex.size(); ++i) {
                object = (intContainer)reservoirSysOp._reservoirIndex.elementAt(i);
                this._reservoirIndex.addElement(new intContainer(object.value));
            }
            if (this._systemOpSetTable == null) {
                this._systemOpSetTable = new Hashtable();
            } else {
                this._systemOpSetTable.clear();
            }
            Enumeration enumeration = reservoirSysOp._systemOpSetTable.elements();
            while (enumeration.hasMoreElements()) {
                object = (ResSystemOpSet)enumeration.nextElement();
                object.setParent(this);
                this._systemOpSetTable.put(new intContainer(object.getIndex()), object);
            }
        }
        this.setModified(true);
    }

    public String toString() {
        return this.getUserName();
    }

    public void setUserName(String string) {
        if (string == null) {
            return;
        }
        this._userName = string;
        this.setModified(true);
    }

    public String getUserName() {
        return this._userName;
    }

    public void setRssSystem(RssSystem rssSystem) {
        this.a = rssSystem;
        this.setModified(true);
    }

    public void clearReservoirs() {
        int n = this._reservoirIndex.size();
        for (int i = 0; i < n; ++i) {
            Object object = (intContainer)this._reservoirIndex.elementAt(i);
            if (object == null || (object = this.a.findReservoir(((intContainer)object).value)) == null) continue;
            ((ReservoirElement)object).setReservoirSysOp(null);
        }
        this._reservoirIndex.clear();
        this.setModified(true);
    }

    public void removeReservoir(ReservoirElement reservoirElement) {
        if (reservoirElement == null) {
            return;
        }
        for (int i = 0; i < this._reservoirIndex.size(); ++i) {
            intContainer intContainer2 = (intContainer)this._reservoirIndex.elementAt(i);
            if (intContainer2.value != reservoirElement.getIndex()) continue;
            this._reservoirIndex.remove(intContainer2);
            reservoirElement.setReservoirSysOp(null);
        }
    }

    public void addReservoir(ReservoirElement reservoirElement) {
        if (reservoirElement == null) {
            return;
        }
        if (this.exists(reservoirElement)) {
            return;
        }
        int n = reservoirElement.getIndex();
        this._reservoirIndex.addElement(new intContainer(n));
        reservoirElement.setReservoirSysOp(this);
        this.setModified(true);
    }

    public boolean exists(ReservoirElement reservoirElement) {
        if (reservoirElement == null) {
            return false;
        }
        for (int i = 0; i < this._reservoirIndex.size(); ++i) {
            intContainer intContainer2 = (intContainer)this._reservoirIndex.elementAt(i);
            if (intContainer2.value != reservoirElement.getIndex()) continue;
            return true;
        }
        return false;
    }

    public void lowerPriority(ReservoirElement reservoirElement) {
        if (reservoirElement == null) {
            return;
        }
        int n = reservoirElement.getIndex();
        intContainer intContainer2 = new intContainer(n);
        int n2 = this._reservoirIndex.indexOf(intContainer2);
        if (n2 < 0 || n2 == this._reservoirIndex.size() - 1) {
            return;
        }
        this._reservoirIndex.remove(n2);
        this._reservoirIndex.insertElementAt(intContainer2, n2 + 1);
        this.setModified(true);
    }

    public void raisePriority(ReservoirElement reservoirElement) {
        if (reservoirElement == null) {
            return;
        }
        int n = reservoirElement.getIndex();
        intContainer intContainer2 = new intContainer(n);
        int n2 = this._reservoirIndex.indexOf(intContainer2);
        if (n2 <= 0) {
            return;
        }
        this._reservoirIndex.remove(n2);
        this._reservoirIndex.insertElementAt(intContainer2, n2 - 1);
        this.setModified(true);
    }

    public void removeAllReservoirs() {
        this._reservoirIndex.removeAllElements();
        this.setModified(true);
    }

    public ReservoirElement getReservoirByName(String object) {
        if (object == null) {
            return null;
        }
        if (this.a == null) {
            return null;
        }
        if (this._reservoirIndex.indexOf(new intContainer((object = this.a.findReservoir((String)object)).getIndex())) < 0) {
            return null;
        }
        return object;
    }

    public Vector getDownStreamElements() {
        Cloneable cloneable;
        Object object;
        int n;
        Vector<Element> vector = new Vector<Element>();
        Vector<ReservoirElement> vector2 = new Vector<ReservoirElement>();
        if (this.a == null) {
            return vector;
        }
        for (n = 0; n < this._reservoirIndex.size(); ++n) {
            object = (intContainer)this._reservoirIndex.elementAt(n);
            cloneable = this.a.findReservoir(object.value);
            if (cloneable == null) continue;
            vector2.addElement((ReservoirElement)cloneable);
        }
        for (n = 0; n < vector2.size(); ++n) {
            object = (ReservoirElement)vector2.elementAt(n);
            cloneable = this.a.getDownstreamElements((Element)object);
            for (int i = 0; cloneable != null && i < ((Vector)cloneable).size(); ++i) {
                boolean bl = true;
                Element element = (Element)((Vector)cloneable).elementAt(i);
                if (element instanceof ReservoirElement) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    ReservoirElement reservoirElement = (ReservoirElement)vector2.elementAt(j);
                    if (reservoirElement == object) continue;
                    bl &= element.downStreamFrom(reservoirElement);
                }
                if (!bl || vector.contains(element)) continue;
                vector.addElement(element);
            }
        }
        return vector;
    }

    public Vector getDownStreamNodes() {
        Vector vector = this.getDownStreamElements();
        Vector<Element> vector2 = new Vector<Element>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            TSLocation tSLocation = (Element)vector.elementAt(i);
            if ((tSLocation = tSLocation.getDownstreamNode()) == null) continue;
            vector2.addElement((Element)tSLocation);
        }
        return vector2;
    }

    public ReservoirElement getReservoirById(int n) {
        int n2 = this._reservoirIndex.indexOf(new intContainer(n));
        if (n2 < 0 || n2 >= this.numReservoirs()) {
            return null;
        }
        intContainer cfr_ignored_0 = (intContainer)this._reservoirIndex.elementAt(n2);
        if (this.a == null) {
            return null;
        }
        return this.a.findReservoir(n);
    }

    public List<ReservoirElement> getReservoirList() {
        ArrayList<ReservoirElement> arrayList = new ArrayList<ReservoirElement>();
        this._reservoirIndex.forEach(object -> arrayList.add(this.a.findReservoir(((intContainer)object).value)));
        return arrayList;
    }

    public void deleteReservoir(ReservoirElement reservoirElement) {
        if (reservoirElement == null) {
            return;
        }
        int n = reservoirElement.getIndex();
        this._reservoirIndex.removeElement(new intContainer(n));
        Enumeration enumeration = this._systemOpSetTable.elements();
        while (enumeration.hasMoreElements()) {
            ResSystemOpSet resSystemOpSet = (ResSystemOpSet)enumeration.nextElement();
            resSystemOpSet.deleteReservoirReferences(n);
        }
        reservoirElement.setReservoirSysOp(null);
        this.setModified(true);
    }

    public int numReservoirs() {
        return this._reservoirIndex.size();
    }

    @Override
    public Object clone() {
        try {
            Object object;
            ReservoirSysOp reservoirSysOp = (ReservoirSysOp)super.clone();
            ((ReservoirSysOp)super.clone())._userName = this._userName;
            reservoirSysOp._reservoirIndex = new Vector();
            for (int i = 0; i < this._reservoirIndex.size(); ++i) {
                object = (intContainer)this._reservoirIndex.elementAt(i);
                reservoirSysOp._reservoirIndex.addElement(new intContainer(object.value));
            }
            reservoirSysOp.a = this.a;
            reservoirSysOp._nextIndex = this._nextIndex;
            reservoirSysOp._systemOpSetTable = new Hashtable();
            Enumeration enumeration = this._systemOpSetTable.elements();
            while (enumeration.hasMoreElements()) {
                object = (ResSystemOpSet)((ResSystemOpSet)enumeration.nextElement()).clone();
                object.setParent(reservoirSysOp);
                reservoirSysOp._systemOpSetTable.put(new intContainer(object.getIndex()), object);
            }
            return reservoirSysOp;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("Error when cloning Reservoir System Operations " + this.getName());
            System.out.println(cloneNotSupportedException.getMessage());
            return null;
        }
    }

    public void resetId() {
        this._id = Long.MIN_VALUE;
    }

    public boolean equals(Object object) {
        if (object instanceof ReservoirSysOp) {
            return this.equals((ReservoirSysOp)object);
        }
        return false;
    }

    public boolean equals(ReservoirSysOp reservoirSysOp) {
        if (reservoirSysOp == null) {
            return false;
        }
        if (this == reservoirSysOp) {
            return true;
        }
        return this.getIndex() == reservoirSysOp.getIndex();
    }

    public int hashCode() {
        return this.getIndex();
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    public static double[][] a(RssSystem rssSystem, ReservoirElement[] reservoirElementArray, RunTimeStep runTimeStep, SystemStorageDefinition systemStorageDefinition, int n) {
        if (systemStorageDefinition == null) {
            return null;
        }
        if (systemStorageDefinition.h() == 0) {
            return ReservoirSysOp.b(rssSystem, reservoirElementArray, runTimeStep, systemStorageDefinition, n);
        }
        for (int i = 0; i < reservoirElementArray.length; ++i) {
            ReservoirSysOp reservoirSysOp;
            if (reservoirElementArray[i] == null || (reservoirSysOp = reservoirElementArray[i].getReservoirSysOp()) == null) continue;
            return reservoirSysOp.getZoneSystemStorageTableC(rssSystem, reservoirElementArray, runTimeStep, systemStorageDefinition, n);
        }
        return null;
    }

    public static double[][] b(RssSystem rssSystem, ReservoirElement[] reservoirElementArray, RunTimeStep runTimeStep, SystemStorageDefinition systemStorageDefinition, int n) {
        int n2 = reservoirElementArray.length;
        double[][] dArray = new double[n2 + 1][3];
        dArray[n2][0] = 0.0;
        dArray[n2][1] = 0.0;
        dArray[n2][2] = 0.0;
        for (int i = 0; i < n2; ++i) {
            if (reservoirElementArray[i] == null) continue;
            NamedType namedType = reservoirElementArray[i];
            Storage storage = reservoirElementArray[i].getStorageFunction();
            StorageZone storageZone = (namedType = namedType.getReservoirOp(false).getActiveOpSet()).getInactiveZone();
            double d = storageZone != null ? storageZone.getElevation(runTimeStep) : storage.getMinElevation();
            double d2 = storage.elevationToStorage(d);
            dArray[i][0] = n == 0 ? d2 : (n == 1 ? 0.0 : d);
            double[] dArray2 = dArray[n2];
            dArray2[0] = dArray2[0] + d2;
            storageZone = namedType.getGuideCurveZone();
            d = storageZone != null ? storageZone.getElevation(runTimeStep) : (d += 0.001);
            d2 = storage.elevationToStorage(d);
            dArray[i][1] = n == 0 ? d2 : (n == 1 ? 100.0 : d);
            double[] dArray3 = dArray[n2];
            dArray3[1] = dArray3[1] + d2;
            namedType = namedType.getTopZone();
            if (namedType != null && namedType != storageZone) {
                d = namedType.getElevation(runTimeStep);
                dArray[i][2] = storage.elevationToStorage(d);
            } else {
                d = storage.getMaxElevation();
            }
            d2 = storage.elevationToStorage(d);
            dArray[i][2] = n == 0 ? d2 : (n == 1 ? 200.0 : d);
            double[] dArray4 = dArray[n2];
            dArray4[2] = dArray4[2] + d2;
        }
        return dArray;
    }

    public double[][] getZoneSystemStorageTable(RssSystem rssSystem, ReservoirElement[] reservoirElementArray, RunTimeStep runTimeStep, SystemStorageDefinition systemStorageDefinition, int n) {
        RssAlt rssAlt = rssSystem.getAlternative();
        if (rssAlt == null) {
            return ReservoirSysOp.b(rssSystem, reservoirElementArray, runTimeStep, systemStorageDefinition, n);
        }
        rssAlt.getResSysOpSetSelection(this.getIndex());
        n = reservoirElementArray.length;
        int n2 = systemStorageDefinition.g();
        double[][] dArray = new double[n + 1][n2];
        int n3 = 0;
        int n4 = 0;
        SystemStorageZone[] systemStorageZoneArray = systemStorageDefinition.d();
        int[] nArray = systemStorageDefinition.e();
        for (n2 = 0; n2 < systemStorageZoneArray.length; ++n2) {
            n4 += nArray[n2];
            for (int i = 0; i < n; ++i) {
                ReservoirElement reservoirElement = reservoirElementArray[i];
                Object object = reservoirElement.getStorageFunction();
                NamedType namedType = systemStorageZoneArray[n2].getStorageZoneBounds(reservoirElement.getIndex());
                if ((namedType = namedType.getUpperBound()) == null) {
                    rssSystem.printWarningMessage("Reservior System Operations - Reservior: " + reservoirElement.getName() + "'s zone is null");
                    rssSystem.printWarningMessage("System Storage balance computation will be affected");
                }
                double d = namedType.getElevation(runTimeStep);
                int n5 = n3 + nArray[n2];
                dArray[i][n5] = ((Storage)object).elevationToStorage(d);
                object = systemStorageZoneArray[n2].getSystemStorage(reservoirElement.getIndex());
                object = ((SystemReservoirStorage)object).getStorageValues();
                n5 = nArray[n2];
                int n6 = ((Object)object).length;
                n5 = Math.min(n5, n6);
                if (nArray[n2] != ((Object)object).length) {
                    rssSystem.printWarningMessage("Number of zones (" + nArray.length + ") doesn't match number of values available () vals.length for System Storage Zone:" + String.valueOf(systemStorageZoneArray[n2]) + " Reservoir:" + String.valueOf(reservoirElement) + " StorageZone:" + String.valueOf(namedType));
                    rssSystem.printWarningMessage("System Storage balance computation will be affected");
                }
                for (int j = 1; j < n5; ++j) {
                    dArray[i][n3 + nArray[n2] - j] = dArray[i][n3] + object[j] / 100.0 * (dArray[i][n3 + nArray[n2]] - dArray[i][n3]);
                }
            }
            n3 += nArray[n2];
        }
        for (int i = 0; i < n4 + 2; ++i) {
            dArray[n][i] = 0.0;
            for (int j = 0; j < n; ++j) {
                double[] dArray2 = dArray[n];
                int n7 = i;
                dArray2[n7] = dArray2[n7] + dArray[j][i];
            }
        }
        return dArray;
    }

    public double[][] getZoneSystemStorageTableC(RssSystem rssSystem, ReservoirElement[] reservoirElementArray, RunTimeStep runTimeStep, SystemStorageDefinition object, int n) {
        Object object2;
        RssAlt rssAlt = rssSystem.getAlternative();
        if (rssAlt == null) {
            return ReservoirSysOp.b(rssSystem, reservoirElementArray, runTimeStep, (SystemStorageDefinition)object, n);
        }
        int n2 = reservoirElementArray.length;
        int n3 = ((SystemStorageDefinition)object).g();
        double[][] dArray = new double[n2 + 1][n3];
        double[][] dArray2 = new double[n2 + 1][n3];
        double[][] dArray3 = new double[n2 + 1][n3];
        SystemStorageZone[] systemStorageZoneArray = ((SystemStorageDefinition)object).d();
        object = ((SystemStorageDefinition)object).e();
        for (int i = 0; i < n2; ++i) {
            object2 = reservoirElementArray[i];
            object2 = this.buildResValues(rssSystem, runTimeStep, n3, systemStorageZoneArray, (ReservoirElement)object2, (int[])object, n);
            dArray[i] = (double[])object2[0];
            dArray2[i] = (double[])object2[1];
            dArray3[i] = (double[])object2[2];
        }
        double[] dArray4 = this.calcTotalArray((double[][])dArray.clone(), n2, n3);
        dArray[n2] = dArray4;
        dArray2[n2] = dArray4;
        if (n == 2) {
            return dArray2;
        }
        if (n == 1) {
            object2 = this.translatePercentageTotals((double[])dArray4.clone(), (int[])object);
            dArray3[n2] = (double[])object2;
            return dArray3;
        }
        return dArray;
    }

    private double[] translatePercentageTotals(double[] dArray, int[] nArray) {
        double[] dArray2 = new double[dArray.length];
        double[] dArray3 = dArray2;
        dArray2[0] = 0.0;
        double d = dArray[0];
        int n = 1;
        for (int i = 1; i < nArray.length; ++i) {
            int n2 = nArray[i];
            double d2 = dArray[n + n2 - 1];
            double d3 = d2 - d;
            for (int j = 0; j < n2; ++j) {
                double d4 = dArray[n + j];
                double d5 = d4 - d;
                double d6 = d5 / d3 * 100.0;
                dArray3[n + j] = d6 + (double)((i - 1) * 100);
            }
            n += n2;
            d = d2;
        }
        return dArray3;
    }

    private double[] calcTotalArray(double[][] dArray, int n, int n2) {
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += dArray[j][i];
            }
            dArray2[i] = d;
        }
        return dArray2;
    }

    private double[][] buildResValues(RssSystem rssSystem, RunTimeStep runTimeStep, int n, SystemStorageZone[] systemStorageZoneArray, ReservoirElement reservoirElement, int[] nArray, int n2) {
        double[][] dArray = new double[3][n];
        n2 = 0;
        double d = 0.0;
        for (int i = 0; i < systemStorageZoneArray.length; ++i) {
            if (systemStorageZoneArray[i] == null || systemStorageZoneArray[i].getStorageZoneBounds(reservoirElement.getIndex()) == null) {
                rssSystem.printWarningMessage("Reservior System Operations - Reservior: " + reservoirElement.getName() + "'s zone improperly configured");
                rssSystem.printWarningMessage("System Storage balance computation will be affected");
                continue;
            }
            Storage storage = reservoirElement.getStorageFunction();
            Object object = systemStorageZoneArray[i];
            NamedType namedType = ((SystemStorageZone)object).getStorageZoneBounds(reservoirElement.getIndex());
            if ((namedType = namedType.getUpperBound()) == null) {
                rssSystem.printWarningMessage("Reservior System Operations - Reservior: " + reservoirElement.getName() + "'s zone is null");
                rssSystem.printWarningMessage("System Storage balance computation will be affected");
                continue;
            }
            double d2 = namedType.getElevation(runTimeStep);
            double d3 = storage.elevationToStorage(d2);
            if (i == 0) {
                double d4;
                dArray[0][n2] = d3;
                d = d3;
                dArray[1][n2] = d4 = storage.storageToElevation(d2);
                dArray[2][n2] = 0.0;
                ++n2;
                continue;
            }
            int n3 = nArray[i];
            SystemReservoirStorage systemReservoirStorage = ((SystemStorageZone)object).getSystemStorage(reservoirElement.getIndex());
            object = systemReservoirStorage.getStorageValues();
            double d5 = d3 - d;
            for (int j = 0; j < n3; ++j) {
                double d6;
                double d7;
                double d8;
                Object object2 = object[n3 - (j + 1)];
                dArray[0][n2] = d8 = d + object2 * d5 / 100.0;
                dArray[1][n2] = d7 = storage.storageToElevation(d8);
                dArray[2][n2] = d6 = (double)(100 * (i - 1)) + object2;
                ++n2;
            }
            d = d3;
        }
        return dArray;
    }

    public double[][] getZoneSystemStorageTableB(RssSystem rssSystem, ReservoirElement[] reservoirElementArray, RunTimeStep runTimeStep, SystemStorageDefinition systemStorageDefinition, int n) {
        int n2 = reservoirElementArray.length;
        int n3 = systemStorageDefinition.f();
        double[][] dArray = new double[n2 + 1][n3];
        SystemStorageZone[] systemStorageZoneArray = systemStorageDefinition.d();
        for (int i = 0; i < n3; ++i) {
            dArray[n2][i] = 0.0;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            if (reservoirElementArray[n3] == null) continue;
            ReservoirElement reservoirElement = reservoirElementArray[n3];
            Storage storage = reservoirElementArray[n3].getStorageFunction();
            int n4 = 0;
            while (n4 < systemStorageZoneArray.length) {
                NamedType namedType = systemStorageZoneArray[n4];
                namedType = namedType.getStorageZoneBounds(reservoirElement.getIndex());
                double d = (namedType = namedType.getUpperBound()) != null ? namedType.getElevation(runTimeStep) : storage.getMinElevation();
                double d2 = storage.elevationToStorage(d);
                double d3 = n4 * 100;
                dArray[n3][n4] = n == 0 ? d2 : (n == 1 ? d3 : d);
                double[] dArray2 = dArray[n2];
                int n5 = n4++;
                dArray2[n5] = dArray2[n5] + d2;
            }
        }
        return dArray;
    }
}

