/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.ParamDouble;
import hec.lang.NamedType;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.client.AdjustmentOptions;
import hec.rss.client.AdjustmentOptions$AdjustmentLimitsType;
import hec.rss.client.AdjustmentOptions$AdjustmentStrategy;
import hec.rss.client.AdjustmentOptions$ZoneAdjustments;
import hec.rss.model.Element;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReverseReservoirYieldAnalysisBase;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.YieldAnalysis;
import hec.rss.model.YieldAnalysisData;
import hec.rss.model.YieldAnalysisRuleRef;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.ArrayUtils;

public class ReverseReservoirYieldAnalysis
extends ReverseReservoirYieldAnalysisBase
implements Cloneable {
    private AdjustmentOptions r;
    private int s = 1;
    private double t;
    private double u;
    private double v;
    private double w;
    private double x;

    public ReverseReservoirYieldAnalysis(RssAlt rssAlt) {
        super(rssAlt);
    }

    public AdjustmentOptions a() {
        return this.r;
    }

    public void a(AdjustmentOptions adjustmentOptions) {
        this.r = adjustmentOptions;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int initializeCompute(RssRun object) {
        double d;
        Object object2;
        this.l();
        ReservoirElement reservoirElement = this.k();
        int n = this.a((RssRun)object, reservoirElement);
        if (n != 0) {
            return n;
        }
        this.initializeRuleRefs(((RssRun)object).getAlternative());
        ((YieldAnalysis)this).initializeOutputArrays();
        this.r.o();
        Object object3 = object;
        object = this;
        int n2 = ((ReverseReservoirYieldAnalysisBase)object).a.getResOpSetSelection(((ReverseReservoirYieldAnalysisBase)object).b.getIndex());
        NamedType namedType = ((ReverseReservoirYieldAnalysisBase)object).b.getReservoirOp().getOperationSet(n2);
        Object object4 = namedType.getSortedZoneVector(true);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        object4 = ((Vector)object4).iterator();
        while (object4.hasNext()) {
            object2 = (StorageZone)object4.next();
            arrayList.add(object2.getIndex());
        }
        object4 = namedType.getGuideCurveZone();
        object2 = ((ReverseReservoirYieldAnalysisBase)object).m();
        Object object5 = namedType.getInactiveZone();
        StorageZone storageZone = namedType.getFloodZone();
        if (arrayList.indexOf(object4.getIndex()) < arrayList.indexOf(object2.getIndex())) {
            object3.printErrorMessage("Yield Analysis Error: Lower Limit of Con Pool Zone is above Guide Curve");
            return 1;
        }
        namedType = ((ReverseReservoirYieldAnalysis)object).a((OpSet)namedType);
        double d2 = Arrays.stream(namedType.getSeasonalRecord().getDataArray()).min().getAsDouble();
        double d3 = Arrays.stream(namedType.getSeasonalRecord().getDataArray()).max().getAsDouble();
        double d4 = Arrays.stream(((StorageZone)object5).getSeasonalRecord().getDataArray()).min().getAsDouble();
        double d5 = Arrays.stream(storageZone.getSeasonalRecord().getDataArray()).max().getAsDouble();
        object4 = "Yield Analysis Error: Upper Limit of Adjustment Strategy is below " + namedType.getDisplayName();
        object2 = "Yield Analysis Error: Upper Zone Limit of Adjustment Strategy = Zone Being Adjusted";
        object5 = "Yield Analysis Warning: Upper Limit of Adjustment Strategy is above Flood Control Zone";
        switch (((ReverseReservoirYieldAnalysis)object).r.l()) {
            case ELEVATION: {
                double d6;
                double d7 = ((ReverseReservoirYieldAnalysis)object).r.b();
                if (d6 < d2) {
                    object3.printErrorMessage((String)object4);
                    return 1;
                }
                if (!(d7 > d5)) break;
                object3.printWarningMessage((String)object5);
                break;
            }
            case STORAGE: {
                double d8;
                d = ((ReverseReservoirYieldAnalysis)object).r.d();
                double d9 = ((ReverseReservoirYieldAnalysisBase)object).b.getStorageFunction().storageToElevation(d);
                if (d8 < d2) {
                    object3.printErrorMessage((String)object4);
                    return 1;
                }
                if (!(d9 > d5)) break;
                object3.printWarningMessage((String)object5);
                break;
            }
            case ZONE: {
                int n3 = ((ReverseReservoirYieldAnalysis)object).r.e();
                if (arrayList.indexOf(n3) < arrayList.indexOf(namedType.getIndex())) {
                    object3.printErrorMessage((String)object4);
                    return 1;
                }
                if (arrayList.indexOf(n3) > arrayList.indexOf(storageZone.getIndex())) {
                    object3.printErrorMessage((String)object4);
                    return 1;
                }
                if (n3 != namedType.getIndex()) break;
                object3.printErrorMessage((String)object2);
                return 1;
            }
        }
        object4 = "Yield Analysis Error: Lower Limit of Adjustment Strategy is above " + namedType.getDisplayName();
        object2 = "Yield Analysis Error: Lower Zone Limit of Adjustment Strategy = Zone Being Adjusted";
        object5 = "Yield Analysis Warning: Lower Limit of Adjustment Strategy is below Inactive Zone";
        switch (((ReverseReservoirYieldAnalysis)object).r.m()) {
            case ELEVATION: {
                double d10;
                d = ((ReverseReservoirYieldAnalysis)object).r.a();
                if (d10 > d3) {
                    object3.printErrorMessage((String)object4);
                    return 1;
                }
                if (!((ReverseReservoirYieldAnalysis)object).r.g()) return 0;
                if (!(d < d4)) return 0;
                object3.printWarningMessage((String)object5);
                return 0;
            }
            case STORAGE: {
                double d11;
                double d12 = ((ReverseReservoirYieldAnalysis)object).r.c();
                d = ((ReverseReservoirYieldAnalysisBase)object).b.getStorageFunction().storageToElevation(d12);
                if (d11 < d3) {
                    object3.printErrorMessage((String)object4);
                    return 1;
                }
                if (!((ReverseReservoirYieldAnalysis)object).r.g()) return 0;
                if (!(d < d4)) return 0;
                object3.printWarningMessage((String)object5);
                return 0;
            }
            case ZONE: {
                int n4 = ((ReverseReservoirYieldAnalysis)object).r.f();
                if (arrayList.indexOf(n4) > arrayList.indexOf(namedType.getIndex())) {
                    object3.printErrorMessage((String)object4);
                    return 1;
                }
                if (n4 != namedType.getIndex()) return 0;
                object3.printErrorMessage((String)object2);
                return 1;
            }
        }
        return 0;
    }

    @Override
    public void initializeOutputArrays() {
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        yieldAnalysisData.initializeOutputArrays(this.getMaxIterations());
        yieldAnalysisData.setStartScale(1, 0.0);
        yieldAnalysisData.setUpperScale(1, 1.0);
        yieldAnalysisData.setLowerScale(1, -1.0);
        yieldAnalysisData.setIsBracketed(1, true);
    }

    public double a(RunTimeStep runTimeStep) {
        double d = -3.4028234663852886E38;
        switch (this.r.l()) {
            case ELEVATION: {
                d = this.r.b();
                break;
            }
            case STORAGE: {
                double d2 = this.r.d();
                d = this.b.getStorageFunction().storageToElevation(d2);
                break;
            }
            case ZONE: {
                int n = this.r.e();
                int n2 = this.a.getResOpSetSelection(this.b.getIndex());
                OpSet opSet = this.b.getReservoirOp().getOperationSet(n2);
                StorageZone storageZone = opSet.getZone(n);
                d = storageZone.getElevation(runTimeStep);
            }
        }
        return d;
    }

    public double b(RunTimeStep runTimeStep) {
        double d = -3.4028234663852886E38;
        switch (this.r.m()) {
            case ELEVATION: {
                d = this.r.a();
                break;
            }
            case STORAGE: {
                double d2 = this.r.c();
                d = this.b.getStorageFunction().storageToElevation(d2);
                break;
            }
            case ZONE: {
                int n = this.r.f();
                int n2 = this.a.getResOpSetSelection(this.b.getIndex());
                OpSet opSet = this.b.getReservoirOp().getOperationSet(n2);
                StorageZone storageZone = opSet.getZone(n);
                d = storageZone.getElevation(runTimeStep);
            }
        }
        return d;
    }

    public boolean c(RunTimeStep runTimeStep) {
        return this.r.a(runTimeStep.getHecTime());
    }

    @Override
    public int loadData(RssRun object, int n) {
        double[] dArray;
        double[] dArray2;
        Object object2;
        Object object3;
        Object object4;
        RunTimeWindow runTimeWindow = ((RssRun)object).getRunTimeWindow();
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        this.l = new ArrayList<Double[]>();
        this.m = new ArrayList<Double[]>();
        this.n = new ArrayList<Double[]>();
        this.p = new ArrayList<Double[]>();
        this.o = new ArrayList<Double[]>();
        for (OpRule object52 : this.k) {
            try {
                object4 = ReverseReservoirYieldAnalysis.getOpRuleLimitTS((RssRun)object, object52, runTimeWindow);
                object3 = ReverseReservoirYieldAnalysis.getOpRuleResultTS((RssRun)object, object52, runTimeWindow);
            }
            catch (FileNotFoundException | RemoteException iOException) {
                object3 = ((RssTSLocationObject)object52).getSystem();
                object3.printErrorMessage(iOException.getMessage());
                object3.printLogMessage(iOException.getMessage());
                yieldAnalysisData.setDecision(n, -21);
                return -21;
            }
            this.l.add(ArrayUtils.toObject((double[])object4));
            this.m.add(ArrayUtils.toObject((double[])object3));
        }
        ReverseReservoirYieldAnalysis reverseReservoirYieldAnalysis = this;
        reverseReservoirYieldAnalysis.setNumRoutingSteps(reverseReservoirYieldAnalysis.k);
        this.q = null;
        object3 = this.m().getOpSet();
        RssSystem rssSystem = ((RssTSLocationObject)object3).getSystem();
        object4 = ((OpSet)object3).getGuideCurveZone();
        try {
            object2 = ReverseReservoirYieldAnalysis.getResPoolStorTS((RssRun)object, this.b, runTimeWindow);
            object4 = ReverseReservoirYieldAnalysis.getResZoneStorTS((RssRun)object, (StorageZone)object4, runTimeWindow);
            dArray2 = ReverseReservoirYieldAnalysis.getResZoneStorTS((RssRun)object, this.e, runTimeWindow);
            this.q = ReverseReservoirYieldAnalysis.getSimulationTimeArray((RssRun)object, this.b, runTimeWindow);
        }
        catch (FileNotFoundException | RemoteException iOException) {
            rssSystem.printErrorMessage(iOException.getMessage());
            rssSystem.printLogMessage(iOException.getMessage());
            yieldAnalysisData.setDecision(n, -21);
            return -21;
        }
        this.n.add(ArrayUtils.toObject((double[])object2));
        this.p.add(ArrayUtils.toObject((double[])object4));
        this.o.add(ArrayUtils.toObject((double[])dArray2));
        object4 = this.a((OpSet)object3);
        try {
            dArray = ReverseReservoirYieldAnalysis.getResZoneElevTS((RssRun)object, (StorageZone)object4, runTimeWindow);
            object = ReverseReservoirYieldAnalysis.getResZoneStorTS((RssRun)object, (StorageZone)object4, runTimeWindow);
        }
        catch (FileNotFoundException | RemoteException iOException) {
            rssSystem.printErrorMessage(iOException.getMessage());
            rssSystem.printLogMessage(iOException.getMessage());
            return -21;
        }
        this.u = Arrays.stream(dArray).average().getAsDouble();
        this.v = Arrays.stream((double[])object).average().getAsDouble();
        return 0;
    }

    public int a(RssRun object, int n) {
        int n2 = this.m.get(0).length;
        RunTimeWindow runTimeWindow = ((RssRun)object).getRunTimeWindow();
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        int n3 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double[] dArray = ArrayUtils.toPrimitive((Double[])this.n.get(0));
        double[] dArray2 = ArrayUtils.toPrimitive((Double[])this.p.get(0));
        double d6 = this.d((RssRun)object);
        for (int i = this.s; i < n2; ++i) {
            double d7 = 0.0;
            boolean bl = false;
            for (int j = 0; j < this.k.size(); ++j) {
                Object object2 = object = this.k.get(j);
                object = this;
                object = ((YieldAnalysis)object).getYieldAnalysisRuleRefs();
                double d8 = -3.4028234663852886E38;
                object = object.iterator();
                while (object.hasNext()) {
                    YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)object.next();
                    if (yieldAnalysisRuleRef.getRule().getIndex() != object2.getIndex()) continue;
                    d8 = yieldAnalysisRuleRef.getTolerance();
                    break;
                }
                double d9 = d8;
                d = Math.min(d, d9);
                object = ArrayUtils.toPrimitive((Double[])this.m.get(j));
                double[] dArray3 = ArrayUtils.toPrimitive((Double[])this.l.get(j));
                object2 = dArray3;
                if (!((dArray3[i] - object[i]) * d6 > d9)) continue;
                bl = true;
                double d10 = Math.max((double)((object2[i] - object[i]) * d6), 0.0);
                d7 += d10;
                d2 = d9;
            }
            if (dArray2[i] - dArray[i] < 10.0) {
                d3 = 0.0;
            }
            if (bl) {
                ++n3;
            }
            d4 = Math.max(d4, d7);
            d5 = Math.max(d5, d3 += d7 * (double)runTimeWindow.getTimeStepSeconds() / Storage.DSDT_TO_Q);
        }
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        if (d2 == 0.0) {
            yieldAnalysisData.setLimitingRuleTol(n, d);
        } else {
            yieldAnalysisData.setLimitingRuleTol(n, d2);
        }
        yieldAnalysisData.setMaxDemandShortage(n, d4);
        yieldAnalysisData.setAccumDemandShortage(n, d5);
        if (n3 > 0) {
            yieldAnalysisData.setRuleTest(n, false);
            return 24;
        }
        yieldAnalysisData.setRuleTest(n, true);
        return 25;
    }

    public int a(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Double.MAX_VALUE;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl = false;
        double[] dArray = ArrayUtils.toPrimitive((Double[])this.n.get(0));
        double[] dArray2 = ArrayUtils.toPrimitive((Double[])this.p.get(0));
        double[] dArray3 = ArrayUtils.toPrimitive((Double[])this.o.get(0));
        int n9 = dArray.length;
        for (int i = this.s; i < n9; ++i) {
            double d4;
            double d5;
            double d6;
            if (dArray[i] < dArray3[i] - 10.0) {
                ++n2;
            }
            if (dArray[i] <= dArray3[i] + this.i.getValue()) {
                ++n3;
            }
            d += dArray[i];
            d2 += dArray2[i] - dArray3[i];
            ++n4;
            double d7 = dArray2[i] - dArray[i];
            if (d6 < 10.0) {
                double d8;
                n5 = this.q[i];
                d5 = dArray2[i - 1] - dArray[i - 1];
                if (d8 >= 10.0 && bl) {
                    n8 = this.q[i - 1];
                    bl = false;
                }
            }
            d5 = dArray[i] - dArray3[i];
            if (!(d4 < d3)) continue;
            d3 = d5;
            n7 = this.q[i];
            n6 = n5;
            bl = true;
        }
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        yieldAnalysisData.setAvgSimStorage(n, d / (double)n4);
        yieldAnalysisData.setAvgConPoolStorage(n, d2 / (double)n4);
        yieldAnalysisData.setStorageTest(n, n2 > 0);
        yieldAnalysisData.setStorageTolTest(n, n3 > 0);
        if (n8 < n6) {
            n8 = this.q[n9 - 1];
        }
        yieldAnalysisData.setMinStorage(n, d3);
        yieldAnalysisData.setStartCritPeriod(n, n6);
        yieldAnalysisData.setMinCritPeriod(n, n7);
        yieldAnalysisData.setEndCritPeriod(n, n8);
        if (n2 > 0) {
            return 21;
        }
        if (n3 > 0) {
            return 23;
        }
        return 22;
    }

    public boolean b(int n) {
        boolean bl = n == 21 ? this.r.g() : !this.r.g();
        n = bl ? 1 : 0;
        return bl;
    }

    public int a(RssRun rssRun) {
        double d;
        this.g = this.b(this.getYieldAnalysisData().getDecision(1));
        double d2 = d = this.g ? 1.0 : -1.0;
        if (this.r.h() == AdjustmentOptions$AdjustmentStrategy.SLIDE_PATTERN || this.r.n() == AdjustmentOptions$ZoneAdjustments.PROPORTIONALLY_SCALE) {
            int n = this.a.getResOpSetSelection(this.b.getIndex());
            Object object = this.b.getReservoirOp().getOperationSet(n);
            RssSystem rssSystem = ((RssTSLocationObject)object).getSystem();
            Object object2 = this.a((OpSet)object);
            RunTimeWindow runTimeWindow = rssRun.getRunTimeWindow();
            try {
                object2 = ReverseReservoirYieldAnalysis.getResZoneElevTS(rssRun, (StorageZone)object2, runTimeWindow);
            }
            catch (FileNotFoundException | RemoteException iOException) {
                rssSystem.printErrorMessage(iOException.getMessage());
                rssSystem.printLogMessage(iOException.getMessage());
                return -21;
            }
            double d3 = 0.0;
            this.h = 0.0;
            double[] dArray = null;
            this.t = Arrays.stream((double[])object2).average().getAsDouble();
            AdjustmentOptions$AdjustmentLimitsType adjustmentOptions$AdjustmentLimitsType = this.g ? this.r.l() : this.r.m();
            switch (adjustmentOptions$AdjustmentLimitsType) {
                case ELEVATION: {
                    int n2;
                    d3 = this.g ? this.r.b() : this.r.a();
                    for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
                        this.h = Math.max(this.h, d * (d3 - object2[n2]));
                    }
                    break;
                }
                case STORAGE: {
                    int n2;
                    double d4 = this.g ? this.r.d() : this.r.c();
                    d3 = this.b.getStorageFunction().storageToElevation(d4);
                    for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
                        this.h = Math.max(this.h, d * (d3 - object2[n2]));
                    }
                    break;
                }
                case ZONE: {
                    int n2;
                    int n3 = this.g ? this.r.e() : this.r.f();
                    StorageZone storageZone = ((OpSet)object).getZone(n3);
                    try {
                        dArray = ReverseReservoirYieldAnalysis.getResZoneElevTS(rssRun, storageZone, runTimeWindow);
                    }
                    catch (FileNotFoundException | RemoteException iOException) {
                        rssSystem.printErrorMessage(iOException.getMessage());
                        rssSystem.printLogMessage(iOException.getMessage());
                        return -21;
                    }
                    d3 = Arrays.stream(dArray).average().getAsDouble();
                    for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
                        this.h = Math.max(this.h, d * (dArray[n2] - object2[n2]));
                    }
                    break;
                }
            }
            if (this.g) {
                this.w = d3;
            } else {
                this.x = d3;
            }
            if (this.r.n() == AdjustmentOptions$ZoneAdjustments.PROPORTIONALLY_SCALE) {
                Object object3 = this.g ? this.b((OpSet)object) : this.c((OpSet)object);
                object = object3.iterator();
                while (object.hasNext()) {
                    object2 = (StorageZone)object.next();
                    try {
                        object3 = ReverseReservoirYieldAnalysis.getResZoneElevTS(rssRun, (StorageZone)object2, runTimeWindow);
                    }
                    catch (FileNotFoundException | RemoteException iOException) {
                        rssSystem.printErrorMessage(iOException.getMessage());
                        rssSystem.printLogMessage(iOException.getMessage());
                        return -21;
                    }
                    double d5 = 0.0;
                    switch (adjustmentOptions$AdjustmentLimitsType) {
                        case ELEVATION: {
                            for (int i = 0; i < ((Object)object3).length; ++i) {
                                d5 = Math.max(d5, d * (d3 - object3[i]));
                            }
                            break;
                        }
                        case STORAGE: {
                            for (int i = 0; i < ((Object)object3).length; ++i) {
                                d5 = Math.max(d5, d * (d3 - object3[i]));
                            }
                            break;
                        }
                        case ZONE: {
                            for (int i = 0; i < ((Object)object3).length; ++i) {
                                d5 = Math.max(d5, d * (dArray[i] - object3[i]));
                            }
                            break;
                        }
                    }
                    double d6 = 1.0 - d5 / this.h;
                    d6 = Math.max(0.0, Math.min(1.0, d6));
                    ((StorageZone)object2).setProportionScale(d6);
                }
            }
        }
        return 0;
    }

    public StorageZone a(OpSet namedType) {
        namedType = this.r.g() ? namedType.getGuideCurveZone() : this.m();
        return namedType;
    }

    public List<StorageZone> b(OpSet opSet) {
        Cloneable cloneable;
        Object object = opSet.getSortedZoneVector(true);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Object object2 = ((Vector)object).iterator();
        while (object2.hasNext()) {
            cloneable = object2.next();
            arrayList.add(cloneable.getIndex());
        }
        object2 = this.a(opSet);
        cloneable = new ArrayList();
        boolean bl = false;
        object = ((Vector)object).iterator();
        while (object.hasNext()) {
            StorageZone storageZone = (StorageZone)object.next();
            if (storageZone.getIndex() == object2.getIndex()) {
                bl = true;
                continue;
            }
            if (bl) {
                double d = Arrays.stream(storageZone.getSeasonalRecord().getDataArray()).min().getAsDouble();
                switch (this.r.l()) {
                    case ELEVATION: {
                        double d2;
                        double d3 = this.r.b();
                        if (!(d2 < d)) break;
                        cloneable.add(storageZone);
                        break;
                    }
                    case STORAGE: {
                        double d4;
                        double d5 = this.r.d();
                        double d3 = this.b.getStorageFunction().storageToElevation(d5);
                        if (!(d4 < d)) break;
                        cloneable.add(storageZone);
                        break;
                    }
                    case ZONE: {
                        int n = this.r.e();
                        if (arrayList.indexOf(storageZone.getIndex()) >= arrayList.indexOf(n)) break;
                        cloneable.add(storageZone);
                    }
                }
            }
        }
        return cloneable;
    }

    public List<StorageZone> c(OpSet object) {
        Cloneable cloneable;
        Cloneable cloneable2 = ((OpSet)object).getSortedZoneVector(true);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Object object2 = ((Vector)cloneable2).iterator();
        while (object2.hasNext()) {
            cloneable = object2.next();
            arrayList.add(cloneable.getIndex());
        }
        object2 = this.a((OpSet)object);
        cloneable = new ArrayList();
        object = ((Vector)cloneable2).iterator();
        while (object.hasNext() && (cloneable2 = (StorageZone)object.next()).getIndex() != object2.getIndex()) {
            double d = Arrays.stream(((StorageZone)cloneable2).getSeasonalRecord().getDataArray()).max().getAsDouble();
            switch (this.r.m()) {
                case ELEVATION: {
                    double d2;
                    double d3 = this.r.a();
                    if (!(d2 < d)) break;
                    cloneable.add(cloneable2);
                    break;
                }
                case STORAGE: {
                    double d4;
                    double d5 = this.r.c();
                    double d3 = this.b.getStorageFunction().storageToElevation(d5);
                    if (!(d4 < d)) break;
                    cloneable.add(cloneable2);
                    break;
                }
                case ZONE: {
                    int n = this.r.f();
                    if (arrayList.indexOf(cloneable2.getIndex()) <= arrayList.indexOf(n)) break;
                    cloneable.add(cloneable2);
                }
            }
        }
        return cloneable;
    }

    public void a(boolean bl) {
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        if (bl) {
            yieldAnalysisData.setLowerScale(2, 0.0);
            yieldAnalysisData.setUpperScale(2, 1.0);
            yieldAnalysisData.setEndScale(1, 1.0);
            yieldAnalysisData.setStartScale(2, 1.0);
        } else {
            yieldAnalysisData.setLowerScale(2, -1.0);
            yieldAnalysisData.setUpperScale(2, 0.0);
            yieldAnalysisData.setEndScale(1, -1.0);
            yieldAnalysisData.setStartScale(2, -1.0);
        }
        yieldAnalysisData.setIsBracketed(2, true);
    }

    public void c(int n) {
        double d;
        boolean bl;
        double d2;
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        int n2 = n + 1;
        double d3 = yieldAnalysisData.getStartScale(n);
        int n3 = yieldAnalysisData.getDecision(n);
        if (n3 == 21) {
            d2 = yieldAnalysisData.getAccumDemandShortage(n);
            bl = this.a().g();
        } else {
            d2 = yieldAnalysisData.getMinStorage(n) - 0.5 * this.p().getValue();
            bl = !this.a().g();
        }
        n3 = bl ? 1 : 0;
        if (bl) {
            double d4;
            double d5 = d2;
            ReverseReservoirYieldAnalysis reverseReservoirYieldAnalysis = this;
            double d6 = reverseReservoirYieldAnalysis.v + d5;
            double d7 = reverseReservoirYieldAnalysis.b.getStorageFunction().storageToElevation(d6);
            double d8 = Math.max(d7 - reverseReservoirYieldAnalysis.u, 0.0);
            double d9 = reverseReservoirYieldAnalysis.g ? reverseReservoirYieldAnalysis.w - reverseReservoirYieldAnalysis.t : reverseReservoirYieldAnalysis.t - reverseReservoirYieldAnalysis.x;
            double d10 = d4 = d8 / d9;
            d = d3 + d10;
            d = this.g ? Math.max(0.0, Math.min(d, 1.0)) : Math.max(-1.0, Math.min(d, 0.0));
            yieldAnalysisData.setLowerScale(n2, yieldAnalysisData.getStartScale(n));
            yieldAnalysisData.setUpperScale(n2, yieldAnalysisData.getUpperScale(n));
            yieldAnalysisData.setHeuristicRatioIncr(n, d);
            yieldAnalysisData.setHeuristicRatioDecr(n, -3.4028234663852886E38);
        } else {
            double d11;
            double d12 = d2;
            ReverseReservoirYieldAnalysis reverseReservoirYieldAnalysis = this;
            double d13 = reverseReservoirYieldAnalysis.v - d12;
            double d14 = reverseReservoirYieldAnalysis.b.getStorageFunction().storageToElevation(d13);
            double d15 = Math.min(d14 - reverseReservoirYieldAnalysis.u, 0.0);
            double d16 = reverseReservoirYieldAnalysis.g ? reverseReservoirYieldAnalysis.w - reverseReservoirYieldAnalysis.t : reverseReservoirYieldAnalysis.t - reverseReservoirYieldAnalysis.x;
            double d17 = d11 = d15 / d16;
            d = d3 + d17;
            d = this.g ? Math.max(0.0, Math.min(d, 1.0)) : Math.max(-1.0, Math.min(d, 0.0));
            yieldAnalysisData.setLowerScale(n2, yieldAnalysisData.getLowerScale(n));
            yieldAnalysisData.setUpperScale(n2, yieldAnalysisData.getStartScale(n));
            yieldAnalysisData.setHeuristicRatioDecr(n, d);
            yieldAnalysisData.setHeuristicRatioIncr(n, -3.4028234663852886E38);
        }
        yieldAnalysisData.setEndScale(n, d);
        yieldAnalysisData.setStartScale(n2, d);
        yieldAnalysisData.setIsBracketed(n2, true);
    }

    @Override
    public boolean writeFile(BufferedWriter bufferedWriter, RssAlt rssAlt) throws IOException {
        if (bufferedWriter == null) {
            return false;
        }
        bufferedWriter.write("ReverseReservoirYieldAnalysisBegin");
        bufferedWriter.newLine();
        super.writeFile(bufferedWriter, rssAlt);
        bufferedWriter.write("ReverseReservoirYieldAnalysisEnd");
        bufferedWriter.newLine();
        return true;
    }

    @Override
    final void a(BufferedWriter bufferedWriter) throws IOException {
        this.r.a(bufferedWriter);
    }

    @Override
    public boolean readFile(BufferedReader bufferedReader) throws IOException {
        String string;
        if (bufferedReader == null) {
            return false;
        }
        while ((string = bufferedReader.readLine()) != null) {
            if ("ReverseReservoirYieldAnalysisEnd".equalsIgnoreCase(string)) {
                return true;
            }
            if ("YieldAnalysisBegin".equalsIgnoreCase(string)) {
                super.readFile(bufferedReader);
                continue;
            }
            if ("SatisfyMapBegin".equalsIgnoreCase(string)) {
                this.b(bufferedReader);
                continue;
            }
            if ("ReservoirDataBegin".equalsIgnoreCase(string)) {
                this.a(bufferedReader);
                continue;
            }
            if (!"AdjustmentOptionsBegin".equalsIgnoreCase(string)) continue;
            this.r = AdjustmentOptions.a(bufferedReader);
        }
        return true;
    }

    @Override
    public Object clone() {
        try {
            StorageZone storageZone;
            ReverseReservoirYieldAnalysis reverseReservoirYieldAnalysis = (ReverseReservoirYieldAnalysis)super.clone();
            reverseReservoirYieldAnalysis.a(this.r());
            if (this.r != null) {
                reverseReservoirYieldAnalysis.a(this.r.q());
            }
            if (this.b != null) {
                reverseReservoirYieldAnalysis.a((ReservoirElement)((Element)this.b).clone());
            }
            if (this.i != null) {
                reverseReservoirYieldAnalysis.c((ParamDouble)this.i.clone());
            }
            if ((storageZone = this.m()) != null) {
                reverseReservoirYieldAnalysis.a((StorageZone)storageZone.clone());
            }
            reverseReservoirYieldAnalysis.d = this.d;
            reverseReservoirYieldAnalysis.c = this.c;
            reverseReservoirYieldAnalysis.f = this.f;
            return reverseReservoirYieldAnalysis;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            CloneNotSupportedException cloneNotSupportedException2 = cloneNotSupportedException;
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }
}

