/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.model.RunTimeWindow;
import hec.rss.client.ReverseWaterAccountAdjustmentOptions;
import hec.rss.client.ReverseWaterAccountMaxAdjustmentTypes;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReverseYieldAnalysisBase;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.StorageZone;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.SystemHydropowerOpRule;
import hec.rss.model.WaterAccount;
import hec.rss.model.WaterAccountSet;
import hec.rss.model.YieldAnalysis;
import hec.rss.model.YieldAnalysisData;
import hec.rss.model.YieldAnalysisRuleRef;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import rma.util.RMAIO;

public class ReverseWaterAccountYieldAnalysis
extends ReverseYieldAnalysisBase {
    private ReverseWaterAccountAdjustmentOptions a;
    private WaterAccount b = null;
    private RssAlt c;
    private int d = Integer.MIN_VALUE;
    private double e;

    public ReverseWaterAccountYieldAnalysis(RssAlt rssAlt) {
        this.c = rssAlt;
    }

    public void a(ReverseWaterAccountAdjustmentOptions reverseWaterAccountAdjustmentOptions) {
        this.a = reverseWaterAccountAdjustmentOptions;
    }

    @Override
    public Map<Integer, Boolean> a_() {
        return this.j;
    }

    @Override
    public void a(Map<Integer, Boolean> map) {
        this.j = map;
    }

    public ReverseWaterAccountAdjustmentOptions b() {
        return this.a;
    }

    public void a(int n) {
        this.d = n;
    }

    public int c() {
        return this.d;
    }

    public WaterAccount d() {
        if (this.b == null) {
            this.h();
        }
        return this.b;
    }

    private void h() {
        WaterAccountSet waterAccountSet = this.c.getWaterAccountSet();
        if (waterAccountSet != null) {
            this.b = waterAccountSet.getWaterAccountSet(this.d);
        }
    }

    public ReservoirElement e() {
        Object object = this.d();
        object = ((WaterAccount)object).getRuleRefs();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            if (!((YieldAnalysisRuleRef)object2).isInitialized()) {
                ((YieldAnalysisRuleRef)object2).initializeData(this.c.getSystem());
            }
            if (!((object2 = ((YieldAnalysisRuleRef)object2).getRuleOwner()) instanceof ReservoirElement)) continue;
            object = (ReservoirElement)object2;
            return object;
        }
        return null;
    }

    public StorageZone f() {
        Iterator iterator = this.c.getWaterAccountSet();
        ReservoirElement reservoirElement = this.e();
        iterator = ((WaterAccountSet)((Object)iterator)).getResZoneRefs();
        StorageZone storageZone = null;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            StorageZoneRef storageZoneRef = (StorageZoneRef)iterator.next();
            if (storageZoneRef.getReservoirIndex() != reservoirElement.getIndex()) continue;
            storageZone = reservoirElement.getStorageZone(storageZoneRef.getOpsetId(), storageZoneRef.getZoneIndex());
        }
        return storageZone;
    }

    public void a(WaterAccount waterAccount) {
        this.b = waterAccount;
    }

    @Override
    public int initializeCompute(RssRun object) {
        int n;
        int n2;
        double d;
        Cloneable cloneable;
        ReverseWaterAccountYieldAnalysis reverseWaterAccountYieldAnalysis;
        Object object2;
        block11: {
            block10: {
                block9: {
                    this.h();
                    this.a(((RssRun)object).getAlternative());
                    ((YieldAnalysis)this).initializeOutputArrays();
                    object2 = object;
                    reverseWaterAccountYieldAnalysis = this;
                    cloneable = reverseWaterAccountYieldAnalysis.b();
                    if (((ReverseWaterAccountAdjustmentOptions)cloneable).a() != ReverseWaterAccountMaxAdjustmentTypes.CONSTANT) break block9;
                    d = ((ReverseWaterAccountAdjustmentOptions)cloneable).c();
                    object = reverseWaterAccountYieldAnalysis.e();
                    int n3 = ((RssRun)object2).getAlternative().getResOpSetSelection(object.getIndex());
                    OpSet opSet = ((ReservoirElement)object).getReservoirOp().getOperationSet(n3);
                    StorageZone storageZone = opSet.getGuideCurveZone();
                    StorageZone storageZone2 = reverseWaterAccountYieldAnalysis.f();
                    double d2 = Arrays.stream(storageZone.getSeasonalRecord().getDataArray()).min().getAsDouble();
                    double d3 = ((ReservoirElement)object).getStorageFunction().elevationToStorage(d2);
                    double d4 = Arrays.stream(storageZone2.getSeasonalRecord().getDataArray()).max().getAsDouble();
                    double d5 = ((ReservoirElement)object).getStorageFunction().elevationToStorage(d4);
                    if (!(d > d3 - d5)) break block10;
                    object2.printErrorMessage("Yield Analysis Error: Max Water Account Storage exceeds Water Supply Pool Storage.");
                    n2 = 1;
                    break block11;
                }
                WaterAccountSet waterAccountSet = ((RssRun)object2).getAlternative().getWaterAccountSet();
                ReservoirElement reservoirElement = reverseWaterAccountYieldAnalysis.e();
                if (reservoirElement != null) {
                    object = waterAccountSet.getWaterAccounts(reservoirElement);
                    boolean bl = true;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        WaterAccount waterAccount = (WaterAccount)iterator.next();
                        if (waterAccount == reverseWaterAccountYieldAnalysis.b || waterAccount.usePercentOfCon()) continue;
                        bl = false;
                    }
                    if (bl) {
                        double d6 = 0.0;
                        Iterator iterator2 = object.iterator();
                        while (iterator2.hasNext()) {
                            WaterAccount waterAccount = (WaterAccount)iterator2.next();
                            if (waterAccount == reverseWaterAccountYieldAnalysis.b) {
                                d6 += ((ReverseWaterAccountAdjustmentOptions)cloneable).b();
                                continue;
                            }
                            d6 += waterAccount.getPercentOfCon();
                        }
                        if (d6 > 100.0) {
                            object2.printWarningMessage("Yield Analysis Warning: Max Water Account Storage may exceed Water Supply Pool Storage.");
                        }
                    }
                }
            }
            n2 = n = 0;
        }
        if (n2 == 1) {
            return n;
        }
        reverseWaterAccountYieldAnalysis = this;
        object2 = reverseWaterAccountYieldAnalysis.b();
        cloneable = reverseWaterAccountYieldAnalysis.d();
        if (((ReverseWaterAccountAdjustmentOptions)object2).a() == ReverseWaterAccountMaxAdjustmentTypes.PERCENT_OF_CON) {
            d = ((ReverseWaterAccountAdjustmentOptions)object2).b();
            ((WaterAccount)cloneable).setUsePercentOfCon(true);
            ((WaterAccount)cloneable).setPercentOfCon(d);
        } else {
            d = ((ReverseWaterAccountAdjustmentOptions)object2).c();
            ((WaterAccount)cloneable).setUsePercentOfCon(false);
            ((WaterAccount)cloneable).setMaxStorage(d);
        }
        return n;
    }

    public void a(RssAlt rssAlt) {
        Object object = this.getYieldAnalysisRuleRefs();
        object = object.iterator();
        while (object.hasNext()) {
            YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)object.next();
            yieldAnalysisRuleRef.initializeDataForCompute(rssAlt);
            if (!(yieldAnalysisRuleRef.getRule() instanceof SystemHydropowerOpRule)) continue;
            this.setUseHydropowerRules(true);
        }
    }

    @Override
    public void initializeOutputArrays() {
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        yieldAnalysisData.initializeOutputArrays(this.getMaxIterations());
        yieldAnalysisData.setStartScale(1, 1.0);
        yieldAnalysisData.setUpperScale(1, 1.0);
        yieldAnalysisData.setLowerScale(1, 0.0);
        yieldAnalysisData.setIsBracketed(1, true);
    }

    public int a(RssRun object) {
        RunTimeWindow runTimeWindow = ((RssRun)object).getRunTimeWindow();
        Object object2 = this.d();
        object2 = ((WaterAccount)object2).getStorageZone();
        OpSet opSet = this.e().getReservoirOp().getActiveOpSet();
        StorageZone storageZone = opSet.getGuideCurveZone();
        try {
            object2 = ReverseWaterAccountYieldAnalysis.getResZoneStorTS((RssRun)object, (StorageZone)object2, runTimeWindow);
            object = ReverseWaterAccountYieldAnalysis.getResZoneStorTS((RssRun)object, storageZone, runTimeWindow);
        }
        catch (FileNotFoundException | RemoteException iOException) {
            RssSystem rssSystem = ((RssTSLocationObject)opSet).getSystem();
            rssSystem.printErrorMessage(iOException.getMessage());
            rssSystem.printLogMessage(iOException.getMessage());
            return 1;
        }
        double d = 0.0;
        for (int i = 0; i < ((Object)object2).length; ++i) {
            d += object[i] - object2[i];
        }
        this.e = d / (double)((Object)object2).length;
        return 0;
    }

    public double a(double d) {
        double d2 = this.a.a() == ReverseWaterAccountMaxAdjustmentTypes.CONSTANT ? d / this.a.c() : d / (this.e * this.a.b() / 100.0);
        return d2;
    }

    public void b(int n) {
        double d;
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        int n2 = n + 1;
        int n3 = yieldAnalysisData.getDecision(n);
        double d2 = yieldAnalysisData.getStartScale(n);
        if (n3 == 21) {
            double d3 = yieldAnalysisData.getAccumDemandShortage(n);
            double d4 = this.a(d3);
            d = d2 + d4;
            d = Math.max(0.0, Math.min(d, 1.0));
            yieldAnalysisData.setLowerScale(n2, yieldAnalysisData.getStartScale(n));
            yieldAnalysisData.setUpperScale(n2, yieldAnalysisData.getUpperScale(n));
            yieldAnalysisData.setHeuristicRatioIncr(n, d);
            yieldAnalysisData.setHeuristicRatioDecr(n, -3.4028234663852886E38);
        } else {
            double d5 = yieldAnalysisData.getMinStorage(n) - 0.5 * this.p().getValue();
            double d6 = this.a(d5);
            d = d2 - d6;
            d = Math.max(0.0, Math.min(d, 1.0));
            yieldAnalysisData.setLowerScale(n2, yieldAnalysisData.getLowerScale(n));
            yieldAnalysisData.setUpperScale(n2, yieldAnalysisData.getStartScale(n));
            yieldAnalysisData.setHeuristicRatioDecr(n, d);
            yieldAnalysisData.setHeuristicRatioIncr(n, -3.4028234663852886E38);
        }
        yieldAnalysisData.setEndScale(n, d);
        yieldAnalysisData.setStartScale(n2, d);
        yieldAnalysisData.setIsBracketed(n2, true);
    }

    public void c(int n) {
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        double d = yieldAnalysisData.getStartScale(n);
        if (this.a.a() == ReverseWaterAccountMaxAdjustmentTypes.PERCENT_OF_CON) {
            double d2 = this.a.b();
            double d3 = d * d2;
            this.b.setPercentOfCon(d3);
            return;
        }
        double d4 = this.a.c();
        double d5 = d * d4;
        this.b.setMaxStorage(d5);
    }

    @Override
    public boolean writeFile(BufferedWriter bufferedWriter, RssAlt rssAlt) throws IOException {
        if (bufferedWriter == null) {
            return false;
        }
        bufferedWriter.write("ReverseWaterAccountYieldAnalysisBegin");
        bufferedWriter.newLine();
        bufferedWriter.write("Tolerance=" + String.valueOf(this.p()));
        bufferedWriter.newLine();
        bufferedWriter.write("WaterAccountIndex=" + this.d);
        bufferedWriter.newLine();
        super.writeFile(bufferedWriter, rssAlt);
        this.c(bufferedWriter);
        this.a.a(bufferedWriter);
        bufferedWriter.write("ReverseWaterAccountYieldAnalysisEnd");
        bufferedWriter.newLine();
        return true;
    }

    @Override
    public boolean readFile(BufferedReader bufferedReader) throws IOException {
        String string;
        if (bufferedReader == null) {
            return false;
        }
        int n = this.c.getUnitSystem();
        while ((string = bufferedReader.readLine()) != null) {
            int n2 = string.indexOf(61);
            if (n2 >= 0) {
                String string2 = RMAIO.getType((String)string, (String)"=");
                string = RMAIO.getParam((String)string, (String)"=");
                if ("Tolerance".equals(string2)) {
                    double d = RMAIO.parseDouble((String)string);
                    this.i = new ParamDouble(d, Parameter.PARAMID_STOR, n);
                    continue;
                }
                if (!"WaterAccountIndex".equals(string2)) continue;
                this.a(Integer.parseInt(string));
                continue;
            }
            if ("ReverseWaterAccountYieldAnalysisEnd".equalsIgnoreCase(string)) {
                return true;
            }
            if (string.startsWith("YieldAnalysisBegin")) {
                super.readFile(bufferedReader);
                continue;
            }
            if ("SatisfyMapBegin".equalsIgnoreCase(string)) {
                this.b(bufferedReader);
                continue;
            }
            if (!"AdjustmentOptionsBegin".equalsIgnoreCase(string)) continue;
            this.a = ReverseWaterAccountAdjustmentOptions.a(bufferedReader);
        }
        return true;
    }

    public ReverseWaterAccountYieldAnalysis g() {
        try {
            ParamDouble paramDouble;
            ReverseWaterAccountYieldAnalysis reverseWaterAccountYieldAnalysis = (ReverseWaterAccountYieldAnalysis)super.clone();
            if (this.a != null) {
                reverseWaterAccountYieldAnalysis.a(this.a.f());
            }
            if ((paramDouble = this.p()) != null) {
                reverseWaterAccountYieldAnalysis.c((ParamDouble)paramDouble.clone());
            }
            ((ReverseYieldAnalysisBase)reverseWaterAccountYieldAnalysis).a(this.r());
            reverseWaterAccountYieldAnalysis.d = this.d;
            if (this.b != null) {
                reverseWaterAccountYieldAnalysis.b = (WaterAccount)((RssTSLocationObject)this.b).clone();
            }
            return reverseWaterAccountYieldAnalysis;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Logger.getLogger(ReverseWaterAccountYieldAnalysis.class.getName()).warning("Unable to clone reverse water account yield analysis." + String.valueOf(cloneNotSupportedException));
            return null;
        }
    }

    @Override
    public /* synthetic */ Object clone() {
        return this.g();
    }
}

