/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.model.RunTimeStep;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.Element;
import hec.rss.model.ReversiblePumpAdjustableParameter;
import rma.util.RMAConst;

public class ReversiblePumpFlow
extends AdjustableFlow {
    public ReversiblePumpFlow() {
        this.setHasPowerPlant(true);
        this.setHasPump(true);
    }

    public ReversiblePumpFlow(Element element) {
        super(element);
        this.setHasPump(true);
        this.setHasPowerPlant(true);
    }

    @Override
    protected AdjustableParameter createDefaultAdjustableParameter() {
        ReversiblePumpAdjustableParameter reversiblePumpAdjustableParameter = new ReversiblePumpAdjustableParameter(this);
        reversiblePumpAdjustableParameter.setName("Flow");
        return reversiblePumpAdjustableParameter;
    }

    public double getCurrentPumpCapacity(RunTimeStep runTimeStep) {
        double d = this.a.array[runTimeStep.step];
        if (!RMAConst.isValidValue((double)d)) {
            int n = runTimeStep.step > 0 ? runTimeStep.step - 1 : 0;
            d = this.a.array[n];
        }
        return -1.0 * this.getPump().computeMaximumCapacity(runTimeStep, d);
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        if (this.c == null || this.b == null) {
            this.printErrorMessage("computeForecastStep", "missing timeseries arrays" + this._hindcastCondition);
            this.element.getSystem().printMessage("Date and Time: " + runTimeStep.dateTimeString());
            return 1;
        }
        if (this._tailElev != null && this._hasTailElev) {
            this._tailElev.computeElevation(runTimeStep);
        }
        this._flowParam.setMinValue(this.getCurrentPumpCapacity(runTimeStep));
        this._flowParam.setMaxValue(this.getCurrentCapacity(runTimeStep));
        double d = this._flowParam.getValue(runTimeStep);
        double d2 = this.getCurrentPumpCapacity(runTimeStep);
        if (d < d2) {
            d = d2;
        }
        this.c.array[runTimeStep.step] = d;
        this.b.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int computeHindcastStep(RunTimeStep runTimeStep) {
        block6: {
            if (this.c == null) {
                return 1;
            }
            if (this._hindcastCondition == 1) {
                if (this.d != null && RMAConst.isValidValue((double)this.d.array[runTimeStep.step])) {
                    this.c.array[runTimeStep.step] = this.d.array[runTimeStep.step];
                    break block6;
                } else {
                    this.printErrorMessage("computeHindcastStep", "known release TS empty or invalid");
                    this.element.getSystem().printMessage("Date and Time: " + runTimeStep.dateTimeString());
                    return 1;
                }
            }
            if (this._hindcastCondition != 0) {
                this.printErrorMessage("computeHindcastStep", "unknown hindcast equation " + this._hindcastCondition);
                this.element.getSystem().printMessage("Date and Time: " + runTimeStep.dateTimeString());
                return 1;
            }
            this.c.array[runTimeStep.step] = this._initialRelease;
        }
        if (this._tailElev != null && this._hasTailElev) {
            this._tailElev.computeElevation(runTimeStep);
        }
        this._flowParam.setMaxValue(this.getCurrentCapacity(runTimeStep));
        this._flowParam.setMinValue(this.getCurrentPumpCapacity(runTimeStep));
        this._flowParam.setValue(this.c.array[runTimeStep.step]);
        this.b.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        return 0;
    }
}

