/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.ChannelType;
import hec.rss.model.CoefRouting;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.LagAndKRouting;
import hec.rss.model.MuskingumCunge8ptRouting;
import hec.rss.model.MuskingumCungePrismRouting;
import hec.rss.model.MuskingumCungeRouting;
import hec.rss.model.MuskingumRouting;
import hec.rss.model.NullRouting;
import hec.rss.model.PulsChannelRouting;
import hec.rss.model.PulsChannelRoutingWithLosses;
import hec.rss.model.RssNode;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.RunTime;
import hec.rss.model.SsarrRouting;
import hec.rss.model.WorkingRDRouting;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import rma.util.RMAConst;

public class Routing
extends Function
implements AltInputReportInfc {
    transient RssNode _upNode = null;
    transient RssNode _dnNode = null;
    transient double[] _tsUpstrm = null;
    transient double[] _tsDnstrm = null;
    transient double[] _tsObs = null;
    protected transient boolean _shouldCheckHotstart;
    public static final String FLOW = "Flow";

    public Routing() {
    }

    public Routing(Element element) {
        super(element);
    }

    public double[] getDefaultCoefArray() {
        RunTimeWindow runTimeWindow = this.getElement().getSystem().getRssRun().getRunTimeWindow();
        int n = runTimeWindow.getNumSteps();
        int n2 = runTimeWindow.getNumLookbackSteps();
        double[] dArray = new double[n + 1];
        Arrays.fill(dArray, 200.0);
        dArray[n2] = 100.0;
        double[] dArray2 = new double[n + 1];
        Arrays.fill(dArray2, 200.0);
        runTimeWindow = new RunTimeStep(runTimeWindow);
        v0.nstep = n + 1;
        Object[] objectArray = new Object[n + 1];
        for (int i = 0; i <= n; ++i) {
            objectArray[i] = this.newRouteData();
        }
        this.computeRouting((RunTimeStep)runTimeWindow, dArray, dArray2, objectArray, dArray2);
        double d = 0.0;
        int n3 = -1;
        while (n >= n2) {
            dArray2[n] = (200.0 - dArray2[n]) / 100.0;
            if (n3 < 0 && Math.abs(dArray2[n]) > 1.0E-8) {
                n3 = n;
            }
            if (n3 >= 0) {
                d += dArray2[n];
            }
            --n;
        }
        n = n3 - n2 + 1;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = dArray2[n2 + i] / d;
        }
        return dArray3;
    }

    public boolean estimateCoefRouting(RunTimeStep runTimeStep, double[] dArray) {
        int n;
        if (runTimeStep.step == 0) {
            return false;
        }
        int n2 = dArray.length;
        double d = 0.0;
        this.computeRouting(runTimeStep);
        for (n = 0; n < n2; ++n) {
            int n3 = runTimeStep.step - n;
            if (n3 < 0) {
                dArray[n] = 0.0;
                continue;
            }
            double d2 = this._tsUpstrm[n3];
            double d3 = this._tsDnstrm[runTimeStep.step];
            int n4 = n3;
            this._tsUpstrm[n4] = this._tsUpstrm[n4] + 1.0;
            this.computeRouting(runTimeStep);
            dArray[n] = this._tsDnstrm[runTimeStep.step] - d3;
            d += dArray[n];
            this._tsUpstrm[n3] = d2;
            this._tsDnstrm[runTimeStep.step] = d3;
        }
        this.computeRouting(runTimeStep);
        if (Math.abs(d) >= 1.0E-9) {
            n = 0;
            while (n < n2) {
                int n5 = n++;
                dArray[n5] = dArray[n5] / d;
            }
        }
        return true;
    }

    @Override
    public boolean initialize() {
        if (!super.initialize()) {
            return false;
        }
        this._upNode = null;
        this._dnNode = null;
        this._tsUpstrm = null;
        this._tsDnstrm = null;
        this._tsObs = null;
        this._upNode = this.element.getNode(0);
        this._dnNode = this.element.getNode(1);
        if (this._upNode == null || this._dnNode == null) {
            this.element.getSystem().printErrorMessage("Routing.intialize: failed to get connecting nodes");
            this.element.getSystem().printErrorMessage("Element: " + this.element.getName());
            return false;
        }
        this._tsUpstrm = this._upNode.getTSArray(0);
        this._tsDnstrm = this._dnNode.getTSArray(0);
        if (this._tsUpstrm == null || this._tsDnstrm == null) {
            this.element.getSystem().printErrorMessage("Routing.intialize: failed to get flow time series");
            this.element.getSystem().printErrorMessage("Element: " + this.element.getName());
            return false;
        }
        this._tsObs = this._dnNode.getTSArray(FLOW, true);
        return true;
    }

    public int computeHindcast(RunTimeWindow runTimeWindow, int n) {
        RunTimeStep runTimeStep = new RunTimeStep(runTimeWindow);
        new RunTimeStep(runTimeWindow).step = 0;
        runTimeStep.nstep = runTimeWindow.getNumLookbackSteps() + 1;
        runTimeStep.flag = n;
        if (this._tsObs != null && n == 0) {
            int n2 = runTimeStep.step;
            if (n2 < runTimeStep.nstep) {
                this._tsDnstrm[n2] = this._tsObs[n2];
                if (RMAConst.isValidValue((double)this._tsDnstrm[n2])) {
                    return 1;
                }
                this.element.getSystem().printErrorMessage("Routing.getHindcastEquation: known flow TS empty or invalid");
                this.element.getSystem().printErrorMessage("Element: " + this.element.getName());
                this.element.getSystem().printErrorMessage("Date and Time: " + runTimeStep.dateTimeString());
                return 1;
            }
            return 0;
        }
        return this.computeRouting(runTimeStep);
    }

    public int computeForecast(RunTimeWindow runTimeWindow, int n) {
        RunTimeStep runTimeStep = new RunTimeStep(runTimeWindow);
        new RunTimeStep(runTimeWindow).step = runTimeWindow.getNumLookbackSteps() + 1;
        runTimeStep.nstep = runTimeWindow.getNumSteps() - runTimeWindow.getNumLookbackSteps();
        runTimeStep.flag = n;
        return this.computeRouting(runTimeStep);
    }

    public int computeRouting(RunTimeStep runTimeStep) {
        this.element.getSystem().printErrorMessage("Routing.computeRouting: Method not defined for class " + this.getClass().getName());
        this.element.getSystem().printErrorMessage("Element: " + this.element.getName());
        return 1;
    }

    public int computeRouting(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, Object[] objectArray, double[] dArray3) {
        if (dArray == null || dArray3 == null) {
            return 1;
        }
        int n = runTimeStep.getTotalNumSteps();
        for (int i = 0; i < runTimeStep.nstep; ++i) {
            int n2 = runTimeStep.step + i;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > n) break;
            dArray3[i] = dArray[n2];
        }
        return 0;
    }

    public Object newRouteData() {
        return null;
    }

    public boolean checkForecastCalc(RunTime runTime, boolean bl) {
        if (this.element != null && runTime.a != 2) {
            int n = runTime.step;
            this._tsDnstrm[n] = this._tsDnstrm[n] - this.element.calcSeepageFlow(this._tsDnstrm[runTime.step]);
        }
        if (!RMAConst.isValidValue((double)this._tsDnstrm[runTime.step])) {
            this.element.getSystem().printErrorMessage("Routing.checkForecastCalc: invalid flow calculation");
            this.element.getSystem().printErrorMessage("Element: " + this.element.getName());
            this.element.getSystem().printErrorMessage("Date and Time: " + runTime.b());
            return false;
        }
        if (runTime.a != 2 && bl && this._tsDnstrm[runTime.step] < 0.0) {
            this._tsDnstrm[runTime.step] = 0.0;
        }
        return true;
    }

    public int checkForecastCalc(RunTimeStep runTimeStep, boolean bl) {
        for (int i = 0; i < runTimeStep.nstep; ++i) {
            int n = runTimeStep.step + i;
            if (this.element != null && runTimeStep.flag != 2 && runTimeStep.flag != 3) {
                int n2 = n;
                this._tsDnstrm[n2] = this._tsDnstrm[n2] - this.element.calcSeepageFlow(this._tsDnstrm[n]);
            }
            if (!RMAConst.isValidValue((double)this._tsDnstrm[n])) {
                this.element.getSystem().printErrorMessage("Routing.checkForecastCalc: invalid flow calculation");
                this.element.getSystem().printErrorMessage("Flow (cfs) = " + this._tsDnstrm[n]);
                this.element.getSystem().printErrorMessage("Element: " + this.element.getName());
                this.element.getSystem().printErrorMessage("Date and Time: " + runTimeStep.dateTimeString(n));
                return 1;
            }
            if (runTimeStep.flag != 2 && bl && this._tsDnstrm[n] < 0.0) {
                this._tsDnstrm[n] = 0.0;
            }
            if (!this.shouldCheckHotstart() || runTimeStep == null || !((RssTSLocationObject)this).getSystem().b || !((RssTSLocationObject)this).getSystem().shouldSaveHotstartAtTimeStep(i, runTimeStep.flag)) continue;
            ArrayList<Element> arrayList = new ArrayList<Element>(1);
            Element element = this.element.getTopParent();
            arrayList.add(element);
            ((RssTSLocationObject)this).getSystem().checkSaveHotstart(i, runTimeStep.flag, arrayList);
        }
        return 0;
    }

    private boolean shouldCheckHotstart() {
        return this._shouldCheckHotstart;
    }

    public int checkForecastStepCalc(RunTimeStep runTimeStep, boolean bl) {
        int n = runTimeStep.step;
        if (this.element != null && runTimeStep.flag != 2 && runTimeStep.flag != 3) {
            int n2 = n;
            this._tsDnstrm[n2] = this._tsDnstrm[n2] - this.element.calcSeepageFlow(this._tsDnstrm[n]);
        }
        if (!RMAConst.isValidValue((double)this._tsDnstrm[n])) {
            this.element.getSystem().printErrorMessage("Routing.checkForecastCalc: invalid flow calculation");
            this.element.getSystem().printErrorMessage("Flow (cfs) = " + this._tsDnstrm[n]);
            this.element.getSystem().printErrorMessage("Element: " + this.element.getName());
            this.element.getSystem().printErrorMessage("Date and Time: " + runTimeStep.dateTimeString(n));
            return 1;
        }
        if (runTimeStep.flag != 2 && bl && this._tsDnstrm[n] < 0.0) {
            this._tsDnstrm[n] = 0.0;
        }
        return 0;
    }

    public String toString() {
        if (this instanceof CoefRouting) {
            return "Coefficent Routing";
        }
        if (this instanceof MuskingumRouting) {
            return "Muskingum";
        }
        if (this instanceof MuskingumCunge8ptRouting || this instanceof MuskingumCungeRouting && ((MuskingumCungeRouting)this).getChannelType() == ChannelType.EIGHT_POINT) {
            return "Muskingum Cunge 8Point";
        }
        if (this instanceof MuskingumCungePrismRouting || this instanceof MuskingumCungeRouting && (((MuskingumCungeRouting)this).getChannelType() == ChannelType.TRAPEZOID || ((MuskingumCungeRouting)this).getChannelType() == ChannelType.CIRCLE)) {
            return "Muskingum Cunge Prismatic Channel";
        }
        if (this instanceof MuskingumCungeRouting) {
            return "Muskingum Cunge";
        }
        if (this instanceof NullRouting) {
            return "Null";
        }
        if (this instanceof SsarrRouting) {
            return "Ssarr";
        }
        if (this instanceof PulsChannelRouting) {
            return "Puls Channel";
        }
        if (this instanceof PulsChannelRoutingWithLosses) {
            return "Puls Channel with Losses";
        }
        if (this instanceof WorkingRDRouting) {
            return "Working RD";
        }
        if (this instanceof LagAndKRouting) {
            return "Lag & K";
        }
        return super.toString();
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    public boolean initializeStandalone() {
        return true;
    }

    public int getNumberSubreaches() {
        return 1;
    }

    public double[] getSubreachFlowArray(double d, double d2, int n) {
        return new double[]{d, d2};
    }

    public double computeRoutingStepStandalone(int n, double d, double d2, double d3, double[] dArray, double[] dArray2) {
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[n] = d3;
        }
        return d2;
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
    }
}

