/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import com.google.common.flogger.FluentLogger;
import com.google.common.flogger.StackSize;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxyList;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.heclib.util.intContainer;
import hec.heclib.util.stringContainer;
import hec.io.DSSIdentifier;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.PairedDataContainer;
import hec.lang.ModelReference;
import hec.lang.NamedType;
import hec.lang.UserId;
import hec.lang.annotation.Scriptable;
import hec.model.ITSDataSet;
import hec.model.ModelVariable;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import hec.model.UserInterface;
import hec.rss.compute.DefaultComputeLauncher;
import hec.rss.compute.ResSimComputeLauncher;
import hec.rss.model.AltGlobalVarData;
import hec.rss.model.AltOverride;
import hec.rss.model.DiversionElement;
import hec.rss.model.DssOutputData;
import hec.rss.model.Element;
import hec.rss.model.GVDataSet;
import hec.rss.model.HindcastData;
import hec.rss.model.HotstartOptions;
import hec.rss.model.InflowLocationFactor;
import hec.rss.model.JunctionElement;
import hec.rss.model.Operations;
import hec.rss.model.OutputVerticalDatumType;
import hec.rss.model.PDCDataSet;
import hec.rss.model.PDCRecord;
import hec.rss.model.PluginSettings;
import hec.rss.model.ResSystemOpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.ReservoirStorageVsYieldAnalysis;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.ReservoirYieldAnalysis;
import hec.rss.model.ReverseReservoirYieldAnalysis;
import hec.rss.model.ReverseWaterAccountYieldAnalysis;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.TsVariant;
import hec.rss.model.WaterAccountSet;
import hec.rss.model.WaterAccountYieldAnalysis;
import hec.rss.model.YieldAnalysis;
import hec.rss.model.YieldAnalysisRuleRef;
import hec.rss.model.YieldAnalysisType;
import hec.rss.model.globalvariable.GlobalVariableData;
import hec.rss.model.reports.AltInputReportEnums;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.rss.plugins.factories.AltPluginDataFactory;
import hec.rss.plugins.model.AbstractAltPluginData;
import hec.rss.plugins.model.AltPluginData;
import hec.rss.plugins.model.MissingAltPluginData;
import hec.rss.wq.model.AltWaterQualityOptions;
import hec.rss.wq.model.BoundaryConditionSetManager;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.InitialConditionSetManager;
import hec.rss.wq.model.MetData;
import hec.rss.wq.model.ObsDatasetManager;
import hec.rss.wq.model.WQPDCDataProvider;
import hec.rss.wq.model.WQTSDataProvider;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.dispersionCoeff.DispersionSetManager;
import hec.rss.wq.model.massinjection.MassInjectionSetManager;
import hec.rss.wq.model.wqParameters.ParameterSetManager;
import hec.util.XMLUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import org.jdom.Content;
import rma.util.RMAIO;

public class RssAlt
extends Manager
implements AltInputReportInfc,
Cloneable {
    private static final FluentLogger b = FluentLogger.forEnclosingClass();
    public static final String FILE_EXT = ".ralt";
    public static final String TS_DATASET_FILE_EXT = ".fits";
    public static final String OBS_SUFFIX = "(Obs)";
    public static final String REPORT_EXT = ".rpt";
    public static final int PER_AVG_TIME = 7200;
    public static final int VERSION = 1001;
    private int _version = 1001;
    public static final int INFLOW_FACTOR_GLOBAL = 0;
    public static final int INFLOW_FACTOR_LOCATION = 1;
    public static final int FLOW_COMPUTE_DEFAULT = 0;
    public static final int FLOW_COMPUTE_PERAVG = 1;
    public static final int FLOW_COMPUTE_INSTANT = 2;
    private transient RssSystem c = null;
    private transient Operations d = null;
    private transient TSDataSet e = null;
    private transient TSDataSet f = null;
    private transient TSDataSet g = null;
    int _networkID = -1;
    String _systemPath = "";
    String _operationsPath = "";
    String _inputTSDataPath = "";
    String _outputTSDataPath = "";
    String _observedTSDataPath = "";
    Vector<String> _runList = new Vector();
    Hashtable<intContainer, Integer> _resOpSelectionTable = new Hashtable();
    Hashtable<intContainer, Integer> _divOpSelectionTable = new Hashtable();
    Hashtable<Long, Integer> _resSysOpSelectionTable = new Hashtable();
    private OutputVerticalDatumType _outputVerticalDatumType = OutputVerticalDatumType.AS_DEFINED;
    private transient intContainer h = new intContainer();
    private transient intContainer i = new intContainer();
    private transient boolean j = false;
    protected int _timeStep = -1;
    protected int _timeIncrement = -1;
    protected int _flowComputeType = 0;
    Vector _hindcastData = new Vector();
    private Hashtable _useDiffAltResultsTable = new Hashtable();
    private boolean _replaceAllReleaseOverrides;
    private boolean _usingInflowFactors;
    private int _inflowFactorType;
    private double _globalInflowFactor = 1.0;
    private List<InflowLocationFactor> _locationFactors = new ArrayList<InflowLocationFactor>();
    private HotstartOptions _hotstartOptions = new HotstartOptions();
    boolean _computeHoldout = false;
    boolean _computeUnReg = true;
    boolean _computeCumLoc = true;
    int _logLevel = 3;
    private transient int k = 0;
    private boolean _useYieldAnalysis = false;
    private YieldAnalysisType _selectedYieldAnalysis = YieldAnalysisType.RESERVOIR;
    private ReservoirYieldAnalysis _reservoirYieldAnalysis;
    private ReverseReservoirYieldAnalysis _reverseReservoirYieldAnalysis;
    private WaterAccountYieldAnalysis _waterAccountYieldAnalysis;
    private ReverseWaterAccountYieldAnalysis _reverseWaterAccountYieldAnalysis;
    private ReservoirStorageVsYieldAnalysis _reservoirStorageVsYieldAnalysis;
    private transient WaterAccountSet l;
    private int _waterAccountSetIndex = Integer.MIN_VALUE;
    private transient String m;
    private Map<String, PluginSettings> _pluginSettings = new HashMap<String, PluginSettings>();
    private List<AltPluginData> _pluginDataList = new ArrayList<AltPluginData>();
    private DssOutputData _dssOutputData = new DssOutputData(this);
    private List<ModelReference> _embeddedAltRefList = new ArrayList<ModelReference>();
    private List<TsVariant> _inputTsVariants = new ArrayList<TsVariant>();
    private boolean _useObsTSData = false;
    private boolean _copyOverrides;
    private AltWaterQualityOptions _wqOpts;
    private GVDataSet _inputGVData;
    private String _inputGVDataPath;
    private transient TSDataSet n = null;
    private transient PDCDataSet o = null;
    private String _inputWQTSDataPath;
    transient TSDataSet a;
    private String _obsWQDataPath;
    private PDCDataSet _obsWQPDCData;
    private AltGlobalVarData _globalVarData;

    public RssAlt(String string) {
        super(string);
    }

    public RssAlt() {
    }

    public boolean useObsTSData() {
        return this._useObsTSData;
    }

    public OutputVerticalDatumType getOutputVerticalDatumType() {
        return this._outputVerticalDatumType;
    }

    public void setOutputVerticalDatumType(OutputVerticalDatumType outputVerticalDatumType) {
        this._outputVerticalDatumType = outputVerticalDatumType;
    }

    public void setUseObsTSData(boolean bl) {
        if (this._useObsTSData != bl) {
            this.setModified(true);
            this._useObsTSData = bl;
        }
    }

    public void setEmbeddedAltRefList(List<ModelReference> list) {
        this._embeddedAltRefList.clear();
        if (list == null) {
            return;
        }
        this._embeddedAltRefList.addAll(list);
    }

    public List<ModelReference> getEmbeddedAltRefList() {
        return this._embeddedAltRefList;
    }

    public int indexOfEmbeddedAltRefList(ModelReference modelReference) {
        if (modelReference == null || modelReference.wkspName == null || modelReference.className == null) {
            return -1;
        }
        for (int i = 0; i < this._embeddedAltRefList.size(); ++i) {
            ModelReference modelReference2 = this._embeddedAltRefList.get(i);
            if (modelReference2.wkspName == null || modelReference2.className == null || !modelReference2.wkspName.equalsIgnoreCase(modelReference.wkspName) || !modelReference2.className.equalsIgnoreCase(modelReference.className)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsEmbeddedAltRefList(ModelReference modelReference) {
        return this.indexOfEmbeddedAltRefList(modelReference) >= 0;
    }

    public void addEmbeddedAltRef(ModelReference modelReference) {
        this.removeEmbeddedAltRef(modelReference);
        if (modelReference == null) {
            return;
        }
        this._embeddedAltRefList.add(modelReference);
    }

    public void removeEmbeddedAltRef(ModelReference modelReference) {
        int n = this.indexOfEmbeddedAltRefList(modelReference);
        if (n >= 0) {
            this._embeddedAltRefList.remove(n);
        }
    }

    public List<YieldAnalysisRuleRef> getYieldAnalysisWaterSupplyRules() {
        RssAlt rssAlt = this;
        return YieldAnalysisRuleRef.a(rssAlt, rssAlt.getSystem(), true);
    }

    public List<YieldAnalysisRuleRef> getYieldAnalysisHydropowerRules() {
        RssAlt rssAlt = this;
        return YieldAnalysisRuleRef.a(rssAlt, rssAlt.getSystem(), false);
    }

    public boolean modifiyForSaveAs() {
        this._runList.clear();
        this.setModified(true);
        return true;
    }

    public void addResOpSetSelection(int n, int n2) {
        this._resOpSelectionTable.put(new intContainer(n), n2);
        this.setModified(true);
    }

    public void addDivOpSetSelection(int n, int n2) {
        this._divOpSelectionTable.put(new intContainer(n), n2);
        this.setModified(true);
    }

    public void addResSysOpSetSelection(long l, int n) {
        this._resSysOpSelectionTable.put(new Long(l), n);
        this.setModified(true);
    }

    public void removeResSysOpSetSelection(long l) {
        this._resSysOpSelectionTable.remove(new Long(l));
        this.setModified(true);
    }

    public void setHindcastData(Vector vector) {
        if (vector == null) {
            return;
        }
        this._hindcastData = vector;
    }

    public Vector getHindcastData() {
        return (Vector)this._hindcastData.clone();
    }

    public void clearAllResOpSetSelection() {
        this._resOpSelectionTable.clear();
        this.setModified(true);
    }

    public void clearAllDivOpSetSelection() {
        this._divOpSelectionTable.clear();
        this.setModified(true);
    }

    public void clearAllResSysOpSetSelection() {
        this._resSysOpSelectionTable.clear();
        this.setModified(true);
    }

    public int getResOpSetSelection(int n) {
        this.h.value = n;
        Integer n2 = this._resOpSelectionTable.get(this.h);
        if (n2 == null) {
            return Integer.MIN_VALUE;
        }
        return n2;
    }

    public int getDivOpSetSelection(int n) {
        return this.getDivOpSetSelection(n, true);
    }

    int getDivOpSetSelection(int n, boolean bl) {
        this.i.value = n;
        Object object = this._divOpSelectionTable.get(this.i);
        if (object == null) {
            Object object2;
            if (bl && (object2 = this.getSystem()) != null) {
                object2 = ((RssSystem)object2).getElementVectorByClass(DiversionElement.class);
                for (int i = 0; i < object2.size(); ++i) {
                    object = (DiversionElement)object2.get(i);
                    if (object.getIndex() != n) continue;
                    NamedType namedType = ((DiversionElement)object).getDiversionOps();
                    if (namedType == null || (namedType = namedType.getOperationSet("Default")) == null) break;
                    return namedType.getIndex();
                }
            }
            return Integer.MIN_VALUE;
        }
        return (Integer)object;
    }

    public int getResSysOpSetSelection(int n) {
        Integer n2 = this._resSysOpSelectionTable.get(new Long(n));
        if (n2 == null && (n2 = this._resSysOpSelectionTable.get(Long.MIN_VALUE)) == null) {
            return Integer.MIN_VALUE;
        }
        return n2;
    }

    public void init() {
    }

    public RssSystem getSystem() {
        if (this.c == null || this.c != null && this.c.getIndex() != this._networkID && this._networkID != -1) {
            if (this._networkID == -1) {
                this.loadNetworkByPath();
            } else if (!this.loadNetworkByID()) {
                this.loadNetworkByPath();
            }
        }
        if (this.c != null) {
            this.c.setAlternative(this);
            if (this._networkID != this.c.getIndex()) {
                this._networkID = this.c.getIndex();
                this.setModified(true);
            }
        }
        return this.c;
    }

    protected boolean loadNetworkByID() {
        try {
            String string;
            this.c = (RssSystem)this._proxyList.openManager(RssSystem.class.getName(), this._networkID);
            if (this.c != null && !RMAIO.pathsEqual((String)this._systemPath, (String)(string = this.c.getIdentifier().getPath()))) {
                this._systemPath = string;
                this.setModified(true);
            }
        }
        catch (Exception exception) {
            this.printErrorMessage("RssAlt.getSystem - Exception" + String.valueOf(exception));
            RssAlt rssAlt = this;
            rssAlt.printMessage("Failed to load RssSystem" + rssAlt._systemPath);
        }
        if (this.c == null) {
            System.out.println("Failed to find Network " + this._systemPath + " id = " + this._networkID);
        }
        return this.c != null;
    }

    protected boolean loadNetworkByPath() {
        Identifier identifier = new Identifier(this._systemPath);
        RssAlt rssAlt = this;
        rssAlt.printMessage("Opening Network " + rssAlt._systemPath);
        try {
            this.c = (RssSystem)this._proxyList.loadManager(RssSystem.class.getName(), identifier);
        }
        catch (RemoteException remoteException) {
            this.printErrorMessage("RssAlt.getSystem - RemoteException" + String.valueOf(remoteException));
            RssAlt rssAlt2 = this;
            rssAlt2.printMessage("Failed to load RssSystem" + rssAlt2._systemPath);
        }
        if (this.c != null) {
            this._networkID = this.c.getIndex();
            return true;
        }
        RssAlt rssAlt3 = this;
        rssAlt3.printMessage("Failed to find Network " + rssAlt3._systemPath);
        return false;
    }

    public GVDataSet getInputGVDataSet(TsVariant tsVariant) {
        if (tsVariant == null) {
            return this.getInputGVDataSet();
        }
        return this.getInputGVDataSet(tsVariant.getName(), tsVariant.hasNonDefaultInput());
    }

    public GVDataSet getInputGVDataSet() {
        block7: {
            if (this._inputGVData != null && this.getName().equals(this._inputGVData.getName())) {
                return this._inputGVData;
            }
            Identifier identifier = new Identifier(this.getGVDataSetPath());
            try {
                Identifier identifier2;
                this._inputGVData = (GVDataSet)this._proxyList.loadManager(GVDataSet.class.getName(), identifier);
                if (this._inputGVData != null) break block7;
                this._inputGVData = (GVDataSet)this._proxyList.newManager("rss", GVDataSet.class.getName());
                this._inputGVData.setName(this.getName());
                this._inputGVData.setDescription(this.getDescription() + " (Global Variable Data Set)");
                identifier.setName(this.getName());
                identifier.setDescription(this._inputGVData.getDescription());
                if (this.getFileManager().fileExists(identifier.getPath()) && (identifier2 = this.getFileManager().openFile(UserId.getUserId(), identifier)) != null) {
                    this._inputGVData.readFile(identifier2);
                }
                if (!this._proxyList.saveManagerAs("rss", (Manager)this._inputGVData, identifier)) {
                    this.printErrorMessage("Failed to save default IntputGVDataSet to file " + identifier.getPath());
                    break block7;
                }
                identifier2 = (RmiWorkspace)this.getWorkspace().getRemote();
                try {
                    identifier2.saveWorkspace(UserId.getUserId());
                }
                catch (RemoteException remoteException) {
                    System.out.println("getInputGVDataSet:error saving RmiWorkspace " + String.valueOf(remoteException));
                }
                this._inputGVData.readFile(this._inputGVData.getIdentifier());
            }
            catch (RemoteException remoteException) {
                this.printErrorMessage("RssAlt.getInputGVData - RemoteException" + String.valueOf(remoteException));
                RssAlt rssAlt = this;
                rssAlt.printMessage("Failed to load Input GVDataSet" + rssAlt._inputGVDataPath);
            }
        }
        return this._inputGVData;
    }

    public String getGVDataSetPath() {
        if ((this._inputGVDataPath == null || this._inputGVDataPath.isEmpty()) && this.getIdentifier() != null) {
            String string = this.getIdentifier().getPath();
            String string2 = RMAIO.getFileNameNoExtension((String)string);
            string = RMAIO.getDirectoryFromPath((String)string);
            this._inputGVDataPath = RMAIO.concatPath((String)string, (String)string2.concat(".igv"));
        }
        return this._inputGVDataPath;
    }

    public String getWQDataSetPath() {
        if (this._inputWQTSDataPath == null && this.getIdentifier() != null) {
            String string = this.getIdentifier().getPath();
            String string2 = RMAIO.getFileNameNoExtension((String)string);
            string = RMAIO.getDirectoryFromPath((String)string);
            this._inputWQTSDataPath = RMAIO.concatPath((String)string, (String)string2.concat(".wqits"));
        }
        return this._inputWQTSDataPath;
    }

    public String getInputGVDataPath() {
        return this._inputGVDataPath;
    }

    public void setGVDataSetPath(String string) {
        this._inputGVDataPath = string;
        this.setModified(true);
    }

    public GVDataSet getInputGVDataSet(String string, boolean bl) {
        Object object;
        if (string == null || string.isEmpty()) {
            return this.getInputGVDataSet();
        }
        String string2 = this.getName().concat("-").concat(string);
        if (this._inputGVData != null && string2.equals(this._inputGVData.getName())) {
            return this._inputGVData;
        }
        System.out.println("getInputGVDataSet:loading GVDataSet for Variant " + string);
        String string3 = this.createInputGVDataPath(string);
        Identifier identifier = new Identifier(string3);
        GVDataSet gVDataSet = null;
        try {
            gVDataSet = (GVDataSet)this._proxyList.loadManager(GVDataSet.class.getName(), identifier);
        }
        catch (RemoteException remoteException) {
            this.printErrorMessage("RssAlt.getInputGVData - RemoteException" + String.valueOf(remoteException));
            this.printMessage("Failed to load Input GVDataSet" + string3 + " for variant " + string);
        }
        if (gVDataSet == null) {
            System.out.println("getInputGVDataSet:creating Input GV Variant " + string3);
            gVDataSet = (GVDataSet)this._proxyList.newManager("rss", GVDataSet.class.getName());
            if (gVDataSet == null) {
                this.printErrorMessage("Failed to create InputGVDataSet for Variant " + string);
                return null;
            }
            identifier.setName(string2);
            gVDataSet.setName(string2);
            gVDataSet.setDescription(this.getDescription() + " (GV Data Set for " + string + ")");
            object = this.getInputGVDataSet();
            if (object != null) {
                gVDataSet.appendGVRecords((GVDataSet)((Object)object));
            }
            if (!this._proxyList.saveManagerAs("rss", (Manager)gVDataSet, identifier)) {
                this.printErrorMessage("Failed to save IntputGVDataSet for Variant " + string + " to file " + string3);
            } else {
                string2 = (RmiWorkspace)this.getWorkspace().getRemote();
                try {
                    string2.saveWorkspace(UserId.getUserId());
                }
                catch (RemoteException remoteException) {
                    System.out.println("getInputGVDataSet:error saving RmiWorkspace " + String.valueOf(remoteException));
                }
                GVDataSet gVDataSet2 = gVDataSet;
                gVDataSet2.readFile(gVDataSet2.getIdentifier());
                this._inputGVData = gVDataSet;
            }
        } else {
            object = this.getInputGVDataSet();
            if (object != null) {
                this.updateVariantInputGVDataSet(gVDataSet, (GVDataSet)((Object)object));
            }
            this._inputGVData = gVDataSet;
        }
        object = new TsVariant(string);
        ((TsVariant)((Object)object)).setHasNonDefaultInput(bl);
        if (!this._inputTsVariants.contains(object)) {
            this._inputTsVariants.add((TsVariant)((Object)object));
            this.setModified(true);
            this.getProxyList().saveManager(UserId.getUserId(), (Manager)this);
        }
        return this._inputGVData;
    }

    private void updateVariantInputGVDataSet(GVDataSet gVDataSet, GVDataSet object) {
        if (gVDataSet == null || object == null) {
            return;
        }
        List<GlobalVariableData> list = gVDataSet.getGVRecords();
        object = object.getGVRecords();
        HashSet<GlobalVariableData> hashSet = new HashSet<GlobalVariableData>(list);
        Cloneable cloneable2 = new HashSet(object);
        cloneable2.removeAll(hashSet);
        if (!cloneable2.isEmpty()) {
            for (Cloneable cloneable2 : cloneable2) {
                cloneable2 = cloneable2.clone();
                list.add((GlobalVariableData)cloneable2);
            }
            gVDataSet.setModified(true);
        }
        cloneable2 = new HashSet(object);
        hashSet.removeAll((Collection<?>)((Object)cloneable2));
        list.removeAll(hashSet);
    }

    private String createInputGVDataPath(String string) {
        return this.createInputDataPath(string, ".igv");
    }

    private String createInputDataPath(String string, String string2) {
        return this.createInputDataPath(string, string2, null);
    }

    private String createInputDataPath(String string, String string2, String string3) {
        String string4 = this.getIdentifier().getPath();
        int n = string4.lastIndexOf(46);
        if (n >= 0) {
            string4 = string4.substring(0, n);
        }
        if (string3 != null) {
            string4 = string4.concat(string3);
        }
        string4.concat("-");
        string3 = string4.concat(RMAIO.userNameToFileName((String)string));
        string3 = string3.concat(string2);
        System.out.println("createInputDataPath:created path for variant:" + string + " path:" + string3);
        return string3;
    }

    public TSDataSet getInputTSDataSet(TsVariant tsVariant) {
        if (tsVariant == null) {
            return this.getInputTSDataSet();
        }
        return this.getInputTSDataSet(tsVariant.getName(), tsVariant.hasNonDefaultInput());
    }

    public TSDataSet getInputTSDataSet(String string, boolean bl) {
        TsVariant tsVariant;
        if (string == null || string.isEmpty()) {
            return this.getInputTSDataSet();
        }
        String string2 = this.getName().concat("-").concat(string);
        if (this.e != null && string2.equals(this.e.getName())) {
            return this.e;
        }
        System.out.println("getInputTSDataSet:loading TSDataSet for Variant " + string);
        String string3 = this.createInputTSDataPath(string);
        Identifier identifier = new Identifier(string3);
        TSDataSet tSDataSet = null;
        try {
            tSDataSet = (TSDataSet)this._proxyList.loadManager(TSDataSet.class.getName(), identifier);
        }
        catch (RemoteException remoteException) {
            this.printErrorMessage("RssAlt.getInputTSData - RemoteException" + String.valueOf(remoteException));
            this.printMessage("Failed to load Input TSDataSet" + string3 + " for variant " + string);
        }
        if (tSDataSet == null) {
            System.out.println("getInputTSDataSet:creating InputTS Variant " + string3);
            tSDataSet = (TSDataSet)this._proxyList.newManager("rss", TSDataSet.class.getName());
            if (tSDataSet == null) {
                this.printErrorMessage("Failed to create InputTSDataSet for Variant " + string);
                return null;
            }
            identifier.setName(string2);
            tSDataSet.setName(string2);
            tSDataSet.setDescription(this.getDescription() + " (TS Data Set for " + string + ")");
            tsVariant = this.getInputTSDataSet();
            if (tsVariant != null) {
                tSDataSet.appendTSRecords((ITSDataSet)tsVariant);
            }
            if (!this._proxyList.saveManagerAs("rss", (Manager)tSDataSet, identifier)) {
                this.printErrorMessage("Failed to save InputTSDataSet for Variant " + string + " to file " + string3);
            } else {
                string2 = (RmiWorkspace)this.getWorkspace().getRemote();
                try {
                    string2.saveWorkspace(UserId.getUserId());
                }
                catch (RemoteException remoteException) {
                    System.out.println("getInputTSDataSet:error saving RmiWorkspace " + String.valueOf(remoteException));
                }
                TSDataSet tSDataSet2 = tSDataSet;
                tSDataSet2.readFile(tSDataSet2.getIdentifier());
                this.e = tSDataSet;
            }
        } else {
            this.e = tSDataSet;
        }
        tsVariant = new TsVariant(string);
        tsVariant.setHasNonDefaultInput(bl);
        if (!this._inputTsVariants.contains((Object)tsVariant)) {
            this._inputTsVariants.add(tsVariant);
            this.setModified(true);
            this.getProxyList().saveManager(UserId.getUserId(), (Manager)this);
        }
        return this.e;
    }

    public TSDataSet getInputTSDataSet() {
        if (this.e != null && this.getName().equals(this.e.getName())) {
            return this.e;
        }
        Identifier identifier = new Identifier(this.getDataSetPath());
        try {
            this.e = (TSDataSet)this._proxyList.loadManager(TSDataSet.class.getName(), identifier);
            if (this.e != null) {
                this.e.setUserInterface(this.getUserInterface());
                this.e.setName("Input TS DataSet for " + this.getName());
            }
        }
        catch (RemoteException remoteException) {
            this.printErrorMessage("RssAlt.getInputTSData - RemoteException" + String.valueOf(remoteException));
            RssAlt rssAlt = this;
            rssAlt.printMessage("Failed to load Input TSDataSet" + rssAlt._inputTSDataPath);
        }
        return this.e;
    }

    private String createInputTSDataPath(String string) {
        return this.createInputDataPath(string, TS_DATASET_FILE_EXT);
    }

    private List<TSRecordProxy> collectWQTSRecords(WQTSDataProvider wQTSDataProvider, TSDataSet tSDataSet) {
        RssSystem rssSystem = this.getSystem();
        if (wQTSDataProvider == null || rssSystem == null) {
            return Collections.emptyList();
        }
        return wQTSDataProvider.getActiveTSRecordProxies(tSDataSet, this);
    }

    public TSDataSet getInputWQTSDataSet() {
        if (this.n == null) {
            this.n = new TSDataSet();
            this.n.setName("WQInput for " + this.getName().concat("-WQ"));
            this.n.setWorkspace(this.getWorkspace());
        } else {
            this.n.clearTSRecordList();
        }
        Manager manager = this.getWaterQualityOptions().getMetDataManager(this);
        if (manager != null) {
            this.n.getTSRecords().addAll(this.collectWQTSRecords((WQTSDataProvider)manager, this.n));
        }
        if ((manager = this.getWaterQualityOptions().getMassInjectionSetManager(this)) != null) {
            this.n.getTSRecords().addAll(this.collectWQTSRecords((WQTSDataProvider)manager, this.n));
        }
        if ((manager = this.getWaterQualityOptions().getBcManager(this)) != null) {
            this.n.getTSRecords().addAll(this.collectWQTSRecords((WQTSDataProvider)manager, this.n));
        }
        RssAlt rssAlt = this;
        rssAlt.indexTSRecords(rssAlt.n.getTSRecords());
        manager = this.getWaterQualityOptions().getParameterSetManager(this);
        if (manager != null) {
            this.n.getTSRecords().addAll(this.collectWQTSRecords((WQTSDataProvider)manager, this.n));
        }
        return this.n;
    }

    public PDCDataSet getInputWQPDCDataSet(TsVariant tsVariant) {
        if (tsVariant == null) {
            RssAlt rssAlt = this;
            return rssAlt.getInputWQPDCDataSet(rssAlt.getRunTimeWindow());
        }
        return this.getInputWQPDCDataSet(tsVariant.getName(), tsVariant.hasNonDefaultInput());
    }

    @Nullable
    private RunTimeWindow getRunTimeWindow() {
        RunTimeWindow runTimeWindow = null;
        Manager manager = this.getSystem();
        if (manager != null && (manager = manager.getRssRun()) != null) {
            runTimeWindow = manager.getRunTimeWindow();
        }
        return runTimeWindow;
    }

    public PDCDataSet getInputWQPDCDataSet() {
        RssAlt rssAlt = this;
        return rssAlt.getInputWQPDCDataSet(rssAlt.getRunTimeWindow());
    }

    public PDCDataSet getInputWQPDCDataSet(@CheckForNull RunTimeWindow runTimeWindow) {
        if (this.o == null) {
            this.o = new PDCDataSet();
            this.o.setName("WQInput Paired Data for " + this.getName());
            this.o.setWorkspace(this.getWorkspace());
        } else {
            this.o.clear();
        }
        InitialConditionSetManager initialConditionSetManager = this.getWaterQualityOptions().getInitialConditionsSetManager(this);
        if (initialConditionSetManager != null) {
            this.o.addAll(this.collectWQPDCRecords(initialConditionSetManager, this.o, runTimeWindow));
        }
        return this.o;
    }

    private List<PDCRecord> collectWQPDCRecords(WQPDCDataProvider wQPDCDataProvider, PDCDataSet pDCDataSet, @CheckForNull RunTimeWindow runTimeWindow) {
        if (wQPDCDataProvider == null) {
            return Collections.emptyList();
        }
        return wQPDCDataProvider.getActivePDCRecords(pDCDataSet, runTimeWindow, this.getSystem());
    }

    private void indexTSRecords(Vector vector) {
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            TSRecord tSRecord = (TSRecord)vector.get(i);
            tSRecord.setIndex(i + 1);
        }
    }

    public TSDataSet getInputWQTSDataSet(TsVariant tsVariant) {
        if (tsVariant == null) {
            return this.getInputWQTSDataSet();
        }
        return this.getInputWQTSDataSet(tsVariant.getName(), tsVariant.hasNonDefaultInput());
    }

    public String getInputWQTSDataPath() {
        return this._inputWQTSDataPath;
    }

    public void setWQDataSetPath(String string) {
        this._inputWQTSDataPath = string;
        this.setModified(true);
    }

    public TSDataSet getInputWQTSDataSet(String string, boolean bl) {
        TSDataSet tSDataSet;
        if (string == null || string.isEmpty()) {
            return this.getInputWQTSDataSet();
        }
        String string2 = this.getName().concat("-").concat(string);
        if (this.n != null && string2.equals(this.n.getName())) {
            List<TSRecord> list = this.getWQTSRecordsFromManagers();
            RssAlt rssAlt = this;
            rssAlt.ensureWqTsDataIsUptoDate(rssAlt.n, list);
            return this.n;
        }
        System.out.println("getInputWQTSDataSet:loading Input WQ TSDataSet for Variant " + string);
        String string3 = this.createInputDataPath(string, ".wqits");
        Identifier identifier = new Identifier(string3);
        TSDataSet tSDataSet2 = null;
        try {
            tSDataSet2 = (TSDataSet)this._proxyList.loadManager(TSDataSet.class.getName(), identifier);
        }
        catch (RemoteException remoteException) {
            this.printErrorMessage("RssAlt.getWQInputTSData - RemoteException" + String.valueOf(remoteException));
            this.printMessage("Failed to load Input WQTSDataSet" + string3 + " for variant " + string);
        }
        if (tSDataSet2 == null) {
            System.out.println("getWQInputTSDataSet:creating InputTS Variant " + string3);
            tSDataSet2 = (TSDataSet)this._proxyList.newManager("rss", TSDataSet.class.getName());
            if (tSDataSet2 == null) {
                this.printErrorMessage("Failed to create InputWQTSDataSet for Variant " + string);
                return null;
            }
            identifier.setName(string2);
            tSDataSet2.setName(string2);
            tSDataSet2.setDescription(this.getDescription() + " (TS Data Set for " + string + ")");
            tSDataSet = this.getInputWQTSDataSet();
            if (tSDataSet != null) {
                tSDataSet2.appendTSRecords((ITSDataSet)tSDataSet);
            }
            if (!this._proxyList.saveManagerAs("rss", (Manager)tSDataSet2, identifier)) {
                this.printErrorMessage("Failed to save IntputWQTSDataSet for Variant " + string + " to file " + string3);
            } else {
                string2 = (RmiWorkspace)this.getWorkspace().getRemote();
                try {
                    string2.saveWorkspace(UserId.getUserId());
                }
                catch (RemoteException remoteException) {
                    System.out.println("getInputWQTSDataSet:error saving RmiWorkspace " + String.valueOf(remoteException));
                }
                TSDataSet tSDataSet3 = tSDataSet2;
                tSDataSet3.readFile(tSDataSet3.getIdentifier());
                this.n = tSDataSet2;
            }
        } else {
            this.n = tSDataSet2;
            tSDataSet = this.getWQTSRecordsFromManagers();
            RssAlt rssAlt = this;
            rssAlt.ensureWqTsDataIsUptoDate(rssAlt.n, (List<TSRecord>)tSDataSet);
        }
        tSDataSet = new TsVariant(string);
        tSDataSet.setHasNonDefaultInput(bl);
        if (!this._inputTsVariants.contains(tSDataSet)) {
            this._inputTsVariants.add((TsVariant)tSDataSet);
            this.setModified(true);
            this.getProxyList().saveManager(UserId.getUserId(), (Manager)this);
        }
        RssAlt rssAlt = this;
        rssAlt.cleanTsRecords(rssAlt.n);
        if (this.n != null) {
            this.n.setUserInterface(this.getUserInterface());
        }
        return this.n;
    }

    public PDCDataSet getInputWQPDCDataSet(String string, boolean bl) {
        Object object;
        if (string == null || string.isEmpty()) {
            RssAlt rssAlt = this;
            return rssAlt.getInputWQPDCDataSet(rssAlt.getRunTimeWindow());
        }
        String string2 = this.getName().concat("-").concat(string);
        if (this.o != null && string2.equals(this.o.getName())) {
            List<PDCRecord> list = this.getWQPDCRecordsFromManagers();
            RssAlt rssAlt = this;
            rssAlt.ensureWqPDCDataIsUptoDate(rssAlt.o, list);
            return this.o;
        }
        System.out.println("getInputWQPDCDataSet:loading Input WQ PDCDataSet for Variant " + string);
        String string3 = this.createInputDataPath(string, ".wqipd");
        Identifier identifier = new Identifier(string3);
        PDCDataSet pDCDataSet = null;
        try {
            pDCDataSet = (PDCDataSet)this._proxyList.loadManager(PDCDataSet.class.getName(), identifier);
        }
        catch (RemoteException remoteException) {
            this.printErrorMessage("RssAlt.getWQInputTSData - RemoteException" + String.valueOf(remoteException));
            this.printMessage("Failed to load Input WQTSDataSet" + string3 + " for variant " + string);
        }
        if (pDCDataSet == null) {
            System.out.println("getInputWQPDCDataSet:creating InputTS Variant " + string3);
            pDCDataSet = (PDCDataSet)this._proxyList.newManager("rss", PDCDataSet.class.getName());
            if (pDCDataSet == null) {
                this.printErrorMessage("Failed to create InputWQPDCDataSet for Variant " + string);
                return null;
            }
            identifier.setName(string2);
            pDCDataSet.setName(string2);
            pDCDataSet.setDescription(this.getDescription() + " (PDC Data Set for " + string + ")");
            RssAlt rssAlt = this;
            object = rssAlt.getInputWQPDCDataSet(rssAlt.getRunTimeWindow());
            if (object != null) {
                pDCDataSet.addAll(((PDCDataSet)((Object)object)).getAll());
            }
            if (!this._proxyList.saveManagerAs("rss", (Manager)pDCDataSet, identifier)) {
                this.printErrorMessage("Failed to save InputWQPDCDataSet for Variant " + string + " to file " + string3);
            } else {
                string2 = (RmiWorkspace)this.getWorkspace().getRemote();
                try {
                    string2.saveWorkspace(UserId.getUserId());
                }
                catch (RemoteException remoteException) {
                    System.out.println("getInputWQPDCDataSet:error saving RmiWorkspace " + String.valueOf(remoteException));
                }
                PDCDataSet pDCDataSet2 = pDCDataSet;
                pDCDataSet2.readFile(pDCDataSet2.getIdentifier());
                this.o = pDCDataSet;
            }
        } else {
            this.o = pDCDataSet;
            object = this.getWQPDCRecordsFromManagers();
            RssAlt rssAlt = this;
            rssAlt.ensureWqPDCDataIsUptoDate(rssAlt.o, (List<PDCRecord>)object);
        }
        object = new TsVariant(string);
        ((TsVariant)((Object)object)).setHasNonDefaultInput(bl);
        if (!this._inputTsVariants.contains(object)) {
            this._inputTsVariants.add((TsVariant)((Object)object));
            this.setModified(true);
            this.getProxyList().saveManager(UserId.getUserId(), (Manager)this);
        }
        RssAlt rssAlt = this;
        rssAlt.cleanPDCRecords(rssAlt.o);
        return this.o;
    }

    public PDCDataSet getObsWQPDCDataSet(TsVariant tsVariant) {
        if (tsVariant == null) {
            return this.getObsWQPDCDataSet();
        }
        return this.getObsWQPDCDataSet(tsVariant.getName(), tsVariant.hasNonDefaultInput(), this.getRunTimeWindow());
    }

    public PDCDataSet getObsWQPDCDataSet(TsVariant tsVariant, RunTimeWindow runTimeWindow) {
        if (tsVariant == null) {
            return this.getObsWQPDCDataSet(runTimeWindow);
        }
        return this.getObsWQPDCDataSet(tsVariant.getName(), tsVariant.hasNonDefaultInput(), runTimeWindow);
    }

    public PDCDataSet getObsWQPDCDataSet(String string, boolean bl) {
        return this.getObsWQPDCDataSet(string, bl, this.getRunTimeWindow());
    }

    public PDCDataSet getObsWQPDCDataSet(String string, boolean bl, RunTimeWindow runTimeWindow) {
        Object object;
        if (string == null || string.isEmpty()) {
            return this.getObsWQPDCDataSet();
        }
        String string2 = this.getName().concat("-").concat(string);
        if (this._obsWQPDCData != null && string2.equals(this._obsWQPDCData.getName())) {
            List<PDCRecord> list = this.getObsWQPDCRecordsFromManagers(runTimeWindow);
            RssAlt rssAlt = this;
            rssAlt.ensureWqPDCDataIsUptoDate(rssAlt._obsWQPDCData, list);
            return this._obsWQPDCData;
        }
        System.out.println("getInputWQPDCDataSet:loading Input WQ PDCDataSet for Variant " + string);
        String string3 = this.createInputDataPath(string, ".wqipd", "Obs");
        Identifier identifier = new Identifier(string3);
        PDCDataSet pDCDataSet = null;
        try {
            pDCDataSet = (PDCDataSet)this._proxyList.loadManager(PDCDataSet.class.getName(), identifier);
        }
        catch (RemoteException remoteException) {
            this.printErrorMessage("RssAlt.getObsWQPDCDataSet - RemoteException" + String.valueOf(remoteException));
            this.printMessage("Failed to load Input ObsWQPDCSDataSet" + string3 + " for variant " + string);
        }
        if (pDCDataSet == null) {
            System.out.println("getObsWQPDCDataSet:creating obsPDC Variant " + string3);
            pDCDataSet = (PDCDataSet)this._proxyList.newManager("rss", PDCDataSet.class.getName());
            if (pDCDataSet == null) {
                this.printErrorMessage("Failed to create ObsWQPDCSDataSet for Variant " + string);
                return null;
            }
            identifier.setName(string2);
            pDCDataSet.setName(string2);
            pDCDataSet.setDescription(this.getDescription() + " (PDC Data Set for " + string + ")");
            object = this.getObsWQPDCDataSet();
            if (object != null) {
                pDCDataSet.addAll(((PDCDataSet)((Object)object)).getAll());
            }
            if (!this._proxyList.saveManagerAs("rss", (Manager)pDCDataSet, identifier)) {
                this.printErrorMessage("Failed to save ObsWQPDCSDataSet for Variant " + string + " to file " + string3);
            } else {
                runTimeWindow = (RmiWorkspace)this.getWorkspace().getRemote();
                try {
                    runTimeWindow.saveWorkspace(UserId.getUserId());
                }
                catch (RemoteException remoteException) {
                    System.out.println("getObsWQPDCDataSet:error saving RmiWorkspace " + String.valueOf(remoteException));
                }
                PDCDataSet pDCDataSet2 = pDCDataSet;
                pDCDataSet2.readFile(pDCDataSet2.getIdentifier());
                this._obsWQPDCData = pDCDataSet;
            }
        } else {
            this._obsWQPDCData = pDCDataSet;
            object = this.getObsWQPDCRecordsFromManagers(runTimeWindow);
            RssAlt rssAlt = this;
            rssAlt.ensureWqPDCDataIsUptoDate(rssAlt._obsWQPDCData, (List<PDCRecord>)object);
        }
        object = new TsVariant(string);
        ((TsVariant)((Object)object)).setHasNonDefaultInput(bl);
        if (!this._inputTsVariants.contains(object)) {
            this._inputTsVariants.add((TsVariant)((Object)object));
            this.setModified(true);
            this.getProxyList().saveManager(UserId.getUserId(), (Manager)this);
        }
        RssAlt rssAlt = this;
        rssAlt.cleanPDCRecords(rssAlt._obsWQPDCData);
        return this._obsWQPDCData;
    }

    private void ensureWqTsDataIsUptoDate(TSDataSet tSDataSet, List<TSRecord> list) {
        Closeable closeable;
        TSRecord tSRecord;
        int n;
        if (tSDataSet == null) {
            return;
        }
        Vector vector = tSDataSet.getTSRecords();
        vector.removeIf(Objects::isNull);
        System.out.println("ensureInputWqTsDataIsUptoDate:have " + vector.size() + " stored WQ TS Records in " + tSDataSet.getName());
        list.removeIf(Objects::isNull);
        System.out.println("ensureInputWqTsDataIsUptoDate:have " + list.size() + " WQ TS Records from WQ managers");
        ArrayList<TSRecord> arrayList = new ArrayList<TSRecord>(list);
        ArrayList<TSRecord> arrayList2 = new ArrayList<TSRecord>(vector);
        this.removeAllTSRecords(arrayList, vector);
        if (!arrayList.isEmpty()) {
            this.printMessage("ensureInputWqTsDataIsUptoDate:have " + arrayList.size() + " new TS Records from WQ managers");
        }
        this.printMessage("ensureInputWqTsDataIsUptoDate:have " + arrayList.size() + " new TS Records to add to " + tSDataSet.getName());
        for (n = 0; n < arrayList.size(); ++n) {
            tSRecord = (TSRecord)arrayList.get(n);
            closeable = new StringWriter(1000);
            BufferedWriter bufferedWriter = new BufferedWriter((Writer)closeable);
            tSRecord.writeData(bufferedWriter);
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
            tSRecord = tSDataSet.createTSRecord(tSRecord.getName(), tSRecord.getVariableId(), tSRecord.getParamName());
            this.printMessage("ensureInputWqTsDataIsUptoDate:add " + String.valueOf(tSRecord) + " new TS Record to " + tSDataSet.getName());
            closeable = new StringReader(closeable.toString());
            closeable = new BufferedReader((Reader)closeable);
            tSRecord.readData((BufferedReader)closeable);
            tSDataSet.setModified(true);
        }
        this.removeAllTSRecords(arrayList2, list);
        if (!arrayList2.isEmpty()) {
            System.out.println("ensureInputWqTsDataIsUptoDate:have " + arrayList2.size() + " deleted TS Records from WQ managers");
            this.printMessage("ensureInputWqTsDataIsUptoDate:have " + arrayList2.size() + " TS Records to delete from " + tSDataSet.getName());
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            tSRecord = (TSRecord)arrayList2.get(n);
            closeable = tSDataSet.getTSRecord(tSRecord.getName(), tSRecord.getParamName());
            if (closeable == null) continue;
            vector.remove(closeable);
            this.printMessage("ensureInputWqTsDataIsUptoDate:removing " + String.valueOf(closeable) + " TS Record from " + tSDataSet.getName());
            tSDataSet.setModified(true);
        }
        if (tSDataSet.isModified()) {
            tSDataSet.getProxyList().saveManager(UserId.getUserId(), (Manager)tSDataSet);
        }
    }

    private void ensureWqPDCDataIsUptoDate(PDCDataSet pDCDataSet, List<PDCRecord> list) {
        PDCRecord pDCRecord;
        if (pDCDataSet == null) {
            return;
        }
        List<PDCRecord> list2 = pDCDataSet.getAll();
        list2.removeIf(Objects::isNull);
        ArrayList<PDCRecord> arrayList = new ArrayList<PDCRecord>(list);
        ArrayList<PDCRecord> arrayList2 = new ArrayList<PDCRecord>(list2);
        this.removeAllPDCRecords(arrayList, list2);
        if (!arrayList.isEmpty()) {
            System.out.println("ensureInputWqPDCDataIsUptoDate:have " + arrayList.size() + " new PDC Records from WQ managers");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            PDCRecord pDCRecord2 = (PDCRecord)arrayList.get(i);
            pDCRecord = pDCDataSet.getOrCreate(pDCRecord2.getName(), pDCRecord2.getVariableId(), pDCRecord2.getParamName());
            PDCDataSet.a(pDCRecord2, pDCRecord);
            pDCDataSet.setModified(true);
        }
        this.removeAllPDCRecords(arrayList2, list);
        if (!arrayList2.isEmpty()) {
            System.out.println("ensureInputWqPDCDataIsUptoDate:have " + arrayList2.size() + " deleted PDC Records from WQ managers");
        }
        for (PDCRecord pDCRecord2 : arrayList2) {
            pDCRecord = pDCDataSet.getRecord(pDCRecord2.getName(), pDCRecord2.getParamName());
            if (pDCRecord == null) continue;
            list2.remove(pDCRecord);
            pDCDataSet.setModified(true);
        }
        LinkedHashSet<PDCRecord> linkedHashSet = new LinkedHashSet<PDCRecord>(list2);
        if (linkedHashSet.size() != list2.size()) {
            list2.clear();
            list2.addAll((Collection<PDCRecord>)linkedHashSet);
            pDCDataSet.setModified(true);
        }
        if (pDCDataSet.isModified()) {
            pDCDataSet.getProxyList().saveManager(UserId.getUserId(), (Manager)pDCDataSet);
        }
    }

    private List<PDCRecord> getWQPDCRecordsFromManagers() {
        ArrayList<PDCRecord> arrayList = new ArrayList<PDCRecord>();
        InitialConditionSetManager initialConditionSetManager = this.getWaterQualityOptions().getInitialConditionsSetManager(this);
        if (initialConditionSetManager != null) {
            arrayList.addAll(this.collectWQPDCRecords(initialConditionSetManager, this.o, this.getRunTimeWindow()));
        }
        return arrayList;
    }

    private List<PDCRecord> getObsWQPDCRecordsFromManagers(RunTimeWindow runTimeWindow) {
        ArrayList<PDCRecord> arrayList = new ArrayList<PDCRecord>();
        ObsDatasetManager obsDatasetManager = this.getWaterQualityOptions().getObservedDataSetManager(this);
        if (obsDatasetManager != null) {
            arrayList.addAll(this.collectWQPDCRecords(obsDatasetManager, this.o, runTimeWindow));
        }
        return arrayList;
    }

    private List<TSRecord> getWQTSRecordsFromManagers() {
        ArrayList<TSRecord> arrayList = new ArrayList<TSRecord>();
        Manager manager = this.getWaterQualityOptions().getMetDataManager(this);
        if (manager != null) {
            arrayList.addAll(this.collectWQTSRecords((WQTSDataProvider)manager, this.n));
        }
        if ((manager = this.getWaterQualityOptions().getMassInjectionSetManager(this)) != null) {
            arrayList.addAll(this.collectWQTSRecords((WQTSDataProvider)manager, this.n));
        }
        if ((manager = this.getWaterQualityOptions().getBcManager(this)) != null) {
            arrayList.addAll(this.collectWQTSRecords((WQTSDataProvider)manager, this.n));
        }
        if ((manager = this.getWaterQualityOptions().getParameterSetManager(this)) != null) {
            arrayList.addAll(this.collectWQTSRecords((WQTSDataProvider)manager, this.n));
        }
        return arrayList;
    }

    private void removeAllTSRecords(List<TSRecord> object, List<TSRecord> list) {
        object = object.iterator();
        block0: while (object.hasNext()) {
            Object object2 = (TSRecord)object.next();
            if (object2 == null) continue;
            String string = object2.getName();
            object2 = object2.getParamName();
            for (TSRecord tSRecord : list) {
                if (tSRecord == null || !string.equals(tSRecord.getName()) || !((String)object2).equals(tSRecord.getParamName())) continue;
                object.remove();
                continue block0;
            }
        }
    }

    private void removeAllPDCRecords(List<PDCRecord> object, List<PDCRecord> list) {
        object = object.iterator();
        block0: while (object.hasNext()) {
            Object object2 = (PDCRecord)object.next();
            if (object2 == null) continue;
            String string = object2.getName();
            object2 = object2.getParamName();
            for (PDCRecord pDCRecord : list) {
                if (pDCRecord == null || !string.equals(pDCRecord.getName()) || !((String)object2).equals(pDCRecord.getParamName())) continue;
                object.remove();
                continue block0;
            }
        }
    }

    private void cleanTsRecords(TSDataSet object) {
        if (object == null) {
            return;
        }
        object = object.getTSRecords();
        object = ((Vector)object).iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (e != null) continue;
            object.remove();
        }
    }

    private void cleanPDCRecords(PDCDataSet pDCDataSet) {
        pDCDataSet.removeIfIsNull();
    }

    public TSDataSet getOutputTSDataSet() {
        if (this.f != null) {
            return this.f;
        }
        Identifier identifier = new Identifier(this._outputTSDataPath);
        try {
            this.f = (TSDataSet)this._proxyList.loadManager(TSDataSet.class.getName(), identifier);
        }
        catch (RemoteException remoteException) {
            this.printErrorMessage("RssAlt.getOutputTSData - RemoteException" + String.valueOf(remoteException));
            RssAlt rssAlt = this;
            rssAlt.printMessage("Failed to load Output TSDataSet" + rssAlt._outputTSDataPath);
        }
        return this.f;
    }

    public String getSystemName() {
        if (this.c != null) {
            return this.c.getName();
        }
        return this._systemPath;
    }

    public String getOperationsName() {
        return this._operationsPath;
    }

    public String getObservedTSDataName() {
        if (this.g != null) {
            return this.g.getName();
        }
        return this._observedTSDataPath;
    }

    public String getObservedTSDataPath() {
        return this._observedTSDataPath;
    }

    public TSDataSet getObservedTSDataSet() {
        if (this.g != null && this.getName().equals(this.g.getName())) {
            return this.g;
        }
        if (this._observedTSDataPath == null) {
            return null;
        }
        Identifier identifier = new Identifier(this._observedTSDataPath);
        try {
            this.g = (TSDataSet)this._proxyList.loadManager(TSDataSet.class.getName(), identifier);
        }
        catch (RemoteException remoteException) {
            this.printErrorMessage("RssAlt.getObservedTSData - RemoteException" + String.valueOf(remoteException));
            RssAlt rssAlt = this;
            rssAlt.printMessage("Failed to load Observed TSDataSet" + rssAlt._observedTSDataPath);
        }
        return this.g;
    }

    public TSDataSet getObservedTSDataSet(TsVariant tsVariant) {
        if (tsVariant == null) {
            return this.getObservedTSDataSet();
        }
        return this.getObservedTSDataSet(tsVariant.getName(), tsVariant.hasNonDefaultInput());
    }

    public List<String> getObsTSVariantNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this._inputTsVariants.size());
        for (int i = 0; i < this._inputTsVariants.size(); ++i) {
            arrayList.add(this._inputTsVariants.get(i).getName());
        }
        return arrayList;
    }

    public TSDataSet getObservedTSDataSet(String string, boolean bl) {
        TsVariant tsVariant;
        Object object;
        if (string == null || string.isEmpty()) {
            return this.getObservedTSDataSet();
        }
        String string2 = this.getName().concat("-").concat(string);
        if (this.g != null && ((String)(object = string2 + OBS_SUFFIX)).equals(this.g.getName())) {
            return this.g;
        }
        ((FluentLogger.Api)b.atInfo()).log("getObservedTSDataSet:loading TSDataSet for Variant " + string);
        object = this.createObsTSDataPath(string);
        Identifier identifier = new Identifier((String)object);
        TSDataSet tSDataSet = null;
        try {
            tSDataSet = (TSDataSet)this._proxyList.loadManager(TSDataSet.class.getName(), identifier);
        }
        catch (RemoteException remoteException) {
            this.printErrorMessage("RssAlt.getObservedTSDataSet - RemoteException" + String.valueOf(remoteException));
            this.printMessage("Failed to load observed TSDataSet" + (String)object + " for variant " + string);
        }
        if (tSDataSet == null) {
            ((FluentLogger.Api)b.atInfo()).log("getObservedTSDataSet:creating ObsTS Variant " + (String)object);
            tSDataSet = (TSDataSet)this._proxyList.newManager("rss", TSDataSet.class.getName());
            if (tSDataSet == null) {
                this.printErrorMessage("Failed to create Obs TSDataSet for Variant " + string);
                return null;
            }
            identifier.setName(string2);
            tSDataSet.setName(string2 + OBS_SUFFIX);
            tSDataSet.setDescription(this.getDescription() + " (Obs TS Data Set for " + string + ")");
            tsVariant = this.getObservedTSDataSet();
            if (tsVariant != null) {
                tSDataSet.appendTSRecords((ITSDataSet)tsVariant);
            }
            if (!this._proxyList.saveManagerAs("rss", (Manager)tSDataSet, identifier)) {
                this.printErrorMessage("Failed to save Obs TSDataSet for Variant " + string + " to file " + (String)object);
            } else {
                string2 = (RmiWorkspace)this.getWorkspace().getRemote();
                try {
                    string2.saveWorkspace(UserId.getUserId());
                }
                catch (RemoteException remoteException) {
                    ((FluentLogger.Api)b.atInfo()).log("getObservedTSDataSet:error saving RmiWorkspace " + String.valueOf(remoteException));
                }
                TSDataSet tSDataSet2 = tSDataSet;
                tSDataSet2.readFile(tSDataSet2.getIdentifier());
                this.g = tSDataSet;
            }
        } else {
            this.g = tSDataSet;
        }
        tsVariant = new TsVariant(string);
        tsVariant.setHasNonDefaultInput(bl);
        if (!this._inputTsVariants.contains((Object)tsVariant)) {
            this._inputTsVariants.add(tsVariant);
            this.setModified(true);
            this.getProxyList().saveManager(UserId.getUserId(), (Manager)this);
        }
        return this.g;
    }

    private String createObsTSDataPath(String string) {
        return this.createInputDataPath(string + OBS_SUFFIX, TS_DATASET_FILE_EXT);
    }

    public String getInputTSDataName() {
        if (this.e != null) {
            return this.e.getName();
        }
        return this._inputTSDataPath;
    }

    public String getInputTSDataPath() {
        return this._inputTSDataPath;
    }

    public String getInputTSDataPath(String string) {
        if (string == null || string.isEmpty()) {
            return this.getInputTSDataPath();
        }
        string = this.createInputTSDataPath(string);
        return string;
    }

    public String getOutputTSDataName() {
        if (this.f != null) {
            return this.f.getName();
        }
        return this._outputTSDataPath;
    }

    public DssOutputData getWriteDSSOutputDataTable() {
        if (this._dssOutputData == null) {
            this._dssOutputData = new DssOutputData(this);
        }
        return this._dssOutputData;
    }

    public AltGlobalVarData getGlobalVariablesTable() {
        if (this._globalVarData == null) {
            this._globalVarData = new AltGlobalVarData(this);
        }
        return this._globalVarData;
    }

    public void setWriteDSSOutputDataTable(DssOutputData dssOutputData) {
        this._dssOutputData = dssOutputData;
    }

    @Deprecated
    public void setSystemPath(String string) {
        if (this.c != null) {
            if (this.c.getIdentifier().getPath().equals(string)) {
                return;
            }
            this._proxyList.unloadManager(this.c.getIdentifier());
            this.c = null;
        }
        this._systemPath = string;
        this.setModified(true);
    }

    public void setSystemIndex(int n) {
        if (this.c != null) {
            if (this.c.getIndex() == n) {
                return;
            }
            this._proxyList.unloadManager(this.c.getIdentifier());
            this.c = null;
        }
        this._networkID = n;
        this.setModified(true);
    }

    @Deprecated
    public String getSystemPath() {
        return this._systemPath;
    }

    public int getSystemIndex() {
        return this._networkID;
    }

    public void setOperationsPath(String string) {
        this._operationsPath = string;
        this.setModified(true);
    }

    public String getOperationsPath() {
        return this._operationsPath;
    }

    public void setFlowComputeType(int n) {
        if (n != 0 && n != 2 && n != 1) {
            return;
        }
        this._flowComputeType = n;
    }

    public void setPerAvgFlow(boolean bl) {
        this._flowComputeType = bl ? 1 : 2;
        this.setModified(true);
    }

    public void setDataSetPath(String string) {
        this._inputTSDataPath = string;
        this.setModified(true);
    }

    public void setObservedDataSetPath(String string) {
        this._observedTSDataPath = string;
        this.setModified(true);
    }

    public String getDataSetPath() {
        if (this._inputTSDataPath == null && this.getIdentifier() != null) {
            String string = this.getIdentifier().getPath();
            string = RMAIO.getFileNameNoExtension((String)string);
            this._inputTSDataPath = string.concat(TS_DATASET_FILE_EXT);
        }
        return this._inputTSDataPath;
    }

    public boolean writeFile(Identifier identifier) {
        super.writeFile(identifier);
        HecFile hecFile = identifier.getFile();
        if (hecFile == null) {
            return false;
        }
        this.setReloadOk(false);
        try {
            int n;
            Object object;
            Object object2;
            BufferedWriter bufferedWriter = hecFile.getBufferedWriter();
            if (bufferedWriter == null) {
                return false;
            }
            bufferedWriter.write("RssAlt Name=" + this.getName());
            bufferedWriter.newLine();
            String string = this.getDescription().replace('\n', '|');
            bufferedWriter.write("RssAlt Description=" + string);
            bufferedWriter.newLine();
            bufferedWriter.write("Version=" + Integer.toString(1001));
            bufferedWriter.newLine();
            this.writeLastModTime(bufferedWriter);
            bufferedWriter.write("NetworkID=" + this._networkID);
            bufferedWriter.newLine();
            RssAlt rssAlt = this;
            string = rssAlt.getRelativePath(rssAlt._systemPath);
            bufferedWriter.write("System Path=" + string);
            bufferedWriter.newLine();
            RssAlt rssAlt2 = this;
            string = rssAlt2.getRelativePath(rssAlt2._operationsPath);
            bufferedWriter.write("Operations Path=" + string);
            bufferedWriter.newLine();
            RssAlt rssAlt3 = this;
            string = rssAlt3.getRelativePath(rssAlt3._inputTSDataPath);
            bufferedWriter.write("InputTSData Path=" + string);
            bufferedWriter.newLine();
            RssAlt rssAlt4 = this;
            string = rssAlt4.getRelativePath(rssAlt4._outputTSDataPath);
            bufferedWriter.write("OutputTSData Path=" + string);
            bufferedWriter.newLine();
            RssAlt rssAlt5 = this;
            string = rssAlt5.getRelativePath(rssAlt5._inputGVDataPath);
            bufferedWriter.write("InputGVData Path=" + string);
            bufferedWriter.newLine();
            RssAlt rssAlt6 = this;
            string = rssAlt6.getRelativePath(rssAlt6._inputWQTSDataPath);
            bufferedWriter.write("InputWQTSDataPath Path=" + string);
            bufferedWriter.newLine();
            bufferedWriter.write("OutputVerticalDatum=" + this._outputVerticalDatumType.name());
            bufferedWriter.newLine();
            bufferedWriter.write("FlowComputeType=" + this._flowComputeType);
            bufferedWriter.newLine();
            bufferedWriter.write("ComputeHoldouts=" + this._computeHoldout);
            bufferedWriter.newLine();
            bufferedWriter.write("ComputeUnreg=" + this._computeUnReg);
            bufferedWriter.newLine();
            bufferedWriter.write("ComputeCumLoc=" + this._computeCumLoc);
            bufferedWriter.newLine();
            bufferedWriter.write("CopyOverrides=" + this._copyOverrides);
            bufferedWriter.newLine();
            bufferedWriter.write("UseObsTSData=" + this._useObsTSData);
            bufferedWriter.newLine();
            bufferedWriter.write("LogLevel=" + this._logLevel);
            bufferedWriter.newLine();
            if (this._waterAccountSetIndex != Integer.MIN_VALUE) {
                bufferedWriter.write("WaterAccountSetIndex=" + Integer.toString(this._waterAccountSetIndex));
                bufferedWriter.newLine();
            }
            bufferedWriter.write("UseYieldAnalysis=" + this._useYieldAnalysis);
            bufferedWriter.newLine();
            bufferedWriter.write("SelectedYieldAnalysis=" + String.valueOf((Object)this._selectedYieldAnalysis));
            bufferedWriter.newLine();
            if (this._reservoirYieldAnalysis != null) {
                ((YieldAnalysis)this._reservoirYieldAnalysis).writeFile(bufferedWriter, this);
            }
            if (this._reverseReservoirYieldAnalysis != null) {
                ((YieldAnalysis)this._reverseReservoirYieldAnalysis).writeFile(bufferedWriter, this);
            }
            if (this._waterAccountYieldAnalysis != null) {
                ((YieldAnalysis)this._waterAccountYieldAnalysis).writeFile(bufferedWriter, this);
            }
            if (this._reverseWaterAccountYieldAnalysis != null) {
                ((YieldAnalysis)this._reverseWaterAccountYieldAnalysis).writeFile(bufferedWriter, this);
            }
            if (this._reservoirStorageVsYieldAnalysis != null) {
                ((YieldAnalysis)this._reservoirStorageVsYieldAnalysis).writeFile(bufferedWriter, this);
            }
            if (this._timeStep != -1 && this._timeIncrement != -1) {
                bufferedWriter.write("TimeStep=" + this._timeStep);
                bufferedWriter.newLine();
                bufferedWriter.write("TimeIncrement=" + this._timeIncrement);
                bufferedWriter.newLine();
            }
            if (this._observedTSDataPath != null) {
                RssAlt rssAlt7 = this;
                string = rssAlt7.getRelativePath(rssAlt7._observedTSDataPath);
                bufferedWriter.write("ObservedTSData Path=" + string);
                bufferedWriter.newLine();
            }
            for (int i = 0; i < this._runList.size(); ++i) {
                object2 = this._runList.elementAt(i);
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("RssRun=" + (String)object2));
            }
            Object object3 = this._resOpSelectionTable.keys();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                object = this._resOpSelectionTable.get(object2);
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("resOpSelection=" + Integer.toString(((intContainer)object2).value) + "," + (Integer)object));
            }
            object3 = this._divOpSelectionTable.keys();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                object = this._divOpSelectionTable.get(object2);
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("divOpSelection=" + Integer.toString(((intContainer)object2).value) + "," + (Integer)object));
            }
            object3 = this._resSysOpSelectionTable.keys();
            while (object3.hasMoreElements()) {
                object2 = (Long)object3.nextElement();
                object = this._resSysOpSelectionTable.get(object2);
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("resSysOpSelection=" + (Long)object2 + "," + (Integer)object));
            }
            bufferedWriter.write("ReplaceAllReleaseOverrides=" + this._replaceAllReleaseOverrides);
            bufferedWriter.newLine();
            bufferedWriter.write("UseDiffAltResultsTableBegin");
            bufferedWriter.newLine();
            object3 = this._useDiffAltResultsTable.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                object = this._useDiffAltResultsTable.get(object2);
                if (!(object instanceof AltOverride)) continue;
                object = (AltOverride)object;
                bufferedWriter.write((String)object2 + ";" + ((AltOverride)object).b() + ";" + ((AltOverride)object).a() + ";" + ((AltOverride)object).c());
                bufferedWriter.newLine();
            }
            bufferedWriter.write("UseDiffAltResultsTableEnd");
            bufferedWriter.newLine();
            object3 = new StringBuffer();
            for (n = 0; n < this._embeddedAltRefList.size(); ++n) {
                object = this._embeddedAltRefList.get(n);
                if (object == null) continue;
                ((StringBuffer)object3).setLength(0);
                ((StringBuffer)object3).append("EmbeddedAltRef=");
                ((StringBuffer)object3).append(((ModelReference)object).wkspName);
                ((StringBuffer)object3).append(";");
                ((StringBuffer)object3).append(((ModelReference)object).className);
                ((StringBuffer)object3).append(";");
                ((StringBuffer)object3).append(((ModelReference)object).newId);
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)((StringBuffer)object3).toString());
            }
            if (this._dssOutputData != null) {
                bufferedWriter.write("DssOutputDataBegin");
                bufferedWriter.newLine();
                this._dssOutputData.write(bufferedWriter);
                bufferedWriter.write("DssOutputDataEnd");
                bufferedWriter.newLine();
            }
            for (n = 0; n < this._hindcastData.size(); ++n) {
                ((StringBuffer)object3).setLength(0);
                object = (HindcastData)this._hindcastData.elementAt(n);
                if (object == null) continue;
                ((StringBuffer)object3).append("Hindcast=");
                ((StringBuffer)object3).append(((HindcastData)object)._objectKey);
                ((StringBuffer)object3).append(';');
                ((StringBuffer)object3).append(((HindcastData)object)._varId);
                ((StringBuffer)object3).append(';');
                ((StringBuffer)object3).append(((HindcastData)object)._typeId);
                ((StringBuffer)object3).append(';');
                ((StringBuffer)object3).append(((HindcastData)object)._constValue);
                bufferedWriter.write(((StringBuffer)object3).toString());
                bufferedWriter.newLine();
            }
            for (n = 0; n < this._inputTsVariants.size(); ++n) {
                object = this._inputTsVariants.get(n);
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("InputTsVariant=" + object.getName() + "," + ((TsVariant)((Object)object)).hasNonDefaultInput()));
            }
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("UsingInflowFactors=" + this._usingInflowFactors));
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("InflowFactorType=" + this._inflowFactorType));
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("GlobalInflowFactor=" + this._globalInflowFactor));
            for (int i = 0; i < this._locationFactors.size(); ++i) {
                InflowLocationFactor inflowLocationFactor = this._locationFactors.get(i);
                if (inflowLocationFactor == null) continue;
                ((StringBuffer)object3).setLength(0);
                ((StringBuffer)object3).append("LocalInflowFactor=");
                ((StringBuffer)object3).append(inflowLocationFactor.getJunctionId());
                ((StringBuffer)object3).append(";");
                ((StringBuffer)object3).append(inflowLocationFactor.getLocalFlowName());
                ((StringBuffer)object3).append(";");
                ((StringBuffer)object3).append(inflowLocationFactor.getFactor());
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)((StringBuffer)object3).toString());
            }
            this._hotstartOptions.writeData(bufferedWriter);
            if (this._wqOpts != null) {
                this._wqOpts.writeData(bufferedWriter);
            }
            Object object4 = this._pluginSettings.keySet();
            object4 = object4.iterator();
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"PlugInDataBegin");
            for (int i = 0; i < this._pluginDataList.size(); ++i) {
                this._pluginDataList.get(i).write(bufferedWriter);
            }
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"PlugInDataEnd");
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                PluginSettings pluginSettings = this._pluginSettings.get(object3);
                if (pluginSettings == null) continue;
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("PluginSettings=" + (String)object3));
                pluginSettings.write(bufferedWriter);
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)"PluginSettingsEnd");
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            hecFile.save();
        }
        catch (IOException iOException) {
            this.setReloadOk(true);
            this.printMessage("Failed to open file " + identifier.getPath());
            return false;
        }
        this.setModified(false);
        this.setReloadOk(true);
        return true;
    }

    public boolean reLoadFile(Identifier identifier) {
        if (this._reloadOk) {
            this._runList.removeAllElements();
            return this.readFile(identifier);
        }
        return false;
    }

    public boolean readFile(Identifier identifier) {
        if ((identifier = identifier.getFile()) == null) {
            return false;
        }
        this.j = true;
        boolean bl = false;
        try {
            this._hindcastData.clear();
            BufferedReader bufferedReader = identifier.getBufferedReader();
            if (bufferedReader == null) {
                return false;
            }
            this._locationFactors.clear();
            this._embeddedAltRefList.clear();
            this._inputTsVariants.clear();
            String string = bufferedReader.readLine();
            System.out.println("readFile:" + String.valueOf(this) + " reading " + identifier.getPath());
            while (string != null) {
                block86: {
                    int n = string.indexOf(61);
                    if (n >= 0) {
                        try {
                            Object object = string.substring(0, n);
                            String string2 = string.substring(n + 1);
                            if (((String)object).compareTo("RssAlt Name") == 0) {
                                this.setName(string2);
                                break block86;
                            }
                            if (((String)object).compareTo("RssAlt Description") == 0) {
                                object = string2.replace('|', '\n');
                                this.setDescription((String)object);
                                break block86;
                            }
                            if (((String)object).compareTo("NetworkID") == 0) {
                                this._networkID = RMAIO.parseInt((String)string2, (int)-1);
                                break block86;
                            }
                            if (((String)object).compareTo("FlowComputeType") == 0) {
                                this._flowComputeType = RMAIO.parseInt((String)string2, (int)-1);
                                break block86;
                            }
                            if ("OutputVerticalDatum".equals(object)) {
                                try {
                                    this._outputVerticalDatumType = OutputVerticalDatumType.valueOf(string2);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    System.out.println("Execption reading output vertical datum type: " + string2);
                                    System.out.println(illegalArgumentException.getMessage());
                                    this._outputVerticalDatumType = OutputVerticalDatumType.AS_DEFINED;
                                }
                                break block86;
                            }
                            if ("Version".equals(object)) {
                                this._version = RMAIO.parseInt((String)string2, (int)this._version);
                                bl = true;
                                break block86;
                            }
                            if ("ComputeHoldouts".equals(object)) {
                                this._computeHoldout = Boolean.parseBoolean(string2);
                                break block86;
                            }
                            if ("ComputeUnreg".equalsIgnoreCase((String)object)) {
                                this._computeUnReg = Boolean.parseBoolean(string2);
                                break block86;
                            }
                            if ("ComputeCumLoc".equalsIgnoreCase((String)object)) {
                                this._computeCumLoc = Boolean.parseBoolean(string2);
                                break block86;
                            }
                            if ("CopyOverrides".equalsIgnoreCase((String)object)) {
                                this._copyOverrides = Boolean.parseBoolean(string2);
                                break block86;
                            }
                            if ("UseObsTSData".equalsIgnoreCase((String)object)) {
                                this._useObsTSData = Boolean.parseBoolean(string2);
                                break block86;
                            }
                            if ("LogLevel".equalsIgnoreCase((String)object)) {
                                this._logLevel = RMAIO.parseInt((String)string2, (int)this._logLevel);
                                break block86;
                            }
                            if (((String)object).compareTo("System Path") == 0) {
                                this._systemPath = string = this.makeAbsolutePath(string2);
                                break block86;
                            }
                            if (((String)object).compareTo("Operations Path") == 0) {
                                this._operationsPath = string = this.makeAbsolutePath(string2);
                                break block86;
                            }
                            if (((String)object).compareTo("InputTSData Path") == 0) {
                                this._inputTSDataPath = string = this.makeAbsolutePath(string2);
                                break block86;
                            }
                            if (((String)object).compareTo("OutputTSData Path") == 0) {
                                this._outputTSDataPath = string = this.makeAbsolutePath(string2);
                                break block86;
                            }
                            if (((String)object).compareTo("ObservedTSData Path") == 0) {
                                this._observedTSDataPath = string = this.makeAbsolutePath(string2);
                                break block86;
                            }
                            if (((String)object).compareTo("InputGVData") == 0) {
                                this._inputGVDataPath = string = this.makeAbsolutePath(string2);
                                break block86;
                            }
                            if (((String)object).compareTo("InputWQTSData") == 0) {
                                this._inputWQTSDataPath = string = this.makeAbsolutePath(string2);
                                break block86;
                            }
                            if (((String)object).compareTo("RssRun") == 0) {
                                this._runList.addElement(string2);
                                break block86;
                            }
                            if ("TimeStep".equalsIgnoreCase((String)object)) {
                                this._timeStep = RMAIO.parseInt((String)string2, (int)this._timeStep);
                                break block86;
                            }
                            if ("TimeIncrement".equalsIgnoreCase((String)object)) {
                                this._timeIncrement = RMAIO.parseInt((String)string2, (int)this._timeIncrement);
                                break block86;
                            }
                            if ("WaterAccountSet".equals(object)) break block86;
                            if ("UseYieldAnalysis".equalsIgnoreCase((String)object)) {
                                this._useYieldAnalysis = Boolean.parseBoolean(string2);
                                break block86;
                            }
                            if ("SelectedYieldAnalysis".equalsIgnoreCase((String)object)) {
                                this._selectedYieldAnalysis = YieldAnalysisType.a(string2);
                                break block86;
                            }
                            if ("WaterAccountSetIndex".equalsIgnoreCase((String)object)) {
                                this._waterAccountSetIndex = Integer.parseInt(string2);
                                break block86;
                            }
                            if ("InputTsVariant".equalsIgnoreCase((String)object)) {
                                object = new TsVariant();
                                var11_16 = string2.split(",");
                                if (var11_16 == null || ((String[])var11_16).length != 2) break block86;
                                object.setName(var11_16[0]);
                                if ("true".equalsIgnoreCase(var11_16[1])) {
                                    ((TsVariant)((Object)object)).setHasNonDefaultInput(true);
                                }
                                this._inputTsVariants.add((TsVariant)((Object)object));
                                break block86;
                            }
                            if (((String)object).compareTo("resOpSelection") == 0) {
                                int n2 = string2.indexOf(44);
                                int n3 = Integer.parseInt(string2.substring(0, n2));
                                int n4 = Integer.parseInt(string2.substring(n2 + 1));
                                this.addResOpSetSelection(n3, n4);
                                break block86;
                            }
                            if (((String)object).compareTo("divOpSelection") == 0) {
                                int n5 = string2.indexOf(44);
                                int n6 = Integer.parseInt(string2.substring(0, n5));
                                int n7 = Integer.parseInt(string2.substring(n5 + 1));
                                this.addDivOpSetSelection(n6, n7);
                                break block86;
                            }
                            if (((String)object).compareTo("resSysOpSelection") == 0) {
                                int n8 = string2.indexOf(44);
                                long l = Long.parseLong(string2.substring(0, n8));
                                int n9 = Integer.parseInt(string2.substring(n8 + 1));
                                this.addResSysOpSetSelection(l, n9);
                                break block86;
                            }
                            if (((String)object).compareTo("Hindcast") == 0) {
                                object = new StringTokenizer(string2, ";", false);
                                var11_16 = new HindcastData();
                                new HindcastData()._objectKey = ((StringTokenizer)object).nextToken();
                                ((HindcastData)var11_16)._varId = RMAIO.parseInt((String)((StringTokenizer)object).nextToken());
                                ((HindcastData)var11_16)._typeId = RMAIO.parseInt((String)((StringTokenizer)object).nextToken());
                                ((HindcastData)var11_16)._constValue = RMAIO.parseDouble((String)((StringTokenizer)object).nextToken());
                                this._hindcastData.addElement(var11_16);
                                break block86;
                            }
                            if (((String)object).compareTo("ModifiedTime") == 0) {
                                try {
                                    this.setLastModifiedTime(Long.parseLong(string2));
                                }
                                catch (NumberFormatException numberFormatException) {}
                                break block86;
                            }
                            if ("UsingInflowFactors".equalsIgnoreCase((String)object)) {
                                this._usingInflowFactors = Boolean.parseBoolean(string2);
                                break block86;
                            }
                            if ("InflowFactorType".equalsIgnoreCase((String)object)) {
                                this._inflowFactorType = RMAIO.parseInt((String)string2);
                                if (this._inflowFactorType == 0 || this._inflowFactorType == 1) break block86;
                                this._inflowFactorType = 0;
                                break block86;
                            }
                            if ("GlobalInflowFactor".equalsIgnoreCase((String)object)) {
                                this._globalInflowFactor = RMAIO.parseDouble((String)string2);
                                break block86;
                            }
                            if ("LocalInflowFactor".equalsIgnoreCase((String)object)) {
                                object = new StringTokenizer(string2, ";");
                                if (((StringTokenizer)object).countTokens() != 3) continue;
                                var11_16 = ((StringTokenizer)object).nextToken();
                                String string3 = ((StringTokenizer)object).nextToken();
                                double d = RMAIO.parseDouble((String)((StringTokenizer)object).nextToken());
                                if (var11_16 == null || ((String)var11_16).length() == 0 || string3 == null || string3.length() == 0) continue;
                                this._locationFactors.add(new InflowLocationFactor((String)var11_16, string3, d));
                                break block86;
                            }
                            if ("ReplaceAllReleaseOverrides".equalsIgnoreCase((String)object)) {
                                this._replaceAllReleaseOverrides = Boolean.parseBoolean(string2);
                                break block86;
                            }
                            if ("EmbeddedAltRef".equalsIgnoreCase((String)object)) {
                                object = new StringTokenizer(string2, ";");
                                if (((StringTokenizer)object).countTokens() != 3) continue;
                                var11_16 = ((StringTokenizer)object).nextToken();
                                String string4 = ((StringTokenizer)object).nextToken();
                                int n10 = RMAIO.parseInt((String)((StringTokenizer)object).nextToken());
                                if (var11_16 == null || ((String)var11_16).length() == 0 || string4 == null || string4.length() == 0) continue;
                                this._embeddedAltRefList.add(new ModelReference(n10, string4, (String)var11_16));
                                break block86;
                            }
                            if (!"PluginSettings".equalsIgnoreCase((String)object)) break block86;
                            try {
                                object = Class.forName(string2);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                System.out.println("readFile: ClassNotFoundException " + String.valueOf(classNotFoundException));
                                continue;
                            }
                            try {
                                var11_16 = ((Class)object).newInstance();
                            }
                            catch (InstantiationException instantiationException) {
                                System.out.println("readFile:InstantiationException " + String.valueOf(instantiationException));
                                continue;
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                System.out.println("readFile:IllegalAccessException " + String.valueOf(illegalAccessException));
                                continue;
                            }
                            if (!(var11_16 instanceof PluginSettings)) break block86;
                            PluginSettings pluginSettings = (PluginSettings)var11_16;
                            try {
                                pluginSettings.setAlternative(this);
                                if (!pluginSettings.load(bufferedReader)) break block86;
                                this._pluginSettings.put(pluginSettings.getClass().getName(), pluginSettings);
                            }
                            catch (IOException iOException) {
                                System.out.println("readFile:error reading plugin settings for " + string2 + " Error:" + String.valueOf(iOException));
                                iOException.printStackTrace();
                            }
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                    } else if ("UseDiffAltResultsTableBegin".equalsIgnoreCase(string)) {
                        string = bufferedReader.readLine();
                        while (!string.equalsIgnoreCase("UseDiffAltResultsTableEnd")) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                            var11_16 = stringTokenizer.nextToken();
                            String string5 = stringTokenizer.nextToken();
                            String string6 = stringTokenizer.nextToken();
                            String string7 = null;
                            if (stringTokenizer.hasMoreTokens()) {
                                string7 = stringTokenizer.nextToken();
                            }
                            this._useDiffAltResultsTable.put(var11_16, new AltOverride(Boolean.parseBoolean(string6), string5, string7));
                            string = bufferedReader.readLine();
                        }
                    } else if ("DssOutputDataBegin".equalsIgnoreCase(string)) {
                        this._dssOutputData = new DssOutputData(this);
                        this._dssOutputData.read(bufferedReader);
                    } else if ("Hotstart Options".equalsIgnoreCase(string)) {
                        this._hotstartOptions.loadData(bufferedReader);
                    } else if ("ReservoirYieldAnalysisBegin".equalsIgnoreCase(string)) {
                        this._reservoirYieldAnalysis = new ReservoirYieldAnalysis();
                        ((YieldAnalysis)this._reservoirYieldAnalysis).readFile(bufferedReader);
                    } else if ("ReverseReservoirYieldAnalysisBegin".equalsIgnoreCase(string)) {
                        this._reverseReservoirYieldAnalysis = new ReverseReservoirYieldAnalysis(this);
                        ((YieldAnalysis)this._reverseReservoirYieldAnalysis).readFile(bufferedReader);
                    } else if ("WaterAccountYieldAnalysisBegin".equalsIgnoreCase(string)) {
                        this._waterAccountYieldAnalysis = new WaterAccountYieldAnalysis();
                        ((YieldAnalysis)this._waterAccountYieldAnalysis).readFile(bufferedReader);
                    } else if ("ReverseWaterAccountYieldAnalysisBegin".equalsIgnoreCase(string)) {
                        this._reverseWaterAccountYieldAnalysis = new ReverseWaterAccountYieldAnalysis(this);
                        ((YieldAnalysis)this._reverseWaterAccountYieldAnalysis).readFile(bufferedReader);
                    } else if ("ReservoirStorageVsYieldAnalysisBegin".equalsIgnoreCase(string)) {
                        this._reservoirStorageVsYieldAnalysis = new ReservoirStorageVsYieldAnalysis(this);
                        ((YieldAnalysis)this._reservoirStorageVsYieldAnalysis).readFile(bufferedReader);
                    } else if ("WaterQualityBegin".equals(string)) {
                        AltWaterQualityOptions altWaterQualityOptions = this.getWaterQualityOptions();
                        altWaterQualityOptions.readData(bufferedReader);
                    } else if ("PlugInDataBegin".equalsIgnoreCase(string)) {
                        this._pluginDataList.clear();
                        string = bufferedReader.readLine();
                        System.out.println("readFile:" + String.valueOf(this) + " reading " + identifier.getPath());
                        while (string != null) {
                            n = string.indexOf(58);
                            if (n >= 0) {
                                String string8 = string.substring(0, n);
                                String string9 = string.substring(n + 1);
                                if (string8.equals("PlugIn")) {
                                    try {
                                        var11_16 = (AltPluginData)AltPluginDataFactory.getFactory().getAltPluginData(string9);
                                        ((AbstractAltPluginData)var11_16).setAlt(this);
                                        var11_16.setType(string9);
                                        var11_16.read(bufferedReader);
                                        this._pluginDataList.add((AltPluginData)var11_16);
                                    }
                                    catch (Exception exception) {
                                        ((FluentLogger.Api)b.atInfo()).log("Unable to read plugin data for plugin type %s  Error %s\n", (Object)string9, (Object)exception.getMessage());
                                    }
                                } else if (string8.equals("PlugInDataEnd")) continue;
                            }
                            string = bufferedReader.readLine();
                        }
                    }
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.printMessage("Failed to open file ");
            this.j = false;
            return false;
        }
        if (!bl) {
            this._version = 1000;
        }
        this.j = false;
        this.setModified(false);
        return true;
    }

    public boolean isValid() {
        return false;
    }

    public void setTimeStep(int n, int n2) {
        this._timeStep = n;
        this._timeIncrement = n2;
    }

    public int getTimestep() {
        return this._timeStep;
    }

    public int getTimestepIncrement() {
        return this._timeIncrement;
    }

    public AltPluginData getAltPluginData(String string) {
        for (int i = 0; i < this._pluginDataList.size(); ++i) {
            AltPluginData altPluginData = this._pluginDataList.get(i);
            if (!altPluginData.getType().equals(string)) continue;
            altPluginData.setAlt(this);
            return altPluginData;
        }
        return null;
    }

    public int compute(RssRun rssRun) {
        for (int i = 0; i < this._pluginDataList.size(); ++i) {
            AltPluginData altPluginData = this._pluginDataList.get(i);
            if (!altPluginData.useCompute()) continue;
            if (altPluginData instanceof MissingAltPluginData) {
                this.printErrorMessage("\nError: Alternative plugin is not available.");
                return 1;
            }
            return altPluginData.compute(rssRun);
        }
        if (this.useYieldAnalysis()) {
            return rssRun.computeFirmYield();
        }
        return rssRun.computeStandard();
    }

    public void addAltPluginData(AltPluginData altPluginData) {
        this._pluginDataList.add(altPluginData);
    }

    public void setReplaceAll(boolean bl) {
        this._replaceAllReleaseOverrides = bl;
    }

    public boolean replaceAllReleaseOverrides() {
        return this._replaceAllReleaseOverrides;
    }

    public boolean useOtherAltResults(String string) {
        if ((string = this._useDiffAltResultsTable.get(string)) == null || !(string instanceof AltOverride)) {
            return false;
        }
        return ((AltOverride)((Object)string)).a();
    }

    public String getUseOtherAltName(String object) {
        if ((object = this._useDiffAltResultsTable.get(object)) == null || !(object instanceof AltOverride)) {
            return null;
        }
        if (((AltOverride)(object = (AltOverride)object)).a()) {
            return ((AltOverride)object).b();
        }
        return null;
    }

    public String getUseOtherAltCollectionSequence(String string) {
        if ((string = this._useDiffAltResultsTable.get(string)) == null || !(string instanceof AltOverride)) {
            return null;
        }
        return ((AltOverride)((Object)string)).c();
    }

    public void setReleaseOverridesAlt(String string, AltOverride altOverride) {
        this._useDiffAltResultsTable.put(string, altOverride);
        this.setModified(true);
    }

    public void setUseOtherAltResults(boolean bl, String string) {
        if ((string = this._useDiffAltResultsTable.get(string)) instanceof AltOverride) {
            ((AltOverride)((Object)string)).a(bl);
        }
    }

    public void clearUserOtherAltOverrides() {
        this._useDiffAltResultsTable.clear();
        this._replaceAllReleaseOverrides = false;
    }

    public String getTimeStepString() {
        if (this._timeStep == -1 || this._timeIncrement == -1) {
            this._timeIncrement = 2;
            this._timeStep = 1;
            this.setModified(true);
            String string = this.getName();
            this.printWarningMessage(string + " is missing its timestep, defaulting to 1 hour");
        }
        return RunTimeWindow.getTimeStepString((int)this._timeStep, (int)this._timeIncrement);
    }

    public void addRun(String string) {
        if (string == null || this._runList.contains(string)) {
            return;
        }
        this._runList.addElement(string);
        this.setModified(true);
    }

    public Vector getRunList() {
        return (Vector)this._runList.clone();
    }

    public void deleteRun(String string) {
        if (string == null) {
            return;
        }
        this._runList.removeElement(string);
        this.setModified(true);
    }

    public void deleting() {
        String string = this.getDataSetPath();
        File file = new File(string);
        if (file.exists()) {
            try {
                if (!this.getFileManager().deleteFile(string)) {
                    RssAlt rssAlt = this;
                    rssAlt.printWarningMessage(rssAlt.getName() + ".deleting: Failed to delete Alternative's *.fits file " + string);
                }
            }
            catch (RemoteException remoteException) {
                RssAlt rssAlt = this;
                rssAlt.printWarningMessage(rssAlt.getName() + ".deleting: Error deleting Alternative's *.fits file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
        if ((file = new File(string = string.concat(".bak"))).exists()) {
            try {
                if (!this.getFileManager().deleteFile(string)) {
                    RssAlt rssAlt = this;
                    rssAlt.printWarningMessage(rssAlt.getName() + ".deleting: Failed to delete Alternative's *.fits.bak file " + string);
                }
            }
            catch (RemoteException remoteException) {
                RssAlt rssAlt = this;
                rssAlt.printWarningMessage(rssAlt.getName() + ".deleting: Error deleting Alternative's *.fits.bak file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
        if ((file = new File(string = this.getObservedTSDataPath())).exists()) {
            try {
                if (!this.getFileManager().deleteFile(string)) {
                    RssAlt rssAlt = this;
                    rssAlt.printWarningMessage(rssAlt.getName() + ".deleting: Failed to delete Alternative's *.fits file " + string);
                }
            }
            catch (RemoteException remoteException) {
                RssAlt rssAlt = this;
                rssAlt.printWarningMessage(rssAlt.getName() + ".deleting: Error deleting Alternative's *.fits file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
        if ((file = new File(string = string.concat(".bak"))).exists()) {
            try {
                if (!this.getFileManager().deleteFile(string)) {
                    RssAlt rssAlt = this;
                    rssAlt.printWarningMessage(rssAlt.getName() + ".deleting: Failed to delete Alternative's *.fits.bak file " + string);
                }
            }
            catch (RemoteException remoteException) {
                RssAlt rssAlt = this;
                rssAlt.printWarningMessage(rssAlt.getName() + ".deleting: Error deleting Alternative's *.fits.bak file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
        file = this.getIdentifier().getFile();
        string = file.getPath();
        if (file != null && file.exists()) {
            try {
                if (!this.getFileManager().deleteFile(string)) {
                    RssAlt rssAlt = this;
                    rssAlt.printWarningMessage(rssAlt.getName() + ".deleting: Failed to delete *.rsys file " + string);
                }
            }
            catch (RemoteException remoteException) {
                RssAlt rssAlt = this;
                rssAlt.printWarningMessage(rssAlt.getName() + ".deleting: Error deleting *.rsys file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
        if ((file = new File(string = string.concat(".bak"))).exists()) {
            try {
                if (!this.getFileManager().deleteFile(string)) {
                    RssAlt rssAlt = this;
                    rssAlt.printWarningMessage(rssAlt.getName() + ".deleting: Failed to delete *.rsys.bak file " + string);
                }
            }
            catch (RemoteException remoteException) {
                RssAlt rssAlt = this;
                rssAlt.printWarningMessage(rssAlt.getName() + ".deleting: Error deleting *.rsys.bak file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
        if (this.hasWaterQualityOptions()) {
            this.getWaterQualityOptions().deleteManagers(this);
        }
    }

    public void renameRun(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        this._runList.removeElement(string);
        this._runList.addElement(string2);
        this.setModified(true);
    }

    public long getLastModifiedTime() {
        long l = super.getLastModifiedTime();
        if (l == Long.MAX_VALUE) {
            l = 0L;
        }
        RssAlt rssAlt = this;
        l = rssAlt.getModTime(rssAlt._systemPath, RssSystem.class.getName(), l);
        RssAlt rssAlt2 = this;
        l = rssAlt2.getModTime(rssAlt2._operationsPath, Operations.class.getName(), l);
        RssAlt rssAlt3 = this;
        l = rssAlt3.getModTime(rssAlt3._inputTSDataPath, TSDataSet.class.getName(), l);
        RssAlt rssAlt4 = this;
        l = rssAlt4.getModTime(rssAlt4._outputTSDataPath, TSDataSet.class.getName(), l);
        RssAlt rssAlt5 = this;
        l = rssAlt5.getModTime(rssAlt5._observedTSDataPath, TSDataSet.class.getName(), l);
        RssAlt rssAlt6 = this;
        l = rssAlt6.getModTime(rssAlt6._inputGVDataPath, GVDataSet.class.getName(), l);
        RssAlt rssAlt7 = this;
        l = rssAlt7.getModTime(rssAlt7._inputWQTSDataPath, TSDataSet.class.getName(), l);
        if (this.hasWaterQualityOptions()) {
            AltWaterQualityOptions altWaterQualityOptions = this.getWaterQualityOptions();
            l = this.getModTime(altWaterQualityOptions.getParametersId(), ParameterSetManager.class.getName(), l);
            l = this.getModTime(altWaterQualityOptions.getConstituentId(), ConstituentSetManager.class.getName(), l);
            l = this.getModTime(altWaterQualityOptions.getDispersionCoefId(), DispersionSetManager.class.getName(), l);
            l = this.getModTime(altWaterQualityOptions.getGeometryId(), WqGeometry.class.getName(), l);
            l = this.getModTime(altWaterQualityOptions.getIcId(), InitialConditionSetManager.class.getName(), l);
            l = this.getModTime(altWaterQualityOptions.getMassInjectionId(), MassInjectionSetManager.class.getName(), l);
            l = this.getModTime(altWaterQualityOptions.getMetDataId(), MetData.class.getName(), l);
            l = this.getModTime(altWaterQualityOptions.getObservedDataId(), ObsDatasetManager.class.getName(), l);
            l = this.getModTime(altWaterQualityOptions.getBcId(), BoundaryConditionSetManager.class.getName(), l);
        }
        return l;
    }

    public void unloading() {
        this.unloadManagers();
    }

    void unloadManagers() {
        if (this.c != null) {
            this._proxyList.unloadManager(this.c.getIdentifier());
            this.c = null;
        }
        if (this.e != null) {
            this._proxyList.unloadManager(this.e.getIdentifier());
            this.e = null;
        }
        if (this.g != null) {
            this._proxyList.unloadManager(this.g.getIdentifier());
            this.g = null;
        }
        if (this._inputGVData != null) {
            this._proxyList.unloadManager(this._inputGVData.getIdentifier());
            this._inputGVData = null;
        }
        if (this.n != null) {
            this._proxyList.unloadManager(this.n.getIdentifier());
            this.n = null;
        }
    }

    public boolean saveChildManagers() {
        String string = UserId.getUserId();
        if (this.c != null && this.c.isModified()) {
            this._proxyList.saveManager(string, (Manager)this.c);
        }
        if (this.e != null && this.e.isModified()) {
            this._proxyList.saveManager(string, (Manager)this.e);
        }
        if (this.g != null && this.g.isModified()) {
            this._proxyList.saveManager(string, (Manager)this.g);
        }
        if (this._inputGVData != null && this._inputGVData.isModified()) {
            this._proxyList.saveManager(string, (Manager)this._inputGVData);
        }
        if (this.n != null && this.n.isModified()) {
            this._proxyList.saveManager(string, (Manager)this.n);
        }
        if (this.isModified()) {
            this._proxyList.saveManager(string, (Manager)this);
        }
        return true;
    }

    public boolean reLoadChildManagers() {
        if (this.c != null && this.c.isModified()) {
            this.c.reLoadFile();
        }
        if (this.e != null && this.e.isModified()) {
            this.e.reLoadFile();
        }
        if (this.g != null && this.g.isModified()) {
            this.g.reLoadFile();
        }
        if (this._inputGVData != null && this._inputGVData.isModified()) {
            this._inputGVData.reLoadFile();
        }
        if (this.n != null && this.n.isModified()) {
            this.n.reLoadFile();
        }
        if (this.isModified()) {
            this.reLoadFile();
        }
        return true;
    }

    public void setModified(boolean bl) {
        if (this.j) {
            return;
        }
        super.setModified(bl);
    }

    public Manager saveManagerAs(String object, String string, ManagerProxyListContainer object2) {
        Manager manager;
        RssSystem rssSystem;
        if (object2 == null) {
            object2 = this._proxyList.getContainer();
        }
        if ((rssSystem = this.getSystem()) == null) {
            System.out.println("-----------------------------------------------------------------");
            System.out.println("NULL RSS System. Save As Can't Continue, Returning NULL");
            System.out.println("-----------------------------------------------------------------");
            return null;
        }
        Object object4 = RMAIO.getFileNameNoExtension((String)rssSystem.getIdentifier().getPath());
        object4 = string != null ? RMAIO.userNameToFileName((String)(string + "_" + (String)object4)) : RMAIO.userNameToFileName((String)object4);
        Object object5 = RMAIO.concatPath((String)object, (String)"networks");
        object4 = RMAIO.concatPath((String)object5, (String)object4);
        object4 = (RssSystem)rssSystem.saveManagerAs((String)object4, string, (ManagerProxyListContainer)object2);
        object5 = this.getInputTSDataSet();
        if (object5 == null) {
            System.out.println("-----------------------------------------------------------------");
            System.out.println("NULL Time Series Data Set. Save As Can't Continue, Returning NULL");
            System.out.println("-----------------------------------------------------------------");
            return null;
        }
        Manager manager2 = object5.saveManagerAs((String)object, string, (ManagerProxyListContainer)object2);
        for (TsVariant object32 : this._inputTsVariants) {
            try {
                System.out.println("saveManagerAs:copying TSDataSet variant " + object32.getName());
                object5 = this.getInputTSDataSet(object32.getName(), object32.hasNonDefaultInput());
                if (object5 == null) {
                    System.out.println("-----------------------------------------------------------------");
                    System.out.println("NULL Time Series Data Set for Variant. " + String.valueOf((Object)object32));
                    System.out.println("-----------------------------------------------------------------");
                } else {
                    System.out.println("saveManagerAs:saving TSDataSet " + object5.getName() + " to " + (String)object);
                    manager = object5.saveManagerAs((String)object, string, (ManagerProxyListContainer)object2);
                    if (manager == null) {
                        System.out.println("saveManagerAs:ERROR: failed to save TSDataSet " + object5.getName() + " to " + (String)object);
                    } else {
                        System.out.println("saveManagerAs:copied TSDataSet" + object5.getName() + " to " + manager.getIdentifier().getPath());
                    }
                }
                if (!this.hasWaterQualityOptions() || !this._wqOpts.shouldRunWq()) continue;
                this.saveWQDataSets(object32, (String)object, string, (ManagerProxyListContainer)object2);
            }
            catch (Exception exception) {
                System.out.println("saveManagerAs:ERROR getting input TS DataSet for variant " + object32.getName() + " Error:" + exception.toString());
            }
        }
        TSDataSet tSDataSet = this.getObservedTSDataSet();
        manager = null;
        if (tSDataSet != null) {
            manager = tSDataSet.saveManagerAs((String)object, string, (ManagerProxyListContainer)object2);
        }
        if ((object5 = this.getInputGVDataSet()) == null) {
            System.out.println("-----------------------------------------------------------------");
            System.out.println("NULL Global Variable Data Set. Save As Can't Continue, Returning NULL");
            System.out.println("-----------------------------------------------------------------");
            return null;
        }
        Object object6 = ((GVDataSet)((Object)object5)).saveManagerAs((String)object, string, (ManagerProxyListContainer)object2, rssSystem);
        object6.refreshData((Manager)object5);
        for (TsVariant tsVariant : this._inputTsVariants) {
            object5 = this.getInputGVDataSet(tsVariant.getName(), tsVariant.hasNonDefaultInput());
            if (object5 == null) {
                System.out.println("-----------------------------------------------------------------");
                System.out.println("NULL Global Variable Data Set for Variant. " + String.valueOf((Object)tsVariant));
                System.out.println("-----------------------------------------------------------------");
                continue;
            }
            Manager manager3 = ((GVDataSet)((Object)object5)).saveManagerAs((String)object, string, (ManagerProxyListContainer)object2, rssSystem);
            manager3.refreshData((Manager)object5);
        }
        this.unloadManagers();
        String string2 = this._proxyList.getModel();
        ManagerProxyList managerProxyList = object2.getManagerProxyList(string2);
        rssSystem = managerProxyList.newManager(this.getClass().getName());
        object5 = this.getSaveAsId((String)object, string, rssSystem.getIndex());
        if (object5 == null) {
            return null;
        }
        rssSystem.getIdentifier().copy((Identifier)object5);
        rssSystem.getIdentifier().setName(string + ":" + this.getName());
        rssSystem.setName(string + ":" + this.getName());
        rssSystem.setDescription(this.getDescription());
        object5 = (RssAlt)((Object)rssSystem);
        object6 = this._wqOpts;
        if (object6 != null) {
            try {
                ((RssAlt)object5)._wqOpts = object = ((AltWaterQualityOptions)object6).saveManagersAs(this, (String)object, string, (ManagerProxyListContainer)object2, object4.getIndex());
            }
            catch (Exception exception) {
                System.out.println("saveManagerAs:error copying WQ options for " + this.getName() + " Error:" + String.valueOf(exception));
                RssAlt rssAlt = this;
                rssAlt.printErrorMessage("Error Copying WQ options for " + rssAlt.getName() + " Error:" + String.valueOf(exception));
                exception.printStackTrace(System.out);
            }
        }
        ((RssAlt)object5).setPerAvgFlow(this.isPerAvgFlow());
        ((RssAlt)object5).setSystemIndex(object4.getIndex());
        ((RssAlt)object5).setSystemPath(object4.getIdentifier().getPath());
        ((RssAlt)object5).setDataSetPath(manager2.getIdentifier().getPath());
        ((RssAlt)object5)._timeStep = this._timeStep;
        ((RssAlt)object5)._timeIncrement = this._timeIncrement;
        ((RssAlt)object5)._flowComputeType = this._flowComputeType;
        ((RssAlt)object5)._inputTsVariants.clear();
        ((RssAlt)object5)._inputTsVariants.addAll(this._inputTsVariants);
        if (manager != null) {
            ((RssAlt)object5).setObservedDataSetPath(manager.getIdentifier().getPath());
        }
        ((RssAlt)object5)._resOpSelectionTable = (Hashtable)this._resOpSelectionTable.clone();
        ((RssAlt)object5)._divOpSelectionTable = (Hashtable)this._divOpSelectionTable.clone();
        ((RssAlt)object5)._resSysOpSelectionTable = (Hashtable)this._resSysOpSelectionTable.clone();
        ((RssAlt)object5)._hindcastData = (Vector)this._hindcastData.clone();
        ((RssAlt)object5)._locationFactors = (List)((ArrayList)this._locationFactors).clone();
        ((RssAlt)object5)._embeddedAltRefList = (List)((ArrayList)this._embeddedAltRefList).clone();
        ((RssAlt)object5)._globalInflowFactor = this._globalInflowFactor;
        ((RssAlt)object5)._inflowFactorType = this._inflowFactorType;
        ((RssAlt)object5)._usingInflowFactors = this._usingInflowFactors;
        ((RssAlt)object5)._hotstartOptions = this._hotstartOptions.clone();
        ((RssAlt)object5)._logLevel = this._logLevel;
        ((RssAlt)object5)._computeUnReg = this._computeUnReg;
        ((RssAlt)object5)._computeHoldout = this._computeHoldout;
        ((RssAlt)object5)._computeCumLoc = this._computeCumLoc;
        ((RssAlt)object5)._copyOverrides = this._copyOverrides;
        ((RssAlt)object5)._useYieldAnalysis = this._useYieldAnalysis;
        ((RssAlt)object5)._outputVerticalDatumType = this._outputVerticalDatumType;
        ((RssAlt)object5)._selectedYieldAnalysis = this._selectedYieldAnalysis;
        if (this._reservoirYieldAnalysis != null) {
            ((RssAlt)object5)._reservoirYieldAnalysis = (ReservoirYieldAnalysis)((YieldAnalysis)this._reservoirYieldAnalysis).clone();
        }
        if (this._reverseReservoirYieldAnalysis != null) {
            ((RssAlt)object5)._reverseReservoirYieldAnalysis = (ReverseReservoirYieldAnalysis)((YieldAnalysis)this._reverseReservoirYieldAnalysis).clone();
        }
        if (this._waterAccountYieldAnalysis != null) {
            ((RssAlt)object5)._waterAccountYieldAnalysis = (WaterAccountYieldAnalysis)((YieldAnalysis)this._waterAccountYieldAnalysis).clone();
        }
        if (this._reverseReservoirYieldAnalysis != null) {
            ((RssAlt)object5)._reverseWaterAccountYieldAnalysis = this._reverseWaterAccountYieldAnalysis.g();
        }
        if (this._reservoirStorageVsYieldAnalysis != null) {
            ((RssAlt)object5)._reservoirStorageVsYieldAnalysis = this._reservoirStorageVsYieldAnalysis.j();
        }
        ((RssAlt)object5)._useDiffAltResultsTable = (Hashtable)this._useDiffAltResultsTable.clone();
        ((RssAlt)object5)._dssOutputData = (DssOutputData)this._dssOutputData.clone();
        ((RssAlt)object5)._replaceAllReleaseOverrides = this._replaceAllReleaseOverrides;
        ((RssAlt)object5)._waterAccountSetIndex = this._waterAccountSetIndex;
        ((RssAlt)object5)._pluginDataList = new ArrayList<AltPluginData>();
        int n = this._pluginDataList.size();
        for (int i = 0; i < n; ++i) {
            try {
                object2 = this._pluginDataList.get(i).clone();
                object2.setAlt((RssAlt)object5);
                ((RssAlt)object5)._pluginDataList.add((AltPluginData)object2);
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                System.out.println("RssAlt.saveManagerAs() AltPluginData.clone: Error in clone " + String.valueOf(cloneNotSupportedException));
            }
        }
        managerProxyList.saveManager(UserId.getUserId(), (Manager)rssSystem);
        ((RssAlt)object5).n = null;
        ((RssAlt)object5)._inputGVData = null;
        ((RssAlt)object5).e = null;
        if (((RssAlt)((Object)rssSystem))._wqOpts != null) {
            ((RssAlt)((Object)rssSystem))._wqOpts.updateObsStationNetworkElements(((RssAlt)((Object)rssSystem)).getSystem(), this.getSystem());
        }
        return rssSystem;
    }

    private void saveWQDataSets(TsVariant tsVariant, String string, String string2, ManagerProxyListContainer managerProxyListContainer) {
        Manager manager;
        TSDataSet tSDataSet = this.getInputWQTSDataSet(tsVariant.getName(), tsVariant.hasNonDefaultInput());
        if (tSDataSet == null) {
            System.out.println("-----------------------------------------------------------------");
            System.out.println("NULL WQ Input Time Series Data Set for Variant. " + String.valueOf((Object)tsVariant));
            System.out.println("-----------------------------------------------------------------");
        } else {
            System.out.println("saveManagerAs:saving WQ Input TSDataSet " + tSDataSet.getName() + " to " + string);
            manager = tSDataSet.saveManagerAs(string, string2, managerProxyListContainer);
            if (manager == null) {
                System.out.println("saveManagerAs:ERROR: failed to save WQ Input TSDataSet " + tSDataSet.getName() + " to " + string);
            } else {
                System.out.println("saveManagerAs:copied WQ Input TSDataSet" + tSDataSet.getName() + " to " + manager.getIdentifier().getPath());
            }
        }
        manager = this.getInputWQPDCDataSet(tsVariant.getName(), tsVariant.hasNonDefaultInput());
        if (manager == null) {
            System.out.println("-----------------------------------------------------------------");
            System.out.println("NULL WQ Input PairedData Data Set for Variant. " + String.valueOf((Object)tsVariant));
            System.out.println("-----------------------------------------------------------------");
        } else {
            System.out.println("saveManagerAs:saving WQ Input PDCDataSet " + manager.getName() + " to " + string);
            tSDataSet = manager.saveManagerAs(string, string2, managerProxyListContainer);
            if (tSDataSet == null) {
                System.out.println("saveManagerAs:ERROR: failed to save WQ Input PDCDataSet " + manager.getName() + " to " + string);
            } else {
                System.out.println("saveManagerAs:copied WQ Input PDCDataSet" + manager.getName() + " to " + tSDataSet.getIdentifier().getPath());
            }
        }
        tSDataSet = this.getObsWQTSDataSet(tsVariant.getName(), tsVariant.hasNonDefaultInput());
        if (tSDataSet == null) {
            System.out.println("-----------------------------------------------------------------");
            System.out.println("NULL Obs WQ Time Series Data Set for Variant. " + String.valueOf((Object)tsVariant));
            System.out.println("-----------------------------------------------------------------");
        } else {
            System.out.println("saveManagerAs:saving Obs WQ TSDataSet " + tSDataSet.getName() + " to " + string);
            manager = tSDataSet.saveManagerAs(string, string2, managerProxyListContainer);
            if (manager == null) {
                System.out.println("saveManagerAs:ERROR: failed to save Obs WQ TSDataSet " + tSDataSet.getName() + " to " + string);
            } else {
                System.out.println("saveManagerAs:copied WQ Input TSDataSet" + tSDataSet.getName() + " to " + manager.getIdentifier().getPath());
            }
        }
        manager = this.getObsWQPDCDataSet(tsVariant.getName(), tsVariant.hasNonDefaultInput());
        if (manager == null) {
            System.out.println("-----------------------------------------------------------------");
            System.out.println("NULL Obs WQ PairedData Data Set for Variant. " + String.valueOf((Object)tsVariant));
            System.out.println("-----------------------------------------------------------------");
            return;
        }
        System.out.println("saveManagerAs:saving Obs WQ PDCDataSet " + manager.getName() + " to " + string);
        tsVariant = manager.saveManagerAs(string, string2, managerProxyListContainer);
        if (tsVariant == null) {
            System.out.println("saveManagerAs:ERROR: failed to save Obs WQ PDCDataSet " + manager.getName() + " to " + string);
            return;
        }
        System.out.println("saveManagerAs:copied Obs WQ PDCDataSet" + manager.getName() + " to " + tsVariant.getIdentifier().getPath());
    }

    public boolean refreshData(Manager manager) {
        int n;
        if (manager == null) {
            return false;
        }
        if (!(manager instanceof RssAlt)) {
            ((FluentLogger.Api)b.atInfo()).log("refreshData: the other manager is not a ResSim Alternative it is a %s", (Object)manager.getClass().getName());
            return false;
        }
        RssAlt rssAlt = (RssAlt)manager;
        Object object = rssAlt.getSystem();
        RssSystem rssSystem = this.getSystem();
        if (object == null || rssSystem == null) {
            ((FluentLogger.Api)b.atInfo()).log("refreshData: Error didn't find needed networks. My Network=%s other Sys=%s", (Object)rssSystem, object);
            return false;
        }
        if (object.isModified()) {
            object.getProxyList().saveManager(UserId.getUserId(), (Manager)object);
        }
        if (rssSystem.isModified()) {
            rssSystem.getProxyList().saveManager(UserId.getUserId(), (Manager)rssSystem);
        }
        if (!rssSystem.refreshData((Manager)object)) {
            return false;
        }
        Object object2 = rssAlt.getInputTSDataSet();
        Object object3 = this.getInputTSDataSet();
        Object object4 = rssAlt.getObservedTSDataSet();
        Object object5 = this.getObservedTSDataSet();
        Object object6 = this.getInputGVDataSet();
        Object object7 = rssAlt.getInputGVDataSet();
        if (!object3.refreshData((Manager)object2)) {
            ((FluentLogger.Api)b.atInfo()).log("refreshData: Error Input TS Data Set failed to refresh. My Input TS Data= %s other Input TS Data=%s", object3, object2);
            return false;
        }
        if (object5 != null && !object5.refreshData((Manager)object4)) {
            ((FluentLogger.Api)b.atInfo()).log("refreshData: Error Obs TS Data Set failed to refresh. My Obs TS Data=%s other Obs TS Data=%s", object5, object4);
            return false;
        }
        ((RssSystem)object).copyGlobalVariableTables(rssSystem);
        if (!((GVDataSet)((Object)object6)).refreshData((Manager)object7)) {
            ((FluentLogger.Api)b.atInfo()).log("refreshData: Error Input Global Variable Data Set failed to refresh. My Input GV Data=%s other Input GV Data=%s", object3, object2);
            return false;
        }
        object = this._wqOpts;
        if (object != null && !((AltWaterQualityOptions)object).refreshData(this, rssAlt)) {
            ((FluentLogger.Api)b.atInfo()).log("refreshData:Error failed to refresh Water Quality Options.");
            return false;
        }
        this._inputTsVariants.clear();
        this._inputTsVariants.addAll(rssAlt._inputTsVariants);
        for (n = 0; n < this._inputTsVariants.size(); ++n) {
            object4 = this._inputTsVariants.get(n);
            object2 = rssAlt.getInputTSDataSet(object4.getName(), ((TsVariant)((Object)object4)).hasNonDefaultInput());
            object3 = this.getInputTSDataSet(object4.getName(), ((TsVariant)((Object)object4)).hasNonDefaultInput());
            if (object2 != null && object3 != null) {
                object3.refreshData((Manager)object2);
            }
            object7 = rssAlt.getInputGVDataSet(object4.getName(), ((TsVariant)((Object)object4)).hasNonDefaultInput());
            object6 = this.getInputGVDataSet(object4.getName(), ((TsVariant)((Object)object4)).hasNonDefaultInput());
            if (object7 == null || object6 == null) continue;
            ((GVDataSet)((Object)object6)).refreshData((Manager)object7);
        }
        this._resOpSelectionTable = (Hashtable)rssAlt._resOpSelectionTable.clone();
        this._divOpSelectionTable = (Hashtable)rssAlt._divOpSelectionTable.clone();
        this._resSysOpSelectionTable = (Hashtable)rssAlt._resSysOpSelectionTable.clone();
        n = this.getIndex();
        int n2 = this.getSystemIndex();
        this._waterAccountSetIndex = rssAlt._waterAccountSetIndex;
        object2 = this.getName();
        object3 = this.getDescription();
        object5 = this.getSystemPath();
        object6 = this.getOperationsPath();
        object7 = this.getInputTSDataPath();
        String string = this.getOutputTSDataName();
        String string2 = this.getObservedTSDataPath();
        String string3 = this.getInputGVDataPath();
        String string4 = this.getInputWQTSDataPath();
        this._hindcastData.clear();
        if (rssAlt.useYieldAnalysis()) {
            this._selectedYieldAnalysis = rssAlt._selectedYieldAnalysis;
            if (rssAlt._reservoirYieldAnalysis != null) {
                this._reservoirYieldAnalysis = (ReservoirYieldAnalysis)((YieldAnalysis)rssAlt._reservoirYieldAnalysis).clone();
            }
            if (rssAlt._reverseReservoirYieldAnalysis != null) {
                this._reverseReservoirYieldAnalysis = (ReverseReservoirYieldAnalysis)((YieldAnalysis)rssAlt._reverseReservoirYieldAnalysis).clone();
            }
            if (rssAlt._waterAccountYieldAnalysis != null) {
                this._waterAccountYieldAnalysis = (WaterAccountYieldAnalysis)((YieldAnalysis)rssAlt._waterAccountYieldAnalysis).clone();
            }
            if (rssAlt._reverseWaterAccountYieldAnalysis != null) {
                this._reverseWaterAccountYieldAnalysis = rssAlt._reverseWaterAccountYieldAnalysis.g();
            }
            if (rssAlt._reservoirStorageVsYieldAnalysis != null) {
                this._reservoirStorageVsYieldAnalysis = rssAlt._reservoirStorageVsYieldAnalysis.j();
            }
        }
        if (object != null) {
            object = ((AltWaterQualityOptions)object).clone();
        }
        if (this.readFile(manager.getIdentifier())) {
            this._wqOpts = object;
            this.setIndex(n);
            this.setName((String)object2);
            this._networkID = n2;
            this.setDescription((String)object3);
            this._systemPath = object5;
            this._operationsPath = object6;
            this._inputTSDataPath = object7;
            this._outputTSDataPath = string;
            this._observedTSDataPath = string2;
            this._inputGVDataPath = string3;
            this._inputWQTSDataPath = string4;
            RssAlt rssAlt2 = this;
            return rssAlt2.writeFile(rssAlt2.getIdentifier());
        }
        return true;
    }

    public Object clone() {
        try {
            int n;
            RssAlt rssAlt = (RssAlt)super.clone();
            ((RssAlt)super.clone())._runList = (Vector)this._runList.clone();
            rssAlt._outputVerticalDatumType = this._outputVerticalDatumType;
            rssAlt._resOpSelectionTable = (Hashtable)this._resOpSelectionTable.clone();
            rssAlt._divOpSelectionTable = (Hashtable)this._divOpSelectionTable.clone();
            rssAlt._resSysOpSelectionTable = (Hashtable)this._resSysOpSelectionTable.clone();
            rssAlt._hindcastData = (Vector)this._hindcastData.clone();
            rssAlt._locationFactors = (List)((ArrayList)this._locationFactors).clone();
            rssAlt._embeddedAltRefList = (List)((ArrayList)this._embeddedAltRefList).clone();
            rssAlt._hotstartOptions = this._hotstartOptions.clone();
            rssAlt._usingInflowFactors = this._usingInflowFactors;
            rssAlt._inflowFactorType = this._inflowFactorType;
            rssAlt._globalInflowFactor = this._globalInflowFactor;
            rssAlt._locationFactors = this._locationFactors;
            rssAlt._usingInflowFactors = this._usingInflowFactors;
            rssAlt._useYieldAnalysis = this._useYieldAnalysis;
            rssAlt._replaceAllReleaseOverrides = this._replaceAllReleaseOverrides;
            rssAlt._useDiffAltResultsTable = (Hashtable)this._useDiffAltResultsTable.clone();
            rssAlt._dssOutputData = (DssOutputData)this._dssOutputData.clone();
            rssAlt._selectedYieldAnalysis = this._selectedYieldAnalysis;
            if (this._reservoirYieldAnalysis != null) {
                rssAlt._reservoirYieldAnalysis = (ReservoirYieldAnalysis)((YieldAnalysis)this._reservoirYieldAnalysis).clone();
            }
            if (this._reverseReservoirYieldAnalysis != null) {
                rssAlt._reverseReservoirYieldAnalysis = (ReverseReservoirYieldAnalysis)((YieldAnalysis)this._reverseReservoirYieldAnalysis).clone();
            }
            if (this._waterAccountYieldAnalysis != null) {
                rssAlt._waterAccountYieldAnalysis = (WaterAccountYieldAnalysis)((YieldAnalysis)this._waterAccountYieldAnalysis).clone();
            }
            if (this._reverseWaterAccountYieldAnalysis != null) {
                rssAlt._reverseWaterAccountYieldAnalysis = this._reverseWaterAccountYieldAnalysis.g();
            }
            if (this._reservoirStorageVsYieldAnalysis != null) {
                rssAlt._reservoirStorageVsYieldAnalysis = this._reservoirStorageVsYieldAnalysis.j();
            }
            rssAlt._waterAccountSetIndex = this._waterAccountSetIndex;
            int n2 = this._pluginDataList.size();
            rssAlt._pluginDataList = new ArrayList<AltPluginData>();
            for (n = 0; n < n2; ++n) {
                AltPluginData altPluginData = this._pluginDataList.get(n).clone();
                rssAlt._pluginDataList.add(altPluginData);
            }
            rssAlt._inputTsVariants = new ArrayList<TsVariant>();
            for (n = 0; n < this._inputTsVariants.size(); ++n) {
                rssAlt._inputTsVariants.add((TsVariant)((Object)this._inputTsVariants.get(n).clone()));
            }
            return rssAlt;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("RssAlt.clone: Error in clone " + String.valueOf(cloneNotSupportedException));
            return null;
        }
    }

    public boolean copyInto(RssAlt rssAlt) {
        int n;
        if (rssAlt == null) {
            return false;
        }
        if (rssAlt == this) {
            return true;
        }
        this.setName(rssAlt.getName());
        this.setDescription(rssAlt.getDescription());
        if (this.c != null) {
            this._proxyList.unloadManager(this.c.getIdentifier());
        }
        this.c = null;
        this.d = null;
        if (this.e != null) {
            this._proxyList.unloadManager(this.e.getIdentifier());
        }
        this.e = null;
        if (this.f != null) {
            this._proxyList.unloadManager(this.f.getIdentifier());
        }
        this.f = null;
        if (this.g != null) {
            this._proxyList.unloadManager(this.g.getIdentifier());
        }
        this.g = null;
        if (this._inputGVData != null) {
            this._proxyList.unloadManager(this._inputGVData.getIdentifier());
        }
        this._inputGVData = null;
        if (this.n != null) {
            this._proxyList.unloadManager(this.n.getIdentifier());
        }
        this.n = null;
        this._outputVerticalDatumType = rssAlt._outputVerticalDatumType;
        this._systemPath = rssAlt._systemPath;
        this._operationsPath = rssAlt._operationsPath;
        this._inputTSDataPath = rssAlt._inputTSDataPath;
        this._outputTSDataPath = rssAlt._outputTSDataPath;
        this._observedTSDataPath = rssAlt._observedTSDataPath;
        this._inputGVDataPath = rssAlt._inputGVDataPath;
        this._inputWQTSDataPath = rssAlt._inputWQTSDataPath;
        this._networkID = rssAlt._networkID;
        this._runList = (Vector)rssAlt._runList.clone();
        this._resOpSelectionTable = (Hashtable)rssAlt._resOpSelectionTable.clone();
        this._divOpSelectionTable = (Hashtable)rssAlt._divOpSelectionTable.clone();
        this._resSysOpSelectionTable = (Hashtable)rssAlt._resSysOpSelectionTable.clone();
        this.h = new intContainer(rssAlt.h);
        this._hindcastData = (Vector)rssAlt._hindcastData.clone();
        this._timeStep = rssAlt._timeStep;
        this._timeIncrement = rssAlt._timeIncrement;
        this._flowComputeType = rssAlt._flowComputeType;
        this._inputTsVariants.clear();
        if (rssAlt._inputTsVariants != null && rssAlt._inputTsVariants.size() > 0) {
            for (n = 0; n < rssAlt._inputTsVariants.size(); ++n) {
                TsVariant tsVariant = rssAlt._inputTsVariants.get(n);
                try {
                    this._inputTsVariants.add((TsVariant)((Object)tsVariant.clone()));
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    System.out.println("copyInto:failed to clone TsVariant " + String.valueOf(cloneNotSupportedException));
                }
            }
        }
        this._usingInflowFactors = rssAlt._usingInflowFactors;
        this._inflowFactorType = rssAlt._inflowFactorType;
        this._globalInflowFactor = rssAlt._globalInflowFactor;
        this._locationFactors = (List)((ArrayList)rssAlt._locationFactors).clone();
        this._embeddedAltRefList = (List)((ArrayList)rssAlt._embeddedAltRefList).clone();
        this._hotstartOptions = rssAlt._hotstartOptions.clone();
        this._flowComputeType = rssAlt._flowComputeType;
        this._logLevel = rssAlt._logLevel;
        this._computeHoldout = rssAlt._computeHoldout;
        this._computeUnReg = rssAlt._computeUnReg;
        this._computeCumLoc = rssAlt._computeCumLoc;
        this._copyOverrides = rssAlt._copyOverrides;
        this._useYieldAnalysis = rssAlt._useYieldAnalysis;
        this._selectedYieldAnalysis = rssAlt._selectedYieldAnalysis;
        if (rssAlt._reservoirYieldAnalysis != null) {
            this._reservoirYieldAnalysis = (ReservoirYieldAnalysis)((YieldAnalysis)rssAlt._reservoirYieldAnalysis).clone();
        }
        if (rssAlt._reverseReservoirYieldAnalysis != null) {
            this._reverseReservoirYieldAnalysis = (ReverseReservoirYieldAnalysis)((YieldAnalysis)rssAlt._reverseReservoirYieldAnalysis).clone();
        }
        if (rssAlt._reverseWaterAccountYieldAnalysis != null) {
            this._reverseWaterAccountYieldAnalysis = rssAlt._reverseWaterAccountYieldAnalysis.g();
        }
        if (rssAlt._waterAccountYieldAnalysis != null) {
            this._waterAccountYieldAnalysis = (WaterAccountYieldAnalysis)((YieldAnalysis)rssAlt._waterAccountYieldAnalysis).clone();
        }
        if (rssAlt._reservoirStorageVsYieldAnalysis != null) {
            this._reservoirStorageVsYieldAnalysis = rssAlt._reservoirStorageVsYieldAnalysis.j();
        }
        this._waterAccountSetIndex = rssAlt._waterAccountSetIndex;
        this._useDiffAltResultsTable = (Hashtable)rssAlt._useDiffAltResultsTable.clone();
        this._replaceAllReleaseOverrides = rssAlt._replaceAllReleaseOverrides;
        this._dssOutputData = (DssOutputData)rssAlt._dssOutputData.clone();
        if (rssAlt._wqOpts != null) {
            this._wqOpts = rssAlt._wqOpts.clone();
        }
        n = rssAlt._pluginDataList.size();
        this._pluginDataList = new ArrayList<AltPluginData>();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                try {
                    if (rssAlt._pluginDataList.get(i) == null) continue;
                    this._pluginDataList.add(rssAlt._pluginDataList.get(i).clone());
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    System.out.println("RssAlt copyInto() AltPluginData.clone : Error in clone " + String.valueOf(cloneNotSupportedException));
                }
            }
        }
        this.setModified(true);
        return true;
    }

    public boolean copyGvDataSetsInto(RssAlt rssAlt) {
        this._inputGVDataPath = null;
        RssAlt rssAlt2 = rssAlt;
        return this.copyGvDataSetsInto(rssAlt2, rssAlt2._inputTsVariants);
    }

    private boolean copyGvDataSetsInto(RssAlt rssAlt, List<TsVariant> list) {
        GVDataSet gVDataSet = rssAlt.getInputGVDataSet();
        boolean bl = this.copyGVDataSetInto(gVDataSet, null);
        boolean bl2 = true | bl;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                TsVariant tsVariant = list.get(i);
                GVDataSet gVDataSet2 = rssAlt.getInputGVDataSet(tsVariant);
                bl = this.copyGVDataSetInto(gVDataSet2, tsVariant);
                bl2 |= bl;
            }
        }
        return bl2;
    }

    private boolean copyGVDataSetInto(GVDataSet gVDataSet, TsVariant object) {
        Identifier identifier;
        String string;
        if (gVDataSet == null) {
            return true;
        }
        if (object == null) {
            string = this.getGVDataSetPath();
            object = this.getInputGVDataSet();
        } else {
            string = this.createInputGVDataPath(object.getName());
            object = this.getInputGVDataSet((TsVariant)((Object)object));
        }
        Identifier identifier2 = new Identifier(string);
        try {
            identifier = this.getFileManager().openFile(UserId.getUserId(), identifier2);
            if (identifier == null) {
                identifier = this.getFileManager().newFile(UserId.getUserId(), identifier2);
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("copyGVDataSetInto:failed to open file " + string);
            return false;
        }
        if (identifier == null) {
            return false;
        }
        boolean bl = gVDataSet.writeFile(identifier);
        if (bl && object != null) {
            ((GVDataSet)((Object)object)).readFile(identifier);
        }
        return bl;
    }

    public void setInflowFactorType(int n) {
        this._inflowFactorType = n;
    }

    public int getInflowFactorType() {
        return this._inflowFactorType;
    }

    public void setGlobalInflowFactor(double d) {
        this._globalInflowFactor = d;
    }

    public double getGlobalInflowFactor() {
        return this._globalInflowFactor;
    }

    public void setLocationInflowFactors(List<InflowLocationFactor> list) {
        if (this._locationFactors == list) {
            return;
        }
        this._locationFactors.clear();
        if (list == null) {
            return;
        }
        this._locationFactors.addAll(list);
    }

    public List<InflowLocationFactor> getLocationInflowFactors() {
        ArrayList<InflowLocationFactor> arrayList = new ArrayList<InflowLocationFactor>();
        arrayList.addAll(this._locationFactors);
        return arrayList;
    }

    public double[] getLocationInflowFactors(JunctionElement object, double[] dArray) {
        if (object == null) {
            Arrays.fill(dArray, 1.0);
            return dArray;
        }
        if (dArray == null || dArray.length == 0) {
            return dArray;
        }
        object = ((Element)object).getSystem().getKeyStringForObject(object);
        int n = this._locationFactors.size();
        int n2 = 0;
        for (int i = 0; i < n && n2 < dArray.length; ++i) {
            InflowLocationFactor inflowLocationFactor = this._locationFactors.get(i);
            if (inflowLocationFactor == null || !((String)object).equals(inflowLocationFactor.getJunctionId())) continue;
            dArray[n2++] = inflowLocationFactor.getFactor();
        }
        return dArray;
    }

    public void setUsingInflowFactors(boolean bl) {
        this._usingInflowFactors = bl;
    }

    public boolean isDefaultFlowCompute() {
        return this._flowComputeType == 0;
    }

    public int getFlowComputeType() {
        return this._flowComputeType;
    }

    public boolean isPerAvgFlow() {
        RssAlt rssAlt = this;
        int n = rssAlt.getFlowComputeType(rssAlt.getTimeStepSeconds());
        return n == 1;
    }

    public int getComputedFlowComputeType() {
        return this.k;
    }

    private int getTimeStepSeconds() {
        int n = 0;
        if (this._timeStep == -1) {
            n = 3600;
        } else if (this._timeIncrement == 1) {
            n = 60 * this._timeStep;
        } else if (this._timeIncrement == 2) {
            n = this._timeStep * 3600;
        } else if (this._timeIncrement == 3) {
            n = this._timeStep * 86400;
        }
        return n;
    }

    public boolean isUsingInflowFactors() {
        return this._usingInflowFactors;
    }

    public double getLocationInflowFactor(JunctionElement junctionElement, String string) {
        if (!this._usingInflowFactors) {
            return 1.0;
        }
        if (this._inflowFactorType == 0) {
            return this._globalInflowFactor;
        }
        if (junctionElement == null || string == null) {
            return 1.0;
        }
        String string2 = junctionElement.getSystem().getKeyStringForObject(junctionElement);
        int n = this._locationFactors.size();
        for (int i = 0; i < n; ++i) {
            InflowLocationFactor inflowLocationFactor = this._locationFactors.get(i);
            if (inflowLocationFactor == null || !string2.equals(inflowLocationFactor.getJunctionId()) || !string.equals(inflowLocationFactor.getLocalFlowName())) continue;
            return inflowLocationFactor.getFactor();
        }
        this.printWarningMessage("Failed to find Local Inflow Factor entry for " + String.valueOf(junctionElement) + ":" + string + " returning default factor of 1.0");
        return 1.0;
    }

    public HotstartOptions getHotstartOptions() {
        return this._hotstartOptions;
    }

    public boolean getComputeUnReg() {
        return this._computeUnReg;
    }

    public void setComputeUnReg(boolean bl) {
        this._computeUnReg = bl;
        this.setModified(true);
    }

    public void setComputeCumLoc(boolean bl) {
        this._computeCumLoc = bl;
        this.setModified(true);
    }

    public boolean getComputeCumLoc() {
        return this._computeCumLoc;
    }

    public void setCopyOverrides(boolean bl) {
        this._copyOverrides = bl;
    }

    public boolean getComputeHoldout() {
        return this._computeHoldout;
    }

    public void setComputeHoldout(boolean bl) {
        this._computeHoldout = bl;
        this.setModified(true);
    }

    public int getLogLevel() {
        return this._logLevel;
    }

    public void setLogLevel(int n) {
        this._logLevel = n;
        this.setModified(true);
    }

    public int getVersion() {
        return this._version;
    }

    public static int[] a(RssAlt object) {
        if (object == null) {
            return new int[]{-1, -1};
        }
        Object object2 = ((RssAlt)object).getSystem();
        if (object2 != null) {
            int n;
            Object object3;
            ((RssSystem)object2).setAlternative((RssAlt)object);
            ((RssSystem)object2).updateTSProxyList();
            ((RssSystem)object2).getActiveTSProxies(null, 1);
            HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
            int[] cfr_ignored_0 = new int[2];
            List<JunctionElement> list = ((RssSystem)object2).getHeadwaterJunctions();
            DSSPathname dSSPathname = new DSSPathname();
            for (int i = 0; i < list.size(); ++i) {
                Object object4;
                object3 = list.get(i);
                object2 = new Vector();
                Vector vector = ((Element)object3).getNodeVector();
                Vector<RssNode> vector2 = new Vector<RssNode>();
                for (n = 0; n < vector.size(); ++n) {
                    if (((Element)object3).getNodeDir(n) != 1) continue;
                    vector2.add((RssNode)vector.get(n));
                }
                for (n = 0; n < vector2.size(); ++n) {
                    object4 = (RssNode)vector2.get(n);
                    object2 = object4.getActiveTSProxies((Vector)object2, 1);
                }
                object4 = (TSDataSet)object.getInputITSDataSet();
                if (object4 == null) {
                    return new int[]{-1, -1};
                }
                for (int j = 0; j < ((Vector)object2).size(); ++j) {
                    TSRecordProxy tSRecordProxy = (TSRecordProxy)((Vector)object2).get(j);
                    object3 = object4.getTSRecord(tSRecordProxy.getName(), tSRecordProxy.getVariableId());
                    if (object3 == null) continue;
                    dSSPathname.setPathname(object3.getDSSPathname());
                    object3 = dSSPathname.getEPart();
                    if (object3 == null || ((String)object3).length() <= 0) continue;
                    object3 = ((String)object3).toUpperCase();
                    int n2 = HecTimeSeriesBase.getIntervalFromEPart((String)object3);
                    if ((object3 = (intContainer)hashMap.get(n2)) == null) {
                        object3 = new intContainer(0);
                        hashMap.put(n2, object3);
                    }
                    ++((intContainer)object3).value;
                }
            }
            Set set = hashMap.keySet();
            Object object5 = set.iterator();
            int n3 = 0;
            n = 0;
            while (object5.hasNext()) {
                int n4 = (Integer)object5.next();
                object3 = (intContainer)hashMap.get(n4);
                if (((intContainer)object3).value <= n3) continue;
                n3 = ((intContainer)object3).value;
                n = n4;
            }
            if (n > 0) {
                object5 = HecTimeSeriesBase.getEPartFromInterval((int)n);
                object5 = ((String)object5).toUpperCase();
                int[] nArray = RunTimeWindow.getTimeStep((String)object5);
                object = nArray;
                return nArray;
            }
        }
        return new int[]{-1, -1};
    }

    public int getFlowComputeType(int n) {
        int n2 = this.getFlowComputeType();
        if (n2 == 0) {
            HecTime hecTime;
            Object object = this.getSystem();
            if (this.k != 0 && object != null && ((RssSystem)object).getRssRun() != null) {
                return this.k;
            }
            if (object == null) {
                if (n <= 7200) {
                    this.k = 2;
                    this.printMessage("Program-Determined Flow Computation Method: Instantaneous");
                    return 2;
                }
                this.k = 1;
                this.printMessage("Program-Determined Flow Computation Method: Period Average");
                return 1;
            }
            object = ((RssSystem)object).getHeadwaterJunctions();
            int n3 = object.size();
            TSDataSet tSDataSet = this.getInputTSDataSet();
            DSSManager dSSManager = this.getDSSFileManager();
            DSSPathname dSSPathname = new DSSPathname();
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            DSSIdentifier dSSIdentifier = new DSSIdentifier();
            HecTime hecTime2 = new HecTime();
            HecTime hecTime3 = new HecTime();
            stringContainer stringContainer2 = new stringContainer();
            stringContainer stringContainer3 = new stringContainer();
            RssRun rssRun = this.c.getRssRun();
            Object object2 = "01Jan1800";
            if (rssRun != null && (hecTime = rssRun.getRunTimeWindow().getStartTime()) != null) {
                object2 = hecTime.date(104);
                object2 = "01" + ((String)object2).substring(2);
            }
            for (int i = 0; i < n3; ++i) {
                int n4;
                Object object3 = (JunctionElement)object.get(i);
                Vector vector = new Vector();
                Object object4 = ((Element)object3).getNodeVector();
                Vector<RssNode> vector2 = new Vector<RssNode>();
                for (n4 = 0; n4 < ((Vector)object4).size(); ++n4) {
                    if (((Element)object3).getNodeDir(n4) != 1) continue;
                    vector2.add((RssNode)((Vector)object4).get(n4));
                }
                for (n4 = 0; n4 < vector2.size(); ++n4) {
                    object4 = (RssNode)vector2.get(n4);
                    vector = ((RssNode)object4).getActiveTSProxies(vector, 1);
                }
                for (int j = 0; j < vector.size(); ++j) {
                    object3 = (TSRecordProxy)vector.get(j);
                    object3.setTSDataSet(tSDataSet);
                    object3 = tSDataSet.getTSRecord(object3.getName(), object3.getVariableId());
                    dSSPathname.setPathname(object3.getDSSPathname());
                    dSSPathname.setDPart((String)object2);
                    try {
                        dSSIdentifier.setDSSPath(dSSPathname.getPathname());
                        object3 = rssRun != null ? rssRun.getDSSOutputFile() : this.makeAbsolutePath(object3.getDSSFilename());
                        dSSIdentifier.setFileName((String)object3);
                        dSSManager.getTSRecordInfo(dSSIdentifier, hecTime2, hecTime3, stringContainer2, stringContainer3);
                    }
                    catch (RemoteException remoteException) {
                        System.out.println("RemoteException " + String.valueOf(remoteException));
                        continue;
                    }
                    if ("PER-AVER".equalsIgnoreCase(stringContainer3.string)) {
                        this.printMessage("Program-Determined Flow Computation Method: Period Average");
                        this.k = 1;
                        return 1;
                    }
                    nArray3[0] = 1;
                    Heclib.zgintl((int[])nArray2, (String)dSSPathname.getEPart(), (int[])nArray, (int[])nArray3);
                    if (nArray3[0] != 0 || nArray2[0] <= 7200) continue;
                    this.printMessage("Program-Determined Flow Computation Method: Period Average");
                    this.k = 2;
                    return 1;
                }
            }
            if (n > 7200) {
                this.k = 1;
                this.printMessage("Program-Determined Flow Computation Method: Period Average");
                return 1;
            }
            this.printMessage("Program-Determined Flow Computation Method: Instantaneous");
            this.k = 2;
            return 2;
        }
        return n2;
    }

    public void initCompute() {
        this.k = 0;
        int n = this.getFlowComputeType();
        if (n == 2) {
            this.printMessage("User-Determined Flow Computation Method: Instantaneous");
        } else if (n == 1) {
            this.printMessage("User-Determined Flow Computation Method: Period Average");
        }
        RssAlt rssAlt = this;
        rssAlt.printMessage("Alternative Type: " + rssAlt.getAltTypeName());
        Object object = this._pluginSettings.values();
        object = object.iterator();
        while (object.hasNext()) {
            ((PluginSettings)object.next()).initCompute(this);
        }
    }

    private String getAltTypeName() {
        if (this.useYieldAnalysis()) {
            return "Yield Analysis";
        }
        String string = this.getComputingAltPluginType();
        if (string != null) {
            return string;
        }
        return "Standard";
    }

    public void setUseYieldAnalysis(boolean bl) {
        this._useYieldAnalysis = bl;
    }

    @Scriptable
    public boolean useYieldAnalysis() {
        return this._useYieldAnalysis;
    }

    public void setUserName(String string) {
        this.m = string;
    }

    public String toString() {
        if (this.m != null) {
            return this.m;
        }
        return super.toString();
    }

    public void addPluginSettings(PluginSettings pluginSettings) {
        if (pluginSettings == null) {
            return;
        }
        this._pluginSettings.put(pluginSettings.getClass().getName(), pluginSettings);
    }

    public PluginSettings getPluginSettings(String string) {
        if (string == null) {
            return null;
        }
        return this._pluginSettings.get(string);
    }

    public List<AltPluginData> getPluginDataList() {
        return this._pluginDataList;
    }

    public void clearPluginSettings(String string) {
        if (string == null) {
            return;
        }
        this._pluginSettings.remove(string);
    }

    public boolean writeReport(BufferedWriter bufferedWriter, RunTimeWindow object, RssRun rssRun) {
        if (bufferedWriter == null || object == null) {
            ((FluentLogger.Api)b.atWarning()).log("Error writing alternative report for %s, no file output or RuntimeWindow", (Object)this.getName());
            return false;
        }
        try {
            bufferedWriter.write("HEC-ResSim");
            bufferedWriter.newLine();
            bufferedWriter.write("U.S. Army Corps of Engineers");
            bufferedWriter.newLine();
            bufferedWriter.write("Hydrologic Engineering Center");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("*** ResSim ALTERNATIVE DATA ***");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("Alternative:   " + this.getName());
            bufferedWriter.newLine();
            bufferedWriter.write("Network:       " + this.getSystemName());
            bufferedWriter.newLine();
            bufferedWriter.write("Sim Lookback:  " + object.getLookbackTimeString());
            bufferedWriter.newLine();
            bufferedWriter.write("Sim Start:     " + object.getStartTimeString());
            bufferedWriter.newLine();
            bufferedWriter.write("Sim End:       " + object.getEndTimeString());
            bufferedWriter.newLine();
            bufferedWriter.write("WaterAccountSetIndex:       " + Integer.toString(this._waterAccountSetIndex));
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            for (int i = 0; i < this._pluginDataList.size(); ++i) {
                object = this._pluginDataList.get(i);
                if (!object.useCompute()) continue;
                if (object instanceof MissingAltPluginData) {
                    this.printErrorMessage("Error: Alternative plugin is not available.");
                    return false;
                }
                return object.writeReport(bufferedWriter, rssRun);
            }
        }
        catch (IOException iOException) {
            ((FluentLogger.Api)b.atWarning()).log("Error writing alternative report for %s, error %s", (Object)this.getName(), (Object)iOException.getMessage());
            ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)b.atWarning()).withStackTrace(StackSize.SMALL)).withCause((Throwable)iOException)).log();
        }
        return true;
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        org.jdom.Element element2;
        element.setAttribute("Alt_Name", this.getDisplayName());
        element.setAttribute("Description", this.getDescription());
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.INPUT_DATA).a()) {
            Object object;
            int n;
            int n2;
            Object object2;
            org.jdom.Element element3;
            org.jdom.Element element4;
            Object object3;
            org.jdom.Element element5 = new org.jdom.Element("Input_Data");
            element.addContent((Content)element5);
            if (alternativeInputReport.b().get((Object)AltInputReportEnums.RUN_CONTROLS).a()) {
                element2 = new org.jdom.Element("Run_Control_Tab");
                element5.addContent((Content)element2);
                element2.setAttribute("Time_Step", this.getTimeStepString());
                if (this.getFlowComputeType() == 2) {
                    element2.setAttribute("Flow_Computation_Method", "Instantaneous");
                } else if (this.getFlowComputeType() == 1) {
                    element2.setAttribute("Flow_Computation_Method", "Period Average");
                }
                element2.setAttribute("Compute_Unreg_Flows", Boolean.toString(this._computeUnReg));
                element2.setAttribute("Compute_Holdouts", Boolean.toString(this._computeHoldout));
                element2.setAttribute("Log_Level", Integer.toString(this.getLogLevel()));
            } else {
                element5.setAttribute("Alternative_Type", "Standard");
            }
            if (alternativeInputReport.b().get((Object)AltInputReportEnums.OPERATIONS).a()) {
                element2 = new org.jdom.Element("Operations_Tab");
                element5.addContent((Content)element2);
                object3 = this.getSystem().getReservoirSysOps();
                if (object3 != null && ((ReservoirSysOp[])object3).length > 0) {
                    element4 = new org.jdom.Element("Reservoir_Systems");
                    element2.addContent((Content)element4);
                    for (int i = 0; i < ((Object)object3).length; ++i) {
                        element3 = new org.jdom.Element("Reservoir_System");
                        element4.addContent((Content)element3);
                        element3.setAttribute("ReservoirSystemName", object3[i].getName());
                        int n3 = this.getResSysOpSetSelection(object3[i].getIndex());
                        ResSystemOpSet resSystemOpSet = ((ReservoirSysOp)object3[i]).getSystemOpSet(n3);
                        if (resSystemOpSet == null) continue;
                        element3.setAttribute("StorageBalance", resSystemOpSet.getName());
                    }
                }
                element4 = new org.jdom.Element("Reservoir_Operation_Sets");
                element2.addContent((Content)element4);
                object2 = this.c.getReservoirNames();
                for (n2 = 0; n2 < ((String[])object2).length; ++n2) {
                    ReservoirElement reservoirElement = this.c.findReservoir(object2[n2]);
                    if (reservoirElement == null) continue;
                    element3 = new org.jdom.Element("Reservoir_System");
                    element4.addContent((Content)element3);
                    element3.setAttribute("Reservoir_Name", (String)object2[n2]);
                    object3 = reservoirElement.getReservoirOp();
                    if (object3 == null) continue;
                    ((ReservoirOp)object3).getOperationSets();
                    n = this.getResOpSetSelection(reservoirElement.getIndex());
                    object = ((ReservoirOp)object3).getOperationSet(n);
                    element3.setAttribute("Operation_Set", object._name);
                    element3.setAttribute("Operation_Set_Description", object._description);
                }
            }
            if (alternativeInputReport.b().get((Object)AltInputReportEnums.LOOKBACK).a()) {
                element2 = new org.jdom.Element("Lookback_tab");
                element5.addContent((Content)element2);
                object3 = this.getHindcastData();
                for (n2 = 0; n2 < ((Vector)object3).size(); ++n2) {
                    object2 = (HindcastData)((Vector)object3).get(n2);
                    if (object2 == null) continue;
                    element4 = new org.jdom.Element("Lookback");
                    element2.addContent((Content)element4);
                    element4.setAttribute("Location", this.c.getNameForKeyString(((HindcastData)object2).getObjectKey()));
                    ModelVariable modelVariable = RssModelVariableSet.getModelVariable(((HindcastData)object2)._varId);
                    element4.setAttribute("Variable", modelVariable.getName());
                    element4.setAttribute("Type", ((HindcastData)object2).getTypeName());
                    element4.setAttribute("Default_Values", ((HindcastData)object2).getValueString());
                }
            }
            if (alternativeInputReport.b().get((Object)AltInputReportEnums.TIMESERIES).a()) {
                element2 = new org.jdom.Element("TimeSeries_tab");
                element5.addContent((Content)element2);
                this.c.updateTSProxyList();
                object3 = (TSDataSet)this.getInputITSDataSet();
                object2 = this.c.getActiveTSProxies(null, 1);
                if (object2 != null) {
                    for (n = 0; n < ((Vector)object2).size(); ++n) {
                        object = (TSRecordProxy)((Vector)object2).elementAt(n);
                        if (object == null) continue;
                        element4 = new org.jdom.Element("TimeSeries");
                        element2.addContent((Content)element4);
                        String string = this.c.getNameForKeyString(object.getName());
                        element4.setAttribute("Name", string);
                        String string2 = RssModelVariableSet.getVariableName(object.getVariableId());
                        element4.setAttribute("Variable", string2);
                        string = object3.getTSRecord(object.getName(), object.getVariableId());
                        if (string == null) continue;
                        element4.setAttribute("File_Name", string.getDSSFilename());
                        element4.setAttribute("Pathname", string.getDSSPathname());
                        if (!alternativeInputReport.b().get((Object)AltInputReportEnums.TIMESERIES_DATA).a()) continue;
                        element3 = new org.jdom.Element("Time_Series_Data");
                        element4.addContent((Content)element3);
                        XMLUtilities.createArrayElements((org.jdom.Element)element3, (int[])string.getTimeArray());
                        XMLUtilities.createArrayElements((org.jdom.Element)element3, (double[])string.getTSArray());
                    }
                }
            }
            if (alternativeInputReport.b().get((Object)AltInputReportEnums.OBSERVED).a()) {
                element2 = new org.jdom.Element("Observed_Tab");
                element5.addContent((Content)element2);
                object3 = this.getObservedTSDataSet();
                if (object3 != null && (object2 = object3.getTSRecords()) != null) {
                    for (int i = 0; i < ((Vector)object2).size(); ++i) {
                        element4 = new org.jdom.Element("Observed");
                        element2.addContent((Content)element4);
                        TSRecord tSRecord = (TSRecord)((Vector)object2).get(i);
                        String string = this.c.getNameForKeyString(tSRecord.getName());
                        element4.setAttribute("Location", string);
                        element4.setAttribute("Variable", RssModelVariableSet.getVariableName(tSRecord.getVariableId()));
                        element4.setAttribute("DSSFile", tSRecord.getDSSFilename());
                        element4.setAttribute("Pathname", tSRecord.getDSSPathname());
                        if (!alternativeInputReport.b().get((Object)AltInputReportEnums.OBESERVED_TIMESERIES_DATA).a()) continue;
                        element3 = new org.jdom.Element("Observed_Time_Series_Data");
                        element4.addContent((Content)element3);
                        XMLUtilities.createArrayElements((org.jdom.Element)element3, (int[])tSRecord.getTimeArray());
                        XMLUtilities.createArrayElements((org.jdom.Element)element3, (double[])tSRecord.getTSArray());
                    }
                }
            }
            if (alternativeInputReport.b().get((Object)AltInputReportEnums.HOTSTART).a()) {
                element2 = new org.jdom.Element("Hotstart_Tab");
                element5.addContent((Content)element2);
                this.getHotstartOptions().outputReport(alternativeInputReport, element5);
            }
            if (alternativeInputReport.b().get((Object)AltInputReportEnums.DSS_OUTPUT).a()) {
                element2 = new org.jdom.Element("DSS_Output_Tab");
                element5.addContent((Content)element2);
                this.getWriteDSSOutputDataTable().outputReport(alternativeInputReport, element2);
            }
            for (int i = 0; i < this._pluginDataList.size(); ++i) {
                AltPluginData altPluginData = this._pluginDataList.get(i);
                if (!altPluginData.useCompute() || altPluginData instanceof MissingAltPluginData) continue;
                element2 = new org.jdom.Element(altPluginData.getType());
                element5.addContent((Content)element2);
                altPluginData.outputReport(alternativeInputReport, element2);
            }
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.ALT_GLOBAL_VARS).a()) {
            element2 = new org.jdom.Element("Global_Variables");
            element.addContent((Content)element2);
            this.getGlobalVariablesTable().outputReport(alternativeInputReport, element2);
        }
    }

    private String getComputingAltPluginType() {
        AltPluginData altPluginData = this.getComputingAltPluginData();
        if (altPluginData != null) {
            return altPluginData.getType();
        }
        return null;
    }

    private AltPluginData getComputingAltPluginData() {
        int n = this._pluginDataList.size();
        for (int i = 0; i < n; ++i) {
            AltPluginData altPluginData = this._pluginDataList.get(i);
            if (!altPluginData.useCompute()) continue;
            return altPluginData;
        }
        return null;
    }

    public ResSimComputeLauncher getComputeLauncher() {
        if (Boolean.getBoolean("ResSim.UseDefaultCompute")) {
            return new DefaultComputeLauncher();
        }
        Object object = this.getComputingAltPluginData();
        if (object != null && (object = object.getComputeLauncher()) != null) {
            return object;
        }
        return new DefaultComputeLauncher();
    }

    public void setSystem(RssSystem rssSystem) {
        this.c = rssSystem;
    }

    public void setTSDataSets(TSDataSet tSDataSet, TSDataSet tSDataSet2) {
        this.e = tSDataSet;
        this.f = tSDataSet2;
    }

    public void setReservoirYieldAnalysis(ReservoirYieldAnalysis reservoirYieldAnalysis) {
        this._reservoirYieldAnalysis = reservoirYieldAnalysis;
    }

    public void setReverseReservoirYieldAnalysis(ReverseReservoirYieldAnalysis reverseReservoirYieldAnalysis) {
        this._reverseReservoirYieldAnalysis = reverseReservoirYieldAnalysis;
    }

    public void setWaterAccountYieldAnalysis(WaterAccountYieldAnalysis waterAccountYieldAnalysis) {
        this._waterAccountYieldAnalysis = waterAccountYieldAnalysis;
    }

    public void setReverseWaterAccountYieldAnalysis(ReverseWaterAccountYieldAnalysis reverseWaterAccountYieldAnalysis) {
        this._reverseWaterAccountYieldAnalysis = reverseWaterAccountYieldAnalysis;
    }

    public void setReservoirStorageVsYieldAnalysis(ReservoirStorageVsYieldAnalysis reservoirStorageVsYieldAnalysis) {
        this._reservoirStorageVsYieldAnalysis = reservoirStorageVsYieldAnalysis;
    }

    public void setSelectedYieldAnalysis(YieldAnalysisType yieldAnalysisType) {
        this._selectedYieldAnalysis = yieldAnalysisType;
    }

    public ReservoirYieldAnalysis getReservoirYieldAnalysis() {
        return this._reservoirYieldAnalysis;
    }

    public ReverseReservoirYieldAnalysis getReverseReservoirYieldAnalysis() {
        return this._reverseReservoirYieldAnalysis;
    }

    public WaterAccountYieldAnalysis getWaterAccountYieldAnalysis() {
        return this._waterAccountYieldAnalysis;
    }

    public ReverseWaterAccountYieldAnalysis getReverseWaterAccountYieldAnalysis() {
        return this._reverseWaterAccountYieldAnalysis;
    }

    public ReservoirStorageVsYieldAnalysis getReservoirStorageVsYieldAnalysis() {
        return this._reservoirStorageVsYieldAnalysis;
    }

    public YieldAnalysisType getSelectedYieldAnalysis() {
        return this._selectedYieldAnalysis;
    }

    public YieldAnalysis getYieldAnalysis() {
        if (!this._useYieldAnalysis) {
            return null;
        }
        YieldAnalysis yieldAnalysis = null;
        switch (this._selectedYieldAnalysis) {
            case RESERVOIR: {
                yieldAnalysis = this._reservoirYieldAnalysis;
                break;
            }
            case WATER_ACCOUNT: {
                yieldAnalysis = this._waterAccountYieldAnalysis;
                break;
            }
            case REVERSE_RESERVOIR: {
                yieldAnalysis = this._reverseReservoirYieldAnalysis;
                break;
            }
            case REVERSE_WATER_ACCOUNT: {
                yieldAnalysis = this._reverseWaterAccountYieldAnalysis;
                break;
            }
            case RESERVOIR_STORAGE_VS_YIELD_ANALYSIS: {
                yieldAnalysis = this._reservoirStorageVsYieldAnalysis;
            }
        }
        return yieldAnalysis;
    }

    public void setWaterAccountSet(WaterAccountSet waterAccountSet) {
        if (waterAccountSet == null) {
            this._waterAccountSetIndex = Integer.MIN_VALUE;
            return;
        }
        this._waterAccountSetIndex = waterAccountSet.getIndex();
    }

    public WaterAccountSet getWaterAccountSet() {
        this.l = null;
        if (this._waterAccountSetIndex != Integer.MIN_VALUE) {
            this.l = this.getSystem().getWaterAccountSet(this._waterAccountSetIndex);
        }
        return this.l;
    }

    public void setWaterAccountSetIndex(int n) {
        this._waterAccountSetIndex = n;
    }

    public int getWaterAccountSetIndex() {
        return this._waterAccountSetIndex;
    }

    public List<String> getInputTSVariantNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this._inputTsVariants.size());
        for (int i = 0; i < this._inputTsVariants.size(); ++i) {
            arrayList.add(this._inputTsVariants.get(i).getName());
        }
        return arrayList;
    }

    public List<TsVariant> getInputTSVariants() {
        return this._inputTsVariants;
    }

    public TsVariant getTsVariant(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this._inputTsVariants.size(); ++i) {
            TsVariant tsVariant = this._inputTsVariants.get(i);
            if (!string.equals(tsVariant.getName())) continue;
            return tsVariant;
        }
        System.out.println("getTsVarient:no Variant for " + string + " found.");
        return null;
    }

    public Vector getActiveTSProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector();
        }
        if (this._pluginDataList != null) {
            for (AltPluginData altPluginData : this._pluginDataList) {
                vector = altPluginData.getActiveTSProxies(vector, n);
            }
        }
        return vector;
    }

    public AltWaterQualityOptions getWaterQualityOptions() {
        if (this._wqOpts == null) {
            this._wqOpts = new AltWaterQualityOptions();
        }
        return this._wqOpts;
    }

    public boolean hasWaterQualityOptions() {
        return this._wqOpts != null;
    }

    public String getObsWQDataPath() {
        return this._obsWQDataPath;
    }

    public void setObsWQDataSetPath(String string) {
        this._obsWQDataPath = string;
        this.setModified(true);
    }

    public TSDataSet getObsWQTSDataSet(TsVariant tsVariant) {
        if (tsVariant == null) {
            return this.getObsWQTSDataSet();
        }
        return this.getObsWQTSDataSet(tsVariant.getName(), tsVariant.hasNonDefaultInput());
    }

    public TSDataSet getObsWQTSDataSet(String string, boolean bl) {
        TSDataSet tSDataSet;
        if (string == null || string.isEmpty()) {
            return this.getObsWQTSDataSet();
        }
        Object object = this.getName().concat("-").concat(string);
        if (this.a != null && ((String)object).equals(this.a.getName())) {
            List<TSRecord> list = this.getObsWQTSRecordsFromManagers();
            RssAlt rssAlt = this;
            rssAlt.ensureWqTsDataIsUptoDate(rssAlt.a, list);
            return this.a;
        }
        System.out.println("getObsWQTSDataSet:loading Obs WQ TSDataSet for Variant " + string);
        String string2 = this.createInputDataPath(string, ".wqits", "Obs");
        Identifier identifier = new Identifier(string2);
        TSDataSet tSDataSet2 = null;
        try {
            tSDataSet2 = (TSDataSet)this._proxyList.loadManager(TSDataSet.class.getName(), identifier);
        }
        catch (RemoteException remoteException) {
            this.printErrorMessage("RssAlt.getObsWQTSData - RemoteException" + String.valueOf(remoteException));
            this.printMessage("Failed to load Obs WQ TSDataSet" + string2 + " for variant " + string);
        }
        if (tSDataSet2 == null) {
            System.out.println("getObsWQTSDataSet:creating Obs WQ TS Variant " + string2);
            tSDataSet2 = (TSDataSet)this._proxyList.newManager("rss", TSDataSet.class.getName());
            if (tSDataSet2 == null) {
                this.printErrorMessage("Failed to create ObsWQTSDataSet for Variant " + string);
                return null;
            }
            identifier.setName((String)object);
            tSDataSet2.setName((String)object);
            tSDataSet2.setDescription(this.getDescription() + " (Obs WQ TS Data Set for " + string + ")");
            tSDataSet = this.getObsWQTSDataSet();
            if (tSDataSet != null) {
                tSDataSet2.appendTSRecords((ITSDataSet)tSDataSet);
            }
            if (!this._proxyList.saveManagerAs("rss", (Manager)tSDataSet2, identifier)) {
                this.printErrorMessage("Failed to save ObsWQTSDataSet for Variant " + string + " to file " + string2);
            } else {
                object = (RmiWorkspace)this.getWorkspace().getRemote();
                try {
                    object.saveWorkspace(UserId.getUserId());
                }
                catch (RemoteException remoteException) {
                    System.out.println("getObsWQTSDataSet:error saving RmiWorkspace " + String.valueOf(remoteException));
                }
                TSDataSet tSDataSet3 = tSDataSet2;
                tSDataSet3.readFile(tSDataSet3.getIdentifier());
                this.a = tSDataSet2;
                object = this.getObsWQTSRecordsFromManagers();
                RssAlt rssAlt = this;
                rssAlt.ensureWqTsDataIsUptoDate(rssAlt.a, (List<TSRecord>)object);
            }
        } else {
            this.a = tSDataSet2;
            tSDataSet = this.getObsWQTSRecordsFromManagers();
            RssAlt rssAlt = this;
            rssAlt.ensureWqTsDataIsUptoDate(rssAlt.a, (List<TSRecord>)tSDataSet);
        }
        tSDataSet = new TsVariant(string);
        tSDataSet.setHasNonDefaultInput(bl);
        if (!this._inputTsVariants.contains(tSDataSet)) {
            this._inputTsVariants.add((TsVariant)tSDataSet);
            this.setModified(true);
            this.getProxyList().saveManager(UserId.getUserId(), (Manager)this);
        }
        return this.a;
    }

    private List<TSRecord> getObsWQTSRecordsFromManagers() {
        ArrayList<TSRecord> arrayList = new ArrayList<TSRecord>();
        ObsDatasetManager obsDatasetManager = this.getWaterQualityOptions().getObservedDataSetManager(this);
        if (obsDatasetManager != null) {
            arrayList.addAll(this.collectWQTSRecords(obsDatasetManager, this.a));
        }
        return arrayList;
    }

    public TSDataSet getObsWQTSDataSet() {
        this.a = new TSDataSet();
        this.a.setName("WQobs for " + this.getName());
        this.a.setWorkspace(this.getWorkspace());
        ObsDatasetManager obsDatasetManager = this.getWaterQualityOptions().getObservedDataSetManager(this);
        if (obsDatasetManager != null) {
            this.a.getTSRecords().addAll(this.collectWQTSRecords(obsDatasetManager, this.a));
        }
        return this.a;
    }

    public List<PairedDataContainer> getObsWQPairedData() {
        RssAlt rssAlt = this;
        return rssAlt.getObsWQPairedData(rssAlt.getRunTimeWindow());
    }

    public List<PairedDataContainer> getObsWQPairedData(RunTimeWindow runTimeWindow) {
        List<PairedDataContainer> list = new ArrayList<PairedDataContainer>();
        ObsDatasetManager obsDatasetManager = this.getWaterQualityOptions().getObservedDataSetManager(this);
        if (obsDatasetManager != null) {
            list = obsDatasetManager.getPairedData(this.getSystem(), runTimeWindow);
        }
        return list;
    }

    public PDCDataSet getObsWQPDCDataSet() {
        RssAlt rssAlt = this;
        return rssAlt.getObsWQPDCDataSet(rssAlt.getRunTimeWindow());
    }

    public PDCDataSet getObsWQPDCDataSet(RunTimeWindow runTimeWindow) {
        this._obsWQPDCData = new PDCDataSet();
        this._obsWQPDCData.setName("WQobs for " + this.getName());
        this._obsWQPDCData.setWorkspace(this.getWorkspace());
        ObsDatasetManager obsDatasetManager = this.getWaterQualityOptions().getObservedDataSetManager(this);
        if (obsDatasetManager != null && this.getSystem() != null) {
            this._obsWQPDCData.addAll(this.collectWQPDCRecords(obsDatasetManager, this._obsWQPDCData, runTimeWindow));
        }
        return this._obsWQPDCData;
    }

    public UserInterface setUserInterface(UserInterface userInterface) {
        UserInterface userInterface2 = super.setUserInterface(userInterface);
        if (this.n != null) {
            this.n.setUserInterface(userInterface);
        }
        if (this.e != null) {
            this.e.setUserInterface(userInterface);
        }
        if (this._inputGVData != null) {
            this._inputGVData.setUserInterface(userInterface);
        }
        return userInterface2;
    }

    public RemoteWrapper setUserInterface(RemoteWrapper remoteWrapper) {
        RemoteWrapper remoteWrapper2 = super.setUserInterface(remoteWrapper);
        if (this.n != null) {
            this.n.setUserInterface(remoteWrapper);
        }
        if (this.e != null) {
            this.e.setUserInterface(remoteWrapper);
        }
        if (this._inputGVData != null) {
            this._inputGVData.setUserInterface(remoteWrapper);
        }
        if (this.o != null) {
            this.o.setUserInterface(remoteWrapper);
        }
        if (this.c != null) {
            this.c.setUserInterface(remoteWrapper);
        }
        return remoteWrapper2;
    }

    public boolean deleteVariant(TsVariant object) {
        if (object == null) {
            return false;
        }
        TsVariant tsVariant = this.getTsVariant(object.getName());
        if (tsVariant == null) {
            ((FluentLogger.Api)b.atInfo()).log("Failed to find Variant " + object.getName() + " to delete.");
            return false;
        }
        object = this.getInputGVDataSet(tsVariant);
        TSDataSet tSDataSet = this.getInputTSDataSet(tsVariant);
        TSDataSet tSDataSet2 = this.getInputWQTSDataSet(tsVariant);
        PDCDataSet pDCDataSet = this.getInputWQPDCDataSet(tsVariant);
        if (this._inputTsVariants.remove((Object)tsVariant)) {
            this.deleteManager((Manager)object);
            this.deleteManager((Manager)tSDataSet);
            this.deleteManager((Manager)tSDataSet2);
            this.deleteManager(pDCDataSet);
            this.setModified(true);
            return true;
        }
        return false;
    }

    private void deleteManager(Manager manager) {
        if (manager != null) {
            manager = manager.getIdentifier();
            this._proxyList.deleteManager((Identifier)manager);
            try {
                if (this.getFileManager().fileExists(manager.getPath())) {
                    this.getFileManager().deleteFile(manager.getPath());
                }
                return;
            }
            catch (RemoteException remoteException) {}
        }
    }

    public boolean hasbeenAccepted() {
        if (this.hasWaterQualityOptions()) {
            AltWaterQualityOptions altWaterQualityOptions = this.getWaterQualityOptions();
            return altWaterQualityOptions.deleteManagers(this);
        }
        return true;
    }

    public List<String> prepareForExtract(RunTimeWindow runTimeWindow, RssAlt rssAlt, DSSManager dSSManager) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = this.getWaterQualityOptions().getWQTSDataProviders(this);
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (WQTSDataProvider)object.next();
            object2 = object2.prepareForExtract(runTimeWindow, rssAlt, dSSManager);
            arrayList.addAll((Collection<String>)object2);
        }
        return arrayList;
    }

    public String getInputMetDataDSSFileName() {
        String string = this.getName();
        int n = string.lastIndexOf(":");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return Paths.get(this.getWorkspacePath(), new String[0]).resolve("rss").resolve(string + "_" + MetData.class.getSimpleName() + ".dss").toString();
    }

    static {
        System.loadLibrary("javaHeclib");
    }
}

