/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.HecTime;
import hec.lang.NamedType;
import hec.model.Conditional;
import hec.model.ConditionalBlock;
import hec.model.ConditionalItem;
import hec.model.ConditionalOperator;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.RssRmiWorkspace;
import hec.rss.model.ConditionalBlockRef;
import hec.rss.model.Element;
import hec.rss.model.ElementOp;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssConditionalBlock;
import hec.rss.model.RssConditionalItem;
import hec.rss.model.RssSystem;
import hec.rss.model.StorageZoneRules;
import hec.rss.model.ZoneObject;
import hec.rss.model.ZoneObjectParent;
import java.util.ArrayList;
import java.util.List;

public class RssConditional
extends Conditional
implements ZoneObjectParent {
    public RssConditional() {
    }

    public RssConditional(int n) {
        super(n);
    }

    public boolean initializeCompute(RunTimeWindow object) {
        if (!super.initializeCompute((RunTimeWindow)object)) {
            return false;
        }
        object = this.getElementOp();
        if (object == null) {
            return true;
        }
        object = object.getOperationsElement();
        object = object.getSystem();
        try {
            object = ((RssRmiWorkspace)((Object)object.getWorkspace().getRemote())).getStartOfWaterYearString();
            object = new HecTime((String)object + "1901", "2400");
            ConditionalOperator.setStartOfYear((HecTime)object);
        }
        catch (Exception exception) {}
        return true;
    }

    public void getReferencedStateVariables(List list) {
        Object object;
        int n;
        int n2 = this._conditionalList.size();
        for (n = 0; n < n2; ++n) {
            object = (ConditionalItem)this._conditionalList.get(n);
            if (!(object instanceof RssConditionalItem)) continue;
            ((RssConditionalItem)((Object)object)).getReferencedStateVariables(list);
        }
        n2 = this._rulesList.size();
        for (n = 0; n < n2; ++n) {
            object = this._rulesList.get(n);
            if (object instanceof OpRuleRef) {
                ((OpRuleRef)object).getReferencedStateVariables(list);
                continue;
            }
            if (object instanceof RssConditionalBlock) {
                ((RssConditionalBlock)((Object)object)).getReferencedStateVariables(list);
                continue;
            }
            if (!(object instanceof ConditionalBlockRef)) continue;
            object = (ConditionalBlockRef)object;
            if ((object = (RssConditionalBlock)object.getConditionalBlock()) == null) continue;
            object.getReferencedStateVariables(list);
        }
    }

    public RssConditional clone() {
        RssConditional rssConditional = (RssConditional)super.clone();
        int n = rssConditional._rulesList.size();
        for (int i = 0; i < n; ++i) {
            Object object = rssConditional._rulesList.get(i);
            if (!(object instanceof ZoneObject)) continue;
            object = (ZoneObject)object;
            object.setParent(rssConditional);
        }
        return rssConditional;
    }

    public void updateTSProxyList() {
        Object object;
        int n;
        int n2 = this._conditionalList.size();
        for (n = 0; n < n2; ++n) {
            object = this._conditionalList.get(n);
            if (object instanceof RssConditionalItem) {
                ((RssConditionalItem)((Object)object)).updateTSProxyList();
                continue;
            }
            if (object instanceof RssConditionalBlock) {
                ((RssConditionalBlock)((Object)object)).updateTSProxyList();
                continue;
            }
            if (!(object instanceof ConditionalBlockRef)) continue;
            object = (ConditionalBlockRef)object;
            if ((object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock()) == null) continue;
            ((RssConditionalBlock)((Object)object)).updateTSProxyList();
        }
        n2 = this._rulesList.size();
        for (n = 0; n < n2; ++n) {
            object = this._rulesList.get(n);
            if (object instanceof RssConditionalBlock) {
                ((RssConditionalBlock)((Object)object)).updateTSProxyList();
                continue;
            }
            if (!(object instanceof ConditionalBlockRef)) continue;
            object = (ConditionalBlockRef)object;
            if ((object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock()) == null) continue;
            ((RssConditionalBlock)((Object)object)).updateTSProxyList();
        }
    }

    public void getActiveTSRecordProxies(List list, int n) {
        Object object;
        int n2;
        int n3 = this._conditionalList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = this._conditionalList.get(n2);
            if (object instanceof RssConditionalItem) {
                ((RssConditionalItem)((Object)object)).getActiveTSRecordProxies(list, n);
                continue;
            }
            if (object instanceof RssConditionalBlock) {
                ((RssConditionalBlock)((Object)object)).getActiveTSRecordProxies(list, n);
                continue;
            }
            if (!(object instanceof ConditionalBlockRef)) continue;
            object = (ConditionalBlockRef)object;
            if ((object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock()) == null) continue;
            ((RssConditionalBlock)((Object)object)).getActiveTSRecordProxies(list, n);
        }
        n3 = this._rulesList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = this._rulesList.get(n2);
            if (!(object instanceof RssConditionalBlock)) continue;
            ((RssConditionalBlock)((Object)object)).getActiveTSRecordProxies(list, n);
        }
    }

    public void getElementDependencies(RssSystem rssSystem, Element element, List<Element> list) {
        Object object;
        int n;
        int n2 = this._conditionalList.size();
        for (n = 0; n < n2; ++n) {
            object = this._conditionalList.get(n);
            if (object instanceof RssConditionalItem) {
                ((RssConditionalItem)((Object)object)).getElementDependencies(rssSystem, element, list);
                continue;
            }
            if (object instanceof RssConditionalBlock) {
                ((RssConditionalBlock)((Object)object)).getElementDependencies(rssSystem, element, list);
                continue;
            }
            if (!(object instanceof ConditionalBlockRef)) continue;
            object = (ConditionalBlockRef)object;
            if ((object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock()) == null) continue;
            ((RssConditionalBlock)((Object)object)).getElementDependencies(rssSystem, element, list);
        }
        n2 = this._rulesList.size();
        for (n = 0; n < n2; ++n) {
            object = this._rulesList.get(n);
            if (!(object instanceof RssConditionalBlock)) continue;
            ((RssConditionalBlock)((Object)object)).getElementDependencies(rssSystem, element, list);
        }
    }

    public void updateParentData() {
        super.updateParentData();
        ElementOp elementOp = this.getElementOp();
        if (elementOp == null) {
            return;
        }
        for (int i = 0; i < this._rulesList.size(); ++i) {
            OpRuleRef opRuleRef;
            OpSet opSet;
            if (!(this._rulesList.get(i) instanceof OpRuleRef) || (opSet = (opRuleRef = (OpRuleRef)this._rulesList.get(i)).getOpSet()) == null) continue;
            opSet = elementOp.getOperationSet(opSet.getIndex());
            opRuleRef.setOpSet(opSet);
        }
    }

    @Override
    public ElementOp getElementOp() {
        Object object = this.getParent();
        if (object == null) {
            return null;
        }
        object = object.getParent();
        while (!(object instanceof ElementOp)) {
            if ((object = ((Conditional)object).getParent()) == null) {
                return null;
            }
            object = object.getParent();
        }
        return (ElementOp)object;
    }

    public OpRuleRef removeRule(OpRule opRule) {
        if (opRule == null) {
            return null;
        }
        for (int i = 0; i < this._rulesList.size(); ++i) {
            OpRuleRef opRuleRef;
            OpRule opRule2;
            if (!(this._rulesList.get(i) instanceof OpRuleRef) || (opRule2 = (opRuleRef = (OpRuleRef)this._rulesList.get(i)).getRule()) == null || opRule2 != opRule && (!opRule2.getName().equals(opRule.getName()) || !opRule2.getClass().equals(opRule.getClass()))) continue;
            this._rulesList.remove(opRuleRef);
            return opRuleRef;
        }
        return null;
    }

    public OpRuleRef removeRule(OpRuleRef opRuleRef) {
        for (int i = 0; i < this._rulesList.size(); ++i) {
            OpRuleRef opRuleRef2;
            if (!(this._rulesList.get(i) instanceof OpRuleRef) || (opRuleRef2 = (OpRuleRef)this._rulesList.get(i)) == null || opRuleRef2 != opRuleRef) continue;
            this._rulesList.remove(opRuleRef2);
            return opRuleRef2;
        }
        return null;
    }

    public List getActiveRules(RunTimeStep runTimeStep, List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<OpRule>();
        }
        int n = this._rulesList.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._rulesList.get(i);
            if (object instanceof OpRuleRef) {
                object = (OpRuleRef)object;
                OpRule opRule = ((OpRuleRef)object).getRule();
                if (((OpRuleRef)object).isDisabled() || opRule == null || arrayList.contains(opRule)) continue;
                arrayList.add(opRule);
                continue;
            }
            if (object instanceof RssConditionalBlock) {
                if ((object = (RssConditionalBlock)((Object)object)) == null) continue;
                ((RssConditionalBlock)((Object)object)).getActiveRules(runTimeStep, arrayList);
                continue;
            }
            if (!(object instanceof ConditionalBlockRef)) continue;
            object = (ConditionalBlockRef)object;
            if ((object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock()) == null) continue;
            ((RssConditionalBlock)((Object)object)).getActiveRules(runTimeStep, arrayList);
        }
        return arrayList;
    }

    public List getPrimaryRules(List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        int n = this._rulesList.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._rulesList.get(i);
            if (!(object instanceof OpRuleRef)) continue;
            object = (OpRuleRef)object;
            if ((object = ((OpRuleRef)object).getRule()) == null || arrayList.contains(object)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public List getRules(List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        int n = this._rulesList.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._rulesList.get(i);
            if (object instanceof OpRuleRef) {
                object = (OpRuleRef)object;
                if ((object = ((OpRuleRef)object).getRule()) == null || arrayList.contains(object)) continue;
                arrayList.add(object);
                continue;
            }
            if (object instanceof RssConditionalBlock) {
                if ((object = (RssConditionalBlock)((Object)object)) == null) continue;
                ((RssConditionalBlock)((Object)object)).getRules(arrayList);
                continue;
            }
            if (!(object instanceof ConditionalBlockRef)) continue;
            object = (ConditionalBlockRef)object;
            if ((object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock()) == null) continue;
            ((RssConditionalBlock)((Object)object)).getRules(arrayList);
        }
        return arrayList;
    }

    public List<OpRuleRef> getRuleRefs(List<OpRuleRef> list) {
        if (list == null) {
            list = new ArrayList<OpRuleRef>();
        }
        int n = this._rulesList.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._rulesList.get(i);
            if (object instanceof OpRuleRef) {
                if ((object = (OpRuleRef)object) == null || list.contains(object)) continue;
                list.add((OpRuleRef)object);
                continue;
            }
            if (!(object instanceof RssConditionalBlock) || (object = (RssConditionalBlock)((Object)object)) == null) continue;
            ((RssConditionalBlock)((Object)object)).getRuleRefs(list);
        }
        return list;
    }

    public List getAllRuleRefs(int n, int n2, List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        int n3 = this._rulesList.size();
        for (int i = 0; i < n3; ++i) {
            Object object = this._rulesList.get(i);
            if (object instanceof OpRuleRef) {
                if (((OpRuleRef)(object = (OpRuleRef)object)).getOpControllerIndex() != n || ((OpRuleRef)object).getRuleIndex() != n2) continue;
                arrayList.add(object);
                continue;
            }
            if (object instanceof RssConditionalBlock) {
                object = (RssConditionalBlock)((Object)object);
                ((RssConditionalBlock)((Object)object)).getAllRuleRefs(n, n2, arrayList);
                continue;
            }
            if (!(object instanceof ConditionalBlockRef)) continue;
            object = (ConditionalBlockRef)object;
            if ((object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock()) == null) continue;
            ((RssConditionalBlock)((Object)object)).getAllRuleRefs(n, n2, arrayList);
        }
        return arrayList;
    }

    public List getControllerRules(int n, List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        int n2 = this._rulesList.size();
        for (int i = 0; i < n2; ++i) {
            Object object = this._rulesList.get(i);
            if (object instanceof OpRuleRef) {
                if (((OpRuleRef)(object = (OpRuleRef)object)).getOpControllerIndex() != n || (object = ((OpRuleRef)object).getRule()) == null || arrayList.contains(object)) continue;
                arrayList.add(object);
                continue;
            }
            if (object instanceof RssConditionalBlock) {
                object = (RssConditionalBlock)((Object)object);
                ((RssConditionalBlock)((Object)object)).getControllerRules(n, arrayList);
                continue;
            }
            if (!(object instanceof ConditionalBlockRef)) continue;
            object = (ConditionalBlockRef)object;
            if ((object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock()) == null) continue;
            ((RssConditionalBlock)((Object)object)).getControllerRules(n, arrayList);
        }
        return arrayList;
    }

    public List<RssConditionalBlock> getConditionalBlocks(List<RssConditionalBlock> list) {
        if (list == null) {
            list = new ArrayList<RssConditionalBlock>();
        }
        int n = this._rulesList.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._rulesList.get(i);
            if (object instanceof RssConditionalBlock) {
                object = (RssConditionalBlock)((Object)object);
                list.add((RssConditionalBlock)((Object)object));
                continue;
            }
            if (!(object instanceof ConditionalBlockRef)) continue;
            object = (ConditionalBlockRef)object;
            if ((object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock()) == null) continue;
            list.add((RssConditionalBlock)((Object)object));
        }
        return list;
    }

    List<ConditionalBlockRef> getConditionalBlockRefs(List<ConditionalBlockRef> list) {
        if (list == null) {
            list = new ArrayList<ConditionalBlockRef>();
        }
        int n = this._rulesList.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._rulesList.get(i);
            if (!(object instanceof ConditionalBlockRef)) continue;
            object = (ConditionalBlockRef)object;
            list.add((ConditionalBlockRef)object);
        }
        return list;
    }

    public void removeControllerRefs(int n) {
        int n2 = this._rulesList.size();
        --n2;
        while (n2 >= 0) {
            Object object = this._rulesList.get(n2);
            if (object instanceof OpRuleRef) {
                if (((OpRuleRef)(object = (OpRuleRef)object)).getOpControllerIndex() == n) {
                    this._rulesList.remove(n2);
                }
            } else if (object instanceof RssConditionalBlock) {
                object = (RssConditionalBlock)((Object)object);
                ((RssConditionalBlock)((Object)object)).removeControllerRefs(n);
            } else if (object instanceof ConditionalBlockRef) {
                object = (ConditionalBlockRef)object;
                if ((object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock()) != null) {
                    ((RssConditionalBlock)((Object)object)).removeControllerRefs(n);
                }
            }
            --n2;
        }
    }

    public void removeAllRuleRefs(int n, int n2) {
        int n3 = this._rulesList.size();
        --n3;
        while (n3 >= 0) {
            Object object = this._rulesList.get(n3);
            if (object instanceof OpRuleRef) {
                if (((OpRuleRef)(object = (OpRuleRef)object)).getOpControllerIndex() == n && ((OpRuleRef)object).getRuleIndex() == n2) {
                    this._rulesList.remove(n3);
                }
            } else if (object instanceof RssConditionalBlock) {
                object = (RssConditionalBlock)((Object)object);
                ((RssConditionalBlock)((Object)object)).removeAllRuleRefs(n, n2);
            } else if (object instanceof ConditionalBlockRef) {
                object = (ConditionalBlockRef)object;
                if ((object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock()) != null) {
                    ((RssConditionalBlock)((Object)object)).removeAllRuleRefs(n, n2);
                }
            }
            --n3;
        }
    }

    public void removeAllConditionalBlockRefs(int n) {
        int n2 = this._rulesList.size();
        --n2;
        while (n2 >= 0) {
            Object object = this._rulesList.get(n2);
            if (object instanceof RssConditionalBlock) {
                if ((object = (RssConditionalBlock)((Object)object)).getIndex() == n) {
                    this._rulesList.remove(n2);
                } else {
                    ((RssConditionalBlock)((Object)object)).removeAllConditionalBlockRefs(n);
                }
            } else if (object instanceof ConditionalBlockRef) {
                if ((object = (ConditionalBlockRef)object).getIndex() == n) {
                    this._rulesList.remove(n2);
                } else if ((object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock()) != null) {
                    ((RssConditionalBlock)((Object)object)).removeAllConditionalBlockRefs(n);
                }
            }
            --n2;
        }
    }

    public boolean removeCondtionalObject(Object object) {
        boolean bl = super.removeCondtionalObject(object);
        if (object instanceof OpRule) {
            this.removeRule((OpRule)object);
        }
        return bl;
    }

    public OpRuleRef addRule(OpRule opRule, StorageZoneRules storageZoneRules) {
        int n = 0;
        for (int i = 0; i < this._rulesList.size(); ++i) {
            int n2;
            ZoneObject zoneObject;
            if (!(this._rulesList.get(i) instanceof ZoneObject) || (zoneObject = (ZoneObject)this._rulesList.get(i)) == null || n > (n2 = (int)Math.ceil(zoneObject.getPriority()))) continue;
            n = n2 + 1;
        }
        return this.addRule(opRule, n, storageZoneRules);
    }

    public OpRuleRef addRule(OpRule opRule, int n, StorageZoneRules storageZoneRules) {
        if (opRule == null) {
            return null;
        }
        for (int i = 0; i < this._rulesList.size(); ++i) {
            OpRuleRef opRuleRef;
            OpRule opRule2;
            if (!(this._rulesList.get(i) instanceof OpRuleRef) || (opRule2 = (opRuleRef = (OpRuleRef)this._rulesList.get(i)).getRule()) == null || opRule2.getIndex() != opRule.getIndex()) continue;
            return opRuleRef;
        }
        OpRuleRef opRuleRef = new OpRuleRef(this, opRule);
        this._rulesList.add(opRuleRef);
        this.setModified(true);
        return opRuleRef;
    }

    public OpRuleRef addRule(OpRule opRule) {
        OpRuleRef opRuleRef;
        if (opRule == null) {
            return null;
        }
        for (int i = 0; i < this._rulesList.size(); ++i) {
            OpRule opRule2;
            if (!(this._rulesList.get(i) instanceof OpRuleRef) || (opRule2 = (opRuleRef = (OpRuleRef)this._rulesList.get(i)).getRule()) == null || opRule2 != opRule) continue;
            return opRuleRef;
        }
        opRuleRef = new OpRuleRef(this, opRule);
        this._rulesList.add(opRuleRef);
        this.setModified(true);
        return opRuleRef;
    }

    public void addConditionalBlock(ConditionalBlockRef conditionalBlockRef) {
        if (conditionalBlockRef == null) {
            return;
        }
        conditionalBlockRef.setParent(this);
        this._rulesList.add(conditionalBlockRef);
        this.setModified(true);
    }

    protected void printErrorMessage(String string) {
        NamedType namedType = this.getParentElement();
        if (namedType instanceof ReservoirElement) {
            ((ReservoirElement)namedType).getSystem().printErrorMessage(string);
            return;
        }
        super.printErrorMessage(string);
    }

    public NamedType getParentElement() {
        Object object = this._conditionalBlock.getParent();
        while (object instanceof Conditional) {
            object = ((Conditional)object).getParent();
        }
        while (object instanceof RssConditionalBlock) {
            object = ((RssConditionalBlock)((Object)object)).getParent();
        }
        if (object instanceof ElementOp) {
            return (NamedType)((ElementOp)object).getOperationsElement();
        }
        return null;
    }

    public boolean updateConditionaBlockWithRef(ConditionalBlock conditionalBlock, ConditionalBlockRef conditionalBlockRef) {
        if (conditionalBlock == null || conditionalBlockRef == null) {
            return false;
        }
        for (int i = 0; i < this._rulesList.size(); ++i) {
            if (this._rulesList.get(i) != conditionalBlock) continue;
            this._rulesList.set(i, conditionalBlockRef);
            return true;
        }
        return false;
    }
}

