/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.heclib.util.intContainer;
import hec.model.ModelVariable;
import hec.model.TSLocation;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssSystem;
import java.util.Hashtable;

public class RssModelVariableSet
implements RssModelVariableConstants {
    static final String EMPTYSTR = "";
    static final String DASH = "-";
    static final int NAME = 0;
    static final int FULLNAME = 1;
    static final int PARENTNAME = 2;
    static final int PARENTFULLNAME = 3;
    static final int TOPPARENTNAME = 4;
    static final Integer FLOWPARAM = Parameter.PARAMID_FLOW;
    static final Integer STAGEPARAM = Parameter.PARAMID_STAGE;
    static final Integer ELEVPARAM = Parameter.PARAMID_ELEV;
    static final Integer STORPARAM = Parameter.PARAMID_STOR;
    static final Integer AREAPARAM = Parameter.PARAMID_AREARESERVOIR;
    static final String JUNCTION_STR = "Junction";
    static final String REACH_STR = "Reach";
    static final String DIVERSION_STR = "Diversion";
    static final String DIVERTEDOUTLET_STR = "Diverted Outlet";
    static final String RESERVOIR_STR = "Reservoir";
    static final String NODE_STR = "Node";
    static final String CONTROLLER_STR = "Operation";
    static final String RULE_STR = "Operation";
    static final String STATEVAR_STR = "State Variable";
    static final String WATER_ACCOUNT_STR = "Water Account";
    static final String[] GRP_NAME = new String[]{"Junction", "Reach", "Diversion", "Reservoir"};
    static final Hashtable _variableTable = new Hashtable();
    static volatile ThreadLocal<intContainer> _intContainers = new ThreadLocal();

    public static ModelVariable getModelVariable(int n) {
        intContainer intContainer2 = RssModelVariableSet.getIntContainer();
        RssModelVariableSet.getIntContainer().value = n;
        return (ModelVariable)_variableTable.get(intContainer2);
    }

    public static void addModelVariable(ModelVariable modelVariable) {
        if (modelVariable == null) {
            return;
        }
        intContainer intContainer2 = RssModelVariableSet.getIntContainer();
        RssModelVariableSet.getIntContainer().value = modelVariable.getType();
        _variableTable.put(intContainer2, modelVariable);
    }

    private static intContainer getIntContainer() {
        intContainer intContainer2 = _intContainers.get();
        if (intContainer2 == null) {
            ThreadLocal<intContainer> threadLocal = _intContainers;
            synchronized (threadLocal) {
                intContainer2 = new intContainer();
                _intContainers.set(intContainer2);
            }
        }
        return intContainer2;
    }

    public static TSRecordProxy newTSRecordProxy(RssSystem object, TSLocation tSLocation, int n) {
        if (object == null || tSLocation == null) {
            return null;
        }
        intContainer intContainer2 = RssModelVariableSet.getIntContainer();
        RssModelVariableSet.getIntContainer().value = n;
        if ((intContainer2 = (ModelVariable)_variableTable.get(intContainer2)) == null) {
            return null;
        }
        TSRecordProxy tSRecordProxy = object.newTSRecordProxy(tSLocation);
        tSRecordProxy.setVariableId(n);
        object = ((RssSystem)object).getKeyStringForObject(tSLocation);
        tSRecordProxy.setName((String)object);
        if (intContainer2.getParamId() == -1) {
            tSRecordProxy.setParamName(intContainer2.getNameQualifier());
        } else {
            object = Parameter.getParamString((int)intContainer2.getParamId());
            if (intContainer2.getNameQualifier() != null) {
                object = (String)object + DASH + intContainer2.getNameQualifier();
            }
            tSRecordProxy.setParamName((String)object);
        }
        if (intContainer2.getDataSetId() == 0) {
            tSRecordProxy.setInput(false);
        } else {
            tSRecordProxy.setInput(true);
        }
        return tSRecordProxy;
    }

    public static String getVariableName(int n) {
        intContainer intContainer2 = RssModelVariableSet.getIntContainer();
        RssModelVariableSet.getIntContainer().value = n;
        ModelVariable modelVariable = (ModelVariable)_variableTable.get(intContainer2);
        if (modelVariable == null) {
            return EMPTYSTR;
        }
        return modelVariable.getName();
    }

    public static String getParamName(int n) {
        Object object = RssModelVariableSet.getIntContainer();
        RssModelVariableSet.getIntContainer().value = n;
        ModelVariable modelVariable = (ModelVariable)_variableTable.get(object);
        if (modelVariable == null) {
            return EMPTYSTR;
        }
        if (modelVariable.getParamId() == -1) {
            object = modelVariable.getNameQualifier();
        } else {
            object = Parameter.getParamString((int)modelVariable.getParamId());
            if (modelVariable.getNameQualifier() != null) {
                object = (String)object + DASH + modelVariable.getNameQualifier();
            }
        }
        return object;
    }

    public static String getTSRecordProxyName(RssSystem object, TSLocation tSLocation, int n) {
        intContainer intContainer2 = RssModelVariableSet.getIntContainer();
        RssModelVariableSet.getIntContainer().value = n;
        ModelVariable modelVariable = (ModelVariable)_variableTable.get(intContainer2);
        if (modelVariable == null) {
            return null;
        }
        object = ((RssSystem)object).getKeyStringForObject(tSLocation);
        return object;
    }

    public static String getTSRecordProxyParamName(RssSystem rssSystem, TSLocation object, int n) {
        rssSystem = RssModelVariableSet.getIntContainer();
        RssModelVariableSet.getIntContainer().value = n;
        if ((rssSystem = (ModelVariable)_variableTable.get(rssSystem)) == null) {
            return null;
        }
        if (rssSystem.getParamId() == -1) {
            object = rssSystem.getNameQualifier();
        } else {
            object = Parameter.getParamString((int)rssSystem.getParamId());
            if (rssSystem.getNameQualifier() != null) {
                object = (String)object + DASH + rssSystem.getNameQualifier();
            }
        }
        return object;
    }

    public static int getTSRecordProxyDataSet(RssSystem rssSystem, TSLocation tSLocation, int n) {
        rssSystem = RssModelVariableSet.getIntContainer();
        RssModelVariableSet.getIntContainer().value = n;
        if ((rssSystem = (ModelVariable)_variableTable.get(rssSystem)) == null) {
            return 0;
        }
        return rssSystem.getDataSetId();
    }

    static {
        _variableTable.put(new intContainer(0), new ModelVariable(0, NODE_STR, "Flow", null, Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(1), new ModelVariable(1, NODE_STR, "Lookback Flow", null, Parameter.PARAMID_FLOW, 1));
        _variableTable.put(new intContainer(2), new ModelVariable(2, NODE_STR, "Stage", null, Parameter.PARAMID_STAGE, 0));
        _variableTable.put(new intContainer(3), new ModelVariable(2, NODE_STR, "Lookback Stage", null, Parameter.PARAMID_STAGE, 1));
        _variableTable.put(new intContainer(4), new ModelVariable(4, NODE_STR, "Known Flow", null, Parameter.PARAMID_FLOW, 1));
        _variableTable.put(new intContainer(6), new ModelVariable(6, RESERVOIR_STR, "Holdout", "HOLDOUT", Parameter.PARAMID_FLOW, 1));
        _variableTable.put(new intContainer(7), new ModelVariable(7, RESERVOIR_STR, "Guide Curve Release", "GC-RELEASE", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(10), new ModelVariable(10, RESERVOIR_STR, "Elevation", null, Parameter.PARAMID_ELEV, 0));
        _variableTable.put(new intContainer(23), new ModelVariable(23, RESERVOIR_STR, "Elevation-Est", "EST", Parameter.PARAMID_ELEV, 0));
        _variableTable.put(new intContainer(11), new ModelVariable(11, RESERVOIR_STR, "Storage", null, Parameter.PARAMID_STOR, 0));
        _variableTable.put(new intContainer(12), new ModelVariable(12, RESERVOIR_STR, "Inflow", "IN", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(13), new ModelVariable(13, RESERVOIR_STR, "Net Inflow", "IN NET", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(14), new ModelVariable(14, RESERVOIR_STR, "Lookback Elevation", null, Parameter.PARAMID_ELEV, 1));
        _variableTable.put(new intContainer(15), new ModelVariable(15, RESERVOIR_STR, "Lookback Storage", null, Parameter.PARAMID_STOR, 1));
        _variableTable.put(new intContainer(16), new ModelVariable(16, RESERVOIR_STR, "Flow Holdout", "HOLDOUT", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(17), new ModelVariable(17, RESERVOIR_STR, "Evap Flow", "EVAP", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(18), new ModelVariable(18, RESERVOIR_STR, "Input Evap", null, Parameter.PARAMID_EVAP, 1));
        _variableTable.put(new intContainer(19), new ModelVariable(19, RESERVOIR_STR, "Seepage Flow", "SEEPAGE", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(20), new ModelVariable(20, RESERVOIR_STR, "Area", RESERVOIR_STR, Parameter.PARAMID_AREARESERVOIR, 0));
        _variableTable.put(new intContainer(21), new ModelVariable(21, RESERVOIR_STR, "Outflow", "OUT", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(24), new ModelVariable(21, RESERVOIR_STR, "Outflow-Est", "EST", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(22), new ModelVariable(22, RESERVOIR_STR, "Elev ROC", "ELEV", Parameter.PARAMID_RATE_OF_RISE, 0));
        _variableTable.put(new intContainer(201), new ModelVariable(21, RESERVOIR_STR, "FlowIntoStor", "Q2S", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(25), new ModelVariable(25, RESERVOIR_STR, "Leakage", "LEAKAGE", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(26), new ModelVariable(26, RESERVOIR_STR, "Total Outflow", "OUT TOTAL", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(31), new ModelVariable(31, RESERVOIR_STR, "Gate Opening", "GATE OPENING", Parameter.PARAMID_ELEV, 0));
        _variableTable.put(new intContainer(32), new ModelVariable(32, RESERVOIR_STR, "Gate Opening", "GATE OPENING", Parameter.PARAMID_PERCENT, 0));
        _variableTable.put(new intContainer(30), new ModelVariable(30, RESERVOIR_STR, "Tailwater Elev", "TAILWATER", Parameter.PARAMID_ELEV, 0));
        _variableTable.put(new intContainer(143), new ModelVariable(143, RESERVOIR_STR, "Forebay Elev", "FOREBAY", Parameter.PARAMID_ELEV, 0));
        _variableTable.put(new intContainer(144), new ModelVariable(144, RESERVOIR_STR, "Forebay Headloss", "FOREBAY HEADLOSS", Parameter.PARAMID_ELEV, 0));
        _variableTable.put(new intContainer(35), new ModelVariable(35, RESERVOIR_STR, "Release", "OUT TOTAL", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(40), new ModelVariable(40, RESERVOIR_STR, "Release", "RELEASE", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(41), new ModelVariable(41, RESERVOIR_STR, "Lookback Release", "RELEASE", Parameter.PARAMID_FLOW, 1));
        _variableTable.put(new intContainer(42), new ModelVariable(42, DIVERSION_STR, DIVERSION_STR, "DIVERSION", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(43), new ModelVariable(43, RESERVOIR_STR, "Lookback Diversion", "DIVERSION", Parameter.PARAMID_FLOW, 1));
        _variableTable.put(new intContainer(47), new ModelVariable(47, "Operation", "Flow Setting", "SETTING", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(45), new ModelVariable(45, RESERVOIR_STR, "Uncontrolled", null, Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(50), new ModelVariable(50, RESERVOIR_STR, "Generation Efficiency", "EFFICIENCY", -1, 0));
        _variableTable.put(new intContainer(51), new ModelVariable(51, RESERVOIR_STR, "Power Head", "HEAD POWER", Parameter.PARAMID_ELEV, 0));
        _variableTable.put(new intContainer(52), new ModelVariable(52, RESERVOIR_STR, "Hydraulic Losses", "HYD LOSS", Parameter.PARAMID_ELEV, 0));
        _variableTable.put(new intContainer(53), new ModelVariable(53, RESERVOIR_STR, "Energy Generated per Time Step", null, Parameter.PARAMID_ENERGY, 0));
        _variableTable.put(new intContainer(54), new ModelVariable(54, RESERVOIR_STR, "Power Generated", null, Parameter.PARAMID_POWER, 0));
        _variableTable.put(new intContainer(55), new ModelVariable(55, RESERVOIR_STR, "Plant Factor", "PLANTFACTOR", -1, 0));
        _variableTable.put(new intContainer(56), new ModelVariable(56, RESERVOIR_STR, "Flow Power", "QPOWER", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(57), new ModelVariable(57, RESERVOIR_STR, "Power Capability", "CAPABILITY", Parameter.PARAMID_POWER, 0));
        _variableTable.put(new intContainer(166), new ModelVariable(166, RESERVOIR_STR, "Power Capacity", "CAPACITY", Parameter.PARAMID_POWER, 0));
        _variableTable.put(new intContainer(58), new ModelVariable(58, RESERVOIR_STR, "Power Required", "REQUIRED", Parameter.PARAMID_POWER, 0));
        _variableTable.put(new intContainer(155), new ModelVariable(155, RESERVOIR_STR, "Energy Pattern", "PATTERN", Parameter.PARAMID_ENERGY, 0));
        _variableTable.put(new intContainer(157), new ModelVariable(157, RESERVOIR_STR, "Period Energy Required", "PER-REQD", Parameter.PARAMID_ENERGY, 0));
        _variableTable.put(new intContainer(156), new ModelVariable(156, RESERVOIR_STR, "Period Energy Generation", "PERIOD", Parameter.PARAMID_ENERGY, 0));
        _variableTable.put(new intContainer(59), new ModelVariable(59, RESERVOIR_STR, "Energy Required", "REQUIRED", Parameter.PARAMID_ENERGY, 0));
        _variableTable.put(new intContainer(158), new ModelVariable(158, RESERVOIR_STR, "Power Violation", "VIOL", Parameter.PARAMID_POWER, 0));
        _variableTable.put(new intContainer(159), new ModelVariable(159, RESERVOIR_STR, "Energy Violation", "VIOL", Parameter.PARAMID_ENERGY, 0));
        _variableTable.put(new intContainer(154), new ModelVariable(154, RESERVOIR_STR, "Spill Flow", "SPILL", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(160), new ModelVariable(160, RESERVOIR_STR, "Period Generation from Min Release", "PER-MINREL", Parameter.PARAMID_ENERGY, 0));
        _variableTable.put(new intContainer(161), new ModelVariable(161, RESERVOIR_STR, "Period Generation from Pumpback above Min Pumpback", "PER-PUMP", Parameter.PARAMID_ENERGY, 0));
        _variableTable.put(new intContainer(165), new ModelVariable(165, RESERVOIR_STR, "Period Generation from Min Pumpback", "PER-PUMPMIN", Parameter.PARAMID_ENERGY, 0));
        _variableTable.put(new intContainer(162), new ModelVariable(162, RESERVOIR_STR, "Period Generation from Balancing Release", "PER-BAL", Parameter.PARAMID_ENERGY, 0));
        _variableTable.put(new intContainer(163), new ModelVariable(163, RESERVOIR_STR, "Period Generation for Guide Curve Release", "PER-GC", Parameter.PARAMID_ENERGY, 0));
        _variableTable.put(new intContainer(164), new ModelVariable(164, RESERVOIR_STR, "Period Generation additional to meet Power Reqm't", "PER-POWRULE", Parameter.PARAMID_ENERGY, 0));
        _variableTable.put(new intContainer(60), new ModelVariable(60, REACH_STR, "Seepage Loss", "SEEP", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(65), new ModelVariable(65, JUNCTION_STR, "Inflow", "IN", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(66), new ModelVariable(66, JUNCTION_STR, "Stage", null, Parameter.PARAMID_STAGE, 0));
        _variableTable.put(new intContainer(68), new ModelVariable(68, JUNCTION_STR, "Elevation", null, Parameter.PARAMID_ELEV, 0));
        _variableTable.put(new intContainer(67), new ModelVariable(67, JUNCTION_STR, "Lookback Flow", null, Parameter.PARAMID_FLOW, 1));
        _variableTable.put(new intContainer(197), new ModelVariable(197, JUNCTION_STR, "Local Flows", "Local", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(69), new ModelVariable(69, "Operation", "Max Limit", "MAXLIM", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(74), new ModelVariable(74, "Operation", "Min Limit", "MINLIM", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(70), new ModelVariable(70, "Operation", "Decision", "DECISION", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(71), new ModelVariable(71, "Operation", "Rule ID", "RULEID", -1, 0));
        _variableTable.put(new intContainer(73), new ModelVariable(73, "Operation", "Constraint ID", "CONSTRAINTID", -1, 0));
        _variableTable.put(new intContainer(72), new ModelVariable(72, "Operation", "Zone ID", "ZONEID", -1, 0));
        _variableTable.put(new intContainer(76), new ModelVariable(76, RESERVOIR_STR, "Zone Elevation", "ZONE", Parameter.PARAMID_ELEV, 0));
        _variableTable.put(new intContainer(77), new ModelVariable(77, RESERVOIR_STR, "Zone Elevation", "ZONE", Parameter.PARAMID_ELEV, 1, false));
        _variableTable.put(new intContainer(78), new ModelVariable(78, RESERVOIR_STR, "Zone Storage", "ZONE", Parameter.PARAMID_STOR, 0));
        _variableTable.put(new intContainer(169), new ModelVariable(169, RESERVOIR_STR, "Projected Elev", "PROJECTED", Parameter.PARAMID_ELEV, 0));
        _variableTable.put(new intContainer(128), new ModelVariable(128, RESERVOIR_STR, "Guide Curve Elevation", "GC", Parameter.PARAMID_ELEV, 0));
        _variableTable.put(new intContainer(129), new ModelVariable(129, RESERVOIR_STR, "Guide Curve Storage", "GC", Parameter.PARAMID_STOR, 0));
        _variableTable.put(new intContainer(79), new ModelVariable(79, "Operation", "Flow Space", "SPACE", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(80), new ModelVariable(80, "Operation", "Req Flow", "SPEC", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(81), new ModelVariable(81, "Operation", "Max Flow", "MAX", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(82), new ModelVariable(82, "Operation", "Min Flow", "MIN", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(141), new ModelVariable(141, "Operation", "Max Stage", "MAX", Parameter.PARAMID_STAGE, 0));
        _variableTable.put(new intContainer(142), new ModelVariable(142, "Operation", "Min Stage", "MIN", Parameter.PARAMID_STAGE, 0));
        _variableTable.put(new intContainer(83), new ModelVariable(83, "Operation", "Flow Violation", "VIOL", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(84), new ModelVariable(84, "Operation", "Stage Violation", "VIOL", Parameter.PARAMID_STAGE, 0));
        _variableTable.put(new intContainer(87), new ModelVariable(87, "Operation", "Elevation Violation", "VIOL", Parameter.PARAMID_ELEV, 0));
        _variableTable.put(new intContainer(88), new ModelVariable(88, "Operation", "Storage Violation", "VIOL", Parameter.PARAMID_STOR, 0));
        _variableTable.put(new intContainer(89), new ModelVariable(89, "Operation", "Desired Storage Balance", "BAL", Parameter.PARAMID_STOR, 0));
        _variableTable.put(new intContainer(202), new ModelVariable(202, "Operation", "Priority", "PRIORITY", Parameter.PARAMID_PENALTY, 0));
        int n = 0;
        try {
            Parameter parameter = new Parameter("Coeff");
            n = parameter.getParameterId();
        }
        catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
            DataSetIllegalArgumentException dataSetIllegalArgumentException2 = dataSetIllegalArgumentException;
            dataSetIllegalArgumentException.printStackTrace();
        }
        _variableTable.put(new intContainer(167), new ModelVariable(167, "Operation", "Storage Balance Index", "BAL-INDEX", n, 0));
        _variableTable.put(new intContainer(198), new ModelVariable(198, "Operation", "Routing Lag", "ROUTE-LAG", n, 0));
        _variableTable.put(new intContainer(199), new ModelVariable(199, "Operation", "Routing Min Offset", "ROUTE-MINOFFSET", n, 0));
        _variableTable.put(new intContainer(200), new ModelVariable(200, "Operation", "Routing Max Offset", "ROUTE-MAXOFFSET", n, 0));
        _variableTable.put(new intContainer(210), new ModelVariable(210, "Operation", "WQCD Op Elevation", "DECISION", Parameter.PARAMID_ELEV, 0));
        _variableTable.put(new intContainer(85), new ModelVariable(85, "Operation", "Input Time Series", null, -1, 1));
        _variableTable.put(new intContainer(86), new ModelVariable(86, "Operation", "Cumulative Local Flow", null, Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(196), new ModelVariable(196, "Operation", "Input Time Series", null, -1, 1));
        _variableTable.put(new intContainer(182), new ModelVariable(182, RESERVOIR_STR, "Pumped Volume", "PUMP", Parameter.PARAMID_STOR, 0));
        _variableTable.put(new intContainer(183), new ModelVariable(183, RESERVOIR_STR, "Pump Flow Average", "PUMP-AVG", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(170), new ModelVariable(170, "Operation", "Pumped Volume", "PUMP", Parameter.PARAMID_STOR, 0));
        _variableTable.put(new intContainer(171), new ModelVariable(171, "Operation", "Pump Flow Average", "PUMP-AVG", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(172), new ModelVariable(172, "Operation", "Pump Flow Rate", "PUMP-RATE", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(173), new ModelVariable(173, "Operation", "Pump Hours", "HOURS-PUMP", Parameter.PARAMID_COUNT, 0));
        _variableTable.put(new intContainer(180), new ModelVariable(180, "Operation", "Pump Unit Hours", "HOURS-PUMPUNIT", Parameter.PARAMID_COUNT, 0));
        _variableTable.put(new intContainer(174), new ModelVariable(174, "Operation", "Number of Pumps", "NUM-PUMPS", Parameter.PARAMID_COUNT, 0));
        _variableTable.put(new intContainer(175), new ModelVariable(175, "Operation", "Pumped Volume Capactiy", "PUMP-CAP", Parameter.PARAMID_STOR, 0));
        _variableTable.put(new intContainer(176), new ModelVariable(176, "Operation", "Pump Flow Average Capacity", "PUMP-AVG-CAP", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(177), new ModelVariable(177, "Operation", "Pump Flow Rate Capacity", "PUMP-RATE-CAP", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(178), new ModelVariable(178, "Operation", "Pump Hours Available", "HOURS-PUMP-AVAIL", Parameter.PARAMID_COUNT, 0));
        _variableTable.put(new intContainer(181), new ModelVariable(181, "Operation", "Pump Unit Hours Available", "HOURS-PUMPUNIT-AVAIL", Parameter.PARAMID_COUNT, 0));
        _variableTable.put(new intContainer(179), new ModelVariable(179, "Operation", "Number of Pumps Available", "NUM-PUMPS-AVAIL", Parameter.PARAMID_COUNT, 0));
        _variableTable.put(new intContainer(90), new ModelVariable(90, RESERVOIR_STR, "Pulse Flow", "Pulse", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(91), new ModelVariable(91, RESERVOIR_STR, "Back Route", "BackQ", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(95), new ModelVariable(95, RESERVOIR_STR, "Spill", "Spill", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(96), new ModelVariable(96, RESERVOIR_STR, "Lookback Spill", "Lookback Spill", Parameter.PARAMID_FLOW, 1));
        _variableTable.put(new intContainer(97), new ModelVariable(97, STATEVAR_STR, STATEVAR_STR, null, -1, 0));
        _variableTable.put(new intContainer(98), new ModelVariable(98, STATEVAR_STR, "Lookback State Variable", null, -1, 1));
        _variableTable.put(new intContainer(100), new ModelVariable(100, REACH_STR, "Regulated Flow", null, Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(103), new ModelVariable(103, REACH_STR, "Regulated Inflow", "IN", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(102), new ModelVariable(102, REACH_STR, "Cumulative Local Flow", "CUMLOC", Parameter.PARAMID_FLOW, 3));
        _variableTable.put(new intContainer(101), new ModelVariable(101, REACH_STR, "Unregulated Flow", "UNREG", Parameter.PARAMID_FLOW, 2));
        _variableTable.put(new intContainer(110), new ModelVariable(110, JUNCTION_STR, "Regulated Flow", null, Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(117), new ModelVariable(117, JUNCTION_STR, "Regulated Inflow", "IN", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(118), new ModelVariable(118, JUNCTION_STR, "Local Inflow", "LOC", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(119), new ModelVariable(119, JUNCTION_STR, DIVERSION_STR, "DIV", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(111), new ModelVariable(111, JUNCTION_STR, "Unregulated Flow", "UNREG", Parameter.PARAMID_FLOW, 2));
        _variableTable.put(new intContainer(112), new ModelVariable(112, JUNCTION_STR, "Cumulative Local Flow", "CUMLOC", Parameter.PARAMID_FLOW, 3));
        _variableTable.put(new intContainer(113), new ModelVariable(113, JUNCTION_STR, "Reservoir Holdout Flow", "HOLDOUT", Parameter.PARAMID_FLOW, 4));
        _variableTable.put(new intContainer(114), new ModelVariable(114, JUNCTION_STR, "Reservoir Pulse Flow", "PULSE", Parameter.PARAMID_FLOW, 5));
        _variableTable.put(new intContainer(115), new ModelVariable(115, JUNCTION_STR, "Regulated Stage", null, Parameter.PARAMID_STAGE, 0));
        _variableTable.put(new intContainer(116), new ModelVariable(116, JUNCTION_STR, "Unregulated Stage", "UNREG", Parameter.PARAMID_STAGE, 2));
        _variableTable.put(new intContainer(130), new ModelVariable(130, JUNCTION_STR, "Flow Limit", null, Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(131), new ModelVariable(131, JUNCTION_STR, "Stage Limit", null, Parameter.PARAMID_STAGE, 0));
        _variableTable.put(new intContainer(132), new ModelVariable(132, JUNCTION_STR, "Flow Violation", null, Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(133), new ModelVariable(133, JUNCTION_STR, "Stage Violation", null, Parameter.PARAMID_STAGE, 0));
        _variableTable.put(new intContainer(120), new ModelVariable(120, DIVERSION_STR, DIVERSION_STR, null, Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(121), new ModelVariable(121, DIVERSION_STR, "Routed Diversion", null, Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(125), new ModelVariable(125, DIVERTEDOUTLET_STR, DIVERSION_STR, null, Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(126), new ModelVariable(126, DIVERTEDOUTLET_STR, "Routed Diversion", null, Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(127), new ModelVariable(127, RESERVOIR_STR, "Capacity Factor", null, -1, 0));
        _variableTable.put(new intContainer(190), new ModelVariable(190, WATER_ACCOUNT_STR, "Stor", null, Parameter.PARAMID_STOR, 0));
        _variableTable.put(new intContainer(191), new ModelVariable(191, WATER_ACCOUNT_STR, "Max Stor", "MAX", Parameter.PARAMID_STOR, 0));
        _variableTable.put(new intContainer(192), new ModelVariable(192, WATER_ACCOUNT_STR, "Inflow", "IN", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(193), new ModelVariable(193, WATER_ACCOUNT_STR, "Demand", "DEMAND", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(194), new ModelVariable(194, WATER_ACCOUNT_STR, "Demand", "YA RULE DEMAND", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(195), new ModelVariable(195, WATER_ACCOUNT_STR, "Lookback Storage", null, Parameter.PARAMID_STOR, 1));
        _variableTable.put(new intContainer(203), new ModelVariable(203, WATER_ACCOUNT_STR, "Inflow Surplus", "SURPLUS", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(204), new ModelVariable(204, WATER_ACCOUNT_STR, "Inflow Transfers", "TRANSFERS", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(205), new ModelVariable(205, WATER_ACCOUNT_STR, "Demand Charges", "CHARGES", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(206), new ModelVariable(206, WATER_ACCOUNT_STR, "Demand Credits", "CREDITS", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(207), new ModelVariable(207, WATER_ACCOUNT_STR, "Inflow Losses", "LOSSES", Parameter.PARAMID_FLOW, 0));
        _variableTable.put(new intContainer(208), new ModelVariable(208, WATER_ACCOUNT_STR, "Inflow Pumpback", "PUMPBACK", Parameter.PARAMID_FLOW, 0));
    }
}

