/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.StreamAlignment;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.lang.ObjectReference;
import hec.map.WorldPt;
import hec.model.Node;
import hec.model.StreamElement;
import hec.model.TSLocation;
import hec.model.TsRecordContainer;
import hec.rss.model.Element;
import hec.rss.model.FlowLimitOpRule;
import hec.rss.model.HindcastData;
import hec.rss.model.JunctionElement;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.watershed.model.ComputationPoint;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import rma.util.RMAIO;
import rma.util.rmaTokenizer;

public class RssNode
extends Node
implements TSLocation,
RssReturnStatusConstants {
    RssSystem _system;
    ObjectReference _upstreamElement = new ObjectReference();
    ObjectReference _downstreamElement = new ObjectReference();
    long _computationPointId = Long.MIN_VALUE;
    private transient ComputationPoint a;
    private transient boolean b = true;
    private transient Vector c;

    public RssNode() {
    }

    public RssNode(RssSystem rssSystem, int n) {
        super((TsRecordContainer)rssSystem, n);
        this._system = rssSystem;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public void addFlowRule(FlowLimitOpRule flowLimitOpRule) {
        if (this.c == null) {
            this.c = new Vector();
        }
        if (!this.c.contains(flowLimitOpRule)) {
            this.c.add(flowLimitOpRule);
        }
    }

    public Vector getFlowRuleVector() {
        return this.c;
    }

    public void applyHindcastData(HindcastData hindcastData) {
    }

    public void clearTSProxyList() {
        int n = this._tsrecordVector.size();
        TSRecordProxy tSRecordProxy = this.getTSRecordProxy(4);
        --n;
        while (n >= 0) {
            TSRecordProxy tSRecordProxy2 = (TSRecordProxy)this._tsrecordVector.elementAt(n);
            if (tSRecordProxy2 == null || tSRecordProxy == null || tSRecordProxy2 != tSRecordProxy && tSRecordProxy2.getName().indexOf(tSRecordProxy.getName()) < 0) {
                this._tsrecordVector.remove(n);
            }
            --n;
        }
    }

    public Vector getActiveTSProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        boolean bl = false;
        if (n == 1) {
            bl = true;
        }
        int n2 = this._tsrecordVector.size();
        for (n = 0; n < n2; ++n) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(n);
            if (tSRecordProxy.isInput() != bl || RssModelVariableConstants.isWQId(tSRecordProxy.getVariableId())) continue;
            vector.add(tSRecordProxy);
        }
        return vector;
    }

    public List<TSRecordProxy> getActiveOutputWQTSProxies() {
        ArrayList<TSRecordProxy> arrayList = new ArrayList<TSRecordProxy>();
        for (Object object : this._tsrecordVector) {
            if ((object = (TSRecordProxy)object).isInput() || !RssModelVariableConstants.isWQId(object.getVariableId())) continue;
            arrayList.add((TSRecordProxy)object);
        }
        return arrayList;
    }

    public TSRecordProxy addTSRecordProxy(int n) {
        TSRecordProxy tSRecordProxy = RssModelVariableSet.newTSRecordProxy(this._system, this, n);
        if (tSRecordProxy != null) {
            this._tsrecordVector.addElement(tSRecordProxy);
        }
        return tSRecordProxy;
    }

    public TSRecordProxy getTSRecordProxy(int n) {
        int n2 = this._tsrecordVector.size();
        for (int i = 0; i < n2; ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(i);
            if (tSRecordProxy == null || tSRecordProxy.getVariableId() != n) continue;
            return tSRecordProxy;
        }
        return null;
    }

    public double getTSFactor(int n) {
        TSRecordProxy tSRecordProxy = this.getTSRecordProxy(n);
        if (tSRecordProxy == null) {
            return 1.0;
        }
        return tSRecordProxy.getFactor();
    }

    public void setComputationPoint(ComputationPoint computationPoint) {
        this.a = computationPoint;
        if (computationPoint == null) {
            this._computationPointId = Long.MIN_VALUE;
            return;
        }
        this._computationPointId = computationPoint.getId();
        this.setName(computationPoint.getName());
        this.setStreamIndex(computationPoint.getStreamId());
        this.setStreamName(computationPoint.getStreamName());
        this.setStreamStation(computationPoint.getStreamStation());
    }

    public String toString() {
        return this._system.getNameForKeyString(this.getName());
    }

    public boolean isActive() {
        return this.b;
    }

    public void setActive(boolean bl) {
        this.b = bl;
    }

    public Element getContinuityElement() {
        if (this.getUpstreamElement() != null && this.getUpstreamElement() instanceof JunctionElement) {
            return this.getUpstreamElement();
        }
        if (this.getDownstreamElement() != null && this.getDownstreamElement() instanceof JunctionElement) {
            return this.getDownstreamElement();
        }
        return null;
    }

    public void setSystem(RssSystem rssSystem) {
        this._system = rssSystem;
        this.setManager((TsRecordContainer)rssSystem);
    }

    public Element getUpstreamElement() {
        Element element = (Element)this._upstreamElement.getObject();
        if (element != null) {
            return element;
        }
        if (this._upstreamElement.id != Integer.MIN_VALUE) {
            element = this._system.getElement(this._upstreamElement.id);
            this._upstreamElement.setObject((Object)element);
        }
        return element;
    }

    public void setUpstreamElement(Element element) {
        this._upstreamElement.id = element.getIndex();
        this._upstreamElement.setObject((Object)element);
    }

    public Element getDownstreamElement() {
        Element element = (Element)this._downstreamElement.getObject();
        if (element != null) {
            return element;
        }
        if (this._downstreamElement.id != Integer.MIN_VALUE) {
            element = this._system.getElement(this._downstreamElement.id);
            this._downstreamElement.setObject((Object)element);
        }
        return element;
    }

    public void setDownstreamElement(Element element) {
        this._downstreamElement.id = element.getIndex();
        this._downstreamElement.setObject((Object)element);
    }

    public void removeElement(Element element) {
        if (element == this.getDownstreamElement()) {
            this._downstreamElement.clear();
            return;
        }
        if (element == this.getUpstreamElement()) {
            this._upstreamElement.clear();
        }
    }

    public void setStreamStation(double d) {
        this._station = d;
        StreamElement streamElement = this.getStream();
        if (streamElement != null) {
            this._streamCoord = streamElement.getCoordByStation(this._station);
        }
    }

    public double getStreamCoord() {
        StreamElement streamElement = this.getStream();
        if (streamElement != null) {
            this._streamCoord = streamElement.getCoordByStation(this._station);
        }
        return this._streamCoord;
    }

    public WorldPt getLocation() {
        StreamElement streamElement = this.getStream();
        if (streamElement != null) {
            this._location = streamElement.getLocationByStation(this._station);
        }
        return this._location;
    }

    public StreamElement getStream() {
        StreamAlignment streamAlignment;
        if (this._stream == null && (streamAlignment = this._system.getAlignment()) != null && this._streamIndex >= 0) {
            this._stream = streamAlignment.findReach(this._streamIndex);
        }
        return this._stream;
    }

    public void dispose() {
        if (this._system != null) {
            this._system.deleteDownstreamOp(this._index);
        }
        if (this.getDownstreamElement() != null) {
            this.getDownstreamElement().removeNode(this);
            this._downstreamElement.clear();
        }
        if (this.getUpstreamElement() != null) {
            this.getUpstreamElement().removeNode(this);
            this._upstreamElement.clear();
        }
    }

    public boolean isDisposed() {
        if (this.getDownstreamElement() == null && this.getUpstreamElement() == null) {
            return true;
        }
        if (this._upstreamElement.id != Integer.MIN_VALUE && this._system.getElement(this._upstreamElement.id) == null) {
            return true;
        }
        return this._downstreamElement.id != Integer.MIN_VALUE && this._system.getElement(this._downstreamElement.id) == null;
    }

    public TSDataSet getTSDataSet(boolean bl) {
        if (bl) {
            return this._system.getInputTSDataSet();
        }
        return this._system.getOutputTSDataSet();
    }

    public double[] getTSArray(String string) {
        double[] dArray = null;
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(i);
            if (tSRecordProxy == null || !string.equalsIgnoreCase(tSRecordProxy.getParamName())) continue;
            dArray = tSRecordProxy.getTSArray();
            break;
        }
        return dArray;
    }

    public boolean readData(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() == 0) {
                    string = bufferedReader.readLine();
                    continue;
                }
                if (string.indexOf("Node") < 0) break;
                String string2 = RMAIO.getType((String)string, (String)"=");
                string = RMAIO.getParam((String)string, (String)"=").trim();
                if (string2.compareTo("Node Name") == 0) {
                    this.setName(string);
                } else if (string2.compareTo("Node Description") == 0) {
                    this.setDescription(string);
                } else if (string2.compareTo("Node Location") == 0) {
                    this._location.parseString(string);
                }
                if (string2.compareTo("Node TSRecord") == 0) {
                    string2 = new TSRecordProxy((TSLocation)this);
                    string = new rmaTokenizer(string, ",");
                    try {
                        string2.setName(string.nextToken().trim());
                        string2.setParamName(string.nextToken().trim());
                        string = string.nextToken();
                        if (string.indexOf("Input") >= 0) {
                            string2.setInput(true);
                        } else {
                            string2.setInput(false);
                        }
                        this._tsrecordVector.addElement(string2);
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                } else if (string2.equals("Node _streamIndex")) {
                    this._streamIndex = RMAIO.parseInt((String)string);
                } else if (string2.equals("Node Station")) {
                    this._station = RMAIO.parseDouble((String)string);
                } else if (string2.equals("Node StreamCoord")) {
                    this._streamCoord = RMAIO.parseDouble((String)string);
                } else if (string2.compareTo("Node End") == 0) break;
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean writeData(BufferedWriter bufferedWriter) {
        try {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Node=" + this.getIndex()));
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Node Name=" + this.getName()));
            bufferedWriter.write("Node Description=" + this.getDescription());
            bufferedWriter.newLine();
            bufferedWriter.write("Node Location=" + this._location.toString());
            bufferedWriter.newLine();
            for (int i = 0; i < this._tsrecordVector.size(); ++i) {
                TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(i);
                String string = "Node TSRecord=" + tSRecordProxy.getName() + ", " + tSRecordProxy.getParamName() + ", ";
                string = tSRecordProxy.isInput() ? string + "Input" : string + "Output";
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)string);
            }
            bufferedWriter.write("Node _streamIndex=" + this._streamIndex);
            bufferedWriter.newLine();
            bufferedWriter.write("Node Station=" + RMAIO.toString((double)this._station));
            bufferedWriter.newLine();
            bufferedWriter.write("Node StreamCoord=" + RMAIO.toString((double)this._streamCoord));
            bufferedWriter.newLine();
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"Node End");
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
            return true;
        }
        catch (Exception exception) {
            System.out.println("Error writing node data");
            return false;
        }
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

