/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.ParameterString;
import hec.data.Units;
import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.io.DSSIdentifier;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.lang.UserId;
import hec.model.ModelVariable;
import hec.model.TSLocation;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.DiversionElement;
import hec.rss.model.Element;
import hec.rss.model.JunctionElement;
import hec.rss.model.ModelConst;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocation;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Spillway;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.CallBackInterface;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import mil.army.usace.hec.rmi.server.RmiFileCallBackImpl;
import rma.util.RMASort;

public class RssOutput
extends NamedType
implements AsciiSerializable,
RssModelVariableConstants,
RssReturnStatusConstants,
Serializable,
CallBackInterface {
    Hashtable<String, Hashtable> _collectionRunMap = new Hashtable();
    Hashtable _tsSummaryTable = new Hashtable();
    int m_unitSystem = 1;
    private Identifier _identifier;
    private RmiFileCallBackImpl _callBack;

    public void setUnitSystem(int n) {
        if (!Units.isValidUnitsSystem((int)n)) {
            throw new IllegalArgumentException("ERROR <" + this.getClass().getName() + ".setUnitSystem()> : Invalid Unit System being set!");
        }
        this.m_unitSystem = n;
    }

    public Object[][] getReservoirSummaryStrArray(RssSystem rssSystem, String object) {
        if ((object = (Map)this._collectionRunMap.get(object)) != null) {
            return this.getReservoirSummaryStrArray(rssSystem, (Map)object);
        }
        if (this._tsSummaryTable != null) {
            return this.getReservoirSummaryStrArray(rssSystem, this._tsSummaryTable);
        }
        return null;
    }

    public Object[][] getReservoirSummaryStrArray(RssSystem object, Map map) {
        if (object == null) {
            return null;
        }
        ((RssSystem)object).updateTSProxyList();
        object = ((RssSystem)object).getElementVectorByClass(ReservoirElement.class.getName());
        Vector<String> vector = new Vector<String>();
        Object[][] objectArray = ((Vector)object).elements();
        while (objectArray.hasMoreElements()) {
            vector.addElement(((Element)objectArray.nextElement()).getName());
        }
        RMASort.quickSort(vector, (List)object);
        objectArray = new Object[((Vector)object).size() * 5][5];
        int n = 0;
        String string = "1";
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            ReservoirElement reservoirElement = (ReservoirElement)((Vector)object).elementAt(i);
            objectArray[n][0] = reservoirElement.getName();
            objectArray[n][4] = string;
            ++n;
            Object object2 = reservoirElement.getStorageFunction();
            if ((object2 = ((RssTSLocationObject)object2).getTSRecordProxy(11)) != null) {
                object2 = "REG|" + object2.getName() + "|" + object2.getParamName();
                double[] dArray = (double[])map.get(object2);
                object2 = dArray;
                if (dArray != null) {
                    objectArray[n][0] = new ParameterString(ModelConst.u + " (%S)", Parameter.PARAMID_STOR);
                    objectArray[n][1] = new ParamDouble((double)object2[0], Parameter.PARAMID_STOR, this.m_unitSystem, 2);
                    objectArray[n][2] = new ParamDouble((double)object2[2], Parameter.PARAMID_STOR, this.m_unitSystem, 2);
                    objectArray[n][3] = new ParamDouble((double)object2[1], Parameter.PARAMID_STOR, this.m_unitSystem, 2);
                }
            }
            ++n;
            object2 = reservoirElement.getStorageFunction();
            if ((object2 = ((RssTSLocationObject)object2).getTSRecordProxy(10)) != null) {
                object2 = "REG|" + object2.getName() + "|" + object2.getParamName();
                double[] dArray = (double[])map.get(object2);
                object2 = dArray;
                if (dArray != null) {
                    objectArray[n][0] = new ParameterString(ModelConst.r + " (%S)", Parameter.PARAMID_ELEV);
                    objectArray[n][1] = new ParamDouble((double)object2[0], Parameter.PARAMID_ELEV, this.m_unitSystem, 2);
                    objectArray[n][2] = new ParamDouble((double)object2[2], Parameter.PARAMID_ELEV, this.m_unitSystem, 2);
                    objectArray[n][3] = new ParamDouble((double)object2[1], Parameter.PARAMID_ELEV, this.m_unitSystem, 2);
                }
            }
            ++n;
            Vector vector2 = reservoirElement.getElementsByClass(AdjustableFlow.class, null);
            double[] dArray = new double[3];
            for (int j = 0; j < vector2.size(); ++j) {
                Element element = (Element)vector2.elementAt(j);
                object2 = element.getDownstreamNode();
                if ((object2 = ((RssNode)object2).getTSRecordProxy(0)) == null) continue;
                object2 = "REG|" + object2.getName() + "|" + object2.getParamName();
                double[] dArray2 = (double[])map.get(object2);
                object2 = dArray2;
                if (dArray2 == null) continue;
                dArray[0] = dArray[0] + object2[0];
                dArray[1] = dArray[1] + object2[2];
                dArray[2] = dArray[2] + object2[1];
            }
            objectArray[n][0] = new ParameterString("Controlled Release (%S)", Parameter.PARAMID_FLOW);
            objectArray[n][1] = new ParamDouble(dArray[0], Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
            objectArray[n][2] = new ParamDouble(dArray[1], Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
            objectArray[n][3] = new ParamDouble(dArray[2], Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
            ++n;
            Vector vector3 = reservoirElement.getElementsByClass(Spillway.class, null);
            dArray = new double[3];
            for (int j = 0; j < vector3.size(); ++j) {
                object2 = (Element)vector3.elementAt(j);
                object2 = ((Element)object2).getDownstreamNode();
                if ((object2 = ((RssNode)object2).getTSRecordProxy(0)) == null) continue;
                object2 = "REG|" + object2.getName() + "|" + object2.getParamName();
                double[] dArray3 = (double[])map.get(object2);
                object2 = dArray3;
                if (dArray3 == null) continue;
                dArray[0] = dArray[0] + object2[0];
                dArray[1] = dArray[1] + object2[2];
                dArray[2] = dArray[2] + object2[1];
            }
            objectArray[n][0] = new ParameterString("Uncontrolled Spill (%S)", Parameter.PARAMID_FLOW);
            objectArray[n][1] = new ParamDouble(dArray[0], Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
            objectArray[n][2] = new ParamDouble(dArray[1], Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
            objectArray[n][3] = new ParamDouble(dArray[2], Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
            ++n;
        }
        return objectArray;
    }

    public Object[][] getReservoirSummaryStrArray(RssSystem object, String object2, RssRun rssRun, String string) {
        if (object == null || rssRun == null || object2 == null) {
            return null;
        }
        ((RssSystem)object).updateTSProxyList();
        object = ((RssSystem)object).getElementVectorByClass(ReservoirElement.class.getName());
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            vector.addElement(((Element)((Vector)object).get(i)).getName());
        }
        RMASort.quickSort(vector, (List)object);
        Object[][] objectArray = new Object[((Vector)object).size() * 5][3];
        int n = 0;
        String string2 = "1";
        DSSIdentifier dSSIdentifier = new DSSIdentifier();
        HecTime hecTime = new HecTime((String)object2);
        DSSManager dSSManager = rssRun.getDSSFileManager();
        String string3 = rssRun.getOutputFPart();
        if (string != null) {
            rssRun.setOutputFPart(string);
        }
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            double d;
            TSDataSet tSDataSet;
            object2 = (ReservoirElement)((Vector)object).elementAt(i);
            objectArray[n][0] = object2.getName();
            objectArray[n][2] = string2;
            ++n;
            TSLocation tSLocation = ((ReservoirElement)object2).getStorageFunction();
            if ((tSLocation = tSLocation.getTSRecordProxy(11)) != null) {
                tSDataSet = rssRun.getRegOutputTSData();
                objectArray[n][0] = new ParameterString(ModelConst.u + " (%S)", Parameter.PARAMID_FLOW);
                d = this.getDataPoint(tSDataSet, (TSRecordProxy)tSLocation, hecTime, dSSIdentifier, dSSManager);
                objectArray[n][1] = new ParamDouble(d, Parameter.PARAMID_STOR, this.m_unitSystem, 2);
            }
            ++n;
            tSLocation = ((ReservoirElement)object2).getStorageFunction();
            if ((tSLocation = tSLocation.getTSRecordProxy(10)) != null) {
                tSDataSet = rssRun.getRegOutputTSData();
                objectArray[n][0] = new ParameterString(ModelConst.r + " (%S)", Parameter.PARAMID_ELEV);
                d = this.getDataPoint(tSDataSet, (TSRecordProxy)tSLocation, hecTime, dSSIdentifier, dSSManager);
                objectArray[n][1] = new ParamDouble(d, Parameter.PARAMID_ELEV, this.m_unitSystem, 2);
            }
            ++n;
            Vector vector2 = ((Element)object2).getElementsByClass(AdjustableFlow.class, null);
            for (int j = 0; j < vector2.size(); ++j) {
                Element element = (Element)vector2.elementAt(j);
                tSLocation = element.getDownstreamNode();
                if ((tSLocation = ((RssNode)tSLocation).getTSRecordProxy(0)) == null) continue;
                tSDataSet = rssRun.getRegOutputTSData();
                objectArray[n][0] = new ParameterString("Controlled Release (%S)", Parameter.PARAMID_FLOW);
                d = this.getDataPoint(tSDataSet, (TSRecordProxy)tSLocation, hecTime, dSSIdentifier, dSSManager);
                objectArray[n][1] = new ParamDouble(d, Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
            }
            Vector vector3 = ((Element)object2).getElementsByClass(Spillway.class, null);
            objectArray[++n][0] = new ParameterString("Uncontrolled Spill (%S)", Parameter.PARAMID_FLOW);
            d = 0.0;
            for (int j = 0; j < vector3.size(); ++j) {
                object2 = (Element)vector3.elementAt(j);
                tSLocation = ((Element)object2).getDownstreamNode();
                if ((tSLocation = ((RssNode)tSLocation).getTSRecordProxy(0)) == null) continue;
                tSDataSet = rssRun.getRegOutputTSData();
                d += this.getDataPoint(tSDataSet, (TSRecordProxy)tSLocation, hecTime, dSSIdentifier, dSSManager);
            }
            objectArray[n][1] = new ParamDouble(d, Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
            ++n;
        }
        if (string != null) {
            rssRun.setOutputFPart(string3);
        }
        return objectArray;
    }

    public Object[][] getFlowSummaryStrArray(RssSystem rssSystem, String object) {
        if ((object = (Map)this._collectionRunMap.get(object)) != null) {
            return this.getFlowSummaryStrArray(rssSystem, (Map)object);
        }
        if (this._tsSummaryTable != null) {
            return this.getFlowSummaryStrArray(rssSystem, this._tsSummaryTable);
        }
        return null;
    }

    public double[] getStorageForReservoir(RssSystem rssSystem, String string, String object) {
        if ((object = (Map)this._collectionRunMap.get(object)) != null) {
            return this.getStorageForReservoir(rssSystem, string, (Map)object);
        }
        if (this._tsSummaryTable != null) {
            return this.getStorageForReservoir(rssSystem, string, this._tsSummaryTable);
        }
        return null;
    }

    private double[] getStorageForReservoir(RssSystem object, String string, Map map) {
        if (object == null) {
            return null;
        }
        ((RssSystem)object).updateTSProxyList();
        object = ((RssSystem)object).findReservoir(string);
        if (object == null) {
            return null;
        }
        if ((object = ((ReservoirElement)object).getStorageFunction().getTSRecordProxy(11)) == null) {
            return null;
        }
        object = "REG|" + object.getName() + "|" + object.getParamName();
        double[] dArray = (double[])map.get(object);
        object = dArray;
        if (dArray != null) {
            return object;
        }
        return null;
    }

    public double[] getControlReleaseForReservoir(RssSystem rssSystem, String string, String object) {
        if ((object = (Map)this._collectionRunMap.get(object)) != null) {
            return this.getControlReleaseForReservoir(rssSystem, string, (Map)object);
        }
        if (this._tsSummaryTable != null) {
            return this.getControlReleaseForReservoir(rssSystem, string, this._tsSummaryTable);
        }
        return null;
    }

    private double[] getControlReleaseForReservoir(RssSystem object, String string, Map map) {
        if (object == null) {
            return null;
        }
        ((RssSystem)object).updateTSProxyList();
        object = ((RssSystem)object).findReservoir(string);
        if (object == null) {
            return null;
        }
        if ((object = ((ReservoirElement)object).getStorageFunction().getTSRecordProxy(21)) == null) {
            return null;
        }
        object = "REG|" + object.getName() + "|" + object.getParamName();
        double[] dArray = (double[])map.get(object);
        object = dArray;
        if (dArray != null) {
            return object;
        }
        return null;
    }

    public double[] getUncontrolReleaseForReservoir(RssSystem rssSystem, String string, String object) {
        if ((object = (Map)this._collectionRunMap.get(object)) != null) {
            return this.getUncontrolReleaseForReservoir(rssSystem, string, (Map)object);
        }
        if (this._tsSummaryTable != null) {
            return this.getUncontrolReleaseForReservoir(rssSystem, string, this._tsSummaryTable);
        }
        return null;
    }

    private double[] getUncontrolReleaseForReservoir(RssSystem object, String string, Map map) {
        if (object == null) {
            return null;
        }
        ((RssSystem)object).updateTSProxyList();
        object = ((RssSystem)object).findReservoir(string);
        if (object == null) {
            return null;
        }
        if ((object = ((ReservoirElement)object).getStorageFunction().getTSRecordProxy(0)) == null) {
            return null;
        }
        object = "REG|" + object.getName() + "|" + object.getParamName();
        double[] dArray = (double[])map.get(object);
        object = dArray;
        if (dArray != null) {
            return object;
        }
        return null;
    }

    public double[] getElevForReservoir(RssSystem rssSystem, String string, String object) {
        if ((object = (Map)this._collectionRunMap.get(object)) != null) {
            return this.getElevForReservoir(rssSystem, string, (Map)object);
        }
        if (this._tsSummaryTable != null) {
            return this.getElevForReservoir(rssSystem, string, this._tsSummaryTable);
        }
        return null;
    }

    private double[] getElevForReservoir(RssSystem object, String string, Map map) {
        if (object == null) {
            return null;
        }
        ((RssSystem)object).updateTSProxyList();
        object = ((RssSystem)object).findReservoir(string);
        if (object == null) {
            return null;
        }
        if ((object = ((ReservoirElement)object).getStorageFunction().getTSRecordProxy(10)) == null) {
            return null;
        }
        object = "REG|" + object.getName() + "|" + object.getParamName();
        double[] dArray = (double[])map.get(object);
        object = dArray;
        if (dArray != null) {
            return object;
        }
        return null;
    }

    public Object[][] getFlowSummaryStrArray(RssSystem object, Map map) {
        if (object == null) {
            return null;
        }
        ((RssSystem)object).updateTSProxyList();
        object = ((RssSystem)object).getElementVector();
        Vector<String> vector = new Vector<String>();
        Object[][] objectArray = ((Vector)object).elements();
        while (objectArray.hasMoreElements()) {
            vector.addElement(((Element)objectArray.nextElement()).getName());
        }
        RMASort.quickSort(vector, (List)object);
        objectArray = new Object[((Vector)object).size() << 2][5];
        int n = 0;
        String string = "1";
        ParameterString parameterString = new ParameterString("Regulated Flow (%S)", Parameter.PARAMID_FLOW);
        ParameterString parameterString2 = new ParameterString("Unregulated Flow (%S)", Parameter.PARAMID_FLOW);
        ParameterString parameterString3 = new ParameterString("Cumulative Local Flow (%S)", Parameter.PARAMID_FLOW);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            Object object2 = (Element)((Vector)object).elementAt(i);
            objectArray[n][0] = object2.getName();
            objectArray[n][4] = string;
            ++n;
            TSRecordProxy tSRecordProxy = null;
            if (object2 instanceof ReservoirElement) {
                object2 = (ReservoirElement)object2;
                tSRecordProxy = ((ReservoirElement)object2).getStorageFunction().getTSRecordProxy(21);
            } else if (object2 instanceof DiversionElement) {
                object2 = (DiversionElement)object2;
                if ((object2 = ((DiversionElement)object2).getDiversionNode()) != null) {
                    tSRecordProxy = ((RssNode)object2).getTSRecordProxy(0);
                }
            } else if ((object2 = ((Element)object2).getDownstreamNode()) != null) {
                tSRecordProxy = ((RssNode)object2).getTSRecordProxy(0);
            }
            if (tSRecordProxy == null) continue;
            object2 = "REG|" + tSRecordProxy.getName() + "|" + tSRecordProxy.getParamName();
            object2 = (double[])map.get(object2);
            objectArray[n][0] = parameterString;
            if (object2 != null) {
                objectArray[n][1] = new ParamDouble((double)object2[0], Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
                objectArray[n][2] = new ParamDouble((double)object2[2], Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
                objectArray[n][3] = new ParamDouble((double)object2[1], Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
            }
            object2 = "UNREG|" + tSRecordProxy.getName() + "|" + tSRecordProxy.getParamName();
            object2 = (double[])map.get(object2);
            objectArray[++n][0] = parameterString2;
            if (object2 != null) {
                objectArray[n][1] = new ParamDouble((double)object2[0], Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
                objectArray[n][2] = new ParamDouble((double)object2[2], Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
                objectArray[n][3] = new ParamDouble((double)object2[1], Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
            }
            object2 = "CUMLOC|" + tSRecordProxy.getName() + "|" + tSRecordProxy.getParamName();
            object2 = (double[])map.get(object2);
            objectArray[++n][0] = parameterString3;
            if (object2 != null) {
                objectArray[n][1] = new ParamDouble((double)object2[0], Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
                objectArray[n][2] = new ParamDouble((double)object2[2], Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
                objectArray[n][3] = new ParamDouble((double)object2[1], Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
            }
            ++n;
        }
        return objectArray;
    }

    public Object[][] getFlowSummaryStrArray(RssSystem object, String object2, RssRun rssRun, String string) {
        if (object == null || rssRun == null) {
            return null;
        }
        ((RssSystem)object).updateTSProxyList();
        object = ((RssSystem)object).getElementVector();
        Vector<String> vector = new Vector<String>();
        Object[][] objectArray = ((Vector)object).elements();
        while (objectArray.hasMoreElements()) {
            vector.addElement(((Element)objectArray.nextElement()).getName());
        }
        RMASort.quickSort(vector, (List)object);
        objectArray = new Object[((Vector)object).size() << 2][3];
        int n = 0;
        String string2 = "1";
        ParameterString parameterString = new ParameterString("Regulated Flow (%S)", Parameter.PARAMID_FLOW);
        ParameterString parameterString2 = new ParameterString("Unregulated Flow (%S)", Parameter.PARAMID_FLOW);
        ParameterString parameterString3 = new ParameterString("Cumulative Local Flow (%S)", Parameter.PARAMID_FLOW);
        DSSIdentifier dSSIdentifier = new DSSIdentifier();
        HecTime hecTime = new HecTime((String)object2);
        DSSManager dSSManager = rssRun.getDSSFileManager();
        String string3 = rssRun.getOutputFPart();
        if (string != null) {
            rssRun.setOutputFPart(string);
        }
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            object2 = (Element)((Vector)object).elementAt(i);
            objectArray[n][0] = object2.getName();
            objectArray[n][2] = string2;
            ++n;
            TSRecordProxy tSRecordProxy = null;
            if (object2 instanceof ReservoirElement) {
                object2 = (ReservoirElement)object2;
                tSRecordProxy = ((ReservoirElement)object2).getStorageFunction().getTSRecordProxy(21);
            } else if (object2 instanceof DiversionElement) {
                object2 = (DiversionElement)object2;
                if ((object2 = ((DiversionElement)object2).getDiversionNode()) != null) {
                    tSRecordProxy = ((RssNode)object2).getTSRecordProxy(0);
                }
            } else if ((object2 = ((Element)object2).getDownstreamNode()) != null) {
                tSRecordProxy = ((RssNode)object2).getTSRecordProxy(0);
            }
            if (tSRecordProxy == null) continue;
            objectArray[n][0] = parameterString;
            object2 = rssRun.getRegOutputTSData();
            double d = this.getDataPoint((TSDataSet)object2, tSRecordProxy, hecTime, dSSIdentifier, dSSManager);
            objectArray[n][1] = new ParamDouble(d, Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
            objectArray[++n][0] = parameterString2;
            object2 = rssRun.getUnregOutputTSData();
            d = this.getDataPoint((TSDataSet)object2, tSRecordProxy, hecTime, dSSIdentifier, dSSManager);
            objectArray[n][1] = new ParamDouble(d, Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
            objectArray[++n][0] = parameterString3;
            object2 = rssRun.getCumLocOutputTSData();
            d = this.getDataPoint((TSDataSet)object2, tSRecordProxy, hecTime, dSSIdentifier, dSSManager);
            objectArray[n][1] = new ParamDouble(d, Parameter.PARAMID_FLOW, this.m_unitSystem, 2);
            ++n;
        }
        if (string != null) {
            rssRun.setOutputFPart(string3);
        }
        return objectArray;
    }

    double getDataPoint(TSDataSet tSDataSet, TSRecordProxy tSRecordProxy, HecTime hecTime, DSSIdentifier dSSIdentifier, DSSManager dSSManager) {
        tSDataSet = tSDataSet.getTSRecord(tSRecordProxy.getName(), tSRecordProxy.getVariableId());
        dSSIdentifier.setDSSPath(tSDataSet.getDSSPathname());
        dSSIdentifier.setFileName(tSDataSet.getDSSFilename());
        HecTime hecTime2 = hecTime;
        dSSIdentifier.setTimeWindow(hecTime2, hecTime2);
        try {
            tSDataSet = dSSManager.readTS(dSSIdentifier, false);
        }
        catch (Exception exception) {
            System.out.println("Error reading " + String.valueOf(dSSIdentifier) + " Error:" + String.valueOf(exception));
            return Double.NEGATIVE_INFINITY;
        }
        if (tSDataSet == null || tSDataSet.numberValues == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return tSDataSet.values[0];
    }

    public Object[][] getStageSummaryStrArray(RssSystem rssSystem, String object) {
        if ((object = (Map)this._collectionRunMap.get(object)) != null) {
            return this.getStageSummaryStrArray(rssSystem, (Map)object);
        }
        if (this._tsSummaryTable != null) {
            return this.getStageSummaryStrArray(rssSystem, this._tsSummaryTable);
        }
        return null;
    }

    public Object[][] getStageSummaryStrArray(RssSystem object, Map map) {
        if (object == null) {
            return null;
        }
        ((RssSystem)object).updateTSProxyList();
        object = ((RssSystem)object).getElementVectorByClass(JunctionElement.class.getName());
        for (int i = ((Vector)object).size() - 1; i >= 0; --i) {
            if (((JunctionElement)((Vector)object).elementAt(i)).hasRatingCurve()) continue;
            ((Vector)object).removeElementAt(i);
        }
        if (((Vector)object).size() <= 0) {
            Object[][] objectArray = new String[][]{{"No Stage Data Computed", null, null, null, "1"}};
            return objectArray;
        }
        Vector<String> vector = new Vector<String>();
        Object[][] objectArray = ((Vector)object).elements();
        while (objectArray.hasMoreElements()) {
            vector.addElement(((Element)objectArray.nextElement()).getName());
        }
        RMASort.quickSort(vector, (List)object);
        objectArray = new Object[((Vector)object).size() << 2][5];
        int n = 0;
        String string = "1";
        ParameterString parameterString = new ParameterString("Regulated Stage (%S)", Parameter.PARAMID_STAGE);
        ParameterString parameterString2 = new ParameterString("Unregulated Stage (%S)", Parameter.PARAMID_STAGE);
        ParameterString parameterString3 = new ParameterString("Cumulative Local Stage (%S)", Parameter.PARAMID_STAGE);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            Object object2 = (JunctionElement)((Vector)object).elementAt(i);
            objectArray[n][0] = object2.getName();
            objectArray[n][4] = string;
            ++n;
            TSRecordProxy tSRecordProxy = ((Element)object2).getFunction().getTSRecordProxy(66);
            if (tSRecordProxy == null) continue;
            object2 = "REG|" + tSRecordProxy.getName() + "|" + tSRecordProxy.getParamName();
            object2 = (double[])map.get(object2);
            objectArray[n][0] = parameterString;
            if (object2 != null) {
                objectArray[n][1] = new ParamDouble((double)object2[0], Parameter.PARAMID_FLOW, this.m_unitSystem, 1);
                objectArray[n][2] = new ParamDouble((double)object2[2], Parameter.PARAMID_FLOW, this.m_unitSystem, 1);
                objectArray[n][3] = new ParamDouble((double)object2[1], Parameter.PARAMID_FLOW, this.m_unitSystem, 1);
            }
            object2 = "UNREG|" + tSRecordProxy.getName() + "|" + tSRecordProxy.getParamName();
            object2 = (double[])map.get(object2);
            objectArray[++n][0] = parameterString2;
            if (object2 != null) {
                objectArray[n][1] = new ParamDouble((double)object2[0], Parameter.PARAMID_FLOW, this.m_unitSystem, 1);
                objectArray[n][2] = new ParamDouble((double)object2[2], Parameter.PARAMID_FLOW, this.m_unitSystem, 1);
                objectArray[n][3] = new ParamDouble((double)object2[1], Parameter.PARAMID_FLOW, this.m_unitSystem, 1);
            }
            object2 = "CUMLOC|" + tSRecordProxy.getName() + "|" + tSRecordProxy.getParamName();
            object2 = (double[])map.get(object2);
            objectArray[++n][0] = parameterString3;
            if (object2 != null) {
                objectArray[n][1] = new ParamDouble((double)object2[0], Parameter.PARAMID_FLOW, this.m_unitSystem, 1);
                objectArray[n][2] = new ParamDouble((double)object2[2], Parameter.PARAMID_FLOW, this.m_unitSystem, 1);
                objectArray[n][3] = new ParamDouble((double)object2[1], Parameter.PARAMID_FLOW, this.m_unitSystem, 1);
            }
            ++n;
        }
        return objectArray;
    }

    public Object[][] getStageSummaryStrArray(RssSystem object, String object2, RssRun rssRun, String string) {
        if (object == null || rssRun == null || object2 == null) {
            return null;
        }
        ((RssSystem)object).updateTSProxyList();
        object = ((RssSystem)object).getElementVectorByClass(JunctionElement.class.getName());
        for (int i = ((Vector)object).size() - 1; i >= 0; --i) {
            if (((JunctionElement)((Vector)object).elementAt(i)).hasRatingCurve()) continue;
            ((Vector)object).removeElementAt(i);
        }
        if (((Vector)object).size() <= 0) {
            Object[][] objectArray = new String[][]{{"No Stage Data Computed", null, "1"}};
            return objectArray;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            vector.addElement(((Element)((Vector)object).get(i)).getName());
        }
        RMASort.quickSort(vector, (List)object);
        Object[][] objectArray = new Object[((Vector)object).size() << 2][3];
        int n = 0;
        String string2 = "1";
        ParameterString parameterString = new ParameterString("Regulated Stage (%S)", Parameter.PARAMID_FLOW);
        ParameterString parameterString2 = new ParameterString("Unregulated Stage (%S)", Parameter.PARAMID_FLOW);
        ParameterString parameterString3 = new ParameterString("Cumulative Local Stage (%S)", Parameter.PARAMID_FLOW);
        HecTime hecTime = new HecTime((String)object2);
        DSSManager dSSManager = rssRun.getDSSFileManager();
        DSSIdentifier dSSIdentifier = new DSSIdentifier();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            double d;
            object2 = (JunctionElement)((Vector)object).elementAt(i);
            objectArray[n][0] = object2.getName();
            objectArray[n][2] = string2;
            ++n;
            TSRecordProxy tSRecordProxy = ((Element)object2).getFunction().getTSRecordProxy(66);
            if (tSRecordProxy == null) continue;
            object2 = "REG|" + tSRecordProxy.getName() + "|" + tSRecordProxy.getParamName();
            Hashtable hashtable = this._collectionRunMap.get(string);
            object2 = (double[])hashtable.get(object2);
            objectArray[n][0] = parameterString;
            if (object2 != null) {
                object2 = rssRun.getRegOutputTSData();
                d = this.getDataPoint((TSDataSet)object2, tSRecordProxy, hecTime, dSSIdentifier, dSSManager);
                objectArray[n][1] = new ParamDouble(d, Parameter.PARAMID_FLOW, this.m_unitSystem, 1);
            }
            object2 = "UNREG|" + tSRecordProxy.getName() + "|" + tSRecordProxy.getParamName();
            object2 = (double[])hashtable.get(object2);
            objectArray[++n][0] = parameterString2;
            if (object2 != null) {
                object2 = rssRun.getUnregOutputTSData();
                d = this.getDataPoint((TSDataSet)object2, tSRecordProxy, hecTime, dSSIdentifier, dSSManager);
                objectArray[n][1] = new ParamDouble(d, Parameter.PARAMID_FLOW, this.m_unitSystem, 1);
            }
            object2 = "CUMLOC|" + tSRecordProxy.getName() + "|" + tSRecordProxy.getParamName();
            object2 = (double[])hashtable.get(object2);
            objectArray[++n][0] = parameterString3;
            if (object2 != null) {
                object2 = rssRun.getCumLocOutputTSData();
                d = this.getDataPoint((TSDataSet)object2, tSRecordProxy, hecTime, dSSIdentifier, dSSManager);
                objectArray[n][1] = new ParamDouble(d, Parameter.PARAMID_FLOW, this.m_unitSystem, 1);
            }
            ++n;
        }
        return objectArray;
    }

    public Object[][] getPowerSummaryStrArray(RssSystem rssSystem, String object) {
        if ((object = (Map)this._collectionRunMap.get(object)) != null) {
            return this.getPowerSummaryStrArray(rssSystem, (Map)object);
        }
        if (this._tsSummaryTable != null) {
            return this.getPowerSummaryStrArray(rssSystem, this._tsSummaryTable);
        }
        return null;
    }

    public Object[][] getPowerSummaryStrArray(RssSystem object, Map map) {
        int n;
        Object[] objectArray;
        if (object == null) {
            return null;
        }
        ((RssSystem)object).updateTSProxyList();
        object = ((RssSystem)object).getElementVectorByClass(ReservoirElement.class.getName());
        if (((Vector)object).size() <= 0) {
            Object[][] objectArray2 = new String[][]{{"No Reservoirs Computed", null, null, null, "1"}};
            return objectArray2;
        }
        Object object2 = new Vector<String>();
        Object object3 = ((Vector)object).elements();
        while (object3.hasMoreElements()) {
            ((Vector)object2).addElement(((Element)object3.nextElement()).getName());
        }
        RMASort.quickSort(object2, (List)object);
        object3 = new Vector();
        object2 = "1";
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            NamedType namedType;
            objectArray = (Object[])((Vector)object).elementAt(i);
            Vector vector = objectArray.getElementsByClass(AdjustableFlow.class, null);
            for (n = vector.size() - 1; n >= 0; --n) {
                namedType = (Element)vector.elementAt(n);
                if (((AdjustableFlow)namedType.getFunction()).hasPowerPlant()) continue;
                vector.removeElementAt(n);
            }
            if (vector.size() <= 0) continue;
            for (n = 0; n < vector.size(); ++n) {
                namedType = (Element)vector.elementAt(n);
                String string = namedType.getDisplayName();
                Object[] objectArray3 = new Object[5];
                objectArray = objectArray3;
                objectArray3[0] = string;
                objectArray[4] = object2;
                ((Vector)object3).add(objectArray);
                namedType = namedType.getFunction();
                objectArray = new Object[5];
                if (this.fillSummaryRow((RssTSLocation)namedType, 50, "REG", objectArray, map)) {
                    ((Vector)object3).add(objectArray);
                }
                if (this.fillSummaryRow((RssTSLocation)namedType, 51, "REG", objectArray = new Object[5], map)) {
                    ((Vector)object3).add(objectArray);
                }
                if (this.fillSummaryRow((RssTSLocation)namedType, 52, "REG", objectArray = new Object[5], map)) {
                    ((Vector)object3).add(objectArray);
                }
                if (this.fillSummaryRow((RssTSLocation)namedType, 53, "REG", objectArray = new Object[5], map)) {
                    ((Vector)object3).add(objectArray);
                }
                if (this.fillSummaryRow((RssTSLocation)namedType, 54, "REG", objectArray = new Object[5], map)) {
                    ((Vector)object3).add(objectArray);
                }
                if (this.fillSummaryRow((RssTSLocation)namedType, 55, "REG", objectArray = new Object[5], map)) {
                    ((Vector)object3).add(objectArray);
                }
                if (!this.fillSummaryRow((RssTSLocation)namedType, 56, "REG", objectArray = new Object[5], map)) continue;
                ((Vector)object3).add(objectArray);
            }
        }
        if (((Vector)object3).size() <= 0) {
            Object[][] objectArray4 = new String[][]{{"No Power Data", null, null, null, "1"}};
            return objectArray4;
        }
        Object[][] objectArray5 = new Object[((Vector)object3).size()][5];
        for (int i = 0; i < ((Vector)object3).size(); ++i) {
            objectArray = (Object[])((Vector)object3).elementAt(i);
            for (n = 0; n < 5; ++n) {
                objectArray5[i][n] = objectArray[n];
            }
        }
        return objectArray5;
    }

    public Object[][] getPowerSummaryStrArray(RssSystem object, String string, RssRun rssRun, String objectArray) {
        int n;
        if (object == null || rssRun == null || string == null) {
            return null;
        }
        ((RssSystem)object).updateTSProxyList();
        object = ((RssSystem)object).getElementVectorByClass(ReservoirElement.class.getName());
        if (((Vector)object).size() <= 0) {
            Object[][] objectArray2 = new String[][]{{"No Reservoirs Computed", null, "1"}};
            return objectArray2;
        }
        Object object2 = new Vector<String>();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            ((Vector)object2).addElement(((Element)((Vector)object).get(i)).getName());
        }
        RMASort.quickSort(object2, (List)object);
        Vector<Object[]> vector = new Vector<Object[]>();
        object2 = "1";
        DSSManager dSSManager = rssRun.getDSSFileManager();
        Hashtable hashtable = this._collectionRunMap.get(objectArray);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            Element element;
            objectArray = (ReservoirElement)((Vector)object).elementAt(i);
            Vector vector2 = objectArray.getElementsByClass(AdjustableFlow.class, null);
            for (n = vector2.size() - 1; n >= 0; --n) {
                element = (Element)vector2.elementAt(n);
                if (((AdjustableFlow)element.getFunction()).hasPowerPlant()) continue;
                vector2.removeElementAt(n);
            }
            if (vector2.size() <= 0) continue;
            HecTime hecTime = new HecTime(string);
            element = rssRun.getRegOutputTSData();
            for (int j = 0; j < vector2.size(); ++j) {
                NamedType namedType = (Element)vector2.elementAt(j);
                String string2 = namedType.getDisplayName();
                Object[] objectArray3 = new Object[3];
                objectArray = objectArray3;
                objectArray3[0] = string2;
                objectArray[2] = object2;
                vector.add(objectArray);
                namedType = namedType.getFunction();
                objectArray = new Object[3];
                if (this.fillSummaryRow((RssTSLocation)namedType, 50, "REG", objectArray, (TSDataSet)element, hecTime, dSSManager)) {
                    vector.add(objectArray);
                }
                if (this.fillSummaryRow((RssTSLocation)namedType, 51, "REG", objectArray = new Object[3], (TSDataSet)element, hecTime, dSSManager)) {
                    vector.add(objectArray);
                }
                if (this.fillSummaryRow((RssTSLocation)namedType, 52, "REG", objectArray = new Object[3], hashtable)) {
                    vector.add(objectArray);
                }
                if (this.fillSummaryRow((RssTSLocation)namedType, 53, "REG", objectArray = new Object[3], (TSDataSet)element, hecTime, dSSManager)) {
                    vector.add(objectArray);
                }
                if (this.fillSummaryRow((RssTSLocation)namedType, 54, "REG", objectArray = new Object[3], (TSDataSet)element, hecTime, dSSManager)) {
                    vector.add(objectArray);
                }
                if (this.fillSummaryRow((RssTSLocation)namedType, 55, "REG", objectArray = new Object[3], (TSDataSet)element, hecTime, dSSManager)) {
                    vector.add(objectArray);
                }
                if (!this.fillSummaryRow((RssTSLocation)namedType, 56, "REG", objectArray = new Object[3], (TSDataSet)element, hecTime, dSSManager)) continue;
                vector.add(objectArray);
            }
        }
        if (vector.size() <= 0) {
            Object[][] objectArray4 = new String[][]{{"No Power Data", null, "1"}};
            return objectArray4;
        }
        Object[][] objectArray5 = new Object[vector.size()][5];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray = (Object[])vector.elementAt(i);
            for (n = 0; n < 5; ++n) {
                objectArray5[i][n] = objectArray[n];
            }
        }
        return objectArray5;
    }

    private boolean fillSummaryRow(RssTSLocation object, int n, String string, Object[] objectArray, Map map) {
        if ((object = object.getTSRecordProxy(n)) == null) {
            return false;
        }
        ModelVariable modelVariable = RssModelVariableSet.getModelVariable(n);
        if (modelVariable == null) {
            return false;
        }
        object = string + "|" + object.getName() + "|" + object.getParamName();
        object = (double[])map.get(object);
        int n2 = modelVariable.getParamId();
        if (n2 == -1) {
            objectArray[0] = modelVariable.getName();
        } else {
            modelVariable = new ParameterString(modelVariable.getName() + " (%S)", n2);
            objectArray[0] = modelVariable;
        }
        if (object != null) {
            objectArray[1] = new ParamDouble((double)object[0], n2, this.m_unitSystem, 2);
            objectArray[2] = new ParamDouble((double)object[2], n2, this.m_unitSystem, 2);
            objectArray[3] = new ParamDouble((double)object[1], n2, this.m_unitSystem, 2);
        }
        return true;
    }

    private boolean fillSummaryRow(RssTSLocation rssTSLocation, int n, String string, Object[] objectArray, TSDataSet tSDataSet, HecTime hecTime, DSSManager dSSManager) {
        if ((rssTSLocation = rssTSLocation.getTSRecordProxy(n)) == null) {
            return false;
        }
        ModelVariable modelVariable = RssModelVariableSet.getModelVariable(n);
        if (modelVariable == null) {
            return false;
        }
        int n2 = modelVariable.getParamId();
        if (n2 == -1) {
            objectArray[0] = modelVariable.getName();
        } else {
            ParameterString parameterString = new ParameterString(modelVariable.getName() + " (%S)", n2);
            objectArray[0] = parameterString;
        }
        modelVariable = new DSSIdentifier();
        double d = this.getDataPoint(tSDataSet, (TSRecordProxy)rssTSLocation, hecTime, (DSSIdentifier)modelVariable, dSSManager);
        objectArray[1] = new ParamDouble(d, n2, this.m_unitSystem, 1);
        return true;
    }

    public Object[][] getGatesSummaryStrArray(RssSystem rssSystem, String object) {
        if ((object = (Map)this._collectionRunMap.get(object)) != null) {
            return this.getGatesSummaryStrArray(rssSystem, (Map)object);
        }
        if (this._tsSummaryTable != null) {
            return this.getGatesSummaryStrArray(rssSystem, this._tsSummaryTable);
        }
        return null;
    }

    public Object[][] getGatesSummaryStrArray(RssSystem object, Map map) {
        int n;
        Object[] objectArray;
        if (object == null) {
            return null;
        }
        ((RssSystem)object).updateTSProxyList();
        object = ((RssSystem)object).getElementVectorByClass(ReservoirElement.class.getName());
        if (((Vector)object).size() <= 0) {
            Object[][] objectArray2 = new String[][]{{"No Reservoirs Computed", null, null, null, "1"}};
            return objectArray2;
        }
        Object object2 = new Vector<String>();
        Object object3 = ((Vector)object).elements();
        while (object3.hasMoreElements()) {
            ((Vector)object2).addElement(((Element)object3.nextElement()).getName());
        }
        RMASort.quickSort(object2, (List)object);
        object3 = new Vector();
        object2 = "1";
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            NamedType namedType;
            objectArray = (Object[])((Vector)object).elementAt(i);
            Vector vector = objectArray.getElementsByClass(AdjustableFlow.class, null);
            for (n = vector.size() - 1; n >= 0; --n) {
                namedType = (Element)vector.elementAt(n);
                if (((AdjustableFlow)namedType.getFunction()).hasMultipleGateSettings()) continue;
                vector.removeElementAt(n);
            }
            if (vector.size() <= 0) continue;
            for (n = 0; n < vector.size(); ++n) {
                namedType = (Element)vector.elementAt(n);
                String string = namedType.getDisplayName();
                Object[] objectArray3 = new Object[5];
                objectArray = objectArray3;
                objectArray3[0] = string;
                objectArray[4] = object2;
                ((Vector)object3).add(objectArray);
                namedType = (AdjustableFlow)namedType.getFunction();
                objectArray = new Object[5];
                if (namedType.getGateSettingsParamId() == Parameter.PARAMID_PERCENT) {
                    if (!this.fillSummaryRow((RssTSLocation)namedType, 32, "REG", objectArray, map)) continue;
                    ((Vector)object3).add(objectArray);
                    continue;
                }
                if (!this.fillSummaryRow((RssTSLocation)namedType, 31, "REG", objectArray, map)) continue;
                ((Vector)object3).add(objectArray);
            }
        }
        if (((Vector)object3).size() <= 0) {
            Object[][] objectArray4 = new String[][]{{"No Gate Setting Data", null, null, null, "1"}};
            return objectArray4;
        }
        Object[][] objectArray5 = new Object[((Vector)object3).size()][5];
        for (int i = 0; i < ((Vector)object3).size(); ++i) {
            objectArray = (Object[])((Vector)object3).elementAt(i);
            for (n = 0; n < 5; ++n) {
                objectArray5[i][n] = objectArray[n];
            }
        }
        return objectArray5;
    }

    public Object[][] getGatesSummaryStrArray(RssSystem object, String objectArray, RssRun rssRun, String objectArray2) {
        int n;
        if (object == null || rssRun == null || objectArray == null) {
            return null;
        }
        ((RssSystem)object).updateTSProxyList();
        object = ((RssSystem)object).getElementVectorByClass(ReservoirElement.class.getName());
        if (((Vector)object).size() <= 0) {
            objectArray = new String[][]{{"No Reservoirs Computed", null, "1"}};
            return objectArray;
        }
        objectArray = new Vector();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            objectArray.addElement(((Element)((Vector)object).get(i)).getName());
        }
        RMASort.quickSort((List)objectArray, (List)object);
        Vector<Object[]> vector = new Vector<Object[]>();
        objectArray = "1";
        Hashtable hashtable = this._collectionRunMap.get(objectArray2);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            NamedType namedType;
            objectArray2 = (ReservoirElement)((Vector)object).elementAt(i);
            Vector vector2 = objectArray2.getElementsByClass(AdjustableFlow.class, null);
            for (n = vector2.size() - 1; n >= 0; --n) {
                namedType = (Element)vector2.elementAt(n);
                if (((AdjustableFlow)namedType.getFunction()).hasMultipleGateSettings()) continue;
                vector2.removeElementAt(n);
            }
            if (vector2.size() <= 0) continue;
            for (n = 0; n < vector2.size(); ++n) {
                namedType = (Element)vector2.elementAt(n);
                String string = namedType.getDisplayName();
                Object[] objectArray3 = new Object[3];
                objectArray2 = objectArray3;
                objectArray3[0] = string;
                objectArray2[2] = objectArray;
                vector.add(objectArray2);
                namedType = (AdjustableFlow)namedType.getFunction();
                objectArray2 = new Object[3];
                if (namedType.getGateSettingsParamId() == Parameter.PARAMID_PERCENT) {
                    if (!this.fillSummaryRow((RssTSLocation)namedType, 32, "REG", objectArray2, hashtable)) continue;
                    vector.add(objectArray2);
                    continue;
                }
                if (!this.fillSummaryRow((RssTSLocation)namedType, 31, "REG", objectArray2, hashtable)) continue;
                vector.add(objectArray2);
            }
        }
        if (vector.size() <= 0) {
            Object[][] objectArray4 = new String[][]{{"No Gate Setting Data", null, "1"}};
            return objectArray4;
        }
        Object[][] objectArray5 = new Object[vector.size()][3];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray2 = (Object[])vector.elementAt(i);
            for (n = 0; n < 3; ++n) {
                objectArray5[i][n] = objectArray2[n];
            }
        }
        return objectArray5;
    }

    public void addTSRecordSummaryTable(String string, Hashtable hashtable) {
        Hashtable hashtable2 = this._collectionRunMap.get(string);
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
            this._collectionRunMap.put(string, hashtable2);
        }
        hashtable2.putAll(hashtable);
    }

    public void notify(String string) {
        int n;
        if (string == null) {
            return;
        }
        System.out.println("Call back message: " + string);
        if (!string.equalsIgnoreCase("modified")) {
            return;
        }
        if (string.startsWith("Modified") && (n = string.indexOf("|")) >= 0) {
            string = string.substring(n + 1);
            if (UserId.getUserId().equals(string) && string.indexOf("-") != -1 && string.indexOf("#") != -1) {
                return;
            }
        }
        try {
            RssOutput rssOutput = this;
            rssOutput.readFile(rssOutput._identifier);
            return;
        }
        catch (Exception exception) {
            System.out.println(this.getName() + ".notify: Error on reLoadFile " + String.valueOf(exception));
            return;
        }
    }

    public void removeCallBack() {
        if (this._callBack != null && this._identifier != null) {
            HecFile hecFile = this._identifier.getFile();
            if (hecFile instanceof HecFileImpl) {
                RemoteWrapper remoteWrapper = this._callBack.getRemoteReference();
                ((HecFileImpl)hecFile).removeCallBack(remoteWrapper);
            }
            this._callBack = null;
        }
    }

    public void setIdentifier(Identifier identifier) {
        this.setName(identifier.getName());
        this._identifier = identifier;
        try {
            this._callBack = new RmiFileCallBackImpl((CallBackInterface)this);
        }
        catch (RemoteException remoteException) {
            System.out.println("Exception: " + String.valueOf(remoteException));
            remoteException.printStackTrace();
        }
        identifier = this._callBack.getRemoteReference();
        HecFile hecFile = this._identifier.getFile();
        if (hecFile instanceof HecFileImpl) {
            ((HecFileImpl)hecFile).setCallBack((RemoteWrapper)identifier);
        }
    }

    public boolean readFile() {
        RssOutput rssOutput = this;
        return rssOutput.readFile(rssOutput._identifier);
    }

    public boolean readFile(Identifier identifier) {
        Object object = identifier.getFile();
        if (object == null) {
            return false;
        }
        System.out.println("opening " + object.getPath());
        try {
            object = object.getBufferedReader();
            HecAsciiDeserializer hecAsciiDeserializer = new HecAsciiDeserializer((BufferedReader)object);
            hecAsciiDeserializer.deserializeObject((Object)this);
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {
            System.out.println("Failed to open file " + identifier.getPath());
            return false;
        }
        this.setModified(false);
        return true;
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

