/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.io.DSSIdentifier;
import hec.model.ModelVariable;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.RunTimeStep;
import hec.model.TSLocation;
import hec.rss.model.Element;
import hec.rss.model.IndependentVariable;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.StateVariable;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import rma.util.DSSPathPartGenerator;
import rma.util.RMAConst;

public class RssRatingObject
extends RssTSLocationObject
implements AsciiSerializable,
RssModelVariableConstants,
AltInputReportInfc,
Serializable,
Cloneable {
    Element _element;
    String _ratingName;
    boolean _usesRatingCurveElev = false;
    PairedValues _ratingCurve = new PairedValues();
    double _stageDatum = 0.0;
    IndependentVariable _independentVariable;
    boolean _usesIndependentVariable;
    boolean _outOfRangeToMissing = false;
    private PairedValues _ivPairedValues = new PairedValues();
    private PairedValuesExt _ivPairedValuesExt = new PairedValuesExt();
    private transient doubleArrayContainer a;

    public RssRatingObject() {
    }

    public RssRatingObject(Element element) {
        this._element = element;
    }

    protected String getOutputBPart() {
        ArrayList<String> arrayList = this.getElement().getFullNameList();
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        arrayList.add("TAILWATER");
        return this.getElement().getSystem().generateUniquePathPart(arrayList, "-");
    }

    public void setupForSerialization() {
        Object object;
        String string = this.getElement().getTopParent().getName();
        String string2 = "";
        Element element = this.getElement().getParent();
        if (element != null) {
            string2 = element.getName();
        }
        if (string2.equalsIgnoreCase(string)) {
            string2 = "";
        }
        element = new DSSPathname();
        DSSPathPartGenerator dSSPathPartGenerator = new DSSPathPartGenerator();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        string = dSSPathPartGenerator.generatePathnamePart(arrayList, "");
        element.setAPart(string);
        string = this.getElement().getSystem().getDssPairedDataFilePath();
        element.getPathname();
        if (this._ratingCurve != null) {
            arrayList.clear();
            if (string2.length() > 0) {
                arrayList.add(string2);
            }
            arrayList.add(this.getRatingName());
            object = dSSPathPartGenerator.generatePathnamePart(arrayList, "-");
            element.setBPart((String)object);
            object = Parameter.getParamString((int)Parameter.PARAMID_STAGE) + "-" + Parameter.getParamString((int)Parameter.PARAMID_FLOW);
            element.setCPart((String)object);
            this._ratingCurve.setParamXId(Parameter.PARAMID_STAGE);
            this._ratingCurve.setParamYId(Parameter.PARAMID_FLOW);
            this._ratingCurve.setUnitSystem(this.getElement().getUnitSystem());
        }
        if (this._independentVariable != null) {
            String string3;
            if (this._ivPairedValuesExt != null && this._ivPairedValuesExt.size() > 0) {
                this._ivPairedValuesExt.setParamYId(Parameter.PARAMID_STAGE);
                this._ivPairedValuesExt.setParamXId(Parameter.PARAMID_FLOW);
                this._ivPairedValuesExt.setUnitSystem(this.getElement().getUnitSystem());
                arrayList.clear();
                if (string2.length() > 0) {
                    arrayList.add(string2);
                }
                arrayList.add(this.getRatingName());
                arrayList.add("IV_3VAR");
                object = dSSPathPartGenerator.generatePathnamePart(arrayList, "-");
                element.setBPart((String)object);
                object = this._ivPairedValuesExt.getParamXString();
                string3 = this._ivPairedValuesExt.getParamYString();
                object = (String)object + "-" + string3;
                element.setCPart((String)object);
                object = element.getPathname();
                this._ivPairedValuesExt.setDssIdentifier(new DSSIdentifier(string, (String)object));
            }
            if (this._ivPairedValues != null && this._ivPairedValues.size() > 0) {
                arrayList.clear();
                if (string2.length() > 0) {
                    arrayList.add(string2);
                }
                arrayList.add(this.getRatingName());
                arrayList.add("IV");
                object = dSSPathPartGenerator.generatePathnamePart(arrayList, "-");
                element.setBPart((String)object);
                object = this._ivPairedValues.getParamXString();
                string3 = this._ivPairedValues.getParamYString();
                object = (String)object + "-" + string3;
                element.setCPart((String)object);
                object = element.getPathname();
                this._ivPairedValues.setUnitSystem(this.getElement().getUnitSystem());
                this._ivPairedValues.setDssIdentifer(new DSSIdentifier(string, (String)object));
            }
        }
    }

    public void setOutOfRangeValuesToMissing(boolean bl) {
        this._outOfRangeToMissing = bl;
    }

    public boolean getOutOfRangeValuesToMissing() {
        return this._outOfRangeToMissing;
    }

    @Override
    public synchronized Object clone() {
        RssRatingObject rssRatingObject = (RssRatingObject)super.clone();
        ((RssRatingObject)super.clone())._ratingCurve = (PairedValues)this._ratingCurve.clone();
        if (rssRatingObject._independentVariable != null) {
            rssRatingObject._independentVariable = (IndependentVariable)this._independentVariable.clone();
        }
        rssRatingObject._ivPairedValues = (PairedValues)this._ivPairedValues.clone();
        rssRatingObject._ivPairedValuesExt = this._ivPairedValuesExt.clone();
        return rssRatingObject;
    }

    public void initialize() {
        if (this._usesIndependentVariable && this._independentVariable != null) {
            this._independentVariable.initializeCompute(this._element.getSystem(), this);
        }
    }

    public void setElement(Element element) {
        this._element = element;
    }

    public Element getElement() {
        return this._element;
    }

    public void setRatingName(String string) {
        this._ratingName = string;
    }

    public String getRatingName() {
        return this._ratingName;
    }

    public double getElevation(double d) {
        double d2 = -3.4028234663852886E38;
        if (this._usesRatingCurveElev && this._ratingCurve != null) {
            if (this._ratingCurve.isXValueOutOfRange(d)) {
                return -3.4028234663852886E38;
            }
            double d3 = this._ratingCurve.getXValue(d);
            double d4 = 0.0;
            if (RMAConst.isValidValue((double)this._stageDatum)) {
                d4 = this._stageDatum;
            }
            d2 = d3 + d4;
        }
        return d2;
    }

    public boolean isEmpty() {
        return this._ivPairedValues.size() <= 0 && this._ivPairedValuesExt.size() <= 0;
    }

    public double getElevation(RunTimeStep runTimeStep, double d) {
        double d2 = -3.4028234663852886E38;
        if (this._usesRatingCurveElev || this._usesIndependentVariable) {
            if (this._usesIndependentVariable && this._independentVariable != null) {
                double d3 = this.getIndpVarValue(runTimeStep, false);
                d2 = RMAConst.isValidValue((double)this._stageDatum) ? d3 + this._stageDatum : d3;
            } else if (this._usesRatingCurveElev && this._ratingCurve != null) {
                if (this._ratingCurve.isXValueOutOfRange(d)) {
                    return -3.4028234663852886E38;
                }
                double d4 = this._ratingCurve.getYValue(d);
                double d5 = 0.0;
                if (RMAConst.isValidValue((double)this._stageDatum)) {
                    d5 = this._stageDatum;
                }
                d2 = d4 + d5;
            }
        }
        return d2;
    }

    public double getFlowFromStage(RunTimeStep runTimeStep, double d) {
        double d2 = Double.NEGATIVE_INFINITY;
        if (this._usesRatingCurveElev || this._usesIndependentVariable) {
            if (this._usesIndependentVariable && this._independentVariable != null) {
                d2 = this.getInpVarFlow(runTimeStep, d);
            } else if (this._usesRatingCurveElev && this._ratingCurve != null) {
                if (this._ratingCurve.isXValueOutOfRange(d)) {
                    return Double.NEGATIVE_INFINITY;
                }
                d2 = this._ratingCurve.getYValue(d);
            }
        }
        return d2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected double getIndpVarValue(RunTimeStep runTimeStep, boolean bl) {
        if (this._independentVariable == null) {
            return -3.4028234663852886E38;
        }
        switch (this._independentVariable.getType()) {
            case 2: 
            case 3: {
                double d = this._independentVariable.evaluateTSFunction(runTimeStep);
                if (d == Double.NEGATIVE_INFINITY) return -3.4028234663852886E38;
                if (d == -3.4028234663852886E38) {
                    return -3.4028234663852886E38;
                }
                if (this._independentVariable.getType() == 3 && this._independentVariable.isTSOptChecked()) {
                    return d;
                }
                if (!this._outOfRangeToMissing) return this._ivPairedValues.interpolate(d);
                if (!this._ivPairedValues.isXValueOutOfRange(d)) return this._ivPairedValues.interpolate(d);
                return -3.4028234663852886E38;
            }
            case 4: 
            case 6: {
                if (runTimeStep.flag != 0) return -3.4028234663852886E38;
                double d = this._independentVariable.evaluateTSFunction(runTimeStep);
                if (d == Double.NEGATIVE_INFINITY) return -3.4028234663852886E38;
                if (d == -3.4028234663852886E38) {
                    return -3.4028234663852886E38;
                }
                if (!this._outOfRangeToMissing) return this._ivPairedValues.interpolate(d);
                if (!this._ivPairedValues.isXValueOutOfRange(d)) return this._ivPairedValues.interpolate(d);
                return -3.4028234663852886E38;
            }
            case 5: {
                RssRatingObject rssRatingObject = this;
                return rssRatingObject.getTwoVarValue(rssRatingObject._independentVariable.getRowVariable(), this._independentVariable.getColVariable(), runTimeStep, bl);
            }
            default: {
                return -3.4028234663852886E38;
            }
        }
    }

    protected double getTwoVarValue(IndependentVariable independentVariable, IndependentVariable independentVariable2, RunTimeStep runTimeStep, boolean bl) {
        if (independentVariable == null || independentVariable2 == null) {
            return -3.4028234663852886E38;
        }
        double d = -3.4028234663852886E38;
        double d2 = Double.NEGATIVE_INFINITY;
        switch (independentVariable2.getType()) {
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                d2 = independentVariable2.evaluateTSFunction(runTimeStep);
                if (d2 != Double.NEGATIVE_INFINITY && d2 != -3.4028234663852886E38) break;
                d = -3.4028234663852886E38;
            }
        }
        switch (independentVariable.getType()) {
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                double d3 = independentVariable.evaluateTSFunction(runTimeStep);
                if (this._outOfRangeToMissing && (this._ivPairedValuesExt.isXValueOutOfRange(d3) || this._ivPairedValuesExt.isZValueOutOfRange(d2))) {
                    return -3.4028234663852886E38;
                }
                d = this._ivPairedValuesExt.interpolate(d3, d2);
            }
        }
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected double getInpVarFlow(RunTimeStep runTimeStep, double d) {
        if (this._independentVariable == null) return -3.4028234663852886E38;
        if (!RMAConst.isValidValue((double)d)) {
            return -3.4028234663852886E38;
        }
        double d2 = -3.4028234663852886E38;
        switch (this._independentVariable.getType()) {
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                if (!this._outOfRangeToMissing) return this._ivPairedValues.interpolateY(d);
                if (this._ivPairedValues.isYValueOutOfRange(d)) return -3.4028234663852886E38;
                return this._ivPairedValues.interpolateY(d);
            }
            case 5: {
                IndependentVariable independentVariable = this._independentVariable.getColVariable();
                switch (independentVariable.getType()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        double d3 = independentVariable.evaluateTSFunction(runTimeStep);
                        d2 = !RMAConst.isValidValue((double)d3) ? -3.4028234663852886E38 : this._ivPairedValuesExt.interpolateY(d, d3);
                    }
                }
                return d2;
            }
            default: {
                return -3.4028234663852886E38;
            }
        }
    }

    public boolean isDefined(RunTimeStep runTimeStep) {
        if (this._usesRatingCurveElev && this._ratingCurve != null) {
        }
        return false;
    }

    public boolean usesRatingCurveElev() {
        return this._usesRatingCurveElev;
    }

    public void setUsesRatingCurveElev(boolean bl) {
        this._usesRatingCurveElev = bl;
    }

    public PairedValues getRatingCurve() {
        this._ratingCurve.setUnitSystem(this._element.getUnitSystem());
        this._ratingCurve.setParamXId(Parameter.PARAMID_STAGE);
        this._ratingCurve.setParamYId(Parameter.PARAMID_FLOW);
        return (PairedValues)this._ratingCurve.clone();
    }

    public void setRatingCurve(PairedValues pairedValues) {
        if (pairedValues == null) {
            return;
        }
        this._ratingCurve = pairedValues;
        this._ratingCurve.setUnitSystem(this._element.getUnitSystem());
        this._ratingCurve.setParamXId(Parameter.PARAMID_STAGE);
        this._ratingCurve.setParamYId(Parameter.PARAMID_FLOW);
    }

    public void getStageDatum(ParamDouble paramDouble) {
        paramDouble.setValue(this._stageDatum);
        paramDouble.setUnitSystem(this._element.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_ELEV);
    }

    public void setStageDatum(ParamDouble paramDouble) {
        this._stageDatum = paramDouble.getValue();
    }

    public void setStageDatum(double d) {
        this._stageDatum = d;
    }

    public PairedValuesExt getIndependentVariableRatingCurveExt() {
        this._ivPairedValuesExt.setUnitSystem(this._element.getUnitSystem());
        this._ivPairedValuesExt.setParamYId(Parameter.PARAMID_STAGE);
        return this._ivPairedValuesExt.clone();
    }

    public void setIndependentVariableRatingCurveExt(PairedValuesExt pairedValuesExt) {
        if (pairedValuesExt == null) {
            return;
        }
        this._ivPairedValuesExt = pairedValuesExt;
        this._ivPairedValuesExt.setUnitSystem(this._element.getUnitSystem());
        this._ivPairedValuesExt.setParamYId(Parameter.PARAMID_STAGE);
    }

    public PairedValues getIndependentVariableRatingCurve() {
        this._ivPairedValues.setUnitSystem(this._element.getUnitSystem());
        this._ivPairedValues.setParamYId(Parameter.PARAMID_STAGE);
        this._ivPairedValues.setParamXId(Parameter.PARAMID_FLOW);
        return (PairedValues)this._ivPairedValues.clone();
    }

    public void setIndependentVariableRatingCurve(PairedValues pairedValues) {
        if (pairedValues == null) {
            return;
        }
        this._ivPairedValues = pairedValues;
        this._ivPairedValues.setUnitSystem(this._element.getUnitSystem());
    }

    public boolean usesIndependentVariable() {
        return this._usesIndependentVariable;
    }

    public void setUsesIndependentVariable(boolean bl) {
        this._usesIndependentVariable = bl;
    }

    public IndependentVariable getIndependentVariable() {
        if (this._independentVariable == null) {
            this._independentVariable = this.getDefaultIndependentVariable();
        }
        return this._independentVariable;
    }

    public void setIndependentVariable(IndependentVariable independentVariable) {
        this._independentVariable = independentVariable;
    }

    public int[] getModelVariableElementIds() {
        if (this._independentVariable != null) {
            return this._independentVariable.getModelVariableElementIds();
        }
        return null;
    }

    public int getDownstreamModelVariableElementId(Element object) {
        int[] nArray = this.getModelVariableElementIds();
        object = ((Element)object).getSystem().getDownstreamElements((Element)object, true);
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                Element element = (Element)((Vector)object).get(j);
                if (element.getIndex() == nArray[i]) {
                    n = nArray[i];
                }
                int n2 = element.getChildElementCount();
                for (int k = 0; k < n2; ++k) {
                    Element element2 = element.getChildElementAt(k);
                    if (element2 == null || element2.getIndex() != nArray[i]) continue;
                    n = element.getIndex();
                }
            }
        }
        return n;
    }

    public IndependentVariable getDefaultIndependentVariable() {
        IndependentVariable independentVariable = new IndependentVariable(2);
        TSLocation tSLocation = this.getElement();
        Element element = tSLocation.getTopParent();
        tSLocation = tSLocation.getDownstreamNode();
        TSRecordProxy tSRecordProxy = null;
        if (tSLocation != null && (tSRecordProxy = tSLocation.getTSRecordProxy(0)) == null) {
            element.updateTSProxyList();
            tSRecordProxy = tSLocation.getTSRecordProxy(0);
        }
        tSLocation = new ModelVariable("Node", "Flow", 0, Parameter.PARAMID_FLOW);
        independentVariable.setModalVariableInfo(tSRecordProxy, element, (ModelVariable)tSLocation);
        return independentVariable;
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        if (n == 0) {
            if (this._element == null) {
                return vector;
            }
            TSRecordProxy tSRecordProxy = this._element.getFunction().getTSRecordProxy(30);
            if (tSRecordProxy != null) {
                vector.addElement(tSRecordProxy);
            }
        }
        return vector;
    }

    public Vector getActiveTSProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        boolean bl = false;
        if (n == 1) {
            bl = true;
        }
        int n2 = this._tsrecordVector.size();
        for (n = 0; n < n2; ++n) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(n);
            if (tSRecordProxy.isInput() != bl) continue;
            vector.add(tSRecordProxy);
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        String string;
        IndependentVariable independentVariable;
        if (this._element == null) {
            return;
        }
        if (this._tsrecordVector != null) {
            this._tsrecordVector.clear();
        }
        if (this._usesIndependentVariable && this._independentVariable != null && this._independentVariable.getType() == 3 && (independentVariable = this.getTSRecordProxy(string = this._independentVariable.getTimeSeriesName(), 85)) == null) {
            this.addTSRecordProxy(string, 85);
        }
        if (this._usesIndependentVariable && this._independentVariable != null && this._independentVariable.getType() == 5) {
            independentVariable = this._independentVariable.getRowVariable();
            if (independentVariable != null && independentVariable.getType() == 3 && (independentVariable = this.getTSRecordProxy(string = !independentVariable.getTimeSeriesName().isEmpty() ? independentVariable.getTimeSeriesName() : "External Variable", 85)) == null) {
                this.addTSRecordProxy(string, 85);
            }
            if ((independentVariable = this._independentVariable.getColVariable()) != null && independentVariable.getType() == 3 && (independentVariable = this.getTSRecordProxy(string = !independentVariable.getTimeSeriesName().isEmpty() ? independentVariable.getTimeSeriesName() : "External Variable", 85)) == null) {
                this.addTSRecordProxy(string, 85);
            }
        }
    }

    public void getReferencedStateVariables(List list) {
        if (this._independentVariable == null) {
            return;
        }
        RssSystem rssSystem = ((RssTSLocationObject)this).getSystem();
        if (rssSystem == null) {
            return;
        }
        if (this._independentVariable.getType() == 4) {
            StateVariable stateVariable = rssSystem.getStateVariable(this._independentVariable.getStateVariableId());
            if (stateVariable != null && !list.contains(stateVariable)) {
                list.add(stateVariable);
                return;
            }
        } else if (this._independentVariable.getType() == 5) {
            AsciiSerializable asciiSerializable = this._independentVariable.getRowVariable();
            if (asciiSerializable != null && asciiSerializable.getType() == 4 && (asciiSerializable = rssSystem.getStateVariable(asciiSerializable.getStateVariableId())) != null && !list.contains(asciiSerializable)) {
                list.add(asciiSerializable);
            }
            if ((asciiSerializable = this._independentVariable.getColVariable()) != null && asciiSerializable.getType() == 4 && (asciiSerializable = rssSystem.getStateVariable(asciiSerializable.getStateVariableId())) != null && !list.contains(asciiSerializable)) {
                list.add(asciiSerializable);
            }
        }
    }

    @Override
    public RssSystem getSystem() {
        return this._element.getSystem();
    }

    @Override
    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        org.jdom.Element element2;
        element.setAttribute("Use_Simple_Curve", Boolean.toString(this._usesRatingCurveElev));
        if (this._usesRatingCurveElev) {
            element.setAttribute("Stage_Datum", Double.toString(this._stageDatum));
            org.jdom.Element element3 = new org.jdom.Element("Rating_Curve_Flow");
            element.addContent((Content)element3);
            XMLUtilities.createArrayElements((org.jdom.Element)element3, (double[])this._ratingCurve.getXArray());
            element3 = new org.jdom.Element("Rating_Curve_Stage");
            element.addContent((Content)element3);
            XMLUtilities.createArrayElements((org.jdom.Element)element3, (double[])this._ratingCurve.getYArray());
            return;
        }
        if (this._independentVariable != null) {
            element2 = new org.jdom.Element("Independent_Variable");
            element.addContent((Content)element2);
            this._independentVariable.outputReport(alternativeInputReport, element2);
        }
        if (this._ivPairedValuesExt != null && this._ivPairedValuesExt.getXArray() != null) {
            element2 = new org.jdom.Element("Rating_Curve_Flows");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._ivPairedValuesExt.getXArray());
            for (int i = 0; i < this._ivPairedValuesExt.getNumberCurves(); ++i) {
                alternativeInputReport = this._ivPairedValuesExt.getCurve(i);
                element2 = new org.jdom.Element("Rating_Curve_" + Integer.toString(i));
                element.addContent((Content)element2);
                XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])alternativeInputReport.getYArray());
            }
        }
    }
}

