/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import com.google.common.flogger.FluentLogger;
import com.google.common.flogger.StackSize;
import hec.client.RunObserver;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordImpl;
import hec.clientapp.model.TSRecordProxy;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.data.IVerticalDatum;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DssDataType;
import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.DSSPathString;
import hec.lang.ModelReference;
import hec.lang.UserId;
import hec.lang.annotation.Scriptable;
import hec.model.AbstractTSRecord;
import hec.model.ModelVariable;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import hec.model.UserInterface;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.RSS;
import hec.rss.client.reports.ReleaseDecisionReportOptions;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.ComputeStatus;
import hec.rss.model.ControlStructure;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOp;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.DssOutputData;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.GVDataSet;
import hec.rss.model.HindcastData;
import hec.rss.model.Junction;
import hec.rss.model.JunctionElement;
import hec.rss.model.ModelConst;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.OutputVerticalDatumType;
import hec.rss.model.PDCDataSet;
import hec.rss.model.PDCDataSet$RecordBuilder;
import hec.rss.model.PDCRecord;
import hec.rss.model.ReleaseOverrides;
import hec.rss.model.ReleaseOverrides$Overrides;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOutletElement;
import hec.rss.model.ReservoirStorageVsYieldAnalysis;
import hec.rss.model.ReservoirYieldAnalysis;
import hec.rss.model.ReverseReservoirYieldAnalysis;
import hec.rss.model.ReverseWaterAccountYieldAnalysis;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssOutput;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssRun$ErrorMsg;
import hec.rss.model.RssRun$MsgType;
import hec.rss.model.RssRun$TsRecordWithDatumPredicate;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.RssTSRecordImpl;
import hec.rss.model.RunDataRecord;
import hec.rss.model.ScriptOpRule;
import hec.rss.model.Spillway;
import hec.rss.model.StateVariable;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.TsVariant;
import hec.rss.model.VerticalDatumSettings;
import hec.rss.model.VerticalDatumType;
import hec.rss.model.WQUtilities;
import hec.rss.model.WaterAccount;
import hec.rss.model.WaterAccountSet;
import hec.rss.model.WaterAccountYieldAnalysis;
import hec.rss.model.YieldAnalysis;
import hec.rss.model.YieldAnalysisData;
import hec.rss.model.YieldAnalysisRuleRef;
import hec.rss.model.YieldAnalysisType;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableData;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.model.globalvariable.GlobalVariableUtils;
import hec.rss.model.globalvariable.ScalarGlobalVariable;
import hec.rss.model.globalvariable.TableGlobalVariable;
import hec.rss.model.globalvariable.TimeSeriesGlobalVariable;
import hec.rss.model.reports.AltInputReportEnums;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.rss.plugins.factories.AltPluginDataFactory;
import hec.rss.plugins.model.AltPluginData;
import hec.rss.plugins.model.EmbeddedAlternative;
import hec.rss.plugins.server.EmbeddedWorkspace;
import hec.rss.server.RssComputeOptions;
import hec.rss.wq.model.AltWaterQualityOptions;
import hec.rss.wq.model.WQRun;
import hec.wqenginecore.WQException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.csinterface.RmiProgress;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import org.jdom.Content;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class RssRun
extends Manager
implements AsciiSerializable,
RssModelVariableConstants,
RssReturnStatusConstants,
AltInputReportInfc,
Serializable,
Runnable,
Callable {
    private static final FluentLogger FLOGGER = FluentLogger.forEnclosingClass();
    public static final int VERSION = 1001;
    public static final String FILE_EXTENSION = "rssrun";
    public static final int COMPUTE_REG = 0;
    public static final int COMPUTE_UNREG = 1;
    public static final int COMPUTE_HOLDOUT = 2;
    public static final int COMPUTE_PULSE_ROUTING = 3;
    public static final int COMPUTE_CUMLOC = 4;
    public static final String[] COMPUTE_TYPE_NAME = new String[]{"Regulated Flow", "Unregulated Flow", "Reservoir Holdout", "Pulse Routing", "Cumulative Local Flow"};
    public static String MSG_RSSRUNERROR = "\nERROR in RssRun";
    public static String MSG_COMPUTEFAIL = "\nRSS COMPUTE FAILED";
    public static String MSG_INITCOMPUTE = "\nInitializing Simulation";
    public static String MSG_EVALROUTING = "\nEvaluating Routing for Downstream Operations";
    public static String MSG_COMPUTEREG = "\nComputing Regulated Flow";
    public static String MSG_COMPUTECUMLOC = "\nComputing Cumulative Local Flow";
    public static String MSG_COMPUTEUNREG = "\nComputing Unregulated Flow";
    public static String MSG_COMPUTEHOLDOUT = "\nComputing Reservoir Holdouts";
    public static String MSG_FAILEDTOLOADALT = "\nFailed to Load ResSim Alternative: ";
    int _version = 0;
    String _altPath = "";
    String _outputDSSFileName = "rss/rssout.dss";
    transient String _outputDSSFilePath;
    transient String _outputFpart = null;
    boolean _computeReg = true;
    boolean _computeCumLoc = true;
    boolean _computeUnReg = true;
    boolean _computeHoldout = false;
    transient boolean _stopFYIter = false;
    RunTimeWindow _runTimeWindow = new RunTimeWindow();
    transient RunTimeWindow _currentComputeBlockTimwWindow = null;
    String _runId = null;
    int _logLevel = 3;
    Hashtable _elementLogLevelTable = new Hashtable();
    Hashtable _elementComputeNotes = new Hashtable();
    transient ReleaseOverrides _releaseOverrides = null;
    transient ReleaseOverrides _elevationOverrides = null;
    transient ReleaseOverrides _gateOverrides = null;
    transient ReleaseOverrides _capacityOverrides = null;
    private ReleaseOverrides _storageOverrides;
    private ReleaseOverrides _elevStorageOverrides;
    transient ReleaseOverrides _diversionOverrides = null;
    private ReleaseDecisionReportOptions _releaseReportOptions = new ReleaseDecisionReportOptions();
    private String _summaryReportCollectionRun = null;
    private int _inputPos = 0;
    private int _modelPos = 3;
    transient RunObserver _runObserver = null;
    transient RssAlt _alt;
    transient RssSystem _system;
    transient TSDataSet _inputTSData = null;
    transient TSDataSet _observedTSData = null;
    transient TSDataSet _outputTSData = null;
    transient TSDataSet _regOutputTSData = null;
    transient TSDataSet _cumlocOutputTSData = null;
    transient TSDataSet _unregOutputTSData = null;
    transient TSDataSet _inputWQTSData = null;
    transient PDCDataSet _inputWQPDCData = null;
    transient TSDataSet _obsWQTSData = null;
    transient Vector _holdoutOutputTSDataVec = null;
    transient TSDataSet _wqOutputTSData = null;
    transient RssOutput _output = null;
    transient Vector _timeBlockVec;
    transient String _forecastDir;
    transient int _fpartMultiplier = 2;
    private transient double _dprog;
    private transient int _iprog;
    private transient double _progscl;
    int _lookbackLength = 0;
    int _loobackLengthInc = 0;
    private int _storageOverrideType = 5;
    private transient int _timeBlockNum;
    private boolean _timeBlocking = true;
    private boolean _iterative = false;
    public static final int PROGRESS_START = 0;
    public static final int PROGRESS_INIT = 5;
    public static final int PROGRESS_EVALROUTE = 10;
    public static final int PROGRESS_CUMLOC = 15;
    public static final int PROGRESS_UNREG = 25;
    public static final int PROGRESS_REG = 90;
    public static final int PROGRESS_HOLDOUT = 95;
    public static final int PROGRESS_END = 100;
    private long[] _timeInit = new long[1];
    private long[] _timePulse = new long[1];
    private long[] _timeCLoc = new long[1];
    private long[] _timeUReg = new long[1];
    private long[] _timeReg2 = new long[1];
    private long[] _timeHOut = new long[1];
    private long[] _timeCplt = new long[1];
    private transient List<EmbeddedAlternative> _embeddedAltList = new ArrayList<EmbeddedAlternative>();
    private long _TOTAL_TIME = 0L;
    protected transient Object _additionalComputeOptions;
    private transient boolean _computing;
    private WQRun _wqRun;
    private ComputeStatus _lastComputeStatus = ComputeStatus.NOT_COMPUTED;
    private transient GVDataSet _inputGVData;
    private transient GVDataSet _regOutputGVData;
    private transient int[] varIdArray = null;
    private String _variantName;
    private int _computeType;

    public RssRun() {
    }

    public RssRun(String string) {
        super(string);
    }

    public boolean usesTimeBlocking() {
        return this._timeBlocking;
    }

    public void setTimeBlocking(boolean bl) {
        this._timeBlocking = bl;
    }

    public boolean isIterative() {
        return this._iterative;
    }

    public void setIterative(boolean bl) {
        this._iterative = bl;
    }

    @Scriptable
    public void setStopFYIter(boolean bl) {
        this._stopFYIter = bl;
    }

    @Scriptable
    public boolean getStopFYIter() {
        return this._stopFYIter;
    }

    public void init() {
    }

    void incrementComputeProgress(double d) {
        double d2;
        double d3 = this._dprog + this._progscl * d;
        if (d2 > 100.0) {
            d3 = 100.0;
        }
        this.setRunProgress(d3);
    }

    public void setRunProgress(double d) {
        if (d - (double)this._iprog > 1.0) {
            this.setProgress((int)d);
            this._iprog = (int)d;
        }
        this._dprog = d;
    }

    void initProgressStep(double d, double d2, int n, int n2) {
        this._progscl = (d2 - d) / (double)(n * n2);
        this.setRunProgress(d);
    }

    public void initProgress() {
        this._dprog = 0.0;
        this._iprog = 0;
        this.setProgress(0);
    }

    public TSRecord getTSRecordByPathParts(String string, String string2) {
        TSRecord tSRecord = null;
        TSDataSet tSDataSet = this.getRegOutputTSData();
        if (tSDataSet != null && (tSRecord = tSDataSet.getTSRecordByPathParts(string, string2)) != null) {
            return tSRecord;
        }
        tSDataSet = this.getInputTSData();
        if (tSDataSet != null && (tSRecord = tSDataSet.getTSRecordByPathParts(string, string2)) != null) {
            return tSRecord;
        }
        tSDataSet = this.getUnregOutputTSData();
        if (tSDataSet != null && (tSRecord = tSDataSet.getTSRecordByPathParts(string, string2)) != null) {
            return tSRecord;
        }
        tSDataSet = this.getCumLocOutputTSData();
        if (tSDataSet != null && (tSRecord = tSDataSet.getTSRecordByPathParts(string, string2)) != null) {
            return tSRecord;
        }
        return tSRecord;
    }

    public RunDataRecord getDataRecord() {
        RunDataRecord runDataRecord = new RunDataRecord();
        new RunDataRecord()._name = this.getName();
        runDataRecord._description = this.getDescription();
        runDataRecord._lookbackTime = this._runTimeWindow.getLookbackHrMinString();
        runDataRecord._lookbackDate = this._runTimeWindow.getLookbackDateString();
        runDataRecord._startDate = this._runTimeWindow.getStartDateString();
        runDataRecord._startTimeString = this._runTimeWindow.getStartHrMinString();
        runDataRecord._endDate = this._runTimeWindow.getEndDateString();
        runDataRecord._endTimeString = this._runTimeWindow.getEndHrMinString();
        runDataRecord._timeStepString = this._runTimeWindow.getTimeStepString(1);
        runDataRecord.logLevel = this._logLevel;
        runDataRecord._computeUnregFlow = this._computeUnReg;
        runDataRecord._computeResHoldouts = this._computeHoldout;
        return runDataRecord;
    }

    public boolean setDataRecord(RunDataRecord runDataRecord) {
        this.setName(runDataRecord._name);
        this.setDescription(runDataRecord._description);
        this._runTimeWindow.setLookbackTime(runDataRecord._lookbackDate + " " + runDataRecord._lookbackTime);
        this._runTimeWindow.setStartTime(runDataRecord._startDate + " " + runDataRecord._startTimeString);
        this._runTimeWindow.setEndTime(runDataRecord._endDate + " " + runDataRecord._endTimeString);
        this._runTimeWindow.setTimeStep(runDataRecord._timeStepString);
        this._logLevel = runDataRecord.logLevel;
        this._computeUnReg = runDataRecord._computeUnregFlow;
        this._computeHoldout = runDataRecord._computeResHoldouts;
        this.setModified(true);
        return true;
    }

    public void setAltPath(String string) {
        string = this.getRelativePath(string);
        if (this._altPath != null && !this._altPath.equals(string)) {
            this._alt = null;
            this._system = null;
            this._inputTSData = null;
            this._regOutputTSData = null;
            this._unregOutputTSData = null;
            this._holdoutOutputTSDataVec = null;
            this._wqOutputTSData = null;
        }
        this._altPath = string;
    }

    public String getAltPath() {
        RssRun rssRun = this;
        String string = rssRun.makeAbsolutePath(rssRun._altPath);
        return string;
    }

    @Scriptable
    public RunTimeWindow getRunTimeWindow() {
        return this._runTimeWindow;
    }

    public String getTimeWindowString() {
        return this._runTimeWindow.getLookbackTimeString() + " " + this._runTimeWindow.getEndTimeString();
    }

    public void setComputeObserver(RunObserver runObserver) {
        this._runObserver = runObserver;
    }

    public RssAlt getAlternative() {
        block4: {
            if (this._alt != null) {
                return this._alt;
            }
            RssRun rssRun = this;
            Identifier identifier = new Identifier(rssRun.makeAbsolutePath(rssRun._altPath));
            try {
                this._alt = (RssAlt)this._proxyList.loadManager(RssAlt.class.getName(), identifier);
            }
            catch (RemoteException remoteException) {
                this.printErrorMessage(MSG_RSSRUNERROR + ".loadManagers - RemoteException");
                this.printMessage(MSG_FAILEDTOLOADALT + this._altPath);
                if (this._logLevel < 5) break block4;
                this.printMessage(remoteException.toString());
            }
        }
        if (this._alt == null && this._logLevel > 4) {
            RssRun rssRun = this;
            rssRun.printWarningMessage("Failed to load Alternative " + rssRun._altPath);
        }
        return this._alt;
    }

    public RssSystem getNetwork() {
        if (this._system == null) {
            RssAlt rssAlt = this.getAlternative();
            if (rssAlt == null) {
                return null;
            }
            this._system = rssAlt.getSystem();
        }
        return this._system;
    }

    public GVDataSet getInputGVData() {
        if (this._inputGVData != null) {
            return this._inputGVData;
        }
        if (this._alt == null && this.getAlternative() == null) {
            RssRun rssRun = this;
            rssRun.printMessage("Failed to load ResSim Alternative " + rssRun._altPath);
            this.printMessage("Cannot load inputGVData");
            return null;
        }
        Object object = this._alt.getTsVariant(this._variantName);
        this._inputGVData = this._alt.getInputGVDataSet((TsVariant)((Object)object));
        if (this._runId != null) {
            this._inputGVData = this.createForecastInputGVData(this._inputGVData, this.getDSSOutputFile(), this._runId);
        }
        if ((object = this._runId) == null) {
            object = this._alt.getName();
        }
        this._inputGVData.setAltName((String)object);
        return this._inputGVData;
    }

    public TSDataSet getInputWQTSDataSet(boolean bl) {
        if (this._inputWQTSData != null) {
            this._inputWQTSData.setUserInterface(this._uiWrapper);
            if (bl) {
                RssRun rssRun = this;
                rssRun.printMessage("Using WQ TSDataSet " + rssRun._inputWQTSData.getName());
            }
            return this._inputWQTSData;
        }
        if (this._alt == null && this.getAlternative() == null) {
            RssRun rssRun = this;
            rssRun.printMessage("Failed to load ResSim Alternative " + rssRun._altPath);
            this.printMessage("Cannot load inputWQTSData");
            return null;
        }
        Object object = this._alt.getTsVariant(this._variantName);
        this._inputWQTSData = this._alt.getInputWQTSDataSet((TsVariant)((Object)object));
        RssRun rssRun = this;
        rssRun.printMessage("Created WQ TSDataSet " + rssRun._inputWQTSData.getName());
        if (this._runId != null) {
            this._inputWQTSData = this.createForecastInputTSData(this._inputWQTSData, this.getDSSOutputFile(), this._runId);
        }
        if ((object = this._runId) == null) {
            object = this._alt.getName();
        }
        this._inputWQTSData.setAltName((String)object);
        return this._inputWQTSData;
    }

    public PDCDataSet getInputWQPDCDataSet() {
        if (this._inputWQPDCData != null) {
            this._inputWQPDCData.setUserInterface(this._uiWrapper);
            return this._inputWQPDCData;
        }
        if (this._alt == null && this.getAlternative() == null) {
            RssRun rssRun = this;
            rssRun.printMessage("Failed to load ResSim Alternative " + rssRun._altPath);
            this.printMessage("Cannot load inputWQPDCData");
            return null;
        }
        TsVariant tsVariant = this._alt.getTsVariant(this._variantName);
        this._inputWQPDCData = this._alt.getInputWQPDCDataSet(tsVariant);
        this._inputWQPDCData.setUserInterface(this._uiWrapper);
        if (this._runId != null) {
            this._inputWQPDCData = this.createForecastInputPDCData(this._inputWQPDCData, this.getDSSOutputFile(), this._runId);
        }
        return this._inputWQPDCData;
    }

    public TSDataSet getObsWQTSDataSet() {
        if (this._obsWQTSData != null) {
            return this._obsWQTSData;
        }
        if (this._alt == null && this.getAlternative() == null) {
            RssRun rssRun = this;
            rssRun.printMessage("Failed to load ResSim Alternative " + rssRun._altPath);
            this.printMessage("Cannot load ObsWQTSData");
            return null;
        }
        this._alt.getObsWQTSDataSet(this.getVariantName(), false);
        this._obsWQTSData = this._alt.getObsWQTSDataSet();
        return this._obsWQTSData;
    }

    public TSDataSet getInputTSData() {
        if (this._inputTSData != null) {
            return this._inputTSData;
        }
        if (this._alt == null && this.getAlternative() == null) {
            RssRun rssRun = this;
            rssRun.printMessage("Failed to load ResSim Alternative " + rssRun._altPath);
            this.printMessage("Cannot load inputTSData");
            return null;
        }
        Object object = this._alt.getTsVariant(this._variantName);
        this._inputTSData = this._alt.getInputTSDataSet((TsVariant)((Object)object));
        if (this._runId != null) {
            this._inputTSData = this.createForecastInputTSData(this._inputTSData, this.getDSSOutputFile(), this._runId);
        }
        if ((object = this._runId) == null) {
            object = this._alt.getName();
        }
        this._inputTSData.setAltName((String)object);
        return this._inputTSData;
    }

    public TSDataSet getObservedTSData() {
        if (this._alt == null && this.getAlternative() == null) {
            RssRun rssRun = this;
            rssRun.printMessage("Failed to load ResSim Alternative " + rssRun._altPath);
            this.printMessage("Cannot load Observed TSDataSet");
            return null;
        }
        this._observedTSData = this._alt.getObservedTSDataSet();
        if (this._runId != null && this._observedTSData != null) {
            this._observedTSData = this.createForecastInputTSData(this._observedTSData, this.getDSSOutputFile(), this._runId);
        }
        return this._observedTSData;
    }

    public TSDataSet getOutputTSData() {
        if (this._outputTSData != null) {
            return this._outputTSData;
        }
        if (this._alt == null && this.getAlternative() == null) {
            this.printMessage("Can't load outputTSData");
            return null;
        }
        this._system = this._alt.getSystem();
        if (this._system == null) {
            this.printMessage("Failed to load data managers.");
            return null;
        }
        String string = this._runId;
        if (string == null) {
            string = this._alt.getName();
        }
        this._outputTSData = this.createOutputTSData(string);
        this._outputTSData.setAltName(string);
        return this._outputTSData;
    }

    public TSDataSet getWQOutputTSData() {
        if (!this.shouldComputeWaterQuality()) {
            return null;
        }
        if (this._wqOutputTSData != null) {
            return this._wqOutputTSData;
        }
        if (this._alt == null && this.getAlternative() == null) {
            this.printErrorMessage("Can't load Water Quality Output TS Data because the Alternative cannot be found");
            return null;
        }
        this._system = this._alt.getSystem();
        if (this._system == null) {
            RssRun rssRun = this;
            rssRun.printErrorMessage("Failed to load data managers: No network found for " + rssRun._alt.getName());
            return null;
        }
        String string = this._runId;
        if (string == null) {
            string = this._alt.getName();
        }
        this._wqOutputTSData = this.createOutputWQTSData(string);
        this._wqOutputTSData.setAltName(string);
        return this._wqOutputTSData;
    }

    public ReleaseDecisionReportOptions getReleaseDecisionReportOptions() {
        return this._releaseReportOptions;
    }

    public void setReleaseDecisionReportOptions(ReleaseDecisionReportOptions releaseDecisionReportOptions) {
        this._releaseReportOptions = releaseDecisionReportOptions;
    }

    public void setSelectedSummaryReportCollectionRun(String string) {
        this._summaryReportCollectionRun = string;
    }

    public String getSelectedSummaryReportCollectionRun() {
        return this._summaryReportCollectionRun;
    }

    public String getReportKey() {
        List<Object> list = this.getAlternative().getPluginDataList();
        for (int i = 0; i < list.size(); ++i) {
            AltPluginData altPluginData = list.get(i);
            if (!altPluginData.useCompute()) continue;
            list = altPluginData.getCollectionNumbers(this.getAlternative(), this.getRunTimeWindow().getStartTime());
            if (list == null || list.isEmpty()) {
                return this.getOutputFPart();
            }
            if (this._summaryReportCollectionRun == null || this._summaryReportCollectionRun.isEmpty()) {
                altPluginData = new DSSPathname();
                altPluginData.setFPart(this.getOutputFPart());
                altPluginData.setCollectionSequence((String)list.get(0));
                return altPluginData.getFPart();
            }
            altPluginData = new DSSPathname();
            altPluginData.setFPart(this.getOutputFPart());
            altPluginData.setCollectionSequence(this._summaryReportCollectionRun);
            return altPluginData.getFPart();
        }
        return this.getOutputFPart();
    }

    public void clearInputTSData() {
        this._inputTSData = null;
    }

    public void clearOutputTSData() {
        this._regOutputTSData = null;
        this._outputTSData = null;
        this._cumlocOutputTSData = null;
        this._unregOutputTSData = null;
        this._holdoutOutputTSDataVec = null;
        this._regOutputGVData = null;
        this._wqOutputTSData = null;
    }

    public GVDataSet getRegOutputGVData() {
        if (this._regOutputGVData != null) {
            return this._regOutputGVData;
        }
        if (this._alt == null && this.getAlternative() == null) {
            this.printMessage("Missing Alternative. Can't load output Global Variable DataSet");
            return null;
        }
        this._system = this._alt.getSystem();
        if (this._system == null) {
            this.printMessage("Missing Network. Can't load output Global Variable DataSet");
            return null;
        }
        this._regOutputGVData = this._runId == null ? this.createOutputGVData(this._alt.getName(), "REG", 0) : this.createOutputGVData(this._runId, "REG", 0);
        return this._regOutputGVData;
    }

    public TSDataSet getRegOutputTSData() {
        return this.getRegOutputTSData(false);
    }

    public TSDataSet getRegOutputTSData(boolean bl) {
        if (this._regOutputTSData != null && !bl) {
            return this._regOutputTSData;
        }
        if (this._alt == null && this.getAlternative() == null) {
            this.printMessage("Can't load outputTSData");
            return null;
        }
        this._system = this._alt.getSystem();
        if (this._system == null) {
            this.printMessage("Failed to load data managers.");
            return null;
        }
        this._system.updateTSProxyList();
        if (this._runId == null) {
            this._regOutputTSData = this.createOutputTSData(this._alt.getName(), "REG", 0);
        } else {
            if (bl) {
                RssRun rssRun = this;
                return rssRun.createReleaseDecisionTSData(rssRun._runId, "REG", 0);
            }
            this._regOutputTSData = this.createOutputTSData(this._runId, "REG", 0);
        }
        return this._regOutputTSData;
    }

    public TSDataSet getUnregOutputTSData() {
        if (this._unregOutputTSData != null) {
            return this._unregOutputTSData;
        }
        if (this._alt == null && this.getAlternative() == null) {
            this.printMessage("Can't load outputTSData");
            return null;
        }
        this._system = this._alt.getSystem();
        if (this._system == null) {
            this.printMessage("Failed to load data managers.");
            return null;
        }
        this._unregOutputTSData = this._runId == null ? this.createOutputTSData(this._alt.getName(), "UNREG", 1) : this.createOutputTSData(this._runId, "UNREG", 1);
        return this._unregOutputTSData;
    }

    public TSDataSet getCumLocOutputTSData() {
        if (this._cumlocOutputTSData != null) {
            return this._cumlocOutputTSData;
        }
        if (this._alt == null && this.getAlternative() == null) {
            this.printMessage("Can't load outputTSData");
            return null;
        }
        this._system = this._alt.getSystem();
        if (this._system == null) {
            this.printMessage("Failed to load data managers.");
            return null;
        }
        this._cumlocOutputTSData = this._runId == null ? this.createOutputTSData(this._alt.getName(), "CUMLOC", 4) : this.createOutputTSData(this._runId, "CUMLOC", 4);
        return this._cumlocOutputTSData;
    }

    public Integer call() throws Exception {
        int n;
        this.printLogMessage("Starting compute at " + String.valueOf(new Date()));
        AltPluginData altPluginData = this._alt.getAltPluginData(AltPluginDataFactory.ENSEMBLE);
        if (altPluginData != null) {
            Thread.currentThread().setName("ResSim Ensemble Compute Thread " + altPluginData.toString());
        }
        if ((n = this.compute()) != 0) {
            this.printErrorMessage("ResSim Compute Failed");
        }
        if (this._userInterface != null) {
            this._userInterface.computeComplete();
        } else if (this._uiWrapper != null) {
            try {
                ((RmiProgress)this._uiWrapper.getRemote()).runComplete((Object)this.getName());
            }
            catch (RemoteException remoteException) {
                this.printMessage("RssRun.run: RemoteExecption " + String.valueOf(remoteException));
            }
        }
        if (this._runObserver != null) {
            this._runObserver.runComplete((Object)this.getName());
        }
        return n;
    }

    @Override
    public void run() {
        try {
            this.call();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    public int compute() {
        this._computing = true;
        try {
            HecTime.setAlwaysShowTimeAsBeginningOfDay((boolean)false);
            this.printMessage("\nResSim Compute\n");
            Object object = RMAIO.getAppVersionProperties(RSS.class);
            if (object == null || ((Properties)object).isEmpty()) {
                this.printMessage("Build Version: not available");
            } else {
                String string = ((Properties)object).getProperty("fullVersion");
                if (string != null) {
                    this.printMessage("Build Version: " + string);
                } else {
                    this.printMessage("Build Version: not found");
                }
            }
            this.printLogMessage("Simulation Time Window:");
            RssRun rssRun = this;
            rssRun.printLogMessage("  Lookback\t: " + rssRun.getRunTimeWindow().getLookbackTimeString());
            RssRun rssRun2 = this;
            rssRun2.printLogMessage("  Start\t: " + rssRun2.getRunTimeWindow().getStartTimeString());
            RssRun rssRun3 = this;
            rssRun3.printLogMessage("  End\t: " + rssRun3.getRunTimeWindow().getEndTimeString());
            RssRun rssRun4 = this;
            rssRun4.printLogMessage("\n  Time Step: " + rssRun4.getRunTimeWindow().getTimeStepString(1));
            this.printStatus("ResSim");
            this.initProgress();
            long l = System.currentTimeMillis();
            if (this.getAlternative() == null) {
                this.printErrorMessage("Failed to load alternative");
                return 1;
            }
            if (!this.loadEmbeddedAlts()) {
                this.printErrorMessage("Failed to load embedded alternatives");
                return 1;
            }
            this.printLogMessage("");
            object = "--------------------------------------------------------------------------------------------------------------------";
            this.printLogMessage((String)object);
            this.printComputeSettings();
            this.printROCOptions();
            this.printLogMessage((String)object);
            int n = this._alt.compute(this);
            this.unloadEmbeddedAlts();
            System.out.println("compute init     took:" + this._timeInit[0] + " ms");
            System.out.println("compute pulse    took:" + this._timePulse[0] + " ms");
            System.out.println("compute cumLoc   took:" + this._timeCLoc[0] + " ms");
            System.out.println("compute unreg    took:" + this._timeUReg[0] + " ms");
            System.out.println("compute reg      took:" + this._timeReg2[0] + " ms");
            System.out.println("compute holdout  took:" + this._timeHOut[0] + " ms");
            System.out.println("compute complete took:" + this._timeCplt[0] + " ms");
            long l2 = System.currentTimeMillis();
            long l3 = (l2 - l) / 1000L;
            this.printStatus("ResSim Compute Complete");
            this.printMessage("Total Compute Time " + l3 + " Seconds.");
            System.out.println("Total Compute Time " + l3 + " Seconds.");
            this.setTotalComputeTime(l3);
            Object object2 = this._system.getStateVariableList();
            for (int i = 0; i < object2.size(); ++i) {
                StateVariable stateVariable = object2.get(i);
                System.out.println("compute stateVariable " + String.valueOf(stateVariable) + " took " + stateVariable.getTotalComputeTime() + " ms");
            }
            Vector<ReservoirElement> vector = this._system.getElementVectorByClass(ReservoirElement.class);
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    object2 = vector.get(i);
                    Object object3 = ((ReservoirElement)object2).getReservoirOp().getActiveOpSet();
                    object3 = ((OpSet)object3).getRules(null);
                    for (int j = 0; j < object3.size(); ++j) {
                        OpRule opRule = (OpRule)object3.get(j);
                        if (!(opRule instanceof ScriptOpRule)) continue;
                        System.out.println("compute: ScriptOpRules for Reservoir " + String.valueOf(object2));
                        opRule = (ScriptOpRule)opRule;
                        long l4 = ((ScriptOpRule)opRule).getTotalComputeInitMs();
                        long l5 = ((ScriptOpRule)opRule).getTotalComputeMs();
                        System.out.println(" compute ScriptOpRule init script " + opRule.getName() + " took " + l4 + " ms");
                        System.out.println(" compute ScriptOpRule script " + opRule.getName() + " took " + l5 + " ms");
                    }
                }
            }
            return n;
        }
        catch (Exception exception) {
            System.out.println("compute:exception during compute " + String.valueOf(exception));
            this.printErrorMessage("Error during compute " + String.valueOf(exception));
            exception.printStackTrace();
            return 1;
        }
        finally {
            this._inputWQTSData = null;
            this._inputWQPDCData = null;
            this._obsWQTSData = null;
            this._alt.a = null;
            this._inputGVData = null;
            this._inputTSData = null;
            this._computing = false;
        }
    }

    private void printROCOptions() {
        Object object = this.getAlternative().getSystem();
        if (object == null) {
            this.printErrorMessage("\nRssSystem is null, not printing ROC options.");
            return;
        }
        if ((object = ((RssSystem)object).getComputeOptions()) == null) {
            this.printErrorMessage("\nRssComputeOptions are null, not printing ROC Options.");
            return;
        }
        this.printLogMessage("\nRate of Change Options:");
        boolean bl = ((RssComputeOptions)object).getConsiderROC();
        this.printLogMessage("  Consider Rate of Change Constraints in Guide Curve Release Computations: " + (bl ? "Yes" : "No"));
        if (bl) {
            this.printLogMessage("    Minimum Look Ahead (days): " + ((RssComputeOptions)object).getMinLookAheadDays());
            this.printLogMessage("    Maximum Look Ahead (days): " + ((RssComputeOptions)object).getMaxLookAheadDays());
            bl = ((RssComputeOptions)object).getIterateNonConstantROC();
            this.printLogMessage("    Allow Iterations for Variable ROC: " + (bl ? "Yes" : "No"));
            if (bl) {
                this.printLogMessage("      Maximum Iterations: " + ((RssComputeOptions)object).getMaxIterNonConstROC());
                DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(Locale.US);
                decimalFormat.setGroupingUsed(false);
                decimalFormat.setMaximumFractionDigits(15);
                double d = ((RssComputeOptions)object).getFlowTol();
                this.printLogMessage("      Flow Tolerance: " + decimalFormat.format(d));
                double d2 = ((RssComputeOptions)object).getStorTol();
                this.printLogMessage("      Storage Tolerance: " + decimalFormat.format(d2));
            }
        }
    }

    private void printComputeSettings() {
        Object object = this.getAlternative().getSystem();
        if (object == null) {
            this.printErrorMessage("\nRssSystem is null, not printing compute options.");
            return;
        }
        if ((object = ((RssSystem)object).getComputeOptions()) == null) {
            this.printErrorMessage("\nRssComputeOptions are null, not printing ResSim Compute Settings.");
            return;
        }
        this.printLogMessage("ResSim Compute Settings:");
        this.printLogMessage("  Minimum Number of Compute Passes: " + ((RssComputeOptions)object).getMinComputePasses());
        double d = ((RssComputeOptions)object).getStorCalcErrTolFac();
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(Locale.US);
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMaximumFractionDigits(15);
        this.printLogMessage("  Error Tolerance Factor for Storage Calculation: " + decimalFormat.format(d));
        this.printLogMessage("  Maximum Sub-Steps for Storage Calculation: " + ((RssComputeOptions)object).getStorCalcSubSteps());
        this.printLogMessage("  Include System Hydropower in Requirement for Number of Routing Steps: " + (((RssComputeOptions)object).noSysHydroRoutingSteps() ? "No" : "Yes"));
    }

    private void unloadEmbeddedAlts() {
        this._embeddedAltList.clear();
    }

    private boolean loadEmbeddedAlts() {
        this._embeddedAltList.clear();
        List<ModelReference> list = this._alt.getEmbeddedAltRefList();
        for (int i = 0; i < list.size(); ++i) {
            ModelReference modelReference = list.get(i);
            try {
                Object object = ((RmiWorkspace)this._Workspace.getRemote()).getChildWorkspace(modelReference.wkspName);
                if (!(object instanceof EmbeddedWorkspace)) {
                    System.out.println("loadEmbeddedAlts: Child workspace " + modelReference.wkspName + " is not an instance of an embedded workspace.");
                    this.printErrorMessage("Error loading workspace " + modelReference.wkspName);
                    this._embeddedAltList.clear();
                    return false;
                }
                object = (EmbeddedWorkspace)object;
                if ((object = object.getAlternative(modelReference.newId, modelReference.className)) == null) {
                    System.out.println("loadEmbeddedAlts: Alternative " + String.valueOf(modelReference) + " not found.");
                    this.printErrorMessage("Error loading alternative " + String.valueOf(modelReference));
                    this._embeddedAltList.clear();
                    return false;
                }
                this._embeddedAltList.add((EmbeddedAlternative)object);
                continue;
            }
            catch (RemoteException remoteException) {
                System.out.println("loadEmbeddedAlts: Failed to load child workspace " + modelReference.wkspName);
                this.printErrorMessage("Failed to load child workspace " + modelReference.wkspName);
                this._embeddedAltList.clear();
                return false;
            }
        }
        return true;
    }

    public List<EmbeddedAlternative> getEmbeddedAltList() {
        return this._embeddedAltList;
    }

    public int computeStandard() {
        int n = 1;
        try {
            this.setRunProgress(0.0);
            this.setTimeBlocking(true);
            this.setIterative(false);
            if (this.isSeededCompute()) {
                RssRun rssRun = this;
                rssRun.printWarningMessage("Warning: Alternative " + rssRun.getName() + " cannot be randomized because it is of type standard.");
            }
            RssRun rssRun = this;
            n = rssRun.initCompute(rssRun._timeInit);
            if (n == 0) {
                this.setRunProgress(5.0);
                RssRun rssRun2 = this;
                n = rssRun2.pulseRoutingCompute(rssRun2._timePulse);
            }
            if (n == 0) {
                this.setRunProgress(10.0);
                RssRun rssRun3 = this;
                n = rssRun3.cumLocCompute(rssRun3._timeCLoc);
            }
            if (n == 0) {
                this.setRunProgress(15.0);
                RssRun rssRun4 = this;
                n = rssRun4.unRegCompute(rssRun4._timeUReg);
            }
            if (n == 0) {
                this.setRunProgress(25.0);
                RssRun rssRun5 = this;
                n = rssRun5.regCompute(rssRun5._timeReg2);
            }
            if (n == 0) {
                this.setRunProgress(90.0);
                RssRun rssRun6 = this;
                n = rssRun6.holdOutCompute(rssRun6._timeHOut);
            }
            if (n == 0) {
                this.setRunProgress(95.0);
                if (this.shouldComputeWaterQuality() && !this.isCoupledWQCompute()) {
                    n = this.computeWQ();
                }
            }
            RssRun rssRun7 = this;
            int n2 = rssRun7.finalizeCompute(rssRun7._timeCplt, false);
            if (n != 0) {
                return n;
            }
            if (n2 != 0) {
                return n2;
            }
            this.setRunProgress(100.0);
        }
        catch (Throwable throwable) {
            RssRun rssRun = this;
            int n3 = rssRun.finalizeCompute(rssRun._timeCplt, false);
            if (n != 0) {
                return n;
            }
            if (n3 != 0) {
                return n3;
            }
            this.setRunProgress(100.0);
            throw throwable;
        }
        return n;
    }

    public boolean isCoupledWQCompute() {
        AltWaterQualityOptions altWaterQualityOptions = this.getAlternative().getWaterQualityOptions();
        if (altWaterQualityOptions != null) {
            return altWaterQualityOptions.getCoupledFlowWQCompute();
        }
        return false;
    }

    public boolean shouldComputeWaterQuality() {
        RssAlt rssAlt = this.getAlternative();
        boolean bl = false;
        if (rssAlt != null) {
            RssAlt rssAlt2 = rssAlt;
            bl = WQUtilities.shouldComputeWaterQuality(rssAlt2, rssAlt2.getWaterQualityOptions());
        }
        return bl;
    }

    private int loadWQ() {
        int n = 0;
        boolean bl = this._wqRun.initialize();
        if (!bl) {
            this._wqRun.finalizeCompute();
            n = 1;
        }
        return n;
    }

    private int computeWQ() {
        boolean bl = this._wqRun.computeUncoupled();
        if (!bl) {
            this._wqRun.finalizeCompute();
        } else {
            this.printStatus("Saving Water Quality time-series records");
            bl = this._wqRun.writeWQTSRecords(this._wqOutputTSData);
            if (!bl) {
                this.printErrorMessage("Failed to write Water Quality time-series records");
            }
        }
        if (bl) {
            return 0;
        }
        return 1;
    }

    public int computeFirmYield() {
        int n = 1;
        try {
            this.setRunProgress(0.0);
            this.setTimeBlocking(true);
            this.setIterative(false);
            if (this.isSeededCompute()) {
                RssRun rssRun = this;
                rssRun.printWarningMessage("Warning: Alternative " + rssRun.getName() + " cannot be randomized because it is of type Yield Analysis.");
            }
            RssRun rssRun = this;
            n = rssRun.initCompute(rssRun.getTimeInit());
            if (n == 0) {
                this.setRunProgress(5.0);
                RssRun rssRun2 = this;
                n = rssRun2.pulseRoutingCompute(rssRun2.getTimePulse());
            }
            if (n == 0) {
                this.setRunProgress(10.0);
                RssRun rssRun3 = this;
                n = rssRun3.cumLocCompute(rssRun3.getTimeCLoc());
            }
            if (n == 0) {
                this.setRunProgress(15.0);
                RssRun rssRun4 = this;
                n = rssRun4.unRegCompute(rssRun4.getTimeUReg());
            }
            if (n == 0) {
                this.setRunProgress(25.0);
                RssRun rssRun5 = this;
                n = rssRun5.regFYCompute(rssRun5.getTimeReg2());
            }
            if (n == 0) {
                this.setRunProgress(90.0);
                RssRun rssRun6 = this;
                n = rssRun6.holdOutCompute(rssRun6.getTimeHOut());
            }
            if (n == 0) {
                this.setRunProgress(95.0);
                if (this.shouldComputeWaterQuality() && !this.isCoupledWQCompute()) {
                    n = this.computeWQ();
                }
            }
        }
        finally {
            RssRun rssRun = this;
            int n2 = rssRun.finalizeCompute(rssRun.getTimeCplt(), false);
            if (n != 0) {
                return n;
            }
            if (n2 != 0) {
                return n2;
            }
            this.setRunProgress(100.0);
        }
        return n;
    }

    public int initCompute(long[] lArray) {
        TSDataSet tSDataSet;
        int n;
        long l = System.currentTimeMillis();
        this.isIterative();
        if (this._logLevel >= 2) {
            this.printLogMessage(MSG_INITCOMPUTE);
        }
        this.printStatus("ResSim Initializing");
        if (this.shouldComputeWaterQuality()) {
            this._wqRun = new WQRun(this._alt, this);
        }
        if ((n = this.initCompute()) != 0) {
            this.printErrorMessage("Initialization Failed");
            return n;
        }
        if (this.shouldComputeWaterQuality()) {
            n = this.loadWQ();
            if (n != 0) {
                this.printErrorMessage("ResSim ERROR: Failed to initialize water quality data");
                this.printErrorMessage("Initialization Failed");
                ((FluentLogger.Api)((FluentLogger.Api)FLOGGER.atWarning()).withStackTrace(StackSize.SMALL)).log("WQInit Failed");
                return 1;
            }
            if (this.isCoupledWQCompute() && (tSDataSet = this.getWQOutputTSData()) != null) {
                List<RunTimeWindow> list = this.getTimeBlocks();
                try {
                    this._wqRun.initTSDataSet(tSDataSet, list.get(0));
                }
                catch (WQException wQException) {
                    this.printErrorMessage("ResSim ERROR: Failed to initialize water quality output time series dataset");
                    this.printErrorMessage("Initialization Failed");
                    ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)FLOGGER.atWarning()).withStackTrace(StackSize.SMALL)).withCause((Throwable)wQException)).log("WQInit Failed");
                    return 1;
                }
            }
        }
        if ((tSDataSet = this.getEmbeddedAltList()) != null) {
            for (int i = 0; i < tSDataSet.size(); ++i) {
                EmbeddedAlternative embeddedAlternative = (EmbeddedAlternative)tSDataSet.get(i);
                if (embeddedAlternative == null || embeddedAlternative.initializeCompute(this) == 0) continue;
                this.printErrorMessage("ResSim ERROR: Failed to init embedded alternative");
                this.printErrorMessage("Initialization Failed");
                return 1;
            }
        }
        RssRun rssRun = this;
        rssRun.printLogMessage("  Flow Computation Method: " + (rssRun.getAlternative().isPerAvgFlow() ? "Period Average" : "Instantaneous"));
        if (this._logLevel >= 3) {
            this.printLogMessage("Compute Initialization Complete");
        }
        long l2 = System.currentTimeMillis();
        lArray[0] = l2 - l;
        this.printMessage("Initialization Complete");
        return n;
    }

    public int initForPostProcessing() {
        RunTimeWindow runTimeWindow;
        int n = this.loadMangers();
        if (n != 0) {
            this.printErrorMessage("Failed to load Managers");
            return n;
        }
        n = this.initSimulationTime();
        if (n != 0) {
            this.printErrorMessage("Failed to set up simulation time");
            return n;
        }
        if (this._alt != null) {
            this._alt.setUserInterface(this._uiWrapper);
            this._alt.initCompute();
        }
        if (n != 0) {
            this.printErrorMessage("Initialization Failed");
            return n;
        }
        this._currentComputeBlockTimwWindow = runTimeWindow = (RunTimeWindow)this._timeBlockVec.elementAt(0);
        boolean bl = this._system.initForPostProcessing(this._inputTSData, this._outputTSData, 0, runTimeWindow);
        if (!bl) {
            this.printErrorMessage("System Initialization Failed for post processing");
            return 1;
        }
        return n;
    }

    public int pulseRoutingCompute(long[] lArray) {
        long l = System.currentTimeMillis();
        int n = 0;
        if (this._computeReg && this._system.hasDownstreamGoals()) {
            if (this._logLevel >= 2) {
                this.printMessage(MSG_EVALROUTING);
            }
            this.printStatus("ResSim Prep Downstream Operations");
            n = this._system.initDownstreamPulse();
            if (n != 0) {
                this.printErrorMessage("\nInitialization of Downstream Rules Failed");
                return n;
            }
            Vector<ReservoirElement> vector = this._system.getElementVectorByClass(ReservoirElement.class);
            Vector vector2 = new Vector();
            RunTimeWindow runTimeWindow = (RunTimeWindow)this._timeBlockVec.elementAt(0);
            RunTimeStep runTimeStep = new RunTimeStep(runTimeWindow);
            new RunTimeStep(runTimeWindow).step = runTimeWindow.getNumLookbackSteps();
            runTimeStep.nstep = runTimeWindow.getForecastSteps();
            int n2 = vector.size();
            this.initProgressStep(5.0, 10.0, vector.size() * this._system.getElementCount(), runTimeStep.nstep - runTimeStep.step);
            for (int i = 0; i < n2; ++i) {
                int n3;
                ReservoirElement reservoirElement = vector.get(i);
                if (!reservoirElement.hasDownstreamGoals(n3 = this._alt.getResOpSetSelection(reservoirElement.getIndex()))) continue;
                this.printMessage("\tReservoir: " + reservoirElement.getName());
                int n4 = reservoirElement.getChildElementCount();
                for (int j = 0; j < n4; ++j) {
                    Element element = reservoirElement.getChildElementAt(j);
                    if (element == null || element.getDownstreamNode() == null || !(element instanceof ReservoirOutletElement) || !this._system.prepPulseRoutingCompute(reservoirElement, n3, j)) continue;
                    n = this.computeSystem(3, "ROUTING-" + reservoirElement.getName() + "-" + j);
                    if (n == 50) {
                        return n;
                    }
                    if (n != 0) {
                        this.printErrorMessage("ResSim ERROR: Failed to evaluate routing for reservoir " + reservoirElement.getName());
                        this.printStatus("ResSim COMPUTE FAILED");
                        return 1;
                    }
                    ArrayList<RssNode> arrayList = new ArrayList<RssNode>();
                    this._system.getDownstreamNodeList(element, arrayList);
                    vector2.removeAllElements();
                    reservoirElement.getDownstreamRules(n3, vector2);
                    int n5 = vector2.size();
                    for (int k = 0; k < n5; ++k) {
                        DownstreamOp downstreamOp;
                        int n6;
                        RssNode rssNode;
                        OpRule opRule = (OpRule)vector2.elementAt(k);
                        if (!(opRule instanceof DownstreamCntrlOpRule) || !arrayList.contains(rssNode = this._system.getNode(n6 = ((DownstreamOpRule)(opRule = (DownstreamCntrlOpRule)opRule)).getDownstreamControlLocationID())) || (downstreamOp = this._system.getDownstreamOp(n6)) == null || (n = downstreamOp.computePulseResponse(reservoirElement, j, runTimeStep)) == 0) continue;
                        this.printStatus("ResSim COMPUTE FAILED");
                        return 1;
                    }
                }
            }
        }
        long l2 = System.currentTimeMillis();
        lArray[0] = l2 - l;
        return n;
    }

    public int cumLocCompute(long[] lArray) {
        boolean bl;
        long l = System.currentTimeMillis();
        int n = 0;
        boolean bl2 = bl = !this.isIterative();
        if (this._computeCumLoc) {
            if (this._logLevel >= 2) {
                this.printMessage(MSG_COMPUTECUMLOC);
            }
            this.printStatus("ResSim Cumulative Local Flow");
            this.initProgressStep(10.0, 15.0, this._system.getElementCount(), this._runTimeWindow.getNumSteps());
            this._system.prepCumLocFlowCompute();
            n = this.computeSystem(4, "CUMLOC");
            if (n == 50) {
                return n;
            }
            if (n != 0) {
                this.printErrorMessage("ResSim ERROR: Failed to compute cumulative local flows");
                return 1;
            }
            if (bl) {
                this._output.addTSRecordSummaryTable(this.getOutputFPart(), this._cumlocOutputTSData.getTSRecordSummaryTable("CUMLOC"));
            }
        }
        long l2 = System.currentTimeMillis();
        lArray[0] = l2 - l;
        return n;
    }

    public int unRegCompute(long[] lArray) {
        boolean bl;
        long l = System.currentTimeMillis();
        int n = 0;
        boolean bl2 = bl = !this.isIterative();
        if (this._computeUnReg) {
            if (this._logLevel >= 2) {
                this.printMessage(MSG_COMPUTEUNREG);
            }
            this.printStatus("ResSim Unregulated Flow");
            this.initProgressStep(15.0, 25.0, this._system.getElementCount(), this._runTimeWindow.getNumSteps());
            this._system.prepUnregulatedFlowCompute();
            n = this.computeSystem(1, "UNREG");
            if (n == 50) {
                return n;
            }
            if (n != 0) {
                this.printErrorMessage("ResSim ERROR: Failed to compute unregulated flows");
                return 1;
            }
            if (bl) {
                this._output.addTSRecordSummaryTable(this.getOutputFPart(), this._unregOutputTSData.getTSRecordSummaryTable("UNREG"));
            }
        }
        long l2 = System.currentTimeMillis();
        lArray[0] = l2 - l;
        return n;
    }

    public int regCompute(long[] lArray) {
        boolean bl;
        long l = System.currentTimeMillis();
        int n = 0;
        boolean bl2 = bl = !this.isIterative();
        if (this._computeReg) {
            if (this._logLevel >= 2) {
                this.printMessage(MSG_COMPUTEREG);
            }
            this.printStatus("ResSim Regulated Flow");
            this.initProgressStep(25.0, 90.0, this._system.getElementCount(), this._runTimeWindow.getNumSteps());
            this._system.prepRegulatedFlowCompute();
            n = this.computeSystem(0, "REG");
            if (n == 50) {
                return n;
            }
            if (n != 0) {
                this.printErrorMessage("ResSim ERROR: Failed to compute regulated flows");
                return 1;
            }
            if (bl) {
                this._output.addTSRecordSummaryTable(this.getOutputFPart(), this._inputTSData.getTSRecordSummaryTable("INPUT"));
                this._output.addTSRecordSummaryTable(this.getOutputFPart(), this._regOutputTSData.getTSRecordSummaryTable("REG"));
            }
        }
        long l2 = System.currentTimeMillis();
        lArray[0] = l2 - l;
        return n;
    }

    public int regFYCompute(long[] lArray) {
        int n = 0;
        YieldAnalysis yieldAnalysis = this._alt.getYieldAnalysis();
        if (yieldAnalysis != null) {
            this.setNumberTasks(yieldAnalysis.getMaxIterations());
        }
        switch (this._alt.getSelectedYieldAnalysis()) {
            case RESERVOIR: {
                n = this.reservoirFYCompute(lArray);
                break;
            }
            case WATER_ACCOUNT: {
                n = this.waterAccountFYCompute(lArray);
                break;
            }
            case REVERSE_RESERVOIR: {
                n = this.reverseFYCompute(lArray);
                break;
            }
            case REVERSE_WATER_ACCOUNT: {
                n = this.reverseWAFYCompute(lArray);
                break;
            }
            case RESERVOIR_STORAGE_VS_YIELD_ANALYSIS: {
                n = this.storageVsYieldAnalysis(lArray);
            }
        }
        if (n == 0 && yieldAnalysis != null && yieldAnalysis != null) {
            this.setTaskNumber(100);
        }
        return n;
    }

    private int reservoirFYCompute(long[] lArray) {
        long l = System.currentTimeMillis();
        int n = 0;
        ReservoirYieldAnalysis reservoirYieldAnalysis = this._alt.getReservoirYieldAnalysis();
        if (this._computeReg && reservoirYieldAnalysis != null) {
            n = reservoirYieldAnalysis.initializeCompute(this);
            if (n != 0) {
                return n;
            }
            YieldAnalysisData yieldAnalysisData = reservoirYieldAnalysis.getYieldAnalysisData();
            int n2 = reservoirYieldAnalysis.getUseBisectionAfterIts(this);
            int n3 = 0;
            int n4 = reservoirYieldAnalysis.getMaxIterations();
            this._stopFYIter = false;
            while (n3 < n4) {
                if ((n = this.singleFirmYieldIteration(reservoirYieldAnalysis, ++n3, lArray, n2)) == 1 || n == 50) {
                    return n;
                }
                if (n == 100) {
                    n = 0;
                    break;
                }
                this.setTaskNumberAsPercent(n3, n4);
            }
            yieldAnalysisData.writePairedData(this, reservoirYieldAnalysis);
            reservoirYieldAnalysis.updateByDemandScale(yieldAnalysisData.getStartScale(n3));
            reservoirYieldAnalysis.setYieldAnalysisRuleUseDemandScale(false);
            this._alt.getSystem().setModified(true);
            this._alt.setModified(true);
        }
        long l2 = System.currentTimeMillis();
        lArray[0] = l2 - l;
        return n;
    }

    private void setTaskNumberAsPercent(int n, int n2) {
        this.setTaskNumber((int)((double)n / (double)n2 * 100.0));
    }

    private int singleFirmYieldIteration(YieldAnalysis yieldAnalysis, int n, long[] lArray, int n2) {
        YieldAnalysisData yieldAnalysisData = yieldAnalysis.getYieldAnalysisData();
        List<YieldAnalysisRuleRef> list = yieldAnalysis.getYieldAnalysisRuleRefs();
        yieldAnalysis.setYieldAnalysisRuleDemandScale(yieldAnalysisData.getStartScale(n));
        this.printMessage(" ");
        this.printMessage("Yield Analysis Compute " + n);
        int n3 = this.regCompute(lArray);
        if (n3 != 0) {
            return n3;
        }
        n3 = yieldAnalysis.loadData(this, n);
        if (n3 == -21) {
            return 1;
        }
        yieldAnalysisData.setRuleTest(n, true);
        yieldAnalysisData.setHeuristicRatioDecr(n, Double.MAX_VALUE);
        for (YieldAnalysisRuleRef yieldAnalysisRuleRef : list) {
            yieldAnalysis.testRule(this, yieldAnalysisRuleRef, n);
        }
        yieldAnalysisData.setStorageTest(n, true);
        yieldAnalysisData.setStorageTolTest(n, true);
        yieldAnalysisData.setHeuristicRatioIncr(n, Double.MAX_VALUE);
        for (YieldAnalysisRuleRef yieldAnalysisRuleRef : list) {
            yieldAnalysis.testStorage(this, yieldAnalysisRuleRef, n);
        }
        int n4 = yieldAnalysisData.getStorageTest(n) ? 22 : (yieldAnalysisData.getStorageTolTest(n) ? 23 : 21);
        if (!yieldAnalysisData.getRuleTest(n)) {
            n4 = 22;
        }
        yieldAnalysisData.setDecision(n, n4);
        if (n == 1) {
            yieldAnalysis.calcAvgStartingRuleDemand(this);
        }
        yieldAnalysisData.printFYComputeMessages(this, yieldAnalysis, n);
        int n5 = yieldAnalysis.getMaxIterations();
        if (yieldAnalysis instanceof ReservoirStorageVsYieldAnalysis) {
            n5 = ((ReservoirStorageVsYieldAnalysis)yieldAnalysis).h();
        }
        if ((n4 = this.checkExitIterationLoop(yieldAnalysisData, n4, n, n5)) == 100) {
            return n4;
        }
        boolean bl = yieldAnalysis.makeDecisionUseBisection(n, n2);
        n4 = bl ? 1 : 0;
        if (bl) {
            this.printMessage("Computing next iteration scale using Bisection Method");
            if (yieldAnalysisData.getIsBracketed(n)) {
                yieldAnalysis.setNextBisectionScaleBracketed(n);
            } else {
                yieldAnalysis.setNextBisectionScaleNotBracketed(n);
            }
        } else {
            this.printMessage("Computing next iteration scale using Heuristics Method");
            yieldAnalysis.setNextHeuristicsScaleWA(n);
        }
        return 0;
    }

    private int checkExitIterationLoop(YieldAnalysisData yieldAnalysisData, int n, int n2, int n3) {
        if (n == 23) {
            yieldAnalysisData.setScalesConverged(n2);
            return 100;
        }
        if (n2 == n3) {
            this.printWarningMessage("Warning - maximum number of iterations reached without convergence");
            return 100;
        }
        if (this._stopFYIter) {
            yieldAnalysisData.setDecision(n2, -22);
            this.printMessage("Yield Analysis stopped by script");
            return 100;
        }
        if (yieldAnalysisData.getIsBracketed(n2)) {
            if (n == 21 && yieldAnalysisData.getStartScale(n2) == yieldAnalysisData.getUpperScale(n2)) {
                this.printWarningMessage("Warning - Maximum user-defined variation in rule demand reached.");
                this.printWarningMessage("Cannot increase demand scale beyond upper limit.");
                yieldAnalysisData.setDecision(n2, 23);
                yieldAnalysisData.setScalesConverged(n2);
                return 100;
            }
            if (n == 22 && yieldAnalysisData.getStartScale(n2) == yieldAnalysisData.getLowerScale(n2)) {
                this.printWarningMessage("Warning - Maximum user-defined variation in rule demand reached.");
                this.printWarningMessage("Cannot decrease demand scale beyond lower limit.");
                yieldAnalysisData.setDecision(n2, 23);
                yieldAnalysisData.setScalesConverged(n2);
                return 100;
            }
        }
        return 0;
    }

    private int waterAccountFYCompute(long[] lArray) {
        long l = System.currentTimeMillis();
        int n = 0;
        WaterAccountYieldAnalysis waterAccountYieldAnalysis = this._alt.getWaterAccountYieldAnalysis();
        if (this._computeReg && waterAccountYieldAnalysis != null) {
            n = waterAccountYieldAnalysis.initializeCompute(this);
            if (n != 0) {
                return n;
            }
            WaterAccount waterAccount = waterAccountYieldAnalysis.getWaterAccount(this._alt);
            YieldAnalysisData yieldAnalysisData = waterAccountYieldAnalysis.getYieldAnalysisData();
            int n2 = waterAccountYieldAnalysis.getUseBisectionAfterIts(this);
            int n3 = 0;
            int n4 = waterAccountYieldAnalysis.getMaxIterations();
            this._stopFYIter = false;
            while (n3 < n4) {
                waterAccountYieldAnalysis.setYieldAnalysisRuleDemandScale(yieldAnalysisData.getStartScale(++n3));
                this.printMessage(" ");
                this.printMessage("Water Account Yield Analysis Compute " + n3);
                n = this.regCompute(lArray);
                if (n != 0) {
                    return n;
                }
                n = waterAccountYieldAnalysis.loadWaterAccountData(this, waterAccount, n3);
                if (n == -21) {
                    n = 1;
                    break;
                }
                n = waterAccountYieldAnalysis.testWaterAccountRule(this, n3);
                int n5 = waterAccountYieldAnalysis.testWaterAccountStorage(this, n3, waterAccountYieldAnalysis.a());
                if (n == 24) {
                    n5 = 22;
                }
                yieldAnalysisData.setDecision(n3, n5);
                if (n3 == 1) {
                    waterAccountYieldAnalysis.calcAvgStartingRuleDemand(this);
                    waterAccountYieldAnalysis.b();
                }
                yieldAnalysisData.printFYComputeMessages(this, waterAccountYieldAnalysis, n3);
                n = this.checkExitIterationLoop(yieldAnalysisData, n5, n3, n4);
                if (n == 100) {
                    n = 0;
                    break;
                }
                boolean bl = waterAccountYieldAnalysis.makeDecisionUseBisection(n3, n2);
                n5 = bl ? 1 : 0;
                if (bl) {
                    this.printMessage("Computing next iteration scale using Bisection Method");
                    if (yieldAnalysisData.getIsBracketed(n3)) {
                        waterAccountYieldAnalysis.setNextBisectionScaleBracketed(n3);
                    } else {
                        waterAccountYieldAnalysis.setNextBisectionScaleNotBracketed(n3);
                    }
                } else {
                    this.printMessage("Computing next iteration scale using Heuristics Method");
                    waterAccountYieldAnalysis.setNextHeuristicsScaleWA(n3);
                }
                this.setTaskNumberAsPercent(n3, n4);
            }
            yieldAnalysisData.writePairedData(this, waterAccountYieldAnalysis);
            waterAccountYieldAnalysis.updateByDemandScale(yieldAnalysisData.getStartScale(n3));
            waterAccountYieldAnalysis.setYieldAnalysisRuleUseDemandScale(false);
            this._alt.getSystem().setModified(true);
            this._alt.setModified(true);
        }
        long l2 = System.currentTimeMillis();
        lArray[0] = l2 - l;
        return n;
    }

    private int reverseWAFYCompute(long[] lArray) {
        long l = System.currentTimeMillis();
        int n = 0;
        ReverseWaterAccountYieldAnalysis reverseWaterAccountYieldAnalysis = this._alt.getReverseWaterAccountYieldAnalysis();
        if (this._computeReg && reverseWaterAccountYieldAnalysis != null) {
            n = ((YieldAnalysis)reverseWaterAccountYieldAnalysis).initializeCompute(this);
            if (n != 0) {
                return n;
            }
            WaterAccount waterAccount = reverseWaterAccountYieldAnalysis.d();
            waterAccount.setUseStorageScale(true);
            YieldAnalysisData yieldAnalysisData = reverseWaterAccountYieldAnalysis.getYieldAnalysisData();
            int n2 = reverseWaterAccountYieldAnalysis.getUseBisectionAfterIts(this);
            this._stopFYIter = false;
            int n3 = 0;
            int n4 = reverseWaterAccountYieldAnalysis.getMaxIterations();
            while (n3 < n4) {
                waterAccount.setStorageScale(yieldAnalysisData.getStartScale(++n3));
                this.printMessage(" ");
                this.printMessage("Reverse Water Account Yield Analysis Compute " + n3);
                n = this.regCompute(lArray);
                if (n != 0) break;
                n = reverseWaterAccountYieldAnalysis.loadWaterAccountData(this, waterAccount, n3);
                if (n == -21) {
                    n = 1;
                    break;
                }
                int n5 = reverseWaterAccountYieldAnalysis.testWaterAccountRule(this, n3);
                int n6 = reverseWaterAccountYieldAnalysis.testWaterAccountStorage(this, n3, reverseWaterAccountYieldAnalysis.p().getValue());
                if (n5 == 24) {
                    n6 = 21;
                }
                yieldAnalysisData.setDecision(n3, n6);
                if (n3 == 1) {
                    reverseWaterAccountYieldAnalysis.a(this);
                    reverseWaterAccountYieldAnalysis.q();
                }
                yieldAnalysisData.printRevFYComputeMessages(this, reverseWaterAccountYieldAnalysis, n3);
                if (n6 == 23) {
                    yieldAnalysisData.setScalesConverged(n3);
                    break;
                }
                if (n3 == n4) {
                    this.printWarningMessage("Warning - maximum number of iterations reached without convergence");
                    break;
                }
                if (yieldAnalysisData.getStartScale(n3) == 1.0 && yieldAnalysisData.getDecision(n3) == 21) {
                    this.printWarningMessage("Water Supply Pool Storage Reached Upper Limit");
                    break;
                }
                if (this._stopFYIter) {
                    yieldAnalysisData.setDecision(n3, -22);
                    this.printMessage("Yield Analysis stopped by script");
                    break;
                }
                boolean bl = reverseWaterAccountYieldAnalysis.makeDecisionUseBisection(n3, n2);
                n5 = bl ? 1 : 0;
                if (bl) {
                    this.printMessage("Computing next iteration scale using Bisection Method");
                    reverseWaterAccountYieldAnalysis.setNextBisectionScaleBracketed(n3);
                } else {
                    this.printMessage("Computing next iteration scale using Heuristics Method");
                    reverseWaterAccountYieldAnalysis.b(n3);
                }
                this.setTaskNumberAsPercent(n3, n4);
            }
            reverseWaterAccountYieldAnalysis.c(n3);
            yieldAnalysisData.writePairedDataReverse(this, reverseWaterAccountYieldAnalysis);
            waterAccount.setUseStorageScale(false);
            this._alt.getSystem().setModified(true);
            this._alt.setModified(true);
        }
        long l2 = System.currentTimeMillis();
        lArray[0] = l2 - l;
        return n;
    }

    private int reverseFYCompute(long[] lArray) {
        long l = System.currentTimeMillis();
        int n = 0;
        ReverseReservoirYieldAnalysis reverseReservoirYieldAnalysis = this._alt.getReverseReservoirYieldAnalysis();
        if (this._computeReg && reverseReservoirYieldAnalysis != null) {
            n = ((YieldAnalysis)reverseReservoirYieldAnalysis).initializeCompute(this);
            if (n != 0) {
                return n;
            }
            Cloneable cloneable = reverseReservoirYieldAnalysis.k();
            OpSet opSet = ((ReservoirElement)cloneable).getReservoirOp().getActiveOpSet();
            n = opSet.setUseStorageScale(true, reverseReservoirYieldAnalysis);
            if (n != 0) {
                return n;
            }
            cloneable = reverseReservoirYieldAnalysis.getYieldAnalysisData();
            int n2 = reverseReservoirYieldAnalysis.getUseBisectionAfterIts(this);
            this._stopFYIter = false;
            int n3 = 0;
            int n4 = reverseReservoirYieldAnalysis.getMaxIterations();
            while (n3 < n4) {
                boolean bl;
                opSet.setStorageScale(((YieldAnalysisData)cloneable).getStartScale(++n3), reverseReservoirYieldAnalysis);
                this.printMessage(" ");
                this.printMessage("Reverse Yield Analysis Compute " + n3);
                n = this.regCompute(lArray);
                if (n != 0) break;
                n = ((YieldAnalysis)reverseReservoirYieldAnalysis).loadData(this, n3);
                if (n == -21) {
                    n = 1;
                    break;
                }
                boolean bl2 = reverseReservoirYieldAnalysis.a(this, n3);
                int n5 = reverseReservoirYieldAnalysis.a(n3);
                if (bl2) {
                    n5 = 21;
                }
                ((YieldAnalysisData)cloneable).setDecision(n3, n5);
                if (n3 == 1) {
                    reverseReservoirYieldAnalysis.a(this);
                    reverseReservoirYieldAnalysis.q();
                }
                ((YieldAnalysisData)cloneable).printRevFYComputeMessages(this, reverseReservoirYieldAnalysis, n3);
                if (n5 == 23) {
                    ((YieldAnalysisData)cloneable).setScalesConverged(n3);
                    break;
                }
                if (n3 == n4) {
                    this.printWarningMessage("Warning - maximum number of iterations reached without convergence");
                    break;
                }
                boolean bl3 = reverseReservoirYieldAnalysis.b(((YieldAnalysisData)cloneable).getDecision(n3));
                bl2 = bl3;
                Object object = bl3 ? "Upper" : "Lower";
                object = "Water Supply Pool Storage Reached " + (String)object + " Limit";
                boolean bl4 = ((YieldAnalysisData)cloneable).getStartScale(n3) == 1.0 && bl2;
                boolean bl5 = bl = ((YieldAnalysisData)cloneable).getStartScale(n3) == -1.0 && !bl2;
                if (n3 > 1 && Math.abs(((YieldAnalysisData)cloneable).getAvgConPoolStorage(n3) - ((YieldAnalysisData)cloneable).getAvgConPoolStorage(n3 - 1)) < 10.0) {
                    this.printWarningMessage((String)object);
                    break;
                }
                if (bl4 || bl) {
                    this.printWarningMessage((String)object);
                    break;
                }
                if (this._stopFYIter) {
                    ((YieldAnalysisData)cloneable).setDecision(n3, -22);
                    this.printMessage("Yield Analysis stopped by script");
                    break;
                }
                n5 = reverseReservoirYieldAnalysis.makeDecisionUseBisection(n3, n2) ? 1 : 0;
                if (n3 == 1) {
                    reverseReservoirYieldAnalysis.a(bl2);
                } else if (n5 != 0) {
                    this.printMessage("Computing next iteration scale using Bisection Method");
                    reverseReservoirYieldAnalysis.setNextBisectionScaleBracketed(n3);
                } else {
                    this.printMessage("Computing next iteration scale using Heuristics Method");
                    reverseReservoirYieldAnalysis.c(n3);
                }
                this.setTaskNumberAsPercent(n3, n4);
            }
            ((YieldAnalysisData)cloneable).writePairedDataReverse(this, reverseReservoirYieldAnalysis);
            opSet.setUseStorageScale(false, reverseReservoirYieldAnalysis);
            this._alt.getSystem().setModified(true);
            this._alt.setModified(true);
        }
        long l2 = System.currentTimeMillis();
        lArray[0] = l2 - l;
        return n;
    }

    private int storageVsYieldAnalysis(long[] lArray) {
        long l = System.currentTimeMillis();
        int n = 0;
        ReservoirStorageVsYieldAnalysis reservoirStorageVsYieldAnalysis = this._alt.getReservoirStorageVsYieldAnalysis();
        if (this._computeReg && reservoirStorageVsYieldAnalysis != null) {
            n = ((YieldAnalysis)reservoirStorageVsYieldAnalysis).initializeCompute(this);
            if (n != 0) {
                return n;
            }
            YieldAnalysisData yieldAnalysisData = reservoirStorageVsYieldAnalysis.getYieldAnalysisData();
            int n2 = reservoirStorageVsYieldAnalysis.getUseBisectionAfterIts(this);
            int n3 = 0;
            int n4 = reservoirStorageVsYieldAnalysis.d();
            while (n3 < n4) {
                this.printMessage(" ");
                this.printMessage("***********************************************************************");
                this.printMessage("Storage Vs. Yield Analysis Interval " + ++n3);
                this.printMessage("***********************************************************************");
                yieldAnalysisData.setElevationInterval(n3);
                reservoirStorageVsYieldAnalysis.c(n3);
                reservoirStorageVsYieldAnalysis.i();
                reservoirStorageVsYieldAnalysis.initializeOutputArrays();
                this._stopFYIter = false;
                int n5 = 0;
                int n6 = reservoirStorageVsYieldAnalysis.h();
                while (n5 < n6) {
                    if ((n = this.singleFirmYieldIteration(reservoirStorageVsYieldAnalysis, ++n5, lArray, n2)) == 1 || n == 50) {
                        return n;
                    }
                    if (n != 100) continue;
                }
                double d = yieldAnalysisData.getStartScale(n5) * yieldAnalysisData.getAvgStartingRuleDemand();
                reservoirStorageVsYieldAnalysis.a(n3, d);
                int n7 = yieldAnalysisData.getDecision(n5);
                reservoirStorageVsYieldAnalysis.a(n3, n7 == 23);
                if (reservoirStorageVsYieldAnalysis.a(n3)) {
                    yieldAnalysisData.writePairedData(this, reservoirStorageVsYieldAnalysis);
                }
                this.setTaskNumberAsPercent(n5, n6);
            }
            reservoirStorageVsYieldAnalysis.a(this);
            this._alt.getSystem().setModified(true);
            this._alt.setModified(true);
        }
        if (n == 100) {
            n = 0;
        }
        long l2 = System.currentTimeMillis();
        lArray[0] = l2 - l;
        return n;
    }

    public int holdOutCompute(long[] lArray) {
        long l = System.currentTimeMillis();
        int n = 0;
        if (this._computeHoldout) {
            if (this._logLevel >= 2) {
                this.printMessage(MSG_COMPUTEHOLDOUT);
            }
            this.printStatus("ResSim Holdout Flows");
            String[] stringArray = this._system.getReservoirNames();
            if (stringArray != null && stringArray.length > 0) {
                this._holdoutOutputTSDataVec = new Vector();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.printMessage("\tReservoir: " + stringArray[i]);
                    this._system.prepHoldoutCompute(stringArray[i]);
                    n = this.computeSystem(2, "HOLDOUT-" + stringArray[i]);
                    if (n == 50) {
                        return n;
                    }
                    if (n != 0) {
                        this.printErrorMessage("ResSim ERROR: Failed to compute holdout flows for reservoir " + stringArray[i]);
                        this.printStatus("ResSim COMPUTE FAILED");
                        return 1;
                    }
                    this._holdoutOutputTSDataVec.addElement(this._outputTSData);
                }
            }
        }
        long l2 = System.currentTimeMillis();
        lArray[0] = l2 - l;
        return n;
    }

    public int finalizeCompute(long[] lArray, boolean bl) {
        return this.finalizeCompute(lArray, bl, true);
    }

    public int finalizeCompute(long[] lArray, boolean bl, boolean bl2) {
        this._system.printMessage("Finalizing Compute...");
        long l = System.currentTimeMillis();
        this.printMessage("\nResSim Compute Complete\n");
        this.printStatus("Saving output");
        RssRun rssRun = this;
        rssRun.saveOutput(!rssRun.usesTimeBlocking() && bl, bl2);
        this._system.finalizeCompute();
        this._system.prepRegulatedFlowCompute();
        List<EmbeddedAlternative> list = this.getEmbeddedAltList();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                EmbeddedAlternative embeddedAlternative = list.get(i);
                if (embeddedAlternative == null || embeddedAlternative.cleanupCompute() == 0) continue;
                this.printErrorMessage("ResSim ERROR: Failed to finalize embedded alternative");
                return 1;
            }
        }
        long l2 = System.currentTimeMillis();
        lArray[0] = l2 - l;
        return 0;
    }

    private int computeReg() {
        if (this._logLevel >= 2) {
            this.printMessage(MSG_COMPUTEREG);
        }
        this.printStatus("ResSim Regulated Flow");
        this.initProgressStep(25.0, 90.0, this._system.getElementCount(), this._runTimeWindow.getNumSteps());
        this._system.prepRegulatedFlowCompute();
        int n = this.computeSystem(0, "REG");
        if (n == 50) {
            return n;
        }
        if (n != 0) {
            this.printErrorMessage("ResSim ERROR: Failed to compute regulated flows");
            return 1;
        }
        this._output.addTSRecordSummaryTable(this.getOutputFPart(), this._inputTSData.getTSRecordSummaryTable("INPUT"));
        this._output.addTSRecordSummaryTable(this.getOutputFPart(), this._regOutputTSData.getTSRecordSummaryTable("REG"));
        return n;
    }

    @Scriptable
    public RunTimeWindow getCurrentComputeBlockRunTimeWindow() {
        if (this._currentComputeBlockTimwWindow != null) {
            return this._currentComputeBlockTimwWindow;
        }
        return this._runTimeWindow;
    }

    int computeSystem(int n, String string) {
        int n2;
        boolean bl = this.usesTimeBlocking() || this.isSeededCompute();
        boolean bl2 = !this.isIterative();
        this._outputTSData = this._runId == null ? this.createOutputTSData(this._alt.getName(), string, n) : this.createOutputTSData(this._runId.substring(0, this._modelPos), string, n);
        this._system.setUserInterface(this._uiWrapper);
        this._inputTSData.setUserInterface(this._uiWrapper);
        this._outputTSData.setUserInterface(this._uiWrapper);
        if (this._logLevel >= 2) {
            this.printLogMessage("\nOrdering Elements for Compute.");
        }
        if ((n2 = this._system.orderElementsForCompute(n)) == 0) {
            return 1;
        }
        for (int i = 0; i < this._timeBlockVec.size(); ++i) {
            int n3;
            boolean bl3;
            System.out.println("Time Block Number ==> " + i);
            this._timeBlockNum = i;
            RunTimeWindow runTimeWindow = ((RunTimeWindow)this._timeBlockVec.elementAt(i)).clone();
            System.out.println("computeSystem:using Time Block " + String.valueOf(runTimeWindow));
            this._currentComputeBlockTimwWindow = runTimeWindow;
            if (i == 0) {
                bl3 = this.initInputTSData(runTimeWindow);
                if (this._observedTSData != null) {
                    this.initObsTSData(runTimeWindow);
                }
                n3 = this._outputTSData.initialize(runTimeWindow);
                System.setProperty("SKIP_INITIALIZE", "true");
            } else {
                System.setProperty("SKIP_INITIALIZE", "false");
                bl3 = true;
                System.out.println("computeSystem:shifting data...");
                this._inputTSData.shiftDataSet(runTimeWindow);
                n3 = 1;
                this._outputTSData.shiftDataSet(runTimeWindow);
            }
            boolean bl4 = this._system.initialize(this._inputTSData, this._outputTSData, this._inputGVData, this._regOutputGVData, n, runTimeWindow);
            if (!bl3) {
                this.printErrorMessage("ResSim ERROR: Failed to initialize Input Timeseries ");
            }
            if (n3 == 0) {
                this.printErrorMessage("ResSim ERROR: Failed to initialize Output Timeseries ");
            }
            if (!bl4) {
                this.printErrorMessage("ResSim ERROR: Failed to initialize Network");
            }
            if (!bl3 || n3 == 0 || !bl4) {
                return 1;
            }
            int n4 = 0;
            if (runTimeWindow.isPerAvgTimeStep()) {
                n4 = 1;
            }
            this._inputTSData.setType(n4);
            this._outputTSData.setType(n4);
            n2 = this.loadInputTimeSeries(runTimeWindow);
            if (n2 != 0) {
                this.printErrorMessage("ResSim ERROR: Failed to load time-series records");
                return 1;
            }
            if (this._logLevel >= 2) {
                this.printLogMessage("\nStarting Computations.");
            }
            n2 = this._system.compute(runTimeWindow, this, n, i == 0);
            if (this._logLevel >= 2) {
                this.printLogMessage("\nSaving ResSim time-series output");
            }
            this.printStatus("Saving ResSim time-series output");
            this._outputTSData.setCompressData(true);
            if (bl) {
                this.writeFilteredOutputTSRecords(n, this._outputTSData);
                if (n == 0) {
                    this._regOutputGVData.writeData();
                    if (this.shouldComputeWaterQuality() && this.isCoupledWQCompute()) {
                        this._wqRun.writeWQTSRecords(this._wqOutputTSData);
                    }
                }
            }
            if (bl2) {
                this._system.writeHotstartStates(runTimeWindow);
            }
            if (n == 0) {
                List<StateVariable> list = this._system.getStateVariableList();
                n3 = list.size();
                for (n4 = 0; n4 < n3; ++n4) {
                    StateVariable stateVariable = list.get(n4);
                    if (stateVariable.runCleanupScript()) continue;
                    n2 = 1;
                    break;
                }
            }
            if (n2 == 50) {
                this.printWarningMessage("Compute canceled");
                return n2;
            }
            if (n2 != 0) {
                this.printErrorMessage("ResSim ERROR: System Computations failed!");
                return 1;
            }
            if (n == 3) break;
        }
        return 0;
    }

    private boolean initInputTSData(RunTimeWindow runTimeWindow) {
        boolean bl = this._inputTSData.initialize(runTimeWindow);
        Vector vector = this._inputTSData.getTSRecords();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            TSRecord tSRecord = (TSRecord)vector.get(i);
            if (!(tSRecord instanceof RssTSRecordImpl)) continue;
            ((RssTSRecordImpl)tSRecord).setRssRun(this);
        }
        return bl;
    }

    private boolean initObsTSData(RunTimeWindow runTimeWindow) {
        if (this._observedTSData == null) {
            return false;
        }
        boolean bl = this._observedTSData.initialize(runTimeWindow);
        Vector vector = this._observedTSData.getTSRecords();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            TSRecord tSRecord = (TSRecord)vector.get(i);
            if (!(tSRecord instanceof RssTSRecordImpl)) continue;
            ((RssTSRecordImpl)tSRecord).setRssRun(this);
        }
        return bl;
    }

    protected void backupConfigFiles(String object) {
        object = (String)object + "/rss";
        this.printMessage("Saving ResSim configuration files to forecast directory");
        try {
            if (!this._alt.backupFile((String)object)) {
                this.printWarningMessage("Failed to copy ResSim Alternative to forecast directory");
            }
            if (!this._system.backupFile((String)object)) {
                this.printWarningMessage("Failed to copy ResSim System to forecast directory");
            }
            TsVariant tsVariant = this._alt.getTsVariant(this._variantName);
            if ((tsVariant = this._alt.getInputTSDataSet(tsVariant)) != null && !tsVariant.backupFile((String)object)) {
                this.printWarningMessage("Failed to copy ResSim Input TS to forecast directory");
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("Error copying ResSim configuration files to forecast directory " + String.valueOf(exception));
            exception.printStackTrace();
            this.printWarningMessage("Error copying ResSim configuration files to forecast directory " + String.valueOf(exception));
            return;
        }
    }

    String getOutputFileName() {
        return this.getOutputFileName(true);
    }

    private String getOutputFileName(boolean bl) {
        String string = bl ? RMAIO.userNameToFileName((String)this.getName()) : this.getName();
        int n = string.indexOf(".");
        if (n >= 0) {
            return string.substring(0, n - 1) + ".rssout";
        }
        return string + ".rssout";
    }

    int saveOutput(boolean bl, boolean bl2) {
        if (bl) {
            this._system.updateTSProxyList();
            if (this._computeCumLoc && this._cumlocOutputTSData != null) {
                this.writeFilteredOutputTSRecords(4, this._cumlocOutputTSData);
            }
            if (this._computeReg && this._regOutputTSData != null) {
                this.writeFilteredOutputTSRecords(0, this._regOutputTSData);
            }
            if (this._computeUnReg && this._unregOutputTSData != null) {
                this.writeFilteredOutputTSRecords(1, this._unregOutputTSData);
            }
            if (this._computeHoldout && this._holdoutOutputTSDataVec != null) {
                for (String string : this._holdoutOutputTSDataVec) {
                    if (string == null) continue;
                    this.writeFilteredOutputTSRecords(2, (TSDataSet)string);
                }
            }
            if (this._computeReg && this._regOutputGVData != null) {
                this._regOutputGVData.writeData();
            }
        }
        if (bl2) {
            if (this._output == null) {
                this.printErrorMessage("RssRun.saveOutput: No output available");
                return 1;
            }
            try {
                String string;
                Object object = this.getIdentifier();
                string = RMAIO.getDirectoryFromPath((String)object.getPath());
                object = string + "/" + this.getOutputFileName();
                object = new Identifier((String)object);
                Identifier identifier = this.openFile((Identifier)object);
                if (identifier == null) {
                    identifier = this.newFile((Identifier)object);
                }
                if ((object = identifier) == null || object.getFile() == null) {
                    this.printErrorMessage("RssRun.saveOutput: Output identifier or file is null");
                    return 1;
                }
                if (!this.writeOutput((Identifier)object)) {
                    this.printErrorMessage("RssRun.saveOutput: Failed to write output");
                    return 1;
                }
            }
            catch (Exception exception) {
                this.printErrorMessage("RssRun.saveOutput: Execption writing ResSim output: " + String.valueOf(exception));
                return 1;
            }
        }
        return 0;
    }

    public String getOutputFile(boolean bl) {
        Object object = this.getIdentifier();
        object = RMAIO.getDirectoryFromPath((String)object.getPath());
        String string = (String)object + "/" + this.getOutputFileName(bl);
        return string;
    }

    public RssOutput getOutput() {
        if (this._output != null) {
            return this._output;
        }
        try {
            String string = this.getOutputFile(true);
            string = new Identifier(string);
            string = this.openFile((Identifier)string);
            if (string == null) {
                System.out.println("RssRun.getOutput: could not get output file for run " + this.getName());
                string = this.getOutputFile(false);
                string = new Identifier(string);
                string = this.openFile((Identifier)string);
                if (string == null) {
                    System.out.println("RssRun.getOutput: could not get output file for run " + this.getName());
                    return null;
                }
            }
            if (string.getFile() == null) {
                System.out.println("RssRun.getOutput: could not get output file for run " + this.getName());
                return null;
            }
            this._output = new RssOutput();
            this._output.setIdentifier((Identifier)string);
            this._output.readFile();
        }
        catch (Exception exception) {
            System.out.println("Execption reading ResSim output: " + String.valueOf(exception));
            return null;
        }
        return this._output;
    }

    int initCompute() {
        int n;
        boolean bl = !this.isIterative();
        RssRun rssRun = this;
        rssRun.printMessage("Computing Using Variant " + rssRun._variantName);
        if (this._logLevel > 4) {
            this.printLogMessage("Loading Managers");
        }
        if ((n = this.loadMangers()) != 0) {
            this.printErrorMessage("Failed to load Managers");
            return n;
        }
        if (this._system != null && this._system.isComputeCanceled()) {
            return 50;
        }
        if (this._logLevel > 4) {
            this.printLogMessage("Processing Time Window");
        }
        if ((n = this.initSimulationTime()) != 0) {
            this.printErrorMessage("Failed to set up simulation time");
            return n;
        }
        if (this._alt != null) {
            this._alt.setUserInterface(this._uiWrapper);
            this._alt.initCompute();
            n = this.checkLookbackConstants();
            if (n == 1) {
                return 1;
            }
        }
        if ((n = this.checkZoneElevations()) == 1) {
            return 1;
        }
        if (this._system != null && this._system.isComputeCanceled()) {
            return 50;
        }
        this._output = new RssOutput();
        this._output.setUnitSystem(this.getUnitSystem());
        if (bl) {
            this._system.initHotstart(this._runTimeWindow);
        }
        if (!this.updateReleaseOverrides()) {
            return 1;
        }
        return 0;
    }

    private int checkZoneElevations() {
        Vector<ReservoirElement> vector = this._system.getElementVectorByClass(ReservoirElement.class);
        HashMap<Double, StorageZone> hashMap = new HashMap<Double, StorageZone>();
        boolean bl = false;
        block0: for (int i = 0; i < vector.size(); ++i) {
            hashMap.clear();
            ReservoirElement reservoirElement = (ReservoirElement)vector.get(i);
            Object object = reservoirElement.getReservoirOp().getActiveOpSet();
            object = ((OpSet)object).getZoneVector();
            for (int j = 0; j < object.size(); ++j) {
                StorageZone storageZone = (StorageZone)object.get(j);
                Object object2 = storageZone.getSeasonalRecord();
                double d = object2 != null && object2.size() > 0 ? object2.getDataArray()[0] : storageZone.getReferenceValue();
                if (RMAConst.isUndefinedValue((double)d)) {
                    this.printWarningMessage("No zone sort value found for Reservoir:" + String.valueOf(reservoirElement) + " Zone:" + String.valueOf(storageZone));
                    continue;
                }
                object2 = (StorageZone)hashMap.get(d);
                if (object2 != null) {
                    this.printErrorMessage("ERROR: Two or more zones at Reservoir: " + String.valueOf(reservoirElement) + " have the same zone sort value (" + d + ")!");
                    bl = true;
                    continue block0;
                }
                hashMap.put(d, storageZone);
            }
        }
        if (bl) {
            this.printErrorMessage("");
            this.printErrorMessage("Equal zone sort elevations have been found at one or more reservoirs.");
            this.printErrorMessage("This is not allowed and constitutes a fatal error.");
            this.printErrorMessage("For zones defined as a function of date, the zone sort value is the value on 01Jan.");
            this.printErrorMessage("For all other zone specifications, the zone sort value is explicitly defined at the bottom of the zone edit panel.");
            this.printErrorMessage("You must modify the zone sort value in at least one zone of this reservoir's active operation set to indicate the relative order of the zones.");
            this.printErrorMessage("No two values may be exactly the same.");
            return 1;
        }
        return 0;
    }

    int loadMangers() {
        if (this._logLevel > 5) {
            RssRun rssRun = this;
            rssRun.printLogMessage("Loading ResSim Alternative: " + rssRun._altPath);
        }
        if (this.getAlternative() == null) {
            this.printErrorMessage("Failed to load alternative");
            return 1;
        }
        if (this._logLevel > 5) {
            RssRun rssRun = this;
            rssRun.printLogMessage("Loading ResSim System: " + rssRun._alt.getSystemPath());
        }
        this._system = this._alt.getSystem();
        if (this._system == null) {
            this.printErrorMessage("Failed to load RssSystem");
            return 1;
        }
        this._system.setRssRun(this);
        if (this._logLevel > 5) {
            RssRun rssRun = this;
            rssRun.printLogMessage("Loading Input Time Series: " + rssRun._alt.getInputTSDataPath(this._variantName));
        }
        TsVariant tsVariant = this._alt.getTsVariant(this._variantName);
        this._inputTSData = this._alt.getInputTSDataSet(tsVariant);
        if (this._runId != null) {
            this._inputTSData = this.createForecastInputTSData(this._inputTSData, this.getDSSOutputFile(), this._runId);
        }
        this._observedTSData = this.getObservedTSData();
        if (this._inputTSData == null) {
            this.printErrorMessage("Failed to load input TSDataSet");
            return 1;
        }
        String string = this._runId;
        if (string == null) {
            string = this._alt.getName();
        }
        this._inputTSData.setAltName(string);
        this._inputGVData = this._alt.getInputGVDataSet(tsVariant);
        if (this._runId != null) {
            this._inputGVData = this.createForecastInputGVData(this._inputGVData, this.getDSSOutputFile(), this._runId);
        }
        if (this._inputGVData == null) {
            this.printErrorMessage("Failed to load input Global Variable DataSet");
            return 1;
        }
        if (this._alt.hasWaterQualityOptions() && this._alt.getWaterQualityOptions().shouldRunWq()) {
            this._inputWQTSData = this._alt.getInputWQTSDataSet(tsVariant);
            if (this._runId != null) {
                this._inputWQTSData = this.createForecastInputTSData(this._inputWQTSData, this.getDSSOutputFile(), this._runId);
            }
            if (this._inputWQTSData == null) {
                this.printErrorMessage("Failed to load input Water Qaulity Variable DataSet");
                return 1;
            }
        }
        this._regOutputGVData = this.getRegOutputGVData();
        if (this._regOutputGVData == null) {
            this.printErrorMessage("Failed to load output Global Variable DataSet");
            return 1;
        }
        return 0;
    }

    int loadInputTimeSeries(RunTimeWindow runTimeWindow) {
        Vector vector;
        TSRecordProxy tSRecordProxy;
        if (this._system == null) {
            return 1;
        }
        long l = System.currentTimeMillis();
        this.printStatus("Loading Input Timeseries");
        this._system.updateTSProxyList();
        Vector vector2 = this._system.getActiveTSProxies(null, 1);
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            tSRecordProxy = (TSRecordProxy)vector2.get(i);
            tSRecordProxy.setInterpUnitsType("INST-VAL");
            if (!runTimeWindow.isPerAvgTimeStep()) continue;
            Object object = RssModelVariableSet.getModelVariable(tSRecordProxy.getVariableId());
            if (object != null) {
                int n2 = object.getParamId();
                if (n2 == Parameter.PARAMID_ELEV || n2 == Parameter.PARAMID_STOR) continue;
                tSRecordProxy.setInterpUnitsType("PER-AVER");
                continue;
            }
            object = tSRecordProxy.getParamName().toLowerCase();
            if (((String)object).startsWith("elev") || ((String)object).startsWith("stor")) continue;
            tSRecordProxy.setInterpUnitsType("PER-AVER");
        }
        if (this._timeBlockNum > 0) {
            Iterator iterator = vector2.iterator();
            while (iterator.hasNext()) {
                tSRecordProxy = (TSRecordProxy)iterator.next();
                if (!this.isHindcastId(tSRecordProxy.getVariableId())) continue;
                iterator.remove();
            }
        }
        if (!this.checkTSRecords(vector = this._inputTSData.getFilteredTSRecords(vector2), runTimeWindow)) {
            return 1;
        }
        if (!this._inputTSData.loadFilteredTSRecords(vector2)) {
            return 1;
        }
        this.printDatumConversionMessages(vector2);
        this.convertInputTimeSeriesToVerticalDatum(vector2);
        if (this.getAlternative().useObsTSData() && this._observedTSData != null) {
            this.printMessage("Loading Observed Timeseries");
            this._observedTSData.loadTSRecords();
        }
        long l2 = System.currentTimeMillis();
        if (this._logLevel > 5) {
            this.printMessage("Loading Input Timeseries done. took " + (l2 - l) + " ms");
        }
        return 0;
    }

    protected void printDatumConversionMessages(List list) {
        boolean bl;
        Object object2 = this.getAlternative();
        object2 = ((RssAlt)object2).getOutputVerticalDatumType();
        this.printLogMessage("\nManaging Native Vertical Datum Information");
        String string = "\nNOTE: Vertical Datum conversions of the input and/or output elevation data may have been performed. Please review the compute log for more information.";
        String string2 = "\nThe Native Vertical Datum for all relevant model elements is set to \"Unspecified\".\nNo Vertical Datum conversions were performed on the input or output data.";
        Object object3 = "\nNOTE: This model contains one or more model elements with a native vertical datum specified. In addition, the input elevation time series data associated with one or more of these model elements also contains vertical datum information.  The vertical datum conversion information defined in the ResSim model may not match the conversion information carried by the input data.\n\nAs needed, ResSim used the conversion information contained in each input elevation time series dataset to convert that data to the associated element's native vertical datum as specified in the model.  However, as needed, ResSim used the conversion information specified in the model when writing the alternative's results to the simulation.dss file.";
        String cfr_ignored_0 = "\nNOTE: This model contains one or more model elements with a native vertical datum specified. In addition, the input elevation time series data associated with one or more of these model elements also contains vertical datum information.  The vertical datum conversion information defined in the ResSim model may not match the conversion information carried by the input data.\n\nAs needed, ResSim used the conversion information contained in each input elevation time series dataset to convert that data to the associated element's native vertical datum as specified in the model.  However, as needed, ResSim used the conversion information specified in the model when writing the alternative's results to the simulation.dss file." + "Please review the information in the following table which shows the vertical datum conversion values used on input and output for each relevant model location.";
        object3 = (String)object3 + "\n\nPlease use HEC-DSSVue to view the vertical datum information for each input elevation time series.  The vertical datum information can be found in the Supplemental Information dialog available from the Display menu of DSSVue";
        Object object4 = "\nNOTE: This model contains one or more model elements with a Native Vertical Datum specified.\nHowever, the input elevation time series data associated with these model elements \ndo not contain vertical datum information. ResSim assumed the input data was already in each location's native datum so no conversion of the input was performed.";
        Object object5 = MessageFormat.format("\n\nThe vertical datum selection for the output from this alternative is:  {0}.\nTherefore, as needed, ResSim used the vertical datum conversion information specified in\nthe model for each relevant model element when writing the alternative's results to the simulation.dss file. ", ((Enum)object2).toString());
        object5 = (String)object4 + (String)object5;
        String cfr_ignored_1 = (String)object5 + "\n\nPlease review the information in the following table which shows the vertical datum\nconversion values used on output for each relevant model location.";
        Object object6 = MessageFormat.format("\n\nThe vertical datum selection for the output from this alternative is:  {0}, so no conversion of the results was performed.", ((Enum)object2).toString());
        object4 = (String)object4 + (String)object6;
        boolean bl2 = ((Enum)object2).equals((Object)OutputVerticalDatumType.NAVD88) || ((Enum)object2).equals((Object)OutputVerticalDatumType.NGVD29);
        object6 = this._system.getElementVector().stream().filter(object -> object instanceof JunctionElement).collect(Collectors.toList());
        List list2 = this._system.getElementVector().stream().filter(object -> object instanceof ReservoirElement).collect(Collectors.toList());
        boolean bl3 = list2.stream().filter(object -> !((ReservoirElement)object).getVerticalDatumSettings().getType().equals((Object)VerticalDatumType.UNSPECIFIED)).count() > 0L;
        boolean bl4 = bl3 = bl3 | object6.stream().filter(object -> !((Junction)((JunctionElement)object).getFunction()).getVerticalDatumSettings().getType().equals((Object)VerticalDatumType.UNSPECIFIED)).count() > 0L;
        boolean bl5 = bl = list.stream().filter(new RssRun$TsRecordWithDatumPredicate()).count() > 0L;
        if (!bl4) {
            this.printLogMessage(string2);
            return;
        }
        this.printMessage(string);
        if (bl) {
            this.printLogMessage((String)object3);
            return;
        }
        if (bl2) {
            this.printLogMessage((String)object5);
            return;
        }
        this.printLogMessage((String)object4);
    }

    protected void printConversionTable() {
    }

    protected void convertInputTimeSeriesToVerticalDatum(List object) {
        object = object.iterator();
        block8: while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (TSRecordProxy)object2;
            if ((object2 = object2.getTSRecord()) == null || !((TSRecordImpl)object2).hasVerticalDatum()) continue;
            try {
                Object object3 = RssModelVariableSet.getModelVariable(object2.getVariableId());
                if (object3.getParamId() != Parameter.PARAMID_ELEV) continue;
                ((FluentLogger.Api)FLOGGER.atInfo()).log("convertInputTimeSeriesToVerticalDatum: TSRecord " + String.valueOf(object2) + " has vertical datum of " + String.valueOf(((TSRecordImpl)object2).getVerticalDatumContainer()));
                object3 = ((TSRecordImpl)object2).getName();
                object3 = this._system.getObjectForKeyString((String)object3);
                Object object4 = null;
                if (object3 instanceof Function) {
                    object4 = ((Function)object3).getElement();
                } else if (object3 instanceof Element) {
                    object4 = (Element)object3;
                }
                while (object4 != null && !(object4 instanceof JunctionElement) && !(object4 instanceof ReservoirElement)) {
                    object4 = ((Element)object4).getParent();
                }
                if (object4 == null) continue;
                object3 = null;
                if (object4 instanceof JunctionElement) {
                    object3 = ((Junction)((JunctionElement)object4).getFunction()).getVerticalDatumSettings();
                } else if (object4 instanceof ReservoirElement) {
                    object3 = ((ReservoirElement)object4).getVerticalDatumSettings();
                }
                if (object3 == null) continue;
                switch (((VerticalDatumSettings)object3).getType()) {
                    case UNSPECIFIED: {
                        continue block8;
                    }
                    case NAVD88: {
                        ((TSRecordImpl)object2).toNAVD88();
                        continue block8;
                    }
                    case NGVD29: {
                        ((TSRecordImpl)object2).toNGVD29();
                        continue block8;
                    }
                    case LOCAL: {
                        ((TSRecordImpl)object2).toNAVD88();
                        double d = -1.0 * ((VerticalDatumSettings)object3).getLocalShiftToNAVD88();
                        object4 = ((TSRecordImpl)object2).getTSArray();
                        for (int i = 0; i < ((Object)object4).length; ++i) {
                            if (object4[i] == -3.4028234663852886E38) continue;
                            Object object5 = object4;
                            int n = i;
                            object5[n] = object5[n] + d;
                        }
                        String string = ((VerticalDatumSettings)object3).toVerticalDatumXml();
                        ((TSRecordImpl)object2).setVerticalDatumInfo(string);
                        ((TSRecordImpl)object2).setVerticalDatumContainer((VerticalDatumContainer)new hec.io.VerticalDatumContainer(((VerticalDatumSettings)object3).toVerticalDatumXml()));
                    }
                }
            }
            catch (VerticalDatumException verticalDatumException) {
                ((FluentLogger.Api)FLOGGER.atWarning()).log(verticalDatumException.getMessage());
            }
        }
    }

    public boolean checkTSRecords(Vector vector, RunTimeWindow runTimeWindow) {
        DSSManager dSSManager;
        block11: {
            try {
                if (this._dssFileManagerWrapper == null || (dSSManager = (DSSManager)this._dssFileManagerWrapper.getRemote()) == null || !dSSManager.isAlive()) {
                    this.printLogMessage("RssRun.checkTSRecords: attempting to get DSSFileManager wrapper");
                    if (this.getDSSFileManagerWrapper() == null) {
                        this.printErrorMessage("RssRun ERROR: failed to get DSSFileManager wrapper!");
                        this.printErrorMessage("RssRun.checkTSRecords: ERROR: failed to get DSSFileManager wrapper!");
                        return false;
                    }
                }
            }
            catch (RemoteException remoteException) {
                System.out.println("RssRun.checkTSRecords: rmi error on _dssFileManagerWrapper.isAlive() " + String.valueOf(remoteException));
                System.out.println("RssRun.checkTSRecords: attempting to reconnect to DssFileManager");
                this._dssFileManagerWrapper = null;
                if (this.getDSSFileManagerWrapper() != null) break block11;
                this.printErrorMessage("RssRun ERROR: failed to get DSSFileManager wrapper!");
                System.out.println("RssRun.checkTSRecords: ERROR: failed to get DSSFileManager wrapper!");
                return false;
            }
        }
        boolean bl = false;
        block2: for (int i = 0; i < vector.size(); ++i) {
            dSSManager = (TSRecord)vector.elementAt(i);
            if (dSSManager == null) continue;
            boolean bl2 = dSSManager.loadRawTSData();
            int n = dSSManager.getVariableId();
            Object object = RssModelVariableSet.getModelVariable(n);
            if (object != null && !object.isRequired()) {
                System.out.println("skipping checks on ts " + dSSManager.getName());
                continue;
            }
            if (!bl2) {
                bl = true;
                System.out.println("checkTSRecords:failed to load TS Record " + dSSManager.getName());
                this.printErrorMessage("ERROR: failed to load record ");
                this.printTSErrorMsg((TSRecord)dSSManager);
                continue;
            }
            Object object2 = dSSManager.getTimeArray();
            object = dSSManager.getTSArray();
            if (object2 == null || ((int[])object2).length <= 0 || object == null || ((ModelVariable)object).length <= 0) {
                bl = true;
                System.out.println("checkTSRecords:data not read for Time Window. for " + dSSManager.getName());
                this.printErrorMessage("ERROR: Data not read for Time Window");
                this.printTSErrorMsg((TSRecord)dSSManager);
                continue;
            }
            HecTime hecTime = runTimeWindow.getLookbackTime();
            HecTime hecTime2 = runTimeWindow.getEndTime();
            if (this.isHindcastId(dSSManager.getVariableId())) {
                if (this._timeBlockNum > 0) continue;
                hecTime2 = runTimeWindow.getStartTime();
            }
            int n2 = hecTime.value();
            int n3 = hecTime2.value();
            int cfr_ignored_0 = ((int[])object2).length;
            for (int j = 0; j < ((ModelVariable)object).length; ++j) {
                if (object2[j] < n2 || object2[j] > n3 || object[j] != -3.4028234663852886E38) continue;
                bl = true;
                object2 = new HecTime(object2[j], 1);
                System.out.println("checkTSRecords: ERROR: Data is undefined or missing on " + object2.toString() + " for " + dSSManager.getName() + " Path:" + dSSManager.getDSSPathname());
                this.printErrorMessage("ERROR: Data is undefined or missing on " + object2.toString());
                this.printTSErrorMsg((TSRecord)dSSManager);
                continue block2;
            }
        }
        if (bl) {
            System.out.println("checkTSRecords:ERROR loading TS records ");
            return false;
        }
        return true;
    }

    private void printTSErrorMsg(TSRecord tSRecord) {
        String string = this._system.getNameForKeyString(tSRecord.getName());
        this.printErrorMessage("ResSim Time Series location: " + string);
        this.printErrorMessage("dssfile " + tSRecord.getDSSFilename());
        this.printErrorMessage("dsspath " + tSRecord.getDSSPathname());
        this.printErrorMessage("param " + tSRecord.getParamName());
        this.printErrorMessage("timewindow " + tSRecord.getTimeWindowString());
        this.printMessage(" ");
    }

    boolean isHindcastId(int n) {
        if (this.varIdArray == null) {
            this.varIdArray = new int[211];
            for (int i = 0; i < this.varIdArray.length; ++i) {
                this.varIdArray[i] = 0;
            }
            int[] nArray = RssModelVariableConstants.HINDCAST_IDS;
            for (int i = 0; i < nArray.length; ++i) {
                this.varIdArray[nArray[i]] = 1;
            }
        }
        return this.varIdArray[n] == 1;
    }

    private int checkLookbackConstants() {
        AbstractList abstractList;
        this.printMessage("Initialization Start");
        if (this._alt == null) {
            this.printMessage("    Alternative is null in checkLookbackConstants");
            return 1;
        }
        boolean bl = false;
        Vector vector = this._alt.getHindcastData();
        if (this.checkForMissingLookbackSettings(vector, abstractList = this._system.getHindcastDataList())) {
            return 1;
        }
        String string = "";
        abstractList = new ArrayList();
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (HindcastData)vector.elementAt(i);
            if (((HindcastData)object).getType() != 1 || ((HindcastData)object).getValue() != Double.NEGATIVE_INFINITY) continue;
            ModelVariable modelVariable = RssModelVariableSet.getModelVariable(((HindcastData)object)._varId);
            if (((String)(object = this._system.getNameForKeyString(((HindcastData)object).getObjectKey()) + ", " + modelVariable.getName())).startsWith("~")) continue;
            if (modelVariable.getObjectType().equalsIgnoreCase("State Variable")) {
                abstractList.add(new RssRun$ErrorMsg((String)object, RssRun$MsgType.Warning));
                continue;
            }
            abstractList.add(new RssRun$ErrorMsg((String)object, RssRun$MsgType.Error));
            bl = true;
        }
        if (!abstractList.isEmpty()) {
            this.printMessage("Lookback Constant missing for:");
            for (int i = 0; i < abstractList.size(); ++i) {
                RssRun$ErrorMsg rssRun$ErrorMsg = (RssRun$ErrorMsg)abstractList.get(i);
                if (rssRun$ErrorMsg.a() == RssRun$MsgType.Error) {
                    this.printErrorMessage("    " + rssRun$ErrorMsg.b());
                    continue;
                }
                this.printWarningMessage("    " + rssRun$ErrorMsg.b());
            }
            this.printMessage("");
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (HindcastData)vector.elementAt(i);
            boolean bl2 = false;
            if (((HindcastData)object).getType() != 4) continue;
            ReservoirElement reservoirElement = this.findReservoirForHindcastData((HindcastData)object);
            if ((object = this._system.getObjectForKeyString(((HindcastData)object).getObjectKey())) instanceof AdjustableFlow) {
                object = ((AdjustableFlow)object).getElement();
                string = object.getName();
            }
            String string2 = "";
            for (int j = 0; j < vector.size(); ++j) {
                HindcastData hindcastData = (HindcastData)vector.elementAt(j);
                if (hindcastData.getType() != 5 && hindcastData.getType() != 7 && hindcastData.getType() != 6 || reservoirElement != (object = this.findReservoirForHindcastData(hindcastData))) continue;
                string2 = RssModelVariableSet.getVariableName(hindcastData.getVariableId());
                bl2 = true;
                break;
            }
            if (!bl2) continue;
            this.printErrorMessage("Fn of Release has been selected for " + String.valueOf(reservoirElement) + "-" + string2 + " and " + HindcastData.e + " for " + reservoirElement.getName() + "-" + string + "-Lookback Release.");
            this.printErrorMessage("These options cannot be used together on the same reservoir.");
            bl = true;
        }
        if (bl) {
            return 1;
        }
        return 0;
    }

    private boolean checkForMissingLookbackSettings(List list, List list2) {
        HindcastData hindcastData;
        HindcastData hindcastData2;
        int n;
        boolean bl = false;
        ArrayList<HindcastData> arrayList = new ArrayList<HindcastData>();
        for (n = 0; n < list2.size(); ++n) {
            hindcastData2 = (HindcastData)list2.get(n);
            boolean bl2 = false;
            for (int i = 0; i < list.size(); ++i) {
                hindcastData = (HindcastData)list.get(i);
                if (!hindcastData2.getObjectKey().equals(hindcastData.getObjectKey()) || hindcastData2.getVariableId() != hindcastData.getVariableId()) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            arrayList.add(hindcastData2);
        }
        if (!arrayList.isEmpty()) {
            this.printMessage("Failed to find Alternative Lookback Settings for the following:");
            for (n = 0; n < arrayList.size(); ++n) {
                hindcastData2 = (HindcastData)arrayList.get(n);
                String string = "    " + this._system.getNameForKeyString(hindcastData2.getObjectKey()) + ", " + RssModelVariableSet.getVariableName(hindcastData2.getVariableId());
                hindcastData = RssModelVariableSet.getModelVariable(hindcastData2._varId);
                if (hindcastData.getObjectType().equalsIgnoreCase("State Variable")) {
                    this.printWarningMessage(string);
                    continue;
                }
                this.printErrorMessage(string);
                bl = true;
            }
        }
        return bl;
    }

    public ReservoirElement findReservoirForHindcastData(HindcastData object) {
        object = ((HindcastData)object).getObjectKey();
        if ((object = this._system.getObjectForKeyString((String)object)) instanceof ControlStructure) {
            object = (Function)object;
            object = ((Function)object).getElement();
            while (object != null) {
                if (!(object instanceof ReservoirElement)) {
                    object = ((Element)object).getParent();
                    continue;
                }
                if (!(object instanceof ReservoirElement)) continue;
                return (ReservoirElement)object;
            }
        } else if (object instanceof Storage && (object = ((Storage)object).getElement()) != null && (object = ((Element)object).getParent()) instanceof ReservoirElement) {
            return (ReservoirElement)object;
        }
        return null;
    }

    public void unloading() {
        this.unloadManagers();
    }

    void unloadManagers() {
        if (this._alt != null) {
            this._proxyList.unloadManager(this._alt.getIdentifier());
            this._alt = null;
        }
        if (this._output != null) {
            this._output.removeCallBack();
            this._output = null;
        }
    }

    int initSimulationTime() {
        this._runTimeWindow.setShowTimeAsBeginningOfDay(false);
        this._runTimeWindow.setPeriodAvgTimeStep(this.getAlternative().isPerAvgFlow());
        this._timeBlockVec = new Vector();
        this._system.updateTSProxyList();
        if (this._logLevel > 5) {
            this.printLogMessage("\nRssRun.initSimulationTime: Creating time block");
            RssRun rssRun = this;
            rssRun.printLogMessage("Lookback: " + rssRun._runTimeWindow.getLookbackTimeString());
            RssRun rssRun2 = this;
            rssRun2.printLogMessage("Start: " + rssRun2._runTimeWindow.getStartTimeString());
            RssRun rssRun3 = this;
            rssRun3.printLogMessage("End: " + rssRun3._runTimeWindow.getEndTimeString());
            RssRun rssRun4 = this;
            rssRun4.printLogMessage("Number of time steps: " + rssRun4._runTimeWindow.getNumSteps());
        }
        HecTime hecTime = new HecTime(this._runTimeWindow.getStartTime());
        HecTime hecTime2 = new HecTime(this._runTimeWindow.getEndTime());
        HecTime hecTime3 = new HecTime(this._runTimeWindow.getLookbackTime());
        hecTime.setTimeGranularity(11);
        hecTime2.setTimeGranularity(11);
        hecTime3.setTimeGranularity(11);
        this._lookbackLength = hecTime.value() - hecTime3.value();
        this._loobackLengthInc = hecTime3.getTimeGranularity();
        int n = this._runTimeWindow.getNumLookbackSteps();
        this._runTimeWindow.setNumRoutingSteps(n);
        RssRun rssRun = this;
        int n2 = rssRun.computeTimeBlockLength(rssRun._runTimeWindow);
        if (Boolean.getBoolean("NoTimeBlocking")) {
            System.out.println("Time Block: Time Blocking Disabled.");
            this._timeBlockVec.add(this._runTimeWindow);
        } else {
            try {
                if (this._runTimeWindow.getNumSteps() * this._runTimeWindow.getTimeStepMinutes() > n2) {
                    this._timeBlockVec = RssRun.splitTimeWindow(this, this._runTimeWindow, n2, 1, this._runTimeWindow.getTimeStepMinutes() * n, 1);
                    System.out.println("Time Block: Time Window split into " + this._timeBlockVec.size() + " blocks.");
                } else {
                    System.out.println("Time Block: No Time Blocking Required.");
                    this._timeBlockVec.add(this._runTimeWindow);
                }
            }
            catch (RuntimeException runtimeException) {
                this.printErrorMessage(runtimeException.getMessage());
                return 1;
            }
        }
        return 0;
    }

    private int computeTimeBlockLength(RunTimeWindow runTimeWindow) {
        int n = 0 + (this._inputTSData == null ? 0 : this._inputTSData.getTSRecordCount());
        TSDataSet tSDataSet = this.getOutputTSData();
        n += tSDataSet == null ? 0 : tSDataSet.getTSRecordCount();
        tSDataSet = this.getRegOutputTSData();
        n += tSDataSet == null ? 0 : tSDataSet.getTSRecordCount();
        tSDataSet = this.getUnregOutputTSData();
        n += tSDataSet == null ? 0 : tSDataSet.getTSRecordCount();
        tSDataSet = this.getCumLocOutputTSData();
        n += tSDataSet == null ? 0 : tSDataSet.getTSRecordCount();
        if (this.shouldComputeWaterQuality()) {
            tSDataSet = this.getWQOutputTSData();
            n += tSDataSet == null ? 0 : tSDataSet.getTSRecordCount();
        }
        long l = ((long)runTimeWindow.getNumSteps() << 3) * (long)((double)n * 1.1);
        System.out.println("==========================================================================================");
        System.out.println("Memory Size needed for TSData = " + (l += ((long)runTimeWindow.getNumSteps() << 2) * (long)n) / 0x100000L + " MB");
        this.printLogMessage("==========================================================================================");
        this.printLogMessage("Memory Size needed for TSData = " + l / 0x100000L + " MB");
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.totalMemory();
        long l3 = l2 - runtime.freeMemory();
        System.getProperty("java.runtime.version");
        long l4 = (long)((double)runtime.maxMemory() * 0.9);
        long l5 = l4 - l3;
        if (l5 < l) {
            runtime.gc();
            l2 = runtime.totalMemory();
            l3 = l2 - runtime.freeMemory();
            l4 = (long)((double)runtime.maxMemory() * 0.9);
            l5 = l4 - l3;
        }
        if (this.getLogLevel() >= 3) {
            this.printLogMessage("Max Memory            = " + Double.toString(l4 / 0x100000L) + " MB");
            this.printLogMessage("Total Memory          = " + Double.toString(runtime.totalMemory() / 0x100000L) + " MB");
            this.printLogMessage("Free Memory           = " + Double.toString(runtime.freeMemory() / 0x100000L) + " MB");
            this.printLogMessage("Used Memory           = " + Double.toString(l3 / 0x100000L) + " MB");
            this.printLogMessage("Max Available Memory  = " + Double.toString(l5 / 0x100000L) + " MB");
        }
        System.out.println("Max Memory            = " + Double.toString(l4 / 0x100000L) + " MB");
        System.out.println("Total Memory          = " + Double.toString(runtime.totalMemory() / 0x100000L) + " MB");
        System.out.println("Free Memory           = " + Double.toString(runtime.freeMemory() / 0x100000L) + " MB");
        System.out.println("Used Memory           = " + Double.toString(l3 / 0x100000L) + " MB");
        System.out.println("Max Available Memory  = " + Double.toString(l5 / 0x100000L) + " MB");
        double d = (double)l / (double)l5;
        double d2 = Math.ceil(d);
        System.out.println("Minimum Number of TimeWindowBlocks Needed = " + d2);
        this.printLogMessage("Minimum Number of TimeWindowBlocks Needed = " + d2);
        if (d < 1.0) {
            int n2 = runTimeWindow.getNumSteps() * runTimeWindow.getTimeStepMinutes();
            if (this.getLogLevel() >= 3) {
                this.printLogMessage("Size of each block = " + Double.toString(n2 / 1440) + " days");
                this.printLogMessage("==========================================================================================");
            }
            System.out.println("Size of each block = " + Double.toString(n2 / 1440) + " days");
            System.out.println("==========================================================================================");
            return n2;
        }
        double d3 = Math.ceil((double)(runTimeWindow.getNumSteps() * runTimeWindow.getTimeStepMinutes()) / d2);
        int n3 = runTimeWindow.getTimeIncrement() == 3 ? 1440 : 60;
        double d4 = Math.floor(d3 / (double)(n3 *= runTimeWindow.getTimeStep()));
        d3 = d4 * (double)n3;
        System.out.println("Size of each block = " + Double.toString(d3 / 1440.0) + " days");
        System.out.println("==========================================================================================");
        if (this.getLogLevel() >= 3) {
            this.printLogMessage("Size of each block = " + Double.toString(d3 / 1440.0) + " days");
            this.printLogMessage("==========================================================================================");
        }
        if (d3 >= 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)d3;
    }

    public List<RunTimeWindow> getTimeBlocks() {
        if (this._timeBlockVec == null) {
            return new ArrayList<RunTimeWindow>(Arrays.asList(this.getRunTimeWindow()));
        }
        return new ArrayList<RunTimeWindow>(this._timeBlockVec);
    }

    public int getRoutingTimeSteps() {
        return this._runTimeWindow.getNumLookbackSteps();
    }

    private static Vector splitTimeWindow(RssRun rssRun, RunTimeWindow runTimeWindow, int n, int n2, int n3, int n4) {
        if (n2 == 0 || n4 == 0) {
            throw new IllegalArgumentException("Time types cannot by of type second");
        }
        int n5 = runTimeWindow.getTimeStep();
        int n6 = runTimeWindow.getTimeIncrement();
        HecTime hecTime = new HecTime(runTimeWindow.getStartTime());
        HecTime hecTime2 = new HecTime(runTimeWindow.getEndTime());
        HecTime hecTime3 = new HecTime(runTimeWindow.getLookbackTime());
        int n7 = runTimeWindow.getNumRoutingSteps();
        hecTime.setTimeGranularity(11);
        hecTime2.setTimeGranularity(11);
        hecTime3.setTimeGranularity(11);
        int n8 = hecTime2.value() - hecTime.value();
        int n9 = hecTime.value() - hecTime3.value();
        switch (n2) {
            case 3: {
                n = n * 24 * 60;
                break;
            }
            case 2: {
                n *= 60;
            }
        }
        switch (n4) {
            case 3: {
                n3 = n3 * 24 * 60;
                break;
            }
            case 2: {
                n3 *= 60;
            }
        }
        if (n < n9 + n3) {
            throw new IllegalArgumentException("Time Window Block Size cannot be smaller than the sum of lookback and routing times!");
        }
        if (n >= n8) {
            Vector<RunTimeWindow> vector = new Vector<RunTimeWindow>();
            vector.add(runTimeWindow);
            return vector;
        }
        double d = Math.ceil((double)n8 / (double)(n - n3));
        Vector<RunTimeWindow> vector = new Vector<RunTimeWindow>();
        n4 = 0;
        while ((double)n4 < d) {
            RunTimeWindow runTimeWindow2;
            if (n4 == 0) {
                var16_19 = new HecTime();
                var16_19.set(hecTime.value() + n);
                runTimeWindow2 = new RunTimeWindow(hecTime, var16_19, hecTime3);
            } else {
                var16_19 = (RunTimeWindow)vector.get(n4 - 1);
                HecTime hecTime4 = new HecTime();
                hecTime4.set(var16_19.getEndTime().value() - n3);
                runTimeWindow2 = new RunTimeWindow();
                runTimeWindow2.setStartTime(hecTime4);
                int n10 = hecTime4.value() - n9;
                hecTime4 = new HecTime();
                hecTime4.set(n10);
                runTimeWindow2.setLookbackTime(hecTime4);
                hecTime4 = new HecTime();
                if (var16_19.getEndTime().value() + n - n3 >= hecTime2.value()) {
                    hecTime4.set(hecTime2.value());
                    n4 = (int)d;
                } else {
                    hecTime4.set(var16_19.getEndTime().value() + n - n3);
                }
                runTimeWindow2.setEndTime(hecTime4);
            }
            runTimeWindow2.setNumRoutingSteps(n7);
            runTimeWindow2.setTimeStep(n5, n6);
            runTimeWindow2.setTimeBlockIndex(n4);
            runTimeWindow2.setPeriodAvgTimeStep(runTimeWindow.isPerAvgTimeStep());
            vector.add(runTimeWindow2);
            ++n4;
        }
        Boolean.getBoolean("DEBUG_TIMEWINDOW_SPLIT");
        if (rssRun != null && rssRun.getLogLevel() >= 3) {
            rssRun.printLogMessage("      Results of Splitting Time Window     ");
            rssRun.printLogMessage("LookbackTime        StartTime       EndTime");
            rssRun.printLogMessage("------------------------------------------------");
        }
        System.out.println("      Results of Splitting Time Window     ");
        System.out.println("LookbackTime        StartTime       EndTime");
        System.out.println("------------------------------------------------");
        for (n4 = 0; n4 < vector.size(); ++n4) {
            RunTimeWindow runTimeWindow3 = (RunTimeWindow)vector.get(n4);
            System.out.println(runTimeWindow3.getLookbackTime().dateAndTime(4) + "\t" + runTimeWindow3.getStartTime().dateAndTime(4) + "\t" + runTimeWindow3.getEndTime().dateAndTime(4));
            if (rssRun == null || rssRun.getLogLevel() < 3) continue;
            rssRun.printLogMessage(runTimeWindow3.getLookbackTime().dateAndTime(4) + "\t" + runTimeWindow3.getStartTime().dateAndTime(4) + "\t" + runTimeWindow3.getEndTime().dateAndTime(4));
        }
        return vector;
    }

    TSDataSet createOutputTSData(String string) {
        return this.createOutputTSData(string, "REG", 0);
    }

    public TSDataSet createOutputTSData(String object, String object2, int n) {
        TSDataSet tSDataSet = new TSDataSet();
        tSDataSet.setName("OutputTS for " + (String)object);
        tSDataSet.setWorkspace(this.getWorkspace());
        tSDataSet.setProxyList(this.getProxyList());
        this._system.updateTSProxyList();
        object = this._system.getActiveTSProxies(null, 0, n);
        if (object == null) {
            return null;
        }
        this.updateOutputFPart();
        object2 = "-" + (String)object2;
        String string = "INST-VAL";
        if (this._alt.isPerAvgFlow()) {
            string = "PER-AVER";
        }
        Object object3 = this._alt.getWaterAccountSet();
        if (this._alt.getWaterAccountSetIndex() != Integer.MIN_VALUE && object3 != null && n == 0) {
            WaterAccount waterAccount;
            int n2;
            for (n2 = 0; n2 < ((WaterAccountSet)object3).getWaterAccounts().size(); ++n2) {
                waterAccount = ((WaterAccountSet)object3).getWaterAccounts().get(n2);
                waterAccount.setSystem(this._alt.getSystem());
                waterAccount.clearTSProxyList();
                boolean bl = false;
                if (this._alt.useYieldAnalysis()) {
                    if (this._alt.getSelectedYieldAnalysis() == YieldAnalysisType.WATER_ACCOUNT && this._alt.getWaterAccountYieldAnalysis() != null) {
                        var10_17 = this._alt.getWaterAccountYieldAnalysis().getYieldAnalysisRuleRefs(this._system);
                        bl = waterAccount.checkUsesRule(this._system, var10_17);
                    } else if (this._alt.getSelectedYieldAnalysis() == YieldAnalysisType.REVERSE_WATER_ACCOUNT && this._alt.getReverseWaterAccountYieldAnalysis() != null) {
                        var10_17 = this._alt.getReverseWaterAccountYieldAnalysis().getYieldAnalysisRuleRefs(this._system);
                        bl = waterAccount.checkUsesRule(this._system, var10_17);
                    }
                }
                waterAccount.updateTSProxyList(bl);
                waterAccount.getActiveTSProxies((Vector)object, 0);
            }
            n2 = this._system._elementVector.size();
            for (int i = 0; i < n2; ++i) {
                Element element = (Element)this._system._elementVector.elementAt(i);
                if (element == null || !(element instanceof ReservoirElement) || (waterAccount = ((ReservoirElement)(object3 = (ReservoirElement)element)).getDefaultWaterAccount()) == null) continue;
                waterAccount.updateTSProxyList(false);
                waterAccount.getActiveTSProxies((Vector)object, 0);
            }
        }
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            int n3;
            TSRecord tSRecord;
            TSRecordProxy tSRecordProxy = (TSRecordProxy)((Vector)object).elementAt(i);
            if (tSRecordProxy == null || (tSRecord = tSDataSet.createTSRecord(tSRecordProxy.getName(), tSRecordProxy.getVariableId(), tSRecordProxy.getParamName())) == null) continue;
            tSRecord.setDSSFilename(this.getDSSOutputFile());
            String string2 = this.constructTSRecordProxyDssPath(tSRecordProxy, (String)object2);
            if (string2 == null) continue;
            tSRecord.setDSSPathname(string2);
            if (tSRecord instanceof IVerticalDatum && tSRecordProxy.hasVerticalDatum()) {
                try {
                    ((IVerticalDatum)tSRecord).setVerticalDatumInfo(tSRecordProxy.getVerticalDatumInfo());
                }
                catch (VerticalDatumException verticalDatumException) {
                    Logger.getLogger(RssRun.class.getName()).log(Level.INFO, null, verticalDatumException);
                }
            }
            if ((n3 = tSRecordProxy.getVariableId()) >= 0) {
                string2 = RssModelVariableSet.getModelVariable(n3);
                if (string2 != null && string2.getUnitString() != null) {
                    tSRecord.setUnits(string2.getUnitString());
                } else if (n3 == 173 || n3 == 178 || n3 == 180 || n3 == 181) {
                    tSRecord.setUnits("hours");
                } else if (n3 == 174 || n3 == 179) {
                    tSRecord.setUnits("count");
                } else if (n3 == 97) {
                    tSRecord.setUnits(Parameter.getUnitsStringForSystem((String)((StateVariable)tSRecordProxy.getParent()).getParamType(), (int)this.getUnitSystem()));
                } else {
                    if (string2 == null) continue;
                    tSRecord.setUnits(Parameter.getUnitsStringForSystem((int)string2.getParamId(), (int)this.getUnitSystem()));
                }
                if (string2 != null && string2.getUnitTypeString() != null) {
                    tSRecord.setUnitsType(string2.getUnitTypeString());
                    continue;
                }
                if (string2.getParamId() == Parameter.PARAMID_ENERGY || n3 == 170 || n3 == 175 || n3 == 173 || n3 == 178 || n3 == 180 || n3 == 181) {
                    tSRecord.setUnitsType("PER-CUM");
                    continue;
                }
                if (n3 == 172 || n3 == 177 || n3 == 171 || n3 == 176 || n3 == 174 || n3 == 179) {
                    tSRecord.setUnitsType("PER-AVER");
                    continue;
                }
                if (string2.getParamId() == Parameter.PARAMID_FLOW || string2.getParamId() == Parameter.PARAMID_STAGE || string2.getParamId() == Parameter.PARAMID_POWER) {
                    tSRecord.setUnitsType(string);
                    continue;
                }
                tSRecord.setUnitsType("INST-VAL");
                continue;
            }
            if (tSRecordProxy.getParamName().indexOf("Stor") >= 0 || tSRecordProxy.getParamName().indexOf("STOR") >= 0) {
                tSRecord.setUnits(ModelConst.D);
                continue;
            }
            if (tSRecordProxy.getParamName().contains("Elev") || tSRecordProxy.getParamName().contains("ELEV")) {
                tSRecord.setUnits(ModelConst.A);
                continue;
            }
            if (tSRecordProxy.getParamName().indexOf("Area") >= 0 || tSRecordProxy.getParamName().indexOf("AREA") >= 0) {
                tSRecord.setUnits(ModelConst.B);
                continue;
            }
            if (tSRecordProxy.getParamName().equals(ModelConst.m)) {
                tSRecord.setUnits(ModelConst.C);
                continue;
            }
            tSRecord.setUnits(ModelConst.z);
        }
        switch (n) {
            case 0: {
                this._regOutputTSData = tSDataSet;
                break;
            }
            case 1: {
                this._unregOutputTSData = tSDataSet;
                break;
            }
            case 4: {
                this._cumlocOutputTSData = tSDataSet;
            }
        }
        return tSDataSet;
    }

    public TSDataSet createOutputWQTSData(String object) {
        TSDataSet tSDataSet = new TSDataSet();
        tSDataSet.setName("WQ OutputTS for " + (String)object);
        tSDataSet.setWorkspace(this.getWorkspace());
        tSDataSet.setProxyList(this.getProxyList());
        this._system.updateTSProxyList();
        if (this._wqRun == null) {
            return null;
        }
        object = this._system.getActiveWaterQualityTSProxies(this._wqRun);
        if (object == null) {
            return null;
        }
        this.updateOutputFPart();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (TSRecordProxy)object.next();
            int n = object2.getVariableId();
            TSRecord tSRecord = tSDataSet.createTSRecord(object2.getName(), n, object2.getParamName());
            if (tSRecord == null) continue;
            tSRecord.setDSSFilename(this.getDSSOutputFile());
            if ((object2 = this.constructTSRecordProxyDssPath((TSRecordProxy)object2, "")) == null) continue;
            tSRecord.setDSSPathname((String)object2);
            object2 = RssModelVariableSet.getModelVariable(n);
            if (object2 != null && object2.getUnitString() != null) {
                tSRecord.setUnits(object2.getUnitString());
            }
            tSRecord.setUnitsType(DssDataType.INST_VAL.toString());
        }
        this._wqOutputTSData = tSDataSet;
        return tSDataSet;
    }

    public GVDataSet createOutputGVData(String object, String object2, int n) {
        GVDataSet gVDataSet = new GVDataSet();
        gVDataSet.setName("OutputGV for " + (String)object);
        gVDataSet.setWorkspace(this.getWorkspace());
        gVDataSet.setProxyList(this.getProxyList());
        gVDataSet.setUserInterface(this._uiWrapper);
        gVDataSet.setAltName((String)object);
        object = this._system.getOutputGlobalVariables();
        if (object == null) {
            return null;
        }
        object2 = "-" + (String)object2;
        this._alt.isPerAvgFlow();
        for (int i = 0; i < object.size(); ++i) {
            GlobalVariable globalVariable = (GlobalVariable)object.get(i);
            if (globalVariable == null) continue;
            GlobalVariableData globalVariableData = gVDataSet.createGVRecord(globalVariable.getType(), globalVariable.getIndex());
            if (globalVariableData == null) {
                this.printLogMessage("Failed to initialize GlobalVariable " + globalVariableData.getName());
                continue;
            }
            globalVariableData.setDSSFilename(this.getDSSOutputFile());
            String string = this.constructGvDssPath(globalVariable, (String)object2);
            if (string == null) {
                this.printLogMessage("Failed to get DSS path for GlobalVariable " + globalVariableData.getName());
                continue;
            }
            globalVariableData.setDSSPathname(string);
            globalVariable.setGlobalVariableData(globalVariableData);
            globalVariableData.setGVDataSet(gVDataSet);
        }
        return gVDataSet;
    }

    TSDataSet createReleaseDecisionTSData(String string, String object, int n) {
        string = new TSDataSet();
        string.setWorkspace(this.getWorkspace());
        string.setProxyList(this.getProxyList());
        this._system.updateTSProxyList();
        Vector vector = this._system.getActiveTSProxies(null, 0, n);
        if (vector == null) {
            return null;
        }
        this.updateOutputFPart();
        object = "-" + (String)object;
        String string2 = "INST-VAL";
        if (this._alt.isPerAvgFlow()) {
            string2 = "PER-AVER";
        }
        for (int i = 0; i < vector.size(); ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)vector.elementAt(i);
            TSRecord tSRecord = null;
            if (tSRecordProxy == null) continue;
            int n2 = tSRecordProxy.getVariableId();
            if (n2 == 13 || n2 == 10 || n2 == 71 || n2 == 21 || n2 == 183 || n2 == 0 || n2 == 73 || n2 == 72) {
                tSRecord = string.createTSRecord(tSRecordProxy.getName(), tSRecordProxy.getVariableId(), tSRecordProxy.getParamName());
            }
            if (tSRecord == null) continue;
            tSRecord.setDSSFilename(this.getDSSOutputFile());
            String string3 = this.constructTSRecordProxyDssPath(tSRecordProxy, (String)object);
            tSRecord.setDSSPathname(string3);
            if (n2 >= 0) {
                string3 = RssModelVariableSet.getModelVariable(n2);
                if (n2 == 173 || n2 == 178 || n2 == 180 || n2 == 181) {
                    tSRecord.setUnits("hours");
                } else if (n2 == 174 || n2 == 179) {
                    tSRecord.setUnits("count");
                } else if (n2 == 97) {
                    tSRecord.setUnits(Parameter.getUnitsStringForSystem((String)((StateVariable)tSRecordProxy.getParent()).getParamType(), (int)this.getUnitSystem()));
                } else {
                    if (string3 == null) continue;
                    tSRecord.setUnits(Parameter.getUnitsStringForSystem((int)string3.getParamId(), (int)this.getUnitSystem()));
                }
                if (string3.getParamId() == Parameter.PARAMID_ENERGY || n2 == 170 || n2 == 175 || n2 == 173 || n2 == 178 || n2 == 180 || n2 == 181) {
                    tSRecord.setUnitsType("PER-CUM");
                    continue;
                }
                if (n2 == 172 || n2 == 177 || n2 == 171 || n2 == 176 || n2 == 174 || n2 == 179) {
                    tSRecord.setUnitsType("PER-AVER");
                    continue;
                }
                if (string3.getParamId() == Parameter.PARAMID_FLOW || string3.getParamId() == Parameter.PARAMID_STAGE || string3.getParamId() == Parameter.PARAMID_POWER) {
                    tSRecord.setUnitsType(string2);
                    continue;
                }
                tSRecord.setUnitsType("INST-VAL");
                continue;
            }
            if (tSRecordProxy.getParamName().indexOf("Stor") >= 0 || tSRecordProxy.getParamName().indexOf("STOR") >= 0) {
                tSRecord.setUnits(ModelConst.D);
                continue;
            }
            if (tSRecordProxy.getParamName().indexOf("Elev") >= 0 || tSRecordProxy.getParamName().indexOf("ELEV") >= 0) {
                tSRecord.setUnits(ModelConst.A);
                continue;
            }
            if (tSRecordProxy.getParamName().indexOf("Area") >= 0 || tSRecordProxy.getParamName().indexOf("AREA") >= 0) {
                tSRecord.setUnits(ModelConst.B);
                continue;
            }
            if (tSRecordProxy.getParamName().equals(ModelConst.m)) {
                tSRecord.setUnits(ModelConst.C);
                continue;
            }
            tSRecord.setUnits(ModelConst.z);
        }
        return string;
    }

    public void updateOutputFPart() {
        this._outputFpart = this.getOutputFPart();
    }

    public String constructTSRecordProxyDssPath(TSRecordProxy object, String string) {
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "";
        stringArray2[1] = this._system.getNameForKeyString(object.getName());
        stringArray2[2] = object.getParamName();
        if ((stringArray2[2].equals("FLOW") || stringArray2[2].equals("Flow")) && !string.equals("-REG")) {
            stringArray2[2] = stringArray2[2] + string;
        } else if (stringArray2[2].equalsIgnoreCase("Flow-In") && string.equals("-UNREG") && object.getParent() instanceof Junction && ((Junction)object.getParent()).getElement() instanceof JunctionElement) {
            stringArray2[2] = stringArray2[2] + string;
        } else if (stringArray2[2].equals(ModelConst.m) && !string.equals("-REG")) {
            stringArray2[2] = stringArray2[2] + string;
        } else if (stringArray2[2].equals(ModelConst.k) && !string.equals("-REG")) {
            stringArray2[2] = stringArray2[2] + string;
        } else if (stringArray2[2].equals(ReservoirElement.STORAGE)) {
            stringArray2[2] = ModelConst.n;
        } else if (stringArray2[2].equals(ReservoirElement.ELEVATION)) {
            stringArray2[2] = ModelConst.k;
        } else if (stringArray2[2].length() == 0) {
            if (string.equalsIgnoreCase("-reg")) {
                return null;
            }
            stringArray2[2] = string;
        }
        stringArray2[3] = this._runTimeWindow.getLookbackDateString();
        stringArray2[4] = this._runTimeWindow.getTimeStepString(0);
        stringArray2[5] = this.getOutputFPart();
        object = DSSPathString.getPathname((String[])stringArray2);
        return object;
    }

    public String constructWQTSRecordProxyDssPath(TSRecordProxy tSRecordProxy) {
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "";
        stringArray2[1] = this._system.getNameForKeyString(tSRecordProxy.getName());
        stringArray2[2] = tSRecordProxy.getParamName();
        stringArray2[3] = this._runTimeWindow.getStartDateString();
        int n = this._alt.getWaterQualityOptions().getTimestepMinutes();
        RunTimeWindow runTimeWindow = new RunTimeWindow(this._runTimeWindow);
        runTimeWindow.setTimeStep(n, 1);
        stringArray2[4] = runTimeWindow.getTimeStepString(0);
        stringArray2[5] = this.getOutputFPart();
        return DSSPathString.getPathname((String[])stringArray2);
    }

    public String constructGvDssPath(GlobalVariable object, String objectArray) {
        Object[] objectArray2 = new String[6];
        objectArray = objectArray2;
        objectArray2[0] = "";
        Arrays.fill(objectArray, "");
        objectArray[1] = this._system.getNameForKeyString(object.getName());
        if (object instanceof TableGlobalVariable) {
            objectArray[2] = GlobalVariableUtils.a((TableGlobalVariable)object);
        }
        if (object.getType() == GlobalVariableType.TIME_SERIES) {
            objectArray[2] = ((TimeSeriesGlobalVariable)object).getParameter();
            objectArray[3] = this._runTimeWindow.getLookbackDateString();
            objectArray[4] = this._runTimeWindow.getTimeStepString(0);
        } else {
            objectArray[3] = object.getType().toString();
            if (object instanceof ScalarGlobalVariable) {
                objectArray[4] = object = GlobalVariableUtils.a((ScalarGlobalVariable)object);
            }
        }
        objectArray[5] = this.getOutputFPart();
        object = DSSPathString.getPathname((String[])objectArray);
        return object;
    }

    @Scriptable
    public String getOutputFPart() {
        if (this._outputFpart != null) {
            return this._outputFpart;
        }
        if (this._runId == null) {
            return this.getName();
        }
        return this._runId.substring(0, this._modelPos);
    }

    public void setOutputFPart(String string) {
        this._outputFpart = string;
    }

    @Scriptable
    public String getDSSOutputFile() {
        if (this._outputDSSFilePath != null) {
            return this._outputDSSFilePath;
        }
        if (RMAIO.isFullPath((String)this._outputDSSFileName)) {
            return this._outputDSSFileName;
        }
        try {
            this._outputDSSFilePath = ((RmiWorkspace)this._Workspace.getRemote()).getWorkspacePath() + "/" + this._outputDSSFileName;
        }
        catch (Exception exception) {
            return this._outputDSSFileName;
        }
        return this._outputDSSFilePath;
    }

    public void setForecastDir(String string) {
        this._forecastDir = string;
    }

    public void setDSSOutputFile(String string) {
        this._outputDSSFilePath = string;
        if (string != null) {
            try {
                this._outputDSSFileName = RMAIO.getRelativePath((String)((RmiWorkspace)this._Workspace.getRemote()).getWorkspacePath(), (String)string);
                return;
            }
            catch (Exception exception) {
                this._outputDSSFileName = string;
            }
        }
    }

    public void setRunId(String string) {
        this._runId = string;
    }

    public String getRunId() {
        return this._runId;
    }

    public void setTimeWindow(RunTimeWindow runTimeWindow) {
        HecTime hecTime;
        int n;
        runTimeWindow.setShowTimeAsBeginningOfDay(false);
        this._runTimeWindow = new RunTimeWindow(runTimeWindow);
        int n2 = this._runTimeWindow.getTimeStepSeconds();
        HecTime hecTime2 = this._runTimeWindow.getLookbackTime();
        int n3 = hecTime2.secondsSinceMidnight();
        long l = hecTime2.getTimeInMillis();
        if (n3 % n2 != 0) {
            int n4 = (int)Math.ceil((double)n3 / (double)n2) * n2;
            hecTime2.setTimeInMillis(l += (long)((n4 - n3) * 1000));
            this._runTimeWindow.setLookbackTime(hecTime2);
        }
        HecTime hecTime3 = this._runTimeWindow.getStartTime();
        int n5 = hecTime3.secondsSinceMidnight();
        long l2 = hecTime3.getTimeInMillis();
        if (n5 % n2 != 0) {
            n = (int)Math.floor((double)n5 / (double)n2) * n2;
            if ((l2 += (long)((n - n5) * 1000)) <= l) {
                l2 += (long)(n2 * 1000);
            }
            hecTime3.setTimeInMillis(l2);
            this._runTimeWindow.setStartTime(hecTime3);
        }
        if ((n3 = (hecTime = this._runTimeWindow.getEndTime()).secondsSinceMidnight()) % n2 != 0) {
            n = (int)Math.floor((double)n3 / (double)n2) * n2;
            long l3 = hecTime.getTimeInMillis();
            long l4 = l3 + (long)((n - n3) * 1000);
            hecTime.setTimeInMillis(l4);
            this._runTimeWindow.setEndTime(hecTime);
        }
        this.setModified(true);
    }

    public ReleaseOverrides getDiversionOverrides() {
        return this._diversionOverrides;
    }

    public ReleaseOverrides getReleaseOverrides() {
        return this._releaseOverrides;
    }

    public ReleaseOverrides getElevationOverrides() {
        return this._elevationOverrides;
    }

    public ReleaseOverrides getGateOverrides() {
        return this._gateOverrides;
    }

    public ReleaseOverrides getCapacityOverrides() {
        return this._capacityOverrides;
    }

    public ReleaseOverrides getStorageOverrides() {
        return this._storageOverrides;
    }

    public ReleaseOverrides getElevationStorageOverrides() {
        return this._elevStorageOverrides;
    }

    public void readReleaseOverrides() {
        if (this._releaseOverrides != null) {
            RssRun rssRun = this;
            rssRun.readReleaseOverrides(rssRun._releaseOverrides);
        }
        if (this._diversionOverrides != null) {
            RssRun rssRun = this;
            rssRun.readReleaseOverrides(rssRun._diversionOverrides);
        }
        if (this._elevationOverrides != null) {
            RssRun rssRun = this;
            rssRun.readReleaseOverrides(rssRun._elevationOverrides);
        }
        if (this._gateOverrides != null) {
            RssRun rssRun = this;
            rssRun.readReleaseOverrides(rssRun._gateOverrides);
        }
        if (this._capacityOverrides != null) {
            RssRun rssRun = this;
            rssRun.readReleaseOverrides(rssRun._capacityOverrides);
        }
        if (this._storageOverrides != null) {
            RssRun rssRun = this;
            rssRun.readReleaseOverrides(rssRun._storageOverrides);
        }
        if (this._elevStorageOverrides != null) {
            RssRun rssRun = this;
            rssRun.readReleaseOverrides(rssRun._elevStorageOverrides);
        }
    }

    private void readReleaseOverrides(ReleaseOverrides releaseOverrides) {
        Enumeration<String> enumeration = releaseOverrides.a.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Object object = releaseOverrides.a.get(string);
            if (object == null || !(object instanceof ReleaseOverrides$Overrides) || (object = ((ReleaseOverrides$Overrides)object).b) != null) continue;
            releaseOverrides.getReleaseValues(string);
        }
    }

    public boolean updateReleaseOverrides() {
        int n;
        int n2;
        Hashtable<String, Object> hashtable;
        String[] stringArray;
        String string;
        Object object;
        int n3;
        Cloneable cloneable;
        Object object2;
        int n4;
        Object object3;
        RunTimeWindow runTimeWindow = this.getRunTimeWindow();
        int n5 = runTimeWindow.getStartTime().value();
        int n6 = runTimeWindow.getTimeStepMinutes();
        int n7 = (runTimeWindow.getEndTime().value() - n5) / n6 + 1;
        if (this._releaseOverrides == null) {
            this._releaseOverrides = new ReleaseOverrides();
        }
        if (this._elevationOverrides == null) {
            this._elevationOverrides = new ReleaseOverrides();
        }
        if (this._gateOverrides == null) {
            this._gateOverrides = new ReleaseOverrides();
        }
        if (this._capacityOverrides == null) {
            this._capacityOverrides = new ReleaseOverrides();
        }
        if (this._storageOverrides == null) {
            this._storageOverrides = new ReleaseOverrides();
        }
        if (this._elevStorageOverrides == null) {
            this._elevStorageOverrides = new ReleaseOverrides();
        }
        if (this._diversionOverrides == null) {
            this._diversionOverrides = new ReleaseOverrides();
        }
        if (this._system == null) {
            try {
                object3 = new Identifier(this._altPath);
                this._alt = (RssAlt)this._proxyList.loadManager(RssAlt.class.getName(), (Identifier)object3);
                this._system = this._alt.getSystem();
            }
            catch (Exception exception) {
                System.out.println(exception);
                this.printErrorMessage("Failed to load system managers.");
                return false;
            }
            if (this._system == null) {
                return false;
            }
        }
        this._releaseOverrides.setRun(this);
        this._releaseOverrides.storeOverrides();
        this._releaseOverrides.setReleaseTimes(n5, n6, n7);
        object3 = this._system.getFlowContolTSRecordProxies();
        if (object3 != null && ((Vector)object3).size() > 0) {
            n4 = ((Vector)object3).size();
            object2 = new String[n4];
            for (int i = 0; i < n4; ++i) {
                TSRecordProxy tSRecordProxy = (TSRecordProxy)((Vector)object3).elementAt(i);
                if (tSRecordProxy == null) continue;
                object2[i] = tSRecordProxy.getName();
            }
            this._releaseOverrides.updateReleases((String[])object2, 1);
            cloneable = new Hashtable<String, String>();
            for (n3 = 0; n3 < n4; ++n3) {
                object = (TSRecordProxy)((Vector)object3).elementAt(n3);
                string = this.constructTSRecordProxyDssPath((TSRecordProxy)object, "-REG");
                ((Hashtable)cloneable).put(object.getName(), string);
            }
            this._releaseOverrides.setDssPathTable((Hashtable)cloneable);
        }
        if (!this._releaseOverrides.updateAltData()) {
            return false;
        }
        this._diversionOverrides.setRun(this);
        this._diversionOverrides.storeOverrides();
        this._diversionOverrides.setReleaseTimes(n5, n6, n7);
        object3 = this._system.getDivContolTSRecordProxies();
        if (object3 != null && !((Vector)object3).isEmpty()) {
            n4 = ((Vector)object3).size();
            object2 = new String[n4];
            for (int i = 0; i < n4; ++i) {
                TSRecordProxy tSRecordProxy = (TSRecordProxy)((Vector)object3).elementAt(i);
                if (tSRecordProxy == null) continue;
                object2[i] = tSRecordProxy.getName();
            }
            this._diversionOverrides.updateReleases((String[])object2, 1);
            cloneable = new Hashtable();
            for (n3 = 0; n3 < n4; ++n3) {
                object = (TSRecordProxy)((Vector)object3).elementAt(n3);
                string = this.constructTSRecordProxyDssPath((TSRecordProxy)object, "-REG");
                ((Hashtable)cloneable).put(object.getName(), string);
            }
            this._diversionOverrides.setDssPathTable((Hashtable)cloneable);
        }
        if (this._elevationOverrides == null) {
            this._elevationOverrides = new ReleaseOverrides();
        }
        this._elevationOverrides.setRun(this);
        this._elevationOverrides.setReleaseTimes(n5, n6, n7);
        String[] stringArray2 = this._system.getReservoirNames();
        object2 = new Vector();
        if (stringArray2 != null && stringArray2.length > 0) {
            cloneable = new Hashtable();
            String[] stringArray3 = new String[stringArray2.length];
            int n8 = 0;
            for (int i = 0; i < stringArray2.length; ++i) {
                object = this._system.findReservoir(stringArray2[i]);
                ((Vector)object2).addElement(object);
                stringArray = ((ReservoirElement)object).getStorageFunction().getTSRecordProxy(10);
                if (stringArray == null) continue;
                stringArray3[n8] = stringArray.getName();
                hashtable = this.constructTSRecordProxyDssPath((TSRecordProxy)stringArray, "");
                ((Hashtable)cloneable).put(stringArray.getName(), hashtable);
                ++n8;
            }
            this._elevationOverrides.updateReleases(stringArray3, 2);
            this._elevationOverrides.setDssPathTable((Hashtable)cloneable);
        }
        this._gateOverrides.setRun(this);
        this._gateOverrides.setReleaseTimes(n5, n6, n7);
        cloneable = new Vector();
        if (!((Vector)object2).isEmpty()) {
            int n9 = ((Vector)object2).size();
            try {
                Class<?> clazz = Class.forName(AdjustableFlow.class.getName());
                for (int i = 0; i < n9; ++i) {
                    object = (ReservoirElement)((Vector)object2).elementAt(i);
                    hashtable = ((Element)object).getElementsByClass(clazz, null);
                    n2 = ((Vector)((Object)hashtable)).size();
                    for (n = 0; n < n2; ++n) {
                        AdjustableFlow adjustableFlow;
                        if (!(((Element)((Vector)((Object)hashtable)).elementAt(n)).getFunction() instanceof AdjustableFlow) || !(adjustableFlow = (AdjustableFlow)((Element)((Vector)((Object)hashtable)).elementAt(n)).getFunction()).hasMultipleGateSettings()) continue;
                        ((Vector)cloneable).addElement(adjustableFlow);
                    }
                }
            }
            catch (Exception exception) {}
            n9 = ((Vector)cloneable).size();
            stringArray = new String[n9];
            hashtable = new Hashtable();
            n2 = 0;
            for (n = 0; n < n9; ++n) {
                TSRecordProxy tSRecordProxy;
                Object object4 = (AdjustableFlow)((Vector)cloneable).elementAt(n);
                int n10 = 31;
                if (((AdjustableFlow)object4).getGateSettingsParamId() == Parameter.PARAMID_PERCENT) {
                    n10 = 32;
                }
                if ((tSRecordProxy = ((RssTSLocationObject)object4).getTSRecordProxy(n10)) == null) continue;
                stringArray[n2] = tSRecordProxy.getName();
                object4 = this.constructTSRecordProxyDssPath(tSRecordProxy, "");
                hashtable.put(tSRecordProxy.getName(), object4);
                ++n2;
            }
            this._gateOverrides.updateReleases(stringArray, 3);
            this._gateOverrides.setDssPathTable(hashtable);
        }
        this._capacityOverrides.setRun(this);
        this._capacityOverrides.setReleaseTimes(n5, n6, n7);
        Vector vector = new Vector();
        if (!((Vector)object2).isEmpty()) {
            int n11 = ((Vector)object2).size();
            try {
                for (int i = 0; i < n11; ++i) {
                    ReservoirElement reservoirElement = (ReservoirElement)((Vector)object2).elementAt(i);
                    vector = reservoirElement.getElementsByClass(AdjustableFlow.class, vector);
                    vector = reservoirElement.getElementsByClass(Spillway.class, vector);
                }
            }
            catch (Exception exception) {
                System.out.println("updateReleaseOverrides: Exception " + String.valueOf(exception));
            }
            n11 = vector.size();
            stringArray = new String[n11];
            hashtable = new Hashtable<String, Object>();
            n2 = 0;
            for (n = 0; n < n11; ++n) {
                Element element = (Element)vector.get(n);
                if ((element = element.getTSRecordProxy(127)) == null) continue;
                stringArray[n2] = element.getName();
                String string2 = this.constructTSRecordProxyDssPath((TSRecordProxy)element, "CAPACITY-FACTOR");
                hashtable.put(element.getName(), string2);
                ++n2;
            }
            this._capacityOverrides.updateReleases(stringArray, 4);
            this._capacityOverrides.setDssPathTable(hashtable);
        }
        this._elevStorageOverrides.setRun(this);
        this._elevStorageOverrides.setReleaseTimes(n5, n6, n7);
        if (stringArray2 != null && stringArray2.length > 0) {
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            String[] stringArray4 = new String[stringArray2.length];
            int n12 = 0;
            for (int i = 0; i < stringArray2.length; ++i) {
                ReservoirElement reservoirElement = this._system.findReservoir(stringArray2[i]);
                ((Vector)object2).addElement(reservoirElement);
                TSRecordProxy tSRecordProxy = reservoirElement.getStorageFunction().getTSRecordProxy(10);
                if (tSRecordProxy == null) continue;
                stringArray4[n12] = tSRecordProxy.getName();
                String string3 = this.constructTSRecordProxyDssPath(tSRecordProxy, "");
                hashtable2.put(tSRecordProxy.getName(), string3);
                ++n12;
            }
            this._elevStorageOverrides.updateReleases(stringArray4, 6);
            this._elevStorageOverrides.setDssPathTable(hashtable2);
        }
        this._storageOverrides.setRun(this);
        this._storageOverrides.setReleaseTimes(n5, n6, n7);
        if (stringArray2 != null && stringArray2.length > 0) {
            Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
            String[] stringArray5 = new String[stringArray2.length];
            int n13 = 0;
            for (int i = 0; i < stringArray2.length; ++i) {
                ReservoirElement reservoirElement = this._system.findReservoir(stringArray2[i]);
                ((Vector)object2).addElement(reservoirElement);
                TSRecordProxy tSRecordProxy = reservoirElement.getStorageFunction().getTSRecordProxy(11);
                if (tSRecordProxy == null) continue;
                stringArray5[n13] = tSRecordProxy.getName();
                String string4 = this.constructTSRecordProxyDssPath(tSRecordProxy, "");
                hashtable3.put(tSRecordProxy.getName(), string4);
                ++n13;
            }
            this._storageOverrides.updateReleases(stringArray5, 5);
            this._storageOverrides.setDssPathTable(hashtable3);
        }
        return true;
    }

    protected GVDataSet createForecastInputGVData(GVDataSet object, String string, String object2) {
        string = this.getDSSOutputFile();
        this.printMessage("Creating Simulation Input GlobalData. Using DSSFile=" + string);
        object2 = new GVDataSet();
        object2.setWorkspace(this.getWorkspace());
        object2.setProxyList(object.getProxyList());
        object2.setName(object.getName());
        object2.setDescription(object.getDescription());
        object2.setIdentifier(object.getIdentifier());
        object = ((GVDataSet)((Object)object)).getGVRecords();
        DSSPathname dSSPathname = new DSSPathname();
        for (int i = 0; i < object.size(); ++i) {
            Object object3 = (GlobalVariableData)object.get(i);
            if (object3 == null) continue;
            GlobalVariableData globalVariableData = ((GVDataSet)((Object)object2)).createGVRecord(object3.getType(), object3.getIndex());
            globalVariableData.copyInto((GlobalVariableData)object3);
            globalVariableData.setName(object3.getName());
            globalVariableData.setDescription(object3.getDescription());
            object3 = object3.getDSSPathname();
            if (object3 == null) continue;
            dSSPathname.setPathname((String)object3);
            globalVariableData.setDSSPathname(dSSPathname.getPathname());
            if (!globalVariableData.getDSSFilename().isEmpty()) {
                globalVariableData.setDSSFilename(string);
            }
            if (globalVariableData.loadData()) continue;
            this.printWarningMessage("Failed to load data for Global Variable: " + globalVariableData.getName());
        }
        List<GlobalVariable> list = this._system.getInputGlobalVariables();
        if (list == null) {
            return null;
        }
        this.matchUpInputGvData(list, (GVDataSet)((Object)object2));
        this.printMessage("");
        return object2;
    }

    protected PDCDataSet createForecastInputPDCData(PDCDataSet object, String string, String object2) {
        string = this.getDSSOutputFile();
        this.printMessage("Creating Simulation Input PairedDataContainers. Using DSSFile=" + string);
        object2 = new PDCDataSet();
        object2.setWorkspace(this.getWorkspace());
        object2.setUserInterface(this.getUserInterface());
        object2.setProxyList(object.getProxyList());
        object2.setName(object.getName());
        object2.setDescription(object.getDescription() + " (Simulation)");
        if (object.getIdentifier() != null) {
            object2.setIdentifier(object.getIdentifier());
        }
        object = ((PDCDataSet)((Object)object)).getAll();
        ArrayList<PDCRecord> arrayList = new ArrayList<PDCRecord>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object3 = (PDCRecord)object.next();
            if (object3 == null) continue;
            String string2 = object3.getDSSFilename();
            object3 = new PDCDataSet$RecordBuilder().from((PDCRecord)object3);
            if (!string2.isEmpty()) {
                object3 = ((PDCDataSet$RecordBuilder)object3).withDssFilename(string);
            }
            arrayList.add(((PDCDataSet$RecordBuilder)object3).build());
        }
        ((PDCDataSet)((Object)object2)).addAll(arrayList);
        return object2;
    }

    protected void matchUpInputGvData(List<GlobalVariable> list, GVDataSet gVDataSet) {
        for (int i = 0; i < list.size(); ++i) {
            GlobalVariable globalVariable = list.get(i);
            if (globalVariable == null) continue;
            GlobalVariableData globalVariableData = gVDataSet.getGlobalVariableData(globalVariable.getIndex(), globalVariable.getType());
            if (globalVariableData == null) {
                this.printLogMessage("WARNING: Failed to initialize GlobalVariable " + globalVariable.getName());
                continue;
            }
            globalVariable.setGlobalVariableData(globalVariableData);
        }
    }

    protected TSDataSet createForecastInputTSData(TSDataSet object, String string, String string2) {
        TSDataSet tSDataSet = new TSDataSet();
        tSDataSet.setName("RssRun's " + object.getName());
        tSDataSet.setWorkspace(this.getWorkspace());
        tSDataSet.setProxyList(this.getProxyList());
        tSDataSet.setUserInterface(this._uiWrapper);
        if (this._logLevel >= 5) {
            this.printLogMessage("Creating Forecast Input TSData with DssFile='" + string + "' FPart='" + string2 + "'");
        }
        object = object.getTSRecords();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            TSRecord tSRecord = (TSRecord)((Vector)object).elementAt(i);
            if (tSRecord == null) continue;
            TSRecord tSRecord2 = tSDataSet.createTSRecord(tSRecord.getName(), tSRecord.getVariableId(), tSRecord.getParamName());
            tSRecord2.setInputDataPos(tSRecord.getInputDataPos());
            tSRecord2.setDSSFilename(string);
            String[] stringArray = tSRecord.getDSSPathname();
            if (stringArray == null) continue;
            stringArray = AbstractTSRecord.parseDssPath((String)stringArray);
            for (int j = 0; j < 6; ++j) {
                if (stringArray[j] != null) continue;
                stringArray[j] = "";
            }
            if (tSRecord.isDefaultData() && this._inputPos > 0) {
                stringArray[5] = string2.substring(0, this._inputPos);
            } else if (!tSRecord.isObservedData() && !tSRecord.isDefaultData()) {
                stringArray[5] = string2.substring(0, tSRecord.getInputDataPos() * this._fpartMultiplier);
            }
            DSSPathString.cleanPathParts((String[])stringArray);
            tSRecord2.setDSSPathname(stringArray);
        }
        return tSDataSet;
    }

    public boolean writeOutput(Identifier identifier) {
        if (this._output == null) {
            this.printErrorMessage("RssRun.writeOutput: No output available");
            return false;
        }
        identifier.getPath();
        HecFile hecFile = identifier.getFile();
        if (hecFile == null) {
            this.printErrorMessage("RssRun.writeOutput: Failed to get file " + identifier.getPath());
            return false;
        }
        System.out.println("opening " + hecFile.getPath());
        try {
            BufferedWriter bufferedWriter = hecFile.getBufferedWriter();
            if (bufferedWriter == null) {
                return false;
            }
            HecAsciiSerializer hecAsciiSerializer = new HecAsciiSerializer(bufferedWriter);
            hecAsciiSerializer.serializeObject((Object)this._output);
            bufferedWriter.flush();
            bufferedWriter.close();
            hecFile.save();
        }
        catch (IOException iOException) {
            this.printErrorMessage("RssRun.writeOutput: Failed to open file " + identifier.getPath());
            return false;
        }
        return true;
    }

    private void writeOutputTSRecords(TSDataSet tSDataSet) {
        OutputVerticalDatumType outputVerticalDatumType = this._alt.getOutputVerticalDatumType();
        boolean bl = OutputVerticalDatumType.AS_DEFINED.equals((Object)outputVerticalDatumType);
        Vector vector = tSDataSet.getTSRecords();
        for (int i = 0; i < vector.size() && !bl; ++i) {
            TSRecord tSRecord = (TSRecord)vector.elementAt(i);
            if (!(tSRecord instanceof IVerticalDatum)) continue;
            IVerticalDatum iVerticalDatum = (IVerticalDatum)tSRecord;
            try {
                iVerticalDatum.getVerticalDatumInfo();
            }
            catch (VerticalDatumException verticalDatumException) {
                continue;
            }
            if (tSRecord.getDSSPathname() == null) continue;
            try {
                iVerticalDatum.toVerticalDatum(outputVerticalDatumType.toString());
                continue;
            }
            catch (VerticalDatumException verticalDatumException) {
                Logger.getLogger(RssRun.class.getName()).log(Level.FINE, null, verticalDatumException);
            }
        }
        tSDataSet.writeTSRecords();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeFilteredOutputTSRecords(int n, TSDataSet tSDataSet) {
        int n2;
        Vector vector = this._system.getActiveTSProxies(null, 0, n);
        HashMap<OutputVerticalDatumType, Boolean> hashMap = new HashMap<OutputVerticalDatumType, Boolean>();
        DssOutputData dssOutputData = this._alt.getWriteDSSOutputDataTable();
        OutputVerticalDatumType outputVerticalDatumType = this._alt.getOutputVerticalDatumType();
        OutputVerticalDatumType.AS_DEFINED.equals((Object)outputVerticalDatumType);
        Vector vector2 = tSDataSet.getTSRecords();
        block19: for (n2 = 0; n2 < vector2.size(); n2 += 1) {
            Object object;
            TSRecord tSRecord = (TSRecord)vector2.get(n2);
            if (!(tSRecord instanceof IVerticalDatum)) continue;
            IVerticalDatum iVerticalDatum = (IVerticalDatum)tSRecord;
            try {
                iVerticalDatum.getVerticalDatumInfo();
            }
            catch (VerticalDatumException verticalDatumException) {
                continue;
            }
            hec.io.VerticalDatumContainer verticalDatumContainer = iVerticalDatum.getVerticalDatumContainer();
            if (verticalDatumContainer == null) continue;
            try {
                if (verticalDatumContainer.getNativeVerticalDatum().equals(VerticalDatumType.UNSPECIFIED.toString())) {
                    iVerticalDatum.setVerticalDatumInfo(null);
                    iVerticalDatum.setVerticalDatumContainer(null);
                    continue;
                }
            }
            catch (VerticalDatumException verticalDatumException) {
                object = verticalDatumException;
                verticalDatumException.printStackTrace();
            }
            if (tSRecord.getDSSPathname() == null) continue;
            switch (outputVerticalDatumType) {
                case AS_DEFINED: {
                    continue block19;
                }
                case NAVD88: {
                    try {
                        iVerticalDatum.toNAVD88();
                        object = new VerticalDatumSettings();
                        ((VerticalDatumSettings)object).setType(VerticalDatumType.NAVD88);
                        ((VerticalDatumSettings)object).setUnits(verticalDatumContainer.unit);
                        ((VerticalDatumSettings)object).setNGVDShiftToNAVD88(verticalDatumContainer.getNAVD88Offset() - verticalDatumContainer.getNGVD29Offset());
                        ((TSRecordImpl)tSRecord).setVerticalDatumContainer((VerticalDatumContainer)new hec.io.VerticalDatumContainer(((VerticalDatumSettings)object).toVerticalDatumXml()));
                    }
                    catch (VerticalDatumException verticalDatumException) {
                        Logger.getLogger(RssRun.class.getName()).log(Level.FINE, null, verticalDatumException);
                    }
                    continue block19;
                }
                case NGVD29: {
                    try {
                        ((TSRecordImpl)tSRecord).toNGVD29();
                        object = new VerticalDatumSettings();
                        ((VerticalDatumSettings)object).setType(VerticalDatumType.NGVD29);
                        ((VerticalDatumSettings)object).setUnits(verticalDatumContainer.unit);
                        ((VerticalDatumSettings)object).setNGVDShiftToNAVD88(verticalDatumContainer.getNAVD88Offset() - verticalDatumContainer.getNGVD29Offset());
                        ((TSRecordImpl)tSRecord).setVerticalDatumContainer((VerticalDatumContainer)new hec.io.VerticalDatumContainer(((VerticalDatumSettings)object).toVerticalDatumXml()));
                    }
                    catch (VerticalDatumException verticalDatumException) {
                        Logger.getLogger(RssRun.class.getName()).log(Level.FINE, null, verticalDatumException);
                    }
                    continue block19;
                }
                case UNSPECIFIED: {
                    try {
                        ((TSRecordImpl)tSRecord).setVerticalDatumInfo(null);
                        ((TSRecordImpl)tSRecord).setVerticalDatumContainer(null);
                    }
                    catch (VerticalDatumException verticalDatumException) {
                        object = verticalDatumException;
                        verticalDatumException.printStackTrace();
                    }
                    continue block19;
                }
            }
        }
        n2 = dssOutputData.writeAll() ? 1 : 0;
        if (n == 2) {
            dssOutputData.setWriteAllDSSOutput(false);
        }
        try {
            for (int i = 0; i < vector.size(); ++i) {
                outputVerticalDatumType = (TSRecordProxy)vector.elementAt(i);
                if (outputVerticalDatumType == null) continue;
                if (dssOutputData.writeAll()) {
                    tSDataSet.writeTSRecords();
                    if (n != 2) return;
                    dssOutputData.setWriteAllDSSOutput(n2 != 0);
                    return;
                }
                if (!dssOutputData.writeRecord((TSRecordProxy)outputVerticalDatumType) || n == 2 && outputVerticalDatumType.getVariableId() == 197 || hashMap.containsKey((Object)outputVerticalDatumType)) continue;
                if (outputVerticalDatumType.getTSRecord() == null || this.isValidToWrite(outputVerticalDatumType.getTSRecord()) && !outputVerticalDatumType.getTSRecord().writeTSData()) {
                    ((FluentLogger.Api)FLOGGER.atWarning()).log("TSDataSet.writeTSRecords(): writeTSData failed or record missing for " + String.valueOf((Object)outputVerticalDatumType));
                    continue;
                }
                hashMap.put(outputVerticalDatumType, Boolean.TRUE);
            }
            if (n != 2) return;
            dssOutputData.setWriteAllDSSOutput(n2 != 0);
            return;
        }
        catch (Throwable throwable) {
            if (n != 2) throw throwable;
            dssOutputData.setWriteAllDSSOutput(n2 != 0);
            throw throwable;
        }
    }

    private boolean isValidToWrite(TSRecord tSRecord) {
        if (tSRecord.getDSSPathname() == null || tSRecord.getDSSPathname().isEmpty()) {
            ((FluentLogger.Api)FLOGGER.atFine()).log("TSRecord " + String.valueOf(tSRecord) + " missing its DSS Pathname");
            return false;
        }
        if (tSRecord.getDSSFilename() == null || tSRecord.getDSSFilename().isEmpty()) {
            ((FluentLogger.Api)FLOGGER.atFine()).log("TSRecord " + String.valueOf(tSRecord) + " missing its DSS Filename");
            return false;
        }
        return true;
    }

    public boolean writeFile(Identifier identifier) {
        if (this.getReadOnly()) {
            System.out.println("File " + identifier.getFile().getPath() + " is marked readonly");
            return false;
        }
        if (this._releaseOverrides != null && this._releaseOverrides.isModified()) {
            this._releaseOverrides.setRun(this);
            this._releaseOverrides.storeOverrides();
        }
        if (this._diversionOverrides != null && this._diversionOverrides.isModified()) {
            this._diversionOverrides.setRun(this);
            this._diversionOverrides.storeOverrides();
        }
        if (this._elevationOverrides != null && this._elevationOverrides.isModified()) {
            this._elevationOverrides.setRun(this);
            this._elevationOverrides.storeOverrides();
        }
        if (this._gateOverrides != null && this._gateOverrides.isModified()) {
            this._gateOverrides.setRun(this);
            this._gateOverrides.storeOverrides();
        }
        if (this._capacityOverrides != null && this._capacityOverrides.isModified()) {
            this._capacityOverrides.setRun(this);
            this._capacityOverrides.storeOverrides();
        }
        if (this._elevStorageOverrides != null && this._elevStorageOverrides.isModified()) {
            this._elevStorageOverrides.setRun(this);
            this._elevStorageOverrides.storeOverrides();
        }
        if (this._storageOverrides != null && this._storageOverrides.isModified()) {
            this._storageOverrides.setRun(this);
            this._storageOverrides.storeOverrides();
        }
        this._version = 1001;
        HecFile hecFile = identifier.getFile();
        System.out.println("writing " + hecFile.getPath());
        this.setReloadOk(false);
        try {
            BufferedWriter bufferedWriter = hecFile.getBufferedWriter();
            HecAsciiSerializer hecAsciiSerializer = new HecAsciiSerializer(bufferedWriter);
            hecAsciiSerializer.serializeObject((Object)this);
            bufferedWriter.flush();
            bufferedWriter.close();
            hecFile.save();
        }
        catch (IOException iOException) {
            this.printMessage("Failed to open file " + identifier.getPath());
            return false;
        }
        finally {
            this.setReloadOk(true);
        }
        this.setModified(false);
        this.setReloadOk(true);
        return true;
    }

    public boolean reLoadFile(Identifier identifier) {
        if (this.getReloadOk()) {
            this._regOutputTSData = null;
            return this.readFile(identifier);
        }
        return false;
    }

    public boolean readFile(Identifier identifier) {
        boolean bl;
        if (this._computing) {
            return true;
        }
        HecFile hecFile = identifier.getFile();
        System.out.println("opening " + hecFile.getPath());
        this._output = null;
        try {
            BufferedReader bufferedReader = hecFile.getBufferedReader();
            hecFile = new HecAsciiDeserializer(bufferedReader);
            bl = hecFile.deserializeObject((Object)this);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.printErrorMessage("Failed to open file " + identifier.getPath());
            return false;
        }
        this.setModified(false);
        if (!bl) {
            this.printErrorMessage("Failed to correctly read file " + identifier.getPath());
        }
        if (this._version < 1000) {
            this._altPath = this.getRelativePath(this._altPath);
        }
        if (this._version < 1001) {
            this._computeCumLoc = true;
        }
        return bl;
    }

    public long getRunModifiedTime() {
        return super.getLastModifiedTime();
    }

    public void setFpartPos(int n, int n2) {
        this._inputPos = n;
        this._modelPos = n2;
    }

    public void setFpartMultiplier(int n) {
        this._fpartMultiplier = n;
    }

    public long getLastModifiedTime() {
        long l = super.getLastModifiedTime();
        if (l == Long.MAX_VALUE) {
            l = 0L;
        }
        RssRun rssRun = this;
        l = rssRun.getModTime(rssRun._altPath, RssAlt.class.getName(), l);
        return l;
    }

    public boolean getComputeUnReg() {
        return this._computeUnReg;
    }

    public void setComputeUnReg(boolean bl) {
        this._computeUnReg = bl;
        this.setModified(true);
    }

    public boolean getComputeHoldout() {
        return this._computeHoldout;
    }

    public void setComputeHoldout(boolean bl) {
        this._computeHoldout = bl;
        this.setModified(true);
    }

    public boolean getComputeCumLoc() {
        return this._computeCumLoc;
    }

    public void setComputeCumLoc(boolean bl) {
        this._computeCumLoc = bl;
        this.setModified(true);
    }

    public int getLogLevel() {
        return this._logLevel;
    }

    public void setLogLevel(int n) {
        this._logLevel = n;
        this.setModified(true);
    }

    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        if (this._releaseOverrides != null && this._releaseOverrides.isModified()) {
            return true;
        }
        if (this._diversionOverrides != null && this._diversionOverrides.isModified()) {
            return true;
        }
        if (this._elevationOverrides != null && this._elevationOverrides.isModified()) {
            return true;
        }
        if (this._gateOverrides != null && this._gateOverrides.isModified()) {
            return true;
        }
        if (this._capacityOverrides != null && this._capacityOverrides.isModified()) {
            return true;
        }
        if (this._elevStorageOverrides != null && this._elevStorageOverrides.isModified()) {
            return true;
        }
        return this._storageOverrides != null && this._storageOverrides.isModified();
    }

    public Manager saveManagerAs(String string, String string2, ManagerProxyListContainer managerProxyListContainer) {
        Object object = this.getFileManager();
        if (object == null) {
            return null;
        }
        if (managerProxyListContainer == null) {
            managerProxyListContainer = this._proxyList.getContainer();
        }
        object = this._proxyList.getModel();
        if ((string = this.getSaveAsId(string, string2, (object = (managerProxyListContainer = managerProxyListContainer.getManagerProxyList((String)object)).newManager(this.getClass().getName())).getIndex())) == null) {
            return null;
        }
        object.getIdentifier().copy((Identifier)string);
        object.getIdentifier().setName(string2);
        int n = object.getIndex();
        object.readFile(this.getIdentifier());
        object.setName(string2);
        object.setDescription(this.getDescription());
        object.setIndex(n);
        object.setModified(true);
        managerProxyListContainer.saveManager(UserId.getUserId(), (Manager)object);
        managerProxyListContainer.unloadManager(object.getIdentifier());
        if (object.isModified()) {
            Object object2 = object;
            object2.writeFile(object2.getIdentifier());
        }
        return object;
    }

    protected Identifier getSaveAsId(String string, String object, int n, Identifier identifier) {
        object = (String)object + ".rssrun";
        if (string != null) {
            if (!RMAIO.isFullPath((String)string)) {
                RmiWorkspace rmiWorkspace = (RmiWorkspace)this._Workspace.getRemote();
                try {
                    string = rmiWorkspace.makeAbsolutePath(string);
                }
                catch (RemoteException remoteException) {
                    System.out.println("getSaveAsId: RMI error making absolute path " + String.valueOf(remoteException));
                }
            }
        } else {
            string = RMAIO.getDirectoryFromPath((String)identifier.getPath());
        }
        String string2 = string + "/" + (String)object;
        string2 = new Identifier(string2);
        string2.setName(this.getName());
        string2.setDescription(this.getDescription());
        return string2;
    }

    public boolean refreshData(Manager object) {
        if (!(object instanceof RssRun)) {
            return false;
        }
        RssRun rssRun = (RssRun)object;
        String string = this._altPath;
        RunTimeWindow runTimeWindow = new RunTimeWindow(rssRun.getRunTimeWindow());
        RunTimeWindow runTimeWindow2 = new RunTimeWindow(this.getRunTimeWindow());
        if (!super.refreshData((Manager)object)) {
            return false;
        }
        this.setTimeWindow(runTimeWindow2);
        rssRun.setTimeWindow(runTimeWindow);
        this._altPath = string;
        object = rssRun.getReleaseOverrides();
        if (object != null) {
            ((ReleaseOverrides)object).setForceWrite(true);
            ((ReleaseOverrides)object).setRun(this);
            ((ReleaseOverrides)object).storeOverrides();
            ((ReleaseOverrides)object).setRun(rssRun);
        }
        if ((object = rssRun.getElevationOverrides()) != null) {
            ((ReleaseOverrides)object).setForceWrite(true);
            ((ReleaseOverrides)object).setRun(this);
            ((ReleaseOverrides)object).storeOverrides();
            ((ReleaseOverrides)object).setRun(rssRun);
        }
        if ((object = rssRun.getGateOverrides()) != null) {
            ((ReleaseOverrides)object).setForceWrite(true);
            ((ReleaseOverrides)object).setRun(this);
            ((ReleaseOverrides)object).storeOverrides();
            ((ReleaseOverrides)object).setRun(rssRun);
        }
        return true;
    }

    public void setStorageOverrideType(int n) {
        this._storageOverrideType = n;
    }

    public int getStorageOverrideType() {
        return this._storageOverrideType;
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    public long[] getTimeInit() {
        return this._timeInit;
    }

    public void setTimeInit(long l) {
        this._timeInit[0] = l;
    }

    public long[] getTimePulse() {
        return this._timePulse;
    }

    public void setTimePulse(long l) {
        this._timePulse[0] = l;
    }

    public long[] getTimeCLoc() {
        return this._timeCLoc;
    }

    public void setTimeCLoc(long l) {
        this._timeCLoc[0] = l;
    }

    public long[] getTimeUReg() {
        return this._timeUReg;
    }

    public void setTimeUReg(long l) {
        this._timeUReg[0] = l;
    }

    public long[] getTimeReg2() {
        return this._timeReg2;
    }

    public void setTimeReg2(long l) {
        this._timeReg2[0] = l;
    }

    public long[] getTimeHOut() {
        return this._timeHOut;
    }

    public void setTimeHOut(long l) {
        this._timeHOut[0] = l;
    }

    public long[] getTimeCplt() {
        return this._timeCplt;
    }

    public void setTimeCplt(long l) {
        this._timeCplt[0] = l;
    }

    public String getReportPath() {
        return this.getWorkspacePath() + "/rss/" + RMAIO.userNameToFileName((String)this.getName()) + ".rpt";
    }

    public boolean saveReport() {
        Identifier identifier;
        RssAlt rssAlt = this.getAlternative();
        if (rssAlt == null) {
            ((FluentLogger.Api)FLOGGER.atWarning()).log("Error writing altenative report, null alternative");
            return false;
        }
        RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        String string = this.getReportPath();
        string = new Identifier(string);
        try {
            identifier = rmiFileManager.openFile(UserId.getUserId(), (Identifier)string);
            if (identifier == null) {
                identifier = rmiFileManager.newFile(UserId.getUserId(), (Identifier)string);
            }
            if (identifier == null) {
                ((FluentLogger.Api)FLOGGER.atInfo()).log("Failed to open file %s to save alternative report", (Object)string.getPath());
            }
            rmiFileManager = identifier.getFile();
        }
        catch (RemoteException remoteException) {
            ((FluentLogger.Api)FLOGGER.atWarning()).log("Error writing alternative report to %s for %s, error %s" + string.getPath(), (Object)rssAlt.getName(), (Object)remoteException.getMessage());
            return false;
        }
        if (rmiFileManager == null) {
            ((FluentLogger.Api)FLOGGER.atWarning()).log("Error getting file for alternative report %s for alt %s" + identifier.getPath(), (Object)rssAlt.getName());
            return false;
        }
        BufferedWriter bufferedWriter = rmiFileManager.getBufferedWriter();
        if (!rssAlt.writeReport(bufferedWriter, this.getRunTimeWindow(), this)) {
            return false;
        }
        try {
            bufferedWriter.flush();
            bufferedWriter.close();
            rmiFileManager.save();
        }
        catch (IOException iOException) {
            ((FluentLogger.Api)FLOGGER.atWarning()).log("Error writing alternative report %s for alt %s, error %s" + identifier.getPath(), (Object)rssAlt.getName(), (Object)iOException.getMessage());
            return false;
        }
        return true;
    }

    public Identifier getOutputReportId() {
        if (!this.saveReport()) {
            return null;
        }
        RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        String string = this.getReportPath();
        Identifier identifier = new Identifier(string);
        try {
            rmiFileManager = rmiFileManager.openFile(UserId.getUserId(), identifier);
            rmiFileManager = rmiFileManager.getFile();
        }
        catch (RemoteException remoteException) {
            ((FluentLogger.Api)FLOGGER.atWarning()).log("Error reading alternative report %s.", (Object)string);
            return null;
        }
        if (rmiFileManager == null) {
            ((FluentLogger.Api)FLOGGER.atWarning()).log("Failed to get file to read alternative report %s.", (Object)string);
            return null;
        }
        rmiFileManager = new Identifier(string, (HecFile)rmiFileManager);
        return rmiFileManager;
    }

    private void setTotalComputeTime(long l) {
        this._TOTAL_TIME = l;
    }

    protected long getTotalComputeTime() {
        return this._TOTAL_TIME;
    }

    @Override
    public void outputReport(AlternativeInputReport object, org.jdom.Element element) {
        Object object2;
        element.setAttribute("Simulation_Run_Name", this._name);
        element.setAttribute("Description", this.getDescription());
        if (((AlternativeInputReport)object).b().get((Object)AltInputReportEnums.SIM_TIME_WINDOW).a()) {
            object2 = new org.jdom.Element("RunTimeWindow");
            element.addContent((Content)object2);
            object2.setAttribute("Lookback_Time", this.getRunTimeWindow().getLookbackTime().toString(4));
            object2.setAttribute("Start_Time", this.getRunTimeWindow().getStartTime().toString(4));
            object2.setAttribute("End_Time", this.getRunTimeWindow().getEndTime().toString(4));
        }
        if (((AlternativeInputReport)object).b().get((Object)AltInputReportEnums.SIM_OVERRIDES).a()) {
            this.updateReleaseOverrides();
            this.readReleaseOverrides();
            if (this._capacityOverrides != null) {
                object2 = new org.jdom.Element("Capacity_Overrides");
                element.addContent((Content)object2);
                this._capacityOverrides.outputReport((AlternativeInputReport)object, (org.jdom.Element)object2, this._system);
            }
            if (this._elevationOverrides != null) {
                object2 = new org.jdom.Element("Elevation_Overrides");
                element.addContent((Content)object2);
                this._elevationOverrides.outputReport((AlternativeInputReport)object, (org.jdom.Element)object2, this._system);
            }
            if (this._elevStorageOverrides != null) {
                object2 = new org.jdom.Element("Elevation_Storage_Overrides");
                element.addContent((Content)object2);
                this._elevStorageOverrides.outputReport((AlternativeInputReport)object, (org.jdom.Element)object2, this._system);
            }
            if (this._gateOverrides != null) {
                object2 = new org.jdom.Element("Gate_Overrides");
                element.addContent((Content)object2);
                this._gateOverrides.outputReport((AlternativeInputReport)object, (org.jdom.Element)object2, this._system);
            }
            if (this._releaseOverrides != null) {
                object2 = new org.jdom.Element("Release_Overrides");
                element.addContent((Content)object2);
                this._releaseOverrides.outputReport((AlternativeInputReport)object, (org.jdom.Element)object2, this._system);
            }
            if (this._storageOverrides != null) {
                object2 = new org.jdom.Element("Storage_Overrides");
                element.addContent((Content)object2);
                this._storageOverrides.outputReport((AlternativeInputReport)object, (org.jdom.Element)object2, this._system);
            }
            if (this._diversionOverrides != null) {
                object2 = new org.jdom.Element("Diversion_Overrides");
                element.addContent((Content)object2);
                this._diversionOverrides.outputReport((AlternativeInputReport)object, (org.jdom.Element)object2, this._system);
            }
        }
        if (((AlternativeInputReport)object).b().get((Object)AltInputReportEnums.SIM_COMPUTE_OPTIONS).a()) {
            object2 = ClientApp.Workspace();
            if (object2 == null) {
                return;
            }
            if ((object2 = (RssRmiWorkspace)object2.getChildWorkspace("rss")) == null) {
                return;
            }
            try {
                RssComputeOptions rssComputeOptions = object2.getRssComputeOptions();
                if (rssComputeOptions == null) {
                    return;
                }
                object2 = new org.jdom.Element("Compute_Options");
                element.addContent((Content)object2);
                rssComputeOptions.outputReport((AlternativeInputReport)object, (org.jdom.Element)object2);
                return;
            }
            catch (RemoteException remoteException) {
                object = remoteException;
                remoteException.printStackTrace();
            }
        }
    }

    public void setAlternative(RssAlt rssAlt) {
        this._alt = rssAlt;
    }

    public void setTaskNumber(int n) {
        if (this._userInterface == null) {
            if (this._uiWrapper == null || this._uiWrapper.getRemote() == null || !(this._uiWrapper.getRemote() instanceof RmiProgress)) {
                System.out.println("\nTask Number " + n + "\n");
                return;
            }
            try {
                ((RmiProgress)this._uiWrapper.getRemote()).setTaskNumber(n);
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println("\nTask Number " + n + "\n");
                return;
            }
        }
        if (this._userInterface instanceof RmiProgress) {
            try {
                ((RmiProgress)this._userInterface).setTaskNumber(n);
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println("\nTask Number " + n + "\n");
            }
        }
    }

    public void setNumberTasks(int n) {
        if (this._userInterface == null) {
            if (this._uiWrapper == null || this._uiWrapper.getRemote() == null || !(this._uiWrapper.getRemote() instanceof RmiProgress)) {
                System.out.println("\nNumber of Tasks " + n + "\n");
                return;
            }
            try {
                ((RmiProgress)this._uiWrapper.getRemote()).setNumberTasks(n);
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println("\nNumber of Tasks " + n + "\n");
                return;
            }
        }
        if (this._userInterface instanceof RmiProgress) {
            try {
                ((RmiProgress)this._userInterface).setNumberTasks(n);
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println("\nNumber of Tasks " + n + "\n");
            }
        }
    }

    public boolean isSeededCompute() {
        return false;
    }

    public double simulationEventRandomSeed() {
        return 0.0;
    }

    public double simulationRealizationRandomSeed() {
        return 0.0;
    }

    public int seededIterationNumber() {
        return 0;
    }

    public void setAdditionalComputeOptions(Object object) {
        this._additionalComputeOptions = object;
    }

    public Object getAdditionalComputeOptions() {
        return this._additionalComputeOptions;
    }

    public void setVariantName(String string) {
        this._variantName = string;
    }

    public String getVariantName() {
        return this._variantName;
    }

    public void deleting() {
        String string = this.getIdentifier().getPath();
        File file = new File(string);
        if (file.exists()) {
            try {
                if (!this.getFileManager().deleteFile(string)) {
                    RssRun rssRun = this;
                    rssRun.printWarningMessage(rssRun.getName() + ".deleting: Failed to delete RssRun's *.rssrun file " + string);
                }
            }
            catch (RemoteException remoteException) {
                RssRun rssRun = this;
                rssRun.printWarningMessage(rssRun.getName() + ".deleting: Error deleting RssRun's *.rssrun file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
        if ((file = new File(string = string.concat(".bak"))).exists()) {
            try {
                if (!this.getFileManager().deleteFile(string)) {
                    RssRun rssRun = this;
                    rssRun.printWarningMessage(rssRun.getName() + ".deleting: Failed to delete RssRun's *.rssrun.bak file " + string);
                }
            }
            catch (RemoteException remoteException) {
                RssRun rssRun = this;
                rssRun.printWarningMessage(rssRun.getName() + ".deleting: Error deleting RssRun's *.rssrun.bak file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
        if ((file = new File(string = string.replace(".rssrun.bak", ".rssout"))).exists()) {
            try {
                if (!this.getFileManager().deleteFile(string)) {
                    RssRun rssRun = this;
                    rssRun.printWarningMessage(rssRun.getName() + ".deleting: Failed to delete RssRun's *.rssout file " + file.getPath());
                }
            }
            catch (RemoteException remoteException) {
                RssRun rssRun = this;
                rssRun.printWarningMessage(rssRun.getName() + ".deleting: Error deleting RssRun's *.rssout file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
        if ((file = new File(string = string.concat(".bak"))).exists()) {
            try {
                if (!this.getFileManager().deleteFile(string)) {
                    RssRun rssRun = this;
                    rssRun.printWarningMessage(rssRun.getName() + ".deleting: Failed to delete RssRun's *.rssout.bak file " + file.getPath());
                }
                return;
            }
            catch (RemoteException remoteException) {
                RssRun rssRun = this;
                rssRun.printWarningMessage(rssRun.getName() + ".deleting: Error deleting RssRun's *.rssout.bak file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
    }

    public void setComputeType(int n) {
        this._computeType = n;
    }

    public int getComputeType() {
        return this._computeType;
    }

    public ComputeStatus getLastComputeStatus() {
        return this._lastComputeStatus;
    }

    public void setLastComputeStatus(ComputeStatus computeStatus) {
        this._lastComputeStatus = computeStatus;
    }

    public WQRun getWQRun() {
        if (!this.shouldComputeWaterQuality()) {
            return null;
        }
        return this._wqRun;
    }

    public UserInterface setUserInterface(UserInterface userInterface) {
        super.setUserInterface(userInterface);
        if (this._regOutputGVData != null) {
            this._regOutputGVData.setUserInterface(userInterface);
        }
        if (this._inputGVData != null) {
            this._inputGVData.setUserInterface(userInterface);
        }
        return userInterface;
    }

    public RemoteWrapper setUserInterface(RemoteWrapper remoteWrapper) {
        super.setUserInterface(remoteWrapper);
        if (this._regOutputGVData != null) {
            this._regOutputGVData.setUserInterface(remoteWrapper);
        }
        if (this._inputGVData != null) {
            this._inputGVData.setUserInterface(remoteWrapper);
        }
        return remoteWrapper;
    }
}

