/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import codebase.Error4usage;
import com.vividsolutions.jts.geom.GeometryFactory;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxyList;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.StreamAlignment;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.clientapp.rmi.csinterface.HecRmiWorkspace;
import hec.clientapp.util.VersionUtilities;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.util.HecTime;
import hec.heclib.util.intContainer;
import hec.io.AsciiSerializable;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.dbf.AsciiSerializableDbfHeader;
import hec.io.dbf.DBFHeader;
import hec.io.dbf.DbfRecord;
import hec.io.dbf.DbfRecordIndexSet;
import hec.io.dbf.DbfRecordQuery;
import hec.io.dbf.DbfRecordSet;
import hec.lang.Logger;
import hec.lang.NamedType;
import hec.lang.UserId;
import hec.lang.annotation.Scriptable;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegion;
import hec.map.crs.CoordinateReferenceSystem;
import hec.model.CommonDataList;
import hec.model.ComputeCanceledCallback;
import hec.model.ConditionalBlock;
import hec.model.DataObject;
import hec.model.DataStruct;
import hec.model.MessagePrinter;
import hec.model.ModelVariable;
import hec.model.Node;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.SeasonalPairedValues;
import hec.model.SeasonalRecord;
import hec.model.StreamElement;
import hec.model.StreamSegment;
import hec.model.TSLocation;
import hec.model.TSManager;
import hec.model.TSRecord;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.RSS;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.ChannelType;
import hec.rss.model.ConditionalBlockRef;
import hec.rss.model.Dam;
import hec.rss.model.DayOfWeekMultiplier;
import hec.rss.model.DecisionEngine;
import hec.rss.model.DiversionDemandOpRule;
import hec.rss.model.DiversionElement;
import hec.rss.model.DiversionRule;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOp;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.DownstreamOptions;
import hec.rss.model.Element;
import hec.rss.model.ElementGraph;
import hec.rss.model.ElevReleaseOpRule;
import hec.rss.model.FlowFunction;
import hec.rss.model.FlowLimitOpRule;
import hec.rss.model.Function;
import hec.rss.model.GVDataSet;
import hec.rss.model.GatedIntakeControlDevice;
import hec.rss.model.HindcastData;
import hec.rss.model.HotstartContainer;
import hec.rss.model.HotstartOptions;
import hec.rss.model.IndependentVariable;
import hec.rss.model.InputTSBasedOpRule;
import hec.rss.model.IterationBlock;
import hec.rss.model.Junction;
import hec.rss.model.JunctionElement;
import hec.rss.model.MuskingumCunge8ptRouting;
import hec.rss.model.MuskingumCungePrismRouting;
import hec.rss.model.MuskingumCungeRouting;
import hec.rss.model.NetworkHotstartState;
import hec.rss.model.NetworkMigration;
import hec.rss.model.NullRouting;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.OpSet;
import hec.rss.model.Operations;
import hec.rss.model.PoolElevation;
import hec.rss.model.PowerPlantFlow;
import hec.rss.model.PulsChannelRouting;
import hec.rss.model.PulsChannelRoutingWithLosses;
import hec.rss.model.PumpOpRule;
import hec.rss.model.RSimDssPathPartGenerator;
import hec.rss.model.ReachElement;
import hec.rss.model.ReleaseElement;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReleaseFunctionInflowOpRule;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.RssAlt;
import hec.rss.model.RssConditional;
import hec.rss.model.RssConditionalBlock;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssRatingObject;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssRun;
import hec.rss.model.RssTSLocation;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.SpecFlowOpRule;
import hec.rss.model.Spillway;
import hec.rss.model.StateVariable;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.SystemHydropowerOpRule;
import hec.rss.model.SystemHydropowerRule;
import hec.rss.model.TailwaterElevation;
import hec.rss.model.TandemOp;
import hec.rss.model.TandemOpParent;
import hec.rss.model.TandemOpRule;
import hec.rss.model.TandemSysOpRule;
import hec.rss.model.TimeStepRoutingElement;
import hec.rss.model.TimeStepUtil;
import hec.rss.model.V1028Migration;
import hec.rss.model.VariableTSBasedOpRule;
import hec.rss.model.VerticalDatumSettings;
import hec.rss.model.VerticalDatumType;
import hec.rss.model.WQUtilities;
import hec.rss.model.WaterAccount;
import hec.rss.model.WaterAccountSet;
import hec.rss.model.engine.RSEngine;
import hec.rss.model.engine.RSNetworkAdapter2;
import hec.rss.model.globalvariable.CharacterSetType;
import hec.rss.model.globalvariable.ExternalGlobalVariable;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.model.globalvariable.ScalarDataType;
import hec.rss.model.globalvariable.ScalarGlobalVariable;
import hec.rss.model.globalvariable.StringGlobalVariable;
import hec.rss.model.globalvariable.TableGlobalVariable;
import hec.rss.model.globalvariable.TimeSeriesGlobalVariable;
import hec.rss.model.rs4engine.ComputeEngine;
import hec.rss.plugins.model.EmbeddedAlternative;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.server.RssComputeOptions;
import hec.rss.wq.model.AltWaterQualityOptions;
import hec.rss.wq.model.RssComputeWQObsStation;
import hec.rss.wq.model.WQRun;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointDataList;
import hec.watershed.model.Condition;
import hec.watershed.model.ConditionDataList;
import hec.watershed.model.Diversion;
import hec.watershed.model.Reservoir;
import hec.watershed.model.Study;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.WQException;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.rmi.RemoteException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import mil.army.usace.hec.rmi.csinterface.BaseDSSManager;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import mil.army.usace.hec.rmi.io.dbf.DbfFile;
import mil.army.usace.hec.rmi.io.dbf.DbfIdentifier;
import rma.util.IntArray;
import rma.util.IntVector;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class RssSystem
extends Manager
implements MapObjectInterface,
ComputeCanceledCallback,
TSManager,
RssReturnStatusConstants {
    public static final String REACH_STR = "Reach";
    public static final String RESERVOIR_STR = "Reservoir";
    public static final String JUNCTION_STR = "Junction";
    public static final String DIVERSION_STR = "Diversion";
    public static final int REACH = 0;
    public static final int RESERVOIR = 1;
    public static final int JUNCTION = 2;
    public static final int DIVERSION = 3;
    public static final int SPILLWAY = 4;
    public static final String KEYMARK = "~";
    public static final String KEYDELIM = ":";
    public static final int VERSION = 2029;
    public static final int HINDCAST_ELEM_STATE = 0;
    public static final int OUTER_TIME_ELEM_STATE = 1;
    public static final int TRIAL_ELEM_STATE = 2;
    public static final int INNER_TIME_ELEM_STATE = 3;
    public static final int TIME_BLOCK_ELEM_STATE = 4;
    public static final int TIME_BLOCK_ELEM_STATE2 = 5;
    public static final int PRE_COMPUTE_ELEM_STATE = 6;
    public static final int NUM_ELEM_STATES = 7;
    public static final int COMPUTE_ENGINE_3X = 0;
    public static final int COMPUTE_ENGINE_4A = 1;
    public static final int COMPUTE_ENGINE_4B = 2;
    public static final String GLOBAL_VARIABLE_TABLES_DSS = "GlobalVariableTables.dss";
    private static List e;
    private String _ressimVersion;
    int _version = -1;
    int _nextElementIndex = 0;
    int _nextNodeIndex = 0;
    private int _nextStateVariableIndex = 0;
    private int _nextTandemOpIndex = 0;
    List<StateVariable> _stateVariableList = new ArrayList<StateVariable>();
    Vector _nodeVector = new Vector();
    Vector _elementVector = new Vector();
    @Deprecated
    Vector _inputTSDataNameVector = new Vector();
    long _configurationID = Long.MIN_VALUE;
    private Map _systemHydropowerRuleTable = null;
    private int _nextSystemHydropowerRuleIndex = 0;
    private Hashtable _downstreamOpTable = null;
    private double _defaultPulseFlow = Double.NEGATIVE_INFINITY;
    public static final double DEFAULT_PULSE_FLOW_ENGLISH = 5000.0;
    public static final double DEFAULT_PULSE_FLOW_SI = 150.0;
    private transient Hashtable f = null;
    private transient RssRun g = null;
    private transient RssAlt h = null;
    private transient Operations i = null;
    private transient TSDataSet j = null;
    private transient GVDataSet k;
    private transient GVDataSet l;
    private transient TSDataSet m = null;
    private transient StreamAlignment n = null;
    private transient Condition o;
    private transient Map p = new HashMap();
    private transient Map q = new HashMap();
    private transient int[] r = null;
    private transient Vector s = null;
    private transient Vector<IterationBlock> t = null;
    private transient Hashtable u = null;
    private transient List v;
    private transient CommonDataList w;
    private transient CommonDataList x;
    private transient String y = null;
    transient String a = null;
    private transient DbfFile z;
    private transient DbfFile A;
    private transient HecAsciiDeserializer B;
    private transient HecAsciiSerializer C;
    private transient IntVector D = new IntVector();
    private transient IntVector E = new IntVector();
    private int _nextResOpId = 0;
    private int _nextResSysOpId = 0;
    private transient Vector F;
    private transient boolean G;
    private transient TandemOp H = null;
    private transient RSimDssPathPartGenerator I = new RSimDssPathPartGenerator();
    private transient RssComputeOptions J;
    private transient int K = 0;
    private transient int L = -1;
    private transient int M;
    private transient int N;
    private transient int O;
    private transient int P;
    private transient int Q;
    private transient HotstartContainer R = new HotstartContainer(this);
    private transient Map<String, HotstartContainer> S = new HashMap<String, HotstartContainer>();
    private transient int T = -1;
    private transient HecTime U = null;
    transient boolean b;
    private transient int[] V;
    transient RunTimeWindow c;
    private transient boolean W;
    private DownstreamOptions _defaultDownstreamOptions = new DownstreamOptions();
    private List<WaterAccountSet> _waterAccountSetList;
    private int _nextWaterAcountSetIndex = 0;
    private transient RunTimeStep X = new RunTimeStep();
    public static boolean d;
    private transient PrintWriter Y;
    private List<GlobalVariable> _globalVariableList = new ArrayList<GlobalVariable>();
    private int _nextGlobalVariableIndex = 0;
    private transient boolean Z = false;
    PrintWriter _convergWriter = null;
    private transient double[] aa;
    private transient double[] ab;
    private transient double[] ac;
    private transient double[] ad;
    private transient boolean[] ae;
    private transient StorageZone[][][] af;
    private transient StorageZone[][] ag;
    private transient Map<ReservoirElement, Integer> ah;
    PrintWriter _zbWriter = null;
    PrintWriter _elevWriter;

    public void finalize() throws Throwable {
        super.finalize();
    }

    public RunTimeStep getStateRts() {
        return this.X;
    }

    public ElementGraph buildElementGraph(int n, boolean bl) {
        return this.buildElementGraph(n, bl, true);
    }

    public ElementGraph buildElementGraph(int n, boolean bl, boolean bl2) {
        Element element;
        int n2;
        ElementGraph elementGraph = new ElementGraph();
        boolean bl3 = false;
        if (this.g != null) {
            elementGraph.a((MessagePrinter)this.g, this.g.getLogLevel());
            bl3 = this.g.getLogLevel() >= 8;
        }
        this.s = new Vector();
        int n3 = this._elementVector.size();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            element = (Element)this._elementVector.elementAt(n2);
            if (!element.isActive()) continue;
            elementGraph.a(element, n4);
            this.s.addElement(element);
            ++n4;
        }
        n3 = this.s.size();
        if (bl3) {
            elementGraph.a("Element Graph before rules");
        }
        if (bl) {
            ArrayList arrayList = new ArrayList();
            ArrayList<StorageZone> arrayList2 = new ArrayList<StorageZone>();
            for (n2 = 0; n2 < n3; ++n2) {
                int n5;
                Object object;
                Object object2;
                int n6;
                Object object3;
                Element element2;
                element = (Element)this.s.get(n2);
                if (element instanceof ReservoirElement) {
                    element2 = (ReservoirElement)element;
                    object3 = new ArrayList<Element>(5);
                    List list = element2.getTailwaterElevationObjects(null);
                    n6 = list.size();
                    for (int i = 0; i < n6; ++i) {
                        TailwaterElevation tailwaterElevation = (TailwaterElevation)list.get(i);
                        tailwaterElevation.getElementDependencies((List<Element>)object3, element2);
                    }
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (Element)object2.next();
                        elementGraph.a(element, (Element)object, "Reservoir Tailwater");
                    }
                    object3.clear();
                    int n7 = this.h.getResOpSetSelection(element2.getIndex());
                    arrayList.clear();
                    ((ReservoirElement)element2).getRules(n7, arrayList);
                    n5 = arrayList.size();
                    arrayList2.clear();
                    ((ReservoirElement)element2).getStorageZones(n7, arrayList2);
                    for (StorageZone storageZone : arrayList2) {
                        storageZone.getElementDependencies((List<Element>)object3);
                    }
                    object = object3.iterator();
                    while (object.hasNext()) {
                        Element element3 = (Element)object.next();
                        elementGraph.a(element, element3, "Reservoir Zone");
                    }
                    object3.clear();
                    for (int i = 0; i < n5; ++i) {
                        object = (OpRule)arrayList.get(i);
                        if (object == null) continue;
                        ((OpRule)object).getElementDependencies((List)object3);
                    }
                    object = new ArrayList();
                    ((ReservoirElement)element2).getConditionalBlockRefs(n7, (List<ConditionalBlockRef>)object);
                    object2 = object.iterator();
                    while (object2.hasNext()) {
                        ConditionalBlockRef conditionalBlockRef = (ConditionalBlockRef)object2.next();
                        if ((conditionalBlockRef = conditionalBlockRef.getConditionalBlock()) == null || !(conditionalBlockRef instanceof RssConditionalBlock)) continue;
                        ((RssConditionalBlock)((Object)conditionalBlockRef)).getElementDependencies(this, element2, (List<Element>)object3);
                    }
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        Element element4 = (Element)object2.next();
                        elementGraph.a(element, element4, "Reservoir Operating Rule");
                    }
                    continue;
                }
                if (element instanceof DiversionElement) {
                    int n8;
                    element2 = (DiversionElement)element;
                    Element element5 = ((DiversionElement)element2).getSourceElement();
                    elementGraph.a(element, element5, "Diversion Source Element");
                    ArrayList<Element> arrayList3 = new ArrayList<Element>(5);
                    n6 = this.h.getDivOpSetSelection(element2.getIndex());
                    arrayList.clear();
                    ((DiversionElement)element2).getRules(n6, arrayList);
                    n5 = arrayList.size();
                    for (n8 = 0; n8 < n5; ++n8) {
                        object = (OpRule)arrayList.get(n8);
                        if (object == null) continue;
                        ((OpRule)object).getElementDependencies(arrayList3);
                    }
                    ArrayList<ConditionalBlockRef> arrayList4 = new ArrayList<ConditionalBlockRef>();
                    ((DiversionElement)element2).getConditionalBlockRefs(n6, arrayList4);
                    for (ConditionalBlockRef conditionalBlockRef : arrayList4) {
                        object2 = conditionalBlockRef.getConditionalBlock();
                        if (object2 == null || !(object2 instanceof RssConditionalBlock)) continue;
                        ((RssConditionalBlock)((Object)object2)).getElementDependencies(this, element2, arrayList3);
                    }
                    for (Element element6 : arrayList3) {
                        elementGraph.a(element, element6, "Diversion Operating Rule");
                    }
                    object = ((DiversionElement)element2).getDiversionOps().getController().getRules(null);
                    n5 = ((Vector)object).size();
                    for (n8 = 0; n8 < n5; ++n8) {
                        NamedType namedType = (OpRule)((Vector)object).elementAt(n8);
                        if (namedType == null || !(namedType instanceof DiversionDemandOpRule)) continue;
                        object2 = ((DiversionDemandOpRule)namedType).getRule();
                        if (object2 instanceof FlowFunction) {
                            object3 = this.getNode(((FlowFunction)object2)._flowLocationIndex);
                            if (object3 == null || (namedType = ((RssNode)object3).getUpstreamElement()) == null) continue;
                            elementGraph.a(element, (Element)namedType, "Diversion Flow Dependence");
                            continue;
                        }
                        if (object2 instanceof PoolElevation) {
                            namedType = this.findReservoir(((PoolElevation)object2).getReservoirName());
                            if (namedType == null) continue;
                            elementGraph.a(element, (Element)namedType, "Diversion Pool Elevation Dependence");
                            continue;
                        }
                        if (!(object2 instanceof DiversionRule)) continue;
                        arrayList3.clear();
                        ((DiversionRule)object2).getElementDependencies(arrayList3);
                        int n9 = arrayList3.size();
                        for (int i = 0; i < n9; ++i) {
                            object3 = (Element)arrayList3.get(i);
                            elementGraph.a(element, (Element)object3, "Diversion Rule");
                        }
                    }
                    continue;
                }
                if (!(element instanceof JunctionElement) || (element2 = (JunctionElement)element).getFunction() == null || ((Junction)element2.getFunction()).getRatingObject() == null || !((Junction)element2.getFunction()).getRatingObject().usesIndependentVariable()) continue;
                RssRatingObject rssRatingObject = ((Junction)element2.getFunction()).getRatingObject();
                for (int n10 : rssRatingObject.getModelVariableElementIds()) {
                    object = this.getElement(n10);
                    if (object == null) {
                        this.printWarningMessage("Rating Function reference not found for Junction " + element.getName());
                        continue;
                    }
                    object2 = ((Element)object).getTopParent();
                    if (object2 == element) continue;
                    elementGraph.a(element, (Element)object2, "Junction Rating");
                }
            }
            if (bl3) {
                elementGraph.a("Element Graph after adding dependent elements");
            }
        }
        elementGraph.b();
        if (bl3) {
            elementGraph.a("Element Graph after adding creating dependent groups");
        }
        if (!(bl = elementGraph.c())) {
            this.printErrorMessage("RssSystem.buildElementGraph: failed to sort ElementGraph, check for and eliminate circular flow routes");
            if (bl2) {
                return null;
            }
        }
        if (bl3) {
            elementGraph.a("Element Graph after sort");
        }
        this.r = elementGraph.f();
        if (this.r == null || this.r.length != this.s.size()) {
            this.printErrorMessage("RssSystem.buildElementGraph: incomplete ordering of elements, check for and eliminate circular flow routes");
            if (bl2) {
                return null;
            }
        }
        return elementGraph;
    }

    public boolean orderElementsForCompute(int n) {
        int n2;
        List<EmbeddedAlternative> list = this.g.getEmbeddedAltList();
        boolean bl = n == 0 || this.h == null || list != null && list.size() > 0;
        Object object = this.buildElementGraph(n, bl);
        if (object == null) {
            return false;
        }
        int n3 = this.s.size();
        int n4 = n2 = n == 0 && this.g.shouldComputeWaterQuality() && this.g.isCoupledWQCompute() ? 1 : 0;
        if (n != 0 && this.h != null || list != null && list.size() > 0 || n2 != 0) {
            this.t = new Vector();
            IterationBlock iterationBlock = new IterationBlock();
            iterationBlock.b(0);
            iterationBlock.c(this.r.length);
            for (int i = 0; i < this.r.length; ++i) {
                if (this.r[i] < 0 || this.r[i] >= n3) {
                    RssSystem rssSystem = this;
                    rssSystem.printErrorMessage("RssSystem.orderElementsForCompute: element order index, " + rssSystem.r[i] + " is out of range at position " + i);
                    return false;
                }
                iterationBlock.b((Element)this.s.elementAt(this.r[i]));
            }
            this.t.addElement(iterationBlock);
            return true;
        }
        this.t = ((ElementGraph)object).g();
        boolean bl2 = true;
        if (this.t.size() <= 0) {
            bl2 = false;
        }
        if (this.g.getLogLevel() > 2) {
            this.printLogMessage("\nIteration Block Order for Compute Type - " + RssRun.COMPUTE_TYPE_NAME[n]);
            this.printLogMessage("Block\tElem ID\tElement Name");
            n2 = this.t.size();
            for (n3 = 0; n3 < n2; ++n3) {
                IterationBlock iterationBlock = this.t.elementAt(n3);
                for (int i = 0; i < iterationBlock.c(); ++i) {
                    object = iterationBlock.d(i);
                    if (object == null) continue;
                    this.printLogMessage(n3 + "\t" + object.getIndex() + "\t" + object.getName());
                }
            }
            this.printLogMessage("\n");
        }
        return bl2;
    }

    @Scriptable
    public int getComputeElemBlockCounter() {
        return this.M;
    }

    @Scriptable
    public int getComputePassCounter() {
        return this.N;
    }

    @Scriptable
    public int getComputeTimeStepCounter() {
        return this.O;
    }

    @Scriptable
    public int getComputeDecisionElemCounter() {
        return this.P;
    }

    @Scriptable
    public int getComputeRoutingStepCounter() {
        return this.Q;
    }

    public int getComputeType() {
        return this.L;
    }

    public TandemOp getTandemOp() {
        if (this.H == null) {
            this.H = new TandemOp(this);
        }
        return this.H;
    }

    public void initTandemOpForecastStep(RunTimeStep runTimeStep) {
        this.getTandemOp();
        this.H.a(runTimeStep);
    }

    int evaluateTandemOpStep(RunTimeStep runTimeStep, int n) {
        this.H.b(runTimeStep, n);
        return 0;
    }

    public TandemOpParent getTandemOpParent(int n) {
        if (this.f == null) {
            return null;
        }
        return (TandemOpParent)this.f.get(n);
    }

    public List getTandemOps() {
        ArrayList arrayList = new ArrayList();
        if (this.f == null) {
            return arrayList;
        }
        Object object = this.f.values();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        return arrayList;
    }

    public TandemOpParent newTandemOpParent(String object) {
        if (this.f == null) {
            this.f = new Hashtable();
        }
        object = new TandemOpParent((String)object, this.nextTandemOpIndex());
        this.f.put(new Integer(object.getIndex()), object);
        return object;
    }

    public TandemOpParent createTandemOpParent(TandemSysOpRule tandemSysOpRule) {
        TandemOpParent tandemOpParent = this.newTandemOpParent(tandemSysOpRule.getName());
        tandemOpParent.copyChildInto(tandemSysOpRule);
        tandemSysOpRule.setParentIndex(tandemOpParent.getIndex());
        return tandemOpParent;
    }

    public void deleteTandemOpParent(int n) {
        Object object;
        Vector<ReservoirElement> vector = this.getElementVectorByClass(ReservoirElement.class);
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            object = vector.elementAt(i);
            if ((object = ((ReservoirElement)object).getReservoirOp()) == null) continue;
            ((ReservoirOp)object).deleteTandemSysOpRulesForParent(n);
        }
        if (this.f != null) {
            object = n;
            this.f.remove(object);
        }
    }

    private int nextTandemOpIndex() {
        int n = this._nextTandemOpIndex++;
        return n;
    }

    public int initDownstreamPulse() {
        if (this._downstreamOpTable != null) {
            Enumeration enumeration = this._downstreamOpTable.keys();
            while (enumeration.hasMoreElements()) {
                int n;
                Object object = (Integer)enumeration.nextElement();
                DownstreamOp downstreamOp = (DownstreamOp)this._downstreamOpTable.get(object);
                if (downstreamOp == null || (object = this.getNode((Integer)object)) == null || (n = downstreamOp.initForPulse(this, (RssNode)object)) != 1) continue;
                this.printErrorMessage("RssSystem.initDownstreamOperations: initializtion failed for DownstreamOp at location " + object.getDisplayName());
                return 1;
            }
        }
        return 0;
    }

    public DownstreamOpRule getDownstreamOpRule(String string) {
        RssReturnStatusConstants rssReturnStatusConstants = null;
        if (this._downstreamOpTable == null) {
            return null;
        }
        Enumeration enumeration = this._downstreamOpTable.elements();
        while (enumeration.hasMoreElements()) {
            rssReturnStatusConstants = (DownstreamOp)enumeration.nextElement();
            if ((rssReturnStatusConstants = rssReturnStatusConstants.getDownstreamOpRule(string)) == null) continue;
            return rssReturnStatusConstants;
        }
        return rssReturnStatusConstants;
    }

    public void deleteDownstreamOpRule(int n, int n2) {
        RssReturnStatusConstants rssReturnStatusConstants;
        Vector<ReservoirElement> vector = this.getElementVectorByClass(ReservoirElement.class);
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            rssReturnStatusConstants = vector.elementAt(i);
            if ((rssReturnStatusConstants = ((ReservoirElement)rssReturnStatusConstants).getReservoirOp()) == null) continue;
            ((ReservoirOp)rssReturnStatusConstants).deletDownstreamRulesForParent(n, n2);
        }
        rssReturnStatusConstants = this.getDownstreamOp(n, false);
        if (rssReturnStatusConstants != null) {
            ((DownstreamOp)rssReturnStatusConstants).removeRule(n2);
        }
    }

    public void deleteDownstreamOp(int n) {
        if (this._downstreamOpTable == null) {
            return;
        }
        DownstreamOp downstreamOp = (DownstreamOp)this._downstreamOpTable.remove(n);
        if (downstreamOp != null) {
            downstreamOp.dispose();
            this.setModified(true);
        }
    }

    public SystemHydropowerRule createSystemHydropowerRule() {
        if (this._systemHydropowerRuleTable == null) {
            this._systemHydropowerRuleTable = new Hashtable();
        }
        SystemHydropowerRule systemHydropowerRule = new SystemHydropowerRule();
        systemHydropowerRule.setIndex(this._nextSystemHydropowerRuleIndex++);
        this._systemHydropowerRuleTable.put(new Integer(systemHydropowerRule.getIndex()), systemHydropowerRule);
        return systemHydropowerRule;
    }

    public SystemHydropowerRule getSystemHydropowerRule(int n) {
        if (this._systemHydropowerRuleTable == null) {
            return null;
        }
        Object object = n;
        object = (SystemHydropowerRule)this._systemHydropowerRuleTable.get(object);
        return object;
    }

    public SystemHydropowerRule getSystemHydropowerRule(String string) {
        if (string == null || this._systemHydropowerRuleTable == null) {
            return null;
        }
        Object object = this._systemHydropowerRuleTable.values();
        object = object.iterator();
        while (object.hasNext()) {
            SystemHydropowerRule systemHydropowerRule = (SystemHydropowerRule)object.next();
            if (!string.equals(systemHydropowerRule.getName())) continue;
            return systemHydropowerRule;
        }
        return null;
    }

    public void deleteSystemHydropowerRule(int n) {
        Object object;
        Vector<ReservoirElement> vector = this.getElementVectorByClass(ReservoirElement.class);
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            object = vector.elementAt(i);
            if ((object = ((ReservoirElement)object).getReservoirOp()) == null) continue;
            ((ReservoirOp)object).deleteSystemHydropowerRulesForParent(n);
        }
        if (this._systemHydropowerRuleTable != null) {
            object = n;
            this._systemHydropowerRuleTable.remove(object);
        }
    }

    public DownstreamOp getDownstreamOp(int n) {
        return this.getDownstreamOp(n, false);
    }

    public DownstreamOptions getDefaultDownstreamOptions() {
        return this._defaultDownstreamOptions;
    }

    public void setDefaultDownstreamOptions(DownstreamOptions downstreamOptions) {
        this._defaultDownstreamOptions = downstreamOptions;
    }

    public DownstreamOp getDownstreamOp(int n, boolean bl) {
        Integer n2;
        DownstreamOp downstreamOp;
        if (this._downstreamOpTable == null) {
            if (!bl) {
                return null;
            }
            this._downstreamOpTable = new Hashtable();
        }
        if ((downstreamOp = (DownstreamOp)this._downstreamOpTable.get(n2 = Integer.valueOf(n))) == null && bl) {
            downstreamOp = new DownstreamOp(n);
            this._downstreamOpTable.put(n2, downstreamOp);
        }
        return downstreamOp;
    }

    public List getSystemHydropowerRules() {
        Vector vector = new Vector();
        if (this._systemHydropowerRuleTable == null) {
            return vector;
        }
        Object object = this._systemHydropowerRuleTable.values();
        object = object.iterator();
        while (object.hasNext()) {
            vector.add(object.next());
        }
        return vector;
    }

    public Vector getDownstreamOpRulesBlwElement(ReservoirElement reservoirElement, Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        if (reservoirElement == null) {
            return vector;
        }
        if (this._downstreamOpTable == null) {
            return vector;
        }
        ArrayList<RssNode> arrayList = new ArrayList<RssNode>();
        this.getDownstreamNodeList(reservoirElement, arrayList);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            RssReturnStatusConstants rssReturnStatusConstants = (RssNode)arrayList.get(i);
            if (rssReturnStatusConstants == null || (rssReturnStatusConstants = (DownstreamOp)this._downstreamOpTable.get(new Integer(rssReturnStatusConstants.getIndex()))) == null) continue;
            ((DownstreamOp)rssReturnStatusConstants).getRules(vector);
        }
        return vector;
    }

    public TSRecordProxy getTSRecordProxy(String string, int n) {
        TSRecordProxy tSRecordProxy;
        int n2;
        Vector vector = this.getTSRecordProxies(true);
        int n3 = vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            tSRecordProxy = (TSRecordProxy)vector.elementAt(n2);
            if (tSRecordProxy == null || !tSRecordProxy.getName().equals(string) || tSRecordProxy.getVariableId() != n) continue;
            return tSRecordProxy;
        }
        vector = this.getTSRecordProxies(false);
        n3 = vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            tSRecordProxy = (TSRecordProxy)vector.elementAt(n2);
            if (tSRecordProxy == null || !tSRecordProxy.getName().equals(string) || tSRecordProxy.getVariableId() != n) continue;
            return tSRecordProxy;
        }
        return null;
    }

    public boolean isKeyString(String string) {
        return string != null && string.length() > 2 && string.indexOf(KEYMARK) >= 0;
    }

    public String getOriginalNetworkName() {
        String string = this.getName();
        if (string.contains(KEYDELIM)) {
            String string2 = string;
            string = string2.substring(string2.lastIndexOf(KEYDELIM), string.length() - 1);
        }
        return string;
    }

    public String getNameForKeyString(String string) {
        if (!this.isKeyString(string)) {
            return string;
        }
        int n = string.indexOf(KEYMARK);
        Object object = n > 0 ? string.substring(0, n) : "";
        NamedType namedType = this.getObjectForKeyString(string);
        if (namedType == null) {
            return string;
        }
        Object object2 = namedType.getDisplayName();
        if (namedType instanceof WaterAccount) {
            RssSystem rssSystem = this;
            if (rssSystem.getWaterAccountSet(rssSystem.h.getWaterAccountSetIndex()) != null) {
                RssSystem rssSystem2 = this;
                object = rssSystem2.getWaterAccountSet(rssSystem2.h.getWaterAccountSetIndex()).getName() + " - ";
            }
        }
        if (this.isKeyString((String)object2)) {
            object2 = this.getNameForKeyString((String)object2);
        }
        object2 = (String)object + (String)object2;
        int n2 = string.lastIndexOf(KEYMARK);
        if (n2 > 0 && n2 < string.length() - 1) {
            object2 = (String)object2 + " " + string.substring(n2 + 1);
        }
        return object2;
    }

    public String getKeyStringForObject(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        if (object instanceof Element) {
            object2 = "~E" + Integer.toString(((Element)object).getIndex());
        } else if (object instanceof Function) {
            object = ((Function)object).getElement();
            object2 = this.getKeyStringForObject(object) + ":F";
        } else if (object instanceof RssNode) {
            object2 = "~N" + Integer.toString(((RssNode)object).getIndex());
        } else if (object instanceof OpController) {
            object = (OpController)object;
            object2 = (Element)((Object)((OpController)object).getElementOp().getOperationsElement());
            object2 = this.getKeyStringForObject(object2) + ":C" + Integer.toString(object.getIndex());
        } else if (object instanceof OpRule) {
            object = (OpRule)object;
            object2 = ((OpRule)object).getController();
            object2 = this.getKeyStringForObject(object2) + ":R" + Integer.toString(object.getIndex());
        } else if (object instanceof StateVariable) {
            object2 = "~S" + Integer.toString(((StateVariable)object).getIndex());
        } else if (object instanceof WaterAccount) {
            object2 = "~W" + Integer.toString(((WaterAccount)object).getIndex());
        }
        return object2;
    }

    public NamedType getObjectForKeyString(String string) {
        if (string == null) {
            return null;
        }
        TSLocation tSLocation = null;
        int n = string.indexOf(KEYMARK);
        int n2 = string.lastIndexOf(KEYMARK);
        if (n >= 0) {
            string = n != n2 ? string.substring(n + 1, n2) : string.substring(n + 1);
        }
        if (n == -1 && n2 == -1) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, KEYDELIM);
        while (stringTokenizer.hasMoreElements()) {
            string = tSLocation;
            String string2 = stringTokenizer.nextToken();
            String string3 = string2.substring(0, 1);
            if (string3.equals("E")) {
                tSLocation = this.getElement(Integer.parseInt(string2.substring(1)));
                continue;
            }
            if (string3.equals("F")) {
                if (string == null || !(string instanceof Element)) break;
                tSLocation = ((Element)((Object)string)).getFunction();
                continue;
            }
            if (string3.equals("N")) {
                tSLocation = this.getNode(Integer.parseInt(string2.substring(1)));
                continue;
            }
            if (string3.equals("C")) {
                if (string == null || !(string instanceof ReservoirElement)) break;
                tSLocation = ((ReservoirElement)((Object)string)).getReservoirOp().getController(Integer.parseInt(string2.substring(1)));
                continue;
            }
            if (string3.equals("R")) {
                if (string == null || !(string instanceof OpController)) break;
                tSLocation = ((OpController)((Object)string)).getRule(Integer.parseInt(string2.substring(1)));
                continue;
            }
            if (string3.equals("S")) {
                tSLocation = this.getStateVariable(Integer.parseInt(string2.substring(1)));
                continue;
            }
            if (!string3.equals("W")) continue;
            tSLocation = this.getWaterAccount(Integer.parseInt(string2.substring(1)));
        }
        return tSLocation;
    }

    public String generateUniquePathPart(List list, String string) {
        return this.I.generatePathnamePart(list, string);
    }

    public void setupForSerialization() {
        int n = this._elementVector.size();
        this.I.clearPartsMap();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)this._elementVector.get(i);
            element.setupForSerialization();
        }
    }

    public void cleanupFromDeSerialization() {
        int n = this._elementVector.size();
        this.I.clearPartsMap();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)this._elementVector.get(i);
            element.cleanupFromDeSerialization();
        }
    }

    public String getBaseDirectory() {
        if (this.y != null) {
            return this.y;
        }
        return RMAIO.getDirectoryFromPath((String)this.getIdentifier().getPath());
    }

    public String getDssPairedDataFilePath() {
        String string = RMAIO.getFileFromPath((String)this.getIdentifier().getPath());
        if (this.a == null) {
            return this.getBaseDirectory() + "/" + RMAIO.removeFileExtension((String)string) + ".dss";
        }
        return this.getBaseDirectory() + "/" + RMAIO.getFileFromPath((String)this.a);
    }

    public Vector getHindcastDataList() {
        Object object;
        int n;
        Vector vector = new Vector();
        int n2 = this._elementVector.size();
        for (n = 0; n < n2; ++n) {
            object = (Element)this._elementVector.elementAt(n);
            if (object == null) continue;
            ((Element)object).getHindcastDataList(vector);
        }
        n2 = this._stateVariableList.size();
        for (n = 0; n < n2; ++n) {
            object = this._stateVariableList.get(n);
            if (object == null) continue;
            ((StateVariable)object).getHindcastDataList(vector);
        }
        if (this.getAlternative() != null && this.getAlternative().getWaterAccountSet() != null && (object = this.getAlternative().getWaterAccountSet()) != null) {
            for (n = 0; n < ((WaterAccountSet)object).getWaterAccounts().size(); ++n) {
                if (((WaterAccountSet)object).getWaterAccounts().get(n) == null) continue;
                if (((RssTSLocationObject)((WaterAccountSet)object).getWaterAccounts().get(n)).getSystem() == null) {
                    ((WaterAccountSet)object).getWaterAccounts().get(n).setSystem(this);
                }
                ((WaterAccountSet)object).getWaterAccounts().get(n).updateTSProxyList(true);
                ((WaterAccountSet)object).getWaterAccounts().get(n).getHindcastDataList(vector);
                if (this.h.useYieldAnalysis()) {
                    ((WaterAccountSet)object).getWaterAccounts().get(n).updateTSProxyList(true);
                    continue;
                }
                ((RssTSLocationObject)((WaterAccountSet)object).getWaterAccounts().get(n)).updateTSProxyList();
            }
        }
        return vector;
    }

    public void setConfiguration(Study study, Condition condition) {
        int n;
        Object object;
        Object object2;
        this.o = condition;
        if (this.o == null) {
            this._configurationID = Long.MIN_VALUE;
            return;
        }
        this._configurationID = this.o.getId();
        if (study == null) {
            return;
        }
        Diversion diversion = study.getComputationPointList();
        if (diversion != null) {
            for (int i = 0; i < ((Object[])diversion).length; ++i) {
                condition = (ComputationPoint)diversion[i];
                if (condition == null || !condition.getSnapToStream() || condition.getStreamId() < 0) continue;
                object2 = this.createNode((ComputationPoint)condition);
                object = this.newJunctionElement((ComputationPoint)condition);
                ((JunctionElement)object).setLabelPosition(condition.getLabelPosition());
                ((Element)object).addNode((RssNode)object2, 0);
            }
        }
        object2 = this.o.getProjects(Reservoir.class.getName());
        int n2 = ((Vector)object2).size();
        for (n = 0; n < n2; ++n) {
            object = (Reservoir)((Vector)object2).elementAt(n);
            if (object == null) continue;
            this.createReservoir((Reservoir)object);
        }
        object = this.o.getProjects(Diversion.class.getName());
        n2 = ((Vector)object).size();
        for (n = 0; n < n2; ++n) {
            diversion = (Diversion)((Vector)object).elementAt(n);
            if (diversion == null) continue;
            Reservoir reservoir = null;
            long l = diversion.getReservoirId();
            if (l >= 0L) {
                int n3 = ((Vector)object2).size();
                for (int i = 0; i < n3; ++i) {
                    Reservoir reservoir2 = (Reservoir)((Vector)object2).elementAt(i);
                    if (reservoir2 == null || reservoir2.getId() != diversion.getReservoirId()) continue;
                    reservoir = reservoir2;
                    break;
                }
            }
            this.createDiversion(diversion, reservoir);
        }
        this.setModified(true);
    }

    public Condition getConfiguration() {
        ConditionDataList conditionDataList;
        if (this.o == null && this._configurationID != Long.MIN_VALUE && (conditionDataList = (ConditionDataList)this.getCommonDataList(Condition.class.getName(), "")) != null) {
            this.o = (Condition)conditionDataList.getObject(this._configurationID);
        }
        return this.o;
    }

    public long getConfigurationId() {
        return this._configurationID;
    }

    public void setConfigurationForImport(Condition condition) {
        this.o = condition;
        this._configurationID = condition.getId();
    }

    public void updateConfiguration() {
        Object object;
        Object object2;
        int n;
        Object object3 = this.getConfiguration();
        if (object3 == null) {
            return;
        }
        ComputationPointDataList computationPointDataList = (ComputationPointDataList)this.getCommonDataList(ComputationPoint.class.getName(), "");
        Object object4 = computationPointDataList.getObjectArray();
        Hashtable<Long, ComputationPoint> hashtable = new Hashtable<Long, ComputationPoint>();
        for (n = 0; n < ((DataStruct[])object4).length; ++n) {
            object2 = (ComputationPoint)object4[n];
            if (object2 == null) continue;
            hashtable.put(new Long(object2.getId()), (ComputationPoint)object2);
        }
        object4 = object3.getProjects(Reservoir.class.getName());
        Hashtable<Long, Object> hashtable2 = new Hashtable<Long, Object>();
        for (n = 0; n < ((Vector)object4).size(); ++n) {
            object2 = (Reservoir)((Vector)object4).elementAt(n);
            if (object2 == null) continue;
            hashtable2.put(new Long(object2.getId()), object2);
        }
        object2 = object3.getProjects(Diversion.class.getName());
        object3 = new Hashtable();
        for (n = 0; n < ((Vector)object2).size(); ++n) {
            Diversion diversion = (Diversion)((Vector)object2).elementAt(n);
            if (diversion == null) continue;
            ((Hashtable)object3).put(new Long(diversion.getId()), diversion);
        }
        int n2 = this._elementVector.size();
        for (n = 0; n < n2; ++n) {
            DivertedOutletElement divertedOutletElement;
            Serializable serializable;
            long l;
            Object object5 = (Element)this._elementVector.elementAt(n);
            if (object5 instanceof JunctionElement) {
                Object object6;
                object = (JunctionElement)object5;
                l = ((JunctionElement)object).getComputationPointId();
                if (l == Long.MIN_VALUE) continue;
                serializable = new Long(l);
                object5 = (ComputationPoint)hashtable.remove(serializable);
                if (object5 == null) {
                    object6 = hashtable.elements();
                    while (object6.hasMoreElements()) {
                        object5 = (ComputationPoint)object6.nextElement();
                        if (object5 == null) continue;
                        if (object5.getName().equals(object.getName())) {
                            hashtable.remove(new Long(object5.getId()));
                            break;
                        }
                        object5 = null;
                    }
                }
                ((JunctionElement)object).setComputationPoint((ComputationPoint)object5);
                if (object5 == null) continue;
                object.setDescription(object5.getDescription());
                ((JunctionElement)object).setLabelPosition(object5.getLabelPosition());
                if (((Element)object).getDownstreamNode() == null) {
                    object6 = this.createNode((ComputationPoint)object5);
                    ((Element)object).addNode((RssNode)object6, 0);
                }
                if ((object6 = this.getAlignment().getReach(object5.getStreamId())) == null) continue;
                ((JunctionElement)object).setStreamStation((StreamElement)object6, object5.getStreamStation());
                continue;
            }
            if (object5 instanceof ReservoirElement) {
                object = (ReservoirElement)object5;
                l = ((ReservoirElement)object).getReservoirProjectId();
                if (l != Long.MIN_VALUE) {
                    serializable = new Long(l);
                    Reservoir reservoir = (Reservoir)hashtable2.remove(serializable);
                    if (reservoir == null) {
                        object5 = hashtable2.elements();
                        while (object5.hasMoreElements()) {
                            reservoir = (Reservoir)object5.nextElement();
                            if (reservoir == null) continue;
                            if (reservoir.getName().equals(object.getName())) {
                                hashtable2.remove(new Long(reservoir.getId()));
                                ((ReservoirElement)object).setReservoirProjectId(reservoir.getId());
                                break;
                            }
                            reservoir = null;
                        }
                    }
                    if (reservoir == null) {
                        ((ReservoirElement)object).setReservoirProjectId(Long.MIN_VALUE);
                    } else {
                        ((Element)object).setName(reservoir.getName());
                        ((ReservoirElement)object).setLabelPosition(reservoir.getLabelPosition());
                        object.setDescription(reservoir.getDescription());
                        ((ReservoirElement)object).setRegion((WorldRegion)reservoir.getRegion().clone());
                        ((ReservoirElement)object).setReferencePt(reservoir.getReferencePt());
                        ((ReservoirElement)object).updateSegments();
                    }
                }
                serializable = ((ReservoirElement)object).getDivertedOutlets();
                int n3 = ((Vector)serializable).size();
                for (int i = 0; i < n3; ++i) {
                    ComputationPoint computationPoint;
                    divertedOutletElement = (DivertedOutletElement)((Vector)serializable).elementAt(i);
                    long l2 = divertedOutletElement.getDiversionProjectId();
                    if (l == Long.MIN_VALUE) continue;
                    object = new Long(l2);
                    if ((object = (Diversion)((Hashtable)object3).remove(object)) == null) {
                        computationPoint = ((Hashtable)object3).elements();
                        while (computationPoint.hasMoreElements()) {
                            object = (Diversion)computationPoint.nextElement();
                            if (object == null) continue;
                            if (object.getName().equals(divertedOutletElement.getName())) {
                                ((Hashtable)object3).remove(new Long(object.getId()));
                                divertedOutletElement.setDiversionProjectId(object.getId());
                                break;
                            }
                            object = null;
                        }
                    }
                    if (object == null) {
                        divertedOutletElement.setDiversionProjectId(Long.MIN_VALUE);
                        continue;
                    }
                    divertedOutletElement.setName(object.getName());
                    divertedOutletElement.setDescription(object.getDescription());
                    computationPoint = object.getComputationPoint(false);
                    RssNode rssNode = ((Element)divertedOutletElement).getDownstreamNode();
                    if (computationPoint == null) {
                        if (rssNode != null) {
                            divertedOutletElement.disconnectDownstream(0.0, 0.0);
                        }
                    } else {
                        Element element;
                        if (!(rssNode == null || (element = rssNode.getDownstreamElement()) instanceof JunctionElement && computationPoint.getId() == ((JunctionElement)element).getComputationPointId())) {
                            divertedOutletElement.disconnectDownstream(0.0, 0.0);
                            rssNode = null;
                        }
                        if (rssNode == null && (element = this.findJunction(computationPoint)) != null) {
                            rssNode = this.createNode(computationPoint);
                            ((Element)divertedOutletElement).addNode(rssNode, 0);
                            element.addNode(rssNode, 1);
                        }
                    }
                    divertedOutletElement.setLine((WorldLine)object.getLine().clone());
                }
                continue;
            }
            if (!(object5 instanceof DiversionElement) || (l = ((DiversionElement)(object = (DiversionElement)object5)).getDiversionProjectId()) == Long.MIN_VALUE) continue;
            serializable = new Long(l);
            Diversion diversion = (Diversion)((Hashtable)object3).remove(serializable);
            if (diversion == null) {
                object5 = ((Hashtable)object3).elements();
                while (object5.hasMoreElements()) {
                    diversion = (Diversion)object5.nextElement();
                    if (diversion == null) continue;
                    if (diversion.getName().equals(object.getName())) {
                        ((Hashtable)object3).remove(new Long(diversion.getId()));
                        ((DiversionElement)object).setDiversionProjectId(diversion.getId());
                        break;
                    }
                    diversion = null;
                }
            }
            if (diversion == null) {
                ((DiversionElement)object).setDiversionProjectId(Long.MIN_VALUE);
                continue;
            }
            ((Element)object).setName(diversion.getName());
            object.setDescription(diversion.getDescription());
            divertedOutletElement = diversion.getComputationPoint(false);
            RssNode rssNode = ((Element)object).getDownstreamNode();
            if (divertedOutletElement == null) {
                if (rssNode != null) {
                    ((DiversionElement)object).disconnectDownstream(0.0, 0.0);
                }
            } else {
                Element element;
                if (!(rssNode == null || (element = rssNode.getDownstreamElement()) instanceof JunctionElement && divertedOutletElement.getId() == ((JunctionElement)element).getComputationPointId())) {
                    ((DiversionElement)object).disconnectDownstream(0.0, 0.0);
                    rssNode = null;
                }
                if (rssNode == null && (element = this.findJunction((ComputationPoint)divertedOutletElement)) != null) {
                    rssNode = this.createNode((ComputationPoint)divertedOutletElement);
                    ((Element)object).addNode(rssNode, 0);
                    element.addNode(rssNode, 1);
                }
            }
            ((DiversionElement)object).setLine((WorldLine)diversion.getLine().clone());
        }
        object = hashtable.elements();
        while (object.hasMoreElements()) {
            Object object7 = (ComputationPoint)object.nextElement();
            if (object7 == null || !object7.getSnapToStream() || object7.getStreamId() < 0) continue;
            RssNode rssNode = this.createNode((ComputationPoint)object7);
            object7 = this.newJunctionElement((ComputationPoint)object7);
            object7.addNode(rssNode, 0);
        }
        object = hashtable2.elements();
        while (object.hasMoreElements()) {
            Reservoir reservoir = (Reservoir)object.nextElement();
            if (reservoir == null) continue;
            this.createReservoir(reservoir);
        }
        object = ((Hashtable)object3).elements();
        while (object.hasMoreElements()) {
            Diversion diversion = (Diversion)object.nextElement();
            if (diversion == null) continue;
            Reservoir reservoir = null;
            long l = diversion.getReservoirId();
            if (l >= 0L) {
                ((Vector)object4).size();
                for (int i = 0; i < ((Vector)object4).size(); ++i) {
                    Reservoir reservoir2 = (Reservoir)((Vector)object4).elementAt(i);
                    if (reservoir2 == null || reservoir2.getId() != diversion.getReservoirId()) continue;
                    reservoir = reservoir2;
                    break;
                }
            }
            this.createDiversion(diversion, reservoir);
        }
        this.cleanVectors();
        this.setModified(true);
        System.out.println("\n\nFinished updating configuration\n\n");
    }

    public boolean modifiyForSaveAs() {
        this._inputTSDataNameVector.clear();
        this.j = null;
        this.k = null;
        this.setModified(true);
        return true;
    }

    @Deprecated
    public void addInputTSData(String string) {
        if (string == null || this._inputTSDataNameVector.contains(string)) {
            return;
        }
        this._inputTSDataNameVector.addElement(string);
        this.setModified(true);
    }

    @Deprecated
    public Vector getInputTSDataList() {
        return (Vector)this._inputTSDataNameVector.clone();
    }

    @Deprecated
    public void deleteInputTSData(String string) {
        if (string == null) {
            return;
        }
        this._inputTSDataNameVector.removeElement(string);
        this.setModified(true);
    }

    @Deprecated
    public void renameInputTSData(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        this._inputTSDataNameVector.removeElement(string);
        this._inputTSDataNameVector.addElement(string2);
        this.setModified(true);
    }

    public void setRssRun(RssRun rssRun) {
        this.g = rssRun;
    }

    @Scriptable
    public RssRun getRssRun() {
        return this.g;
    }

    @Scriptable
    public WQRun getWQRun() {
        if (this.g != null) {
            return this.g.getWQRun();
        }
        return null;
    }

    public void setAlternative(RssAlt rssAlt) {
        this.h = rssAlt;
    }

    @Scriptable
    public RssAlt getAlternative() {
        return this.h;
    }

    public WaterAccountSet getWaterAccountSet(String string) {
        for (int i = 0; i < this._waterAccountSetList.size(); ++i) {
            WaterAccountSet waterAccountSet = this._waterAccountSetList.get(i);
            if (waterAccountSet.getName() == null || !waterAccountSet.getName().equals(string)) continue;
            return waterAccountSet;
        }
        return null;
    }

    public void renameWaterAccountSet(String object, String string) {
        if ((object = this.getWaterAccountSet((String)object)) != null) {
            ((WaterAccountSet)object).setName(string);
        }
    }

    public void deleteWaterAccountSet(WaterAccountSet waterAccountSet) {
        this._waterAccountSetList.remove(waterAccountSet);
        this.setModified(true);
    }

    public ReservoirSysOp[] getReservoirSysOps() {
        DbfFile dbfFile;
        if (this.F == null) {
            this.F = new Vector();
            dbfFile = this.getResSysOpDbfFile();
            if (dbfFile == null) {
                this.printMessage("getResevoirSysOps: Failed to get ResSysOp Dbf File");
                return new ReservoirSysOp[0];
            }
            AsciiSerializableDbfHeader asciiSerializableDbfHeader = new AsciiSerializableDbfHeader();
            asciiSerializableDbfHeader = asciiSerializableDbfHeader.buildDbfRecordIdQuery();
            if ((asciiSerializableDbfHeader = dbfFile.queryRecords((DbfRecordQuery)asciiSerializableDbfHeader)) != null) {
                for (int i = 0; i < asciiSerializableDbfHeader.size(); ++i) {
                    Object object = asciiSerializableDbfHeader.get(i);
                    Serializable serializable = object.getData();
                    if (serializable == null) continue;
                    if (((Vector)serializable).size() < 4) {
                        this.printErrorMessage("getResevoirSysOps: failed to get enough data back from DbfRecord.");
                        this.printErrorMessage("getResevoirSysOps: expected at least 4 got " + ((Vector)serializable).size());
                        object.printData();
                        continue;
                    }
                    object = ((Vector)serializable).get(3);
                    if (!(object instanceof String)) {
                        this.printErrorMessage("getResevoirSysOps: expected a String in the 4th position got a " + String.valueOf(object));
                        continue;
                    }
                    serializable = new ReservoirSysOp();
                    boolean bl = this.deserializeString((AsciiSerializable)serializable, (String)object);
                    if (!bl) continue;
                    ((ReservoirSysOp)serializable).setRssSystem(this);
                    this.F.add(serializable);
                }
            } else {
                this.printMessage("getReservoirSysOps: Record set returned is null!");
            }
            try {
                dbfFile.close();
            }
            catch (IOException iOException) {
                this.printMessage("closeDbfFile: Error closing DBFfile  " + dbfFile.getPath() + " Error:" + String.valueOf(iOException));
                iOException.printStackTrace();
            }
        }
        dbfFile = new ReservoirSysOp[this.F.size()];
        this.F.copyInto((Object[])dbfFile);
        return dbfFile;
    }

    public Vector getUpstreamElements(Element tSLocation) {
        Vector<TSLocation> vector = new Vector<TSLocation>();
        List<RssNode> list = tSLocation.getUpstreamNodes(null);
        List<RssNode> list2 = new ArrayList<RssNode>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            tSLocation = list.get(i);
            while (tSLocation != null && (tSLocation = tSLocation.getUpstreamElement()) != null) {
                if (tSLocation.getFunction() instanceof Storage) {
                    Element element = tSLocation.getParent();
                    if (element == null) {
                        this.printMessage("Connectivity error in storage element " + tSLocation.getName());
                        this.printMessage("No Parent Reservoir Element");
                        return null;
                    }
                    tSLocation = element;
                }
                if (!vector.contains(tSLocation)) {
                    vector.add(tSLocation);
                }
                list2.clear();
                list2 = tSLocation.getUpstreamNodes(list2);
                if (list2.size() > 0) {
                    tSLocation = list2.get(0);
                    for (int j = 1; j < list2.size(); ++j) {
                        list.add(list2.get(j));
                        ++n;
                    }
                    continue;
                }
                tSLocation = null;
            }
        }
        return vector;
    }

    public Vector getDownstreamElements(Element element) {
        return this.getDownstreamElements(element, true);
    }

    public Vector getDownstreamElements(Element tSLocation, boolean bl) {
        int n;
        Vector<TSLocation> vector = new Vector<TSLocation>();
        List list = tSLocation.getDownstreamNodes(null);
        List list2 = new ArrayList();
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            tSLocation = (RssNode)list.get(n);
            while (tSLocation != null && (tSLocation = tSLocation.getDownstreamElement()) != null) {
                if (tSLocation.getFunction() instanceof Storage) {
                    Element element = tSLocation.getParent();
                    if (element == null) {
                        this.printMessage("Connectivity error in storage element " + tSLocation.getName());
                        this.printMessage("No Parent Reservoir Element");
                        return null;
                    }
                    tSLocation = element;
                }
                if (!vector.contains(tSLocation)) {
                    vector.add(tSLocation);
                }
                list2.clear();
                list2 = tSLocation.getDownstreamNodes(list2);
                if (list2.size() > 0) {
                    tSLocation = (RssNode)list2.get(0);
                    for (int i = 1; i < list2.size(); ++i) {
                        list.add(list2.get(i));
                        ++n2;
                    }
                    continue;
                }
                tSLocation = null;
            }
        }
        if (this.r != null && this.r.length >= n2 - 1 && bl) {
            Vector<TSLocation> vector2 = new Vector<TSLocation>();
            n2 = this.r.length;
            for (n = 0; n < n2; ++n) {
                if (this.r[n] < 0) {
                    this.printErrorMessage("RssSystem.getDownstreamElements: negative number in element order at " + n + " in array size " + this.r.length);
                }
                if (!vector.contains(tSLocation = (Element)this.s.elementAt(this.r[n]))) continue;
                vector2.add(tSLocation);
            }
            vector = vector2;
        }
        return vector;
    }

    public boolean getDownstreamNodeList(Element element, List<RssNode> list) {
        return this.getDownstreamNodeList(element, list, rssNode -> true);
    }

    public boolean getDownstreamNodeList(Element tSLocation, List<RssNode> list, Predicate<RssNode> predicate) {
        if (tSLocation == null || list == null) {
            return false;
        }
        predicate = predicate != null ? predicate : rssNode -> true;
        ArrayList arrayList = new ArrayList();
        tSLocation.getDownstreamNodes(arrayList);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            tSLocation = (RssNode)arrayList.get(i);
            if (list.contains(tSLocation)) continue;
            if (predicate.test((RssNode)tSLocation)) {
                list.add((RssNode)tSLocation);
            }
            if ((tSLocation = tSLocation.getDownstreamElement()) == null || (bl = this.getDownstreamNodeList((Element)(tSLocation = tSLocation.getTopParent()), list, predicate))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public CommonDataList getReservoirOpDataList() {
        if (this.w == null) {
            this.w = this.getCommonDataList(ReservoirOp.class.getName(), "rss");
        }
        return this.w;
    }

    @Deprecated
    public CommonDataList getReservoirSysOpDataList() {
        if (this.x == null) {
            this.x = this.getCommonDataList(ReservoirSysOp.class.getName(), "rss");
        }
        return this.x;
    }

    public void renameReservoirSysOp(String object, String string) {
        if ((object = this.getReservoirSysOp((String)object)) == null) {
            return;
        }
        object.setName(this.createReservoirSysOpName(string));
        ((ReservoirSysOp)object).setUserName(string);
    }

    public ReservoirSysOp getReservoirSysOp(String string) {
        ReservoirSysOp[] reservoirSysOpArray = this.getReservoirSysOps();
        if (reservoirSysOpArray == null || reservoirSysOpArray.length == 0) {
            return null;
        }
        for (int i = 0; i < reservoirSysOpArray.length; ++i) {
            String string2 = reservoirSysOpArray[i].getName();
            String string3 = this.createReservoirSysOpName(string);
            if (!string2.equals(string) && !string2.equals(string3)) continue;
            return reservoirSysOpArray[i];
        }
        return null;
    }

    public String createReservoirSysOpName(String string) {
        String string2 = this.getName() + "_";
        if (string.indexOf(string2) == 0) {
            return string;
        }
        return string2 + string;
    }

    public void loadReservoirSysOps(boolean bl) {
        if (this.F == null || bl) {
            this.getReservoirSysOps();
        }
    }

    public ReservoirSysOp createNewReservoirSysOp(String string, String string2) {
        if (string == null || string == "") {
            return null;
        }
        if (string2 == null) {
            return null;
        }
        this.loadReservoirSysOps(false);
        ReservoirSysOp reservoirSysOp = new ReservoirSysOp();
        reservoirSysOp.setUserName(string);
        reservoirSysOp.setName(this.createReservoirSysOpName(string));
        reservoirSysOp.setDescription(string2);
        reservoirSysOp.setIndex(this.getNextResSysOpId());
        reservoirSysOp.setRssSystem(this);
        ReservoirSysOp reservoirSysOp2 = reservoirSysOp;
        if (this.saveReservoirSysOp(reservoirSysOp2, reservoirSysOp2.getIndex()) != -1) {
            this.F.add(reservoirSysOp);
            return reservoirSysOp;
        }
        return null;
    }

    public void addReservoirSysOp(ReservoirSysOp reservoirSysOp) {
        ReservoirSysOp reservoirSysOp2 = reservoirSysOp;
        if (this.saveReservoirSysOp(reservoirSysOp2, reservoirSysOp2.getIndex()) != -1) {
            this.F.add(reservoirSysOp);
        }
    }

    public void deleteReservoirSysOp(ReservoirSysOp reservoirSysOp) {
        if (reservoirSysOp == null) {
            return;
        }
        reservoirSysOp.clearReservoirs();
        this.E.add(reservoirSysOp.getIndex());
        if (this.F != null && !this.F.remove(reservoirSysOp)) {
            System.out.println("deleteReservoirSysOp: failed to remove " + reservoirSysOp.getName());
        }
    }

    protected void deleteReservoirOps(IntVector intVector) {
        if (intVector == null || intVector.size() == 0) {
            return;
        }
        DbfFile dbfFile = this.getResOpDbfFile();
        this.deleteOps(intVector, dbfFile);
        try {
            dbfFile.close();
            return;
        }
        catch (IOException iOException) {
            this.printMessage("closeDbfFile: Error closing DBFfile  " + dbfFile.getPath() + " Error:" + String.valueOf(iOException));
            iOException.printStackTrace();
            return;
        }
    }

    protected void deleteReservoirSysOps(IntVector intVector) {
        if (intVector == null || intVector.size() == 0) {
            return;
        }
        DbfFile dbfFile = this.getResSysOpDbfFile();
        this.deleteOps(intVector, dbfFile);
        try {
            dbfFile.close();
            return;
        }
        catch (IOException iOException) {
            this.printMessage("closeDbfFile: Error closing DBFfile  " + dbfFile.getPath() + " Error:" + String.valueOf(iOException));
            iOException.printStackTrace();
            return;
        }
    }

    private void deleteOps(IntVector intVector, DbfFile dbfFile) {
        Serializable[] serializableArray = new Integer[intVector.size()];
        intVector.copyInto((Integer[])serializableArray);
        AsciiSerializableDbfHeader asciiSerializableDbfHeader = new AsciiSerializableDbfHeader();
        serializableArray = asciiSerializableDbfHeader.buildDbfRecordIdQuery(serializableArray);
        int n = Logger.canDebug((String)"ResSimOperations");
        if (dbfFile != null) {
            if (n != 0) {
                this.printMessage("deleteOps: ids=" + intVector.toString() + " from " + dbfFile.getPath());
            }
            if ((serializableArray = dbfFile.deleteRecords((DbfRecordIndexSet)serializableArray)) != null) {
                if (n != 0) {
                    this.printMessage("Resultset=" + String.valueOf(serializableArray.getError(0)));
                }
                serializableArray = serializableArray.getIndexTagKeys();
                for (n = 0; n < serializableArray.length; ++n) {
                    intVector.remove(((Number)serializableArray[n]).intValue());
                }
            }
        }
        try {
            dbfFile.close();
            return;
        }
        catch (IOException iOException) {
            this.printMessage("closeDbfFile: Error closing DBFfile  " + dbfFile.getPath() + " Error:" + String.valueOf(iOException));
            iOException.printStackTrace();
            return;
        }
    }

    public boolean prepRegulatedFlowCompute() {
        int n = this._nodeVector.size();
        for (int i = 0; i < n; ++i) {
            RssNode rssNode = (RssNode)this._nodeVector.elementAt(i);
            if (rssNode == null) continue;
            rssNode.setActive(true);
        }
        n = this._elementVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)this._elementVector.elementAt(i);
            if (element == null) continue;
            element.setActive(true);
            if (element instanceof ReservoirElement) {
                ((ReservoirElement)element).prepRegulatedFlowCompute();
                continue;
            }
            if (!(element instanceof DiversionElement)) continue;
            element.setActive(true, true);
        }
        return true;
    }

    public boolean prepCumLocFlowCompute() {
        this.prepRegulatedFlowCompute();
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Element element = (Element)this._elementVector.elementAt(i);
            if (element == null) continue;
            if (element instanceof ReservoirElement) {
                ((ReservoirElement)element).prepCumLocFlowCompute();
                continue;
            }
            if (!(element instanceof DiversionElement)) continue;
            element.setActive(false, true);
        }
        return true;
    }

    public boolean prepUnregulatedFlowCompute() {
        this.prepRegulatedFlowCompute();
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Element element = (Element)this._elementVector.elementAt(i);
            if (element == null) continue;
            if (element instanceof ReservoirElement) {
                ((ReservoirElement)element).prepUnregulatedFlowCompute(true);
                continue;
            }
            if (!(element instanceof DiversionElement) || ((DiversionElement)element).getComputeDuringUnReg()) continue;
            element.setActive(false, true);
        }
        return true;
    }

    public boolean prepHoldoutCompute(String object) {
        TSLocation tSLocation;
        if ((object = this.findReservoir((String)object)) == null) {
            return false;
        }
        int n = this._nodeVector.size();
        for (int i = 0; i < n; ++i) {
            RssNode rssNode = (RssNode)this._nodeVector.elementAt(i);
            if (rssNode == null) continue;
            rssNode.setActive(false);
        }
        n = this._elementVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)this._elementVector.elementAt(i);
            if (element == null) continue;
            element.setActive(false);
        }
        RssReturnStatusConstants rssReturnStatusConstants = ((Element)object).getDownstreamNode();
        while (rssReturnStatusConstants != null && (tSLocation = rssReturnStatusConstants.getDownstreamElement()) != null) {
            if (tSLocation.getFunction() instanceof Storage) {
                rssReturnStatusConstants = tSLocation.getParent();
                if (rssReturnStatusConstants == null) {
                    this.printMessage("Connectivity error in storage element " + tSLocation.getName());
                    this.printMessage("No Parent Reservoir Element");
                    return false;
                }
                ((ReservoirElement)rssReturnStatusConstants).prepUnregulatedFlowCompute(true);
                tSLocation = rssReturnStatusConstants;
            }
            tSLocation.setActive(true);
            rssReturnStatusConstants = tSLocation.getDownstreamNode();
        }
        ((ReservoirElement)object).prepHoldoutCompute();
        return true;
    }

    public boolean prepPulseRoutingCompute(ReservoirElement reservoirElement, int n, int n2) {
        int n3;
        if (reservoirElement == null) {
            return false;
        }
        if (n2 < 0 || n2 >= reservoirElement.getChildElementCount()) {
            return false;
        }
        if (reservoirElement.getChildElementAt(n2).getDownstreamNode() == null) {
            return false;
        }
        this.printMessage("\tPrep Pulse Routing for Outlet " + reservoirElement.getChildElementAt(n2).getName());
        this.prepRegulatedFlowCompute();
        boolean bl = this.orderElementsForCompute(3);
        n = bl ? 1 : 0;
        if (!bl) {
            return false;
        }
        int n4 = this._nodeVector.size();
        for (n3 = 0; n3 < n4; ++n3) {
            RssNode rssNode = (RssNode)this._nodeVector.elementAt(n3);
            if (rssNode == null) continue;
            rssNode.setActive(false);
        }
        n4 = this._elementVector.size();
        for (n3 = 0; n3 < n4; ++n3) {
            Element element = (Element)this._elementVector.elementAt(n3);
            if (element == null) continue;
            element.setActive(false);
        }
        Element element = reservoirElement.getChildElementAt(n2);
        if (element == null) {
            return false;
        }
        Vector vector = this.getDownstreamElements(element);
        n4 = vector.size();
        for (n3 = 0; n3 < n4; ++n3) {
            element = (Element)vector.get(n3);
            if (element instanceof ReservoirElement) {
                ((ReservoirElement)element).prepUnregulatedFlowCompute(false);
                continue;
            }
            element.setActive(true);
        }
        reservoirElement.prepPulseRoutingCompute(n2);
        return true;
    }

    public void init() {
    }

    public void clearStreamAlignment() {
        this.n = null;
    }

    public StreamAlignment getAlignment() {
        if (this.n == null) {
            this.n = (StreamAlignment)this._proxyList.openManager("main", "stream.align");
        }
        return this.n;
    }

    public int getElementCount() {
        return this._elementVector.size();
    }

    public int getElementCount(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            System.out.println("getElementCount: Error getting class " + string + " Error:" + exception.toString());
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Object e = this._elementVector.elementAt(i);
            if (!clazz.isInstance(e)) continue;
            ++n;
        }
        return n;
    }

    public int getElementCountByFunction(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            System.out.println("getElementCountByFunction: Error getting class " + string + " Error:" + exception.toString());
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Element element = (Element)this._elementVector.elementAt(i);
            if (!clazz.isInstance(element.getFunction())) continue;
            ++n;
        }
        return n;
    }

    public Vector getElementNameVector(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            System.out.println("getElementNameVector: Error getting class " + string + " Error:" + exception.toString());
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Object e = this._elementVector.elementAt(i);
            if (!clazz.isInstance(e)) continue;
            vector.addElement(((Element)e).getName());
        }
        return vector;
    }

    public Vector getElementNameVectorByFunction(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            System.out.println("getElementNameVectorByFunction: error getting class " + string + " Error:" + exception.toString());
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Element element = (Element)this._elementVector.elementAt(i);
            if (!clazz.isInstance(element.getFunction())) continue;
            vector.addElement(element.getName());
        }
        return vector;
    }

    public Element newElement(boolean bl) {
        RssSystem rssSystem = this;
        Element element = new Element(rssSystem, rssSystem.nextElementIndex());
        if (bl) {
            this._elementVector.addElement(element);
        }
        Element element2 = element;
        element2.setName("Elem " + element2.getIndex());
        return element;
    }

    public ReachElement newReachElement() {
        String string = this.getNextDefaultName(0);
        return this.newReachElement(string);
    }

    public ReachElement newReachElement(String string) {
        RssSystem rssSystem = this;
        ReachElement reachElement = new ReachElement(rssSystem, rssSystem.nextElementIndex());
        reachElement.setName(string);
        reachElement.putFunction(TimeStepUtil.TIME_STEP_ALL.getDuration(), new NullRouting());
        this._elementVector.addElement(reachElement);
        return reachElement;
    }

    public TimeStepRoutingElement newTimeStepRoutingElement(boolean bl) {
        RssSystem rssSystem = this;
        TimeStepRoutingElement timeStepRoutingElement = new TimeStepRoutingElement(rssSystem, rssSystem.nextElementIndex());
        if (bl) {
            this._elementVector.addElement(timeStepRoutingElement);
        }
        timeStepRoutingElement.putFunction(TimeStepUtil.TIME_STEP_ALL.getDuration(), new NullRouting());
        TimeStepRoutingElement timeStepRoutingElement2 = timeStepRoutingElement;
        timeStepRoutingElement2.setName("SimpleTimeStepRoutingElement " + timeStepRoutingElement2.getIndex());
        return timeStepRoutingElement;
    }

    public DiversionElement newDiversionElement() {
        String string = this.getNextDefaultName(3);
        return this.newDiversionElement(string);
    }

    public DiversionElement newDiversionElement(String string) {
        RssSystem rssSystem = this;
        DiversionElement diversionElement = new DiversionElement(rssSystem, rssSystem.nextElementIndex());
        diversionElement.setName(string);
        this._elementVector.addElement(diversionElement);
        diversionElement.createDefaultElements(this);
        this.setModified(true);
        return diversionElement;
    }

    public GlobalVariable newGlobalVariable(String string, GlobalVariableType globalVariableType) {
        GlobalVariable globalVariable = null;
        switch (globalVariableType) {
            case SCALAR: {
                globalVariable = new ScalarGlobalVariable(this);
                break;
            }
            case STRING: {
                globalVariable = new StringGlobalVariable(this);
                break;
            }
            case TABLE: {
                globalVariable = new TableGlobalVariable(this);
                break;
            }
            case TIME_SERIES: {
                globalVariable = new TimeSeriesGlobalVariable(this);
                break;
            }
            case EXTERNAL: {
                globalVariable = new ExternalGlobalVariable(this);
            }
        }
        if (globalVariable != null) {
            globalVariable.setName(string);
            globalVariable.setIndex(this.nextStateVariableIndex());
            this._globalVariableList.add(globalVariable);
            this.setModified(true);
        }
        return globalVariable;
    }

    public GlobalVariable newGlobalVariable(String string, GlobalVariable globalVariable) {
        globalVariable.setName(string);
        globalVariable.setIndex(this.nextStateVariableIndex());
        this._globalVariableList.add(globalVariable);
        this.setModified(true);
        return globalVariable;
    }

    @Scriptable
    public void printGlobalScalarsToComputeLog(int n) {
        for (ScalarGlobalVariable scalarGlobalVariable : this.findGlobalScalars()) {
            Object object = scalarGlobalVariable.getValue();
            if (object == null) {
                object = "";
            }
            if (n == 1) {
                scalarGlobalVariable.printToComputeLog();
                continue;
            }
            if (n != 2) continue;
            Object object2 = scalarGlobalVariable.getMinLimitAsString();
            Object object3 = scalarGlobalVariable.getMaxLimitAsString();
            object2 = object2 == null ? "" : ",Min: " + (String)object2;
            object3 = object3 == null ? "" : ",Max: " + (String)object3;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((Object)scalarGlobalVariable.getType());
            stringBuilder.append(" Global Scalar: ");
            stringBuilder.append(scalarGlobalVariable._name);
            stringBuilder.append(", Value: ");
            stringBuilder.append(object.toString());
            stringBuilder.append(",Data Type: ");
            stringBuilder.append((Object)scalarGlobalVariable.getDataType());
            stringBuilder.append(", Description: ");
            stringBuilder.append(scalarGlobalVariable.getDescription());
            stringBuilder.append(", Usage Type: ");
            stringBuilder.append(scalarGlobalVariable.getUsageType());
            stringBuilder.append((String)object2);
            stringBuilder.append((String)object3);
            this.printLogMessage(stringBuilder.toString());
        }
    }

    @Scriptable
    public void printGlobalStringsToComputeLog(int n) {
        for (StringGlobalVariable stringGlobalVariable : this.findGlobalStrings()) {
            String string = stringGlobalVariable.getValue();
            if (n == 1) {
                stringGlobalVariable.printToComputeLog();
                continue;
            }
            if (n != 2) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((Object)stringGlobalVariable.getType());
            stringBuilder.append(" Global Variable: ");
            stringBuilder.append(stringGlobalVariable._name);
            stringBuilder.append(", Value: ");
            stringBuilder.append(string);
            stringBuilder.append(",Selection: ");
            stringBuilder.append(stringGlobalVariable.isSelection());
            stringBuilder.append(", Description: ");
            stringBuilder.append(stringGlobalVariable.getDescription());
            stringBuilder.append(", Usage Type: ");
            stringBuilder.append(stringGlobalVariable.getUsageType());
            if (stringGlobalVariable.isFreeform()) {
                List<Character> list;
                stringBuilder.append(",CharType: ");
                stringBuilder.append((Object)stringGlobalVariable.getCharacterSetType());
                if (stringGlobalVariable.getCharacterSetType() == CharacterSetType.ASCII && !(list = stringGlobalVariable.getInvalidCharacters()).isEmpty()) {
                    stringBuilder.append(", InvalidChars: ");
                    stringBuilder.append(list);
                }
            }
            this.printLogMessage(stringBuilder.toString());
        }
    }

    @Scriptable
    public void printGlobalTablesToComputeLog(int n) {
        for (TableGlobalVariable tableGlobalVariable : this.findGlobalTables()) {
            if (n == 1) {
                this.printLogMessage("Global Table: " + tableGlobalVariable._name);
                continue;
            }
            if (n != 2) continue;
            String string = "Global Table: " + tableGlobalVariable._name + ",Table Type: " + String.valueOf((Object)tableGlobalVariable.getTableType()) + ",Description: " + tableGlobalVariable.getDescription() + ",Usage Type: " + tableGlobalVariable.getUsageType();
            this.printLogMessage(string);
        }
    }

    @Scriptable
    public void printGlobalTimeSeriesToComputeLog(int n) {
        for (TimeSeriesGlobalVariable timeSeriesGlobalVariable : this.findGlobalTimeSeries()) {
            if (n == 1) {
                this.printLogMessage("Global Time Series: " + timeSeriesGlobalVariable._name);
                continue;
            }
            if (n != 2) continue;
            String string = "Global Time Series: " + timeSeriesGlobalVariable._name + ", Description: " + timeSeriesGlobalVariable.getDescription() + ", Usage Type: " + timeSeriesGlobalVariable.getUsageType();
            this.printLogMessage(string);
        }
    }

    public void updateGlobalVariable(int n, GlobalVariable globalVariable) {
        GlobalVariable globalVariable2 = this.getGlobalVariable(n);
        int n2 = this._globalVariableList.indexOf(globalVariable2);
        if (n2 < 0 || n2 >= this._globalVariableList.size()) {
            return;
        }
        this._globalVariableList.set(n2, globalVariable);
    }

    public StateVariable newStateVariable(String string) {
        RssSystem rssSystem = this;
        StateVariable stateVariable = new StateVariable(rssSystem, rssSystem.nextStateVariableIndex());
        stateVariable.setName(string);
        this._stateVariableList.add(stateVariable);
        this.setModified(true);
        return stateVariable;
    }

    public StateVariable newStateVariable(String string, StateVariable stateVariable) {
        stateVariable.setIndex(this.nextStateVariableIndex());
        stateVariable.setSystem(this);
        stateVariable.setName(string);
        this._stateVariableList.add(stateVariable);
        this.setModified(true);
        return stateVariable;
    }

    public WaterAccount getWaterAccount(int n) {
        if (this.getAlternative().getWaterAccountSet() == null || this.getAlternative().getWaterAccountSet().getWaterAccounts() == null || this.getAlternative().getWaterAccountSet().getWaterAccounts().size() == 0) {
            return null;
        }
        int n2 = this.getAlternative().getWaterAccountSet().getWaterAccounts().size();
        for (int i = 0; i < n2; ++i) {
            WaterAccount waterAccount;
            if (this.getAlternative().getWaterAccountSet().getWaterAccounts().get(i) == null || (waterAccount = this.getAlternative().getWaterAccountSet().getWaterAccounts().get(i)).getIndex() != n) continue;
            return waterAccount;
        }
        return null;
    }

    public GlobalVariable getGlobalVariable(int n) {
        int n2 = this._globalVariableList.size();
        for (int i = 0; i < n2; ++i) {
            GlobalVariable globalVariable = this._globalVariableList.get(i);
            if (globalVariable == null || globalVariable.getIndex() != n) continue;
            return globalVariable;
        }
        return null;
    }

    @Scriptable
    public GlobalVariable getGlobalVariable(String string) {
        if (string == null) {
            return null;
        }
        int n = this._globalVariableList.size();
        for (int i = 0; i < n; ++i) {
            GlobalVariable globalVariable = this._globalVariableList.get(i);
            if (globalVariable == null || !string.equalsIgnoreCase(globalVariable.getName())) continue;
            return globalVariable;
        }
        return null;
    }

    public StateVariable getStateVariable(int n) {
        int n2 = this._stateVariableList.size();
        for (int i = 0; i < n2; ++i) {
            StateVariable stateVariable = this._stateVariableList.get(i);
            if (stateVariable == null || stateVariable.getIndex() != n) continue;
            return stateVariable;
        }
        return null;
    }

    @Scriptable
    public StateVariable getStateVariable(String string) {
        if (string == null) {
            return null;
        }
        int n = this._stateVariableList.size();
        for (int i = 0; i < n; ++i) {
            StateVariable stateVariable = this._stateVariableList.get(i);
            if (stateVariable == null || !string.equalsIgnoreCase(stateVariable.getName())) continue;
            return stateVariable;
        }
        return null;
    }

    public double getDefaultPulseFlow() {
        if (RMAConst.isUndefinedValue((double)this._defaultPulseFlow)) {
            if (this.getUnitSystem() == 2) {
                return 150.0;
            }
            return 5000.0;
        }
        return this._defaultPulseFlow;
    }

    public void getDefaultPulseFlow(ParamDouble paramDouble) {
        paramDouble.setValue(this.getDefaultPulseFlow());
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_FLOW);
    }

    public void setDefaultPulseFlow(double d) {
        this._defaultPulseFlow = d;
    }

    public void setDefaultPulseFlow(ParamDouble paramDouble) {
        this._defaultPulseFlow = paramDouble.getValue();
    }

    public JunctionElement newJunctionElement() {
        String string = this.getNextDefaultName(2);
        return this.newJunctionElement(string);
    }

    public JunctionElement newJunctionElement(String string) {
        RssSystem rssSystem = this;
        JunctionElement junctionElement = new JunctionElement(rssSystem, rssSystem.nextElementIndex());
        junctionElement.setName(string);
        this._elementVector.addElement(junctionElement);
        return junctionElement;
    }

    public JunctionElement newJunctionElement(ComputationPoint computationPoint) {
        RssSystem rssSystem = this;
        JunctionElement junctionElement = new JunctionElement(rssSystem, rssSystem.nextElementIndex());
        junctionElement.setComputationPoint(computationPoint);
        junctionElement.setLabelPosition(computationPoint.getLabelPosition());
        this._elementVector.addElement(junctionElement);
        return junctionElement;
    }

    @Scriptable
    public DivertedOutletElement findDivertedOutlet(String string) {
        int n = this._elementVector.size();
        for (int i = 1; i <= n; ++i) {
            Element element = (Element)this._elementVector.elementAt(n - i);
            if (element == null || !(element instanceof ReservoirElement)) continue;
            int n2 = element._elemVector.size();
            for (int j = 1; j <= n2; ++j) {
                Element element2 = element._elemVector.elementAt(n2 - j);
                if (element2 == null || !(element2 instanceof DivertedOutletElement)) continue;
                element2 = (DivertedOutletElement)element2;
                System.out.println(string + "; " + element.getName() + "-" + element2.getName());
                if (!string.equalsIgnoreCase(element.getName() + "-" + element2.getName())) continue;
                return element2;
            }
        }
        return null;
    }

    public DivertedOutletElement findDivertedOutlet(WorldPt worldPt, double d) {
        WorldRect worldRect = new WorldRect(worldPt, d);
        int n = this._elementVector.size();
        for (int i = 1; i <= n; ++i) {
            Element element = (Element)this._elementVector.elementAt(n - i);
            if (element == null || !(element instanceof ReservoirElement)) continue;
            int n2 = element._elemVector.size();
            for (int j = 1; j <= n2; ++j) {
                TSLocation tSLocation = element._elemVector.elementAt(n2 - j);
                if (tSLocation == null || !(tSLocation instanceof DivertedOutletElement)) continue;
                DivertedOutletElement divertedOutletElement = (DivertedOutletElement)tSLocation;
                if (divertedOutletElement.getLine().nearPt(worldPt, d)) {
                    return divertedOutletElement;
                }
                tSLocation = divertedOutletElement.getTailNode();
                if (tSLocation != null && worldRect.contains((WorldPt)(tSLocation = tSLocation.getLocation()))) {
                    return divertedOutletElement;
                }
                tSLocation = ((Element)divertedOutletElement).getDownstreamNode();
                if (tSLocation == null || !worldRect.contains((WorldPt)(tSLocation = tSLocation.getLocation()))) continue;
                return divertedOutletElement;
            }
        }
        return null;
    }

    public DiversionElement findDiversion(WorldPt worldPt, double d) {
        WorldRect worldRect = new WorldRect(worldPt, d);
        int n = this._elementVector.size();
        for (int i = 1; i <= n; ++i) {
            TSLocation tSLocation = (Element)this._elementVector.elementAt(n - i);
            if (tSLocation == null || !(tSLocation instanceof DiversionElement)) continue;
            DiversionElement diversionElement = (DiversionElement)tSLocation;
            if (diversionElement.getLine().nearPt(worldPt, d)) {
                return diversionElement;
            }
            tSLocation = ((Element)diversionElement).getUpstreamNode();
            if (tSLocation != null && worldRect.contains((WorldPt)(tSLocation = tSLocation.getLocation()))) {
                return diversionElement;
            }
            tSLocation = ((Element)diversionElement).getDownstreamNode();
            if (tSLocation == null || !worldRect.contains((WorldPt)(tSLocation = tSLocation.getLocation()))) continue;
            return diversionElement;
        }
        return null;
    }

    @Scriptable
    public DiversionElement findDiversion(String string) {
        int n = this._elementVector.size();
        for (int i = 1; i <= n; ++i) {
            Element element = (Element)this._elementVector.elementAt(n - i);
            if (element == null || !(element instanceof DiversionElement) || !element.getName().equals(string)) continue;
            return (DiversionElement)element;
        }
        return null;
    }

    public boolean deleteDiversion(String string) {
        int n = this._elementVector.size();
        for (int i = 1; i <= n; ++i) {
            Element element = (Element)this._elementVector.elementAt(n - i);
            if (element == null || !(element instanceof DiversionElement) || !(element = (DiversionElement)element).getName().equals(string)) continue;
            element.dispose(true);
            this._elementVector.removeElementAt(n - i);
            this.cleanVectors();
            this.setModified(true);
            return true;
        }
        return false;
    }

    public ReachElement findReach(WorldPt worldPt, double d) {
        int n = this._elementVector.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._elementVector.elementAt(i);
            if (object == null || !(object instanceof ReachElement)) continue;
            object = (ReachElement)object;
            RssNode rssNode = ((Element)object).getUpstreamNode();
            RssNode rssNode2 = ((Element)object).getDownstreamNode();
            StreamElement streamElement = this.getAlignment().findReach(rssNode.getStreamIndex());
            if (streamElement != null) {
                double d2 = rssNode.getStreamCoord();
                double d3 = rssNode2.getStreamCoord();
                streamElement = streamElement.getLineSegment(d3, d2);
            } else {
                streamElement = new WorldLine();
                streamElement.pts.addElement(rssNode.getLocation());
                streamElement.pts.addElement(rssNode2.getLocation());
            }
            if (!streamElement.nearPt(worldPt, d)) continue;
            return object;
        }
        return null;
    }

    public List<ReachElement> findReaches(Predicate<WorldLine> predicate) {
        ArrayList<ReachElement> arrayList = new ArrayList<ReachElement>();
        int n = this._elementVector.size();
        new GeometryFactory();
        for (int i = 0; i < n; ++i) {
            Object object = this._elementVector.elementAt(i);
            if (object == null || !(object instanceof ReachElement)) continue;
            object = (ReachElement)object;
            RssNode rssNode = ((Element)object).getUpstreamNode();
            RssNode rssNode2 = ((Element)object).getDownstreamNode();
            StreamElement streamElement = this.getAlignment().findReach(rssNode.getStreamIndex());
            if (streamElement != null) {
                double d = rssNode.getStreamCoord();
                double d2 = rssNode2.getStreamCoord();
                streamElement = streamElement.getLineSegment(d2, d);
            } else {
                streamElement = new WorldLine();
                streamElement.pts.addElement(rssNode.getLocation());
                streamElement.pts.addElement(rssNode2.getLocation());
            }
            boolean bl = predicate.test((WorldLine)streamElement);
            if (!bl) continue;
            arrayList.add((ReachElement)object);
        }
        return arrayList;
    }

    public ReachElement findReach(String string) {
        int n = this._elementVector.size();
        for (int i = 1; i <= n; ++i) {
            Element element = (Element)this._elementVector.elementAt(n - i);
            if (element == null || !(element instanceof ReachElement) || !(element = (ReachElement)element).getName().equals(string)) continue;
            return element;
        }
        return null;
    }

    public void breakReach(ReachElement reachElement, WorldPt object, JunctionElement junctionElement) {
        if (reachElement == null || object == null || junctionElement == null) {
            this.printErrorMessage("RssSystem.breakReach: missing required input");
            return;
        }
        Object object2 = ((Element)reachElement).getDownstreamNode();
        if (object2 == null) {
            this.printErrorMessage("RssSystem.breakReach: Failed to get downstream node");
            return;
        }
        Object object3 = ((RssNode)object2).getStream();
        if (object3 == null) {
            this.printErrorMessage("RssSystem.breakReach: Failed to get stream element for reach");
            return;
        }
        double d = object3.getStationByLocation((WorldPt)object);
        object = this.createNode((Node)object2);
        ((RssNode)object).setStreamStation(d);
        object3 = this.createNode((Node)object2);
        object3.setStreamStation(d);
        reachElement.removeNode((RssNode)object2);
        reachElement.addNode((RssNode)object, 0);
        junctionElement.addNode((RssNode)object, 1);
        junctionElement.addNode((RssNode)object3, 0);
        object = this.newReachElement();
        ((Element)object).addNode((RssNode)object3, 1);
        ((Element)object).addNode((RssNode)object2, 0);
        object2 = ((RssNode)object2).getDownstreamElement();
        if (object2 != null) {
            ((Element)object).setName(junctionElement.getName() + " to " + object2.getName());
            object = ((Element)reachElement).getUpstreamNode();
            if (object != null && (object = ((RssNode)object).getUpstreamElement()) != null) {
                object2 = object.getName() + " to " + object2.getName();
                if (reachElement.getName().equals(object2)) {
                    reachElement.setName(object.getName() + " to " + junctionElement.getName());
                }
            }
        }
        this.setModified(true);
    }

    public boolean deleteStateVariable(StateVariable stateVariable) {
        if (stateVariable == null) {
            return false;
        }
        if (this._stateVariableList.remove(stateVariable)) {
            this.setModified(true);
            return true;
        }
        int n = this._stateVariableList.size();
        for (int i = 0; i < n; ++i) {
            StateVariable stateVariable2 = this._stateVariableList.get(i);
            if (stateVariable2.getIndex() != stateVariable.getIndex()) continue;
            this._stateVariableList.remove(i);
            this.setModified(true);
            return true;
        }
        System.out.println("deleteStateVariable: failed to find state variable " + String.valueOf(stateVariable));
        return false;
    }

    public boolean deleteGlobalVariable(GlobalVariable globalVariable) {
        if (globalVariable == null) {
            return false;
        }
        if (this._globalVariableList.remove(globalVariable)) {
            this.setModified(true);
            return true;
        }
        int n = this._globalVariableList.size();
        for (int i = 0; i < n; ++i) {
            GlobalVariable globalVariable2 = this._globalVariableList.get(i);
            if (globalVariable2.getIndex() != globalVariable.getIndex()) continue;
            this._globalVariableList.remove(i);
            this.setModified(true);
            return true;
        }
        System.out.println("deleteGlobalVariable: failed to find global variable " + String.valueOf(globalVariable));
        return false;
    }

    public boolean deleteReach(String string) {
        int n = this._elementVector.size();
        for (int i = 1; i <= n; ++i) {
            Element element = (Element)this._elementVector.elementAt(n - i);
            if (element == null || !(element instanceof ReachElement) || !(element = (ReachElement)element).getName().equals(string)) continue;
            element.dispose(true);
            this._elementVector.removeElementAt(n - i);
            this.cleanVectors();
            this.setModified(true);
            return true;
        }
        return false;
    }

    public JunctionElement findJunction(WorldPt worldPt, double d) {
        worldPt = new WorldRect(worldPt, d);
        int n = this._elementVector.size();
        for (int i = 1; i <= n; ++i) {
            Element element = (Element)this._elementVector.elementAt(n - i);
            if (element == null || !(element instanceof JunctionElement) || !worldPt.contains(element.getReferencePt())) continue;
            return (JunctionElement)element;
        }
        return null;
    }

    public List<ReservoirElement> findReservoirs(Predicate<Object> predicate) {
        ArrayList<ReservoirElement> arrayList = new ArrayList<ReservoirElement>();
        for (Object object : this._elementVector) {
            if (!(object instanceof ReservoirElement)) continue;
            object = (ReservoirElement)object;
            WorldRegion worldRegion = ((ReservoirElement)object)._region;
            RssNode rssNode = ((Element)object).getUpstreamNode();
            RssNode rssNode2 = ((Element)object).getDownstreamNode();
            StreamElement streamElement = this.getAlignment().findReach(rssNode.getStreamIndex());
            if (streamElement != null) {
                double d = rssNode.getStreamCoord();
                double d2 = rssNode2.getStreamCoord();
                streamElement = streamElement.getLineSegment(d2, d);
            } else {
                streamElement = new WorldLine();
                streamElement.pts.addElement(rssNode.getLocation());
                streamElement.pts.addElement(rssNode2.getLocation());
            }
            if (!predicate.test(streamElement) || !predicate.test(worldRegion)) continue;
            arrayList.add((ReservoirElement)object);
        }
        return arrayList;
    }

    public List<JunctionElement> findJunctions(Predicate<WorldPt> predicate) {
        ArrayList<JunctionElement> arrayList = new ArrayList<JunctionElement>();
        for (Object e : this._elementVector) {
            if (!(e instanceof JunctionElement) || !predicate.test(((JunctionElement)e).getReferencePt())) continue;
            arrayList.add((JunctionElement)e);
        }
        return arrayList;
    }

    @Scriptable
    public JunctionElement findJunction(String string) {
        int n = this._elementVector.size();
        for (int i = 1; i <= n; ++i) {
            Element element = (Element)this._elementVector.elementAt(n - i);
            if (element == null || !(element instanceof JunctionElement) || !element.getName().equals(string)) continue;
            return (JunctionElement)element;
        }
        return null;
    }

    public JunctionElement findJunction(ComputationPoint computationPoint) {
        if (computationPoint == null) {
            return null;
        }
        long l = computationPoint.getId();
        int n = this._elementVector.size();
        for (int i = 1; i <= n; ++i) {
            Element element = (Element)this._elementVector.elementAt(n - i);
            if (element == null || !(element instanceof JunctionElement) || ((JunctionElement)(element = (JunctionElement)element)).getComputationPointId() != l) continue;
            return element;
        }
        return null;
    }

    public boolean deleteJunction(String string) {
        int n = this._elementVector.size();
        for (int i = 1; i <= n; ++i) {
            Element element = (Element)this._elementVector.elementAt(n - i);
            if (element == null || !(element instanceof JunctionElement) || !element.getName().equals(string)) continue;
            element.dispose(true);
            this._elementVector.removeElementAt(n - i);
            this.cleanVectors();
            this.setModified(true);
            return true;
        }
        return false;
    }

    public void cleanVectors() {
        TSLocation tSLocation;
        int n;
        this.p.clear();
        this.q.clear();
        int n2 = this._elementVector.size();
        for (n = 1; n <= n2; ++n) {
            tSLocation = (Element)this._elementVector.elementAt(n2 - n);
            if (tSLocation == null) continue;
            tSLocation.cleanVectors();
            if (tSLocation.isDisposed()) {
                System.out.println("Clean Vectors: removing element " + tSLocation.getFullName());
                this._elementVector.removeElementAt(n2 - n);
            }
            this.p.put(new Integer(tSLocation.getIndex()), tSLocation);
        }
        n2 = this._nodeVector.size();
        for (n = 1; n <= n2; ++n) {
            tSLocation = (RssNode)this._nodeVector.elementAt(n2 - n);
            if (tSLocation == null) continue;
            if (tSLocation.isDisposed()) {
                System.out.println("Clean Vectors: removing node " + tSLocation.getName());
                this._nodeVector.removeElementAt(n2 - n);
            }
            this.q.put(new Integer(tSLocation.getIndex()), tSLocation);
        }
    }

    public ReservoirElement findReservoir(WorldPt worldPt) {
        int n = this._elementVector.size();
        for (int i = 1; i <= n; ++i) {
            Element element = (Element)this._elementVector.elementAt(n - i);
            if (element == null || !(element instanceof ReservoirElement) || !((ReservoirElement)(element = (ReservoirElement)element)).getRegion().contains(worldPt)) continue;
            return element;
        }
        return null;
    }

    public ReservoirElement findReservoir(int n) {
        Element element = this.getElement(n);
        if (element instanceof ReservoirElement) {
            return (ReservoirElement)element;
        }
        return null;
    }

    @Scriptable
    public ReservoirElement findReservoir(String string) {
        int n = this._elementVector.size();
        for (int i = 1; i <= n; ++i) {
            Element element = (Element)this._elementVector.elementAt(n - i);
            if (element == null || !(element instanceof ReservoirElement) || !(element = (ReservoirElement)element).getName().equals(string)) continue;
            return element;
        }
        return null;
    }

    public ReservoirElement findReservoir(int n, double d) {
        if (n < 0 || d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Vector vector;
            Object object = this._elementVector.elementAt(i);
            if (object == null || !(object instanceof ReservoirElement)) continue;
            Vector<StreamSegment> vector2 = ((ReservoirElement)(object = (ReservoirElement)object)).getStreamSegmentVector();
            if (vector2 != null) {
                int n2 = vector2.size();
                for (int j = 0; j < n2; ++j) {
                    vector = vector2.elementAt(j);
                    if (vector == null || n != ((StreamSegment)vector).streamIndex || !(((StreamSegment)vector).downstreamCoord <= d) || !(((StreamSegment)vector).upstreamCoord >= d)) continue;
                    return object;
                }
                continue;
            }
            vector = ((Element)object).getNodeVector();
            for (int j = 0; j < vector.size(); ++j) {
                StreamElement streamElement;
                RssNode rssNode = (RssNode)vector.elementAt(j);
                if (rssNode == null || rssNode.getStreamIndex() != n || (streamElement = rssNode.getStream()) == null) continue;
                double d2 = rssNode.getStreamCoord();
                double d3 = Double.NEGATIVE_INFINITY;
                for (int k = 0; k < vector.size(); ++k) {
                    RssNode rssNode2;
                    if (j == k || (rssNode2 = (RssNode)vector.elementAt(k)) == null || rssNode2.getStreamIndex() != rssNode.getStreamIndex()) continue;
                    d3 = rssNode2.getStreamCoord();
                    break;
                }
                if (d3 == Double.NEGATIVE_INFINITY) {
                    d3 = 0.0;
                }
                if (d3 >= d2 || !(d2 >= d) || !(d3 <= d)) continue;
                return object;
            }
        }
        return null;
    }

    public void addReservoir(ReservoirElement reservoirElement) {
        if (reservoirElement == null) {
            return;
        }
        this._elementVector.addElement(reservoirElement);
    }

    public boolean deleteReservoir(String string) {
        int n = this._elementVector.size();
        for (int i = 1; i <= n; ++i) {
            Element element = (Element)this._elementVector.elementAt(n - i);
            if (element == null || !(element instanceof ReservoirElement) || !element.getName().equals(string)) continue;
            ReservoirSysOp[] reservoirSysOpArray = this.getReservoirSysOps();
            if (reservoirSysOpArray != null && reservoirSysOpArray.length > 0) {
                Object object = "";
                for (int j = 0; j < reservoirSysOpArray.length; ++j) {
                    if (reservoirSysOpArray[j].getReservoirByName(string) == null) continue;
                    object = (String)object + reservoirSysOpArray[j].getUserName() + "\n";
                }
                if (!((String)object).isEmpty()) {
                    String string2 = "Reservoir, " + element.getDisplayName() + ", must first be removed from the following \nReservoir System Operations before it can be deleted from the Network:\n" + (String)object;
                    JOptionPane.showMessageDialog((Component)ClientApp.frame(), string2, "Delete Reservoir Error", 0);
                    return false;
                }
            }
            element.dispose(true);
            this._elementVector.removeElementAt(n - i);
            this.cleanVectors();
            if (((ReservoirElement)element)._resOpDbfId >= 0) {
                this.D.add(((ReservoirElement)element)._resOpDbfId);
            }
            this.setModified(true);
            return true;
        }
        return false;
    }

    @Deprecated
    public ReservoirElement createReservoir(WorldRegion worldRegion) {
        if (worldRegion == null) {
            return null;
        }
        RssSystem rssSystem = this;
        ReservoirElement reservoirElement = new ReservoirElement(rssSystem, rssSystem.nextElementIndex());
        reservoirElement.createDefaultElements();
        reservoirElement.setRegion(worldRegion);
        this._elementVector.addElement(reservoirElement);
        int n = this.getElementCount(reservoirElement.getClass().getName());
        reservoirElement.setName("Reservoir Element " + Integer.toString(n));
        this.setModified(true);
        return reservoirElement;
    }

    public ReservoirElement createReservoir(WorldRegion worldRegion, Vector vector, Vector vector2, double d, String object, String string) {
        if (worldRegion == null) {
            return null;
        }
        RssSystem rssSystem = this;
        ReservoirElement reservoirElement = new ReservoirElement(rssSystem, rssSystem.nextElementIndex());
        reservoirElement.setRegion(worldRegion);
        this._elementVector.addElement(reservoirElement);
        if (object == null || ((String)object).length() == 0) {
            object = this.getNextDefaultName(1);
            reservoirElement.setName((String)object);
        } else {
            reservoirElement.setName((String)object);
            reservoirElement.setDescription(string);
        }
        reservoirElement.createDefaultElements();
        this.setModified(true);
        for (int i = 0; i < vector.size(); ++i) {
            int n;
            object = (RssNode)vector.elementAt(i);
            if (!this._nodeVector.contains(object)) {
                ((RssNode)object).setSystem(this);
                object.setIndex(this.nextNodeIndex());
                this._nodeVector.addElement(object);
            }
            int n2 = (n = ((Integer)vector2.elementAt(i)).intValue()) == 1 ? 0 : 1;
            WorldRect worldRect = new WorldRect(((RssNode)object).getLocation(), d);
            Element element = null;
            for (int j = 0; j < this._elementVector.size(); ++j) {
                TSLocation tSLocation = (Element)this._elementVector.elementAt(j);
                if (tSLocation == null || !(tSLocation instanceof JunctionElement)) continue;
                tSLocation = (JunctionElement)tSLocation;
                if (element == null && worldRect.contains(tSLocation.getReferencePt())) {
                    element = tSLocation;
                    if ((tSLocation = element.getDownstreamNode()) != null && tSLocation.getDownstreamElement() == null) {
                        tSLocation.dispose();
                    }
                    element.addNode((RssNode)object, n2);
                }
                if (element != null) break;
            }
            if (element == null) {
                element = this.newJunctionElement();
                element.addNode((RssNode)object, n2);
                if (n2 == 1) {
                    RssNode rssNode = this.createNode(((RssNode)object).getLocation());
                    rssNode.setStreamIndex(object.getStreamIndex());
                    rssNode.setStreamName(object.getStreamName());
                    rssNode.setStreamCoord(((RssNode)object).getStreamCoord());
                    rssNode.setStreamStation(object.getStreamStation());
                    element.addNode(rssNode, 0);
                }
            }
            ((Element)reservoirElement).addNode((RssNode)object, n);
        }
        return reservoirElement;
    }

    public synchronized int getNextResOpId() {
        return ++this._nextResOpId;
    }

    public synchronized int getNextResSysOpId() {
        return ++this._nextResSysOpId;
    }

    public ReservoirElement createReservoir(Reservoir reservoir) {
        if (reservoir == null) {
            return null;
        }
        RssSystem rssSystem = this;
        ReservoirElement reservoirElement = new ReservoirElement(rssSystem, rssSystem.nextElementIndex());
        reservoirElement.setRegion((WorldRegion)reservoir.getRegion().clone());
        reservoirElement.setReferencePt(reservoir.getReferencePt());
        this._elementVector.addElement(reservoirElement);
        reservoirElement.setName(reservoir.getName());
        reservoirElement.setDescription(reservoir.getDescription());
        reservoirElement.createDefaultElements();
        reservoirElement.setReservoirProjectId(reservoir.getId());
        reservoirElement.setLabelPosition(reservoir.getLabelPosition());
        this.setModified(true);
        Vector vector = reservoir.getNodeVector();
        Vector vector2 = reservoir.getNodeDirVector();
        for (int i = 0; i < vector.size(); ++i) {
            Node node = (Node)vector.elementAt(i);
            Integer n = (Integer)vector2.elementAt(i);
            node = this.createNode(node);
            int n2 = n;
            int n3 = 1;
            if (n2 == 1) {
                n3 = 0;
            }
            Element element = null;
            ComputationPoint computationPoint = reservoir.getComputationPointAt(i);
            if (computationPoint != null) {
                for (int j = 0; j < this._elementVector.size(); ++j) {
                    TSLocation tSLocation = (Element)this._elementVector.elementAt(j);
                    if (tSLocation == null || !(tSLocation instanceof JunctionElement)) continue;
                    if ((tSLocation = (JunctionElement)tSLocation).getComputationPointId() == computationPoint.getId()) {
                        element = tSLocation;
                        if ((tSLocation = element.getDownstreamNode()) != null && n3 == 0) {
                            tSLocation.dispose();
                        }
                        element.addNode((RssNode)node, n3);
                    }
                    if (element != null) break;
                }
            }
            if (element == null) {
                element = this.newJunctionElement();
                element.addNode((RssNode)node, n3);
                if (n3 == 1) {
                    RssNode rssNode = this.createNode(node.getLocation());
                    rssNode.setStreamIndex(node.getStreamIndex());
                    rssNode.setStreamName(node.getStreamName());
                    rssNode.setStreamCoord(node.getStreamCoord());
                    rssNode.setStreamStation(node.getStreamStation());
                    element.addNode(rssNode, 0);
                }
            }
            ((Element)reservoirElement).addNode((RssNode)node, n2);
        }
        reservoirElement.updateSegments();
        return reservoirElement;
    }

    public RssNode getConnectionNode(WorldPt object, double d, int n) {
        Element element;
        TSLocation tSLocation;
        int n2;
        if (object == null) {
            return null;
        }
        int n3 = this._elementVector.size();
        object = new WorldRect(object.e - d, object.n + d, object.e + d, object.n - d);
        for (n2 = 0; n2 < n3; ++n2) {
            tSLocation = (Element)this._elementVector.elementAt(n2);
            if (tSLocation == null || !(tSLocation instanceof JunctionElement) || (element = tSLocation.getReferencePt()) == null || !object.contains((WorldPt)element)) continue;
            object = this.createNode((WorldPt)element);
            tSLocation.addNode((RssNode)object, n);
            return object;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            element = (Element)this._elementVector.elementAt(n2);
            if (element == null || !(element instanceof ReachElement)) continue;
            tSLocation = (ReachElement)element;
            tSLocation = tSLocation.getUpstreamNode();
            object.contains(tSLocation.getLocation());
        }
        return null;
    }

    public ReachElement createReach(JunctionElement element, JunctionElement junctionElement, RssNode rssNode, RssNode rssNode2, String string) {
        if (!element.getNodeVector().contains(rssNode)) {
            element.addNode(rssNode, 0);
        }
        if (!junctionElement.getNodeVector().contains(rssNode2)) {
            junctionElement.addNode(rssNode2, 1);
        }
        element = this.newReachElement(string);
        element.addNode(rssNode, 1);
        element.addNode(rssNode2, 0);
        this.setModified(true);
        return element;
    }

    @Deprecated
    public ReachElement createReach(RssNode rssNode, RssNode rssNode2, double d) {
        if (rssNode == null || rssNode2 == null) {
            return null;
        }
        WorldRect worldRect = new WorldRect(rssNode.getLocation(), d);
        WorldRect worldRect2 = new WorldRect(rssNode2.getLocation(), d);
        Element element = null;
        Element element2 = null;
        for (int i = 0; i < this._elementVector.size(); ++i) {
            TSLocation tSLocation = (Element)this._elementVector.elementAt(i);
            if (tSLocation == null || !(tSLocation instanceof JunctionElement)) continue;
            tSLocation = (JunctionElement)tSLocation;
            if (element == null && tSLocation != element2 && worldRect.contains(tSLocation.getReferencePt())) {
                element = tSLocation;
                if ((tSLocation = element.getDownstreamNode()) != null && tSLocation.getDownstreamElement() == null) {
                    tSLocation.dispose();
                }
                element.addNode(rssNode, 0);
            } else if (element2 == null && tSLocation != element && worldRect2.contains(tSLocation.getReferencePt())) {
                element2 = tSLocation;
                element2.addNode(rssNode2, 1);
                tSLocation = element2.getDownstreamNode();
                if (tSLocation != null && tSLocation.getStreamIndex() != rssNode2.getStreamIndex() && tSLocation.getStreamCoord() < 0.01) {
                    tSLocation.setStream(rssNode2.getStream());
                    tSLocation.setStreamStation(rssNode2.getStreamStation());
                    tSLocation.setStreamCoord(rssNode2.getStreamCoord());
                }
            }
            if (element != null && element2 != null) break;
        }
        if (element == null) {
            element = this.newJunctionElement();
            element.addNode(rssNode, 0);
        }
        if (element2 == null) {
            element2 = this.newJunctionElement();
            element2.addNode(rssNode2, 1);
            RssNode rssNode3 = this.createNode(rssNode2.getLocation());
            rssNode3.setStreamIndex(rssNode2.getStreamIndex());
            rssNode3.setStreamName(rssNode2.getStreamName());
            rssNode3.setStreamCoord(rssNode2.getStreamCoord());
            rssNode3.setStreamStation(rssNode2.getStreamStation());
            element2.addNode(rssNode3, 0);
        }
        ReachElement reachElement = this.newReachElement();
        reachElement.addNode(rssNode, 1);
        reachElement.addNode(rssNode2, 0);
        this.setModified(true);
        return reachElement;
    }

    public DiversionElement createDiversion(RssNode rssNode, RssNode rssNode2, Vector vector, double d) {
        if (rssNode == null) {
            return null;
        }
        DiversionElement diversionElement = this.newDiversionElement();
        ((Element)diversionElement).addNode(rssNode, 1);
        if (rssNode2 != null) {
            ((Element)diversionElement).addNode(rssNode2, 0);
        }
        rssNode = new WorldLine();
        for (int i = 0; i < vector.size(); ++i) {
            ((WorldLine)rssNode).pts.addElement(vector.elementAt(i));
        }
        diversionElement.setLine((WorldLine)rssNode);
        this.setModified(true);
        return diversionElement;
    }

    public Element createDiversion(Diversion diversion, Reservoir object) {
        Element element;
        int n;
        if (diversion == null) {
            return null;
        }
        long l = diversion.getReservoirId();
        if (l < 0L) {
            Element element2 = null;
            ComputationPoint computationPoint = diversion.getComputationPoint(true);
            if (computationPoint == null) {
                return null;
            }
            TSLocation tSLocation = this.findJunction(computationPoint);
            if (tSLocation == null) {
                tSLocation = this.findJunction(computationPoint.getName());
            }
            if (tSLocation == null) {
                return null;
            }
            ComputationPoint computationPoint2 = diversion.getComputationPoint(false);
            if (computationPoint2 != null && (element2 = this.findJunction(computationPoint2)) == null) {
                element2 = this.findJunction(computationPoint2.getName());
            }
            object = this.createNode(computationPoint);
            tSLocation.addNode((RssNode)object, 1);
            tSLocation = null;
            if (computationPoint2 != null && element2 != null) {
                tSLocation = this.createNode(computationPoint2);
                element2.addNode((RssNode)tSLocation, 1);
            }
            element2 = this.newDiversionElement();
            ((DiversionElement)element2).setDiversionProjectId(diversion.getId());
            element2.addNode((RssNode)object, 1);
            if (tSLocation != null) {
                element2.addNode((RssNode)tSLocation, 0);
            }
            element2.setName(diversion.getName());
            element2.setDescription(diversion.getDescription());
            WorldLine worldLine = (WorldLine)diversion.getLine().clone();
            ((DiversionElement)element2).setLine(worldLine);
            this.setModified(true);
            return element2;
        }
        ReservoirElement reservoirElement = null;
        int n2 = this._elementVector.size();
        for (n = 0; n < n2; ++n) {
            ReservoirElement reservoirElement2;
            Element element3 = (Element)this._elementVector.elementAt(n);
            if (element3 == null || !(element3 instanceof ReservoirElement) || (reservoirElement2 = (ReservoirElement)element3).getReservoirProjectId() != object.getId()) continue;
            reservoirElement = reservoirElement2;
            break;
        }
        if (reservoirElement == null) {
            return null;
        }
        long l2 = diversion.getId();
        object = reservoirElement.getDivertedOutlets();
        n2 = ((Vector)object).size();
        for (n = 0; n < n2; ++n) {
            element = (DivertedOutletElement)((Vector)object).elementAt(n);
            if (element == null || ((DivertedOutletElement)element).getDiversionProjectId() != l2) continue;
            return null;
        }
        element = null;
        object = diversion.getComputationPoint(false);
        if (object != null && (element = this.findJunction((ComputationPoint)object)) == null) {
            element = this.findJunction(object.getName());
        }
        Node node = diversion.getUpstreamNode();
        RssNode rssNode = this.newNode();
        rssNode.setName(node.getName());
        rssNode.setStreamIndex(node.getStreamIndex());
        rssNode.setStreamName(node.getStreamName());
        rssNode.setStreamStation(node.getStreamStation());
        node = null;
        if (object != null && element != null) {
            node = this.createNode((ComputationPoint)object);
            element.addNode((RssNode)node, 1);
        }
        object = (WorldLine)diversion.getLine().clone();
        object = reservoirElement.createDivertedOutlet(rssNode, (RssNode)node, ((WorldLine)object).pts, 0.0);
        ((DivertedOutletElement)object).setDiversionProjectId(diversion.getId());
        ((Element)object).setName(diversion.getName());
        this.setModified(true);
        return object;
    }

    public ReachElement findReach(int n, double d) {
        if (n < 0 || d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Object object = this._elementVector.elementAt(i);
            if (object == null || !(object instanceof ReachElement)) continue;
            object = (ReachElement)object;
            RssNode rssNode = ((Element)object).getUpstreamNode();
            RssNode rssNode2 = ((Element)object).getDownstreamNode();
            if (rssNode == null || rssNode2 == null || n != rssNode.getStreamIndex() || !(rssNode.getStreamCoord() >= d) || !(rssNode2.getStreamCoord() <= d)) continue;
            return object;
        }
        return null;
    }

    public Vector getElementVector() {
        return this._elementVector;
    }

    public List<StateVariable> getStateVariableList() {
        return this._stateVariableList;
    }

    public List<GlobalVariable> getGlobalVariableList() {
        return this._globalVariableList;
    }

    public List<GlobalVariable> getInputGlobalVariables() {
        ArrayList<GlobalVariable> arrayList = new ArrayList<GlobalVariable>();
        for (GlobalVariable globalVariable : this.getGlobalVariableList()) {
            if (!globalVariable.isInput()) continue;
            arrayList.add(globalVariable);
        }
        return arrayList;
    }

    public List<GlobalVariable> getInputGlobalVariables(GlobalVariableType globalVariableType) {
        ArrayList<GlobalVariable> arrayList = new ArrayList<GlobalVariable>();
        for (GlobalVariable globalVariable : this.getGlobalVariableList()) {
            if (!globalVariable.isInput() || globalVariable.getType() != globalVariableType) continue;
            arrayList.add(globalVariable);
        }
        return arrayList;
    }

    public List<GlobalVariable> getGlobalVariables(GlobalVariableType globalVariableType) {
        ArrayList<GlobalVariable> arrayList = new ArrayList<GlobalVariable>();
        for (GlobalVariable globalVariable : this.getGlobalVariableList()) {
            if (globalVariable.getType() != globalVariableType) continue;
            arrayList.add(globalVariable);
        }
        return arrayList;
    }

    public List<GlobalVariable> getOutputGlobalVariables() {
        ArrayList<GlobalVariable> arrayList = new ArrayList<GlobalVariable>();
        for (GlobalVariable globalVariable : this.getGlobalVariableList()) {
            if (globalVariable.isInput()) continue;
            arrayList.add(globalVariable);
        }
        return arrayList;
    }

    @Scriptable
    public List<ScalarGlobalVariable> findGlobalScalars() {
        ArrayList<ScalarGlobalVariable> arrayList = new ArrayList<ScalarGlobalVariable>();
        for (GlobalVariable globalVariable : this.getGlobalVariableList()) {
            if (GlobalVariableType.SCALAR != globalVariable.getType()) continue;
            arrayList.add((ScalarGlobalVariable)globalVariable);
        }
        return arrayList;
    }

    @Scriptable
    public ScalarGlobalVariable findGlobalScalar(String object) {
        if ((object = this.getGlobalVariable((String)object)) != null && GlobalVariableType.SCALAR == object.getType()) {
            return (ScalarGlobalVariable)object;
        }
        return null;
    }

    @Scriptable
    public List<ScalarGlobalVariable> findGloblScalars(ScalarDataType scalarDataType) {
        List<ScalarGlobalVariable> list = this.findGlobalScalars();
        return list.stream().filter(scalarGlobalVariable -> scalarGlobalVariable.getDataType() == scalarDataType).collect(Collectors.toList());
    }

    @Scriptable
    public List<StringGlobalVariable> findGlobalStrings() {
        ArrayList<StringGlobalVariable> arrayList = new ArrayList<StringGlobalVariable>();
        for (GlobalVariable globalVariable : this.getGlobalVariableList()) {
            if (GlobalVariableType.STRING != globalVariable.getType()) continue;
            arrayList.add((StringGlobalVariable)globalVariable);
        }
        return arrayList;
    }

    @Scriptable
    public StringGlobalVariable findGlobalString(String object) {
        if ((object = this.getGlobalVariable((String)object)) != null && GlobalVariableType.STRING == object.getType()) {
            return (StringGlobalVariable)object;
        }
        return null;
    }

    @Scriptable
    public List<TableGlobalVariable> findGlobalTables() {
        ArrayList<TableGlobalVariable> arrayList = new ArrayList<TableGlobalVariable>();
        for (GlobalVariable globalVariable : this.getGlobalVariableList()) {
            if (GlobalVariableType.TABLE != globalVariable.getType()) continue;
            arrayList.add((TableGlobalVariable)globalVariable);
        }
        return arrayList;
    }

    @Scriptable
    public TableGlobalVariable findGlobalTable(String object) {
        if ((object = this.getGlobalVariable((String)object)) != null && GlobalVariableType.TABLE == object.getType()) {
            return (TableGlobalVariable)object;
        }
        return null;
    }

    @Scriptable
    public List<TimeSeriesGlobalVariable> findGlobalTimeSeries() {
        ArrayList<TimeSeriesGlobalVariable> arrayList = new ArrayList<TimeSeriesGlobalVariable>();
        for (GlobalVariable globalVariable : this.getGlobalVariableList()) {
            if (GlobalVariableType.TIME_SERIES != globalVariable.getType()) continue;
            arrayList.add((TimeSeriesGlobalVariable)globalVariable);
        }
        return arrayList;
    }

    @Scriptable
    public TimeSeriesGlobalVariable findGlobalTimeSeries(String object) {
        if ((object = this.getGlobalVariable((String)object)) != null && GlobalVariableType.TIME_SERIES == object.getType()) {
            return (TimeSeriesGlobalVariable)object;
        }
        return null;
    }

    @Scriptable
    public List<GlobalVariable> findInputGlobals() {
        return this._globalVariableList.stream().filter(globalVariable -> globalVariable.isInput()).collect(Collectors.toList());
    }

    @Scriptable
    public List<GlobalVariable> findOutputGlobals() {
        return this._globalVariableList.stream().filter(globalVariable -> !globalVariable.isInput()).collect(Collectors.toList());
    }

    public Vector getNodeVector() {
        return this._nodeVector;
    }

    public Vector getElementVectorByClass(String object) {
        try {
            object = Class.forName((String)object);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return null;
        }
        return this.getElementVectorByClass((Class)object);
    }

    public <T> Vector<T> getElementVectorByClass(Class<T> clazz) {
        Vector vector = new Vector();
        Enumeration enumeration = this._elementVector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!clazz.isInstance(e)) continue;
            vector.addElement(e);
        }
        return vector;
    }

    public int[] getElementOrder() {
        return this.r;
    }

    public Element getElementByOrder(int n) {
        if (this.s == null || this.s.size() <= n) {
            return null;
        }
        return (Element)this.s.elementAt(n);
    }

    public Element getElement(int n) {
        Element element = (Element)this.p.get(n);
        if (element != null) {
            return element;
        }
        for (int i = 0; i < this._elementVector.size(); ++i) {
            element = (Element)this._elementVector.elementAt(i);
            if (element == null) continue;
            if (element.getIndex() == n) {
                this.p.put(new Integer(element.getIndex()), element);
                return element;
            }
            if ((element = element.getElement(n)) == null) continue;
            return element;
        }
        return null;
    }

    public Element findElement(int n) {
        Element element = (Element)this.p.get(n);
        if (element != null) {
            return element;
        }
        for (int i = 0; i < this._elementVector.size(); ++i) {
            element = (Element)this._elementVector.elementAt(i);
            if (element == null || element.getIndex() != n) continue;
            this.p.put(new Integer(element.getIndex()), element);
            return element;
        }
        return null;
    }

    public Element findElement(String string) {
        String string2 = string;
        int n = string.indexOf(";");
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Element element = (Element)this._elementVector.elementAt(i);
            if (element == null || string2.compareTo(element.getName()) != 0) continue;
            if (n < 0) {
                return element;
            }
            return element.findElement(string.substring(n + 1));
        }
        return null;
    }

    @Deprecated
    public String[] getNodeNames(String string) {
        Vector<String> vector = new Vector<String>();
        int n = this._nodeVector.size();
        for (int i = 0; i < n; ++i) {
            TSRecordProxy tSRecordProxy;
            RssNode rssNode = (RssNode)this._nodeVector.elementAt(i);
            if (rssNode == null || (tSRecordProxy = (TSRecordProxy)rssNode.getTSRecordProxy(string)) == null) continue;
            vector.addElement(rssNode.getName());
        }
        if (vector.size() <= 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public AdjustableParameter findAdjParam(String string, String string2, String string3) {
        int n = string.indexOf(";");
        String string4 = string;
        if (n >= 0) {
            string4 = string.substring(0, n);
        }
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Element element = (Element)this._elementVector.elementAt(i);
            if (element == null || !string4.equals(element.getName())) continue;
            if (n < 0) {
                return element.findAdjParam(string2, string3);
            }
            return element.findAdjParam(string.substring(n + 1), string2, string3);
        }
        return null;
    }

    public double[] findTSArray(String string, String string2, String string3) {
        block3: {
            block2: {
                if (string.compareTo("Node") != 0) break block2;
                int n = this._nodeVector.size();
                for (int i = 0; i < n; ++i) {
                    RssNode rssNode = (RssNode)this._nodeVector.elementAt(i);
                    if (rssNode == null || string2.compareTo(rssNode.getName()) != 0) continue;
                    return rssNode.getTSArray(string3);
                }
                break block3;
            }
            if (string.compareTo("Element") != 0) break block3;
            int n = this._elementVector.size();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)this._elementVector.elementAt(i);
                if (element == null || string2.compareTo(element.getName()) != 0) continue;
                return null;
            }
        }
        return null;
    }

    @Deprecated
    public boolean initialize(Operations operations, TSDataSet tSDataSet, TSDataSet tSDataSet2, GVDataSet gVDataSet, GVDataSet gVDataSet2) {
        this.i = operations;
        return this.initialize(tSDataSet, tSDataSet2, gVDataSet, gVDataSet2, 0, null);
    }

    public boolean initialize(TSDataSet tSDataSet, TSDataSet tSDataSet2, GVDataSet object, GVDataSet object2, int n, RunTimeWindow runTimeWindow) {
        Object object3;
        int n2;
        this.J = null;
        this.L = n;
        this.getComputeOptions();
        this.j = tSDataSet;
        this.m = tSDataSet2;
        this.k = object;
        this.l = object2;
        if (n == 0 && !this.initializeGlobalVariables()) {
            return false;
        }
        int n3 = this._nodeVector.size();
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            RssNode rssNode = (RssNode)this._nodeVector.elementAt(n2);
            if (rssNode == null || !rssNode.isValid()) {
                this._nodeVector.remove(n2);
            }
            if (!rssNode.isActive()) continue;
            rssNode.initialize();
        }
        if (n == 0 && this._downstreamOpTable != null) {
            Enumeration enumeration = this._downstreamOpTable.keys();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                object2 = (DownstreamOp)this._downstreamOpTable.get(object);
                ((DownstreamOp)object2).clearForCompute(this, (Integer)object);
            }
        }
        int n4 = this._elementVector.size();
        Duration.ofMinutes(runTimeWindow.getTimeStepMinutes());
        for (n2 = 0; n2 < n4; ++n2) {
            object = (Element)this._elementVector.elementAt(n2);
            if (object == null || !((Element)object).isActive()) continue;
            if (!((Element)object).initialize(runTimeWindow)) {
                this.printErrorMessage("Failed to initialize Element " + ((Element)object).toString());
                return false;
            }
            if (object instanceof ReachElement) {
                object2 = ((ReachElement)object).getFunction();
                object3 = "Element Name: " + object.getName() + ", Routing Method: " + (object2 != null ? object2.toString() : "");
                this.printLogMessage((String)object3);
                this.printMessage((String)object3);
                System.out.println((String)object3);
                continue;
            }
            if (object instanceof DiversionElement && ((DiversionElement)object).getReachElement() != null) {
                object2 = ((TimeStepRoutingElement)((DiversionElement)object).getReachElement()).getFunction();
                object3 = "Element Name: " + object.getName() + ", Routing Method: " + (object2 != null ? object2.toString() : "");
                this.printLogMessage((String)object3);
                this.printMessage((String)object3);
                System.out.println((String)object3);
                continue;
            }
            if (!(object instanceof DivertedOutletElement) || ((DivertedOutletElement)object).getReachElement() == null) continue;
            object2 = ((TimeStepRoutingElement)((DivertedOutletElement)object).getReachElement()).getFunction();
            object3 = "Element Name: " + object.getName() + ", Routing Method: " + (object2 != null ? object2.toString() : "");
            this.printLogMessage((String)object3);
            this.printMessage((String)object3);
            System.out.println((String)object3);
        }
        if (n == 0 && this._downstreamOpTable != null) {
            object = this._downstreamOpTable.keys();
            while (object.hasMoreElements()) {
                object2 = (Integer)object.nextElement();
                object3 = (DownstreamOp)this._downstreamOpTable.get(object2);
                ((DownstreamOp)object3).initialize(this, (Integer)object2, runTimeWindow);
            }
        }
        if (n == 0 && this._systemHydropowerRuleTable != null) {
            object = this._systemHydropowerRuleTable.values().iterator();
            while (object.hasNext()) {
                object2 = (SystemHydropowerRule)object.next();
                ((SystemHydropowerRule)object2).initialize(this);
            }
        }
        if (n == 0 && (object = this.getAlternative().getWaterAccountSet()) != null) {
            ((WaterAccountSet)object).initialize(this, runTimeWindow);
        }
        return true;
    }

    public boolean initializeGlobalVariables() {
        boolean bl = false;
        int n = this._globalVariableList.size();
        for (int i = 0; i < n; ++i) {
            GlobalVariable globalVariable = this._globalVariableList.get(i);
            if (globalVariable == null) continue;
            try {
                String string;
                if (!globalVariable.initializeGv()) {
                    this.printWarningMessage("Failed to intialize " + String.valueOf((Object)globalVariable.getType()) + " Global Variable " + globalVariable.getName());
                }
                if ((string = globalVariable.hasValidValue()) == null) continue;
                if (this.J.invalidGlobalVariableIsError()) {
                    bl = true;
                    this.printErrorMessage(string);
                    continue;
                }
                this.printWarningMessage(string);
                continue;
            }
            catch (Exception exception) {
                this.printErrorMessage("Error initializing Global Variable " + globalVariable.getName() + " Error:" + String.valueOf(exception));
                exception.printStackTrace();
            }
        }
        return !bl;
    }

    public boolean initForPostProcessing(TSDataSet object, TSDataSet object2, int n, RunTimeWindow runTimeWindow) {
        Object object3;
        this.J = null;
        this.L = n;
        this.getComputeOptions();
        this.j = object;
        this.m = object2;
        if (n == 0 && this._downstreamOpTable != null) {
            object3 = this._downstreamOpTable.keys();
            while (object3.hasMoreElements()) {
                object = (Integer)object3.nextElement();
                object2 = (DownstreamOp)this._downstreamOpTable.get(object);
                object2.clearForCompute(this, (Integer)object);
            }
        }
        int n2 = this._elementVector.size();
        for (int i = 0; i < n2; ++i) {
            object3 = (Element)this._elementVector.elementAt(i);
            if (object3 == null || !((Element)object3).isActive() || ((Element)object3).initForPostProcessing(runTimeWindow)) continue;
            this.printErrorMessage("Failed to initialize Element " + ((Element)object3).toString());
            return false;
        }
        if (n == 0 && this._downstreamOpTable != null) {
            object3 = this._downstreamOpTable.keys();
            while (object3.hasMoreElements()) {
                Integer n3 = (Integer)object3.nextElement();
                DownstreamOp downstreamOp = (DownstreamOp)this._downstreamOpTable.get(n3);
                downstreamOp.initForPostProcessing(this, n3, runTimeWindow);
            }
        }
        if (n == 0 && this._systemHydropowerRuleTable != null) {
            for (SystemHydropowerRule systemHydropowerRule : this._systemHydropowerRuleTable.values()) {
                systemHydropowerRule.initForPostProcessing(this);
            }
        }
        return true;
    }

    public boolean initializeStateVariables(int n) {
        if (n == 0) {
            if (this.u == null) {
                this.u = new Hashtable();
            } else {
                this.u.clear();
            }
            this.getActiveStateVariables(null);
            for (n = 0; n < this._stateVariableList.size(); ++n) {
                StateVariable stateVariable = this._stateVariableList.get(n);
                if (stateVariable == null || stateVariable.initialize()) continue;
                this.printErrorMessage("Failed to initialize State Variable " + String.valueOf(stateVariable));
                return false;
            }
        }
        return true;
    }

    public boolean runStateVariableInitScripts(int n) {
        if (n == 0) {
            n = this._stateVariableList.size();
            for (int i = 0; i < n; ++i) {
                StateVariable stateVariable = this._stateVariableList.get(i);
                if (stateVariable == null || stateVariable.runScripInitialize()) continue;
                this.printErrorMessage("Failed to run the State Variable: (" + String.valueOf(stateVariable) + ") initialize script");
                return false;
            }
        }
        return true;
    }

    List<StateVariable> getActiveStateVariables(List<StateVariable> list) {
        NamedType namedType;
        int n;
        if (list == null) {
            list = new ArrayList<StateVariable>();
        }
        int n2 = this._elementVector.size();
        for (n = 0; n < n2; ++n) {
            Element element = (Element)this._elementVector.get(n);
            if (element != null && element instanceof ReservoirElement) {
                namedType = (ReservoirElement)element;
                if ((namedType = namedType.getReservoirOp(false).getActiveOpSet()) != null) {
                    namedType.getReferencedStateVariables(list);
                }
            }
            if (element == null || !element.isActive()) continue;
            element.getActiveStateVariables(list);
        }
        this.v = null;
        if (this._stateVariableList != null) {
            n2 = this._stateVariableList.size();
            for (n = 0; n < n2; ++n) {
                namedType = this._stateVariableList.get(n);
                if (namedType == null || !namedType.getAlwaysCompute() || list.contains(namedType)) continue;
                list.add((StateVariable)namedType);
                if (this.v == null) {
                    this.v = new ArrayList();
                }
                this.v.add(namedType);
            }
        }
        return list;
    }

    public void finalizeCompute() {
        if (this._systemHydropowerRuleTable != null) {
            for (Object object : this._systemHydropowerRuleTable.values()) {
                ((SystemHydropowerRule)object).finalizeCompute();
            }
        }
        this.S.clear();
        this.R.clear();
        this.V = null;
        this.T = -1;
        if (this.u != null) {
            this.u.clear();
        }
        this.u = null;
        if (this.g.shouldComputeWaterQuality()) {
            this.g.getWQRun().finalizeCompute();
        }
        List<GlobalVariable> list = this.getGlobalVariableList();
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            object = (GlobalVariable)list.get(i);
            if (object == null) continue;
            object.finalizeCompute();
        }
    }

    private int evaluateSysRuleLimits(IterationBlock object, RunTimeStep runTimeStep, List list, List list2, List list3, boolean bl, int n) {
        int n2;
        int n3 = ((IterationBlock)object).c();
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.G) {
                this.printMessage("Compute Canceled");
                return 50;
            }
            Element element = ((IterationBlock)object).d(n2);
            if (!(element instanceof ReservoirElement)) continue;
            ((ReservoirElement)element).getStorageFunction().computeInflow(runTimeStep);
        }
        this.initTandemOpForecastStep(runTimeStep);
        this.initSystemHydropower(list3, runTimeStep);
        if (n <= 0) {
            return 0;
        }
        n3 = list2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.G) {
                this.printMessage("Compute Canceled");
                return 50;
            }
            object = (DownstreamOpRule)list2.get(n2);
            if (object == null) continue;
            if (this.K == 0) {
                ((DownstreamOpRule)object).evaluateLimits32(runTimeStep, n);
                continue;
            }
            ((OpRule)object).evaluateLimits(runTimeStep, n);
        }
        if (n < 2) {
            return 0;
        }
        n3 = list3.size();
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.G) {
                this.printMessage("Compute Canceled");
                return 50;
            }
            object = (SystemHydropowerRule)list3.get(n2);
            if (object == null) continue;
            if (this.K == 0) {
                ((SystemHydropowerRule)object).evaluateLimits33(runTimeStep, n);
                continue;
            }
            ((OpRule)object).evaluateLimits(runTimeStep, n);
        }
        if (bl) {
            this.H.a(runTimeStep, n);
        }
        return 0;
    }

    private void evaluateRuleLimits(IterationBlock object, RunTimeStep runTimeStep, List list, List list2, List list3, int n) {
        int n2;
        int n3 = ((IterationBlock)object).c();
        for (n2 = 0; n2 < n3; ++n2) {
            Element element = ((IterationBlock)object).d(n2);
            if (!(element instanceof ReservoirElement)) continue;
            ((ReservoirElement)element).getStorageFunction().computeInflow(runTimeStep);
        }
        this.initTandemOpForecastStep(runTimeStep);
        this.initSystemHydropower(list3, runTimeStep);
        n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (OpRule)list.get(n2);
            if (object == null) continue;
            ((OpRule)object).evaluateLimits(runTimeStep, n);
        }
        if (n <= 0) {
            return;
        }
        n3 = list2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (DownstreamOpRule)list2.get(n2);
            if (object == null) continue;
            ((OpRule)object).evaluateLimits(runTimeStep, n);
        }
        if (n < 2) {
            return;
        }
        this.H.a(runTimeStep, n);
        n3 = list3.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (SystemHydropowerRule)list3.get(n2);
            if (object == null) continue;
            ((OpRule)object).evaluateLimits(runTimeStep, n);
        }
    }

    private void evaluateDecisions(IterationBlock object, RunTimeStep runTimeStep, List list, int n) {
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            object = (Element)list.get(i);
            if (object == null || !(object instanceof ReleaseElement)) continue;
            object = (ReleaseElement)object;
            object.updateDecisions(runTimeStep, n);
        }
    }

    private void evalStateVariableHindast(RunTimeWindow runTimeWindow, List list) {
        if (list == null) {
            return;
        }
        int n = runTimeWindow.getNumLookbackSteps();
        int n2 = list.size();
        RunTimeStep runTimeStep = new RunTimeStep(runTimeWindow);
        for (int i = 0; i <= n; ++i) {
            runTimeStep.step = i;
            for (int j = 0; j < n2; ++j) {
                StateVariable stateVariable = (StateVariable)list.get(j);
                if (stateVariable == null) continue;
                stateVariable.evaluateHindcast(runTimeStep);
            }
        }
    }

    private int evalWaterAccountsHindast(RunTimeWindow runTimeWindow) {
        WaterAccount waterAccount;
        if (this.getAlternative().getWaterAccountSet() == null || this.getAlternative().getWaterAccountSet().getWaterAccounts() == null || this.getAlternative().getWaterAccountSet().getWaterAccounts().size() == 0) {
            return 0;
        }
        int n = runTimeWindow.getNumLookbackSteps();
        int n2 = this.getAlternative().getWaterAccountSet().getWaterAccounts().size();
        RunTimeStep runTimeStep = new RunTimeStep(runTimeWindow);
        for (int i = 0; i <= n; ++i) {
            runTimeStep.step = i;
            for (int j = 0; j < n2; ++j) {
                int n3;
                if (this.getAlternative().getWaterAccountSet().getWaterAccounts().get(j) == null || (waterAccount = this.getAlternative().getWaterAccountSet().getWaterAccounts().get(j)) == null || (n3 = waterAccount.computeHindcastStep(runTimeStep)) != 1) continue;
                return 1;
            }
        }
        WaterAccountSet waterAccountSet = this.getAlternative().getWaterAccountSet();
        List<StorageZoneRef> list = waterAccountSet.getResZoneRefs();
        for (n2 = 0; n2 < list.size(); ++n2) {
            ReservoirElement reservoirElement = (ReservoirElement)this.getElement(list.get(n2).getReservoirIndex());
            if (!waterAccountSet.containsReservoir(reservoirElement)) continue;
            waterAccount = reservoirElement.getDefaultWaterAccount();
            waterAccount.setReservoir(reservoirElement);
            int n4 = 0;
            while (n4 <= n) {
                runTimeStep.step = n4++;
                int n5 = waterAccount.computeDefaultWAhindcastStep(runTimeStep);
                if (n5 != 1) continue;
                return 1;
            }
        }
        return 0;
    }

    public int evalStateVariables(RunTimeStep runTimeStep, List list) {
        if (list == null) {
            return 0;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (this.G) {
                this.printMessage("Compute Canceled");
                return 50;
            }
            StateVariable stateVariable = (StateVariable)list.get(i);
            if (stateVariable == null) continue;
            stateVariable.evaluate(runTimeStep);
        }
        return 0;
    }

    private int initDownstreamOperationStep(List list, RunTimeStep runTimeStep) {
        if (list == null) {
            return 1;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DownstreamOp downstreamOp = (DownstreamOp)list.get(i);
            downstreamOp.initOperationStep(runTimeStep);
        }
        return 0;
    }

    private int initSystemHydropowerForecast(List<SystemHydropowerRule> list, RunTimeWindow runTimeWindow) {
        if (list == null) {
            return 0;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SystemHydropowerRule systemHydropowerRule = list.get(i);
            int n2 = systemHydropowerRule.initForecast(runTimeWindow);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    private int initSystemHydropower(List list, RunTimeStep runTimeStep) {
        if (list == null) {
            return 0;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SystemHydropowerRule systemHydropowerRule = (SystemHydropowerRule)list.get(i);
            int n2 = systemHydropowerRule.initOperationStep(runTimeStep);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    private int evaluateDownstreamOperationStep(List list, RunTimeStep runTimeStep, int n) {
        if (list == null) {
            return 1;
        }
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            DownstreamOp downstreamOp = (DownstreamOp)list.get(i);
            downstreamOp.evaluateOperationStep(runTimeStep, n);
        }
        return 0;
    }

    RssComputeOptions getComputeOptions() {
        if (this.J != null) {
            return this.J;
        }
        RssRmiWorkspace rssRmiWorkspace = (RssRmiWorkspace)((Object)this.getWorkspace().getRemote());
        try {
            rssRmiWorkspace = (RssRmiWorkspace)((HecRmiWorkspace)rssRmiWorkspace.getChildWorkspace("")).getBaseWorkspace().getChildWorkspace("rss");
            this.J = rssRmiWorkspace.getRssComputeOptions();
        }
        catch (Exception exception) {
            this.printLogMessage("RssSystem failed to get compute options from base watershed, using defaults.");
            exception.printStackTrace();
            this.J = new RssComputeOptions();
        }
        return this.J;
    }

    private boolean loadHotstart(int n, RunTimeWindow object, IterationBlock iterationBlock, boolean bl) {
        HotstartContainer hotstartContainer;
        if (n == 3) {
            return true;
        }
        HotstartOptions hotstartOptions = this.h.getHotstartOptions();
        this.printStatus("Loading Hotstart State");
        String string = hotstartOptions.getLoadAltName();
        object = new HecTime(object.getStartTime());
        object.setTimeIncrement(2);
        object.showTimeAsBeginningOfDay(false);
        String string2 = object.dateAndTime(104);
        if ("00:00".equals(object.time())) {
            object.setTime("0000");
            string2 = object.dateAndTime(104);
        }
        if ((hotstartContainer = this.S.get(string2)) == null) {
            hotstartContainer = new HotstartContainer(this);
            hotstartContainer.setTime((HecTime)object);
            hotstartContainer.setHoursToSave(hotstartOptions.getHoursToSave());
            hotstartContainer.setCanSave(false);
            if (!hotstartContainer.loadFile(string, n)) {
                return false;
            }
            this.S.put(string2, hotstartContainer);
        }
        if (iterationBlock != null) {
            if (!hotstartContainer.fixElements(n, iterationBlock.a)) {
                return false;
            }
            if (bl) {
                object = hotstartContainer.getFilename(string, true);
                hotstartContainer.readTimeSeries((String)object, n);
            }
            iterationBlock.f(0);
        }
        return true;
    }

    public void initHotstart(RunTimeWindow runTimeWindow) {
        this.V = null;
        this.T = -1;
        HotstartOptions hotstartOptions = this.h.getHotstartOptions();
        this.b = hotstartOptions.shouldCreateHotstart();
        if (this.b) {
            int n;
            HecTime hecTime;
            if (hotstartOptions.shouldSaveAtDateTime()) {
                hecTime = hotstartOptions.getSaveAtDateTime();
                if (!hecTime.isDefined()) {
                    this.printWarningMessage("No Hotstart Save At Date/Time is Defined. Not writing Hotstart file");
                } else if ((hecTime.lessThan(runTimeWindow.getLookbackTime()) || hecTime.greaterThan(runTimeWindow.getEndTime())) && this.g.getLogLevel() > 8) {
                    this.printWarningMessage("Hotstart Save At Date/Time is Outside of Time Window. Not writing Hotstart file");
                }
                this.T = runTimeWindow.getStepAtTime(hecTime) + 1;
            }
            hecTime = new IntArray(100);
            if (hotstartOptions.shouldSaveAtLookback()) {
                n = runTimeWindow.getNumLookbackSteps() + 1;
                hecTime.add(n);
            }
            if (hotstartOptions.shouldSaveAtInterval() && this.V == null) {
                HecTime hecTime2 = hotstartOptions.getIntervalDateTime();
                if (!hecTime2.isDefined()) {
                    this.printWarningMessage("No Hotstart Interval Date/Time is Defined. Not writing Hotstart file");
                } else if (this.U != null && (this.U.lessThan(runTimeWindow.getLookbackTime()) || this.U.greaterThan(runTimeWindow.getEndTime()))) {
                    if (this.g.getLogLevel() > 8) {
                        this.printWarningMessage("Hotstart Interval Date/Time is Outside of Time Window. Not writing Hotstart file");
                    }
                } else {
                    if (this.U == null) {
                        this.U = new HecTime(hecTime2);
                    } else {
                        this.U.set(hecTime2);
                    }
                    this.U.setTimeIncrement(hotstartOptions.getTimeIncrement());
                    do {
                        this.U.setTimeIncrement(hotstartOptions.getTimeIncrement());
                        n = runTimeWindow.getStepAtTime(this.U);
                        hecTime.add(n);
                        this.U.add(hotstartOptions.getTimeStep());
                    } while (this.U.lessThanEqualTo(runTimeWindow.getEndTime()));
                    this.V = hecTime.toArray();
                }
            }
            if (hotstartOptions.shouldSaveAtEndofSim()) {
                n = runTimeWindow.getNumSteps();
                hecTime.add(n);
            }
            if (hecTime.size() > 0) {
                this.V = hecTime.toArray();
            }
        }
        if (this.g.getLogLevel() > 8) {
            System.out.println("initHotstart: saveHotstartAtInterval=" + this.T);
            if (this.V != null) {
                System.out.println("initHotstart:saveHotstartAtIntervalSteps=" + Arrays.toString(this.V));
            }
        }
    }

    public int compute3x(RunTimeWindow runTimeWindow, RssRun rssRun, int n, boolean bl) {
        int n2;
        int n3;
        this.initHotstart(runTimeWindow);
        runTimeWindow.getNumSteps();
        int n4 = this.getComputeOptions().minComputePasses;
        this.c = runTimeWindow;
        this.M = -1;
        this.N = -1;
        this.O = -1;
        this.P = -1;
        this.Q = -1;
        this.L = n;
        HotstartOptions hotstartOptions = this.h.getHotstartOptions();
        if (!this.initializeStateVariables(n)) {
            return 1;
        }
        if (bl) {
            if (hotstartOptions.shouldLoadHotstart() && n != 3) {
                int n5 = this.t.size();
                for (n3 = 0; n3 < n5; ++n3) {
                    if (this.loadHotstart(n, runTimeWindow, this.t.get(n3), n3 == n5 - 1)) continue;
                    return 1;
                }
                this.g.incrementComputeProgress(this.getElementCount() * runTimeWindow.getNumLookbackSteps());
            } else if (runTimeWindow.getNumLookbackSteps() > 0) {
                List<EmbeddedAlternative> list;
                this.printStatus("Computing Hindcast");
                int n6 = this.simulateHindcast(runTimeWindow, n);
                if (this.shouldBreakAndReturn(n6, "RssSystem.compute: Hindcast simulation failed")) {
                    return n6;
                }
                if (n == 0 && (list = rssRun.getEmbeddedAltList()) != null) {
                    for (n3 = 1; n3 <= runTimeWindow.getNumLookbackSteps(); ++n3) {
                        for (int i = 0; i < list.size(); ++i) {
                            list.get(i);
                        }
                    }
                }
                this.g.incrementComputeProgress(this.getElementCount() * runTimeWindow.getNumLookbackSteps());
            }
            if (!this.runStateVariableInitScripts(n)) {
                return 1;
            }
        }
        boolean bl2 = this.L == 0 && rssRun.shouldComputeWaterQuality() && rssRun.isCoupledWQCompute();
        WQRun wQRun = null;
        if (bl2 && this.shouldBreakAndReturn(n3 = (wQRun = rssRun.getWQRun()).initSimulation(runTimeWindow), "RssSystem.compute: WQ init simulation failed")) {
            return n3;
        }
        this.printStatus("Computing Forecast");
        RunTimeStep runTimeStep = new RunTimeStep(runTimeWindow);
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeWindow);
        int n7 = runTimeWindow.getNumSteps();
        int n8 = runTimeWindow.getNumLookbackSteps() + 1;
        List<Element> list = null;
        List<DownstreamOpRule> list2 = null;
        List<SystemHydropowerRule> list3 = null;
        List<StateVariable> list4 = null;
        List<ReservoirElement> list5 = null;
        List<PumpOpRule> list6 = null;
        ArrayList<OpRule> arrayList = null;
        boolean bl3 = false;
        int n9 = this.t.size();
        this.U = null;
        Integer n10 = Integer.getInteger("RSMAXTRIALS");
        for (int i = 0; i < n9; ++i) {
            int n5;
            int n6;
            if (this.G) {
                this.printMessage("Compute Canceled");
                return 50;
            }
            this.M = i;
            this.N = -1;
            this.O = -1;
            this.P = -1;
            this.Q = -1;
            IterationBlock iterationBlock = this.t.elementAt(i);
            if (n == 0) {
                Collection<RssTSLocationObject> collection;
                list = iterationBlock.m();
                list2 = iterationBlock.h();
                list5 = iterationBlock.i();
                list6 = iterationBlock.j();
                arrayList = new ArrayList<OpRule>();
                int n11 = list.size();
                for (int j = 0; j < n11; ++j) {
                    Object object = list.get(j);
                    if (object == null || !(object instanceof ReleaseElement)) continue;
                    object = (ReleaseElement)object;
                    object.initForecastOperations(runTimeWindow);
                    if (!(object instanceof ReservoirElement)) continue;
                    collection = ((ReservoirElement)object).getReservoirOp(false).getActiveOpSet().getRules(null);
                    arrayList.addAll(collection);
                }
                bl3 = iterationBlock.e();
                this.getTandemOp().a(iterationBlock);
                list3 = iterationBlock.k();
                n2 = this.initSystemHydropowerForecast(list3, runTimeWindow);
                if (this.shouldBreakAndReturn(n2, "RssSystem.compute: problem initializing hydropower")) {
                    return n2;
                }
                list4 = iterationBlock.l();
                if (this.L == 0 && rssRun.shouldComputeWaterQuality()) {
                    collection = rssRun.getWQRun().getWQStateVariables(iterationBlock);
                    for (StateVariable stateVariable : collection) {
                        if (list4.contains(stateVariable)) continue;
                        list4.add(stateVariable);
                    }
                }
            }
            if (n != 0 || list == null || list.size() <= 0) {
                n2 = this.simulateForecast(runTimeWindow, n, iterationBlock, bl);
                if (this.shouldBreakAndReturn(n2, "RssSystem.compute: Forecast simulation failed")) {
                    return n2;
                }
                if (bl2 && n == 0) {
                    RunTimeWindow runTimeWindow2 = runTimeWindow;
                    n2 = wQRun.simulatePeriod(runTimeWindow2, runTimeWindow2.getNumLookbackSteps() + 1, runTimeWindow.getNumSteps());
                    if (this.shouldBreakAndReturn(n2, "RssSystem.compute: WQ Forecast simulation failed")) {
                        return n2;
                    }
                }
                this.g.incrementComputeProgress(iterationBlock.c() * runTimeWindow.getForecastSteps());
                continue;
            }
            int n12 = iterationBlock.f();
            boolean n13 = true;
            if (iterationBlock.d()) {
                int n11 = 3;
            }
            if (list3.size() > 0) {
                int n14 = 4;
            }
            if (bl3) {
                n6 = 4;
            }
            if (n6 < n4) {
                int n15 = n4;
            }
            if (n10 != null) {
                n5 = n10;
            }
            this.N = 0;
            this.O = -1;
            this.P = -1;
            this.Q = -1;
            this.printStatus("Computing Operations for Block " + i + ": " + iterationBlock.c() + " Elements, " + n12 + " Routing Steps, PASS 1");
            this.simulateForecastWithLocalDecisions(runTimeWindow, n, iterationBlock, bl, n5);
            if (bl) {
                this.restoreElementState(0, iterationBlock, wQRun);
            } else {
                this.restoreElementState(5, iterationBlock, wQRun);
            }
            this.saveElementState(2, iterationBlock, wQRun);
            for (int j = 1; j < n5; ++j) {
                this.N = j;
                this.O = -1;
                this.P = -1;
                this.Q = -1;
                if (j > 1) {
                    this.restoreElementState(2, iterationBlock, wQRun);
                }
                this.printStatus("Computing Operations for Block " + i + ": " + iterationBlock.c() + " Elements, " + n12 + " Routing Steps, PASS " + (j + 1));
                for (int k = n8; k <= n7; ++k) {
                    List<EmbeddedAlternative> list7;
                    int n16;
                    int n17;
                    this.O = k;
                    this.P = -1;
                    this.Q = -1;
                    if (k > n8) {
                        this.restoreElementState(1, iterationBlock, wQRun);
                    }
                    if (this.G) {
                        this.printMessage("Compute Canceled");
                        return 50;
                    }
                    iterationBlock.a(false);
                    runTimeStep.setStep(k);
                    n2 = this.evalStateVariables(runTimeStep, list4);
                    if (this.shouldBreakAndReturn(n2, "RssSystem.compute: Error evaluating State Variables")) {
                        return n2;
                    }
                    n2 = this.evaluateSysRuleLimits(iterationBlock, runTimeStep, arrayList, list2, list3, bl3, j);
                    if (this.shouldBreakAndReturn(n2, "RssSystem.compute: Error evaluating System Rule Limits")) {
                        return n2;
                    }
                    int n18 = iterationBlock.c();
                    int n19 = n18 - 1;
                    for (n17 = 0; n17 < n18; ++n17) {
                        Element element = iterationBlock.d(n17);
                        if (!(element instanceof ReleaseElement)) continue;
                        n19 = n17;
                    }
                    this.saveElementState(3, iterationBlock, wQRun);
                    block9: for (n17 = 0; n17 < n18; ++n17) {
                        this.P = n17;
                        this.Q = -1;
                        Element element = iterationBlock.d(n17);
                        if (element instanceof ReservoirElement) {
                            ((ReservoirElement)element).getReservoirOp(false).evaluateRuleLimits(runTimeStep, j);
                        }
                        if (!(element instanceof ReleaseElement)) continue;
                        ((ReleaseElement)((Object)element)).updateDecisions(runTimeStep, j);
                        if (n17 > 0) {
                            this.restoreElementState(3, iterationBlock, wQRun);
                        }
                        for (int i2 = k; i2 < k + n12; ++i2) {
                            this.Q = i2;
                            if (this.G) {
                                this.printMessage("Compute Canceled");
                                return 50;
                            }
                            if (i2 > n7) continue block9;
                            runTimeStep2.setStep(i2);
                            n16 = i2 == k ? 1 : 0;
                            int n182 = this.simulateForecastStep(runTimeStep2, n, iterationBlock, true, bl, list5, j, n17, n16 != 0, list6);
                            if (this.shouldBreakAndReturn(n182, "RssSystem.compute: Simulate Forecast Step failed")) {
                                return n182;
                            }
                            n182 = this.evalStateVariables(runTimeStep2, list4);
                            if (this.shouldBreakAndReturn(n182, "RssSystem.compute: Evalulate State Variables failed")) {
                                return n182;
                            }
                            if (bl2 && i2 == k && j == n5 - 1 && n17 == n19 && this.shouldBreakAndReturn(n182 = wQRun.simulateStep(runTimeStep2, j, runTimeWindow), "RssSystem.compute: WQ Forecast Step failed")) {
                                return n182;
                            }
                            if (i2 != k) continue;
                            this.saveElementState(1, iterationBlock, wQRun);
                            if (k == n7 - runTimeWindow.getNumRoutingSteps()) {
                                this.saveElementState(5, iterationBlock, wQRun);
                            }
                            if (!this.b) continue;
                            this.checkSaveHotstart(runTimeStep.getStep(), n, iterationBlock.a);
                        }
                    }
                    if (i == n9 - 1 && j == n5 - 1 && (list7 = rssRun.getEmbeddedAltList()) != null) {
                        n2 = list7.size();
                        for (n16 = 0; n16 < n2; n16 += 1) {
                            EmbeddedAlternative embeddedAlternative = list7.get(n16);
                            if (embeddedAlternative == null) continue;
                            int n20 = k;
                            if (embeddedAlternative.computeTimeStep(n20, n20 - n8 + 1, n12, rssRun) == 0) continue;
                            this.printErrorMessage("ResSim ERROR: Failed to compute embedded alternative");
                            return 1;
                        }
                    }
                    this.g.incrementComputeProgress((double)iterationBlock.c() / (double)n5);
                }
            }
            this.evaluateRulePerformance(runTimeWindow, list, list2, list3, bl3);
        }
        if (n == 0 && this.v != null) {
            for (int i = n8; i <= n7; ++i) {
                if (this.G) {
                    this.printMessage("Compute Canceled");
                    return 50;
                }
                runTimeStep.setStep(i);
                n2 = this.evalStateVariables(runTimeStep, this.v);
                if (!this.shouldBreakAndReturn(n2, "RssSystem.compute: Error Evaulating State Variables")) continue;
                return n2;
            }
        }
        return 0;
    }

    private boolean shouldBreakAndReturn(int n, String string) {
        if (n != 0) {
            if (n == 50) {
                return true;
            }
            this.printErrorMessage(string);
            return true;
        }
        return false;
    }

    private void restoreElementState(int n, IterationBlock iterationBlock, WQRun wQRun) {
        iterationBlock.f(n);
        if (wQRun != null) {
            try {
                wQRun.restoreElementState(n);
                return;
            }
            catch (WQException wQException) {
                wQRun.printWQErrorMessages(wQException);
            }
        }
    }

    private void saveElementState(int n, IterationBlock iterationBlock, WQRun wQRun) {
        iterationBlock.e(n);
        if (wQRun != null) {
            try {
                wQRun.saveElementState(n);
                return;
            }
            catch (WQException wQException) {
                wQRun.printWQErrorMessages(wQException);
            }
        }
    }

    void checkSaveHotstart(int n, int n2, List list) {
        if (this.T != -1 && n == this.T && n2 != 3) {
            this.saveHotstartState(n2, n, list);
        }
        if (this.V != null && Arrays.binarySearch(this.V, n) >= 0 && n2 != 3) {
            this.h.getHotstartOptions();
            this.saveHotstartState(n2, n, list);
        }
    }

    private void saveHotstartState(int n, int n2, List list) {
        NetworkHotstartState networkHotstartState;
        HotstartContainer hotstartContainer;
        if (this.g.getLogLevel() > 8) {
            System.out.println("saveHotstartState:saving at step " + n2 + " for computeType=" + n);
        }
        HotstartOptions hotstartOptions = this.h.getHotstartOptions();
        hotstartOptions.getSaveAtDateTime();
        int n3 = 1;
        if (hotstartOptions.shouldSaveAtEndofSim() && this.V != null && n2 == this.V[this.V.length - 1]) {
            n3 = 0;
        }
        HecTime hecTime = new HecTime(this.c.getTimeAtStep(n2 - n3));
        hecTime.setTimeIncrement(2);
        hecTime.showTimeAsBeginningOfDay(false);
        String string = hecTime.dateAndTime(4);
        if ("00:00".equals(hecTime.time())) {
            hecTime.setTime("0000");
            string = hecTime.dateAndTime(4);
        }
        if ((hotstartContainer = this.S.get(string)) == null) {
            hotstartContainer = new HotstartContainer(this);
            hotstartContainer.setTime(hecTime);
            hotstartContainer.setHoursToSave(hotstartOptions.getHoursToSave());
            this.S.put(string, hotstartContainer);
        }
        if ((networkHotstartState = hotstartContainer.get(string = String.valueOf(n).concat("-").concat(hecTime.dateAndTime(104)))) == null) {
            networkHotstartState = new NetworkHotstartState(this, new HecTime(hecTime), n);
            hotstartContainer.put(string, networkHotstartState);
        }
        n = 4;
        if (this.V != null && Arrays.binarySearch(this.V, n2) == 0 && hotstartOptions.shouldSaveAtLookback()) {
            n = 0;
        }
        this.X = new RunTimeStep(this.c);
        this.X.step = n2;
        networkHotstartState.saveState(list, n);
    }

    private int evaluateRulePerformance(RunTimeWindow runTimeWindow, List<Element> object, List<DownstreamOpRule> list, List<SystemHydropowerRule> list2, boolean n) {
        int n2;
        n = object.size();
        ArrayList<OpRule> arrayList = new ArrayList<OpRule>();
        for (n2 = 0; n2 < n; ++n2) {
            Element element = object.get(n2);
            if (!(element instanceof ReservoirElement)) continue;
            arrayList.clear();
            ((ReservoirElement)element).getReservoirOp(false).getActiveOpSet().getRules(arrayList);
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                OpRule opRule = (OpRule)arrayList.get(i);
                opRule.evaulatePerformance(runTimeWindow);
            }
        }
        if (list != null) {
            n = list.size();
            for (n2 = 0; n2 < n; ++n2) {
                object = list.get(n2);
                if (object == null) continue;
                ((OpRule)object).evaulatePerformance(runTimeWindow);
            }
        }
        return 0;
    }

    public int simulateHindcast(RunTimeWindow runTimeWindow, int n) {
        int n2 = this.r.length;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < n2; ++j) {
                Element element;
                if (this.G) {
                    this.printMessage("Compute Canceled");
                    return 50;
                }
                int n3 = this.r[j];
                if (n3 < 0 || (element = (Element)this.s.elementAt(n3)) == null) continue;
                this.X = new RunTimeStep(runTimeWindow);
                this.X.step = 0;
                if (i == 0) {
                    element.saveElementState(6);
                } else {
                    element.restoreElementState(6);
                }
                if (this.g.getLogLevel() >= 8) {
                    this.printLogMessage("Computing hindcast for " + element.getName());
                }
                if (element.computeHindcast(runTimeWindow, n) != 0) {
                    this.printErrorMessage("RssSystem.simulateHindcast: Hindcast compute failed for element " + element.getName());
                    return 1;
                }
                this.X = new RunTimeStep(runTimeWindow);
                this.X.step = runTimeWindow.getNumLookbackSteps();
                element.saveElementState(0);
                if (i <= 0) continue;
                element.saveElementState(0);
            }
        }
        if (n == 0) {
            List<StateVariable> list = this._stateVariableList;
            this.evalStateVariableHindast(runTimeWindow, list);
            int n4 = this.evalWaterAccountsHindast(runTimeWindow);
            if (n4 == 1) {
                return 1;
            }
        }
        return 0;
    }

    public int simulateForecastStep(RunTimeStep runTimeStep, int n, IterationBlock object, boolean bl, boolean bl2, List list, int n2, int n3, boolean bl3, List list2) {
        int n4 = ((IterationBlock)object).c();
        for (n = 0; n < n4; ++n) {
            Element element = ((IterationBlock)object).d(n);
            if (element == null || !element.isDirty() && !bl || element.computeForecastStep(runTimeStep) == 0) continue;
            this.printErrorMessage("RssSystem.simulateForecast: Forecast compute failed for element " + element.getName());
            return 1;
        }
        bl = false;
        if (bl3 && n3 == ((IterationBlock)object).n()) {
            bl = true;
        }
        if (list != null && n2 > 0) {
            n4 = list.size();
            for (n = 0; n < n4; ++n) {
                object = (ReservoirElement)list.get(n);
                ((ReservoirElement)object).initPumpbackStep(runTimeStep);
            }
            for (n = 0; n < n4; ++n) {
                object = (ReservoirElement)list.get(n);
                ((ReservoirElement)object).computePumpbackStep(runTimeStep);
            }
            if (this.h.getWaterAccountSet() != null && bl) {
                this.evalWAForPumpback(runTimeStep, list2);
            }
        }
        return 0;
    }

    private void evalWAForPumpback(RunTimeStep runTimeStep, List object) {
        double d;
        HashMap<ReservoirElement, Double> hashMap = new HashMap<ReservoirElement, Double>();
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            NamedType namedType = (PumpOpRule)object.get(i);
            ReservoirElement reservoirElement = (ReservoirElement)namedType.getOperationsElement();
            ReservoirElement reservoirElement2 = namedType.getSourceReservoir();
            double d2 = namedType.getPumpRuleFlow(runTimeStep);
            if (hashMap.containsKey(reservoirElement)) {
                d = (Double)hashMap.get(reservoirElement);
                d += d2;
            } else {
                d = d2;
            }
            hashMap.put(reservoirElement, d);
            if (hashMap.containsKey(reservoirElement2)) {
                d = (Double)hashMap.get(reservoirElement2);
                d -= d2;
            } else {
                d = -d2;
            }
            hashMap.put(reservoirElement2, d);
        }
        for (NamedType namedType : hashMap.keySet()) {
            d = (Double)hashMap.get(namedType);
            WaterAccount waterAccount = namedType.getDefaultWaterAccount();
            if (waterAccount == null) continue;
            if (d > 0.0) {
                waterAccount.updatePumpbackDestinationAllAccounts(runTimeStep, d);
                continue;
            }
            waterAccount.updatePumpbackSource(runTimeStep, d);
        }
    }

    public int simulateForecast(RunTimeWindow runTimeWindow, int n, IterationBlock iterationBlock, boolean bl) {
        for (int i = 0; i < iterationBlock.c(); ++i) {
            if (this.G) {
                this.printMessage("Compute Canceled");
                return 50;
            }
            Element element = iterationBlock.d(i);
            if (element == null) continue;
            this.X = new RunTimeStep(runTimeWindow);
            this.X.step = runTimeWindow.getNumLookbackSteps();
            if (bl) {
                element.restoreElementState(0);
            } else {
                element.restoreElementState(4);
            }
            if (element.computeForecast(runTimeWindow, n) == 0) continue;
            this.printErrorMessage("RssSystem.simulateForecast: Forecast compute failed for element " + element.getName());
            return 1;
        }
        return 0;
    }

    public int simulateForecastWithLocalDecisions(RunTimeWindow runTimeWindow, int n, IterationBlock iterationBlock, boolean bl, int n2) {
        Element element;
        int n3 = iterationBlock.c();
        RunTimeStep runTimeStep = new RunTimeStep(runTimeWindow);
        int n4 = runTimeWindow.getNumLookbackSteps() + 1;
        int n5 = runTimeWindow.getNumSteps();
        int n6 = n5 - n4 + 1;
        for (n = 0; n < n3; ++n) {
            element = iterationBlock.d(n);
            if (element == null) continue;
            this.X = new RunTimeStep(runTimeWindow);
            this.X.step = runTimeWindow.getNumLookbackSteps();
            if (bl) {
                element.restoreElementState(0);
                continue;
            }
            element.restoreElementState(4);
        }
        for (n = 0; n < n3; ++n) {
            element = iterationBlock.d(n);
            if (element == null) continue;
            for (int i = n4; i <= n5; ++i) {
                if (this.G) {
                    this.printMessage("Compute Canceled");
                    return 50;
                }
                runTimeStep.setStep(i);
                if (element instanceof ReservoirElement) {
                    ((ReservoirElement)element).getReservoirOp(false).evaluateRuleLimits(runTimeStep, 0);
                }
                if (element instanceof ReleaseElement) {
                    ((ReleaseElement)((Object)element)).updateDecisions(runTimeStep, 0);
                }
                if (element.computeForecastStep(runTimeStep) == 0) continue;
                this.printErrorMessage("RssSystem.simulateForecastWithLocalDecisions: Forecast compute failed for element " + element.getName());
                return 1;
            }
            this.g.incrementComputeProgress((double)n6 / (double)n2);
        }
        return 0;
    }

    public void setOperations(Operations operations) {
        this.i = operations;
    }

    public void setInputTSDataSet(TSDataSet tSDataSet) {
        this.j = tSDataSet;
    }

    public TSDataSet getInputTSDataSet() {
        return this.j;
    }

    public GVDataSet getInputGvDataSet() {
        return this.k;
    }

    public GVDataSet getOutputGVDataSet() {
        return this.l;
    }

    public void setOutputTSDataSet(TSDataSet tSDataSet) {
        this.m = tSDataSet;
    }

    public TSDataSet getOutputTSDataSet() {
        return this.m;
    }

    public RssNode findNode(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = this._nodeVector.size();
        for (int i = 0; i < n; ++i) {
            RssNode rssNode = (RssNode)this._nodeVector.elementAt(i);
            if (rssNode == null || !string.equals(rssNode.getName())) continue;
            return rssNode;
        }
        return null;
    }

    public RssNode getNode(int n) {
        RssNode rssNode = (RssNode)this.q.get(n);
        if (rssNode != null) {
            return rssNode;
        }
        int n2 = this._nodeVector.size();
        for (int i = 0; i < n2; ++i) {
            rssNode = (RssNode)this._nodeVector.elementAt(i);
            if (rssNode == null || rssNode.getIndex() != n) continue;
            this.q.put(n, rssNode);
            return rssNode;
        }
        return null;
    }

    public boolean readFile(Identifier object) {
        boolean bl;
        boolean bl2;
        Object object2;
        Object object32;
        HecFile hecFile = object.getFile();
        java.util.logging.Logger.getLogger(RssSystem.class.getName()).info("opening file " + hecFile.getName());
        this.D.clear();
        this.W = false;
        try {
            object32 = hecFile.getBufferedReader();
            object2 = new HecAsciiDeserializer((BufferedReader)object32);
            object2.addClassMapping("hec.model.TSRecordProxy", TSRecordProxy.class.getName());
            object2.addClassMapping("hec.model.TSDataSet", TSDataSet.class.getName());
            object2.addClassMapping("hec.rss.model.WaterControlDevice", GatedIntakeControlDevice.class.getName());
            this.y = RMAIO.getDirectoryFromPath((String)object.getPath());
            object2.setDssFileManager((BaseDSSManager)this.getDSSFileManager());
            object2.setFileManager(this.getFileManager());
            object2.setWorkspacePath(this.y);
            bl2 = object2.deserializeObject((Object)this);
            this.y = null;
            this.a = null;
            ((BufferedReader)object32).close();
        }
        catch (IOException iOException) {
            this.printErrorMessage("Failed to open file " + object.getPath());
            return false;
        }
        this.setModified(false);
        if (!bl2) {
            this.printErrorMessage("Failed to correctly read file " + object.getPath());
        }
        if (this._version != 2029) {
            object2 = "\nNetwork " + this.getDisplayName() + " marked as modified.  The network was created in an earlier version and will be converted to the latest version.";
            this.printMessage((String)object2);
            System.out.println((String)object2);
            this.W = true;
        }
        if (this._version < 1000) {
            this.removeOldOutflowNaming();
            this.setModified(true);
        }
        if (this._version < 1001) {
            this.addSpaceBeforeTailwater();
            this.setModified(true);
        }
        if (this._version < 1002) {
            this.renameDiversionNode();
            this.setModified(true);
        }
        if (this._version < 1003) {
            this.printErrorMessage("RssSystem.readFile: This data set is too old to be opened directly with current version of ResSim");
            this.printErrorMessage("Please open and save this data set with version 2.0 or earlier of ResSim before opening with the current version.");
            return false;
        }
        if (this._version < 1004) {
            this.generateReservoirOp();
        }
        if (this._version < 1004) {
            this.replaceNodeObjects();
        }
        if (this._version < 1006) {
            this.renameStorElevTSProxies();
        }
        if (this._version < 1007) {
            this.renameSpillTSProxies();
        }
        if (this._version < 1008) {
            this.convertRoutingFunctionsToWatershedUnits();
        }
        if (this._version < 1011) {
            this.renameDamElementChildren();
        }
        if (this._version < 1012) {
            this.renameResChildrenUpNodes();
        }
        if (this._version < 1013) {
            this.convertResSysOps();
        }
        if (this._version < 1014) {
            this.convertOldRoutingFunctions();
        }
        if (this._version < 1015) {
            this.addOutputFlowProxyToLocalFlowNodes();
        }
        if (this._version < 1016) {
            this.updatePowerPlantFlows();
        }
        if (this._version < 1017) {
            this.updateRuleRefTables();
        }
        if (this._version < 1018 && !Boolean.getBoolean("ResSim.noOpRuleConversion") && (bl = this.convertRules())) {
            this.setModified(true);
        }
        if (this._version < 1019) {
            this.renameDamElements();
        }
        if (this._version < 1022) {
            this.updateZoneFunction();
        }
        if (this._version < 1023) {
            this.updateIfBlockNames();
        }
        this.updateReachElementRoutingToTimeStep();
        this.updateDiversionAndDivertedOutletElementsToTimeStep();
        if (this._version < 1027) {
            this.updateVerticalDatum();
        }
        if (this._version < 1028) {
            this.Z = true;
            this._modified = true;
        }
        if (this._version < 1030) {
            this.createDefaultDiversionOps();
        }
        if (this._version < 3005) {
            this.resetParentElement();
        }
        this.cleanVectors();
        if (this._downstreamOpTable != null) {
            Enumeration enumeration = this._downstreamOpTable.keys();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                object32 = (DownstreamOp)this._downstreamOpTable.get(object);
                ((DownstreamOp)object32).setSystem(this);
            }
        }
        if (this._systemHydropowerRuleTable != null) {
            Collection collection = this._systemHydropowerRuleTable.values();
            for (Object object32 : collection) {
                ((OpRule)object32).setSystem(this);
            }
        }
        this.updateTSProxyList();
        Vector vector = this.getElementVectorByClass(ReservoirElement.class.getName());
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                object = (ReservoirElement)vector.get(i);
                ((ReservoirElement)object).updateSegments();
            }
        }
        return bl2;
    }

    private void createDefaultDiversionOps() {
        Vector<DiversionElement> vector = this.getElementVectorByClass(DiversionElement.class);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            vector.get(i).updateOperations(this);
        }
    }

    private void updateReachElementRoutingToTimeStep() {
        Object object = this.getElementVectorByClass(ReachElement.class);
        object = ((Vector)object).iterator();
        while (object.hasNext()) {
            ReachElement reachElement = (ReachElement)object.next();
            Object object2 = reachElement.getDefinedTimeStepDurations();
            if (object2 != null && ((Duration[])object2).length != 0 || (object2 = reachElement.getFunction()) == null) continue;
            reachElement.putFunction(TimeStepUtil.TIME_STEP_ALL.getDuration(), (Function)object2);
        }
    }

    public void updateDiversionAndDivertedOutletElementsToTimeStep() {
        Vector<DiversionElement> vector2 = this.getElementVectorByClass(DiversionElement.class);
        for (DiversionElement diversionElement : vector2) {
            diversionElement.convertRoutingElement();
        }
        Vector<ReservoirElement> vector = this.getElementVectorByClass(ReservoirElement.class);
        for (ReservoirElement reservoirElement : vector) {
            int n = ((Element)reservoirElement).getChildElementCount();
            for (int i = 0; i < n; ++i) {
                Element element = ((Element)reservoirElement).getChildElementAt(i);
                if (!(element instanceof DivertedOutletElement)) continue;
                element = (DivertedOutletElement)element;
                ((DivertedOutletElement)element).convertRoutingElement();
            }
        }
    }

    private void updateVerticalDatum() {
        VerticalDatumSettings verticalDatumSettings;
        Object object;
        Object object2 = this.getElementVectorByClass(ReservoirElement.class.getName());
        object2 = ((Vector)object2).iterator();
        while (object2.hasNext()) {
            object = object2.next();
            verticalDatumSettings = ((ReservoirElement)object).getVerticalDatumSettings();
            if (!VerticalDatumType.OTHER.equals((Object)verticalDatumSettings.getType()) || verticalDatumSettings.getLocalShiftToNAVD88() != 0.0 || !verticalDatumSettings.getLocalName().equalsIgnoreCase("Undef")) continue;
            verticalDatumSettings.setType(VerticalDatumType.UNSPECIFIED);
            verticalDatumSettings.setLocalName("");
        }
        object2 = this.getElementVectorByClass(JunctionElement.class.getName());
        object = ((Vector)object2).iterator();
        while (object.hasNext()) {
            verticalDatumSettings = object.next();
            object2 = ((Junction)((Element)((Object)verticalDatumSettings)).getFunction()).getVerticalDatumSettings();
            if (!VerticalDatumType.OTHER.equals((Object)((VerticalDatumSettings)object2).getType()) || ((VerticalDatumSettings)object2).getLocalShiftToNAVD88() != 0.0 || !((VerticalDatumSettings)object2).getLocalName().equalsIgnoreCase("Undef")) continue;
            ((VerticalDatumSettings)object2).setType(VerticalDatumType.UNSPECIFIED);
            ((VerticalDatumSettings)object2).setLocalName("");
        }
    }

    private void updateIfBlockNames() {
        Vector<ReservoirElement> vector = this.getElementVectorByClass(ReservoirElement.class);
        HashMap<String, Set<ConditionalBlock>> hashMap = new HashMap<String, Set<ConditionalBlock>>();
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            int n;
            Object object2;
            ConditionalBlock conditionalBlock2;
            int n2;
            Object object3 = vector.get(i);
            ReservoirOp reservoirOp = ((ReservoirElement)object3).getReservoirOp();
            if (reservoirOp == null) continue;
            System.out.println("updateIfBlockNames:processing reservoir " + object3.getName());
            hashMap.clear();
            object3 = reservoirOp.getConditionalBlocks();
            for (n2 = 0; n2 < object3.size(); ++n2) {
                conditionalBlock2 = (ConditionalBlock)object3.get(n2);
                if (conditionalBlock2 == null) continue;
                this.addConditionalBlockToMap(conditionalBlock2, hashMap);
            }
            for (n2 = 0; n2 < object3.size(); ++n2) {
                conditionalBlock2 = (ConditionalBlock)object3.get(n2);
                object2 = conditionalBlock2.getConditionals();
                for (n = 0; n < object2.size(); ++n) {
                    object = (RssConditional)object2.get(n);
                    this.getIfBlocks((RssConditional)object, hashMap, reservoirOp);
                }
            }
            this.updateConditionalBlockIndexes(hashMap, reservoirOp);
            Collection collection = hashMap.values();
            object2 = collection.iterator();
            object = new ArrayList();
            while (object2.hasNext()) {
                Set set = (Set)object2.next();
                Iterator iterator = set.iterator();
                object.clear();
                while (iterator.hasNext()) {
                    conditionalBlock2 = (ConditionalBlock)iterator.next();
                    String string = conditionalBlock2.getName();
                    if ((string = reservoirOp.getConditionalBlock(string)) != null && string == conditionalBlock2) continue;
                    object.add(conditionalBlock2);
                    bl = true;
                }
                if (set.size() > 1) {
                    n = 1;
                    for (ConditionalBlock conditionalBlock2 : set) {
                        String string = conditionalBlock2.getName();
                        conditionalBlock2.setName(string + " (" + n++ + ")");
                        System.out.println("updateIfBlockNames:changed If Block name from " + string + " @" + System.identityHashCode(conditionalBlock2) + " to " + conditionalBlock2.getName());
                        bl = true;
                    }
                }
                for (int j = 0; j < object.size(); ++j) {
                    conditionalBlock2 = (ConditionalBlock)object.get(j);
                    System.out.println("updateIfBlockNames:adding " + conditionalBlock2.getName() + " to ReservoirOp " + reservoirOp.getName());
                    int n3 = conditionalBlock2.getIndex();
                    reservoirOp.addConditionablock(conditionalBlock2);
                    conditionalBlock2.setIndex(n3);
                }
            }
            for (int j = 0; j < object3.size(); ++j) {
                conditionalBlock2 = (ConditionalBlock)object3.get(j);
                this.replaceConditionalBlockWithRef(conditionalBlock2);
            }
        }
        if (bl) {
            this.setModified(bl);
        }
    }

    private void updateConditionalBlockIndexes(Map<String, Set<ConditionalBlock>> iterator, ReservoirOp reservoirOp) {
        Object object;
        int n;
        Object object2;
        Object object3;
        Cloneable cloneable = new HashMap<Integer, ArrayList<ConditionalBlock>>();
        iterator = iterator.values();
        iterator = iterator.iterator();
        Vector<OpSet> vector = reservoirOp.getOperationSets();
        for (int i = 0; i < vector.size(); ++i) {
            object3 = (OpSet)vector.get(i);
            if (object3 == null) continue;
            object2 = ((OpSet)object3).getZoneVector();
            for (int j = 0; j < ((Vector)object2).size(); ++j) {
                StorageZone storageZone = (StorageZone)((Vector)object2).get(j);
                if (storageZone == null) continue;
                List list = storageZone.getConditionalBlockRefs(null);
                for (n = 0; n < list.size(); ++n) {
                    ConditionalBlockRef conditionalBlockRef = (ConditionalBlockRef)list.get(n);
                    if (conditionalBlockRef == null || (object = conditionalBlockRef.getConditionalBlock()) != null) continue;
                    System.out.println("updateConditionalBlockIndexes:WARNING: failed to retrieve ConditionalBLock for " + conditionalBlockRef.getName() + " Index:" + conditionalBlockRef.getConditionalBlockId() + " reservoirop:" + String.valueOf(object3) + " ZoNe:" + String.valueOf(storageZone));
                }
            }
        }
        while (iterator.hasNext()) {
            object3 = iterator.next();
            object3 = object3.iterator();
            while (object3.hasNext()) {
                object = object3.next();
                ArrayList<ConditionalBlock> arrayList = (ArrayList<ConditionalBlock>)cloneable.get(object.getIndex());
                if (arrayList == null) {
                    arrayList = new ArrayList<ConditionalBlock>();
                    cloneable.put(object.getIndex(), arrayList);
                }
                arrayList.add((ConditionalBlock)object);
            }
        }
        Collection collection = cloneable.values();
        object2 = collection.iterator();
        n = 0;
        while (object2.hasNext()) {
            List list = (List)object2.next();
            for (int i = 1; i < list.size(); ++i) {
                int n2 = reservoirOp.nextConditionalBlockIndex();
                object = (ConditionalBlock)list.get(i);
                int n3 = object.getIndex();
                object.setIndex(n2);
                System.out.println("updateConditionalBlockIndexes:set new index on conditionalBlock " + String.valueOf(object) + " old:" + n3 + " new:" + n2);
                n = 1;
            }
        }
        if (n != 0) {
            this.setModified(true);
        }
        for (int i = 0; i < vector.size(); ++i) {
            OpSet opSet = (OpSet)vector.get(i);
            if (opSet == null) continue;
            cloneable = opSet.getZoneVector();
            for (int j = 0; j < ((Vector)cloneable).size(); ++j) {
                object = (StorageZone)((Vector)cloneable).get(j);
                if (object == null) continue;
                object = ((StorageZone)object).getConditionalBlockRefs(null);
                for (int k = 0; k < object.size(); ++k) {
                    object2 = (ConditionalBlockRef)object.get(k);
                    if (object2 == null) continue;
                    ((ConditionalBlockRef)object2).updateReference();
                    this.updateConditionalBlockRefs((ConditionalBlockRef)object2);
                }
            }
        }
        reservoirOp.getConditionalBlocks();
    }

    private void updateConditionalBlockRefs(ConditionalBlockRef object) {
        if ((object = ((ConditionalBlockRef)object).getConditionalBlock()) != null) {
            object = object.getConditionals();
            for (int i = 0; i < object.size(); ++i) {
                Object object2 = (RssConditional)object.get(i);
                object2 = ((RssConditional)object2).getConditionalBlockRefs(null);
                for (int j = 0; j < object2.size(); ++j) {
                    ConditionalBlockRef conditionalBlockRef = (ConditionalBlockRef)object2.get(j);
                    conditionalBlockRef.updateReference();
                    this.updateConditionalBlockRefs(conditionalBlockRef);
                }
            }
        }
    }

    private void getIfBlocks(RssConditional object, Map<String, Set<ConditionalBlock>> map, ReservoirOp reservoirOp) {
        object = ((RssConditional)object).getConditionalBlocks(null);
        for (int i = 0; i < object.size(); ++i) {
            Object object2 = object.get(i);
            if (!(object2 instanceof ConditionalBlock)) continue;
            object2 = (ConditionalBlock)object2;
            this.addConditionalBlockToMap((ConditionalBlock)object2, map);
            object2 = object2.getConditionals();
            for (int j = 0; j < object2.size(); ++j) {
                RssConditional rssConditional = (RssConditional)object2.get(j);
                this.getIfBlocks(rssConditional, map, reservoirOp);
            }
        }
    }

    private void replaceConditionalBlockWithRef(ConditionalBlock object) {
        object = object.getConditionals();
        for (int i = 0; i < object.size(); ++i) {
            RssConditional rssConditional = (RssConditional)object.get(i);
            List<RssConditionalBlock> list = rssConditional.getConditionalBlocks(null);
            for (int j = 0; j < list.size(); ++j) {
                RssConditionalBlock rssConditionalBlock = list.get(j);
                if (!(rssConditionalBlock instanceof ConditionalBlock)) continue;
                rssConditionalBlock = rssConditionalBlock;
                ConditionalBlockRef conditionalBlockRef = new ConditionalBlockRef(rssConditional, rssConditionalBlock);
                rssConditional.updateConditionaBlockWithRef(rssConditionalBlock, conditionalBlockRef);
                this.replaceConditionalBlockWithRef(rssConditionalBlock);
            }
        }
    }

    private void addConditionalBlockToMap(ConditionalBlock conditionalBlock, Map<String, Set<ConditionalBlock>> map) {
        Set<ConditionalBlock> set = map.get(conditionalBlock.getName());
        if (set == null) {
            set = new LinkedHashSet<ConditionalBlock>();
            map.put(conditionalBlock.getName(), set);
        }
        set.add(conditionalBlock);
    }

    public boolean writeFile(Identifier object) {
        Object object2;
        int n;
        Object object3;
        Object object4;
        Map<String, String> map;
        List<NetworkMigration> list;
        block17: {
            if (this.getReadOnly()) {
                System.out.println("File " + object.getFile().getPath() + " is marked readonly");
                return false;
            }
            RssSystem rssSystem = this;
            list = rssSystem.getRssSystemUpdates(rssSystem._version);
            map = this.preWriteUpdates((Identifier)object, list);
            this._version = 2029;
            super.writeFile(object);
            object4 = object.getFile();
            System.out.println("writing " + object4.getPath());
            object3 = this.getResSimVersionStamp();
            if (object3 != null) {
                this._ressimVersion = object3;
            }
            this.setReloadOk(false);
            object3 = object4.getBufferedWriter();
            if (object3 != null) break block17;
            return false;
        }
        try {
            ((Writer)object3).write("System Name=" + this.getName());
            ((BufferedWriter)object3).newLine();
            ((BufferedWriter)object3).newLine();
            n = object4.getPath().lastIndexOf(".");
            if (n >= 0) {
                object2 = object4.getPath().substring(0, n);
                object2 = object2.concat(".dss");
                this.a = object2;
            }
            object2 = new HecAsciiSerializer((BufferedWriter)object3);
            this.y = RMAIO.getDirectoryFromPath((String)object.getPath());
            object2.setWorkspacePath(this.y);
            object2.setFileManager(this.getFileManager());
            object2.setDssFileManager((BaseDSSManager)this.getDSSFileManager());
            if (!object2.serializeObject((Object)this)) {
                RssSystem rssSystem = this;
                rssSystem.printErrorMessage("Failed to save " + rssSystem.getName() + " to file " + object4.getPath());
            }
            this.y = null;
            this.a = null;
        }
        catch (IOException iOException) {
            this.printMessage("Failed to open file " + object.getPath());
            return false;
        }
        for (n = 0; n < this._elementVector.size(); ++n) {
            object2 = this._elementVector.get(n);
            if (!(object2 instanceof ReservoirElement)) continue;
            object = (ReservoirElement)object2;
            object4 = object.getReservoirOp();
            this.saveReservoirOp((ReservoirOp)object4, object._resOpDbfId);
        }
        if (this.F != null) {
            for (n = 0; n < this.F.size(); ++n) {
                Object object5 = object2 = (ReservoirSysOp)this.F.get(n);
                this.saveReservoirSysOp((ReservoirSysOp)object5, object5.getIndex());
            }
        }
        RssSystem rssSystem = this;
        rssSystem.deleteReservoirOps(rssSystem.D);
        RssSystem rssSystem2 = this;
        rssSystem2.deleteReservoirSysOps(rssSystem2.E);
        try {
            ((BufferedWriter)object3).flush();
            ((BufferedWriter)object3).close();
        }
        catch (Exception exception) {
            System.out.println("An error occured trying flush/close the output stream");
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
        finally {
            this.setModified(false);
            this.setReloadOk(true);
            this.W = false;
        }
        this.postWriteUpdates(map, list);
        return true;
    }

    private String getResSimVersionStamp() {
        return VersionUtilities.getApplicationVersion(RSS.class);
    }

    private Map<String, String> preWriteUpdates(Identifier object, List<NetworkMigration> object2) {
        object = new LinkedHashMap();
        if (this.Z) {
            object.put("getPath", this._identifier.getPath());
            object.put("_version", Integer.toString(this._version));
            object2 = object2.iterator();
            while (object2.hasNext()) {
                NetworkMigration networkMigration = (NetworkMigration)object2.next();
                networkMigration.preWrite(this, (Map<String, String>)object);
            }
        }
        return object;
    }

    private List<NetworkMigration> getRssSystemUpdates(int n) {
        ArrayList<NetworkMigration> arrayList = new ArrayList<NetworkMigration>();
        if (V1028Migration.a(n)) {
            arrayList.add(new V1028Migration());
        }
        return arrayList;
    }

    private void postWriteUpdates(Map<String, String> map, List<NetworkMigration> object) {
        if (this.Z && map != null) {
            object = object.iterator();
            while (object.hasNext()) {
                NetworkMigration networkMigration = (NetworkMigration)object.next();
                networkMigration.postWrite(this, map);
            }
            this.Z = false;
        }
    }

    public int getVersion() {
        return this._version;
    }

    public String getLastSavedInResSimVersion() {
        if (this._ressimVersion != null) {
            return this._ressimVersion;
        }
        return "unknown";
    }

    private boolean convertRules() {
        Vector<ReservoirElement> vector = this.getElementVectorByClass(ReservoirElement.class);
        if (vector == null || vector.size() == 0) {
            return false;
        }
        this.updateTSProxyList();
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            Cloneable cloneable = vector.get(i);
            if ((cloneable = ((ReservoirElement)cloneable).getReservoirOp()) == null) continue;
            cloneable = ((ReservoirOp)cloneable).getControllers();
            int n = ((Vector)cloneable).size();
            for (int j = 0; j < n; ++j) {
                OpController opController = (OpController)((Vector)cloneable).get(j);
                try {
                    if (!this.convertRules(opController._ruleTable)) continue;
                    bl = true;
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("convertRules:Error converting rules for " + String.valueOf(opController));
                    exception.printStackTrace(System.out);
                }
            }
        }
        return bl;
    }

    private boolean convertRules(Map map) {
        int n;
        if (map == null) {
            return false;
        }
        Object object = map.keySet();
        object = object.iterator();
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList();
        while (object.hasNext()) {
            arrayList2.add(object.next());
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            Object object2 = (intContainer)arrayList2.get(n);
            object = (OpRule)map.get(object2);
            if (object instanceof SpecFlowOpRule) {
                System.out.println("convertRules: converting Specified Flow Rule " + object.getName());
                var9_14 = (SpecFlowOpRule)object;
                ReleaseFuncOpRule releaseFuncOpRule = new ReleaseFuncOpRule(object.getName());
                releaseFuncOpRule.setDescription(object.getDescription());
                releaseFuncOpRule.setIndex(object.getIndex());
                releaseFuncOpRule.setController(((OpRule)object).getController());
                releaseFuncOpRule.setTimeInterpolationType(var9_14.getInterpolationType());
                var10_15 = var9_14.getSeasonalRecord();
                releaseFuncOpRule.setSeasonalRecord((SeasonalRecord)var10_15);
                releaseFuncOpRule.setIndependentVariable(new IndependentVariable(1));
                if (var9_14.riseFallConditionIsValid() && var9_14.getEnableRiseFallCondition()) {
                    releaseFuncOpRule.setEnableRiseFallCondition(true);
                    releaseFuncOpRule.setRiseFallCondition(var9_14.getRiseFallCondition());
                    releaseFuncOpRule.setRiseFallTolerance(var9_14.getRiseFallTolerance());
                    releaseFuncOpRule.setParameterType(var9_14.getParameterType());
                    releaseFuncOpRule.setAveragingPeriod(var9_14.getAveragingPeriod());
                }
                if ((var11_16 = var9_14.getMultiplier()) == null || ((DayOfWeekMultiplier)var11_16).isDefaults()) {
                    releaseFuncOpRule.setUseDayOfWeekMultiplier(false);
                } else {
                    releaseFuncOpRule.setUseDayOfWeekMultiplier(true);
                    releaseFuncOpRule.setMultiplier((DayOfWeekMultiplier)var11_16);
                }
                map.put(object2, releaseFuncOpRule);
            } else if (object instanceof ElevReleaseOpRule) {
                System.out.println("convertRules: converting Elevation Release Rule " + object.getName());
                var9_14 = (ElevReleaseOpRule)object;
                ReleaseFuncOpRule releaseFuncOpRule = new ReleaseFuncOpRule(object.getName());
                releaseFuncOpRule.setDescription(object.getDescription());
                releaseFuncOpRule.setIndex(object.getIndex());
                releaseFuncOpRule.setController(((OpRule)object).getController());
                var5_13 = new IndependentVariable(2);
                var10_15 = (ReservoirElement)var9_14.getOperationsElement();
                var11_16 = ((ReservoirElement)var10_15).getStorageElement();
                ModelVariable modelVariable = RssModelVariableSet.getModelVariable(10);
                ((IndependentVariable)var5_13).setModalVariableInfo(((Element)var11_16).getFunction().getTSRecordProxy(10), (Element)var11_16, modelVariable);
                ((IndependentVariable)var5_13).setTimeSeriesOptions(1, 0.0, 0.0);
                releaseFuncOpRule.setIndependentVariable((IndependentVariable)var5_13);
                releaseFuncOpRule.setTimeInterpolationType(var9_14.getInterpolationType());
                releaseFuncOpRule.setLimitType(var9_14.getLimitType());
                object = var9_14.getElevationRelease();
                object.setInterpolationType(var9_14.getInterpolationType());
                var5_13 = new SeasonalPairedValues();
                var5_13.setData((PairedValues)object, "01Jan");
                var5_13.setHasSeasonalVariation(false);
                releaseFuncOpRule.setFunctionRelease((SeasonalPairedValues)var5_13);
                if (var9_14.riseFallConditionIsValid() && var9_14.getEnableRiseFallCondition()) {
                    releaseFuncOpRule.setEnableRiseFallCondition(true);
                    releaseFuncOpRule.setRiseFallCondition(var9_14.getRiseFallCondition());
                    releaseFuncOpRule.setRiseFallTolerance(var9_14.getRiseFallTolerance());
                    releaseFuncOpRule.setParameterType(var9_14.getParameterType());
                    releaseFuncOpRule.setAveragingPeriod(var9_14.getAveragingPeriod());
                }
                map.put(object2, releaseFuncOpRule);
            } else if (object instanceof ReleaseFunctionInflowOpRule) {
                System.out.println("convertRules: converting Release as a function of Inflow Rule " + object.getName());
                var9_14 = (ReleaseFunctionInflowOpRule)object;
                ReleaseFuncOpRule releaseFuncOpRule = new ReleaseFuncOpRule(object.getName());
                releaseFuncOpRule.setDescription(object.getDescription());
                releaseFuncOpRule.setIndex(object.getIndex());
                releaseFuncOpRule.setController(((OpRule)object).getController());
                var5_13 = new IndependentVariable(2);
                ((IndependentVariable)var5_13).setTimeSeriesOptions(0, 0.0, 0.0);
                var10_15 = (ReservoirElement)var9_14.getOperationsElement();
                var11_16 = ((ReservoirElement)var10_15).getStorageElement();
                ModelVariable modelVariable = RssModelVariableSet.getModelVariable(13);
                ((IndependentVariable)var5_13).setModalVariableInfo(((Element)var11_16).getFunction().getTSRecordProxy(13), ((ReservoirElement)var10_15).getStorageElement(), modelVariable);
                releaseFuncOpRule.setIndependentVariable((IndependentVariable)var5_13);
                releaseFuncOpRule.setLimitType(var9_14.getLimitType());
                releaseFuncOpRule.setTimeInterpolationType(var9_14.getInterpolationType());
                if (var9_14.riseFallConditionIsValid() && var9_14.getEnableRiseFallCondition()) {
                    releaseFuncOpRule.setEnableRiseFallCondition(true);
                    releaseFuncOpRule.setRiseFallCondition(var9_14.getRiseFallCondition());
                    releaseFuncOpRule.setRiseFallTolerance(var9_14.getRiseFallTolerance());
                    releaseFuncOpRule.setParameterType(var9_14.getParameterType());
                    releaseFuncOpRule.setAveragingPeriod(var9_14.getAveragingPeriod());
                }
                object = var9_14.getReleaseFunction();
                object.setInterpolationType(var9_14.getInterpolationType());
                var5_13 = new SeasonalPairedValues();
                var5_13.setData((PairedValues)object, "01Jan");
                var5_13.setHasSeasonalVariation(false);
                releaseFuncOpRule.setFunctionRelease((SeasonalPairedValues)var5_13);
                map.put(object2, releaseFuncOpRule);
            } else if (object instanceof VariableTSBasedOpRule) {
                System.out.println("convertRules: WARNING VariableTSBasedOpRule " + object.getName() + " is being dropped. This rule type is bad.");
                arrayList.add(object);
            } else if (object instanceof InputTSBasedOpRule) {
                System.out.println("convertRules: converting TS Parameter Based Release Rule " + object.getName());
                var9_14 = (InputTSBasedOpRule)object;
                ReleaseFuncOpRule releaseFuncOpRule = new ReleaseFuncOpRule(object.getName());
                releaseFuncOpRule.setDescription(object.getDescription());
                releaseFuncOpRule.setIndex(object.getIndex());
                releaseFuncOpRule.setController(((OpRule)object).getController());
                releaseFuncOpRule.setLimitType(var9_14.getLimitType());
                releaseFuncOpRule.setTimeInterpolationType(var9_14.getInterpolationType());
                var5_13 = new IndependentVariable(3);
                ((IndependentVariable)var5_13).setTimeSeriesName(var9_14.getParameterName());
                ((IndependentVariable)var5_13).setTimeSeriesOptions(0, 0.0, 0.0);
                releaseFuncOpRule.setIndependentVariable((IndependentVariable)var5_13);
                if (var9_14.riseFallConditionIsValid() && var9_14.getEnableRiseFallCondition()) {
                    releaseFuncOpRule.setEnableRiseFallCondition(true);
                    releaseFuncOpRule.setRiseFallCondition(var9_14.getRiseFallCondition());
                    releaseFuncOpRule.setRiseFallTolerance(var9_14.getRiseFallTolerance());
                    releaseFuncOpRule.setParameterType(var9_14.getParameterType());
                    releaseFuncOpRule.setAveragingPeriod(var9_14.getAveragingPeriod());
                }
                var10_15 = var9_14.getParameterValueRelease();
                var10_15.setInterpolationType(var9_14.getInterpolationType());
                var11_16 = new SeasonalPairedValues();
                var11_16.setData((PairedValues)var10_15, "01Jan");
                var11_16.setHasSeasonalVariation(false);
                releaseFuncOpRule.setFunctionRelease((SeasonalPairedValues)var11_16);
                map.put(object2, releaseFuncOpRule);
            } else {
                ReleaseFuncOpRule releaseFuncOpRule;
                if (!(object instanceof FlowLimitOpRule)) continue;
                System.out.println("convertRules: converting Flow Limit Rule " + object.getName());
                var9_14 = (FlowLimitOpRule)object;
                var10_15 = ((OpRule)object).getOperationsElement();
                if (var9_14.getRssNodeIndex() < 0) {
                    releaseFuncOpRule = new ReleaseFuncOpRule(object.getName());
                    releaseFuncOpRule.setName(object.getName());
                    releaseFuncOpRule.setIndex(object.getIndex());
                    releaseFuncOpRule.setController(((OpRule)object).getController());
                    map.put(object2, releaseFuncOpRule);
                } else {
                    var11_16 = var10_15.getElementOp().getController();
                    releaseFuncOpRule = (ReleaseFuncOpRule)((OpController)var11_16).newRule("Downstream Control Function", object.getName(), var9_14.getRssNodeIndex());
                    arrayList.add(object);
                }
                releaseFuncOpRule.setDescription(object.getDescription());
                var5_13 = new IndependentVariable(0);
                releaseFuncOpRule.setIndependentVariable((IndependentVariable)var5_13);
                releaseFuncOpRule.setLimitType(var9_14.getLimitType());
                releaseFuncOpRule.setTimeInterpolationType(var9_14.getInterpolationType());
                var11_16 = var9_14.getMultiplier();
                if (var11_16 == null || ((DayOfWeekMultiplier)var11_16).isDefaults()) {
                    releaseFuncOpRule.setUseDayOfWeekMultiplier(false);
                } else {
                    releaseFuncOpRule.setUseDayOfWeekMultiplier(true);
                    releaseFuncOpRule.setMultiplier((DayOfWeekMultiplier)var11_16);
                }
                SeasonalRecord seasonalRecord = var9_14.getSeasonalRecord();
                releaseFuncOpRule.setSeasonalRecord(seasonalRecord);
                if (releaseFuncOpRule instanceof DownstreamCntrlOpRule) {
                    var10_15.getElementOp().getController();
                    var11_16 = (DownstreamCntrlOpRule)releaseFuncOpRule;
                    ((DownstreamOpRule)var11_16).setDownstreamControlLocationID(var9_14.getRssNodeIndex());
                    var5_13 = this.getDownstreamOp(((DownstreamOpRule)var11_16).getDownstreamControlLocationID(), true);
                    object2 = ((DownstreamOp)var5_13).getDownstreamOpRule(var11_16.getName());
                    int n2 = ((OpRule)object).getController().getIndex();
                    var10_15 = var10_15.getElementOp().getOperationSets();
                    for (int i = 0; i < ((Vector)var10_15).size(); ++i) {
                        var9_14 = (OpSet)((Vector)var10_15).get(i);
                        if (var9_14 == null) continue;
                        ArrayList arrayList3 = new ArrayList();
                        var9_14.getAllRuleRefs(n2, object.getIndex(), arrayList3);
                        int n3 = arrayList3.size();
                        for (int j = 0; j < n3; ++j) {
                            var9_14 = (OpRuleRef)arrayList3.get(j);
                            if (var9_14 == null) continue;
                            var9_14.setRule(releaseFuncOpRule);
                        }
                    }
                    if (object2 == null) {
                        ((DownstreamCntrlOpRule)var11_16).setParentRuleIndex(-1);
                        ((DownstreamOp)var5_13).addRule((DownstreamCntrlOpRule)var11_16);
                    } else {
                        ((DownstreamOpRule)object2).copyChildInto((DownstreamCntrlOpRule)var11_16);
                        ((DownstreamCntrlOpRule)var11_16).setParentRuleIndex(object2.getIndex());
                    }
                }
            }
            bl = true;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (OpRule)arrayList.get(n);
            ((OpRule)object).getOperationsElement().getElementOp().deleteOpRule((OpRule)object);
        }
        return bl;
    }

    private void convertResSysOps() {
        ReservoirElement reservoirElement;
        int n;
        int n2;
        Object object = this.getReservoirSysOpDataList();
        if ((object = object.getObjectArray()) == null) {
            return;
        }
        this.printMessage("Converting Reservoir System Operations...");
        Vector<ReservoirElement> vector = this.getElementVectorByClass(ReservoirElement.class);
        ArrayList<DataStruct> arrayList = new ArrayList<DataStruct>();
        for (n2 = 0; n2 < ((DataStruct[])object).length; ++n2) {
            if (((ReservoirSysOp)object[n2]).getName().indexOf(this.getName() + "_") < 0) continue;
            ((ReservoirSysOp)object[n2]).setRssSystem(this);
            arrayList.add(object[n2]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (ReservoirSysOp)arrayList.get(n);
            n2 = this.getNextResSysOpId();
            object.setIndex(n2);
            this.saveReservoirSysOp((ReservoirSysOp)object, n2);
            for (int i = vector.size() - 1; i >= 0; --i) {
                reservoirElement = vector.get(i);
                reservoirElement.getReservoirOp();
                if (reservoirElement._resSysOpId != object.getId()) continue;
                reservoirElement._resSysOpId = n2;
                reservoirElement.setModified(true);
                vector.remove(i);
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            reservoirElement = vector.get(n);
            reservoirElement.getReservoirOp();
            reservoirElement._resSysOpId = -1L;
        }
        this.printMessage("Reservoir System Operation Convertion Complete");
    }

    int saveReservoirSysOp(ReservoirSysOp reservoirSysOp, int n) {
        if (reservoirSysOp == null) {
            return -1;
        }
        DbfFile dbfFile = this.getResSysOpDbfFile();
        if (dbfFile == null) {
            this.printMessage("saveReservoirSysOp: Error saving ResSysOp " + reservoirSysOp.getName() + " No ReservoirSysOp Dbf File");
            return -1;
        }
        if (n == -1) {
            n = this.getNextResSysOpId();
            reservoirSysOp.setIndex(n);
        }
        return this.saveOp((NamedType)reservoirSysOp, n, dbfFile);
    }

    private int saveOp(NamedType namedType, int n, DbfFile dbfFile) {
        long l = System.currentTimeMillis();
        if (Logger.canDebug((String)"ResSimOperations")) {
            this.printMessage("saveOp: saving Operations to " + dbfFile.getPath());
        }
        if (dbfFile == null) {
            this.printMessage("saveOp: Error unable to save, DBF File not available.");
            return -1;
        }
        StringBuffer stringBuffer = this.serializeObjectToString((AsciiSerializable)namedType);
        AsciiSerializableDbfHeader asciiSerializableDbfHeader = new AsciiSerializableDbfHeader();
        asciiSerializableDbfHeader = asciiSerializableDbfHeader.buildDbfRecordSet();
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Integer(namedType.getIndex()));
        vector.add(namedType.getName());
        vector.add(namedType.getDescription());
        vector.add(stringBuffer);
        stringBuffer = new DbfRecord(vector);
        asciiSerializableDbfHeader.add((DbfRecord)stringBuffer);
        stringBuffer = dbfFile.writeRecords((DbfRecordSet)asciiSerializableDbfHeader);
        try {
            dbfFile.close();
        }
        catch (IOException iOException) {
            this.printMessage("closeDbfFile: Error closing DBFfile  " + dbfFile.getPath() + " Error:" + String.valueOf(iOException));
            iOException.printStackTrace();
        }
        long l2 = System.currentTimeMillis();
        if (Logger.canDebug((String)"ResSimOperations")) {
            this.printMessage("saveOp: saving " + namedType.getName() + " took " + (l2 - l) + "ms");
        }
        if (stringBuffer != null) {
            return (Integer)stringBuffer.getIndexTagKeys()[0];
        }
        return -1;
    }

    int saveReservoirOp(ReservoirOp reservoirOp, int n) {
        if (reservoirOp == null) {
            return -1;
        }
        DbfFile dbfFile = this.getResOpDbfFile();
        if (dbfFile == null) {
            this.printMessage("saveReservoirOp: Error saving ResOp " + reservoirOp.getName() + " No ReservoirOp Dbf File");
            return -1;
        }
        if (n == -1) {
            n = this.getNextResOpId();
            reservoirOp.setIndex(n);
        }
        return this.saveOp((NamedType)reservoirOp, n, dbfFile);
    }

    public void setMapIdentifier(MapIdentifier mapIdentifier) {
    }

    public MapIdentifier getMapIdentifier() {
        MapIdentifier mapIdentifier = new MapIdentifier(this.getIdentifier());
        mapIdentifier.setIsManager(true);
        return mapIdentifier;
    }

    public void setExtent(WorldRect worldRect) {
    }

    public WorldRect getExtent() {
        WorldRect worldRect = new WorldRect();
        return worldRect;
    }

    public void load() throws IOException {
    }

    public void unload() {
    }

    public void unloading() {
        try {
            if (this.z != null) {
                this.z.close();
            }
            if (this.A != null) {
                this.A.close();
            }
        }
        catch (IOException iOException) {}
        this.z = null;
        this.A = null;
    }

    public Vector getFlowContolTSRecordProxies() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Object object = (Element)this._elementVector.elementAt(i);
            if (!(object instanceof ReservoirElement)) continue;
            ReservoirElement reservoirElement = (ReservoirElement)object;
            vector.addElement(reservoirElement.getStorageFunction().getTSRecordProxy(21));
            object = ((Element)object).getFlowContolTSRecordProxies();
            if (object == null) continue;
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                TSRecordProxy tSRecordProxy = (TSRecordProxy)((Vector)object).elementAt(j);
                if (tSRecordProxy == null || tSRecordProxy.isInput()) continue;
                vector.addElement(((Vector)object).elementAt(j));
            }
        }
        return vector;
    }

    public Vector getDivContolTSRecordProxies() {
        Vector vector = new Vector();
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Object object = (Element)this._elementVector.elementAt(i);
            if (!(object instanceof DiversionElement)) continue;
            object = ((Element)object).getChildElementAt(0);
            if ((object = ((Element)object).getFlowContolTSRecordProxies()) == null) continue;
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                TSRecordProxy tSRecordProxy = (TSRecordProxy)((Vector)object).elementAt(j);
                if (tSRecordProxy == null || tSRecordProxy.isInput()) continue;
                vector.addElement(((Vector)object).elementAt(j));
            }
        }
        return vector;
    }

    public void clearTSProxyList() {
        RssReturnStatusConstants rssReturnStatusConstants;
        int n;
        int n2 = this._nodeVector.size();
        for (n = 0; n < n2; ++n) {
            rssReturnStatusConstants = (RssNode)this._nodeVector.elementAt(n);
            if (rssReturnStatusConstants == null) continue;
            ((RssNode)rssReturnStatusConstants).clearTSProxyList();
        }
        n2 = this._elementVector.size();
        for (n = 0; n < n2; ++n) {
            rssReturnStatusConstants = (Element)this._elementVector.elementAt(n);
            if (rssReturnStatusConstants == null) continue;
            ((Element)rssReturnStatusConstants).clearTSProxyList();
        }
        n2 = this._stateVariableList.size();
        for (n = 0; n < n2; ++n) {
            rssReturnStatusConstants = this._stateVariableList.get(n);
            if (rssReturnStatusConstants == null) continue;
            ((RssTSLocationObject)rssReturnStatusConstants).clearTSProxyList();
        }
        this.clearWaterAccountProxyList();
    }

    private void clearWaterAccountProxyList() {
        int n;
        if (this.h != null && (n = this.h.getWaterAccountSetIndex()) != Integer.MIN_VALUE) {
            NamedType namedType;
            int n2;
            WaterAccountSet waterAccountSet = this.getWaterAccountSet(n);
            for (n2 = 0; n2 < waterAccountSet.getWaterAccounts().size(); ++n2) {
                namedType = waterAccountSet.getWaterAccounts().get(n2);
                if (namedType == null) continue;
                namedType.clearTSProxyList();
            }
            int n3 = this._elementVector.size();
            for (n2 = 0; n2 < n3; ++n2) {
                namedType = (Element)this._elementVector.elementAt(n2);
                if (!(namedType instanceof ReservoirElement)) continue;
                namedType = (ReservoirElement)namedType;
                if ((namedType = namedType.getDefaultWaterAccount()) == null) continue;
                namedType.clearTSProxyList();
            }
        }
    }

    public void updateTSProxyList() {
        Object object2;
        int n;
        this.clearTSProxyList();
        int n2 = this._elementVector.size();
        for (n = 0; n < n2; ++n) {
            object2 = (Element)this._elementVector.elementAt(n);
            if (object2 == null) continue;
            ((Element)object2).updateTSProxyList();
        }
        n2 = this._stateVariableList.size();
        for (n = 0; n < n2; ++n) {
            object2 = this._stateVariableList.get(n);
            if (object2 == null) continue;
            ((RssTSLocationObject)object2).updateTSProxyList();
        }
        if (this.g != null && this.g.getAlternative() != null && WQUtilities.shouldComputeWaterQuality(this.g, this.g.getAlternative().getWaterQualityOptions())) {
            object2 = this.h.getWaterQualityOptions();
            object2 = ((AltWaterQualityOptions)object2).getConstituentSetManager(this.h).getSet().getConstituentList();
            List<ModelVariable> list = this.addWQModelVariables((Collection<Constituent>)object2);
            for (Object object2 : this._elementVector) {
                object2 = (Element)object2;
                ((Element)object2).updateWQTSProxyList(list);
                if (!(object2 instanceof ReservoirElement) || !((ReservoirElement)(object2 = (ReservoirElement)object2)).hasWaterControlDeviceOnRes()) continue;
                object2 = new ArrayList(((Element)object2).getElementsByClass(AdjustableFlow.class, null));
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    NamedType namedType = (Element)object2.next();
                    if (!namedType.hasWaterControlDevice()) continue;
                    namedType = namedType.getWaterControlDevice();
                    namedType.setSystem(this.h.getSystem());
                    namedType.updateTSProxyList();
                }
            }
        }
    }

    public List<ModelVariable> addWQModelVariables(Collection<Constituent> object) {
        ArrayList<ModelVariable> arrayList = new ArrayList<ModelVariable>();
        object = object.iterator();
        while (object.hasNext()) {
            Constituent constituent = (Constituent)object.next();
            int n = constituent.getId() + 2000;
            Object object2 = RssModelVariableSet.getModelVariable(n);
            if (object2 != null) {
                arrayList.add((ModelVariable)object2);
                continue;
            }
            object2 = constituent.getDisplayName();
            if (object2 == null || ((String)object2).isEmpty()) {
                object2 = constituent.getName();
            }
            String string = "mg/l";
            if (constituent.getUnit().endsWith("C")) {
                string = "deg C";
            }
            constituent = Parameter.getParameterForUnitsString((String)string);
            int n2 = Parameter.PARAMID_CONC;
            if (constituent != null) {
                n2 = constituent.getParameterId();
            }
            Object object3 = object2;
            object2 = new ModelVariable(n, "Node", (String)object3, (String)object3, n2, 0, true, string, "INST-VAL");
            RssModelVariableSet.addModelVariable((ModelVariable)object2);
            arrayList.add((ModelVariable)object2);
        }
        return arrayList;
    }

    public void applyHindcastData(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            HindcastData hindcastData = (HindcastData)vector.elementAt(i);
            NamedType namedType = this.getObjectForKeyString(hindcastData.getObjectKey());
            if (namedType == null) continue;
            if (namedType instanceof RssNode) {
                ((RssNode)namedType).applyHindcastData(hindcastData);
                continue;
            }
            if (namedType instanceof Element) {
                ((Element)namedType).applyHindcastData(hindcastData);
                continue;
            }
            if (namedType instanceof Function) {
                ((Function)namedType).applyHindcastData(hindcastData);
                continue;
            }
            if (namedType instanceof OpController) {
                ((OpController)namedType).applyHindcastData(hindcastData);
                continue;
            }
            if (namedType instanceof OpRule) {
                ((OpRule)namedType).applyHindcastData(hindcastData);
                continue;
            }
            if (namedType instanceof StateVariable) {
                ((StateVariable)namedType).applyHindcastData(hindcastData);
                continue;
            }
            if (!(namedType instanceof WaterAccount)) continue;
            ((WaterAccount)namedType).applyHindcastData(hindcastData);
        }
    }

    public Vector getObservedDataTSProxies(Vector vector) {
        int n = this._elementVector.size();
        for (int i = 0; i < n; ++i) {
            Object object = (Element)this._elementVector.elementAt(i);
            if (object == null || !((Element)object).isActive() || (object = ((Element)object).getObsDataVector()) == null) continue;
            vector.addAll(object);
        }
        return vector;
    }

    public Vector getActiveTSProxies(Vector vector, int n) {
        return this.getActiveTSProxies(vector, n, 0);
    }

    public Vector getActiveTSProxies(Vector vector, int n, int n2) {
        Object object;
        int n3;
        Object object2;
        if (vector == null) {
            vector = new Vector();
        }
        if (this.h != null) {
            object2 = this.h.getHindcastData();
            this.applyHindcastData((Vector)object2);
        }
        int n4 = this._nodeVector.size();
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = (RssNode)this._nodeVector.elementAt(n3);
            if (object2 == null || !((RssNode)object2).isActive()) continue;
            ((RssNode)object2).getActiveTSProxies(vector, n);
        }
        n4 = this._elementVector.size();
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = (Element)this._elementVector.elementAt(n3);
            if (object2 == null || !((Element)object2).isActive()) continue;
            ((Element)object2).getActiveTSProxies(vector, n);
            if (this.g == null || !this.g.shouldComputeWaterQuality() || !(object2 instanceof ReservoirElement) || !((ReservoirElement)(object2 = (ReservoirElement)object2)).hasWaterControlDeviceOnRes()) continue;
            object = new ArrayList(((Element)object2).getElementsByClass(AdjustableFlow.class, null));
            object2 = object.iterator();
            while (object2.hasNext()) {
                object = (Element)object2.next();
                if (!((Element)object).hasWaterControlDevice()) continue;
                ((Element)object).getWaterControlDevice().getActiveTSProxies(vector, n);
            }
        }
        if (n2 == 0) {
            n4 = this._stateVariableList.size();
            for (n3 = 0; n3 < n4; ++n3) {
                object2 = this._stateVariableList.get(n3);
                if (object2 == null) continue;
                ((StateVariable)object2).getActiveTSProxies(vector, n);
            }
        }
        if (n2 == 0 && this.h != null && this.h.getWaterAccountSet() != null) {
            object2 = this.h.getWaterAccountSet();
            for (n3 = 0; n3 < ((WaterAccountSet)object2).getWaterAccounts().size(); ++n3) {
                object = ((WaterAccountSet)object2).getWaterAccounts().get(n3);
                if (((RssTSLocationObject)object).getSystem() == null) {
                    ((WaterAccount)object).setSystem(this);
                }
                ((WaterAccount)object).updateTSProxyList(this.h.useYieldAnalysis());
                ((WaterAccount)object).getActiveTSProxies(vector, n);
            }
            n4 = this._elementVector.size();
            for (n3 = 0; n3 < n4; ++n3) {
                object2 = (Element)this._elementVector.elementAt(n3);
                if (!(object2 instanceof ReservoirElement) || (object = ((ReservoirElement)(object2 = (ReservoirElement)object2)).getDefaultWaterAccount()) == null) continue;
                if (((RssTSLocationObject)object).getSystem() == null) {
                    ((WaterAccount)object).setSystem(this);
                }
                ((WaterAccount)object).updateTSProxyList(false);
                ((WaterAccount)object).getActiveTSProxies(vector, n);
            }
        }
        if (this.h != null) {
            this.h.getActiveTSProxies(vector, n);
        }
        return vector;
    }

    public List<TSRecordProxy> getActiveWaterQualityTSProxies(WQRun wQRun) {
        ArrayList<TSRecordProxy> arrayList = new ArrayList<TSRecordProxy>();
        RssWQGeometry rssWQGeometry = wQRun.getRssWQGeometry();
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Object object2;
            TSLocation tSLocation = (Element)this._elementVector.elementAt(i);
            if (tSLocation == null || !tSLocation.isActive()) continue;
            int n = tSLocation.getIndex();
            if (tSLocation instanceof ReachElement) {
                WQGeoSubDomain wQGeoSubDomain = rssWQGeometry.getWQReach(n);
                if (wQGeoSubDomain == null || !rssWQGeometry.isInExtent((SubDomain)wQGeoSubDomain)) continue;
                tSLocation = tSLocation.getDownstreamNode();
                arrayList.addAll(tSLocation.getActiveOutputWQTSProxies());
                continue;
            }
            if (tSLocation instanceof JunctionElement) {
                object2 = (JunctionElement)tSLocation;
                Object object3 = rssWQGeometry.getWQJunction(n);
                if (object3 == null || !object3.getInExtent()) continue;
                tSLocation = tSLocation.getDownstreamNode();
                arrayList.addAll(tSLocation.getActiveOutputWQTSProxies());
                new Vector();
                Vector vector = ((JunctionElement)object2).getDiversions(null);
                int n2 = vector.size();
                for (int j = 0; j < n2; ++j) {
                    object3 = (DiversionElement)vector.elementAt(j);
                    tSLocation = object3.getUpstreamNode();
                    object3 = RssWQGeometry.formBoundaryName((JunctionElement)object2, (DiversionElement)object3);
                    if ((object3 = rssWQGeometry.getWQSubdomainBoundaryByName((String)object3)) == null || !object3.getInExtent()) continue;
                    arrayList.addAll(tSLocation.getActiveOutputWQTSProxies());
                }
                continue;
            }
            if (!(tSLocation instanceof ReservoirElement)) continue;
            object2 = (ReservoirElement)tSLocation;
            WQGeoSubDomain wQGeoSubDomain = rssWQGeometry.getWQSubdomain((Element)tSLocation);
            if (wQGeoSubDomain == null || !rssWQGeometry.isInExtent((SubDomain)wQGeoSubDomain)) continue;
            ArrayList<RssNode> arrayList2 = wQRun.getReservoirOutletNodes((ReservoirElement)object2);
            for (RssNode rssNode : arrayList2) {
                tSLocation = rssNode;
                rssNode.getActiveTSProxies(null, 0);
                arrayList.addAll(tSLocation.getActiveOutputWQTSProxies());
            }
        }
        List<RssComputeWQObsStation> list = wQRun.getOutputObsStations();
        for (RssComputeWQObsStation rssComputeWQObsStation : list) {
            RssNode rssNode = rssComputeWQObsStation.d();
            Vector vector = rssNode.getTSRecordProxies();
            arrayList.addAll(vector);
        }
        return arrayList;
    }

    @Deprecated
    public Vector getTSRecordProxies() {
        this.updateTSProxyList();
        return this.getActiveTSProxies(null, 1);
    }

    @Deprecated
    public Vector getTSRecordProxies(boolean bl) {
        int n = 1;
        if (!bl) {
            n = 0;
        }
        return this.getActiveTSProxies(null, n);
    }

    public String getNextDefaultName(int n) {
        String string;
        String[] stringArray;
        switch (n) {
            case 0: {
                stringArray = ReachElement.class.getName();
                string = REACH_STR;
                break;
            }
            case 1: {
                stringArray = ReservoirElement.class.getName();
                string = RESERVOIR_STR;
                break;
            }
            case 2: {
                stringArray = JunctionElement.class.getName();
                string = JUNCTION_STR;
                break;
            }
            case 3: {
                stringArray = DiversionElement.class.getName();
                string = DIVERSION_STR;
                break;
            }
            default: {
                return "Untitled";
            }
        }
        int n2 = this.getElementCount((String)stringArray);
        stringArray = this.getElementNames((String)stringArray);
        String string2 = string + " " + Integer.toString(n2);
        if (stringArray == null) {
            return string2;
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string2)) continue;
                bl = true;
                string2 = string + " " + Integer.toString(++n2);
            }
        }
        return string2;
    }

    public String[] getElementNames(String object) {
        int n;
        Class<?> clazz;
        try {
            clazz = Class.forName((String)object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("getElementNames: Class not found " + (String)object + " Error:" + classNotFoundException.toString());
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < this._elementVector.size(); ++n) {
            object = (Element)this._elementVector.elementAt(n);
            if (object == null || !clazz.isInstance(object)) continue;
            vector.addElement(object.getName());
        }
        if (vector.size() <= 0) {
            return null;
        }
        object = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            object[n] = (String)vector.elementAt(n);
        }
        return object;
    }

    @Scriptable
    public String[] getReservoirNames() {
        return this.getElementNames(ReservoirElement.class.getName());
    }

    @Scriptable
    public String[] getReachNames() {
        return this.getElementNames(ReachElement.class.getName());
    }

    @Scriptable
    public String[] getJunctionNames() {
        return this.getElementNames(JunctionElement.class.getName());
    }

    @Scriptable
    public String[] getDiversionNames() {
        return this.getElementNames(DiversionElement.class.getName());
    }

    public RssNode newNode() {
        RssSystem rssSystem = this;
        RssNode rssNode = new RssNode(rssSystem, rssSystem.nextNodeIndex());
        this._nodeVector.addElement(rssNode);
        RssNode rssNode2 = rssNode;
        rssNode2.setName("Node " + Integer.toString(rssNode2.getIndex()));
        rssNode.setDescription("");
        this.setModified(true);
        return rssNode;
    }

    public RssNode createNode(WorldPt worldPt) {
        if (worldPt == null) {
            return null;
        }
        RssNode rssNode = this.newNode();
        rssNode.setLocation(worldPt);
        return rssNode;
    }

    public RssNode createNode(ComputationPoint computationPoint) {
        if (computationPoint == null) {
            return null;
        }
        RssNode rssNode = this.newNode();
        rssNode.setComputationPoint(computationPoint);
        return rssNode;
    }

    public RssNode createNode(Node node) {
        if (node == null) {
            return null;
        }
        RssNode rssNode = this.newNode();
        rssNode.setLocation(node.getLocation());
        rssNode.setStreamIndex(node.getStreamIndex());
        rssNode.setStreamName(node.getStreamName());
        rssNode.setStreamCoord(node.getStreamCoord());
        rssNode.setStreamStation(node.getStreamStation());
        return rssNode;
    }

    public void deleteNode(RssNode rssNode) {
        if (this._nodeVector.contains(rssNode)) {
            this._nodeVector.remove(rssNode);
            this.q.remove(rssNode.getIndex());
            rssNode.dispose();
            this.setModified(true);
        }
    }

    public RssNode findDownstreamNode(int n, double d) {
        RssNode rssNode = null;
        int n2 = this._nodeVector.size();
        for (int i = 0; i < n2; ++i) {
            RssNode rssNode2 = (RssNode)this._nodeVector.elementAt(i);
            if (rssNode2 == null || n != rssNode2.getStreamIndex()) continue;
            double d2 = d - rssNode2.getStreamCoord();
            if (!(rssNode2.getStreamCoord() < d) || Math.abs(d2) < 1.0E-9 || rssNode != null && !(rssNode.getStreamCoord() < rssNode2.getStreamCoord())) continue;
            rssNode = rssNode2;
        }
        return rssNode;
    }

    public RssNode findUpstreamNode(int n, double d) {
        RssNode rssNode = null;
        int n2 = this._nodeVector.size();
        for (int i = 0; i < n2; ++i) {
            RssNode rssNode2 = (RssNode)this._nodeVector.elementAt(i);
            if (rssNode2 == null || n != rssNode2.getStreamIndex() || !(rssNode2.getStreamCoord() > d) || rssNode != null && !(rssNode.getStreamCoord() > rssNode2.getStreamCoord())) continue;
            rssNode = rssNode2;
        }
        return rssNode;
    }

    private Vector getDownstreamElementsWithDiv(Element object, Element element) {
        Element element2;
        int n;
        object = this.getDownstreamElements((Element)object, true);
        int n2 = ((Vector)object).size();
        for (n = n2 - 1; n >= 0 && (element2 = (Element)((Vector)object).elementAt(n)) != element; --n) {
            ((Vector)object).removeElementAt(n);
        }
        n2 = ((Vector)object).size();
        if (n2 <= 0) {
            return object;
        }
        Vector vector = new Vector();
        for (n = 0; n < n2; ++n) {
            element2 = (Element)((Vector)object).elementAt(n);
            if (element2 == null) continue;
            if (element2 instanceof JunctionElement) {
                vector.clear();
                vector = ((JunctionElement)element2).getDiversions(vector);
                int n3 = vector.size();
                for (int i = 0; i < n3; ++i) {
                    Element element3;
                    TSLocation tSLocation = (DiversionElement)vector.elementAt(i);
                    if (tSLocation == null) continue;
                    ((Vector)object).insertElementAt(tSLocation, n);
                    ++n;
                    tSLocation = tSLocation.getDownstreamNode();
                    if (tSLocation == null) continue;
                    int n4 = n + 1;
                    tSLocation = tSLocation.getDownstreamElement();
                    Vector vector2 = this.getDownstreamElements((Element)tSLocation);
                    vector2.insertElementAt(tSLocation, 0);
                    if (!vector2.contains(element)) continue;
                    int n5 = vector2.size();
                    for (int j = 0; j < n5 && !((Vector)object).contains(element3 = (Element)vector2.elementAt(j)); ++j) {
                        ((Vector)object).insertElementAt(element3, n4);
                        ++n4;
                    }
                }
            }
            n2 = ((Vector)object).size();
        }
        return object;
    }

    private int associateIterationBlockElements(Vector vector, Element element, int n, int n2, int[] nArray) {
        int n3 = vector.size();
        int n4 = n2;
        for (n2 = 0; n2 < n3; ++n2) {
            Element element2 = (Element)vector.elementAt(n2);
            if (element2 == null) continue;
            int n5 = element2.getIndex();
            for (int i = n; i < this.r.length; ++i) {
                Element element3 = (Element)this.s.elementAt(this.r[i]);
                if (element3.getIndex() != n5) continue;
                if (nArray[i] < 0) {
                    for (n5 = 0; n5 < this.r.length; ++n5) {
                        if (nArray[n5] != n4) continue;
                        nArray[n5] = i;
                    }
                    int n6 = i;
                    nArray[n6] = n6;
                    n4 = i;
                    break;
                }
                if (nArray[i] == n4) break;
                if (n4 > nArray[i]) {
                    n5 = nArray[i];
                    for (i = 0; i < this.r.length; ++i) {
                        if (nArray[i] != n5) continue;
                        nArray[i] = n4;
                    }
                } else {
                    n5 = n4;
                    n4 = nArray[i];
                    for (i = 0; i < this.r.length; ++i) {
                        if (nArray[i] != n5) continue;
                        nArray[i] = n4;
                    }
                }
                break;
            }
            if (element2 == element) break;
        }
        return n4;
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    public int nextElementIndex() {
        int n = this._nextElementIndex++;
        return n;
    }

    private int nextStateVariableIndex() {
        int n = this._nextStateVariableIndex++;
        return n;
    }

    private int nextGlobalVariableIndex() {
        int n = this._nextGlobalVariableIndex++;
        return n;
    }

    private int nextNodeIndex() {
        int n = this._nextNodeIndex++;
        return n;
    }

    void removeOldOutflowNaming() {
        Enumeration enumeration = this._nodeVector.elements();
        while (enumeration.hasMoreElements()) {
            RssNode rssNode = (RssNode)enumeration.nextElement();
            String string = rssNode.getName();
            int n = string.indexOf(" Outflow");
            if (n < 0) continue;
            rssNode.setName(string.substring(0, n));
        }
    }

    void addSpaceBeforeTailwater() {
        int n;
        int n2;
        int n3;
        String string;
        RssReturnStatusConstants rssReturnStatusConstants;
        Enumeration enumeration = this._nodeVector.elements();
        while (enumeration.hasMoreElements()) {
            rssReturnStatusConstants = (RssNode)enumeration.nextElement();
            string = rssReturnStatusConstants.getName();
            n3 = string.indexOf("Tailwater");
            n2 = string.indexOf(" Tailwater");
            n = string.length();
            if (n3 < 0 || n2 >= 0 || n3 != n - 9) continue;
            rssReturnStatusConstants.setName(string.substring(0, n3) + " Tailwater");
        }
        enumeration = this._elementVector.elements();
        while (enumeration.hasMoreElements()) {
            rssReturnStatusConstants = (Element)enumeration.nextElement();
            string = rssReturnStatusConstants.getName();
            n3 = string.indexOf("Tailwater");
            n2 = string.indexOf(" Tailwater");
            n = string.length();
            if (n3 < 0 || n2 >= 0 || n3 != n - 9) continue;
            ((Element)rssReturnStatusConstants).setName(string.substring(0, n3) + " Tailwater");
        }
    }

    void renameDiversionNode() {
        Enumeration enumeration = this._elementVector.elements();
        while (enumeration.hasMoreElements()) {
            TSLocation tSLocation = (Element)enumeration.nextElement();
            if (!(tSLocation instanceof DiversionElement)) continue;
            tSLocation = tSLocation.getNode(0);
            String string = tSLocation.getName();
            int n = string.indexOf(" Cntrl");
            int n2 = string.length();
            if (n < 0 || n != n2 - 6) continue;
            tSLocation.setName(string.substring(0, n));
        }
    }

    public void resetParentElement() {
        Enumeration enumeration = this._elementVector.elements();
        while (enumeration.hasMoreElements()) {
            ((Element)enumeration.nextElement()).resetParentElement();
        }
    }

    boolean generateReservoirOp() {
        CommonDataList commonDataList = this.getReservoirOpDataList();
        if (commonDataList == null) {
            System.out.println("Error: Failed to Update RssSystem Data");
            System.out.println("Could not get data list to create ResevoirOp objects");
            return false;
        }
        for (int i = 0; i < this._elementVector.size(); ++i) {
            ReservoirElement reservoirElement;
            String string;
            Object object;
            NamedType namedType = (Element)this._elementVector.elementAt(i);
            if (!(namedType instanceof ReservoirElement) || (object = (ReservoirOp)commonDataList.getObject(string = (reservoirElement = (ReservoirElement)namedType).getResOpName())) != null) continue;
            String string2 = string;
            object = (ReservoirOp)commonDataList.newDataObject(string2, string2 + " Operations");
            if (!commonDataList.addNewObject((DataObject)object)) {
                System.out.println("Failed to add new reservoirOp for " + namedType.getName());
                return false;
            }
            namedType = ((OpSet)(object = ((ReservoirOp)object).addNewOpSet("Base"))).getInactiveZone();
            if (namedType != null) {
                namedType.setZoneTypeID(0);
                namedType.setConstantValue(reservoirElement.getStorageFunction().getMinElevation());
            }
            if ((object = ((OpSet)object).getFloodZone()) == null) continue;
            ((StorageZone)object).setZoneTypeID(0);
            ((StorageZone)object).setConstantValue(reservoirElement.getStorageFunction().getMaxElevation());
        }
        return true;
    }

    void replaceNodeObjects() {
    }

    void renameStorElevTSProxies() {
        int n;
        Vector vector;
        int n2;
        int n3 = this._nodeVector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            RssNode rssNode = (RssNode)this._nodeVector.elementAt(n2);
            vector = rssNode.getTSRecordProxies();
            n = vector.size();
            for (int i = 0; i < n; ++i) {
                TSRecordProxy tSRecordProxy = (TSRecordProxy)vector.elementAt(i);
                if (tSRecordProxy == null) continue;
                this.renameStorElevProxy(tSRecordProxy);
            }
        }
        n3 = this._elementVector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            TSRecordProxy tSRecordProxy;
            Element element = (Element)this._elementVector.elementAt(n2);
            Function function = element.getFunction();
            if (function != null) {
                vector = function.getTSRecordProxies();
                n = vector.size();
                for (int i = 0; i < n; ++i) {
                    tSRecordProxy = (TSRecordProxy)vector.elementAt(i);
                    if (tSRecordProxy == null) continue;
                    this.renameStorElevProxy(tSRecordProxy);
                }
            }
            tSRecordProxy = element._elemVector;
            int n4 = tSRecordProxy.size();
            for (int i = 0; i < n4; ++i) {
                NamedType namedType = tSRecordProxy.elementAt(i);
                if ((namedType = namedType.getFunction()) == null) continue;
                vector = namedType.getTSRecordProxies();
                n = vector.size();
                for (int j = 0; j < n; ++j) {
                    TSRecordProxy tSRecordProxy2 = (TSRecordProxy)vector.elementAt(j);
                    if (tSRecordProxy2 == null) continue;
                    this.renameStorElevProxy(tSRecordProxy2);
                }
            }
        }
    }

    void renameStorElevProxy(TSRecordProxy tSRecordProxy) {
        String string = tSRecordProxy.getName();
        int n = string.indexOf(" Elevation");
        int n2 = string.indexOf(" Known Elevation");
        if (n > 0 && n2 < 0) {
            tSRecordProxy.setName(string.substring(0, n));
            tSRecordProxy.setParamName(ReservoirElement.ELEVATION);
        }
        if (tSRecordProxy.getParamName().equalsIgnoreCase("Elevation")) {
            tSRecordProxy.setParamName(ReservoirElement.ELEVATION);
        }
        n = string.indexOf(" Storage");
        n2 = string.indexOf(" Known Storage");
        if (n > 0 && n2 < 0) {
            tSRecordProxy.setName(string.substring(0, n));
            tSRecordProxy.setParamName(ReservoirElement.STORAGE);
        }
        if (tSRecordProxy.getParamName().equalsIgnoreCase("Storage")) {
            tSRecordProxy.setParamName(ReservoirElement.STORAGE);
        }
    }

    void renameSpillTSProxies() {
        int n = this._nodeVector.size();
        for (int i = 0; i < n; ++i) {
            RssNode rssNode = (RssNode)this._nodeVector.elementAt(i);
            Vector vector = rssNode.getTSRecordProxies();
            int n2 = vector.size();
            for (int j = 0; j < n2; ++j) {
                String string;
                int n3;
                TSRecordProxy tSRecordProxy = (TSRecordProxy)vector.elementAt(j);
                if (tSRecordProxy != null) {
                    this.renameStorElevProxy(tSRecordProxy);
                }
                if ((n3 = (string = tSRecordProxy.getName()).indexOf(" Spill")) <= 0 || n3 != string.length() - 6) continue;
                tSRecordProxy.setName(string + "way");
            }
        }
    }

    void convertRoutingFunctionsToWatershedUnits() {
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Element element = (Element)this._elementVector.elementAt(i);
            Function function = null;
            if (element instanceof ReachElement) {
                function = ((ReachElement)element).getFunction();
            } else if (element instanceof DiversionElement) {
                function = ((ReachElement)((DiversionElement)element).getReachElement()).getFunction();
            }
            if (function == null) continue;
            if (function instanceof MuskingumCunge8ptRouting) {
                ((MuskingumCunge8ptRouting)function).convertToWatershedUnits();
                continue;
            }
            if (function instanceof MuskingumCungePrismRouting) {
                ((MuskingumCungePrismRouting)function).convertToWatershedUnits();
                continue;
            }
            if (function instanceof PulsChannelRouting) {
                ((PulsChannelRouting)function).convertToWatershedUnits();
                continue;
            }
            if (!(function instanceof PulsChannelRoutingWithLosses)) continue;
            ((PulsChannelRoutingWithLosses)function).convertToWatershedUnits();
        }
    }

    void convertOldRoutingFunctions() {
        for (int i = 0; i < this._elementVector.size(); ++i) {
            NamedType namedType;
            Element element = (Element)this._elementVector.elementAt(i);
            Function function = null;
            if (element instanceof ReachElement) {
                function = ((ReachElement)element).getFunction();
            } else if (element instanceof DiversionElement && (namedType = ((DiversionElement)element).getReachElement()) != null) {
                function = namedType.getFunction();
            }
            if (function == null) continue;
            if (function instanceof PulsChannelRouting) {
                namedType = new PulsChannelRoutingWithLosses(element);
                ((PulsChannelRoutingWithLosses)namedType).copyDataFromPulChannelRouting((PulsChannelRouting)function);
                element.setFunction((Function)namedType);
                continue;
            }
            if (function instanceof MuskingumCunge8ptRouting) {
                namedType = new MuskingumCungeRouting(element, ChannelType.EIGHT_POINT);
                ((MuskingumCungeRouting)namedType).copyDataFromMuskingumCunge8ptRouting((MuskingumCunge8ptRouting)function);
                element.setFunction((Function)namedType);
                continue;
            }
            if (!(function instanceof MuskingumCungePrismRouting)) continue;
            namedType = new MuskingumCungeRouting(element);
            ((MuskingumCungeRouting)namedType).copyDataFromMuskingumCungePrismRouting((MuskingumCungePrismRouting)function);
            element.setFunction((Function)namedType);
        }
    }

    public void renameDamElementChildren() {
        int n = this._elementVector.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._elementVector.elementAt(i);
            if (!(object instanceof ReservoirElement)) continue;
            object = ((ReservoirElement)object)._elemVector;
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                Element element = (Element)((Vector)object).elementAt(j);
                if (!(element instanceof ReservoirDamElement)) continue;
                Element element2 = element._elemVector.elementAt(0);
                element2.setName(this.getKeyStringForObject(element) + "~Tailwater");
                element2 = element._elemVector.elementAt(1);
                element2.setName(this.getKeyStringForObject(element));
                this.setModified(true);
            }
        }
    }

    public void renameResChildrenUpNodes() {
        int n = this._elementVector.size();
        for (int i = 0; i < n; ++i) {
            Element element;
            int n2;
            Object object = this._elementVector.elementAt(i);
            if (!(object instanceof ReservoirElement)) continue;
            object = (ReservoirElement)object;
            Object object2 = Dam.class;
            object2 = ((Element)object).getElementsByClass((Class)object2, null);
            for (n2 = 0; n2 < ((Vector)object2).size(); ++n2) {
                element = (Element)((Vector)object2).elementAt(n2);
                element.getNode(0).setName(this.getKeyStringForObject(element) + "~IN");
            }
            object2 = AdjustableFlow.class;
            object2 = ((Element)object).getElementsByClass((Class)object2, null);
            for (n2 = 0; n2 < ((Vector)object2).size(); ++n2) {
                element = (Element)((Vector)object2).elementAt(n2);
                element.getNode(0).setName(this.getKeyStringForObject(element) + "~IN");
            }
            object2 = Spillway.class;
            object2 = ((Element)object).getElementsByClass((Class)object2, null);
            for (n2 = 0; n2 < ((Vector)object2).size(); ++n2) {
                element = (Element)((Vector)object2).elementAt(n2);
                element.getNode(0).setName(this.getKeyStringForObject(element) + "~IN");
            }
        }
    }

    private void updatePowerPlantFlows() {
        Element element;
        int n;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (n = 0; n < this._elementVector.size(); ++n) {
            element = (Element)this._elementVector.elementAt(n);
            if (!(element instanceof ReservoirElement)) continue;
            arrayList.add(element);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            element = (ReservoirElement)arrayList.get(n);
            this.updatePowerPlantFlows(element);
        }
        arrayList.size();
    }

    private void updatePowerPlantFlows(Element element) {
        Object object;
        if (element == null) {
            return;
        }
        Function function = element.getFunction();
        if (!(function instanceof PowerPlantFlow) && function instanceof AdjustableFlow && ((AdjustableFlow)function).hasPowerPlant()) {
            object = new PowerPlantFlow(element);
            String string = ((ReservoirElement)element.getTopParent()).getNextPowerPlantName();
            ((AdjustableFlow)object).copyInto((AdjustableFlow)function);
            object.setName(string);
            element.setName(string);
            element.setFunction((Function)object);
        }
        object = element.getElementVector();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            this.updatePowerPlantFlows((Element)((Vector)object).get(i));
        }
    }

    private void addOutputFlowProxyToLocalFlowNodes() {
        int n = this._nodeVector.size();
        for (int i = 0; i < n; ++i) {
            TSRecordProxy tSRecordProxy;
            RssNode rssNode = (RssNode)this._nodeVector.elementAt(i);
            if (rssNode == null || (tSRecordProxy = rssNode.getTSRecordProxy(4)) == null) continue;
            String string = tSRecordProxy.getName();
            TSRecordProxy tSRecordProxy2 = rssNode.getTSRecordProxy(0);
            if (tSRecordProxy2 == null) {
                rssNode.addTSRecordProxy(0);
                tSRecordProxy2 = rssNode.getTSRecordProxy(0);
            }
            rssNode.setName(this.getKeyStringForObject(rssNode.getDownstreamElement()) + KEYMARK + tSRecordProxy.getName());
            tSRecordProxy2.setName(rssNode.getName());
            tSRecordProxy.setName(string);
            this.setModified(true);
        }
    }

    private void updateRuleRefTables() {
        int n = this._elementVector.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._elementVector.get(i);
            if (!(object instanceof ReservoirElement)) continue;
            object = (ReservoirElement)object;
            object = ((ReservoirElement)object).getReservoirOp();
            Vector<OpSet> vector = ((ReservoirOp)object).getOperationSets();
            int n2 = vector.size();
            for (int j = 0; j < n2; ++j) {
                object = vector.get(j);
                ((OpSet)object).updateRuleRefTables();
            }
        }
        this.setModified(true);
    }

    private void updateZoneFunction() {
        Vector vector = this.getElementVectorByClass(ReservoirElement.class.getName());
        boolean bl = false;
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Cloneable cloneable = (ReservoirElement)vector.get(i);
                Vector<OpSet> vector2 = ((ReservoirElement)cloneable).getReservoirOp().getOperationSets();
                for (int j = 0; j < vector2.size(); ++j) {
                    cloneable = vector2.elementAt(j).getZoneVector();
                    int n = ((Vector)cloneable).size();
                    for (int k = 0; k < n; ++k) {
                        StorageZone storageZone = (StorageZone)((Vector)cloneable).elementAt(k);
                        if (storageZone.getIndependentVariable() != null) continue;
                        if (storageZone.isTimeSeries()) {
                            var5_3 = new IndependentVariable(3);
                            storageZone.setIndependentVariable(var5_3);
                            var5_3.setTimeSeriesOptions(true);
                        } else {
                            var5_3 = new IndependentVariable(0);
                            storageZone.setIndependentVariable(var5_3);
                        }
                        bl = true;
                    }
                }
            }
            if (bl) {
                this.W = true;
                this.setModified(true);
            }
        }
    }

    private void renameDamElements() {
        int n = this._elementVector.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._elementVector.get(i);
            if (!(object instanceof ReservoirElement)) continue;
            object = (ReservoirElement)object;
            int n2 = ((Element)object).getChildElementCount();
            for (int j = 0; j < n2; ++j) {
                Element element = ((Element)object).getChildElementAt(j);
                if (!(element instanceof ReservoirDamElement) || (element = ((ReservoirDamElement)element).getDamElement()) == null) continue;
                String string = element.getName();
                int n3 = string.indexOf("~Unctrl");
                if (n3 >= 0) {
                    element.setName(string.substring(0, n3 - 1) + "~L&O");
                    continue;
                }
                element.setName(string + "~L&O");
            }
        }
        this.setModified(true);
    }

    public boolean hasDownstreamGoals() {
        if (this.h == null) {
            return false;
        }
        Cloneable cloneable = this.getElementVectorByClass(ReservoirElement.class);
        Enumeration<ReservoirElement> enumeration = ((Vector)cloneable).elements();
        while (enumeration.hasMoreElements()) {
            cloneable = enumeration.nextElement();
            int n = this.h.getResOpSetSelection(cloneable.getIndex());
            if (n < 0 || !((ReservoirElement)cloneable).hasDownstreamGoals(n)) continue;
            return true;
        }
        return false;
    }

    public boolean backupFile(String string) {
        if (!super.backupFile(string)) {
            return false;
        }
        boolean bl = true;
        if (this.w != null) {
            bl = this.w.backupData(string);
        }
        if (this.x != null) {
            bl |= this.x.backupData(string);
        }
        return bl;
    }

    public Manager saveManagerAs(String string, String string2, ManagerProxyListContainer managerProxyListContainer) {
        Object object = managerProxyListContainer.getManagerProxyList(this._proxyList.getModel());
        object = (RssSystem)object.newManager(this.getClass().getName());
        Identifier identifier = this.getSaveAsId(string, string2, object.getIndex());
        return this.saveManagerAs(string, string2, managerProxyListContainer, identifier, (RssSystem)object);
    }

    public Manager saveManagerAs(String string, String string2, ManagerProxyListContainer managerProxyListContainer, Identifier identifier, RssSystem rssSystem) {
        if (identifier == null || rssSystem == null) {
            return null;
        }
        string = managerProxyListContainer.getManagerProxyList(this._proxyList.getModel());
        managerProxyListContainer = rssSystem.getProxyList();
        rssSystem.setProxyList(this.getProxyList());
        Identifier identifier2 = rssSystem._identifier;
        rssSystem._identifier = this.getIdentifier();
        int n = rssSystem.getIndex();
        rssSystem.readFile(this.getIdentifier());
        rssSystem.getReservoirSysOps();
        rssSystem._identifier = identifier2;
        rssSystem.getIdentifier().copy(identifier);
        rssSystem.setProxyList((ManagerProxyList)managerProxyListContainer);
        if (string2 != null) {
            rssSystem.getIdentifier().setName(string2 + KEYDELIM + this.getName());
            rssSystem.setName(string2 + KEYDELIM + this.getName());
        } else {
            rssSystem.getIdentifier().setName(identifier.getName());
            rssSystem.setName(identifier.getName());
        }
        rssSystem.setDescription(this.getDescription());
        rssSystem._defaultDownstreamOptions = this._defaultDownstreamOptions;
        rssSystem.resetAndSaveOperations();
        rssSystem.setIndex(n);
        rssSystem.Z = false;
        if (!string.saveManager(UserId.getUserId(), (Manager)rssSystem)) {
            System.out.println(this.getName() + ".saveManagerAs: ERROR failed to save new Manager");
        }
        string.unloadManager(rssSystem.getIdentifier());
        rssSystem.copyGlobalVariableTables(this);
        return rssSystem;
    }

    public boolean refreshData(Manager manager) {
        if (!(manager instanceof RssSystem)) {
            return false;
        }
        RssSystem rssSystem = (RssSystem)manager;
        this.getReservoirSysOps();
        rssSystem.getReservoirSysOps();
        Object object = new IntVector();
        IntVector intVector = new IntVector();
        DbfFile dbfFile = this.getElementVectorByClass(ReservoirElement.class);
        for (int i = 0; i < dbfFile.size(); ++i) {
            ReservoirElement reservoirElement = dbfFile.get(i);
            if (reservoirElement._resOpDbfId >= 0) {
                object.add(reservoirElement._resOpDbfId);
            }
            if (reservoirElement._resSysOpId <= -1L) continue;
            intVector.add((int)reservoirElement._resSysOpId);
        }
        String string = this.getName();
        dbfFile = this.getDescription();
        int n = this.getIndex();
        this.setName(manager.getName());
        ManagerProxyList managerProxyList = this.getProxyList();
        this.setProxyList(manager.getProxyList());
        manager = this.getIdentifier();
        this._identifier = rssSystem.getIdentifier();
        DbfFile dbfFile2 = this.z;
        DbfFile dbfFile3 = this.A;
        this.z = null;
        this.A = null;
        this.readFile(rssSystem.getIdentifier());
        this.F = null;
        this.getReservoirSysOps();
        this.z = dbfFile2;
        this.A = dbfFile3;
        this._identifier = manager;
        this.setProxyList(managerProxyList);
        this.getIdentifier().setName(string);
        this.setName(string);
        this.setDescription((String)dbfFile);
        this.setIndex(n);
        this.resetAndSaveOperations();
        boolean bl = Logger.canDebug((String)"ResSimOperations");
        if (object.size() > 0) {
            dbfFile = new Integer[object.size()];
            object.copyInto((Integer[])dbfFile);
            object = new AsciiSerializableDbfHeader();
            object = object.buildDbfRecordIndexSet((Serializable[])dbfFile);
            dbfFile = this.getResOpDbfFile();
            if (dbfFile != null) {
                if (bl) {
                    RssSystem rssSystem2 = this;
                    rssSystem2.printMessage(rssSystem2.getName() + ".refreshData: deleting old ResOps ");
                    object.printData();
                }
                if ((object = dbfFile.deleteRecords((DbfRecordIndexSet)object)).getErrorCount() > 0 && (object = object.getErrors()) != null) {
                    RssSystem rssSystem3 = this;
                    rssSystem3.printMessage(rssSystem3.getName() + ".refreshData: Errors from deleting old ResOps:");
                    for (int i = 0; i < object.size(); ++i) {
                        this.printMessage(object.get(i).toString());
                    }
                }
            }
        }
        if (intVector.size() > 0) {
            DbfFile dbfFile4 = new Integer[intVector.size()];
            intVector.copyInto((Integer[])dbfFile4);
            object = new AsciiSerializableDbfHeader();
            object = object.buildDbfRecordIndexSet((Serializable[])dbfFile4);
            dbfFile4 = this.getResSysOpDbfFile();
            if (dbfFile4 != null) {
                if (bl) {
                    RssSystem rssSystem4 = this;
                    rssSystem4.printMessage(rssSystem4.getName() + ".refreshData: deleting old ResSysOps ");
                    object.printData();
                }
                if ((object = dbfFile4.deleteRecords((DbfRecordIndexSet)object)).getErrorCount() > 0 && (object = object.getErrors()) != null) {
                    RssSystem rssSystem5 = this;
                    rssSystem5.printMessage(rssSystem5.getName() + ".refreshData: Errors from deleting old ResSysOps:");
                    for (int i = 0; i < object.size(); ++i) {
                        this.printMessage(object.get(i).toString());
                    }
                }
            }
        }
        if (!this._proxyList.saveManager(UserId.getUserId(), (Manager)this)) {
            System.out.println(this.getName() + ".refreshData: save failed");
        }
        this.copyGlobalVariableTables(rssSystem);
        return true;
    }

    public void copyGlobalVariableTables(RssSystem object) {
        object = ((RssSystem)object).getGlobalVariableTablesFile();
        String string = this.getGlobalVariableTablesFile();
        try {
            if (!Files.exists(Paths.get(string, new String[0]), new LinkOption[0])) {
                Files.createFile(Paths.get(string, new String[0]), new FileAttribute[0]);
            }
            this.getDSSFileManager().copyFile((String)object, string);
            return;
        }
        catch (IOException iOException) {
            java.util.logging.Logger.getLogger(RssSystem.class.getName()).log(Level.WARNING, "Error copying global variable tables file\nfrom " + (String)object + "\nto " + string, iOException);
            return;
        }
    }

    public String getGlobalVariableTablesFile() {
        if (this.getIdentifier() == null) {
            return "";
        }
        Path path = Paths.get(this.getIdentifier().getPath(), new String[0]).getParent();
        return path.resolve(this.getName().replace(KEYDELIM, "_") + "-GlobalVariableTables.dss").toString();
    }

    public void deleting() {
        Object object = this.getResOpDbfFile();
        String string = object.getAbsolutePath();
        if (object != null && object.exists()) {
            try {
                if (this.getFileManager().deleteFile(string)) {
                    RssSystem rssSystem = this;
                    rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Failed to delete Ops *.dbf file " + string);
                }
            }
            catch (RemoteException remoteException) {
                RssSystem rssSystem = this;
                rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Error deleting ReservoirOp *.dbf file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
        if (((File)(object = new File(string = string.replace(".dbf", ".mdx")))).exists()) {
            try {
                if (this.getFileManager().deleteFile(string)) {
                    RssSystem rssSystem = this;
                    rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Failed to delete Ops *.mdx file " + string);
                }
            }
            catch (RemoteException remoteException) {
                RssSystem rssSystem = this;
                rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Error deleting ReservoirOp *.mdx file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
        if (((File)(object = new File(string = string.replace(".mdx", ".dbt")))).exists()) {
            try {
                if (this.getFileManager().deleteFile(string)) {
                    RssSystem rssSystem = this;
                    rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Failed to delete Ops *.dbt file " + string);
                }
            }
            catch (RemoteException remoteException) {
                RssSystem rssSystem = this;
                rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Error deleting ReservoirOp *.dbt file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
        object = this.getResSysOpDbfFile();
        string = object.getAbsolutePath();
        if (object != null && object.exists()) {
            try {
                if (!this.getFileManager().deleteFile(string)) {
                    RssSystem rssSystem = this;
                    rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Failed to delete Sys Ops *.dbf file " + string);
                }
            }
            catch (RemoteException remoteException) {
                RssSystem rssSystem = this;
                rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Error deleting ReservoirSysOp *.dbf file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
        if (((File)(object = new File(string = string.replace(".dbf", ".mdx")))).exists()) {
            try {
                if (!this.getFileManager().deleteFile(string)) {
                    RssSystem rssSystem = this;
                    rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Failed to delete Sys Ops *.mdx file " + string);
                }
            }
            catch (RemoteException remoteException) {
                RssSystem rssSystem = this;
                rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Error deleting ReservoirSysOp *.mdx file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
        if (((File)(object = new File(string = string.replace(".mdx", ".dbt")))).exists()) {
            try {
                if (!this.getFileManager().deleteFile(string)) {
                    RssSystem rssSystem = this;
                    rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Failed to delete Sys Ops *.dbt file " + ((File)object).getPath());
                }
            }
            catch (RemoteException remoteException) {
                RssSystem rssSystem = this;
                rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Error deleting ReservoirSysOp *.dbt file" + string + " Error:" + String.valueOf(remoteException));
            }
        }
        if ((object = this.getIdentifier().getFile()) != null && object.exists()) {
            try {
                if (!this.getFileManager().deleteFile(object.getPath())) {
                    RssSystem rssSystem = this;
                    rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Failed to delete *.rsys file " + object.getPath());
                }
            }
            catch (RemoteException remoteException) {
                RssSystem rssSystem = this;
                rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Error deleting *.rsys file" + object.getPath() + " Error:" + String.valueOf(remoteException));
            }
        }
        string = new Identifier(this.getDssPairedDataFilePath());
        try {
            object = this.getFileManager().openFile(UserId.getUserId(), (Identifier)string);
            if (object != null) {
                this.getDSSFileManager().close(object.getPath());
                if (!this.getFileManager().deleteFile(object.getPath())) {
                    RssSystem rssSystem = this;
                    rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Failed to delete RssSystem's Paired Data *.dss file " + object.getPath());
                }
            }
            return;
        }
        catch (RemoteException remoteException) {
            RssSystem rssSystem = this;
            rssSystem.printWarningMessage(rssSystem.getName() + ".deleting: Error deleting RssSystem's Paired Data *.dss file" + string.getPath() + " Error:" + String.valueOf(remoteException));
            return;
        }
    }

    public void renamed(Identifier identifier) {
        super.renamed(identifier);
        if (identifier == null) {
            return;
        }
        this.resetAndSaveOperations();
    }

    public void resetAndSaveOperations() {
        int n;
        int n2;
        Object object;
        try {
            if (this.z != null) {
                this.z.close();
            }
            if (this.A != null) {
                this.A.close();
            }
        }
        catch (IOException iOException) {}
        this.z = null;
        this.A = null;
        boolean bl = Logger.canDebug((String)"ResSimOperations");
        for (int i = 0; i < this._elementVector.size(); ++i) {
            object = this._elementVector.get(i);
            if (!(object instanceof ReservoirElement)) continue;
            ReservoirElement reservoirElement = (ReservoirElement)object;
            ReservoirOp reservoirOp = reservoirElement.getReservoirOp();
            n2 = reservoirElement._resOpDbfId;
            reservoirElement._resOpDbfId = -1;
            reservoirOp.setName(reservoirElement.getResOpName());
            reservoirElement._resOpDbfId = n = this.saveReservoirOp(reservoirOp, -1);
            if (!bl) continue;
            System.out.println("resetAndSaveOperations: ResElem " + reservoirElement.getName() + " had Op id=" + n2 + " now has Op id=" + n);
        }
        ReservoirSysOp[] reservoirSysOpArray = this.getReservoirSysOps();
        object = this.getElementVectorByClass(ReservoirElement.class);
        for (int i = 0; i < reservoirSysOpArray.length; ++i) {
            ReservoirSysOp reservoirSysOp = reservoirSysOpArray[i];
            n2 = reservoirSysOp.getIndex();
            n = this.saveReservoirSysOp(reservoirSysOp, n2);
            for (int j = ((Vector)object).size() - 1; j >= 0; --j) {
                ReservoirElement reservoirElement = (ReservoirElement)((Vector)object).get(j);
                if (reservoirElement._resSysOpId != (long)n2) continue;
                if (bl) {
                    System.out.println("resetAndSaveOperations: ResElem " + reservoirElement.getName() + " had SysOp id=" + reservoirElement._resSysOpId + " now has SysOp id=" + n);
                }
                reservoirElement._resSysOpId = n;
                ((Vector)object).remove(j);
            }
        }
        this.setModified(true);
    }

    protected String getResOpDbfFileName() {
        String string = RMAIO.getDirectoryFromPath((String)this._identifier.getPath());
        string = string.concat("/").concat(RMAIO.getFileNameNoExtension((String)this._identifier.getPath()));
        string = string.concat("Op.dbf");
        return string;
    }

    protected String getResSysOpDbfFileName() {
        String string = RMAIO.getDirectoryFromPath((String)this._identifier.getPath());
        string = string.concat("/").concat(RMAIO.getFileNameNoExtension((String)this._identifier.getPath()));
        string = string.concat("SysOp.dbf");
        return string;
    }

    public DbfFile getResOpDbfFile() {
        if (this.z == null) {
            String string = this.getResOpDbfFileName();
            this.z = this.getDbfFile(string);
        }
        return this.z;
    }

    public DbfFile getResSysOpDbfFile() {
        if (this.A == null) {
            String string = this.getResSysOpDbfFileName();
            this.A = this.getDbfFile(string);
        }
        return this.A;
    }

    protected DbfFile getDbfFile(String string) {
        Identifier identifier;
        DbfIdentifier dbfIdentifier = new DbfIdentifier(string);
        try {
            identifier = this.getFileManager().openFile(UserId.getUserId(), (Identifier)dbfIdentifier);
            if (identifier == null) {
                identifier = this.getFileManager().newFile(UserId.getUserId(), (Identifier)dbfIdentifier);
            }
        }
        catch (RemoteException remoteException) {
            RssSystem rssSystem = this;
            rssSystem.printMessage(rssSystem.getName() + "getDbfFile: RMI Error getting DBFfile  " + String.valueOf(remoteException));
            return null;
        }
        if (identifier == null) {
            RssSystem rssSystem = this;
            rssSystem.printMessage(rssSystem.getName() + ".getDbfFile: failed to open " + string);
            return null;
        }
        dbfIdentifier = (DbfFile)identifier.getFile();
        if (dbfIdentifier != null && !dbfIdentifier.exists()) {
            identifier = new AsciiSerializableDbfHeader();
            try {
                Identifier identifier2 = identifier;
                dbfIdentifier.createDbfFile((DBFHeader)identifier2, identifier2.getTag4infoContainer());
            }
            catch (Error4usage error4usage) {
                RssSystem rssSystem = this;
                rssSystem.printMessage(rssSystem.getName() + ".getDbfFile: Error creating DBF file " + string + " Error:" + String.valueOf((Object)error4usage));
                return null;
            }
        }
        return dbfIdentifier;
    }

    public boolean deserializeString(AsciiSerializable asciiSerializable, String object) {
        try {
            if (this.B == null) {
                this.B = new HecAsciiDeserializer(new BufferedReader(new StringReader((String)object)));
                this.B.addClassMapping("hec.model.TSRecordProxy", TSRecordProxy.class.getName());
                this.B.setDssFileManager((BaseDSSManager)this.getDSSFileManager());
                this.B.setFileManager(this.getFileManager());
            } else {
                object = new StringReader(((String)object).toString());
                object = new BufferedReader((Reader)object);
                this.B.reset((BufferedReader)object);
            }
            this.B.setWorkspacePath(RMAIO.getDirectoryFromPath((String)this.getIdentifier().getPath()));
            return this.B.deserializeObject((Object)asciiSerializable);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public StringBuffer serializeObjectToString(AsciiSerializable asciiSerializable) {
        StringBuffer stringBuffer = null;
        try {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
            if (this.C == null) {
                this.C = new HecAsciiSerializer(bufferedWriter);
                this.C.setDssFileManager((BaseDSSManager)this.getDSSFileManager());
                this.C.setFileManager(this.getFileManager());
            } else {
                this.C.reset(bufferedWriter);
            }
            this.C.setWorkspacePath(RMAIO.getDirectoryFromPath((String)this.getIdentifier().getPath()));
            this.C.serializeObject((Object)asciiSerializable);
            bufferedWriter.flush();
            stringBuffer = stringWriter.getBuffer();
        }
        catch (IOException iOException) {}
        return stringBuffer;
    }

    public void setComputeCanceled(boolean bl) {
        this.G = bl;
    }

    public boolean isComputeCanceled() {
        return this.G;
    }

    public RssTSLocation getTimeSeriesLocation(String object, String string) {
        Vector<Element> vector;
        if (object == null || string == null) {
            System.out.println("RssSystem.getTimeSeries: one or more null arguments elementType=" + (String)object + " elementName=" + string);
            return null;
        }
        if (REACH_STR.equalsIgnoreCase((String)object)) {
            vector = this.getElementVectorByClass(ReachElement.class);
        } else if (RESERVOIR_STR.equalsIgnoreCase((String)object)) {
            vector = this.getElementVectorByClass(ReservoirElement.class);
        } else if (DIVERSION_STR.equalsIgnoreCase((String)object)) {
            vector = this.getElementVectorByClass(DiversionElement.class);
        } else if (JUNCTION_STR.equalsIgnoreCase((String)object)) {
            vector = this.getElementVectorByClass(JunctionElement.class);
        } else {
            System.out.println("RssSystem.getTimeSeries: unknown element type " + (String)object + " elementName=" + string);
            return null;
        }
        if (vector == null || vector.size() == 0) {
            System.out.println("RssSystem.getTimeSeries: no " + (String)object + " elements found in network ");
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            object = vector.get(i);
            if (!string.equalsIgnoreCase(object.getName())) continue;
            return object;
        }
        return null;
    }

    public RssTSLocation getTimeSeriesLocation(int n, String string) {
        Vector<Element> vector;
        if (string == null) {
            System.out.println("RssSystem.getTimeSeriesLocation: null element name");
            return null;
        }
        if (n == 0) {
            vector = this.getElementVectorByClass(ReachElement.class);
        } else if (1 == n) {
            vector = this.getElementVectorByClass(ReservoirElement.class);
        } else if (3 == n) {
            vector = this.getElementVectorByClass(DiversionElement.class);
        } else if (2 == n) {
            vector = this.getElementVectorByClass(JunctionElement.class);
        } else {
            System.out.println("RssSystem.getTimeSeriesLocation: unknown element type " + n + " elementName=" + string);
            return null;
        }
        if (vector == null || vector.size() == 0) {
            System.out.println("RssSystem.getTimeSeriesLocation: no " + n + " elements found in network ");
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Element element = vector.get(i);
            if (!string.equalsIgnoreCase(element.getName())) continue;
            return element;
        }
        return null;
    }

    @Scriptable
    public TSRecord getTimeSeries(String string, String string2, String string3, String string4) {
        return this.getTimeSeries(string, string2, string3, string4, false);
    }

    @Scriptable
    public TSRecord getTimeSeries(String object, String string, String string2, String string3, String string4) {
        if (string4 == null || string4.isEmpty()) {
            return this.getTimeSeries((String)object, string, string2, string3, false);
        }
        object = this.getRssRun();
        if (object == null) {
            return null;
        }
        ((RssRun)object).getLogLevel();
        switch (string4.toLowerCase()) {
            case "unreg": {
                object = ((RssRun)object).getUnregOutputTSData();
                string2 = "UNREG";
                object = object.getTSRecordByPathParts(string, string3 + "-" + string2);
                break;
            }
            case "cumloc": {
                object = ((RssRun)object).getCumLocOutputTSData();
                string2 = "CUMLOC";
                object = object.getTSRecordByPathParts(string, string3 + "-" + string2);
                break;
            }
            case "reg": {
                if ("pool".equalsIgnoreCase(string2)) {
                    string = string.concat("-").concat(string2);
                }
                object = ((RssRun)object).getTSRecordByPathParts(string, string3);
                break;
            }
            default: {
                object = ((RssRun)object).getTSRecordByPathParts(string, string3);
            }
        }
        return object;
    }

    @Scriptable
    public TSRecord getTimeSeries(int n, String object, String string, int n2) {
        RssRun rssRun = this.getRssRun();
        if (rssRun == null) {
            return null;
        }
        boolean bl = rssRun.getLogLevel() == 10;
        Object object2 = switch (n) {
            case 1 -> rssRun.getUnregOutputTSData();
            case 4 -> rssRun.getCumLocOutputTSData();
            case 0 -> rssRun.getRegOutputTSData();
            default -> rssRun.getOutputTSData();
        };
        object = this.getTimeSeriesLocation((String)object, string);
        if (!(object instanceof Element)) {
            return null;
        }
        Element cfr_ignored_0 = (Element)object;
        if (object2 != null) {
            int n3 = object2.getTSRecordCount();
            object2 = object2.getTSRecords();
            for (int i = 0; i < n3; ++i) {
                rssRun = (TSRecord)((Vector)object2).get(i);
                if (rssRun == null) continue;
                String string2 = this.getNameForKeyString(rssRun.getName());
                int n4 = rssRun.getVariableId();
                if (bl) {
                    System.out.println("getTimeSeries: checking " + string2 + "(" + n4 + ") against " + string + "(" + n2 + ")");
                }
                if (!string.equalsIgnoreCase(string2) || n2 != n4) continue;
                return rssRun;
            }
        }
        return null;
    }

    @Scriptable
    public TSRecord getTimeSeries(int n, String object, String string, String string2, String string3) {
        Object object2 = this.getRssRun();
        if (object2 == null) {
            return null;
        }
        boolean bl = ((RssRun)object2).getLogLevel() == 10;
        Object object3 = switch (n) {
            case 1 -> ((RssRun)object2).getUnregOutputTSData();
            case 4 -> ((RssRun)object2).getCumLocOutputTSData();
            case 0 -> ((RssRun)object2).getRegOutputTSData();
            default -> ((RssRun)object2).getOutputTSData();
        };
        if (string2 != null && string2.length() > 0) {
            object2 = string;
            object2 = string2.startsWith("_") ? (String)object2 + string2 : (String)object2 + "-" + string2;
        } else {
            object2 = string;
        }
        object = this.getTimeSeriesLocation((String)object, string);
        if (!(object instanceof Element)) {
            return null;
        }
        Element cfr_ignored_0 = (Element)object;
        if (object3 != null) {
            int n2 = object3.getTSRecordCount();
            object3 = object3.getTSRecords();
            for (int i = 0; i < n2; ++i) {
                string = (TSRecord)((Vector)object3).get(i);
                if (string == null) continue;
                String string4 = this.getNameForKeyString(string.getName());
                if (bl) {
                    System.out.println("getTimeSeries: checking " + string4 + "(" + string.getParamName() + ") against " + string2 + "(" + string3 + ")");
                }
                if (!((String)object2).equalsIgnoreCase(string4) || !string3.equalsIgnoreCase(string.getParamName())) continue;
                return string;
            }
        }
        return null;
    }

    @Scriptable
    public TSRecord getTimeSeries(String string, String string2, String string3, String string4, boolean bl) {
        TSRecordProxy tSRecordProxy;
        TSRecord tSRecord = null;
        if (this.u != null && !this.u.isEmpty()) {
            tSRecord = (TSRecord)this.u.get(string + string2 + string3 + string4);
        }
        if (tSRecord == null && (tSRecordProxy = this.getTSRecordProxy(string, string2, string3, string4, bl)) != null) {
            tSRecord = tSRecordProxy.getTSRecord();
            if (this.u != null && tSRecord != null) {
                this.u.put(string + string2 + string3 + string4, tSRecord);
            }
        }
        return tSRecord;
    }

    public TSRecordProxy getTSRecordProxy(String object, String string, String object2, String object3, boolean bl) {
        RssTSLocation rssTSLocation = this.getTimeSeriesLocation((String)object, string);
        if (rssTSLocation == null) {
            return null;
        }
        boolean bl2 = this.isDebug();
        if (object3 == null) {
            System.out.println("getTimeSeries: null argument TimeSeriesParam=" + (String)object3);
            return null;
        }
        if (bl2) {
            System.out.println("getTimeSeries: elementType=" + (String)object + " elementName=" + string + " childElementName=" + (String)object2 + " TimeSeriesParam=" + (String)object3);
        }
        if (!(rssTSLocation instanceof Element)) {
            return null;
        }
        object = (Element)rssTSLocation;
        if (((String)object3).length() > 0) {
            object2 = object2 != null && ((String)object2).length() > 0 ? string + "-" + (String)object2 : string;
        }
        if (bl2) {
            System.out.println("getTimeSeries: checking element " + object.getName());
        }
        if (string.equalsIgnoreCase(object.getName())) {
            object = this.buildTSProxies(bl, (Element)object);
            TSRecord tSRecord = null;
            if ((object2 = this.findTsRecordProxy((Vector)object, bl2, (String)object2, (String)object3)) != null) {
                tSRecord = object2.getTSRecord();
            }
            if (tSRecord != null) {
                return object2;
            }
            Object object4 = object3 = string + (String)object3;
            object2 = this.findTsRecordProxy((Vector)object, bl2, (String)object4, (String)object4);
            if (object2 != null) {
                tSRecord = object2.getTSRecord();
            }
            if (tSRecord != null) {
                return object2;
            }
        }
        return null;
    }

    private boolean isDebug() {
        boolean bl = false;
        RssRun rssRun = this.getRssRun();
        if (rssRun != null) {
            bl = rssRun.getLogLevel() == 10;
        }
        return bl;
    }

    private Vector buildTSProxies(boolean bl, Element object) {
        Vector vector = new Vector();
        vector = bl ? ((Element)object).getActiveTSProxies(vector, 1) : ((Element)object).getActiveTSProxies(vector, 0);
        object = ((Element)object).getDownstreamNodes(null);
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            RssNode rssNode = (RssNode)object.get(i);
            if (bl) {
                rssNode.getActiveTSProxies(vector, 1);
                continue;
            }
            rssNode.getActiveTSProxies(vector, 0);
        }
        return vector;
    }

    private Vector buildTsProxies(Element iterator) {
        Vector vector = ((Element)((Object)iterator)).getActiveTSProxies(null, 1);
        vector = ((Element)((Object)iterator)).getActiveTSProxies(vector, 0);
        iterator = ((Element)((Object)iterator)).getDownstreamNodes(null);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof RssNode)) continue;
            object = (RssNode)object;
            ((RssNode)object).getActiveTSProxies(vector, 1);
            ((RssNode)object).getActiveTSProxies(vector, 0);
        }
        return vector;
    }

    private TSRecordProxy findTsRecordProxy(Vector vector, boolean bl, String string, String string2) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)vector.get(i);
            if (tSRecordProxy == null) continue;
            String string3 = this.getNameForKeyString(tSRecordProxy.getName());
            if (bl) {
                System.out.println("getTimeSeries: checking " + string3 + "(" + tSRecordProxy.getParamName() + ") against " + string + "(" + string2 + ")");
            }
            if (!string.equalsIgnoreCase(string3) || !string2.equalsIgnoreCase(tSRecordProxy.getParamName())) continue;
            return tSRecordProxy;
        }
        return null;
    }

    public TSRecord getTimeSeries(int n, String string, int n2) {
        Object object;
        if (this.u != null && (object = (TSRecord)this.u.get(n + string + n2)) != null) {
            return object;
        }
        object = this.getTimeSeriesLocation(n, string);
        if (object != null) {
            boolean bl = this.isDebug();
            if (bl) {
                System.out.println("getTimeSeries: elementType=" + n + " elementName=" + string + " VID=" + n2);
            }
            if (object instanceof Element) {
                object = (Element)object;
                if (bl) {
                    System.out.println("getTimeSeries: checking element " + object.getName());
                }
                if (string.equalsIgnoreCase(object.getName())) {
                    object = this.buildTsProxies((Element)object);
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object object2 = object.next();
                        if (!(object2 instanceof TSRecordProxy)) continue;
                        object2 = (TSRecordProxy)object2;
                        String string2 = this.getNameForKeyString(object2.getName());
                        if (bl) {
                            System.out.println("getTimeSeries: checking " + string2 + "(" + object2.getIndex() + ") against " + n2);
                        }
                        if (!string.equalsIgnoreCase(object2.getName()) || n2 != object2.getIndex()) continue;
                        object = object2.getTSRecord();
                        if (this.u != null && object != null) {
                            this.u.put(n + string + n2, object);
                        }
                        return object;
                    }
                }
            }
        }
        return null;
    }

    public static List a() {
        if (e == null) {
            e = new ArrayList<String>();
            e.add("getTimeSeries(java.lang.String,java.lang.String,java.lang.String,java.lang.String)");
        }
        return e;
    }

    public void writeHotstartStates(RunTimeWindow runTimeWindow) {
        if (this.h.getHotstartOptions().shouldCreateHotstart()) {
            Object object = this.S.values();
            object = object.iterator();
            while (object.hasNext()) {
                HotstartContainer hotstartContainer = (HotstartContainer)object.next();
                if (!hotstartContainer.canSave(runTimeWindow)) continue;
                hotstartContainer.saveFile();
            }
        }
    }

    public boolean shouldSaveHotstartAtTimeStep(int n, int n2) {
        return this.T != -1 && n == this.T && n2 != 3 || this.V != null && Arrays.binarySearch(this.V, n) >= 0;
    }

    @Scriptable
    public List<JunctionElement> getHeadwaterJunctions() {
        ArrayList<JunctionElement> arrayList = new ArrayList<JunctionElement>();
        int n = this._elementVector.size();
        for (int i = 0; i < n; ++i) {
            RssNode rssNode;
            Element element = (Element)this._elementVector.get(i);
            if (!(element instanceof JunctionElement) || (rssNode = (element = (JunctionElement)element).getUpstreamNode()) == null || rssNode.getUpstreamElement() != null) continue;
            arrayList.add((JunctionElement)element);
        }
        return arrayList;
    }

    public boolean didConversionOccur() {
        return this.W;
    }

    public void setWaterAccountSetList(List<WaterAccountSet> list) {
        this._waterAccountSetList = list;
        this.setModified(true);
    }

    public List<WaterAccountSet> getWaterAccountSetList() {
        return this._waterAccountSetList;
    }

    public void addWaterAccountSet(WaterAccountSet waterAccountSet) {
        if (this._waterAccountSetList == null) {
            this._waterAccountSetList = new ArrayList<WaterAccountSet>();
        }
        if (!this._waterAccountSetList.contains(waterAccountSet)) {
            this._waterAccountSetList.add(waterAccountSet);
        }
    }

    public WaterAccountSet getWaterAccountSet(int n) {
        if (this._waterAccountSetList != null) {
            for (int i = 0; i < this._waterAccountSetList.size(); ++i) {
                WaterAccountSet waterAccountSet = this._waterAccountSetList.get(i);
                if (waterAccountSet.getIndex() != n) continue;
                return waterAccountSet;
            }
        }
        return null;
    }

    public int nextWaterAccountSetIndex() {
        int n = this._nextWaterAcountSetIndex++;
        return n;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    public List<OpRule> getSystemRules() {
        Object object;
        ArrayList<OpRule> arrayList = new ArrayList<OpRule>();
        if (this._downstreamOpTable != null) {
            object = this._downstreamOpTable.values();
            object = object.iterator();
            while (object.hasNext()) {
                DownstreamOp downstreamOp = (DownstreamOp)object.next();
                DownstreamOpRule downstreamOpRule = downstreamOp.getDownstreamOpRule(0);
                if (downstreamOpRule == null) continue;
                arrayList.add(downstreamOp.getDownstreamOpRule(0));
            }
        }
        if (this._systemHydropowerRuleTable != null) {
            object = this._systemHydropowerRuleTable.values();
            object = object.iterator();
            while (object.hasNext()) {
                arrayList.add((OpRule)object.next());
            }
        }
        return arrayList;
    }

    public int compute(RunTimeWindow runTimeWindow, RssRun rssRun, int n, boolean bl) {
        int n2;
        if (Boolean.getBoolean("computeRS4")) {
            this.K = 2;
            n2 = this.computeRS4(runTimeWindow, rssRun, n, bl);
        } else if (Boolean.getBoolean("computeDevOld")) {
            this.K = 1;
            n2 = this.compute_DevOld(runTimeWindow, rssRun, n, bl);
        } else {
            this.K = 0;
            n2 = this.compute3x(runTimeWindow, rssRun, n, bl);
        }
        return n2;
    }

    public int computeRS4(RunTimeWindow runTimeWindow, RssRun rssRun, int n, boolean bl) {
        ComputeEngine computeEngine = new ComputeEngine();
        computeEngine.a(this, runTimeWindow, rssRun, n, bl);
        computeEngine.a();
        return 0;
    }

    public int computeEventQueue(RunTimeWindow runTimeWindow, RssRun object, int n, boolean bl) {
        object = new RSEngine(this);
        RSNetworkAdapter2 rSNetworkAdapter2 = new RSNetworkAdapter2(this);
        rSNetworkAdapter2.a((RSEngine)object, runTimeWindow, n);
        ((RSEngine)object).f();
        ((RSEngine)object).g();
        return 0;
    }

    public int compute_DevOld(RunTimeWindow runTimeWindow, RssRun rssRun, int n, boolean bl) {
        int n2;
        this.initHotstart(runTimeWindow);
        int n3 = runTimeWindow.getNumSteps();
        int n4 = runTimeWindow.getNumLookbackSteps();
        this.c = runTimeWindow;
        this.M = -1;
        this.N = -1;
        this.O = -1;
        this.P = -1;
        this.Q = -1;
        HotstartOptions hotstartOptions = this.h.getHotstartOptions();
        if (bl) {
            if (hotstartOptions.shouldLoadHotstart() && n != 3) {
                n2 = this.t.size();
                for (int i = 0; i < n2; ++i) {
                    if (this.loadHotstart(n, runTimeWindow, this.t.get(i), i == n2 - 1)) continue;
                    return 1;
                }
                this.g.incrementComputeProgress(this.getElementCount() * n4);
            } else if (n4 > 0) {
                this.printStatus("Computing Hindcast");
                int n5 = this.simulateHindcast(runTimeWindow, n);
                if (n5 != 0) {
                    if (n5 == 50) {
                        return 50;
                    }
                    this.printErrorMessage("RssSystem.compute: Hindcast simulation failed");
                    return 1;
                }
                this.g.incrementComputeProgress(this.getElementCount() * runTimeWindow.getNumLookbackSteps());
            }
        }
        this.printStatus("Computing Forecast");
        n2 = this.t.size();
        for (int i = 0; i < n2; ++i) {
            int n6;
            IterationBlock iterationBlock = this.t.elementAt(i);
            List<Element> list = iterationBlock.m();
            List<DownstreamOpRule> list2 = null;
            List<SystemHydropowerRule> list3 = null;
            List<StateVariable> list4 = null;
            List<ReservoirElement> list5 = null;
            boolean bl2 = false;
            DecisionEngine decisionEngine = null;
            if (n == 0) {
                list = iterationBlock.m();
                if (list != null) {
                    int n7 = list.size();
                    ArrayList[] cfr_ignored_0 = new ArrayList[n7];
                    decisionEngine = new DecisionEngine(this, iterationBlock, runTimeWindow);
                }
                list2 = iterationBlock.h();
                list5 = iterationBlock.i();
                ArrayList<OpRule> arrayList = new ArrayList<OpRule>();
                int n8 = list.size();
                for (int j = 0; j < n8; ++j) {
                    Object object = list.get(j);
                    if (object == null || !(object instanceof ReleaseElement)) continue;
                    object = (ReleaseElement)object;
                    object.initForecastOperations(runTimeWindow);
                    if (!(object instanceof ReservoirElement)) continue;
                    List<OpRule> list6 = ((ReservoirElement)object).getReservoirOp(false).getActiveOpSet().getRules(null);
                    arrayList.addAll(list6);
                }
                bl2 = iterationBlock.e();
                this.getTandemOp().a(iterationBlock);
                list3 = iterationBlock.k();
                n6 = this.initSystemHydropowerForecast(list3, runTimeWindow);
                if (n6 == 1) {
                    return 1;
                }
                list4 = iterationBlock.l();
            }
            if (n != 0 || list == null || list.size() <= 0) {
                n6 = this.simulateForecast(runTimeWindow, n, iterationBlock, bl);
                if (n6 != 0) {
                    if (n6 == 50) {
                        this.printMessage("Compute Canceled");
                        return 50;
                    }
                    this.printErrorMessage("RssSystem.compute: Forecast simulation failed");
                    return 1;
                }
                this.g.incrementComputeProgress(iterationBlock.c() * runTimeWindow.getForecastSteps());
                continue;
            }
            if (d) {
                this.writeConvergenceHeader(list);
                this.writeElevIterHeader(list);
            }
            int n9 = iterationBlock.f();
            RunTimeStep runTimeStep = new RunTimeStep(runTimeWindow);
            RunTimeStep runTimeStep2 = new RunTimeStep(runTimeWindow);
            int n10 = n9 + 1;
            this.printMessage("Iteration Block " + i + " has " + n9 + " Routing Steps");
            for (n9 = n4 + 1; n9 <= n3; ++n9) {
                int n11;
                runTimeStep.setStep(n9);
                runTimeStep2.setStep(n9 - (n10 - 1));
                this.elemInitTSVals(iterationBlock, runTimeStep, n10);
                this.preComputeResInflow(list, runTimeStep, n10);
                n6 = 0;
                for (n11 = 0; n6 == 0 && n11 < 25; ++n11) {
                    decisionEngine.a(runTimeStep, n10, n11);
                    n6 = this.elemCompute(iterationBlock, runTimeStep, n10, list5, list4);
                    if (n6 != 0) {
                        if (n6 == 50) {
                            this.printMessage("Compute Canceled");
                            return 50;
                        }
                        this.printErrorMessage("RssSystem.compute: Forecast simulation failed");
                        return 1;
                    }
                    n6 = this.testConvergence2(iterationBlock, runTimeStep, n10, list, n11) ? 1 : 0;
                    if (n11 <= 3) {
                        n6 = 0;
                    }
                    this.updateElevEst(iterationBlock, runTimeStep, n10, list, n11);
                    if (!this.G) continue;
                    this.printMessage("Compute Canceled");
                    return 50;
                }
                this.g.incrementComputeProgress(iterationBlock.c());
                if (n6 != 0) {
                    this.g.printMessage("Compute Converged in " + n11 + " iterations on time step " + n9);
                    continue;
                }
                this.g.printWarningMessage("Compute Did Not Converge after " + n11 + " iterations on time step " + n9);
            }
            this.evaluateRulePerformance(runTimeWindow, list, list2, list3, bl2);
            if (decisionEngine != null && d) {
                if (this.Y == null) {
                    try {
                        this.Y = new PrintWriter(new BufferedWriter(new FileWriter("resSimDEngine.out")));
                    }
                    catch (IOException iOException) {
                        IOException iOException2 = iOException;
                        iOException.printStackTrace();
                    }
                }
                decisionEngine.a(this.Y);
            }
            decisionEngine.a();
        }
        if (this._zbWriter != null) {
            this._zbWriter.close();
        }
        if (this._elevWriter != null) {
            this._elevWriter.close();
            this._elevWriter = null;
        }
        if (this._convergWriter != null) {
            this._convergWriter.close();
            this._convergWriter = null;
        }
        if (this.Y != null) {
            this.Y.close();
            this.Y = null;
        }
        return 0;
    }

    private void elemInitTSVals(IterationBlock iterationBlock, RunTimeStep object, int n) {
        int n2 = ((RunTimeStep)object).step;
        int n3 = n2 + n;
        int n4 = object.getTotalNumSteps();
        int n5 = iterationBlock.c();
        for (int i = 0; i < n5; ++i) {
            object = iterationBlock.d(i);
            for (n = n2; n < n3 && n <= n4; ++n) {
                ((Element)object).initTSVals(n);
            }
        }
    }

    private void preComputeResInflow(List<Element> object, RunTimeStep runTimeStep, int n) {
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        int n2 = runTimeStep.getTotalNumSteps();
        Iterator<Element> iterator = object.iterator();
        block0: while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof ReservoirElement)) continue;
            Storage storage = ((ReservoirElement)object).getStorageFunction();
            for (int i = 0; i < n; ++i) {
                runTimeStep2.step = runTimeStep.step + i;
                if (runTimeStep2.step > n2) continue block0;
                storage.computeInflow(runTimeStep2);
            }
        }
    }

    private void controllerUpdateCap(IterationBlock iterationBlock, RunTimeStep runTimeStep, int n) {
        int n2 = runTimeStep.step + n;
        int n3 = runTimeStep.getTotalNumSteps();
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        int n4 = iterationBlock.c();
        for (int i = 0; i < n4; ++i) {
            Element element = iterationBlock.d(i);
            if (!(element instanceof ReservoirElement)) continue;
            OpController opController = ((ReservoirElement)element).getReservoirOp().getController();
            for (int j = runTimeStep.step; j < n2 && j <= n3; ++j) {
                runTimeStep2.setStep(j);
                opController.initOperationStep(runTimeStep2, 0);
                opController.applyPhysicalLimits32(runTimeStep2, true);
            }
        }
    }

    private int ruleEvalLimits(IterationBlock iterationBlock, RunTimeStep runTimeStep, int n, List<Element> list, List<OpRule> list2, List<DownstreamOpRule> list3, List<SystemHydropowerRule> runTimeStep2, boolean n2, List<OpRule>[] listArray, List<StateVariable> list4) {
        int n3;
        int n4 = runTimeStep.step + n;
        int n5 = runTimeStep.getTotalNumSteps();
        runTimeStep2 = new RunTimeStep(runTimeStep);
        n2 = list.size();
        double[] dArray = new double[n2];
        for (n = runTimeStep.step; n < n4 && n <= n5; ++n) {
            Object object;
            runTimeStep2.setStep(n);
            int n6 = this.evalStateVariables(runTimeStep2, list4);
            if (n6 != 0) {
                if (n6 == 50) {
                    return 50;
                }
                this.printErrorMessage("Error evaluating State Variables");
                return 1;
            }
            for (n6 = 0; n6 < n2; ++n6) {
                object = list.get(n6);
                if (!(object instanceof ReservoirElement)) continue;
                dArray[n6] = ((ReservoirElement)object).getStorageFunction().getPreviousElevation(runTimeStep2);
            }
            n6 = iterationBlock.c();
            for (n3 = 0; n3 < n6; ++n3) {
                if (this.G) {
                    this.printMessage("Compute Canceled");
                    return 50;
                }
                object = iterationBlock.d(n3);
                if (!(object instanceof ReservoirElement)) continue;
                ((ReservoirElement)object).getStorageFunction().computeInflow(runTimeStep2);
            }
            object = this.buildSysRuleStack(runTimeStep2, list, dArray, listArray);
            this.applyReleaseOverrides(runTimeStep2, list);
            this.applyElevationOverrides(runTimeStep2, list);
            n6 = object.size();
            for (n3 = 0; n3 < n6; ++n3) {
                this.applyRule(runTimeStep2, n3, (List)object, 10);
            }
            this.applyGCOperation(runTimeStep2, list);
        }
        for (n = runTimeStep.step; n < n4 && n <= n5; ++n) {
            runTimeStep2.setStep(n);
            List<OpRule> list5 = this.buildSysRuleStack(runTimeStep2, list, dArray, listArray);
            n3 = list5.size();
            for (int i = 0; i < n3; ++i) {
                this.balanceSysRule(runTimeStep2, i, list5, 10);
            }
        }
        return 0;
    }

    private int elemCompute(IterationBlock iterationBlock, RunTimeStep runTimeStep, int n, List<ReservoirElement> list, List<StateVariable> list2) {
        int n2 = runTimeStep.step + n;
        int n3 = runTimeStep.getTotalNumSteps();
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        int n4 = iterationBlock.c();
        this.X = runTimeStep;
        iterationBlock.e(3);
        for (int i = runTimeStep.step; i < n2 && i <= n3; ++i) {
            runTimeStep2.setStep(i);
            if (i > runTimeStep.getTotalNumSteps()) break;
            this.Q = i;
            if (this.G) {
                this.printMessage("Compute Canceled");
                return 50;
            }
            for (int j = 0; j < n4; ++j) {
                Element element = iterationBlock.d(j);
                this.P = j;
                this.Q = -1;
                if (!(element instanceof ReservoirElement) && element instanceof ReleaseElement) {
                    ((ReleaseElement)((Object)element)).updateDecisions(runTimeStep2, 10);
                }
                if (element.computeForecastStep(runTimeStep2) == 0) continue;
                this.printErrorMessage("RssSystem.simulateForecast: Forecast compute failed for element " + element.getName());
                return 1;
            }
            if (this.simulatePumpbackStep32(runTimeStep2, list, 10) != 0) {
                this.printErrorMessage("RssSystem.compute: Forecast simulation failed");
                return 1;
            }
            n = this.evalStateVariables(runTimeStep2, list2);
            if (n != 0) {
                if (n == 50) {
                    return 50;
                }
                this.printErrorMessage("Error evaluating State Variables");
                return 1;
            }
            if (i != runTimeStep.step) continue;
            this.X = runTimeStep;
            iterationBlock.e(1);
            if (runTimeStep.step != runTimeStep.getTotalNumSteps() - runTimeStep.getRunTimeWindow().getNumRoutingSteps()) continue;
            this.X = runTimeStep;
            iterationBlock.e(5);
        }
        return 0;
    }

    private void writeConvergenceHeader(List<Element> list) {
        if (this._convergWriter == null) {
            try {
                this._convergWriter = new PrintWriter(new BufferedWriter(new FileWriter("resSimConvergIteration.out")));
            }
            catch (Exception exception) {
                System.out.println(exception);
                return;
            }
        }
        int n = list.size();
        String string = "rst.step";
        for (int i = 0; i < n; ++i) {
            Element element = list.get(i);
            if (!(element instanceof ReservoirElement)) continue;
            string = String.format("%s\t%s-ELEV-DIFF\t%s-OUTFLOW-DIFF\t%s-Oscillating", string, element.getName(), element.getName(), element.getName());
        }
        this._convergWriter.println(string);
    }

    private boolean testConvergence(IterationBlock iterationBlock, RunTimeStep runTimeStep, int n, List<Element> list, int n2) {
        int n3 = list.size();
        if (this.aa == null || this.aa.length < n3) {
            this.aa = new double[n3];
            this.ac = new double[n3];
            this.ab = new double[n3];
            this.ad = new double[n3];
            this.ae = new boolean[n3];
        }
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        int n4 = runTimeStep.getTotalNumSteps();
        String string = null;
        if (this._convergWriter != null) {
            string = Integer.toString(runTimeStep.step);
        }
        boolean bl = true;
        double d = -99999.0;
        double d2 = -99999.0;
        for (int i = 0; i < n3; ++i) {
            Element element = list.get(i);
            this.ae[i] = false;
            if (!(element instanceof ReservoirElement)) continue;
            Storage storage = ((ReservoirElement)element).getStorageFunction();
            boolean bl2 = false;
            for (int j = 0; j < n; ++j) {
                runTimeStep2.step = runTimeStep.step + j;
                if (runTimeStep2.step > n4) break;
                d = storage.getElevation(runTimeStep2) - storage.getElevationEst33(runTimeStep2);
                d2 = storage.getOutflow(runTimeStep2) - storage.getOutflowEst33(runTimeStep2);
                if (Math.abs(d) > 0.001) {
                    bl2 = true;
                    bl = false;
                }
                if (Math.abs(d2) > 0.01) {
                    bl2 = true;
                    bl = false;
                }
                if (bl2) break;
            }
            if (n2 >= 2 && bl2 && (this.aa[i] * d < 0.0 || this.ac[i] * d2 < 0.0)) {
                this.ae[i] = true;
                this.ad[i] = 0.5 * (storage.getElevation(runTimeStep) + this.ab[i]);
            }
            this.aa[i] = d;
            this.ac[i] = d2;
            this.ab[i] = storage.getElevation(runTimeStep);
            if (this._convergWriter == null) continue;
            string = String.format("%s\t%.4f\t%.4f\t%b", string, d, d2, this.ae[i]);
        }
        if (this._convergWriter != null) {
            this._convergWriter.println(string);
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean testConvergence2(IterationBlock var1_1, RunTimeStep var2_5, int var3_6, List<Element> var4_7, int var5_8) {
        var6_9 = var4_7.size();
        var8_10 = new RunTimeStep(var2_5);
        var9_11 = var2_5.getTotalNumSteps();
        if (this.aa == null || this.aa.length < var6_9) {
            this.aa = new double[var6_9];
            this.ac = new double[var6_9];
            this.ab = new double[var6_9];
            this.ad = new double[var6_9];
            this.ae = new boolean[var6_9];
            var10_12 = 0;
            for (var1_2 = 0; var1_2 < var6_9; ++var1_2) {
                var7_14 = var4_7.get(var1_2);
                if (!(var7_14 instanceof ReservoirElement)) continue;
                var10_12 = var10_12 + 1;
            }
            this.af = new StorageZone[var10_12.intValue()][var3_6][4];
        }
        var10_13 = this.ag.length;
        if (var5_8 == 0) {
            for (var1_3 = 0; var1_3 < var10_13; var1_3 += 1) {
                for (var7_15 = 0; var7_15 < var3_6; ++var7_15) {
                    for (var11_18 = 0; var11_18 < 4; ++var11_18) {
                        this.af[var1_3][var7_15][var11_18] = null;
                    }
                }
            }
        }
        var11_19 = null;
        if (this._convergWriter != null) {
            var11_19 = Integer.toString(var2_5.step);
        }
        if (this._zbWriter == null) {
            try {
                this._zbWriter = new PrintWriter(new BufferedWriter(new FileWriter("resSimZBConvergence.out")));
                this._zbWriter.println("StartRTS, Icnt, TempRTS, ResIdx, Elev, Q, ZBCode");
            }
            catch (Exception var17_20) {
                System.out.println(var17_20);
            }
        }
        var10_13 = 1;
        var17_21 = -99999.0;
        var19_22 = -99999.0;
        var12_23 = var5_8 % 4;
        for (var1_4 = 0; var1_4 < var6_9; ++var1_4) {
            block25: {
                var7_16 /* !! */  = var4_7.get(var1_4);
                this.ae[var1_4] = false;
                if (!(var7_16 /* !! */  instanceof ReservoirElement)) continue;
                var13_24 = (ReservoirElement)var7_16 /* !! */ ;
                var14_26 = var13_24.getStorageFunction();
                var7_16 /* !! */  = var13_24.getReservoirOp(false);
                var15_28 = var7_16 /* !! */ .getActiveOpSet();
                if (this.ah == null) continue;
                var16_29 = this.ah.get(var13_24);
                var7_17 = 0;
                for (var21_30 = 0; var21_30 <= 0; ++var21_30) {
                    var8_10.step = var2_5.step + var21_30;
                    if (var8_10.step > var9_11) break;
                    var17_21 = var14_26.getElevation(var8_10) - var14_26.getElevationEst33(var8_10);
                    var19_22 = var14_26.getOutflow(var8_10) - var14_26.getOutflowEst33(var8_10);
                    if (Math.abs(var17_21) > 0.001) {
                        var7_17 = 1;
                        var10_13 = 0;
                    }
                    if (Math.abs(var19_22) > 0.01) {
                        var7_17 = 1;
                        var10_13 = 0;
                    }
                    if (var7_17 != 0) break;
                }
                for (var21_30 = 0; var21_30 < var3_6; ++var21_30) {
                    var8_10.step = var2_5.step + var21_30;
                    if (var8_10.step > var9_11) break;
                    var28_37 = var14_26.getElevation(var8_10);
                    this.af[var16_29][var21_30][var12_23] = var15_28.getActiveZone(var28_37, var8_10);
                    var30_40 = var14_26.getOutflow(var8_10);
                    var22_31 = var13_24.getName().substring(3);
                    var23_33 = 0;
                    if (this.ag[var16_29][var8_10.step] != null) {
                        var23_33 = 1;
                    }
                    var11_19 = String.format("%d, %d, %d, %s, %.4f, %.4f, %d", new Object[]{var2_5.step, var5_8, var8_10.step, var22_31, var28_37, var30_40, var23_33});
                    this._zbWriter.println(var11_19);
                }
                if (var5_8 >= 2 && var7_17 != 0 && (this.aa[var1_4] * var17_21 < 0.0 || this.ac[var1_4] * var19_22 < 0.0)) {
                    this.ae[var1_4] = true;
                    this.ad[var1_4] = 0.5 * (var14_26.getElevation(var2_5) + this.ab[var1_4]);
                }
                this.aa[var1_4] = var17_21;
                this.ac[var1_4] = var19_22;
                this.ab[var1_4] = var14_26.getElevation(var2_5);
                if (var5_8 < 3) break block25;
                var12_23 = var5_8 % 4;
                var28_38 = (var5_8 - 1) % 4;
                var29_39 = (var5_8 - 2) % 4;
                var30_41 = (var5_8 - 3) % 4;
                for (var21_30 = 0; var21_30 < var3_6; ++var21_30) {
                    block26: {
                        block28: {
                            block27: {
                                var8_10.step = var2_5.step + var21_30;
                                if (var8_10.step > var9_11) break;
                                var31_42 = this.af[var16_29][var21_30][var12_23] == this.af[var16_29][var21_30][var28_38];
                                var22_32 = this.af[var16_29][var21_30][var12_23] == this.af[var16_29][var21_30][var29_39];
                                var23_34 = this.af[var16_29][var21_30][var12_23] == this.af[var16_29][var21_30][var30_41];
                                var7_17 = this.af[var16_29][var21_30][var28_38] == this.af[var16_29][var21_30][var29_39] ? 1 : 0;
                                var13_25 = this.af[var16_29][var21_30][var28_38] == this.af[var16_29][var21_30][var30_41] ? 1 : 0;
                                this.af[var16_29][var21_30][var29_39];
                                this.af[var16_29][var21_30][var30_41];
                                var14_27 = var15_28.checkZonesAdjacent(this.af[var16_29][var21_30][var12_23], this.af[var16_29][var21_30][var28_38]);
                                var24_36 = var15_28.checkZonesAdjacent(this.af[var16_29][var21_30][var28_38], this.af[var16_29][var21_30][var29_39]);
                                var13_25 = var31_42 == false && var22_32 != false && var13_25 != 0 && var14_27 != false ? 1 : 0;
                                var14_27 = var23_34 != false && var7_17 != 0 && var31_42 == false && var14_27 != false;
                                var7_17 = var23_34 != false && var7_17 == 0 && (var31_42 != false || var22_32 != false) && var24_36 != false && var5_8 >= 10 ? 1 : 0;
                                var22_32 = var31_42 != false && var22_32 != false && var23_34 != false;
                                var23_35 = this.ag[var16_29][var8_10.step];
                                if (var13_25 == 0 && !var14_27 && var7_17 == 0) break block26;
                                if (this.af[var16_29][var21_30][var12_23] != null) break block27;
                                this.ag[var16_29][var8_10.step] = this.af[var16_29][var21_30][var28_38];
                                break block28;
                            }
                            if (this.af[var16_29][var21_30][var28_38] == null) ** GOTO lbl-1000
                            if (var7_17 != 0 && var31_42) {
                                this.ag[var16_29][var8_10.step] = this.af[var16_29][var21_30][var29_39].getElevation(var8_10) < this.af[var16_29][var21_30][var12_23].getElevation(var8_10) ? this.af[var16_29][var21_30][var29_39] : this.af[var16_29][var21_30][var12_23];
                            } else if (this.af[var16_29][var21_30][var28_38].getElevation(var8_10) < this.af[var16_29][var21_30][var12_23].getElevation(var8_10)) {
                                this.ag[var16_29][var8_10.step] = this.af[var16_29][var21_30][var28_38];
                            } else lbl-1000:
                            // 2 sources

                            {
                                this.ag[var16_29][var8_10.step] = this.af[var16_29][var21_30][var12_23];
                            }
                        }
                        if (this.ag[var16_29][var8_10.step] == var23_35) continue;
                        var7_17 = var3_6 - var21_30;
                        for (var13_25 = 1; var13_25 < var7_17 && var8_10.step + var13_25 <= var9_11; ++var13_25) {
                            this.ag[var16_29][var8_10.step + var13_25] = null;
                        }
                        break;
                    }
                    if (!var22_32 || this.ag[var16_29][var8_10.step] == this.af[var16_29][var21_30][var12_23] && var5_8 > 5 || var23_35 == null) continue;
                    var7_17 = var3_6 - var21_30;
                    for (var13_25 = 0; var13_25 < var7_17 && var8_10.step + var13_25 <= var9_11; ++var13_25) {
                        this.ag[var16_29][var8_10.step + var13_25] = null;
                    }
                    break;
                }
            }
            if (this._convergWriter == null) continue;
            var11_19 = String.format("%s\t%.4f\t%.4f\t%b", new Object[]{var11_19, var17_21, var19_22, this.ae[var1_4]});
        }
        if (this._convergWriter != null) {
            this._convergWriter.println(var11_19);
        }
        return (boolean)var10_13;
    }

    private void writeElevIterHeader(List<Element> list) {
        if (this._elevWriter == null) {
            try {
                this._elevWriter = new PrintWriter(new BufferedWriter(new FileWriter("resSimElevIteration.out")));
            }
            catch (Exception exception) {
                System.out.println(exception);
                return;
            }
        }
        int n = list.size();
        String string = String.format("%s\t%s\t%s", "rst.step", "icnt", "j-step");
        for (int i = 0; i < n; ++i) {
            Element element = list.get(i);
            if (!(element instanceof ReservoirElement)) continue;
            string = String.format("%s\t%s-ELEV\t%s-ELEVEST\t%s-OUTFLOW\t%s-OUTFLOWEST", string, element.getName(), element.getName(), element.getName(), element.getName());
        }
        this._elevWriter.println(string);
    }

    private int updateElevEst(IterationBlock iterationBlock, RunTimeStep object, int n, List<Element> list, int n2) {
        int n3 = list.size();
        double d = n2 > 5 && n2 < 25 ? 1.0 - (double)(n2 - 5) * 0.005 : 0.9;
        String string = Integer.toString(((RunTimeStep)object).step);
        int n4 = ((RunTimeStep)object).step;
        int n5 = ((RunTimeStep)object).step + n;
        if (n5 > object.getTotalNumSteps() + 1) {
            n5 = object.getTotalNumSteps() + 1;
        }
        for (n = ((RunTimeStep)object).step; n < n5; ++n) {
            if (this._elevWriter != null) {
                string = String.format("%d\t%d\t%d", n4, n2, n);
            }
            for (int i = 0; i < n3; ++i) {
                object = list.get(i);
                if (!(object instanceof ReservoirElement)) continue;
                object = ((ReservoirElement)object).getStorageFunction();
                if (this._elevWriter != null) {
                    string = String.format("%s\t%.3f\t%.3f\t%.3f\t%.3f", string, ((Storage)object).b.array[n], ((Storage)object).d.array[n], ((Storage)object).c.array[n], ((Storage)object).e.array[n]);
                }
                boolean cfr_ignored_0 = this.ae[i];
                ((Storage)object).updateElevEst(n, d);
            }
            if (this._elevWriter == null) continue;
            this._elevWriter.println(string);
        }
        return 0;
    }

    public int simulatePumpbackStep32(RunTimeStep runTimeStep, List list, int n) {
        if (list != null && n > 0) {
            ReservoirElement reservoirElement;
            int n2 = list.size();
            for (n = 0; n < n2; ++n) {
                reservoirElement = (ReservoirElement)list.get(n);
                reservoirElement.initPumpbackStep(runTimeStep);
            }
            for (n = 0; n < n2; ++n) {
                reservoirElement = (ReservoirElement)list.get(n);
                reservoirElement.computePumpbackStep(runTimeStep);
            }
        }
        return 0;
    }

    private int evalSystemRuleStack(IterationBlock object, RunTimeStep runTimeStep, List<OpRule> list, List list2, List object2, boolean bl, int n, List<Element> list3, double[] dArray, List<OpRule>[] listArray) {
        int n2;
        int n3 = ((IterationBlock)object).c();
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.G) {
                this.printMessage("Compute Canceled");
                return 50;
            }
            object2 = ((IterationBlock)object).d(n2);
            if (!(object2 instanceof ReservoirElement)) continue;
            ((ReservoirElement)object2).getStorageFunction().computeInflow(runTimeStep);
        }
        object = this.buildSysRuleStack(runTimeStep, list3, dArray, listArray);
        this.applyReleaseOverrides(runTimeStep, list3);
        this.applyElevationOverrides(runTimeStep, list3);
        n3 = object.size();
        for (n2 = 0; n2 < n3; ++n2) {
            this.applyRule(runTimeStep, n2, (List)object, n);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.balanceSysRule(runTimeStep, n2, (List)object, n);
        }
        if (bl) {
            this.applyTandemRules(runTimeStep, list3, listArray, n);
        }
        this.applyGCOperation(runTimeStep, list3);
        return 0;
    }

    public List<OpRule> buildSysRuleStack(RunTimeStep object, List<Element> list, double[] dArray, List<OpRule>[] listArray) {
        int n;
        ArrayList<OpRule> arrayList = new ArrayList<OpRule>();
        int n2 = list.size();
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            Element element = list.get(n);
            if (element instanceof ReservoirElement) {
                StorageZone storageZone = null;
                if (this.ah != null) {
                    Integer n3 = (int)this.ah.get(element);
                    storageZone = this.ag[n3][((RunTimeStep)object).step];
                }
                listArray[n] = ((ReservoirElement)element).getReservoirOp(false).getActiveRules((RunTimeStep)object, dArray[n], storageZone, null);
            } else {
                listArray[n] = null;
            }
            nArray[n] = 0;
        }
        for (n = 0; n < n2; ++n) {
            if (listArray[n] == null) continue;
            int n4 = listArray[n].size();
            for (int i = nArray[n]; i < n4; ++i) {
                object = listArray[n].get(i);
                if (object instanceof TandemOpRule) {
                    nArray[n] = i + 1;
                    continue;
                }
                if (((OpRule)object).isLocalRule()) {
                    arrayList.add((OpRule)object);
                    nArray[n] = i + 1;
                    continue;
                }
                nArray[n] = i + 1;
                this.addRulesAbvSysRule((OpRule)object, n, i, arrayList, listArray, nArray);
                if (object instanceof DownstreamCntrlOpRule) {
                    object = ((DownstreamCntrlOpRule)object).getParentRule();
                } else if (object instanceof SystemHydropowerOpRule) {
                    object = ((SystemHydropowerOpRule)object).getParentRule();
                }
                if (arrayList.contains(object)) continue;
                arrayList.add((OpRule)object);
            }
        }
        return arrayList;
    }

    public void initZBruleArray(IterationBlock object, RunTimeWindow runTimeWindow) {
        int n = 0;
        object = ((IterationBlock)object).m();
        this.ah = new HashMap<ReservoirElement, Integer>();
        for (int i = 0; i < object.size(); ++i) {
            Element element = (Element)object.get(i);
            if (!(element instanceof ReservoirElement)) continue;
            this.ah.put((ReservoirElement)element, n);
            ++n;
        }
        this.ag = new StorageZone[n][runTimeWindow.getNumSteps() + 1];
    }

    private void addRulesAbvSysRule(OpRule opRule, int n, int n2, List list, List<OpRule>[] listArray, int[] nArray) {
        int n3 = listArray.length;
        block0: for (n2 = 0; n2 < n3; ++n2) {
            OpRule opRule2;
            int n4;
            if (listArray[n2] == null || n2 == n) continue;
            int n5 = listArray[n2].size();
            int n6 = -1;
            for (n4 = nArray[n2]; n4 < n5; ++n4) {
                OpRule opRule3;
                opRule2 = listArray[n2].get(n4);
                if (opRule instanceof DownstreamCntrlOpRule && opRule2 instanceof DownstreamCntrlOpRule) {
                    opRule3 = ((DownstreamCntrlOpRule)opRule).getParentRule();
                    if (opRule3 != (opRule2 = ((DownstreamCntrlOpRule)opRule2).getParentRule())) continue;
                    n6 = n4;
                    break;
                }
                if (opRule instanceof SystemHydropowerOpRule && opRule2 instanceof SystemHydropowerOpRule) {
                    opRule3 = ((SystemHydropowerOpRule)opRule).getParentRule();
                    if (opRule3 != (opRule2 = ((SystemHydropowerOpRule)opRule2).getParentRule())) continue;
                    n6 = n4;
                    break;
                }
                if (!(opRule instanceof TandemOpRule) || !(opRule2 instanceof TandemOpRule)) continue;
                n6 = n4;
                break;
            }
            for (n4 = nArray[n2]; n4 < n5; ++n4) {
                opRule2 = listArray[n2].get(n4);
                if (opRule2 instanceof TandemOpRule) {
                    nArray[n2] = n4 + 1;
                    continue;
                }
                if (opRule2.isLocalRule()) {
                    list.add(opRule2);
                    nArray[n2] = n4 + 1;
                    continue;
                }
                if (n6 < n4) continue block0;
                if (n6 == n4) {
                    nArray[n2] = n4 + 1;
                    continue block0;
                }
                nArray[n] = n4 + 1;
                this.addRulesAbvSysRule(opRule2, n2, n4, list, listArray, nArray);
                if (opRule2 instanceof DownstreamCntrlOpRule) {
                    list.add(((DownstreamCntrlOpRule)opRule2).getParentRule());
                    continue;
                }
                if (!(opRule2 instanceof SystemHydropowerOpRule)) continue;
                list.add(((SystemHydropowerOpRule)opRule2).getParentRule());
            }
        }
    }

    private void initControllerOperation(RunTimeStep runTimeStep, List<Element> list, int n) {
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Element element = list.get(i);
            if (!(element instanceof ReservoirElement)) continue;
            ((ReservoirElement)element).getReservoirOp().initOperationStep(runTimeStep, n);
        }
    }

    private void applyControllerPhysLimits(RunTimeStep runTimeStep, List<Element> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Element element = list.get(i);
            if (!(element instanceof ReservoirElement)) continue;
            ((ReservoirElement)element).getReservoirOp().applyPhysicalLimits32(runTimeStep);
        }
    }

    private void applyReleaseOverrides(RunTimeStep runTimeStep, List<Element> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Element element = list.get(i);
            if (!(element instanceof ReservoirElement)) continue;
            ((ReservoirElement)element).getReservoirOp().applyReleaseOverrides(runTimeStep);
        }
    }

    private void applyElevationOverrides(RunTimeStep runTimeStep, List<Element> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Element element = list.get(i);
            if (!(element instanceof ReservoirElement)) continue;
            ((ReservoirElement)element).getReservoirOp().applyElevationOverrides(runTimeStep);
        }
    }

    private void applyRule(RunTimeStep runTimeStep, int n, List object, int n2) {
        Object object2 = object.get(n);
        if (object2 instanceof DownstreamCntrlOpRule) {
            object2 = (DownstreamCntrlOpRule)object2;
            object = ((DownstreamCntrlOpRule)object2).getParentRule();
            ((DownstreamOpRule)object).evaluateSysLimits(runTimeStep, n2);
            ((DownstreamOpRule)object).evaluateSysBalance(runTimeStep, n2);
            object2 = ((DownstreamOpRule)object).getChildRuleList();
            int n3 = object2.size();
            for (int i = 0; i < n3; ++i) {
                DownstreamCntrlOpRule downstreamCntrlOpRule = (DownstreamCntrlOpRule)object2.get(i);
                ReservoirOp reservoirOp = (ReservoirOp)downstreamCntrlOpRule.getController().getElementOp();
                reservoirOp.applyRuleLimits2(runTimeStep, downstreamCntrlOpRule, n2);
            }
            return;
        }
        if (object2 instanceof SystemHydropowerOpRule) {
            object2 = (SystemHydropowerOpRule)object2;
            object = ((SystemHydropowerOpRule)object2).getParentRule();
            ((OpRule)object).initOperationStep(runTimeStep, n2);
            ((SystemHydropowerRule)object).evaluateSysLimits(runTimeStep, n2);
            return;
        }
        if (object2 instanceof OpRule) {
            object2 = (OpRule)object2;
            ((OpRule)object2).evaluateLimits(runTimeStep, n2);
            object = (ReservoirOp)((OpRule)object2).getController().getElementOp();
            ((ReservoirOp)object).applyRuleLimits2(runTimeStep, (OpRule)object2, n2);
        }
    }

    private void balanceSysRule(RunTimeStep runTimeStep, int n, List list, int n2) {
        if (!(list.get(n) instanceof DownstreamCntrlOpRule) && list.get(n) instanceof SystemHydropowerOpRule) {
            SystemHydropowerOpRule[] systemHydropowerOpRuleArray = (SystemHydropowerOpRule)list.get(n);
            systemHydropowerOpRuleArray = systemHydropowerOpRuleArray.getParentRule();
            for (SystemHydropowerOpRule systemHydropowerOpRule : systemHydropowerOpRuleArray.getChildList()) {
                ReservoirOp reservoirOp = (ReservoirOp)systemHydropowerOpRule.getController().getElementOp();
                reservoirOp.applyRuleLimits2(runTimeStep, systemHydropowerOpRule, n2);
            }
        }
    }

    private void applyTandemRules(RunTimeStep runTimeStep, List<Element> list, List<OpRule>[] listArray, int n) {
        this.H.a(runTimeStep);
        this.H.a(runTimeStep, n);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            if (listArray[i] == null) continue;
            int n3 = listArray[i].size();
            for (int j = 0; j < n3; ++j) {
                OpRule opRule = listArray[i].get(j);
                if (!(opRule instanceof TandemOpRule)) continue;
                ReservoirOp reservoirOp = (ReservoirOp)opRule.getController().getElementOp();
                reservoirOp.applyRuleLimits2(runTimeStep, opRule, n);
            }
        }
    }

    private void applyGCOperation(RunTimeStep runTimeStep, List<Element> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Element element = list.get(i);
            if (!(element instanceof ReservoirElement)) continue;
            ((ReservoirElement)element).getReservoirOp().applyGCOperation(runTimeStep, null);
        }
    }

    public List<IterationBlock> getIterationBlockList() {
        return this.t;
    }

    public boolean globalVariableExists(int n, GlobalVariableType globalVariableType) {
        return this.getGlobalVariables(globalVariableType).stream().filter(globalVariable -> globalVariable.getIndex() == n).findFirst().isPresent();
    }

    static {
        d = false;
    }
}

