/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.HecTime;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.SeasonalRecord;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.DaysOfWeek;
import hec.rss.model.DemandRuleInf;
import hec.rss.model.Function;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import hec.rss.model.PowerGenerationOptions;
import hec.rss.model.PowerGenerationPatternContainer;
import hec.rss.model.PowerPlant;
import hec.rss.model.ReservoirOp;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Storage;
import hec.rss.model.WaterAccount;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;
import rma.util.RMAConst;

public class ScheduledHydropowerOpRule
extends OpRule
implements AsciiSerializable,
DemandRuleInf,
PowerGenerationOptions,
Serializable,
Cloneable {
    public static final int UNDEFINED = -1;
    private transient doubleArrayContainer f;
    private transient doubleArrayContainer i;
    private transient doubleArrayContainer j;
    private transient doubleArrayContainer k;
    private transient doubleArrayContainer l;
    transient doubleArrayContainer a;
    private transient doubleArrayContainer m;
    transient doubleArrayContainer b;
    private transient doubleArrayContainer n;
    private transient doubleArrayContainer o;
    private transient double p = 0.0;
    private transient int q = -1;
    transient doubleArrayContainer[] c;
    transient doubleArrayContainer[] d;
    private transient WaterAccount r;
    protected boolean m_independantPowerReq = false;
    protected boolean m_usePlantFactor = true;
    protected boolean m_systemPwrGenSeasonal = false;
    protected PowerGenerationPatternContainer m_patternContainer = new PowerGenerationPatternContainer();
    protected SeasonalRecord _seasonalPowerRequirement = new SeasonalRecord();
    protected int m_powerReqVariation = 0;
    protected int m_powerReqSpecifiedAs = 13;
    protected int m_startingDay = 0;
    protected int m_dayBelongsToTerm = 0;
    protected int m_startDayOfPeriod = 0;
    protected int m_generationPeriod = 0;
    protected transient List<PowerPlant> e = null;
    private static int[] s = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public ScheduledHydropowerOpRule() {
    }

    public ScheduledHydropowerOpRule(String string) {
        super(string);
    }

    @Override
    public TSRecordProxy getTargetTSRecordProxy() {
        return this.getTSRecordProxy(53);
    }

    @Override
    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
        double d;
        double d2;
        this.getUnitSystem();
        n = runTimeStep.step - 1;
        if (n < 0) {
            n = 0;
        }
        this._controller.getElementOp().getOperationsElement().getStorageFunction();
        double d3 = this.j.array[n];
        double cfr_ignored_0 = (double)runTimeStep.getTimeStepSeconds() / 3600.0;
        int n2 = 0;
        for (PowerPlant powerPlant : this.e) {
            d2 = powerPlant.getTailwaterElevation(runTimeStep);
            d3 = powerPlant.getPoolElevation(runTimeStep);
            powerPlant.calculateAvailablePowerCapacity(d3, d2);
            if (RMAConst.isValidValue((double)this.c[n2].array[n])) {
                double cfr_ignored_1 = this.c[n2].array[n];
            }
            ++n2;
        }
        d2 = 0.0;
        double d4 = 0.0;
        double d5 = this.getEnergyReguirement(runTimeStep, d3);
        if (d < 0.0) {
            d5 = 0.0;
        }
        this.l.array[runTimeStep.step] = d5;
        if (!RMAConst.isValidValue((double)d5)) {
            this.k.array[runTimeStep.step] = -3.4028234663852886E38;
            this.h.array[runTimeStep.step] = -3.4028234663852886E38;
            return;
        }
        if (d5 == 0.0) {
            this.k.array[runTimeStep.step] = 0.0;
            this.h.array[runTimeStep.step] = 0.0;
        } else {
            this.k.array[runTimeStep.step] = d2 = d5 / (double)runTimeStep.getTimeStepMinutes() * 60.0;
            this.h.array[runTimeStep.step] = d4 = this._controller.getElementReleaseForPower(runTimeStep, d2);
            if (!RMAConst.isValidValue((double)d4)) {
                this.h.array[runTimeStep.step] = -3.4028234663852886E38;
                return;
            }
        }
        n = ((ReservoirOp)this.getController().getElementOp()).getNumDecisionSteps();
        for (n2 = 0; n2 < n; ++n2) {
            if (runTimeStep.step + n2 >= this.k.array.length) continue;
            this.k.array[runTimeStep.step + n2] = d2;
            this.h.array[runTimeStep.step + n2] = d4;
        }
    }

    @Override
    public OpValue getOpValue(RunTimeStep runTimeStep) {
        if (!RMAConst.isValidValue((double)this.h.array[runTimeStep.step])) {
            return null;
        }
        OpValue opValue = new OpValue();
        new OpValue().value = this.h.array[runTimeStep.step];
        opValue.type = 0;
        return opValue;
    }

    @Override
    public OpValue getPowerOpValue(RunTimeStep runTimeStep) {
        if (!RMAConst.isValidValue((double)this.k.array[runTimeStep.step])) {
            return null;
        }
        OpValue opValue = new OpValue();
        new OpValue().value = this.k.array[runTimeStep.step];
        opValue.type = 0;
        return opValue;
    }

    @Override
    public void evaulatePerformance(RunTimeWindow runTimeWindow) {
        int n;
        ((RssTSLocationObject)this).getSystem();
        RunTimeWindow runTimeWindow2 = runTimeWindow;
        RunTimeStep runTimeStep = runTimeWindow2.getRunTimeStepAtTime(runTimeWindow2.getLookbackTime());
        int n2 = runTimeStep.getTimeStepSeconds();
        runTimeStep.rtw.getNumSteps();
        HecTime hecTime = runTimeStep.getHecTime();
        int n3 = hecTime.secondsSinceMidnight();
        if (n3 == 0) {
            n3 = 86400;
        }
        if (this.m_generationPeriod == 0) {
            n = 1;
            n2 = 0;
        } else if (this.m_generationPeriod == 1) {
            n = 86400 / n2;
            n2 = n3 / n2 - 1;
        } else {
            n = 604800 / n2;
            int n4 = RunTimeStep.getDayOfWeek((HecTime)hecTime);
            int n5 = n4 - this.m_startDayOfPeriod;
            if (n5 < 0) {
                n5 += 7;
            }
            n2 = n3 / n2 - 1 + n5 * 86400 / n2;
        }
        double d = 0.0;
        int n6 = runTimeWindow.getNumSteps();
        for (int i = 0; i <= n6; ++i) {
            runTimeStep.step = i;
            if (n2 == 0) {
                d = 0.0;
            }
            double d2 = 0.0;
            for (n3 = 0; n3 < this.e.size(); ++n3) {
                d += this.d[n3].array[i];
                d2 += this.d[n3].array[i];
            }
            this.m.array[i] = d;
            this.o.array[i] = d2;
            if (n2 == n - 1) {
                this.n.array[i] = this.m.array[i] - this.l.array[i];
                if (this.n.array[i] > 0.0) {
                    this.n.array[i] = 0.0;
                }
            } else {
                this.n.array[i] = -3.4028234663852886E38;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
    }

    public PowerGenerationPatternContainer getPowerPatternContainer() {
        return this.m_patternContainer;
    }

    @Override
    public void setRequirementVariation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid HydroPower Variation Requirement");
        }
        this.m_powerReqVariation = n;
    }

    @Override
    public int getRequirementVariation() {
        return this.m_powerReqVariation;
    }

    @Override
    public void setStartingDay(int n) {
        if (!DaysOfWeek.d(n)) {
            throw new IllegalArgumentException("Invalid Day being set in SystemHydropowerOpRule.setStartingDay()");
        }
        this.m_startingDay = n;
    }

    @Override
    public int getStartingDay() {
        return this.m_startingDay;
    }

    @Override
    public int getDayBelongsToTerm() {
        return this.m_dayBelongsToTerm;
    }

    @Override
    public void setDayBelongsToTerm(int n) {
        if (!DaysOfWeek.d(n)) {
            throw new IllegalArgumentException("Invalid Day being set in SystemHydropowerOpRule.setDayBelongsToTerm()");
        }
        this.m_dayBelongsToTerm = n;
    }

    @Override
    public int getStartDayOfPeriod() {
        return this.m_startDayOfPeriod;
    }

    @Override
    public void setStartDayOfPeriod(int n) {
        if (!DaysOfWeek.d(n)) {
            throw new IllegalArgumentException("Invalid Day being set in SystemHydropowerOpRule.setStartDayOfPeriod()");
        }
        this.m_startDayOfPeriod = n;
    }

    @Override
    public void setGenerationPeriod(int n) {
        if (n != 1 && n != 0 && n != 2) {
            throw new IllegalArgumentException("Invalid geration period in SystemHydropowerOprRule.setGenerationPeriod()");
        }
        this.m_generationPeriod = n;
    }

    @Override
    public void setPowerReqSpecification(int n) {
        if (n != 10 && n != 11 && n != 12 && n != 13 && n != 14) {
            throw new IllegalArgumentException("Invalid Power Requirement Specification in SystemHydropowerOpRule.setPowerReqSpecifaction()");
        }
        this.m_powerReqSpecifiedAs = n;
    }

    @Override
    public int getPowerReqSpecification() {
        return this.m_powerReqSpecifiedAs;
    }

    @Override
    public int getGenerationPeriod() {
        return this.m_generationPeriod;
    }

    @Override
    public boolean initializeCompute() {
        RssSystem rssSystem = this._controller.getElementOp().getOperationsElement().getSystem();
        this.j = null;
        this.i = null;
        this.f = null;
        this.k = null;
        this.l = null;
        this.a = null;
        this.m = null;
        this.b = null;
        this.n = null;
        this.o = null;
        if (!super.initializeCompute()) {
            return false;
        }
        Storage storage = this._controller.getElementOp().getOperationsElement().getStorageFunction();
        this.j = storage.getTSContainer(10);
        this.i = storage.getTSContainer(13);
        this.f = this._controller.getReleaseTSContainer();
        this.e = this._controller.getPowerPlantList(false);
        this.k = this.getTSContainer(58);
        this.l = this.getTSContainer(59);
        this.a = this.getTSContainer(157);
        this.m = this.getTSContainer(156);
        this.b = this.getTSContainer(155);
        this.n = this.getTSContainer(159);
        this.o = this.getTSContainer(53);
        if (this.e == null || this.e.isEmpty()) {
            RssSystem rssSystem2 = rssSystem;
            rssSystem2.printErrorMessage("ScheduledHydropowerOpRule.initializeCompute: There is no Power Plant associated with " + rssSystem2.getNameForKeyString(this._controller.getName()));
            return false;
        }
        this.c = new doubleArrayContainer[this.e.size()];
        this.d = new doubleArrayContainer[this.e.size()];
        int n = 0;
        for (PowerPlant powerPlant : this.e) {
            if (powerPlant.getAssociatedTailwater() == null) {
                RssSystem rssSystem3 = rssSystem;
                rssSystem3.printErrorMessage("ScheduledHydropowerOpRule.initializeCompute: There is no Tailwater associated with the Power Plant for " + rssSystem3.getNameForKeyString(this._controller.getName()));
                return false;
            }
            this.c[n] = powerPlant.getAdjustableFlow().getTSContainer(54);
            this.d[n] = powerPlant.getAdjustableFlow().getTSContainer(53);
            ++n;
        }
        return true;
    }

    @Override
    public OpValue evaluateRule(RunTimeStep runTimeStep, double d) {
        ((OpRule)this).evaluateLimits(runTimeStep, 0);
        return ((OpRule)this).getOpValue(runTimeStep);
    }

    protected double getEnergyReguirement(RunTimeStep runTimeStep, double d) {
        return 0.0;
    }

    protected List<PowerPlant> getPowerPlantList() {
        if (this._controller == null) {
            return null;
        }
        return this._controller.getPowerPlantList(false);
    }

    protected AdjustableFlow getAdjustableFlow() {
        Function function = this._controller.getReleaseElement().getFunction();
        if (function instanceof AdjustableFlow) {
            function = (AdjustableFlow)function;
            return function;
        }
        return null;
    }

    public double getMonthlyEnergyCapacity(int n) {
        if (n < 0 || n > 11) {
            return Double.NEGATIVE_INFINITY;
        }
        n = s[n];
        Object object = this.getPowerPlantList();
        double d = 0.0;
        object = object.iterator();
        while (object.hasNext()) {
            PowerPlant powerPlant = (PowerPlant)object.next();
            if (powerPlant != null && RMAConst.isValidValue((double)powerPlant.getCapacity())) continue;
            d += powerPlant.getCapacity();
        }
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return (double)n * 24.0 * d;
    }

    @Override
    public Object clone() {
        ScheduledHydropowerOpRule scheduledHydropowerOpRule = (ScheduledHydropowerOpRule)super.clone();
        return scheduledHydropowerOpRule;
    }

    protected static int a(HecTime hecTime) {
        int n = hecTime.month();
        int n2 = hecTime.year();
        if (--n == 1 && n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0)) {
            return 29;
        }
        return s[n];
    }

    @Override
    public int getRuleLimitType() {
        return 0;
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        vector = super.getActiveTSRecordProxies(vector, n);
        if (n == 0) {
            TSRecordProxy tSRecordProxy = this.getTSRecordProxy(58);
            if (tSRecordProxy != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(59)) != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(155)) != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(156)) != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(157)) != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(159)) != null) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(53)) != null) {
                vector.addElement(tSRecordProxy);
            }
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        super.updateTSProxyList();
        String string = this.getTSProxyName();
        if (this.getTSRecordProxy(string, 58) == null) {
            this.addTSRecordProxy(string, 58);
        }
        if (this.getTSRecordProxy(string, 155) == null) {
            this.addTSRecordProxy(string, 155);
        }
        if (this.getTSRecordProxy(string, 156) == null) {
            this.addTSRecordProxy(string, 156);
        }
        if (this.getTSRecordProxy(string, 157) == null) {
            this.addTSRecordProxy(string, 157);
        }
        if (this.getTSRecordProxy(string, 59) == null) {
            this.addTSRecordProxy(string, 59);
        }
        if (this.getTSRecordProxy(string, 159) == null) {
            this.addTSRecordProxy(string, 159);
        }
        if (this.getTSRecordProxy(string, 53) == null) {
            this.addTSRecordProxy(string, 53);
        }
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        super.outputReport(alternativeInputReport, element);
        element.setAttribute("Rule", "HydropowerScheduledHydropower");
        element.setAttribute("PowerVaries", Integer.toString(this.m_powerReqVariation));
        element.setAttribute("SpecifiedAs", Integer.toString(this.m_powerReqSpecifiedAs));
        element.setAttribute("StartingDay", Integer.toString(this.m_startingDay));
        element.setAttribute("DayBelongsToTerm", Integer.toString(this.m_dayBelongsToTerm));
        element.setAttribute("DayofPeriod", Integer.toString(this.m_generationPeriod));
        element.setAttribute("StartDayofPeriod", Integer.toString(this.m_startDayOfPeriod));
        Element element2 = new Element("Seasonal_Times");
        element.addContent((Content)element2);
        XMLUtilities.createArrayElements((Element)element2, (int[])this._seasonalPowerRequirement.getTimeArray());
        element2 = new Element("Seasonal_Data");
        element.addContent((Content)element2);
        XMLUtilities.createArrayElements((Element)element2, (double[])this._seasonalPowerRequirement.getDataArray());
        element2 = new Element("PowerGenerationPattern");
        element.addContent((Content)element2);
        this.getPowerPatternContainer().outputReport(alternativeInputReport, element2);
    }

    @Override
    public WaterAccount getWaterAccount() {
        return this.r;
    }

    @Override
    public void setWaterAccount(WaterAccount waterAccount) {
        this.r = waterAccount;
    }

    @Override
    boolean isPowerRule() {
        return true;
    }
}

